/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.odp.structure.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.structure.StructureConvert;
import org.oiue.service.odp.structure.StructureService;
import org.oiue.service.odp.structure.StructureServiceManager;
import org.oiue.service.system.analyzer.AnalyzerService;
import org.oiue.service.system.analyzer.TimeLogger;
import org.oiue.tools.map.MapUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class StructureServiceManagerImpl
implements Serializable,
StructureServiceManager,
ManagedService {
    private Map<String, StructureService> default_strucures = new HashMap<String, StructureService>();
    private Map<String, Map<String, StructureService>> strucures = new HashMap<String, Map<String, StructureService>>();
    private Logger logger;
    private TimeLogger timeLogger;

    public StructureServiceManagerImpl(LogService logService, AnalyzerService analyzerService) {
        this.logger = logService.getLogger(this.getClass());
        this.timeLogger = analyzerService.getLogger(this.getClass());
    }

    public boolean registerStructure(String DBType, String type, StructureService structure) {
        if (DBType == null) {
            if (this.default_strucures.containsKey(type)) {
                throw new RuntimeException("Duplicate registration![" + DBType + "," + structure.getClass().getSimpleName() + "]");
            }
            this.default_strucures.put(type, structure);
        } else {
            Map<String, StructureService> strucurem = this.strucures.get(DBType);
            if (strucurem == null) {
                strucurem = new HashMap<String, StructureService>();
                this.strucures.put(DBType, strucurem);
            }
            if (strucurem.containsKey(type)) {
                throw new RuntimeException("Duplicate registration![" + DBType + "," + structure.getClass().getSimpleName() + "]");
            }
            strucurem.put(type, structure);
        }
        return true;
    }

    public List<Map<?, ?>> parse(Map<?, ?> event, Map<String, Object> parameter) {
        ArrayList rtnList = new ArrayList();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("event:" + event + ",parameter:" + parameter, new Object[0]);
        }
        String content = MapUtil.getString(event, (String)"CONTENT");
        String expression = MapUtil.getString(event, (String)"EXPRESSION");
        String event_type = MapUtil.getString(event, (String)"EVENT_TYPE");
        ArrayList<Object> per = new ArrayList<Object>();
        if (expression != null) {
            String[] expressions;
            for (String ep : expressions = expression.split(",")) {
                if (ep != null) {
                    ep = ep.trim();
                }
                per.add(MapUtil.get(parameter, (String)ep));
            }
        }
        HashMap rtn = new HashMap();
        rtnList.add(rtn);
        return rtnList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updated(Dictionary props) throws ConfigurationException {
        try {
            if (props == null) return;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public StructureService getStructureService(String type) {
        return this.default_strucures.get(type);
    }

    public StructureService getStructureService(String DBType, String type) {
        return DBType == null ? this.getStructureService(type) : this.strucures.get(DBType).get(type);
    }

    public boolean registerStructureConvert(String DBType, String type, StructureConvert structure) {
        return false;
    }

    public StructureConvert getStructureConvert(String DBType, String type) {
        return null;
    }
}

