/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.auth.impl;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.oiue.service.auth.AuthService;
import org.oiue.service.auth.AuthServiceManager;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.online.Online;
import org.oiue.tools.string.StringUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class AuthServiceManagerImpl
implements AuthServiceManager,
ManagedService,
Serializable {
    private Logger logger;
    private String login_type = "type";
    private Map<String, AuthService> auths = new HashMap<String, AuthService>();

    public AuthServiceManagerImpl(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
    }

    public Online login(Map per) {
        String type = (String)per.remove(this.login_type);
        if (StringUtil.isEmptys((String)type)) {
            String msg = "the key[" + this.login_type + "] con't null or empty!";
            this.logger.error(msg + ":" + per, new Object[0]);
            throw new RuntimeException(msg);
        }
        AuthService auth = this.auths.get(type);
        if (auth == null) {
            String msg = "AuthService the key[" + type + "] con't find!";
            this.logger.error(msg + ":" + per, new Object[0]);
            throw new RuntimeException(msg);
        }
        return auth.login(per);
    }

    public boolean logout(Map per) {
        AuthService auth;
        String type = (String)per.remove(this.login_type);
        if (!StringUtil.isEmptys((String)type) && (auth = this.auths.get(type)) != null) {
            auth.logout(per);
        }
        return true;
    }

    public boolean registerAuthService(String name, AuthService auth) {
        if (this.auths.containsKey(name)) {
            return false;
        }
        this.auths.put(name, auth);
        return true;
    }

    public boolean unRegisterAuthService(String name) {
        if (this.auths.containsKey(name)) {
            this.auths.remove(name);
            return true;
        }
        return false;
    }

    public void updated(Dictionary<String, ?> props) throws ConfigurationException {
        String login_type = props.get("loginType") + "";
        if (!StringUtil.isEmptys((String)login_type)) {
            this.login_type = login_type;
        }
    }

    public void unregister() {
    }
}

