/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.buffer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.oiue.tools.json.JSONUtil;

public class KeyToMany
implements Serializable {
    private Map<Object, Set<Object>> hashMap = new ConcurrentHashMap<Object, Set<Object>>();

    public Map<Object, Set<Object>> getHashMap() {
        return this.hashMap;
    }

    public void put(Object key, Object value) {
        Set<Object> hashSet = this.hashMap.get(key);
        if (hashSet == null) {
            hashSet = new CopyOnWriteArraySet<Object>();
            this.hashMap.put(key, hashSet);
        }
        hashSet.add(value);
    }

    public void remove(Object key) {
        this.hashMap.remove(key);
    }

    public void remove(Set<Object> matchSet) {
        for (Object key : matchSet) {
            this.hashMap.remove(key);
        }
    }

    public void remove(Object key, Object value) {
        Set<Object> hashSet = this.hashMap.get(key);
        if (hashSet != null) {
            hashSet.remove(value);
            if (hashSet.isEmpty()) {
                this.hashMap.remove(key);
            }
        }
    }

    public void remove(Object key, Set<Object> matchSet) {
        Set<Object> hashSet = this.hashMap.get(key);
        if (!hashSet.equals(matchSet) && hashSet != null) {
            for (Object e : matchSet) {
                hashSet.remove(e);
            }
            if (hashSet.isEmpty()) {
                this.hashMap.remove(key);
            }
        }
    }

    public Set<Object> get(Object key) {
        return this.hashMap.get(key);
    }

    public List<Object> get(Set<Object> matchSet) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : matchSet) {
            Set<Object> hashSet = this.hashMap.get(object);
            if (hashSet == null) continue;
            list.addAll(hashSet);
        }
        return list;
    }

    public List<Object> find(Object key, Object like) {
        ArrayList<Object> list = new ArrayList<Object>();
        Set<Object> hashSet = this.hashMap.get(key);
        if (hashSet != null) {
            for (Object object : hashSet) {
                if (object.toString().indexOf(like.toString()) < 0) continue;
                list.add(object);
            }
        }
        return list;
    }

    public boolean contains(Object key) {
        return this.hashMap.containsKey(key);
    }

    public boolean contains(Object key, Object value) {
        return this.hashMap.containsKey(key) && this.hashMap.get(key).contains(value);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean first = true;
        stringBuffer.append("{\"t\":\"m\",");
        stringBuffer.append("\"v\":{");
        for (Object obj : this.hashMap.keySet()) {
            if (first) {
                first = false;
            } else {
                stringBuffer.append(",");
            }
            if (obj instanceof String) {
                stringBuffer.append(JSONUtil.getJSONString((String)((String)obj)));
            } else {
                stringBuffer.append(obj);
            }
            stringBuffer.append(":[");
            boolean firstv = true;
            for (Object objv : this.hashMap.get(obj)) {
                if (firstv) {
                    firstv = false;
                } else {
                    stringBuffer.append(",");
                }
                if (objv instanceof String) {
                    stringBuffer.append(JSONUtil.getJSONString((String)((String)objv)));
                    continue;
                }
                if (objv instanceof Map) {
                    stringBuffer.append(JSONUtil.parserToStr((Map)((Map)objv)));
                    continue;
                }
                if (objv instanceof List) {
                    stringBuffer.append(JSONUtil.parserToStr((List)((List)objv)));
                    continue;
                }
                stringBuffer.append(objv);
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }
}

