/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.buffer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.oiue.service.buffer.KeyToTreeNode;
import org.oiue.tools.json.JSONUtil;

public class KeyToTree
implements Serializable {
    private Map<Object, KeyToTreeNode> hashMap = new ConcurrentHashMap<Object, KeyToTreeNode>();

    public Map<Object, KeyToTreeNode> getHashMap() {
        return this.hashMap;
    }

    public void put(Object key, Object parent, Object value) {
        KeyToTreeNode node;
        List<Object> list = this.getKey(key);
        if (list != null && list.contains(parent)) {
            System.out.println("error " + value);
            return;
        }
        KeyToTreeNode nodeParent = this.hashMap.get(parent);
        if (nodeParent == null) {
            nodeParent = new KeyToTreeNode();
            nodeParent.setKey(key);
            nodeParent.setParent("");
            nodeParent.setValue(value);
            this.hashMap.put(parent, nodeParent);
        }
        if ((node = this.hashMap.get(key)) != null) {
            this.remove(key);
        } else {
            node = new KeyToTreeNode();
            this.hashMap.put(key, node);
        }
        node.setKey(key);
        node.setParent(parent);
        node.setValue(value);
        for (KeyToTreeNode e : this.hashMap.values()) {
            if (e.getKey().equals(parent)) {
                e.children.add(node);
                return;
            }
            if (!e.getParent().equals(key)) continue;
            node.children.add(e);
            return;
        }
    }

    private void appendChildren(KeyToTreeNode node, List<Object> list) {
        for (KeyToTreeNode e : node.children) {
            list.add(e.getValue());
        }
        for (KeyToTreeNode e : node.children) {
            this.appendChildren(e, list);
        }
    }

    public List<Object> get(Object key) {
        ArrayList<Object> list = new ArrayList<Object>();
        KeyToTreeNode node = this.hashMap.get(key);
        if (node != null) {
            list.add(node);
            this.appendChildren(node, list);
        }
        return list;
    }

    private void appendChildrenNode(KeyToTreeNode node, List<KeyToTreeNode> list) {
        for (KeyToTreeNode e : node.children) {
            list.add(e);
        }
        for (KeyToTreeNode e : node.children) {
            this.appendChildrenNode(e, list);
        }
    }

    private List<KeyToTreeNode> getNode(Object key) {
        ArrayList<KeyToTreeNode> list = new ArrayList<KeyToTreeNode>();
        KeyToTreeNode node = this.hashMap.get(key);
        if (node != null) {
            list.add(node);
            this.appendChildrenNode(node, list);
        }
        return list;
    }

    private void appendChildrenKey(KeyToTreeNode node, List<Object> list) {
        for (KeyToTreeNode e : node.children) {
            list.add(e.getKey());
        }
        for (KeyToTreeNode e : node.children) {
            this.appendChildrenKey(e, list);
        }
    }

    private List<Object> getKey(Object key) {
        ArrayList<Object> list = new ArrayList<Object>();
        KeyToTreeNode node = this.hashMap.get(key);
        if (node != null) {
            list.add(node.getKey());
            this.appendChildrenKey(node, list);
        }
        return list;
    }

    public List<Object> get(Set<Object> matchSet) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object key : matchSet) {
            KeyToTreeNode node = this.hashMap.get(key);
            if (node == null) continue;
            list.add(node);
            this.appendChildren(node, list);
        }
        return list;
    }

    public void remove(Object key) {
        List<KeyToTreeNode> list = this.getNode(key);
        for (KeyToTreeNode e : list) {
            this.hashMap.remove(e.getKey());
        }
        this.hashMap.remove(key);
    }

    public void remove(Set<Object> matchSet) {
        for (Object key : matchSet) {
            this.remove(key);
        }
    }

    public boolean contains(Object key) {
        return this.hashMap.containsKey(key);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean first = true;
        stringBuffer.append("{\"t\":\"t\",");
        stringBuffer.append("\"v\":{");
        for (Object obj : this.hashMap.keySet()) {
            if (first) {
                first = false;
            } else {
                stringBuffer.append(",");
            }
            if (obj instanceof String) {
                stringBuffer.append(JSONUtil.getJSONString((String)((String)obj)));
            } else {
                stringBuffer.append(obj);
            }
            stringBuffer.append(":");
            KeyToTreeNode node = this.hashMap.get(obj);
            stringBuffer.append(node.getValue());
        }
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }

    public static void main(String[] args) {
        KeyToTree keyToTree = new KeyToTree();
        keyToTree.put(2, 3, "{k:2,p:3,new}");
        keyToTree.put(3, 2, "{k:3,p:2}");
        keyToTree.put(0, -1, "{k:0,p:-1}");
        keyToTree.put(1, 0, "{k:1,p:0}");
        keyToTree.put(2, 1, "{k:2,p:1}");
        System.out.println("all = " + keyToTree);
        System.out.println("1 = " + JSONUtil.getJSONString(keyToTree.get(1)));
        keyToTree.put(2, 3, "{k:2,p:3,new}");
        System.out.println("all = " + keyToTree);
        System.out.println("2 = " + JSONUtil.getJSONString(keyToTree.get(2)));
        keyToTree.put(3, 2, "{k:3,p:2}");
        System.out.println("all = " + keyToTree);
        System.out.println("1 = " + JSONUtil.getJSONString(keyToTree.get(1)));
        keyToTree.put(4, 3, "{k:4,p:3}");
        keyToTree.put(3, 1, "{k:3,p:1}");
        System.out.println("all = " + keyToTree);
        System.out.println("1 = " + JSONUtil.getJSONString(keyToTree.get(1)));
    }
}

