/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.cache.impl;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.oiue.service.cache.CacheService;
import org.oiue.service.cache.CacheServiceManager;
import org.oiue.service.cache.Type;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.tools.string.StringUtil;

public class CacheServiceManagerImpl
implements CacheServiceManager,
Serializable {
    private Logger logger;
    private String cache_type = "cacheType";
    private String cache_default = "buffer";
    private Map<String, CacheService> caches = new HashMap<String, CacheService>();

    public CacheServiceManagerImpl(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
    }

    public void updated(Dictionary<String, ?> props) {
        String cache_default;
        String cache_type = props.get("cacheType") + "";
        if (!StringUtil.isEmptys((String)cache_type)) {
            this.cache_type = cache_type;
        }
        if (!StringUtil.isEmptys((String)(cache_default = props.get("localCache") + ""))) {
            this.cache_default = cache_default;
        }
    }

    public void put(String name, Object object, Type type) {
        Map data = null;
        if (object instanceof Map) {
            CacheService cache;
            data = (Map)object;
            String cacheType = data.remove(this.cache_type) + "";
            if (StringUtil.isEmptys((String)cacheType)) {
                cacheType = this.cache_default;
            }
            if ((cache = this.caches.get(cacheType)) == null) {
                String msg = "the key[" + cacheType + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, object, type);
        } else {
            CacheService cache = this.caches.get(this.cache_default);
            if (cache == null) {
                String msg = "the key[" + this.cache_default + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, object, type);
        }
    }

    public void put(String name, String key, Object object, Type type) {
        Map data = null;
        if (object instanceof Map) {
            CacheService cache;
            data = (Map)object;
            String cacheType = data.remove(this.cache_type) + "";
            if (StringUtil.isEmptys((String)cacheType)) {
                cacheType = this.cache_default;
            }
            if ((cache = this.caches.get(cacheType)) == null) {
                String msg = "the key[" + cacheType + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, key, object, type);
        } else {
            CacheService cache = this.caches.get(this.cache_default);
            if (cache == null) {
                String msg = "the key[" + this.cache_default + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, key, object, type);
        }
    }

    public void put(String name, Object object, Type type, int expire) {
        Map data = null;
        if (object instanceof Map) {
            CacheService cache;
            data = (Map)object;
            String cacheType = data.remove(this.cache_type) + "";
            if (StringUtil.isEmptys((String)cacheType)) {
                cacheType = this.cache_default;
            }
            if ((cache = this.caches.get(cacheType)) == null) {
                String msg = "the key[" + cacheType + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, object, type, expire);
        } else {
            CacheService cache = this.caches.get(this.cache_default);
            if (cache == null) {
                String msg = "the key[" + this.cache_default + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, object, type, expire);
        }
    }

    public void put(String name, String key, Object object, Type type, int expire) {
        Map data = null;
        if (object instanceof Map) {
            CacheService cache;
            data = (Map)object;
            String cacheType = data.remove(this.cache_type) + "";
            if (StringUtil.isEmptys((String)cacheType)) {
                cacheType = this.cache_default;
            }
            if ((cache = this.caches.get(cacheType)) == null) {
                String msg = "the key[" + cacheType + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, key, object, type, expire);
        } else {
            CacheService cache = this.caches.get(this.cache_default);
            if (cache == null) {
                String msg = "the key[" + this.cache_default + "] cache service not find!";
                this.logger.error(msg + ":" + data);
                throw new RuntimeException(msg);
            }
            cache.put(name, key, object, type, expire);
        }
    }

    public Object get(String name) {
        return this.getCacheService().get(name);
    }

    public Object get(String name, String key) {
        return this.getCacheService().get(name, key);
    }

    public long delete(String name) {
        return this.getCacheService().delete(name);
    }

    public long delete(String name, String ... keys) {
        return this.getCacheService().delete(name, keys);
    }

    public boolean exists(String name) {
        return this.getCacheService().exists(name);
    }

    private CacheService getCacheService() {
        CacheService cache = this.caches.get(this.cache_default);
        if (cache == null) {
            String msg = "the key[" + this.cache_default + "] cache service not find!";
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
        return cache;
    }

    public boolean registerCacheService(String name, CacheService cache) {
        if (this.caches.containsKey(name)) {
            return false;
        }
        this.caches.put(name, cache);
        return true;
    }

    public boolean unRegisterCacheService(String name) {
        if (this.caches.containsKey(name)) {
            this.caches.remove(name);
            return true;
        }
        return false;
    }

    public CacheService getCacheService(String name) {
        return this.caches.get(name);
    }

    public boolean contains(String name, String ... keys) {
        return this.getCacheService().contains(name, keys);
    }
}

