/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.cache.script;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.oiue.service.cache.CacheServiceManager;
import org.oiue.service.cache.Type;
import org.oiue.service.cache.script.CacheScriptResult;
import org.oiue.service.cache.script.CacheScriptService;
import org.oiue.tools.map.MapUtil;

public class CacheScriptServiceImpl
implements CacheScriptService {
    private CacheServiceManager buffer;

    public CacheScriptServiceImpl(CacheServiceManager buffer) {
        this.buffer = buffer;
    }

    @Override
    public CacheScriptResult eval(String script) {
        String line = script.toString().trim();
        CacheScriptResult result = new CacheScriptResult();
        result.setResult(CacheScriptResult.OK);
        result.setData("ok");
        if (line.startsWith("p")) {
            this.parsePut(line, result);
        } else if (line.startsWith("r")) {
            this.parseRemove(line, result);
        } else if (line.startsWith("g")) {
            try {
                this.parseGet(line, result);
            }
            catch (Exception e) {
                result.setResult(CacheScriptResult.ERROR_FORMAT);
                result.setData(e.getLocalizedMessage());
            }
        } else {
            result.setResult(CacheScriptResult.ERROR_COMMAND);
        }
        return result;
    }

    private void parsePut(String line, CacheScriptResult result) {
        String[] cmdArray = line.split(" ", 2);
        if (cmdArray.length == 2) {
            String cmd = cmdArray[0];
            if (cmd.equalsIgnoreCase("po")) {
                String[] tmp = cmdArray[1].split(",", 4);
                if (tmp.length == 4) {
                    this.buffer.getCacheService(tmp[0]).put(tmp[1], tmp[2], (Object)tmp[3], Type.ONE);
                } else {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("poj")) {
                String[] tmp = cmdArray[1].split(",", 4);
                if (tmp.length == 4) {
                    Object value = tmp[3];
                    if (value instanceof String) {
                        value = MapUtil.fromString((String)(value + ""));
                    }
                    this.buffer.getCacheService(tmp[0]).put(tmp[1], tmp[2], value, Type.ONE);
                } else {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("pm")) {
                String[] tmp = cmdArray[1].split(",", 4);
                if (tmp.length == 4) {
                    this.buffer.getCacheService(tmp[0]).put(tmp[1], tmp[2], (Object)tmp[3], Type.MANY);
                } else {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("pmj")) {
                String[] tmp = cmdArray[1].split(",", 4);
                if (tmp.length == 4) {
                    Object value = tmp[3];
                    if (value instanceof String) {
                        value = MapUtil.fromString((String)(value + ""));
                    }
                    this.buffer.getCacheService(tmp[0]).put(tmp[1], tmp[2], value, Type.MANY);
                } else {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("ps")) {
                String[] tmp = cmdArray[1].split(",", 6);
                if (tmp.length != 6) {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("pt")) {
                String[] tmp = cmdArray[1].split(",", 5);
                if (tmp.length != 5) {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else {
                result.setResult(CacheScriptResult.ERROR_COMMAND);
            }
        } else {
            result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
        }
    }

    private void parseRemove(String line, CacheScriptResult result) {
        String[] cmdArray = line.split(" ", 2);
        if (cmdArray.length == 2) {
            String cmd = cmdArray[0];
            if (cmd.equalsIgnoreCase("rb")) {
                String[] tmp = cmdArray[1].split(",", 2);
                this.buffer.getCacheService(tmp[0]).delete(tmp[1]);
            } else if (cmd.equalsIgnoreCase("ro") || cmd.equalsIgnoreCase("rs") || cmd.equalsIgnoreCase("rm") || cmd.equalsIgnoreCase("rt")) {
                String[] tmp = cmdArray[1].split(",", 4);
                if (tmp.length == 3) {
                    this.buffer.getCacheService(tmp[0]).delete(tmp[1], new String[]{tmp[2]});
                } else if (cmd.equalsIgnoreCase("rm") && tmp.length == 4) {
                    this.buffer.getCacheService(tmp[0]).delete(tmp[1], new String[]{tmp[2], tmp[3]});
                } else {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("rr")) {
                String[] tmp = cmdArray[1].split(",");
                if (tmp.length != 4 && tmp.length != 5) {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (!cmd.equalsIgnoreCase("rc")) {
                result.setResult(CacheScriptResult.ERROR_COMMAND);
            }
        } else {
            result.setResult(CacheScriptResult.ERROR_COMMAND);
        }
    }

    private double[][] createSpaticalArgument(String x1, String x2, String y1, String y2) {
        String[] ax1 = x1.split(";");
        String[] ax2 = x2.split(";");
        String[] ay1 = y1.split(";");
        String[] ay2 = y2.split(";");
        if (ax1.length != ax2.length || ax1.length != ay1.length || ax1.length != ay2.length) {
            return null;
        }
        try {
            int j;
            double[][] args = new double[4][];
            for (int i = 0; i < 4; ++i) {
                args[i] = new double[ax1.length];
            }
            for (j = 0; j < ax1.length; ++j) {
                args[0][j] = Double.parseDouble(ax1[j]);
            }
            for (j = 0; j < ax1.length; ++j) {
                args[1][j] = Double.parseDouble(ax2[j]);
            }
            for (j = 0; j < ax1.length; ++j) {
                args[2][j] = Double.parseDouble(ay1[j]);
            }
            for (j = 0; j < ax1.length; ++j) {
                args[3][j] = Double.parseDouble(ay2[j]);
            }
            return args;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void parseGet(String line, CacheScriptResult result) throws JSONException {
        String[] cmdArray = line.split(" ", 2);
        if (cmdArray.length == 2) {
            String cmd = cmdArray[0];
            if (cmd.equalsIgnoreCase("gb")) {
                String[] tmp = cmdArray[1].split(",", 2);
                result.setData(this.buffer.getCacheService(tmp[0]).get(tmp[1]));
            } else if (cmd.equalsIgnoreCase("go") || cmd.equalsIgnoreCase("gm") || cmd.equalsIgnoreCase("gt")) {
                String[] tmp = cmdArray[1].split(",");
                if (tmp.length == 3) {
                    result.setData(this.buffer.getCacheService(tmp[0]).get(tmp[1], tmp[2]));
                } else {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                }
            } else if (!cmd.equalsIgnoreCase("gs") && !cmd.equalsIgnoreCase("gr")) {
                result.setResult(CacheScriptResult.ERROR_COMMAND);
            }
        } else {
            result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
        }
    }

    public Object getParamValue(String param, List<Object> list) {
        String[] temp = param.split("\\{|\\}");
        if (temp.length == 1) {
            return param;
        }
        if (temp.length == 2 && temp[0].length() == 0) {
            try {
                return list.get(Integer.parseInt(temp[1]) - 1);
            }
            catch (Exception e) {
                return param;
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length; i += 2) {
            sb.append(temp[i]);
            try {
                sb.append(list.get(Integer.parseInt(temp[i + 1]) - 1));
                continue;
            }
            catch (Exception e) {
                return param;
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CacheScriptResult eval(String script, List<Object> list) {
        CacheScriptResult result;
        block18: {
            script = script.trim();
            result = new CacheScriptResult();
            String[] tmp = script.split(" |,", 4);
            if (tmp.length < 4) {
                result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
                return result;
            }
            if (!tmp[0].startsWith("p")) {
                if (!tmp[0].startsWith("rr") && !tmp[0].startsWith("r") && tmp[0].startsWith("g")) {
                    // empty if block
                }
            } else {
                Type type;
                switch (tmp[0].charAt(1)) {
                    case 'o': {
                        type = Type.ONE;
                        break;
                    }
                    case 'm': {
                        type = Type.MANY;
                        break;
                    }
                    case 's': {
                        type = Type.SPATIAL;
                        break;
                    }
                    case 't': {
                        type = Type.TREE;
                        break;
                    }
                    default: {
                        result.setResult(CacheScriptResult.ERROR_ARGUMENT);
                        return result;
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String e : tmp[2].split(",")) {
                    String[] kv = (e = e.trim()).split(":", 2);
                    if (kv.length < 2) {
                        result.setResult(CacheScriptResult.ERROR_ARGUMENT);
                        return result;
                    }
                    try {
                        map.put(kv[0], this.getParamValue(kv[1], list));
                    }
                    catch (Exception e2) {
                        result.setResult(CacheScriptResult.ERROR_ARGUMENT);
                        result.setData(e2.getMessage());
                        return result;
                    }
                }
                String valueKey = tmp[0].length() >= 3 ? tmp[0].substring(2) : null;
                try {
                    if (type == Type.SPATIAL || type == Type.TREE) break block18;
                    if (valueKey != null) {
                        this.buffer.put(tmp[1], MapUtil.getString(map, (String)"k"), map.get(valueKey), type);
                    } else {
                        this.buffer.put(tmp[1], MapUtil.getString(map, (String)"k"), map, type);
                    }
                }
                catch (Exception ex) {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENT);
                    result.setData(ex.getMessage());
                    return result;
                }
            }
        }
        result.setResult(CacheScriptResult.OK);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CacheScriptResult eval(String script, Map<String, Object> map) {
        result = new CacheScriptResult();
        tmp = script.split(" |,", 2);
        if (tmp.length < 2) {
            result.setResult(CacheScriptResult.ERROR_ARGUMENTS);
            return result;
        }
        if (tmp[0].startsWith("p")) {
            switch (tmp[0].charAt(1)) {
                case 'o': {
                    type = Type.ONE;
                    break;
                }
                case 'm': {
                    type = Type.MANY;
                    break;
                }
                case 's': {
                    type = Type.SPATIAL;
                    break;
                }
                case 't': {
                    type = Type.TREE;
                    break;
                }
                default: {
                    result.setResult(CacheScriptResult.ERROR_ARGUMENT);
                    return result;
                }
            }
            valueKey = tmp[0].length() >= 3 ? tmp[0].substring(2) : null;
            try {
                if (type == Type.SPATIAL || type == Type.TREE) ** GOTO lbl37
                if (valueKey != null) {
                    this.buffer.put(tmp[1], MapUtil.getString(map, (String)"k"), map.get(valueKey), type);
                }
                this.buffer.put(tmp[1], MapUtil.getString(map, (String)"k"), map, type);
            }
            catch (Exception ex) {
                result.setResult(CacheScriptResult.ERROR_ARGUMENT);
                result.setData(ex.getMessage());
                return result;
            }
        } else if (tmp[0].startsWith("r") || tmp[0].startsWith("g")) {
            // empty if block
        }
lbl37:
        // 6 sources

        result.setResult(CacheScriptResult.OK);
        return result;
    }
}

