/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.cache.tree.script;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.oiue.service.cache.tree.CacheTreeService;
import org.oiue.service.cache.tree.script.BufferScriptResult;
import org.oiue.service.cache.tree.script.CacheTreeScriptService;

public class CacheTreeScriptServiceImpl
implements CacheTreeScriptService {
    private CacheTreeService buffer;

    public CacheTreeScriptServiceImpl(CacheTreeService buffer) {
        this.buffer = buffer;
    }

    @Override
    public Object eval(String script) {
        String line = script.toString().trim();
        BufferScriptResult result = new BufferScriptResult();
        result.setResult(BufferScriptResult.OK);
        result.setData("ok");
        if (line.startsWith("p")) {
            this.parsePut(line, result);
        } else if (line.startsWith("r")) {
            this.parseRemove(line, result);
        } else if (line.startsWith("g")) {
            try {
                this.parseGet(line, result);
            }
            catch (Exception e) {
                result.setResult(BufferScriptResult.ERROR_FORMAT);
                result.setData(e.getLocalizedMessage());
            }
        } else {
            result.setResult(BufferScriptResult.ERROR_COMMAND);
        }
        return result;
    }

    private void parsePut(String line, BufferScriptResult result) {
        String[] cmdArray = line.split(" ", 2);
        if (cmdArray.length == 2) {
            String cmd = cmdArray[0];
            if (cmd.equalsIgnoreCase("pc")) {
                String[] tmp = cmdArray[1].split(",", 2);
                this.buffer.create(tmp[0], (Object)tmp[1]);
            } else if (cmd.equalsIgnoreCase("pt")) {
                String[] tmp = cmdArray[1].split(",", 2);
                this.buffer.createTemp(tmp[0], (Object)tmp[1]);
            } else if (cmd.equalsIgnoreCase("pcc")) {
                String[] tmp = cmdArray[1].split(",", 3);
                if (tmp.length != 3) {
                    result.setResult(BufferScriptResult.ERROR_ARGUMENTS);
                }
            } else if (cmd.equalsIgnoreCase("ptc")) {
                String[] tmp = cmdArray[1].split(",", 3);
                if (tmp.length != 3) {
                    result.setResult(BufferScriptResult.ERROR_ARGUMENTS);
                }
            } else {
                result.setResult(BufferScriptResult.ERROR_COMMAND);
            }
        } else {
            result.setResult(BufferScriptResult.ERROR_ARGUMENTS);
        }
    }

    private void parseRemove(String line, BufferScriptResult result) {
        String[] cmdArray = line.split(" ", 2);
        if (cmdArray.length == 2) {
            String cmd = cmdArray[0];
            if (cmd.equalsIgnoreCase("r")) {
                this.buffer.delete(cmdArray[1], 0);
            } else {
                result.setResult(BufferScriptResult.ERROR_COMMAND);
            }
        } else {
            result.setResult(BufferScriptResult.ERROR_COMMAND);
        }
    }

    private void parseGet(String line, BufferScriptResult result) throws JSONException {
        String[] cmdArray = line.split(" ", 2);
        if (cmdArray.length == 1) {
            if (cmdArray[0].equalsIgnoreCase("gt")) {
                result.setData(this.buffer.getChildren("/"));
            } else if (cmdArray[0].equalsIgnoreCase("gd")) {
                result.setData(this.buffer.getData("/"));
            } else {
                result.setResult(BufferScriptResult.ERROR_COMMAND);
            }
        } else if (cmdArray.length == 2) {
            String cmd = cmdArray[0];
            if (cmd.equalsIgnoreCase("gt")) {
                result.setData(this.buffer.getChildren(cmdArray[1]));
            } else if (cmd.equalsIgnoreCase("gd")) {
                result.setData(this.buffer.getData(cmdArray[1]));
            } else {
                result.setResult(BufferScriptResult.ERROR_COMMAND);
            }
        } else {
            result.setResult(BufferScriptResult.ERROR_ARGUMENTS);
        }
    }

    public Object getParamValue(String param, List<Object> list) {
        String[] temp = param.split("\\{|\\}");
        if (temp.length == 1) {
            return param;
        }
        if (temp.length == 2 && temp[0].length() == 0) {
            try {
                return list.get(Integer.parseInt(temp[1]) - 1);
            }
            catch (Exception e) {
                return param;
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length; i += 2) {
            sb.append(temp[i]);
            try {
                sb.append(list.get(Integer.parseInt(temp[i + 1]) - 1));
                continue;
            }
            catch (Exception e) {
                return param;
            }
        }
        return sb.toString();
    }

    @Override
    public BufferScriptResult eval(String script, List<Object> list) {
        script = script.trim();
        BufferScriptResult result = new BufferScriptResult();
        String[] tmp = script.split(" |,", 3);
        if (tmp.length < 3) {
            result.setResult(BufferScriptResult.ERROR_ARGUMENTS);
            return result;
        }
        if (tmp[0].startsWith("p")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String e : tmp[2].split(",")) {
                String[] kv = (e = e.trim()).split(":", 2);
                if (kv.length < 2) {
                    result.setResult(BufferScriptResult.ERROR_ARGUMENT);
                    return result;
                }
                try {
                    map.put(kv[0], this.getParamValue(kv[1], list));
                }
                catch (Exception e2) {
                    result.setResult(BufferScriptResult.ERROR_ARGUMENT);
                    result.setData(e2.getMessage());
                    return result;
                }
            }
        } else if (tmp[0].startsWith("rr") || tmp[0].startsWith("g")) {
            // empty if block
        }
        result.setResult(BufferScriptResult.OK);
        return result;
    }

    @Override
    public BufferScriptResult eval(String script, Map<String, Object> map) {
        BufferScriptResult result = new BufferScriptResult();
        String[] tmp = script.split(" |,", 2);
        if (tmp.length < 2) {
            result.setResult(BufferScriptResult.ERROR_ARGUMENTS);
            return result;
        }
        if (tmp[0].startsWith("p") || tmp[0].startsWith("r") || tmp[0].startsWith("g")) {
            // empty if block
        }
        result.setResult(BufferScriptResult.OK);
        return result;
    }

    public static void main(String[] args) {
        System.out.println("start");
        for (String e : "a{3}{34}c".split("\\{|\\}")) {
            System.out.println(e);
        }
        System.out.println("end");
    }
}

