/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.debug.cache;

import java.util.List;
import java.util.Map;
import org.oiue.service.cache.script.CacheScriptResult;
import org.oiue.service.cache.script.CacheScriptService;
import org.oiue.service.tcp.Handler;
import org.oiue.service.tcp.Session;
import org.oiue.tools.list.ListUtil;
import org.oiue.tools.map.MapUtil;

public class ServerHandler
implements Handler {
    private CacheScriptService cacheScript = null;

    public ServerHandler(CacheScriptService cacheScript) {
        this.cacheScript = cacheScript;
    }

    public void received(Session session, String line, byte[] bytes) throws Exception {
        if (line.startsWith("o")) {
            session.write("o");
            session.close();
        } else if (line.startsWith("k")) {
            session.write("k");
        } else {
            CacheScriptResult result = this.cacheScript.eval(line);
            if (result.getResult() != CacheScriptResult.OK) {
                session.write(result.getResult());
            } else {
                Object data = result.getData();
                if (data instanceof List) {
                    session.write(ListUtil.toString((List)((List)data)));
                } else if (data instanceof Map) {
                    session.write(MapUtil.toString((Map)((Map)data)));
                } else {
                    session.write(data + "");
                }
            }
        }
    }

    public void closed(Session session) throws Exception {
    }

    public void opened(Session session) throws Exception {
    }

    public void idled(Session session) throws Exception {
        session.close();
    }

    public void sent(Session session) throws Exception {
    }

    public int getReaderIdleCount() {
        return 0;
    }
}

