/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.oiue.service.osgi.MulitServiceTrackerCustomizer;
import org.oiue.service.osgi.proxy.ServiceProxy;
import org.oiue.service.osgi.proxy.ServicesManager;
import org.oiue.tools.string.StringUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class FrameActivator
implements BundleActivator,
ServiceTrackerCustomizer {
    private BundleContext context;
    private boolean isProxy = false;
    private Set<String> classNameSet = new HashSet<String>();
    private Hashtable<String, Object> services = new Hashtable();
    private MulitServiceTrackerCustomizer trackerCustomizer = null;
    private ServiceTracker tracker;
    private Set<ServiceRegistration<?>> regConfigurator = new HashSet();

    public final void start(BundleContext context) throws Exception {
        this.context = context;
        this.isProxy = StringUtil.isTrue((String)(this.getProperty("count_call_service") + ""));
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(BundleContext context) throws Exception {
        Set<ServiceRegistration<?>> set = this.regConfigurator;
        synchronized (set) {
            for (ServiceRegistration<?> serviceRegistration : this.regConfigurator) {
                serviceRegistration.unregister();
            }
            this.regConfigurator.clear();
        }
        this.stop();
        if (this.trackerCustomizer != null) {
            this.trackerCustomizer.removedService();
            this.trackerCustomizer.initialize = false;
        }
        if (this.services != null) {
            this.services.clear();
        }
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.trackerCustomizer = null;
        this.tracker = null;
        context = null;
    }

    public final <T> T getService(Class<T> c) {
        String classname = c.getName();
        if (!this.classNameSet.contains(classname)) {
            throw new RuntimeException("get service exception, class[" + c + "] not in classNames.");
        }
        Object service = this.services.get(classname);
        return (T)service;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(MulitServiceTrackerCustomizer mstc, Class ... cs) throws Exception {
        this.trackerCustomizer = mstc;
        StringBuffer filterString = new StringBuffer();
        filterString.append("(|");
        if (cs != null && cs.length > 0) {
            for (int i = 0; i < cs.length; ++i) {
                String classname = cs[i].getName();
                if (this.classNameSet.contains(classname)) continue;
                this.classNameSet.add(classname);
                filterString.append("(objectClass=").append(classname).append(")");
            }
            filterString.append(")");
            this.tracker = new ServiceTracker(this.context, this.context.createFilter(filterString.toString()), (ServiceTrackerCustomizer)this);
            this.tracker.open();
            ServicesManager.addAllARS(this.classNameSet);
        } else {
            FrameActivator frameActivator = this;
            synchronized (frameActivator) {
                if (!this.trackerCustomizer.initialize) {
                    this.trackerCustomizer.addingService();
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("service.pid", this.getClass().getName());
                    Set<ServiceRegistration<?>> set = this.regConfigurator;
                    synchronized (set) {
                        this.regConfigurator.add(this.context.registerService(ManagedService.class.getName(), (Object)this.trackerCustomizer, props));
                    }
                    this.trackerCustomizer.initialize = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object addingService(ServiceReference reference) {
        Object obj = this.context.getService(reference);
        String[] classNames = (String[])reference.getProperty("objectClass");
        ServicesManager.addAllASS(Arrays.asList(classNames));
        for (String e : classNames) {
            if (!this.classNameSet.contains(e)) continue;
            this.services.put(e, obj);
        }
        if (this.services.size() == this.classNameSet.size()) {
            FrameActivator frameActivator = this;
            synchronized (frameActivator) {
                if (!this.trackerCustomizer.initialize) {
                    this.trackerCustomizer.addingService();
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("service.pid", this.getClass().getName());
                    Set<ServiceRegistration<?>> set = this.regConfigurator;
                    synchronized (set) {
                        this.regConfigurator.add(this.context.registerService(ManagedService.class.getName(), (Object)this.trackerCustomizer, props));
                    }
                    this.trackerCustomizer.initialize = true;
                    ServicesManager.putRelationService(this, new ArrayList<Object>(this.classNameSet));
                }
            }
        }
        return obj;
    }

    public final void modifiedService(ServiceReference reference, Object object) {
    }

    public final void removedService(ServiceReference reference, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerService(Class c, Object object) {
        Set<ServiceRegistration<?>> set = this.regConfigurator;
        synchronized (set) {
            this.regConfigurator.add(this.context.registerService(c.getName(), object, null));
        }
        if (this.isProxy && !c.getName().startsWith("org.oiue.service.odp")) {
            ServicesManager.putService(c.getName(), Proxy.newProxyInstance(c.getClassLoader(), c.getInterfaces(), (InvocationHandler)new ServiceProxy(object)));
        } else {
            ServicesManager.putService(c.getName(), object);
        }
    }

    public final String getProperty(String key) {
        return this.context.getProperty(key);
    }

    public <T> T getServiceForce(String serviceName) {
        return ServicesManager.getServiceByName(serviceName);
    }
}

