/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import org.oiue.service.osgi.SystemMulitServiceTrackerCustomizer;
import org.oiue.service.osgi.proxy.ProxyManager;
import org.oiue.service.osgi.proxy.ServicesManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class MulitServiceTracker
implements ServiceTrackerCustomizer {
    private BundleContext context;
    private Hashtable<String, Object> services = new Hashtable();
    private int trackerCount = 0;
    private ServiceTracker tracker = null;
    private SystemMulitServiceTrackerCustomizer trackerCustomizer = null;
    private HashSet<String> classNameSet = new HashSet();

    public MulitServiceTracker(BundleContext context, String[] classNames, SystemMulitServiceTrackerCustomizer mulitServiceTrackerCustomizer) throws InvalidSyntaxException {
        this.trackerCount = classNames.length;
        this.trackerCustomizer = mulitServiceTrackerCustomizer;
        this.context = ProxyManager.proxyContext(context);
        StringBuffer filterString = new StringBuffer();
        filterString.append("(|");
        for (int i = 0; i < classNames.length; ++i) {
            if (this.classNameSet.contains(classNames[i])) continue;
            this.classNameSet.add(classNames[i]);
            filterString.append("(objectClass=").append(classNames[i]).append(")");
        }
        filterString.append(")");
        this.tracker = new ServiceTracker(context, context.createFilter(filterString.toString()), (ServiceTrackerCustomizer)this);
        ServicesManager.addAllARS(this.classNameSet);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void open() {
        this.tracker.open(true);
    }

    public void close() {
        this.tracker.close();
    }

    public Object addingService(ServiceReference ref) {
        Object obj = this.context.getService(ref);
        String[] classNames = (String[])ref.getProperty("objectClass");
        ServicesManager.addAllASS(Arrays.asList(classNames));
        for (String e : classNames) {
            if (!this.classNameSet.contains(e)) continue;
            this.services.put(e, obj);
        }
        if (this.services.size() == this.trackerCount) {
            this.trackerCustomizer.addingService(this);
        }
        return obj;
    }

    public void modifiedService(ServiceReference ref, Object object) {
    }

    public void removedService(ServiceReference ref, Object object) {
        String[] classNames = (String[])ref.getProperty("objectClass");
        if (this.services.size() == this.trackerCount) {
            this.trackerCustomizer.removedService(this);
        }
        for (String e : classNames) {
            if (!this.classNameSet.contains(e)) continue;
            this.services.remove(e);
        }
    }

    public <T> T getService(String className) {
        if (!this.classNameSet.contains(className)) {
            throw new RuntimeException("get service exception, class[" + className + "] not in classNames.");
        }
        Object service = this.services.get(className);
        return (T)service;
    }

    public <T> T getServiceForce(String serviceName) {
        return ServicesManager.getServiceByName(serviceName);
    }
}

