/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi.rpc;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.oiue.service.cache.tree.CacheTreeService;
import org.oiue.service.osgi.MulitServiceTracker;
import org.oiue.service.osgi.SystemMulitServiceTrackerCustomizer;
import org.oiue.service.osgi.proxy.ServicesManager;
import org.oiue.service.osgi.rpc.RPCService;
import org.oiue.service.osgi.rpc.RPCServiceImpl;
import org.oiue.tools.string.StringUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class Activator
implements BundleActivator {
    private MulitServiceTracker tracker = null;
    private CacheTreeService cacheTreeService;
    private BundleContext context;

    public void start(final BundleContext context) throws Exception {
        this.context = context;
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent be) {
            }
        });
        context.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        ServiceReference ref = event.getServiceReference();
                        Object service = context.getService(ref);
                        if (service == null) break;
                        context.ungetService(ref);
                        break;
                    }
                    case 4: {
                        System.out.println("serviceChanged:[" + event.getType() + "]" + event);
                    }
                }
            }
        });
        context.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                switch (event.getType()) {
                    case 1: {
                        System.out.println("frameworkEvent REGISTERED:[" + event.getType() + "]" + event);
                        String[] classNames = new String[]{CacheTreeService.class.getName()};
                        try {
                            Activator.this.tracker = new MulitServiceTracker(context, classNames, new SystemMulitServiceTrackerCustomizer(){
                                private ServiceRegistration<?> regConfigurator;

                                @Override
                                public void removedService(MulitServiceTracker tracker) {
                                    this.regConfigurator.unregister();
                                }

                                @Override
                                public void addingService(MulitServiceTracker tracker) {
                                    Activator.this.cacheTreeService = (CacheTreeService)tracker.getService(CacheTreeService.class.getName());
                                    Hashtable<String, String> props = new Hashtable<String, String>();
                                    ((Dictionary)props).put("service.pid", Activator.class.getName());
                                    this.regConfigurator = tracker.getContext().registerService(ManagedService.class, (Object)new Configurator(), props);
                                }
                            });
                            Activator.this.tracker.open();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        System.out.println("start RPC over");
                        break;
                    }
                    case 4: {
                        System.out.println("frameworkEvent UNREGISTERING:[" + event.getType() + "]" + event);
                        break;
                    }
                    default: {
                        System.out.println("frameworkEvent:[" + event.getType() + "]" + event);
                    }
                }
            }
        });
        System.out.println("all bundles:" + Arrays.asList(context.getBundles()));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private class Configurator
    implements ManagedService {
        private Configurator() {
        }

        public void updated(final Dictionary<String, ?> props) throws ConfigurationException {
            new Thread(this.getClass().getName()){

                @Override
                public void run() {
                    System.out.println("not start services:" + ServicesManager.getRpcServices());
                    boolean startRpc = StringUtil.isTrue((String)(props.get("startRpc") + ""));
                    boolean shareService = StringUtil.isTrue((String)(props.get("shareService") + ""));
                    if (startRpc) {
                        try {
                            String local = props.get("localURL") + "";
                            String path = props.get("rootPath") + "";
                            int rpcPort = Integer.valueOf(props.get("rpcPort") + "");
                            if (StringUtil.isEmptys((String)path) || StringUtil.isEmptys((String)local)) {
                                throw new RuntimeException("config localURL and rootPath not null!");
                            }
                            path = path.endsWith("/") ? path : path + "/";
                            RPCServiceImpl rpc = new RPCServiceImpl();
                            URLClassLoader uc = (URLClassLoader)ClassLoader.getSystemClassLoader();
                            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                            add.setAccessible(true);
                            add.invoke((Object)uc, RPCService.class.getProtectionDomain().getCodeSource().getLocation());
                            String url = "rmi://" + local + ":" + rpcPort + "/RPCService";
                            LocateRegistry.createRegistry(rpcPort);
                            Naming.rebind(url, rpc);
                            Activator.this.cacheTreeService.createTemp(path + "ServerStatus/" + local.replace(".", "_"), (Object)local);
                            ServicesManager.registerRPC(Activator.this.cacheTreeService, path, local);
                            System.out.println("start all service:" + ServicesManager.getAllService());
                            System.out.println("start all local service:" + ServicesManager.getAllStartService());
                            System.out.println("start all relation service:" + ServicesManager.getRelationService());
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    if (shareService) {
                        ServicesManager.startRPC(Activator.this.cacheTreeService, Activator.this.context, props);
                    }
                }
            }.start();
        }
    }
}

