/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi.proxy;

import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class BundleUtils {
    public static ClassLoader getBundleClassLoader(Bundle bundle) {
        Enumeration classFileEntries = bundle.findEntries("/", "*.class", true);
        if (classFileEntries == null || !classFileEntries.hasMoreElements()) {
            throw new RuntimeException(String.format("Bundle[%s]\u4e2d\u6ca1\u6709\u4e00\u4e2aJava\u7c7b\uff01", bundle.getSymbolicName()));
        }
        URL url = (URL)classFileEntries.nextElement();
        String bundleOneClassName = url.getPath();
        bundleOneClassName = bundleOneClassName.replace("/", ".").substring(0, bundleOneClassName.lastIndexOf("."));
        while (bundleOneClassName.startsWith(".")) {
            bundleOneClassName = bundleOneClassName.substring(1);
        }
        Class bundleOneClass = null;
        try {
            bundleOneClass = bundle.loadClass(bundleOneClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return bundleOneClass.getClassLoader();
    }

    public static void printServiceReference(ServiceReference ref) {
        String[] property;
        for (String key : property = ref.getPropertyKeys()) {
            Object value = ref.getProperty(key);
            System.out.println("key:" + key + "|value=" + (value instanceof String[] ? Arrays.deepToString((Object[])value) : value));
        }
    }
}

