/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.oiue.service.osgi.proxy.ServiceProxy;
import org.oiue.service.osgi.proxy.ServicesManager;
import org.oiue.tools.StatusResult;
import org.osgi.framework.BundleContext;

class ContextProxy
implements InvocationHandler {
    BundleContext context = null;

    public ContextProxy(BundleContext context) {
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!"registerService".equals(method.getName())) return method.invoke((Object)this.context, args);
        try {
            Object service = args[1];
            if (service == null) {
                throw new RuntimeException("registerService error:" + args);
            }
            Class<?> cls = service.getClass();
            try {
                if (!cls.getName().startsWith("org.oiue.service.odp")) {
                    args[1] = Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), (InvocationHandler)new ServiceProxy(service));
                }
            }
            catch (Throwable e) {
                StatusResult sr = new StatusResult();
                sr.setResult(1);
                System.out.println(":" + e.getMessage() + "," + cls.getSimpleName() + "," + cls.getClassLoader() + "," + Arrays.asList(cls.getInterfaces()));
            }
            Object argso = args[0];
            if (argso instanceof String) {
                ServicesManager.putService((String)argso, args[1]);
                return method.invoke((Object)this.context, args);
            }
            if (!(argso instanceof String[])) return method.invoke((Object)this.context, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return method.invoke((Object)this.context, args);
    }
}

