/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi.proxy;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.oiue.service.cache.tree.CacheTreeService;
import org.oiue.service.osgi.FrameActivator;
import org.oiue.service.osgi.proxy.ProxyManager;
import org.oiue.service.osgi.rpc.RPCService;
import org.oiue.service.osgi.rpc.RPCServiceImpl;
import org.oiue.tools.string.StringUtil;
import org.osgi.framework.BundleContext;

public class ServicesManager {
    private static Map<String, Object> allService = null;
    private static Map<FrameActivator, List<Object>> relationService = null;
    private static Set<String> allRelationService = null;
    private static Map<String, Object> allStartService = null;

    public static void addAllARS(Collection<? extends String> c) {
        allRelationService.addAll(c);
    }

    public static void putRelationService(FrameActivator serviceName, List<Object> relation) {
        relationService.put(serviceName, relation);
    }

    public static Set<String> getStartService() {
        return allStartService.keySet();
    }

    public static <T> T getServiceByName(String serviceName) {
        return (T)allService.get(serviceName);
    }

    public static void putService(String key, Object o) {
        if (allStartService.containsKey(key)) {
            return;
        }
        allStartService.put(key, o);
        allService.put(key, o);
    }

    public static Map<String, Object> getAllService() {
        return allService;
    }

    public static Map<FrameActivator, List<Object>> getRelationService() {
        return relationService;
    }

    public static Set<String> getAllRelationService() {
        return allRelationService;
    }

    public static Set<String> getAllStartService() {
        return allStartService.keySet();
    }

    public static Set<String> getRpcServices() {
        HashSet<String> allRelationServiceTmp = new HashSet<String>();
        allRelationServiceTmp.addAll(allRelationService);
        allRelationServiceTmp.removeAll(allStartService.keySet());
        return allRelationServiceTmp;
    }

    public static void startRPC(CacheTreeService cacheTreeService, BundleContext context, Dictionary<String, ?> config) {
        String local = config.get("localIp") + "";
        String path = config.get("rootPath") + "";
        int rpcPort = Integer.valueOf(config.get("rpcPort") + "");
        if (StringUtil.isEmptys((String)path) || StringUtil.isEmptys((String)local)) {
            throw new RuntimeException("config localURL and rootPath not null!");
        }
        try {
            path = path.endsWith("/") ? path : path + "/";
            URLClassLoader uc = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            add.setAccessible(true);
            add.invoke((Object)uc, RPCService.class.getProtectionDomain().getCodeSource().getLocation());
            LocateRegistry.createRegistry(rpcPort);
            RPCServiceImpl rpc = new RPCServiceImpl();
            String url = "rmi://" + local + ":" + rpcPort + "/RPCService";
            Naming.rebind(url, rpc);
            ServicesManager.registerRPC(cacheTreeService, path, local);
            System.out.println("start all service:" + ServicesManager.getAllService());
            System.out.println("start all local service:" + ServicesManager.getAllStartService());
            System.out.println("start all relation service:" + ServicesManager.getRelationService());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ArrayList<Exception> es = new ArrayList<Exception>();
        for (String serviceName : ServicesManager.getRpcServices()) {
            try {
                Object service = ProxyManager.proxyService(serviceName, cacheTreeService, context, config);
                context.registerService(serviceName, service, null);
            }
            catch (Exception e) {
                es.add(e);
            }
        }
        if (es.size() > 0) {
            // empty if block
        }
    }

    public static void registerRPC(CacheTreeService cacheTreeService, String path, String local) {
        ArrayList<Exception> es = new ArrayList<Exception>();
        cacheTreeService.createTemp(path + "ServerStatus/" + local.replace(".", "_"), (Object)local);
        for (String serviceName : ServicesManager.getStartService()) {
            try {
                cacheTreeService.createTemp(path + "Services/" + serviceName.replace(".", "_"), (Object)local);
            }
            catch (Exception e) {
                es.add(e);
            }
        }
    }

    static {
        allService = new ConcurrentHashMap<String, Object>();
        relationService = new ConcurrentHashMap<FrameActivator, List<Object>>();
        allRelationService = new CopyOnWriteArraySet<String>();
        allStartService = new ConcurrentHashMap<String, Object>();
    }
}

