/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.osgi.rpc;

import java.util.Arrays;
import java.util.Dictionary;
import org.oiue.service.cache.tree.CacheTreeService;
import org.oiue.service.osgi.FrameActivator;
import org.oiue.service.osgi.MulitServiceTrackerCustomizer;
import org.oiue.service.osgi.proxy.ServicesManager;
import org.oiue.tools.string.StringUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private FrameActivator tracker = null;
    private CacheTreeService cacheTreeService;

    public void start(final BundleContext context) throws Exception {
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent be) {
            }
        });
        context.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        ServiceReference ref = event.getServiceReference();
                        Object service = context.getService(ref);
                        if (service != null) {
                            context.ungetService(ref);
                        }
                        ServicesManager.putService(((String[])ref.getProperty("objectClass"))[0], service);
                        break;
                    }
                }
            }
        });
        context.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                switch (event.getType()) {
                    case 1: {
                        System.out.println("frameworkEvent REGISTERED:[" + event.getType() + "]" + event);
                        try {
                            Activator.this.tracker = new FrameActivator(){

                                @Override
                                public void stop() throws Exception {
                                }

                                @Override
                                public void start() throws Exception {
                                    this.start(new MulitServiceTrackerCustomizer(){

                                        @Override
                                        public void addingService() {
                                            Activator.this.cacheTreeService = this.getService(CacheTreeService.class);
                                        }

                                        @Override
                                        public void removedService() {
                                        }

                                        @Override
                                        public void updated(final Dictionary<String, ?> props) {
                                            boolean startRpc = StringUtil.isTrue((String)(props.get("startRpc") + ""));
                                            final boolean shareService = StringUtil.isTrue((String)(props.get("shareService") + ""));
                                            new Thread(this.getClass().getName()){

                                                @Override
                                                public void run() {
                                                    System.out.println("not start services:" + ServicesManager.getRpcServices());
                                                    if (props != null && shareService) {
                                                        ServicesManager.startRPC(Activator.this.cacheTreeService, context, props);
                                                    }
                                                }
                                            }.start();
                                        }
                                    }, CacheTreeService.class);
                                }
                            };
                            Activator.this.tracker.start(context);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        System.out.println("not start services:" + ServicesManager.getRpcServices());
                        System.out.println("start RPC over");
                        break;
                    }
                    case 4: {
                        System.out.println("frameworkEvent UNREGISTERING:[" + event.getType() + "]" + event);
                        break;
                    }
                    default: {
                        System.out.println("frameworkEvent:[" + event.getType() + "]" + event);
                    }
                }
            }
        });
        System.out.println("all bundles:" + Arrays.asList(context.getBundles()));
    }

    public void stop(BundleContext context) throws Exception {
    }
}

