/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.permission.verify;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.odp.base.FactoryService;
import org.oiue.service.odp.res.api.IResource;
import org.oiue.service.online.Online;
import org.oiue.service.permission.PermissionService;
import org.oiue.service.permission.PermissionServiceManager;
import org.oiue.tools.StatusResult;
import org.oiue.tools.exception.ExceptionUtil;
import org.oiue.tools.map.MapUtil;
import org.oiue.tools.string.StringUtil;

public class PermissionServiceImpl
implements PermissionService,
Serializable {
    private Logger logger;
    private FactoryService factoryService;
    private PermissionServiceManager permissionServiceManager;
    private String permission_type = "def_permission";
    private String data_source_name = null;
    private String event_id = "fm_system_query_component_service";

    public PermissionServiceImpl(LogService logService, PermissionServiceManager permissionServiceManager, FactoryService factoryService) {
        this.logger = logService.getLogger(this.getClass());
        this.permissionServiceManager = permissionServiceManager;
        this.factoryService = factoryService;
    }

    public void unregister() {
        this.permissionServiceManager.unRegisterPermissionService(this.permission_type);
    }

    public void updated(Dictionary<String, ?> props) {
        try {
            String permission_type = props.get("permissionKey") + "";
            if (!StringUtil.isEmptys((String)permission_type)) {
                this.permission_type = permission_type;
            }
            this.permissionServiceManager.registerPermissionService(this.permission_type, (PermissionService)this);
        }
        catch (Throwable e) {
            this.logger.error("config[permissionKey] is error:" + e.getMessage(), e);
        }
        try {
            String event_id = props.get("service_event_id") + "";
            if (!StringUtil.isEmptys((String)event_id)) {
                this.event_id = event_id;
            }
        }
        catch (Throwable e) {
            this.logger.error("config[service_event_id] is error:" + e.getMessage(), e);
        }
        try {
            String data_source_name = props.get("data_source_name") + "";
            if (!StringUtil.isEmptys((String)data_source_name)) {
                this.data_source_name = data_source_name;
            }
        }
        catch (Throwable e) {
            this.logger.error("config[data_source_name] is error:" + e.getMessage(), e);
        }
    }

    public StatusResult verify(Map per, Online online) {
        StatusResult afr = new StatusResult();
        String modulename = MapUtil.getVauleMatchCase((Map)per, (Object)"modulename") + "";
        if ("execute".equals(modulename)) {
            String event_id = MapUtil.getVauleMatchCase((Map)per, (Object)"operation") + "";
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("serviceName", "org.oiue.service.event.execute.EventExecuteService");
            tmp.put("methodName", "execute");
            tmp.put("service_event_id", event_id);
            per.put("_system_permission_key_", tmp);
            afr.setResult(100);
        } else {
            afr.setResult(1);
        }
        return afr;
    }

    public StatusResult convert(Map per) {
        StatusResult afr = new StatusResult();
        String modulename = MapUtil.getVauleMatchCase((Map)per, (Object)"modulename") + "";
        String operation = MapUtil.getVauleMatchCase((Map)per, (Object)"operation") + "";
        if (!StringUtil.isEmptys((String)modulename) || !StringUtil.isEmptys((String)operation)) {
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("modulename", modulename);
            temp.put("operation", operation);
            try {
                IResource iresource = (IResource)this.factoryService.getBmo(IResource.class.getName());
                Object ro = iresource.callEvent(this.event_id, this.data_source_name, temp);
                if (ro == null) {
                    throw new RuntimeException("Data does not exist\uff01");
                }
                if (ro instanceof Map) {
                    Map tmp = (Map)ro;
                    if (tmp.size() == 0) {
                        throw new RuntimeException("Data does not exist\uff01");
                    }
                    tmp.put("serviceName", MapUtil.getVauleMatchCase((Map)tmp, (Object)"bundle_service_id"));
                    tmp.put("methodName", MapUtil.getVauleMatchCase((Map)tmp, (Object)"name"));
                    ro = tmp;
                }
                per.put("_system_permission_key_", ro);
            }
            catch (Throwable e) {
                String msg = "convert module to service event is error," + ExceptionUtil.getCausedBySrcMsg((Throwable)e);
                this.logger.error("query[" + this.data_source_name + ":" + this.event_id + "] is error:" + msg, e);
                afr.setResult(-120);
                afr.setDescription(msg);
                return afr;
            }
        }
        afr.setResult(1);
        return afr;
    }
}

