/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.sql.apache;

import java.util.Dictionary;
import java.util.Hashtable;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.osgi.FrameActivator;
import org.oiue.service.osgi.MulitServiceTrackerCustomizer;
import org.oiue.service.sql.SqlService;
import org.oiue.service.sql.apache.SqlServiceImpl;

public class Activator
extends FrameActivator {
    public void start() throws Exception {
        this.start(new MulitServiceTrackerCustomizer(){
            private SqlService sqlService;
            private String baseDir;
            private Logger logger;

            public void removedService() {
                this.sqlService.unregisterAll();
            }

            public void addingService() {
                this.baseDir = Activator.this.getProperty("user.dir");
                LogService logService = (LogService)Activator.this.getService(LogService.class);
                this.sqlService = new SqlServiceImpl(logService);
                this.logger = logService.getLogger(Activator.class);
            }

            public void updated(Dictionary<String, ?> props) {
                try {
                    String[] ds;
                    String[] alias;
                    for (String e : alias = this.sqlService.listDataSource()) {
                        this.sqlService.unregister(e);
                    }
                    for (String e : ds = String.valueOf(props.get("ds")).split(",")) {
                        try {
                            e = e.trim();
                            Hashtable<String, Object> dsProps = new Hashtable<String, Object>();
                            ((Dictionary)dsProps).put("driverClassName", props.get("ds." + e + ".driverClassName"));
                            ((Dictionary)dsProps).put("username", props.get("ds." + e + ".username"));
                            ((Dictionary)dsProps).put("password", props.get("ds." + e + ".password"));
                            ((Dictionary)dsProps).put("url", props.get("ds." + e + ".url").toString().replace("${user.dir}", this.baseDir));
                            ((Dictionary)dsProps).put("maxActive", props.get("ds." + e + ".maxActive"));
                            ((Dictionary)dsProps).put("maxIdle", props.get("ds." + e + ".maxIdle"));
                            ((Dictionary)dsProps).put("maxWait", props.get("ds." + e + ".maxWait"));
                            ((Dictionary)dsProps).put("validationQuery", props.get("ds." + e + ".validationQuery"));
                            this.sqlService.registerDataSource(e, dsProps);
                        }
                        catch (Exception ex) {
                            this.logger.error("connect [" + e + "] config is error:" + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    Activator.this.registerService(SqlService.class, this.sqlService);
                }
                catch (Throwable e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }, new Class[]{LogService.class});
    }

    public void stop() throws Exception {
    }
}

