/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.service.sql.apache;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.oiue.service.log.LogService;
import org.oiue.service.log.Logger;
import org.oiue.service.sql.SqlService;
import org.oiue.service.sql.SqlServiceResult;

public class SqlServiceImpl
implements SqlService {
    private Logger logger;
    private Hashtable<String, BasicDataSource> dataSources = new Hashtable();
    private String sql = "select dsp.name,dsp.value from fm_data_source ds,fm_data_source_parameters dsp where ds.data_source_id=dsp.data_source_id and name =?";

    public SqlServiceImpl(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
    }

    public boolean registerDataSource(String alias, Dictionary params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("register data source, alias = " + alias, new Object[0]);
        }
        if (this.dataSources.contains(alias)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.error("data source alias is exits, alais = " + alias, new Object[0]);
            }
            return false;
        }
        BasicDataSource ds = new BasicDataSource();
        try {
            ds.setDriverClassName(params.get("driverClassName").toString());
            ds.setUsername(params.get("username").toString());
            ds.setPassword(params.get("password").toString());
            ds.setUrl(params.get("url").toString());
            ds.setMaxActive(Integer.valueOf(params.get("maxActive").toString()).intValue());
            ds.setMaxIdle(Integer.valueOf(params.get("maxIdle").toString()).intValue());
            ds.setMaxWait((long)Integer.valueOf(params.get("maxWait").toString()).intValue());
            ds.setValidationQuery(params.get("validationQuery").toString());
            if (this.logger.isInfoEnabled()) {
                this.logger.debug("data source params = " + ds, new Object[0]);
            }
        }
        catch (Exception ex) {
            this.logger.error("register data source error", (Throwable)ex);
            return false;
        }
        this.dataSources.put(alias, ds);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("register data source successed, alias = " + alias, new Object[0]);
        }
        return true;
    }

    public void unregister(String alias) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("unregister data source, alias = " + alias, new Object[0]);
        }
        if (this.dataSources.contains(alias)) {
            try {
                this.dataSources.get(alias).close();
            }
            catch (SQLException e) {
                this.logger.error("data source close error", (Throwable)e);
            }
            this.dataSources.remove(alias);
        }
    }

    public void unregisterAll() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("unregister all data source ", new Object[0]);
        }
        Iterator<BasicDataSource> iterator = this.dataSources.values().iterator();
        while (iterator.hasNext()) {
            BasicDataSource ds = iterator.next();
            try {
                ds.close();
            }
            catch (SQLException e) {
                this.logger.error("data source close error", (Throwable)e);
            }
            iterator.remove();
        }
    }

    public String[] listDataSource() {
        return this.dataSources.keySet().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlServiceResult insertUpdateOrDelete(String alias, String sql, List<Object> params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("insert update or delete, alias = " + alias + ", sql = " + sql + ", params = " + params, new Object[0]);
        }
        SqlServiceResult result = new SqlServiceResult();
        DataSource dataSource = (DataSource)this.dataSources.get(alias);
        if (dataSource == null) {
            this.logger.error("can't found alias, alias = " + alias, new Object[0]);
            result.setResult(false);
            result.setData((Object)"can't found data source");
            return result;
        }
        Connection conn = null;
        ResultSet rset = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    if (param instanceof java.util.Date) {
                        pstmt.setObject(i + 1, new Date(((java.util.Date)param).getTime()));
                        continue;
                    }
                    pstmt.setObject(i + 1, param);
                }
            }
            result.setResult(true);
            result.setData((Object)pstmt.executeUpdate());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("execute update successed, data = " + result.getData(), new Object[0]);
            }
            SqlServiceResult i = result;
            return i;
        }
        catch (SQLException e) {
            this.logger.error("execute update sql error", (Throwable)e);
            result.setResult(false);
            result.setData((Object)e.getMessage());
            SqlServiceResult sqlServiceResult = result;
            return sqlServiceResult;
        }
        catch (Exception ex) {
            this.logger.error("execute update error", (Throwable)ex);
            result.setResult(false);
            result.setData((Object)ex.getMessage());
            SqlServiceResult sqlServiceResult = result;
            return sqlServiceResult;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlServiceResult insertUpdateOrDeleteWithClob(String alias, String sql, List<Object> params, HashSet<Integer> clobIndexSet) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("insert update or delete, alias = " + alias + ", sql = " + sql + ", params = " + params, new Object[0]);
        }
        SqlServiceResult result = new SqlServiceResult();
        DataSource dataSource = (DataSource)this.dataSources.get(alias);
        if (dataSource == null) {
            this.logger.error("can't found alias, alias = " + alias, new Object[0]);
            result.setResult(false);
            result.setData((Object)"can't found data source");
            return result;
        }
        Connection conn = null;
        ResultSet rset = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    if (clobIndexSet.contains(i) && param != null) {
                        String clobConent = param.toString();
                        StringReader clobReader = new StringReader(clobConent);
                        pstmt.setCharacterStream(i + 1, (Reader)clobReader, clobConent.length());
                        continue;
                    }
                    pstmt.setObject(i + 1, param);
                }
            }
            result.setResult(true);
            result.setData((Object)pstmt.executeUpdate());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("execute update successed, data = " + result.getData(), new Object[0]);
            }
            SqlServiceResult i = result;
            return i;
        }
        catch (SQLException e) {
            this.logger.error("execute update sql error", (Throwable)e);
            result.setResult(false);
            result.setData((Object)e.getMessage());
            SqlServiceResult sqlServiceResult = result;
            return sqlServiceResult;
        }
        catch (Exception ex) {
            this.logger.error("execute update error", (Throwable)ex);
            result.setResult(false);
            result.setData((Object)ex.getMessage());
            SqlServiceResult sqlServiceResult = result;
            return sqlServiceResult;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlServiceResult select(String alias, String sql, List<Object> params) {
        SqlServiceResult sqlServiceResult;
        SqlServiceResult sqlServiceResult2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("select, alias = " + alias + ", sql = " + sql + ", params = " + params, new Object[0]);
        }
        SqlServiceResult result = new SqlServiceResult();
        DataSource dataSource = (DataSource)this.dataSources.get(alias);
        if (dataSource == null) {
            this.logger.error("can't found alias, alias = " + alias, new Object[0]);
            result.setResult(false);
            result.setData((Object)"can't found data source");
            return result;
        }
        Connection conn = null;
        ResultSet rset = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    if (param instanceof java.util.Date) {
                        pstmt.setObject(i + 1, new Date(((java.util.Date)param).getTime()));
                        continue;
                    }
                    pstmt.setObject(i + 1, param);
                }
            }
            rset = pstmt.executeQuery();
            int numcols = rset.getMetaData().getColumnCount();
            ArrayList arrayRecords = new ArrayList();
            while (rset.next()) {
                ArrayList<Object> arrayRecord = new ArrayList<Object>();
                for (int i = 1; i <= numcols; ++i) {
                    Object obj = rset.getObject(i);
                    if (obj instanceof Clob) {
                        Clob clob = (Clob)obj;
                        Reader reader = clob.getCharacterStream();
                        if (reader == null) {
                            SqlServiceResult sqlServiceResult3 = null;
                            return sqlServiceResult3;
                        }
                        StringBuffer sb = new StringBuffer();
                        char[] charbuf = new char[4096];
                        int size = reader.read(charbuf);
                        while (size > 0) {
                            sb.append(charbuf, 0, size);
                            size = reader.read(charbuf);
                        }
                        arrayRecord.add(sb.toString());
                        continue;
                    }
                    if (obj instanceof BigDecimal) {
                        arrayRecord.add(Long.valueOf(obj + ""));
                        continue;
                    }
                    arrayRecord.add(obj);
                }
                arrayRecords.add(arrayRecord);
            }
            result.setResult(true);
            result.setData(arrayRecords);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("execute select successed, data count = " + arrayRecords.size(), new Object[0]);
            }
            sqlServiceResult2 = result;
        }
        catch (SQLException e) {
            this.logger.error("execute select sql error", (Throwable)e);
            result.setResult(false);
            result.setData((Object)e.getMessage());
            sqlServiceResult = result;
            return sqlServiceResult;
        }
        catch (Exception ex) {
            this.logger.error("execute select error", (Throwable)ex);
            result.setResult(false);
            result.setData((Object)ex.getMessage());
            sqlServiceResult = result;
            return sqlServiceResult;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return sqlServiceResult2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlServiceResult selectMap(String alias, String sql, List<Object> params) {
        SqlServiceResult sqlServiceResult;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("select json, alias = " + alias + ", sql = " + sql + ", params = " + params, new Object[0]);
        }
        SqlServiceResult result = new SqlServiceResult();
        DataSource dataSource = (DataSource)this.dataSources.get(alias);
        if (dataSource == null) {
            this.logger.error("can't found alias, alias = " + alias, new Object[0]);
            result.setResult(false);
            result.setData((Object)"can't found data source");
            return result;
        }
        Connection conn = null;
        ResultSet rset = null;
        PreparedStatement pstmt = null;
        try {
            conn = dataSource.getConnection();
            pstmt = conn.prepareStatement(sql);
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    if (param instanceof java.util.Date) {
                        pstmt.setObject(i + 1, new Date(((java.util.Date)param).getTime()));
                        continue;
                    }
                    pstmt.setObject(i + 1, param);
                }
            }
            rset = pstmt.executeQuery();
            ResultSetMetaData metaData = rset.getMetaData();
            int numcols = metaData.getColumnCount();
            String[] columnLabels = new String[numcols];
            for (int i = 0; i < numcols; ++i) {
                columnLabels[i] = metaData.getColumnLabel(i + 1).toLowerCase();
            }
            ArrayList arrayRecords = new ArrayList();
            while (rset.next()) {
                HashMap<String, Object> record = new HashMap<String, Object>();
                for (int i = 1; i <= numcols; ++i) {
                    Object obj = rset.getObject(i);
                    if (obj instanceof Clob) {
                        Clob clob = (Clob)obj;
                        Reader reader = clob.getCharacterStream();
                        if (reader == null) {
                            SqlServiceResult sqlServiceResult2 = null;
                            return sqlServiceResult2;
                        }
                        StringBuffer sb = new StringBuffer();
                        char[] charbuf = new char[4096];
                        int size = reader.read(charbuf);
                        while (size > 0) {
                            sb.append(charbuf, 0, size);
                            size = reader.read(charbuf);
                        }
                        record.put(columnLabels[i - 1], sb.toString());
                        continue;
                    }
                    if (obj instanceof BigDecimal) {
                        try {
                            record.put(columnLabels[i - 1], Long.valueOf(obj + ""));
                        }
                        catch (Throwable e) {
                            this.logger.warn(e.getMessage(), e);
                            try {
                                record.put(columnLabels[i - 1], Double.valueOf(obj + ""));
                            }
                            catch (Throwable e2) {
                                this.logger.error(e.getMessage() + e2.getMessage(), e2);
                            }
                        }
                        continue;
                    }
                    record.put(columnLabels[i - 1].toLowerCase(), obj);
                }
                arrayRecords.add(record);
            }
            result.setResult(true);
            result.setData(arrayRecords);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("execute select map successed, data count = " + arrayRecords.size(), new Object[0]);
            }
            sqlServiceResult = result;
        }
        catch (SQLException e) {
            this.logger.error("execute select sql error,sql=" + sql + ",params=" + params, (Throwable)e);
            result.setResult(false);
            result.setData((Object)e.getMessage());
            SqlServiceResult sqlServiceResult3 = result;
            return sqlServiceResult3;
        }
        catch (Exception ex) {
            this.logger.error("execute select map error,sql=" + sql + ",params=" + params, (Throwable)ex);
            result.setResult(false);
            result.setData((Object)ex.getMessage());
            SqlServiceResult sqlServiceResult4 = result;
            return sqlServiceResult4;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return sqlServiceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlServiceResult call(String alias, String sql, List<Object> params) {
        SqlServiceResult sqlServiceResult;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("call, alias = " + alias + ", sql = " + sql + ", params = " + params, new Object[0]);
        }
        SqlServiceResult result = new SqlServiceResult();
        DataSource dataSource = (DataSource)this.dataSources.get(alias);
        if (dataSource == null) {
            this.logger.error("can't found alias, alias = " + alias, new Object[0]);
            result.setResult(false);
            result.setData((Object)"can't found data source");
            return result;
        }
        Connection conn = null;
        ResultSet rset = null;
        Statement cstmt = null;
        String flag = "";
        try {
            conn = dataSource.getConnection();
            if (sql.endsWith("V") || sql.endsWith("v")) {
                flag = "V";
                sql = sql.substring(0, sql.length() - 1);
            } else if (sql.endsWith("R") || sql.endsWith("r")) {
                flag = "R";
                sql = sql.substring(0, sql.length() - 1);
            }
            cstmt = conn.prepareCall(sql);
            int paramCount = cstmt.getParameterMetaData().getParameterCount();
            if (flag.equalsIgnoreCase("V")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("call return one string value", new Object[0]);
                }
                cstmt.registerOutParameter(paramCount, 12);
            } else if (flag.equalsIgnoreCase("R")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("call return one record value", new Object[0]);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("call return nothing", new Object[0]);
            }
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    if (param instanceof java.util.Date) {
                        cstmt.setObject(i + 1, new Date(((java.util.Date)param).getTime()));
                        continue;
                    }
                    cstmt.setObject(i + 1, param);
                }
            }
            cstmt.execute();
            if (flag.equalsIgnoreCase("V")) {
                ArrayList<Object> arrayRecord = new ArrayList<Object>();
                arrayRecord.add(cstmt.getObject(paramCount));
                result.setResult(true);
                result.setData(arrayRecord);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("call return result = true, data = " + arrayRecord, new Object[0]);
                }
            } else if (flag.equalsIgnoreCase("R")) {
                rset = (ResultSet)cstmt.getObject(paramCount);
                ResultSetMetaData metaData = rset.getMetaData();
                int numcols = metaData.getColumnCount();
                ArrayList arrayRecords = new ArrayList();
                while (rset.next()) {
                    ArrayList<Object> arrayRecord = new ArrayList<Object>();
                    for (int i = 1; i <= numcols; ++i) {
                        Object obj = rset.getObject(i);
                        if (obj instanceof Clob) {
                            Clob clob = (Clob)obj;
                            Reader reader = clob.getCharacterStream();
                            if (reader == null) {
                                SqlServiceResult sqlServiceResult2 = null;
                                return sqlServiceResult2;
                            }
                            StringBuffer sb = new StringBuffer();
                            char[] charbuf = new char[4096];
                            int size = reader.read(charbuf);
                            while (size > 0) {
                                sb.append(charbuf, 0, size);
                                size = reader.read(charbuf);
                            }
                            arrayRecord.add(sb.toString());
                            continue;
                        }
                        if (obj instanceof BigDecimal) {
                            arrayRecord.add(Long.valueOf(obj + ""));
                            continue;
                        }
                        arrayRecord.add(obj);
                    }
                    arrayRecords.add(arrayRecord);
                }
                result.setResult(true);
                result.setData(arrayRecords);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("call return result = true, data count = " + arrayRecords.size(), new Object[0]);
                }
            } else {
                result.setResult(true);
                result.setData((Object)"ok");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("call return result = true, data = ok", new Object[0]);
                }
            }
            sqlServiceResult = result;
        }
        catch (Exception e) {
            this.logger.error("execute call error", (Throwable)e);
            result.setResult(false);
            result.setData((Object)e.getMessage());
            SqlServiceResult sqlServiceResult3 = result;
            return sqlServiceResult3;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return sqlServiceResult;
    }

    public Connection getConnection(String alias) {
        Connection conn;
        DataSource dataSource;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get connect, alias = " + alias, new Object[0]);
        }
        if ((dataSource = (DataSource)this.dataSources.get(alias)) == null) {
            conn = null;
            ResultSet rset = null;
            Statement pstmt = null;
            try {
                dataSource = (DataSource)this.dataSources.get(0);
                BasicDataSource ds = new BasicDataSource();
                conn = dataSource.getConnection();
                pstmt = conn.prepareStatement(this.sql);
                pstmt.setObject(1, alias);
                rset = pstmt.executeQuery();
                while (rset.next()) {
                    ds.addConnectionProperty(rset.getString("name"), rset.getString("value"));
                }
                this.dataSources.put(alias, ds);
                dataSource = ds;
            }
            catch (Throwable e) {
                throw new RuntimeException("get connect alias is not exits, alias = " + alias, e);
            }
            finally {
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (Exception ds) {}
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ds) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ds) {}
                }
            }
        }
        try {
            conn = dataSource.getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("get connect successed", new Object[0]);
            }
            return conn;
        }
        catch (SQLException e) {
            throw new RuntimeException("get connect alias error\uff0calias=" + alias + "," + e.getMessage(), e);
        }
    }

    public DataSource getDataSource(String alias) {
        return (DataSource)this.dataSources.get(alias);
    }
}

