package org.oiue.tools.string;

import java.util.LinkedHashMap;

/** 
 * 类说明:
 *		汉字转化为全拼,码表利用输入法的码表导出，汉字信息非常全，平时见到的汉字
 * 转拼音的API只能处理几千个一级汉字，很多字都没有法查到，尤其是我自己的姓
 * 都查不到所以只好自己做一个汉字转拼音的API，该API除可以处理99％以上的汉字，
 * 而且可以返回多音字的读音
 * @author Every E-mail/MSN:mwgjkf@hotmail.com
 *               QQ:30130942
 *  CnToSpell 1.0  Apr 23, 2009 4:57:02 PM
 * CnToSpell
 */
public class CnToSpell {

	private static LinkedHashMap<String, String> spellMap;

	private CnToSpell() {
	}

	private static void spellPut(String ascii, String spells) {
		spellMap.put(ascii, spells);
	}

	private static void initialize() {
		init0();
		init1();
		init2();
		init3();
		init4();
		init5();
		init6();
		init7();
		init8();
		init9();
		init10();
		init11();
		init12();
		init13();
		init14();
		init15();
		init16();
		init17();
		init18();
		init19();
		init20();
		init21();
		init22();
		init23();
		init24();
		init25();
		init26();
		init27();
		init28();
		init29();
		init30();
		init31();
		init32();
		init33();
		init34();
		init35();
		init36();
		init37();
		init38();
		init39();
		init40();
		init41();
		init42();
		init43();
		init44();
		init45();
		init46();
		init47();
		init48();
		init49();
		init50();
		init51();
		init52();
		init53();
		init54();
		init55();
		init56();
		init57();
		init58();
		init59();
		init60();
		init61();
		init62();
		init63();
		init64();
		init65();
		init66();
		init67();
		init68();
		init69();
		init70();
		init71();
		init72();
		init73();
		init74();
		init75();
		init76();
		init77();
		init78();
		init79();
		init80();
		init81();
		init82();
		init83();
		init84();
		init85();
		init86();
		init87();
		init88();
		init89();
		init90();
		init91();
		init92();
		init93();
		init94();
		init95();
		init96();
		init97();
		init98();
		init99();
		init100();
		init101();
		init102();
		init103();
		init104();
		init105();
		init106();
		init107();
		init108();
		init109();
		init110();
		init111();
		init112();
		init113();
		init114();
		init115();
	}

	private static void init0() {
		spellPut("129-64", "kao,qiao,yu");
		spellPut("129-65", "shang");
		spellPut("129-66", "xia");
		spellPut("129-67", "mo ye o ne");
		spellPut("129-68", "mian");
		spellPut("129-69", "chou");
		spellPut("129-70", "shi");
		spellPut("129-71", "diu");
		spellPut("129-72", "qiu");
		spellPut("129-73", "liang");
		spellPut("129-74", "you");
		spellPut("129-75", "bing");
		spellPut("129-76", "jiu");
		spellPut("129-77", "ji");
		spellPut("129-78", "jie");
		spellPut("129-79", "guan,kuang");
		spellPut("129-80", "chan");
		spellPut("129-81", "zhuo");
		spellPut("129-82", "ba");
		spellPut("129-83", "jing");
		spellPut("129-84", "fu");
		spellPut("129-85", "yi,ji");
		spellPut("129-86", "yi");
		spellPut("129-87", "shi me");
		spellPut("129-88", "jiu");
		spellPut("129-89", "ho");
		spellPut("129-90", "yin");
		spellPut("129-91", "hu");
		spellPut("129-92", "cheng,sheng");
		spellPut("129-93", "hao,yi");
		spellPut("129-94", "wBn");
		spellPut("129-95", "gai");
		spellPut("129-96", "jiu");
		spellPut("129-97", "hB ri");
		spellPut("129-98", "ho lo");
		spellPut("129-99", "dou");
		spellPut("129-100", "shi");
		spellPut("129-101", "nang");
		spellPut("129-102", "gB ri");
		spellPut("129-103", "ge ri");
		spellPut("129-104", "dBo ri");
		spellPut("129-105", "mo ri");
		spellPut("129-106", "o lo");
		spellPut("129-107", "cB lo");
		spellPut("129-108", "xue");
		spellPut("129-109", "yan");
		spellPut("129-110", "po ri");
		spellPut("129-111", "sB lo");
		spellPut("129-112", "na");
		spellPut("129-113", "qian");
		spellPut("129-114", "sBo ri");
		spellPut("129-115", "er");
		spellPut("129-116", "zu ri");
		spellPut("129-117", "zB ri");
		spellPut("129-118", "zhi,luan");
		spellPut("129-119", "gui");
		spellPut("129-120", "qian");
		spellPut("129-121", "luan");
		spellPut("129-122", "lin");
		spellPut("129-123", "yi");
		spellPut("129-124", "jue");
		spellPut("129-125", "ma");
		spellPut("129-126", "shi");
		spellPut("129-128", "yu");
		spellPut("129-129", "si");
		spellPut("129-130", "sui");
		spellPut("129-131", "gen");
		spellPut("129-132", "ya");
		spellPut("129-133", "qi,zhai");
		spellPut("129-134", "ya");
		spellPut("129-135", "da");
		spellPut("129-136", "ye");
		spellPut("129-137", "xiang");
		spellPut("129-138", "jing");
		spellPut("129-139", "ye");
		spellPut("129-140", "you");
		spellPut("129-141", "dan");
		spellPut("129-142", "lian");
		spellPut("129-143", "duo");
		spellPut("129-144", "wei,men");
		spellPut("129-145", "ji");
		spellPut("129-146", "ji");
		spellPut("129-147", "wang");
		spellPut("129-148", "ba");
		spellPut("129-149", "bing");
		spellPut("129-150", "fo");
		spellPut("129-151", "jin,san");
		spellPut("129-152", "e o");
		spellPut("129-153", "xian");
		spellPut("129-154", "tuo,cha,duo");
		spellPut("129-155", "hong");
		spellPut("129-156", "gan,han");
		spellPut("129-157", "bo");
		spellPut("129-158", "chao");
		spellPut("129-159", "chang,zhang");
		spellPut("129-160", "chang");
		spellPut("129-161", "ren");
		spellPut("129-162", "fan");
		spellPut("129-163", "chao,miao");
		spellPut("129-164", "qian");
		spellPut("129-165", "wo");
		spellPut("129-166", "yao,fo");
		spellPut("129-167", "feng");
		spellPut("129-168", "cang");
		spellPut("129-169", "wang");
		spellPut("129-170", "di");
		spellPut("129-171", "zhong");
		spellPut("129-172", "pei");
		spellPut("129-173", "yu");
		spellPut("129-174", "diao");
		spellPut("129-175", "dun");
		spellPut("129-176", "wen");
		spellPut("129-177", "yi");
		spellPut("129-178", "xin");
		spellPut("129-179", "ji");
		spellPut("129-180", "ai");
		spellPut("129-181", "jin");
		spellPut("129-182", "pi");
		spellPut("129-183", "dan");
		spellPut("129-184", "fu");
		spellPut("129-185", "tang");
		spellPut("129-186", "cui");
		spellPut("129-187", "yun");
		spellPut("129-188", "che,ju");
		spellPut("129-189", "qian");
		spellPut("129-190", "xun");
		spellPut("129-191", "xin");
		spellPut("129-192", "chi");
		spellPut("129-193", "xian,xuan");
		spellPut("129-194", "nu");
		spellPut("129-195", "ni");
		spellPut("129-196", "xie");
		spellPut("129-197", "xu");
		spellPut("129-198", "zhou");
		spellPut("129-199", "qu");
		spellPut("129-200", "peng");
		spellPut("129-201", "pi");
		spellPut("129-202", "zhi");
		spellPut("129-203", "si");
		spellPut("129-204", "yi,chi");
		spellPut("129-205", "zheng");
		spellPut("129-206", "han,gan");
		spellPut("129-207", "mai");
		spellPut("129-208", "zhu");
		spellPut("129-209", "bu");
		spellPut("129-210", "qu");
		spellPut("129-211", "bi");
		spellPut("129-212", "zhao,shao");
		spellPut("129-213", "ci");
		spellPut("129-214", "yang");
		spellPut("129-215", "zhan,dian");
		spellPut("129-216", "bi");
		spellPut("129-217", "xian");
		spellPut("129-218", "qu");
		spellPut("129-219", "shi");
		spellPut("129-220", "bBo");
		spellPut("129-221", "hui,huai");
		spellPut("129-222", "ge");
		spellPut("129-223", "xiang");
		spellPut("129-224", "ge");
		spellPut("129-225", "fa");
		spellPut("129-226", "ming");
		spellPut("129-227", "bing");
		spellPut("129-228", "hen");
		spellPut("129-229", "huo");
		spellPut("129-230", "gui");
		spellPut("129-231", "quan");
		spellPut("129-232", "ci");
		spellPut("129-233", "xing");
		spellPut("129-234", "shen");
		spellPut("129-235", "tuo");
		spellPut("129-236", "gai");
		spellPut("129-237", "lai");
		spellPut("129-238", "yi");
		spellPut("129-239", "gong");
		spellPut("129-240", "yin");
		spellPut("129-241", "mi");
		spellPut("129-242", "xu");
		spellPut("129-243", "an");
		spellPut("129-244", "lu");
		spellPut("129-245", "er");
		spellPut("129-246", "lun");
		spellPut("129-247", "cha");
		spellPut("129-248", "chi");
		spellPut("129-249", "xun");
		spellPut("129-250", "zhou");
		spellPut("129-251", "ru");
		spellPut("129-252", "cun");
		spellPut("129-253", "si");
		spellPut("129-254", "dai");
	}

	private static void init1() {
		spellPut("130-64", "tB");
		spellPut("130-65", "ning");
		spellPut("130-66", "jin");
		spellPut("130-67", "jiong");
		spellPut("130-68", "cheng,ting");
		spellPut("130-69", "zhen");
		spellPut("130-70", "zuo");
		spellPut("130-71", "hao");
		spellPut("130-72", "lv");
		spellPut("130-73", "jv");
		spellPut("130-74", "shu,dou");
		spellPut("130-75", "ting");
		spellPut("130-76", "shen");
		spellPut("130-77", "tuo,tui");
		spellPut("130-78", "bo");
		spellPut("130-79", "nan");
		spellPut("130-80", "xiao");
		spellPut("130-81", "tui");
		spellPut("130-82", "yu");
		spellPut("130-83", "xi");
		spellPut("130-84", "xu");
		spellPut("130-85", "guang");
		spellPut("130-86", "ku");
		spellPut("130-87", "wu");
		spellPut("130-88", "yi");
		spellPut("130-89", "fu");
		spellPut("130-90", "liang");
		spellPut("130-91", "hun");
		spellPut("130-92", "jing");
		spellPut("130-93", "qian");
		spellPut("130-94", "san");
		spellPut("130-95", "pei");
		spellPut("130-96", "xi");
		spellPut("130-97", "fu");
		spellPut("130-98", "xia");
		spellPut("130-99", "xiu");
		spellPut("130-100", "di");
		spellPut("130-101", "che,ju");
		spellPut("130-102", "zhi");
		spellPut("130-103", "lai");
		spellPut("130-104", "si");
		spellPut("130-105", "huo");
		spellPut("130-106", "xiao");
		spellPut("130-107", "jian");
		spellPut("130-108", "biao");
		spellPut("130-109", "chu,ti");
		spellPut("130-110", "fei");
		spellPut("130-111", "ya");
		spellPut("130-112", "bei");
		spellPut("130-113", "yu");
		spellPut("130-114", "xin");
		spellPut("130-115", "hu,chi");
		spellPut("130-116", "chang");
		spellPut("130-117", "zhi");
		spellPut("130-118", "bing");
		spellPut("130-119", "jiu");
		spellPut("130-120", "yao");
		spellPut("130-121", "cui,zu");
		spellPut("130-122", "liang,lia");
		spellPut("130-123", "wan");
		spellPut("130-124", "lai");
		spellPut("130-125", "cang");
		spellPut("130-126", "zong");
		spellPut("130-128", "ge");
		spellPut("130-129", "tian");
		spellPut("130-130", "shu");
		spellPut("130-131", "men");
		spellPut("130-132", "tan");
		spellPut("130-133", "chui");
		spellPut("130-134", "xing");
		spellPut("130-135", "peng");
		spellPut("130-136", "qi");
		spellPut("130-137", "gan");
		spellPut("130-138", "liang,jing");
		spellPut("130-139", "sui");
		spellPut("130-140", "jie");
		spellPut("130-141", "fang");
		spellPut("130-142", "zhi");
		spellPut("130-143", "zong");
		spellPut("130-144", "lun");
		spellPut("130-145", "song");
		spellPut("130-146", "leng");
		spellPut("130-147", "hun");
		spellPut("130-148", "dong");
		spellPut("130-149", "zi");
		spellPut("130-150", "ben");
		spellPut("130-151", "wu");
		spellPut("130-152", "ju");
		spellPut("130-153", "nai");
		spellPut("130-154", "cai");
		spellPut("130-155", "jian");
		spellPut("130-156", "ye");
		spellPut("130-157", "sha");
		spellPut("130-158", "ning");
		spellPut("130-159", "ying");
		spellPut("130-160", "cheng,chen");
		spellPut("130-161", "qian");
		spellPut("130-162", "ruan");
		spellPut("130-163", "zhong,tong");
		spellPut("130-164", "chun");
		spellPut("130-165", "wei");
		spellPut("130-166", "yu");
		spellPut("130-167", "bing");
		spellPut("130-168", "ti");
		spellPut("130-169", "yan");
		spellPut("130-170", "feng");
		spellPut("130-171", "tang,dang");
		spellPut("130-172", "wo");
		spellPut("130-173", "e");
		spellPut("130-174", "che");
		spellPut("130-175", "sheng");
		spellPut("130-176", "kan");
		spellPut("130-177", "di");
		spellPut("130-178", "cha");
		spellPut("130-179", "bei");
		spellPut("130-180", "xie");
		spellPut("130-181", "huang");
		spellPut("130-182", "yao");
		spellPut("130-183", "zhan");
		spellPut("130-184", "chou,qiao");
		spellPut("130-185", "an");
		spellPut("130-186", "you");
		spellPut("130-187", "xu");
		spellPut("130-188", "zha");
		spellPut("130-189", "ci");
		spellPut("130-190", "fu");
		spellPut("130-191", "bi");
		spellPut("130-192", "zhi");
		spellPut("130-193", "mian");
		spellPut("130-194", "ji");
		spellPut("130-195", "yi");
		spellPut("130-196", "xie");
		spellPut("130-197", "xun");
		spellPut("130-198", "cai,si");
		spellPut("130-199", "duan");
		spellPut("130-200", "ce,ze,zhai");
		spellPut("130-201", "zhen");
		spellPut("130-202", "tou");
		spellPut("130-203", "bei");
		spellPut("130-204", "zan,za,zBn");
		spellPut("130-205", "jie");
		spellPut("130-206", "wei");
		spellPut("130-207", "sou");
		spellPut("130-208", "zhi,si");
		spellPut("130-209", "su");
		spellPut("130-210", "xia");
		spellPut("130-211", "yuan");
		spellPut("130-212", "rong");
		spellPut("130-213", "nu");
		spellPut("130-214", "yun");
		spellPut("130-215", "jiang,gou");
		spellPut("130-216", "ma");
		spellPut("130-217", "dian");
		spellPut("130-218", "tang");
		spellPut("130-219", "hao");
		spellPut("130-220", "jie");
		spellPut("130-221", "xi");
		spellPut("130-222", "shan");
		spellPut("130-223", "qian,jian");
		spellPut("130-224", "que,jue");
		spellPut("130-225", "cang,chen");
		spellPut("130-226", "chu");
		spellPut("130-227", "san");
		spellPut("130-228", "bei");
		spellPut("130-229", "xiao");
		spellPut("130-230", "rong");
		spellPut("130-231", "yao");
		spellPut("130-232", "ta,tan");
		spellPut("130-233", "suo");
		spellPut("130-234", "yang");
		spellPut("130-235", "fa");
		spellPut("130-236", "bing");
		spellPut("130-237", "jia");
		spellPut("130-238", "zai");
		spellPut("130-239", "gu");
		spellPut("130-240", "can");
		spellPut("130-241", "lei");
		spellPut("130-242", "yong");
		spellPut("130-243", "zao,cao");
		spellPut("130-244", "zong");
		spellPut("130-245", "peng");
		spellPut("130-246", "song");
		spellPut("130-247", "chuan,zhuan");
		spellPut("130-248", "yu");
		spellPut("130-249", "zhai");
		spellPut("130-250", "qi,cou");
		spellPut("130-251", "shang");
		spellPut("130-252", "chuang");
		spellPut("130-253", "jing");
		spellPut("130-254", "han");
	}

	private static void init2() {
		spellPut("131-64", "zhang");
		spellPut("131-65", "qing");
		spellPut("131-66", "yan");
		spellPut("131-67", "di");
		spellPut("131-68", "xie");
		spellPut("131-69", "lv,lou");
		spellPut("131-70", "bei");
		spellPut("131-71", "piao,biao");
		spellPut("131-72", "jin");
		spellPut("131-73", "lian");
		spellPut("131-74", "lu");
		spellPut("131-75", "man");
		spellPut("131-76", "qian");
		spellPut("131-77", "xian");
		spellPut("131-78", "tan");
		spellPut("131-79", "ying");
		spellPut("131-80", "dong");
		spellPut("131-81", "zhuan");
		spellPut("131-82", "shan");
		spellPut("131-83", "qiao");
		spellPut("131-84", "jiong");
		spellPut("131-85", "tui");
		spellPut("131-86", "zun");
		spellPut("131-87", "pu");
		spellPut("131-88", "lao");
		spellPut("131-89", "chang");
		spellPut("131-90", "guang");
		spellPut("131-91", "qi");
		spellPut("131-92", "cheng,deng");
		spellPut("131-93", "zhan,zhuan,chan");
		spellPut("131-94", "wei");
		spellPut("131-95", "ji");
		spellPut("131-96", "bo");
		spellPut("131-97", "hui");
		spellPut("131-98", "chuan");
		spellPut("131-99", "tie,jian");
		spellPut("131-100", "dan");
		spellPut("131-101", "jiao,yao");
		spellPut("131-102", "fen");
		spellPut("131-103", "xian");
		spellPut("131-104", "yu,ju");
		spellPut("131-105", "e,wu");
		spellPut("131-106", "lin");
		spellPut("131-107", "bo");
		spellPut("131-108", "gu");
		spellPut("131-109", "xian");
		spellPut("131-110", "xian");
		spellPut("131-111", "min");
		spellPut("131-112", "ye");
		spellPut("131-113", "jin");
		spellPut("131-114", "jia,jie");
		spellPut("131-115", "qiao");
		spellPut("131-116", "feng");
		spellPut("131-117", "zhou");
		spellPut("131-118", "ai");
		spellPut("131-119", "sai");
		spellPut("131-120", "yi");
		spellPut("131-121", "jun");
		spellPut("131-122", "nong");
		spellPut("131-123", "chan,tan,shan");
		spellPut("131-124", "yi");
		spellPut("131-125", "dang");
		spellPut("131-126", "kuai");
		spellPut("131-128", "jian");
		spellPut("131-129", "chu");
		spellPut("131-130", "jiao");
		spellPut("131-131", "sha");
		spellPut("131-132", "zai");
		spellPut("131-133", "cBn");
		spellPut("131-134", "bin");
		spellPut("131-135", "an");
		spellPut("131-136", "tai");
		spellPut("131-137", "chou");
		spellPut("131-138", "chai");
		spellPut("131-139", "lan");
		spellPut("131-140", "ni,yi");
		spellPut("131-141", "jin");
		spellPut("131-142", "qian");
		spellPut("131-143", "meng");
		spellPut("131-144", "wu");
		spellPut("131-145", "ning");
		spellPut("131-146", "qiong");
		spellPut("131-147", "ni");
		spellPut("131-148", "chang");
		spellPut("131-149", "lie");
		spellPut("131-150", "lv");
		spellPut("131-151", "kuang");
		spellPut("131-152", "bao");
		spellPut("131-153", "yu");
		spellPut("131-154", "biao");
		spellPut("131-155", "zan");
		spellPut("131-156", "zhi");
		spellPut("131-157", "si");
		spellPut("131-158", "you");
		spellPut("131-159", "hao");
		spellPut("131-160", "qing");
		spellPut("131-161", "chen");
		spellPut("131-162", "li");
		spellPut("131-163", "teng");
		spellPut("131-164", "wei");
		spellPut("131-165", "long");
		spellPut("131-166", "chu");
		spellPut("131-167", "chan");
		spellPut("131-168", "rang,xiang");
		spellPut("131-169", "shu");
		spellPut("131-170", "hui,xie");
		spellPut("131-171", "li");
		spellPut("131-172", "luo");
		spellPut("131-173", "zan");
		spellPut("131-174", "nuo");
		spellPut("131-175", "tang");
		spellPut("131-176", "yan");
		spellPut("131-177", "lei");
		spellPut("131-178", "nang");
		spellPut("131-179", "zan");
		spellPut("131-180", "xiong");
		spellPut("131-181", "dui,rui,yue");
		spellPut("131-182", "dui,rui,yue");
		spellPut("131-183", "tu");
		spellPut("131-184", "chang,zhang");
		spellPut("131-185", "er");
		spellPut("131-186", "er");
		spellPut("131-187", "jin");
		spellPut("131-188", "yan");
		spellPut("131-189", "shi");
		spellPut("131-190", "shike");
		spellPut("131-191", "qiBnke");
		spellPut("131-192", "gongfen");
		spellPut("131-193", "hBoke");
		spellPut("131-194", "shen");
		spellPut("131-195", "dou");
		spellPut("131-196", "bBike");
		spellPut("131-197", "gongli");
		spellPut("131-198", "huang");
		spellPut("131-199", "wang");
		spellPut("131-200", "nei");
		spellPut("131-201", "liang");
		spellPut("131-202", "yu,shu");
		spellPut("131-203", "hBn");
		spellPut("131-204", "tian");
		spellPut("131-205", "bun");
		spellPut("131-206", "ji");
		spellPut("131-207", "yi");
		spellPut("131-208", "mao");
		spellPut("131-209", "ran");
		spellPut("131-210", "yuan");
		spellPut("131-211", "mao");
		spellPut("131-212", "ce");
		spellPut("131-213", "jiong");
		spellPut("131-214", "gua");
		spellPut("131-215", "jiong");
		spellPut("131-216", "mao");
		spellPut("131-217", "zhou");
		spellPut("131-218", "gou");
		spellPut("131-219", "xu");
		spellPut("131-220", "yin,you");
		spellPut("131-221", "kan");
		spellPut("131-222", "yi");
		spellPut("131-223", "shen");
		spellPut("131-224", "shi");
		spellPut("131-225", "meng");
		spellPut("131-226", "zui");
		spellPut("131-227", "kou");
		spellPut("131-228", "lin");
		spellPut("131-229", "fu");
		spellPut("131-230", "xie");
		spellPut("131-231", "mi");
		spellPut("131-232", "tai");
		spellPut("131-233", "gang");
		spellPut("131-234", "ya");
		spellPut("131-235", "pan");
		spellPut("131-236", "fa");
		spellPut("131-237", "min");
		spellPut("131-238", "qia");
		spellPut("131-239", "jian");
		spellPut("131-240", "sou");
		spellPut("131-241", "mei");
		spellPut("131-242", "tu");
		spellPut("131-243", "gu");
		spellPut("131-244", "jing,cheng");
		spellPut("131-245", "qing");
		spellPut("131-246", "dong");
		spellPut("131-247", "gan");
		spellPut("131-248", "yin");
		spellPut("131-249", "ai");
		spellPut("131-250", "li");
		spellPut("131-251", "cang");
		spellPut("131-252", "ming");
		spellPut("131-253", "zhun");
		spellPut("131-254", "cui");
	}

	private static void init3() {
		spellPut("132-64", "si");
		spellPut("132-65", "duo");
		spellPut("132-66", "jin");
		spellPut("132-67", "lin");
		spellPut("132-68", "xi");
		spellPut("132-69", "du");
		spellPut("132-70", "fan");
		spellPut("132-71", "fan");
		spellPut("132-72", "ju");
		spellPut("132-73", "chu");
		spellPut("132-74", "yi kB,yi kB no bo li,tB ko");
		spellPut("132-75", "feng");
		spellPut("132-76", "ko ga la xi");
		spellPut("132-77", "na gi");
		spellPut("132-78", "feng");
		spellPut("132-79", "feng");
		spellPut("132-80", "kai");
		spellPut("132-81", "gan");
		spellPut("132-82", "ping");
		spellPut("132-83", "kuai");
		spellPut("132-84", "han");
		spellPut("132-85", "ren");
		spellPut("132-86", "chuang");
		spellPut("132-87", "ji");
		spellPut("132-88", "qian");
		spellPut("132-89", "cun");
		spellPut("132-90", "ji");
		spellPut("132-91", "dan");
		spellPut("132-92", "wan");
		spellPut("132-93", "jue");
		spellPut("132-94", "li");
		spellPut("132-95", "fu");
		spellPut("132-96", "qu");
		spellPut("132-97", "diao");
		spellPut("132-98", "min");
		spellPut("132-99", "ling");
		spellPut("132-100", "zhong");
		spellPut("132-101", "bie");
		spellPut("132-102", "jie");
		spellPut("132-103", "jie");
		spellPut("132-104", "shan");
		spellPut("132-105", "chan");
		spellPut("132-106", "geng");
		spellPut("132-107", "chuang");
		spellPut("132-108", "kui");
		spellPut("132-109", "duo");
		spellPut("132-110", "er");
		spellPut("132-111", "jie");
		spellPut("132-112", "ci");
		spellPut("132-113", "jing");
		spellPut("132-114", "dou");
		spellPut("132-115", "luo");
		spellPut("132-116", "ze");
		spellPut("132-117", "yuan");
		spellPut("132-118", "cuo");
		spellPut("132-119", "kei,ke");
		spellPut("132-120", "cha,sha");
		spellPut("132-121", "chuang");
		spellPut("132-122", "cuo");
		spellPut("132-123", "li");
		spellPut("132-124", "fei");
		spellPut("132-125", "chan");
		spellPut("132-126", "qi");
		spellPut("132-128", "chuang");
		spellPut("132-129", "zi");
		spellPut("132-130", "gang");
		spellPut("132-131", "bao,bo");
		spellPut("132-132", "duo");
		spellPut("132-133", "qing");
		spellPut("132-134", "du,zhuo");
		spellPut("132-135", "jian");
		spellPut("132-136", "ji");
		spellPut("132-137", "yBn");
		spellPut("132-138", "huo");
		spellPut("132-139", "duo");
		spellPut("132-140", "zhi,duan");
		spellPut("132-141", "wu");
		spellPut("132-142", "gua");
		spellPut("132-143", "sheng");
		spellPut("132-144", "jian");
		spellPut("132-145", "da,zha");
		spellPut("132-146", "kai");
		spellPut("132-147", "chuang");
		spellPut("132-148", "chuan");
		spellPut("132-149", "chan");
		spellPut("132-150", "tuan,zhuan");
		spellPut("132-151", "lu,jiu");
		spellPut("132-152", "li");
		spellPut("132-153", "peng");
		spellPut("132-154", "shan");
		spellPut("132-155", "kou");
		spellPut("132-156", "gua");
		spellPut("132-157", "hua");
		spellPut("132-158", "zha");
		spellPut("132-159", "zhuo");
		spellPut("132-160", "lian");
		spellPut("132-161", "ju");
		spellPut("132-162", "liu");
		spellPut("132-163", "gui");
		spellPut("132-164", "jiao,chao");
		spellPut("132-165", "gui");
		spellPut("132-166", "jian");
		spellPut("132-167", "jian");
		spellPut("132-168", "tang");
		spellPut("132-169", "ji");
		spellPut("132-170", "jian");
		spellPut("132-171", "jian");
		spellPut("132-172", "zhi");
		spellPut("132-173", "chan");
		spellPut("132-174", "zuan");
		spellPut("132-175", "mo");
		spellPut("132-176", "li");
		spellPut("132-177", "zhu");
		spellPut("132-178", "ya");
		spellPut("132-179", "jin,jing");
		spellPut("132-180", "keng");
		spellPut("132-181", "xie,lie");
		spellPut("132-182", "zhi");
		spellPut("132-183", "yi");
		spellPut("132-184", "zhu");
		spellPut("132-185", "miao");
		spellPut("132-186", "lao");
		spellPut("132-187", "juan");
		spellPut("132-188", "kou");
		spellPut("132-189", "yang");
		spellPut("132-190", "wa");
		spellPut("132-191", "xiao");
		spellPut("132-192", "mou");
		spellPut("132-193", "kuang");
		spellPut("132-194", "jie");
		spellPut("132-195", "lie");
		spellPut("132-196", "ke");
		spellPut("132-197", "jin,jing");
		spellPut("132-198", "gao");
		spellPut("132-199", "min");
		spellPut("132-200", "chi");
		spellPut("132-201", "lang");
		spellPut("132-202", "yong");
		spellPut("132-203", "ke");
		spellPut("132-204", "juan");
		spellPut("132-205", "qing");
		spellPut("132-206", "lu");
		spellPut("132-207", "bu");
		spellPut("132-208", "chi");
		spellPut("132-209", "kai");
		spellPut("132-210", "mian");
		spellPut("132-211", "dong");
		spellPut("132-212", "xu");
		spellPut("132-213", "wu");
		spellPut("132-214", "yi");
		spellPut("132-215", "xun");
		spellPut("132-216", "weng,yang");
		spellPut("132-217", "sheng");
		spellPut("132-218", "lao");
		spellPut("132-219", "lu");
		spellPut("132-220", "piao");
		spellPut("132-221", "shi");
		spellPut("132-222", "ji");
		spellPut("132-223", "jiang");
		spellPut("132-224", "jiao,chao");
		spellPut("132-225", "quan");
		spellPut("132-226", "xiang");
		spellPut("132-227", "yi");
		spellPut("132-228", "qiao");
		spellPut("132-229", "fan");
		spellPut("132-230", "juan");
		spellPut("132-231", "tong,dong");
		spellPut("132-232", "ju");
		spellPut("132-233", "dan");
		spellPut("132-234", "mai");
		spellPut("132-235", "xun");
		spellPut("132-236", "xun");
		spellPut("132-237", "lv");
		spellPut("132-238", "li");
		spellPut("132-239", "che");
		spellPut("132-240", "rang,xiang");
		spellPut("132-241", "quan");
		spellPut("132-242", "yun");
		spellPut("132-243", "jiu");
		spellPut("132-244", "bao");
		spellPut("132-245", "mo ne me");
		spellPut("132-246", "xiong");
		spellPut("132-247", "gai");
		spellPut("132-248", "gai");
		spellPut("132-249", "yi");
		spellPut("132-250", "peng");
		spellPut("132-251", "ju");
		spellPut("132-252", "tao,yao");
		spellPut("132-253", "ge");
		spellPut("132-254", "e");
	}

	private static void init4() {
		spellPut("133-64", "gong");
		spellPut("133-65", "da");
		spellPut("133-66", "jiu");
		spellPut("133-67", "gong");
		spellPut("133-68", "nao");
		spellPut("133-69", "jiu");
		spellPut("133-70", "yi");
		spellPut("133-71", "jiang");
		spellPut("133-72", "kang");
		spellPut("133-73", "hu");
		spellPut("133-74", "qu");
		spellPut("133-75", "fan");
		spellPut("133-76", "qie");
		spellPut("133-77", "zang,cang");
		spellPut("133-78", "kuang");
		spellPut("133-79", "hu");
		spellPut("133-80", "yu");
		spellPut("133-81", "gui");
		spellPut("133-82", "hui");
		spellPut("133-83", "dan");
		spellPut("133-84", "kui,gui");
		spellPut("133-85", "lian");
		spellPut("133-86", "lian");
		spellPut("133-87", "suan");
		spellPut("133-88", "du");
		spellPut("133-89", "jiu");
		spellPut("133-90", "jue");
		spellPut("133-91", "xi");
		spellPut("133-92", "ke,qia");
		spellPut("133-93", "yan");
		spellPut("133-94", "qu,ou");
		spellPut("133-95", "xun");
		spellPut("133-96", "nian");
		spellPut("133-97", "zu");
		spellPut("133-98", "shi");
		spellPut("133-99", "xi");
		spellPut("133-100", "wan");
		spellPut("133-101", "wan");
		spellPut("133-102", "xie");
		spellPut("133-103", "dan");
		spellPut("133-104", "ji");
		spellPut("133-105", "shuai,lv");
		spellPut("133-106", "guan,kuang");
		spellPut("133-107", "xi");
		spellPut("133-108", "xie");
		spellPut("133-109", "jie");
		spellPut("133-110", "yang,ang");
		spellPut("133-111", "qiong");
		spellPut("133-112", "shao");
		spellPut("133-113", "chi");
		spellPut("133-114", "xu");
		spellPut("133-115", "que");
		spellPut("133-116", "wu");
		spellPut("133-117", "ji");
		spellPut("133-118", "e");
		spellPut("133-119", "xi");
		spellPut("133-120", "san");
		spellPut("133-121", "wei");
		spellPut("133-122", "zhe,zhai");
		spellPut("133-123", "han,an");
		spellPut("133-124", "ya");
		spellPut("133-125", "di");
		spellPut("133-126", "zha,zhai");
		spellPut("133-128", "pang");
		spellPut("133-129", "B e si");
		spellPut("133-130", "qie");
		spellPut("133-131", "ya");
		spellPut("133-132", "zhi,shi");
		spellPut("133-133", "mang");
		spellPut("133-134", "ti");
		spellPut("133-135", "she");
		spellPut("133-136", "ting");
		spellPut("133-137", "zui");
		spellPut("133-138", "fei");
		spellPut("133-139", "ce");
		spellPut("133-140", "yuan");
		spellPut("133-141", "li");
		spellPut("133-142", "dian");
		spellPut("133-143", "jin");
		spellPut("133-144", "ao");
		spellPut("133-145", "gui");
		spellPut("133-146", "yan");
		spellPut("133-147", "li");
		spellPut("133-148", "chang");
		spellPut("133-149", "qian,lan");
		spellPut("133-150", "li");
		spellPut("133-151", "yan");
		spellPut("133-152", "yan");
		spellPut("133-153", "yuan");
		spellPut("133-154", "gong,hong");
		spellPut("133-155", "lin,miao");
		spellPut("133-156", "rou,qiu");
		spellPut("133-157", "qu");
		spellPut("133-158", "ke wu mu");
		spellPut("133-159", "lei");
		spellPut("133-160", "du");
		spellPut("133-161", "zhuan");
		spellPut("133-162", "can,shen,cen,san");
		spellPut("133-163", "can,shen,cen,san");
		spellPut("133-164", "can,shen,cen,san");
		spellPut("133-165", "ai,yi");
		spellPut("133-166", "dai");
		spellPut("133-167", "shou");
		spellPut("133-168", "guai");
		spellPut("133-169", "ba");
		spellPut("133-170", "ruo");
		spellPut("133-171", "li");
		spellPut("133-172", "zhuo,yi,li,jue");
		spellPut("133-173", "jia");
		spellPut("133-174", "sou");
		spellPut("133-175", "ji");
		spellPut("133-176", "wei,yu");
		spellPut("133-177", "rui");
		spellPut("133-178", "cong");
		spellPut("133-179", "gua");
		spellPut("133-180", "qiu");
		spellPut("133-181", "chi");
		spellPut("133-182", "du ge");
		spellPut("133-183", "hong");
		spellPut("133-184", "mie");
		spellPut("133-185", "mang");
		spellPut("133-186", "xuan,song");
		spellPut("133-187", "zi");
		spellPut("133-188", "dou,cun");
		spellPut("133-189", "ye");
		spellPut("133-190", "ou");
		spellPut("133-191", "huo");
		spellPut("133-192", "yi");
		spellPut("133-193", "chou");
		spellPut("133-194", "qin");
		spellPut("133-195", "jie,ge");
		spellPut("133-196", "bu");
		spellPut("133-197", "e,hua");
		spellPut("133-198", "hong");
		spellPut("133-199", "wu");
		spellPut("133-200", "na,ne");
		spellPut("133-201", "xue,chuo,jue");
		spellPut("133-202", "dou,ru");
		spellPut("133-203", "hou,hong,ou");
		spellPut("133-204", "gBo");
		spellPut("133-205", "jun");
		spellPut("133-206", "lv");
		spellPut("133-207", "ge");
		spellPut("133-208", "wen");
		spellPut("133-209", "qi");
		spellPut("133-210", "wu");
		spellPut("133-211", "jiao");
		spellPut("133-212", "hong");
		spellPut("133-213", "chi");
		spellPut("133-214", "sheng");
		spellPut("133-215", "tun,tian");
		spellPut("133-216", "hua,qi");
		spellPut("133-217", "e");
		spellPut("133-218", "shi");
		spellPut("133-219", "juan");
		spellPut("133-220", "pen");
		spellPut("133-221", "wen,min");
		spellPut("133-222", "mou,m");
		spellPut("133-223", "ran");
		spellPut("133-224", "di");
		spellPut("133-225", "shi");
		spellPut("133-226", "zhou");
		spellPut("133-227", "tie,che");
		spellPut("133-228", "xi");
		spellPut("133-229", "yi");
		spellPut("133-230", "qi,zhi");
		spellPut("133-231", "ping");
		spellPut("133-232", "zi,ci");
		spellPut("133-233", "xu,hou,gou");
		spellPut("133-234", "yi");
		spellPut("133-235", "xiao,hao");
		spellPut("133-236", "da,dan");
		spellPut("133-237", "qu");
		spellPut("133-238", "xian,gan");
		spellPut("133-239", "tuo");
		spellPut("133-240", "pou");
		spellPut("133-241", "bi");
		spellPut("133-242", "fu");
		spellPut("133-243", "yang");
		spellPut("133-244", "he");
		spellPut("133-245", "hai");
		spellPut("133-246", "da");
		spellPut("133-247", "wa");
		spellPut("133-248", "zuo");
		spellPut("133-249", "bu");
		spellPut("133-250", "tuo");
		spellPut("133-251", "xiBn");
		spellPut("133-252", "huo");
		spellPut("133-253", "qi");
		spellPut("133-254", "er");
	}

	private static void init5() {
		spellPut("134-64", "e");
		spellPut("134-65", "die,xi");
		spellPut("134-66", "zhou");
		spellPut("134-67", "shu,xun");
		spellPut("134-68", "xiao");
		spellPut("134-69", "kua");
		spellPut("134-70", "huai,shi");
		spellPut("134-71", "tao");
		spellPut("134-72", "e,an");
		spellPut("134-73", "xuan");
		spellPut("134-74", "wai,he,wo,wa,gua,guo");
		spellPut("134-75", "lao");
		spellPut("134-76", "tong");
		spellPut("134-77", "xiong");
		spellPut("134-78", "you");
		spellPut("134-79", "die,di");
		spellPut("134-80", "nian");
		spellPut("134-81", "xing");
		spellPut("134-82", "po pu ni");
		spellPut("134-83", "hao");
		spellPut("134-84", "yuan,yun");
		spellPut("134-85", "long");
		spellPut("134-86", "pou");
		spellPut("134-87", "mang");
		spellPut("134-88", "zu");
		spellPut("134-89", "he");
		spellPut("134-90", "xian");
		spellPut("134-91", "lao");
		spellPut("134-92", "po,ba,bo");
		spellPut("134-93", "liang,lang");
		spellPut("134-94", "ba");
		spellPut("134-95", "mie");
		spellPut("134-96", "lie,lv");
		spellPut("134-97", "sui");
		spellPut("134-98", "fu");
		spellPut("134-99", "han");
		spellPut("134-100", "chuo,yue");
		spellPut("134-101", "you");
		spellPut("134-102", "gu");
		spellPut("134-103", "gu");
		spellPut("134-104", "bei,bai");
		spellPut("134-105", "han");
		spellPut("134-106", "yi");
		spellPut("134-107", "jia,qian");
		spellPut("134-108", "tu");
		spellPut("134-109", "dan,xian,yan");
		spellPut("134-110", "wan");
		spellPut("134-111", "li");
		spellPut("134-112", "qiu");
		spellPut("134-113", "che");
		spellPut("134-114", "zao");
		spellPut("134-115", "ya");
		spellPut("134-116", "dou");
		spellPut("134-117", "qi");
		spellPut("134-118", "di");
		spellPut("134-119", "qin");
		spellPut("134-120", "mB si");
		spellPut("134-121", "gong,hong");
		spellPut("134-122", "dou");
		spellPut("134-123", "ge xi");
		spellPut("134-124", "liang");
		spellPut("134-125", "leng");
		spellPut("134-126", "sha,shB");
		spellPut("134-128", "zu");
		spellPut("134-129", "wo,wei");
		spellPut("134-130", "jin,yin");
		spellPut("134-131", "qi");
		spellPut("134-132", "er,wa");
		spellPut("134-133", "qiang");
		spellPut("134-134", "an");
		spellPut("134-135", "jie,ze,zuo");
		spellPut("134-136", "nian");
		spellPut("134-137", "yu");
		spellPut("134-138", "tian");
		spellPut("134-139", "lai");
		spellPut("134-140", "xi");
		spellPut("134-141", "ai");
		spellPut("134-142", "gou");
		spellPut("134-143", "zhuo,zhao");
		spellPut("134-144", "di");
		spellPut("134-145", "heng");
		spellPut("134-146", "cai");
		spellPut("134-147", "qiang");
		spellPut("134-148", "zhun,tun,xiang,dui");
		spellPut("134-149", "wu");
		spellPut("134-150", "wen");
		spellPut("134-151", "sha,jie,die,ti");
		spellPut("134-152", "gu");
		spellPut("134-153", "qi");
		spellPut("134-154", "qi");
		spellPut("134-155", "dan");
		spellPut("134-156", "yue,wa");
		spellPut("134-157", "zi,ci");
		spellPut("134-158", "bi,tu");
		spellPut("134-159", "cui");
		spellPut("134-160", "he");
		spellPut("134-161", "ya");
		spellPut("134-162", "qi");
		spellPut("134-163", "zhe");
		spellPut("134-164", "liang");
		spellPut("134-165", "xian");
		spellPut("134-166", "qing,ying");
		spellPut("134-167", "gua");
		spellPut("134-168", "ze,shi");
		spellPut("134-169", "guo");
		spellPut("134-170", "luo");
		spellPut("134-171", "yan");
		spellPut("134-172", "di");
		spellPut("134-173", "quan");
		spellPut("134-174", "tan,chan,tuo");
		spellPut("134-175", "ju");
		spellPut("134-176", "tang");
		spellPut("134-177", "an");
		spellPut("134-178", "dan");
		spellPut("134-179", "yu");
		spellPut("134-180", "zhe");
		spellPut("134-181", "zhou");
		spellPut("134-182", "chai");
		spellPut("134-183", "wai");
		spellPut("134-184", "huo,guo,xu");
		spellPut("134-185", "zan,za,zBn");
		spellPut("134-186", "yao");
		spellPut("134-187", "mian");
		spellPut("134-188", "hu");
		spellPut("134-189", "yun");
		spellPut("134-190", "huan");
		spellPut("134-191", "huan,yuan,xuan,he");
		spellPut("134-192", "ji");
		spellPut("134-193", "zhong,chuang");
		spellPut("134-194", "wei");
		spellPut("134-195", "sha");
		spellPut("134-196", "xu");
		spellPut("134-197", "huang");
		spellPut("134-198", "duo,zha");
		spellPut("134-199", "yan");
		spellPut("134-200", "liang");
		spellPut("134-201", "yu");
		spellPut("134-202", "sang");
		spellPut("134-203", "chi");
		spellPut("134-204", "qiao,jiao");
		spellPut("134-205", "yan");
		spellPut("134-206", "dan,shan,chan");
		spellPut("134-207", "pen,ben");
		spellPut("134-208", "can,sun,qi");
		spellPut("134-209", "yo");
		spellPut("134-210", "wei");
		spellPut("134-211", "ying");
		spellPut("134-212", "pBo xi");
		spellPut("134-213", "xi");
		spellPut("134-214", "jie");
		spellPut("134-215", "zao,qiao");
		spellPut("134-216", "hu");
		spellPut("134-217", "ti");
		spellPut("134-218", "yao");
		spellPut("134-219", "he,xiao,hu");
		spellPut("134-220", "qiang");
		spellPut("134-221", "se");
		spellPut("134-222", "yong");
		spellPut("134-223", "gong,hong");
		spellPut("134-224", "xie");
		spellPut("134-225", "ma,mB");
		spellPut("134-226", "chB");
		spellPut("134-227", "hai");
		spellPut("134-228", "ru");
		spellPut("134-229", "wa,gu");
		spellPut("134-230", "ji");
		spellPut("134-231", "beng,pang");
		spellPut("134-232", "wu");
		spellPut("134-233", "xian,qian,qie");
		spellPut("134-234", "zi");
		spellPut("134-235", "lao");
		spellPut("134-236", "wa");
		spellPut("134-237", "jia lun");
		spellPut("134-238", "suo");
		spellPut("134-239", "zi");
		spellPut("134-240", "sBi");
		spellPut("134-241", "ge");
		spellPut("134-242", "na");
		spellPut("134-243", "qiang");
		spellPut("134-244", "bi");
		spellPut("134-245", "ao");
		spellPut("134-246", "lian");
		spellPut("134-247", "zui,sui");
		spellPut("134-248", "zhe,zhu");
		spellPut("134-249", "mo");
		spellPut("134-250", "tan");
		spellPut("134-251", "jiao");
		spellPut("134-252", "chong");
		spellPut("134-253", "jiao,dao");
		spellPut("134-254", "kai,ge");
	}

	private static void init6() {
		spellPut("135-64", "tan");
		spellPut("135-65", "shan,can");
		spellPut("135-66", "ai");
		spellPut("135-67", "xiao");
		spellPut("135-68", "lou");
		spellPut("135-69", "xiao,jiao");
		spellPut("135-70", "hu");
		spellPut("135-71", "hui");
		spellPut("135-72", "guo");
		spellPut("135-73", "ou");
		spellPut("135-74", "xian");
		spellPut("135-75", "ze");
		spellPut("135-76", "chang");
		spellPut("135-77", "po");
		spellPut("135-78", "de,dei");
		spellPut("135-79", "ma");
		spellPut("135-80", "hu");
		spellPut("135-81", "ga");
		spellPut("135-82", "tang");
		spellPut("135-83", "ye");
		spellPut("135-84", "sai");
		spellPut("135-85", "jiao");
		spellPut("135-86", "xiao");
		spellPut("135-87", "hua");
		spellPut("135-88", "mai");
		spellPut("135-89", "ran");
		spellPut("135-90", "lao");
		spellPut("135-91", "xiao");
		spellPut("135-92", "ji");
		spellPut("135-93", "kui");
		spellPut("135-94", "xiao");
		spellPut("135-95", "hao");
		spellPut("135-96", "fu,?");
		spellPut("135-97", "qiao");
		spellPut("135-98", "chu,xu,shou");
		spellPut("135-99", "tan,chan");
		spellPut("135-100", "dan,tan");
		spellPut("135-101", "xun");
		spellPut("135-102", "e");
		spellPut("135-103", "zun");
		spellPut("135-104", "fan,bo");
		spellPut("135-105", "chi");
		spellPut("135-106", "hui");
		spellPut("135-107", "zan");
		spellPut("135-108", "chuang");
		spellPut("135-109", "cu,za,he");
		spellPut("135-110", "dan");
		spellPut("135-111", "jue");
		spellPut("135-112", "tun,kuo");
		spellPut("135-113", "xi");
		spellPut("135-114", "qi");
		spellPut("135-115", "hao");
		spellPut("135-116", "lian");
		spellPut("135-117", "xu,shi");
		spellPut("135-118", "hui");
		spellPut("135-119", "yin");
		spellPut("135-120", "xun");
		spellPut("135-121", "nie");
		spellPut("135-122", "si");
		spellPut("135-123", "yan");
		spellPut("135-124", "ying");
		spellPut("135-125", "da");
		spellPut("135-126", "zhan");
		spellPut("135-128", "zhou,zhuo");
		spellPut("135-129", "nong");
		spellPut("135-130", "yue,hui");
		spellPut("135-131", "xie");
		spellPut("135-132", "jiao,qiao,chi");
		spellPut("135-133", "yuan");
		spellPut("135-134", "ai");
		spellPut("135-135", "yong");
		spellPut("135-136", "kuai");
		spellPut("135-137", "yu");
		spellPut("135-138", "pen");
		spellPut("135-139", "dao");
		spellPut("135-140", "xin,hen");
		spellPut("135-141", "dun");
		spellPut("135-142", "dang");
		spellPut("135-143", "hB nB xi");
		spellPut("135-144", "pi");
		spellPut("135-145", "yin");
		spellPut("135-146", "zui");
		spellPut("135-147", "ning");
		spellPut("135-148", "di");
		spellPut("135-149", "lan");
		spellPut("135-150", "ta");
		spellPut("135-151", "huo,o");
		spellPut("135-152", "he,xia");
		spellPut("135-153", "yan");
		spellPut("135-154", "duo");
		spellPut("135-155", "xiu,pi");
		spellPut("135-156", "zhou,chou");
		spellPut("135-157", "ji,jie,zhai");
		spellPut("135-158", "jin");
		spellPut("135-159", "chang");
		spellPut("135-160", "xun");
		spellPut("135-161", "me");
		spellPut("135-162", "ti");
		spellPut("135-163", "lu");
		spellPut("135-164", "hui");
		spellPut("135-165", "bo,pao,bao");
		spellPut("135-166", "you");
		spellPut("135-167", "nie");
		spellPut("135-168", "yin");
		spellPut("135-169", "hu");
		spellPut("135-170", "mei,me,mo");
		spellPut("135-171", "hong");
		spellPut("135-172", "zhe");
		spellPut("135-173", "li");
		spellPut("135-174", "liu");
		spellPut("135-175", "xie,hai");
		spellPut("135-176", "nang");
		spellPut("135-177", "mo");
		spellPut("135-178", "yan");
		spellPut("135-179", "li");
		spellPut("135-180", "lu");
		spellPut("135-181", "long");
		spellPut("135-182", "po");
		spellPut("135-183", "dan");
		spellPut("135-184", "chen");
		spellPut("135-185", "pin");
		spellPut("135-186", "pi");
		spellPut("135-187", "xiang");
		spellPut("135-188", "me");
		spellPut("135-189", "xi");
		spellPut("135-190", "duo");
		spellPut("135-191", "ku");
		spellPut("135-192", "yan");
		spellPut("135-193", "chan");
		spellPut("135-194", "ying");
		spellPut("135-195", "di mi");
		spellPut("135-196", "la");
		spellPut("135-197", "ta");
		spellPut("135-198", "xiao");
		spellPut("135-199", "chuo");
		spellPut("135-200", "huan");
		spellPut("135-201", "huo");
		spellPut("135-202", "zhuan");
		spellPut("135-203", "nie");
		spellPut("135-204", "xiao");
		spellPut("135-205", "za,ca");
		spellPut("135-206", "li");
		spellPut("135-207", "chan");
		spellPut("135-208", "chai");
		spellPut("135-209", "li");
		spellPut("135-210", "yi");
		spellPut("135-211", "luo");
		spellPut("135-212", "za,zan,can");
		spellPut("135-213", "su");
		spellPut("135-214", "xi");
		spellPut("135-215", "zeng");
		spellPut("135-216", "jian");
		spellPut("135-217", "yan,za,nie");
		spellPut("135-218", "zhu");
		spellPut("135-219", "lan");
		spellPut("135-220", "nie");
		spellPut("135-221", "rB mo");
		spellPut("135-222", "luo");
		spellPut("135-223", "hui");
		spellPut("135-224", "yin");
		spellPut("135-225", "nin");
		spellPut("135-226", "tuan");
		spellPut("135-227", "kang");
		spellPut("135-228", "yuan");
		spellPut("135-229", "jiong");
		spellPut("135-230", "pian");
		spellPut("135-231", "yun");
		spellPut("135-232", "cong");
		spellPut("135-233", "hui");
		spellPut("135-234", "e");
		spellPut("135-235", "guo");
		spellPut("135-236", "wei,tong");
		spellPut("135-237", "tu");
		spellPut("135-238", "guo");
		spellPut("135-239", "qun");
		spellPut("135-240", "ri");
		spellPut("135-241", "guo");
		spellPut("135-242", "tai");
		spellPut("135-243", "guo");
		spellPut("135-244", "yin");
		spellPut("135-245", "hun");
		spellPut("135-246", "han");
		spellPut("135-247", "lun");
		spellPut("135-248", "guo");
		spellPut("135-249", "chuan,chui");
		spellPut("135-250", "wei");
		spellPut("135-251", "yuan");
		spellPut("135-252", "quan,juan");
		spellPut("135-253", "ku");
		spellPut("135-254", "pu");
	}

	private static void init7() {
		spellPut("136-64", "yuan");
		spellPut("136-65", "yuan");
		spellPut("136-66", "ya");
		spellPut("136-67", "tuan");
		spellPut("136-68", "tu");
		spellPut("136-69", "tu");
		spellPut("136-70", "tuan");
		spellPut("136-71", "l<e");
		spellPut("136-72", "hui");
		spellPut("136-73", "yi");
		spellPut("136-74", "luan");
		spellPut("136-75", "luan");
		spellPut("136-76", "ya");
		spellPut("136-77", "tu");
		spellPut("136-78", "ting");
		spellPut("136-79", "pu");
		spellPut("136-80", "lu");
		spellPut("136-81", "kuBi");
		spellPut("136-82", "ya");
		spellPut("136-83", "yu,zhun");
		spellPut("136-84", "qian,su");
		spellPut("136-85", "qian");
		spellPut("136-86", "zhuo");
		spellPut("136-87", "dang");
		spellPut("136-88", "qia");
		spellPut("136-89", "xiB");
		spellPut("136-90", "shBn");
		spellPut("136-91", "nie");
		spellPut("136-92", "mo");
		spellPut("136-93", "jia");
		spellPut("136-94", "zhi");
		spellPut("136-95", "xun");
		spellPut("136-96", "yi");
		spellPut("136-97", "qin");
		spellPut("136-98", "mei,fen");
		spellPut("136-99", "rong,keng");
		spellPut("136-100", "tun,dun");
		spellPut("136-101", "ben,fen");
		spellPut("136-102", "bi");
		spellPut("136-103", "jing");
		spellPut("136-104", "di,lan");
		spellPut("136-105", "jing");
		spellPut("136-106", "ji");
		spellPut("136-107", "di");
		spellPut("136-108", "jing");
		spellPut("136-109", "pan,ban");
		spellPut("136-110", "tang");
		spellPut("136-111", "qu");
		spellPut("136-112", "zhi");
		spellPut("136-113", "gua");
		spellPut("136-114", "tai");
		spellPut("136-115", "jiong");
		spellPut("136-116", "yang");
		spellPut("136-117", "fo");
		spellPut("136-118", "lu");
		spellPut("136-119", "qiu");
		spellPut("136-120", "gou");
		spellPut("136-121", "xue");
		spellPut("136-122", "fa");
		spellPut("136-123", "ling");
		spellPut("136-124", "zhu");
		spellPut("136-125", "fu");
		spellPut("136-126", "hu");
		spellPut("136-128", "zhi");
		spellPut("136-129", "ao");
		spellPut("136-130", "dai");
		spellPut("136-131", "pao");
		spellPut("136-132", "min");
		spellPut("136-133", "ji");
		spellPut("136-134", "he");
		spellPut("136-135", "lv");
		spellPut("136-136", "ci");
		spellPut("136-137", "chi");
		spellPut("136-138", "yin");
		spellPut("136-139", "hou");
		spellPut("136-140", "dui");
		spellPut("136-141", "zhao");
		spellPut("136-142", "fu");
		spellPut("136-143", "guang");
		spellPut("136-144", "yao");
		spellPut("136-145", "duo");
		spellPut("136-146", "gui");
		spellPut("136-147", "cha");
		spellPut("136-148", "yang");
		spellPut("136-149", "xie");
		spellPut("136-150", "shou");
		spellPut("136-151", "bing");
		spellPut("136-152", "hong");
		spellPut("136-153", "dB");
		spellPut("136-154", "kB");
		spellPut("136-155", "dang");
		spellPut("136-156", "hBng");
		spellPut("136-157", "an");
		spellPut("136-158", "xing");
		spellPut("136-159", "xian");
		spellPut("136-160", "bang");
		spellPut("136-161", "pou,fu");
		spellPut("136-162", "ba");
		spellPut("136-163", "yi");
		spellPut("136-164", "yin");
		spellPut("136-165", "han");
		spellPut("136-166", "xu");
		spellPut("136-167", "chui");
		spellPut("136-168", "cen");
		spellPut("136-169", "beng,feng");
		spellPut("136-170", "di,fang");
		spellPut("136-171", "que,jue");
		spellPut("136-172", "yong");
		spellPut("136-173", "jun");
		spellPut("136-174", "xia,jia");
		spellPut("136-175", "di");
		spellPut("136-176", "lang");
		spellPut("136-177", "juan");
		spellPut("136-178", "qin,jin");
		spellPut("136-179", "zhe");
		spellPut("136-180", "lie");
		spellPut("136-181", "huB");
		spellPut("136-182", "bu");
		spellPut("136-183", "jiong");
		spellPut("136-184", "ye");
		spellPut("136-185", "di");
		spellPut("136-186", "ya");
		spellPut("136-187", "quan");
		spellPut("136-188", "sui,su");
		spellPut("136-189", "qing,zheng");
		spellPut("136-190", "wan");
		spellPut("136-191", "ju");
		spellPut("136-192", "lun");
		spellPut("136-193", "zheng,cheng");
		spellPut("136-194", "kong");
		spellPut("136-195", "chong,shang");
		spellPut("136-196", "dong");
		spellPut("136-197", "tan");
		spellPut("136-198", "cai");
		spellPut("136-199", "chu,tou");
		spellPut("136-200", "beng");
		spellPut("136-201", "xian,kan");
		spellPut("136-202", "duo");
		spellPut("136-203", "yi,shi");
		spellPut("136-204", "zhi");
		spellPut("136-205", "zhun");
		spellPut("136-206", "qi");
		spellPut("136-207", "ju");
		spellPut("136-208", "ni");
		spellPut("136-209", "ke");
		spellPut("136-210", "kun");
		spellPut("136-211", "ni");
		spellPut("136-212", "jian");
		spellPut("136-213", "gang");
		spellPut("136-214", "yu");
		spellPut("136-215", "e");
		spellPut("136-216", "gu");
		spellPut("136-217", "leng");
		spellPut("136-218", "fBng");
		spellPut("136-219", "ya");
		spellPut("136-220", "kun");
		spellPut("136-221", "an");
		spellPut("136-222", "shen");
		spellPut("136-223", "nao");
		spellPut("136-224", "tu");
		spellPut("136-225", "cheng");
		spellPut("136-226", "huan");
		spellPut("136-227", "bi");
		spellPut("136-228", "lian");
		spellPut("136-229", "guo");
		spellPut("136-230", "zhuan");
		spellPut("136-231", "bao");
		spellPut("136-232", "yu");
		spellPut("136-233", "mao,mou,wu");
		spellPut("136-234", "jie");
		spellPut("136-235", "ruan");
		spellPut("136-236", "e,ai,ye");
		spellPut("136-237", "geng");
		spellPut("136-238", "zong");
		spellPut("136-239", "yu");
		spellPut("136-240", "huang");
		spellPut("136-241", "e");
		spellPut("136-242", "yao");
		spellPut("136-243", "bao");
		spellPut("136-244", "ji");
		spellPut("136-245", "mei");
		spellPut("136-246", "chang");
		spellPut("136-247", "tuo");
		spellPut("136-248", "yin");
		spellPut("136-249", "feng");
		spellPut("136-250", "zhong");
		spellPut("136-251", "jie");
		spellPut("136-252", "jin");
		spellPut("136-253", "feng");
		spellPut("136-254", "gang");
	}

	private static void init8() {
		spellPut("137-64", "chuan");
		spellPut("137-65", "jian");
		spellPut("137-66", "ping");
		spellPut("137-67", "lei");
		spellPut("137-68", "jiang");
		spellPut("137-69", "huang");
		spellPut("137-70", "duan");
		spellPut("137-71", "wan");
		spellPut("137-72", "xuan");
		spellPut("137-73", "xi");
		spellPut("137-74", "ji");
		spellPut("137-75", "kuai");
		spellPut("137-76", "ying");
		spellPut("137-77", "yong");
		spellPut("137-78", "kai");
		spellPut("137-79", "su");
		spellPut("137-80", "shi");
		spellPut("137-81", "mi");
		spellPut("137-82", "weng");
		spellPut("137-83", "cheng");
		spellPut("137-84", "tu");
		spellPut("137-85", "que");
		spellPut("137-86", "zhong");
		spellPut("137-87", "li");
		spellPut("137-88", "peng");
		spellPut("137-89", "bang");
		spellPut("137-90", "zang");
		spellPut("137-91", "dui");
		spellPut("137-92", "tian");
		spellPut("137-93", "wu");
		spellPut("137-94", "zheng");
		spellPut("137-95", "xun");
		spellPut("137-96", "zhen");
		spellPut("137-97", "ai");
		spellPut("137-98", "gong");
		spellPut("137-99", "yan");
		spellPut("137-100", "xian");
		spellPut("137-101", "wen");
		spellPut("137-102", "xie");
		spellPut("137-103", "liu");
		spellPut("137-104", "hBi");
		spellPut("137-105", "lang");
		spellPut("137-106", "chang");
		spellPut("137-107", "peng");
		spellPut("137-108", "beng");
		spellPut("137-109", "chen");
		spellPut("137-110", "lu");
		spellPut("137-111", "lu");
		spellPut("137-112", "ou,qiu");
		spellPut("137-113", "qian,zan,jian");
		spellPut("137-114", "mei");
		spellPut("137-115", "mo");
		spellPut("137-116", "zhuan,tuan");
		spellPut("137-117", "shuang");
		spellPut("137-118", "lou");
		spellPut("137-119", "biao");
		spellPut("137-120", "qi");
		spellPut("137-121", "zhi,di");
		spellPut("137-122", "zhang");
		spellPut("137-123", "kan");
		spellPut("137-124", "dian");
		spellPut("137-125", "chen");
		spellPut("137-126", "zhi,zhuo");
		spellPut("137-128", "xi");
		spellPut("137-129", "guo");
		spellPut("137-130", "qiang");
		spellPut("137-131", "jin");
		spellPut("137-132", "di");
		spellPut("137-133", "cui");
		spellPut("137-134", "yan");
		spellPut("137-135", "ta");
		spellPut("137-136", "zeng");
		spellPut("137-137", "qian");
		spellPut("137-138", "wei");
		spellPut("137-139", "zhui");
		spellPut("137-140", "qiao");
		spellPut("137-141", "shan");
		spellPut("137-142", "shan");
		spellPut("137-143", "fa");
		spellPut("137-144", "pu");
		spellPut("137-145", "kuai,tui");
		spellPut("137-146", "tuan,dong");
		spellPut("137-147", "fan");
		spellPut("137-148", "qiao,que");
		spellPut("137-149", "dun");
		spellPut("137-150", "zun,dun");
		spellPut("137-151", "di");
		spellPut("137-152", "sheng");
		spellPut("137-153", "duo,hui");
		spellPut("137-154", "duo");
		spellPut("137-155", "tan");
		spellPut("137-156", "deng");
		spellPut("137-157", "wu");
		spellPut("137-158", "fen");
		spellPut("137-159", "huang");
		spellPut("137-160", "tan");
		spellPut("137-161", "da");
		spellPut("137-162", "ye");
		spellPut("137-163", "zhu");
		spellPut("137-164", "jiBn");
		spellPut("137-165", "ao");
		spellPut("137-166", "qiang");
		spellPut("137-167", "qiao,ao");
		spellPut("137-168", "ken");
		spellPut("137-169", "yi,tu");
		spellPut("137-170", "pi");
		spellPut("137-171", "dian");
		spellPut("137-172", "jiang");
		spellPut("137-173", "ye");
		spellPut("137-174", "xue,bo,jue");
		spellPut("137-175", "tan");
		spellPut("137-176", "lan");
		spellPut("137-177", "ju");
		spellPut("137-178", "huai");
		spellPut("137-179", "dang");
		spellPut("137-180", "rang");
		spellPut("137-181", "qian");
		spellPut("137-182", "xun");
		spellPut("137-183", "xian,lan");
		spellPut("137-184", "xi");
		spellPut("137-185", "ai");
		spellPut("137-186", "ya");
		spellPut("137-187", "dao");
		spellPut("137-188", "ruan");
		spellPut("137-189", "jin");
		spellPut("137-190", "lei");
		spellPut("137-191", "kuang");
		spellPut("137-192", "lu");
		spellPut("137-193", "yan");
		spellPut("137-194", "tan");
		spellPut("137-195", "wei");
		spellPut("137-196", "huai");
		spellPut("137-197", "long");
		spellPut("137-198", "long");
		spellPut("137-199", "rui");
		spellPut("137-200", "li");
		spellPut("137-201", "lin");
		spellPut("137-202", "chan");
		spellPut("137-203", "xun");
		spellPut("137-204", "yan");
		spellPut("137-205", "lei");
		spellPut("137-206", "ba");
		spellPut("137-207", "wan");
		spellPut("137-208", "sBn");
		spellPut("137-209", "zhuang");
		spellPut("137-210", "yi");
		spellPut("137-211", "mai");
		spellPut("137-212", "zhu");
		spellPut("137-213", "zhuang");
		spellPut("137-214", "hu");
		spellPut("137-215", "kun");
		spellPut("137-216", "hu");
		spellPut("137-217", "xu");
		spellPut("137-218", "kun");
		spellPut("137-219", "shou");
		spellPut("137-220", "mang");
		spellPut("137-221", "dun");
		spellPut("137-222", "shou");
		spellPut("137-223", "yi");
		spellPut("137-224", "gu,ying");
		spellPut("137-225", "jiang,xiang");
		spellPut("137-226", "feng,pang");
		spellPut("137-227", "zhai");
		spellPut("137-228", "bian");
		spellPut("137-229", "sui");
		spellPut("137-230", "qun");
		spellPut("137-231", "ling");
		spellPut("137-232", "cuo");
		spellPut("137-233", "xiong,xuan");
		spellPut("137-234", "xie");
		spellPut("137-235", "nao");
		spellPut("137-236", "xia");
		spellPut("137-237", "yuan,wan");
		spellPut("137-238", "mao,wan");
		spellPut("137-239", "duo");
		spellPut("137-240", "qing");
		spellPut("137-241", "yi xi");
		spellPut("137-242", "gou");
		spellPut("137-243", "qi");
		spellPut("137-244", "meng");
		spellPut("137-245", "meng");
		spellPut("137-246", "chen");
		spellPut("137-247", "ce");
		spellPut("137-248", "guai");
		spellPut("137-249", "gao");
		spellPut("137-250", "tao,ben");
		spellPut("137-251", "tai");
		spellPut("137-252", "yan,tao");
		spellPut("137-253", "bi");
		spellPut("137-254", "hua");
	}

	private static void init9() {
		spellPut("138-64", "yun");
		spellPut("138-65", "jia,ga,xia");
		spellPut("138-66", "ba");
		spellPut("138-67", "en");
		spellPut("138-68", "di,ti");
		spellPut("138-69", "pao");
		spellPut("138-70", "juan");
		spellPut("138-71", "xie");
		spellPut("138-72", "dian");
		spellPut("138-73", "quan,juan");
		spellPut("138-74", "huan");
		spellPut("138-75", "kai");
		spellPut("138-76", "she,chi,zha");
		spellPut("138-77", "ben");
		spellPut("138-78", "huang");
		spellPut("138-79", "fei");
		spellPut("138-80", "diao");
		spellPut("138-81", "xun,zhui");
		spellPut("138-82", "beng");
		spellPut("138-83", "ao");
		spellPut("138-84", "weng");
		spellPut("138-85", "po,ha,tai");
		spellPut("138-86", "wu");
		spellPut("138-87", "ao,yu");
		spellPut("138-88", "jiang");
		spellPut("138-89", "lian");
		spellPut("138-90", "duo");
		spellPut("138-91", "yun");
		spellPut("138-92", "jiang");
		spellPut("138-93", "shi");
		spellPut("138-94", "fen");
		spellPut("138-95", "huo");
		spellPut("138-96", "bi");
		spellPut("138-97", "luan");
		spellPut("138-98", "duo,che");
		spellPut("138-99", "ding,tian");
		spellPut("138-100", "qian");
		spellPut("138-101", "jiu");
		spellPut("138-102", "nuan");
		spellPut("138-103", "cha");
		spellPut("138-104", "xian");
		spellPut("138-105", "fan");
		spellPut("138-106", "ji");
		spellPut("138-107", "hong");
		spellPut("138-108", "dan");
		spellPut("138-109", "fu,you");
		spellPut("138-110", "jing");
		spellPut("138-111", "hai,jie");
		spellPut("138-112", "wen");
		spellPut("138-113", "zhong");
		spellPut("138-114", "pa");
		spellPut("138-115", "keng,hang");
		spellPut("138-116", "zhong");
		spellPut("138-117", "yun");
		spellPut("138-118", "fou,pei,pi");
		spellPut("138-119", "chi");
		spellPut("138-120", "yue,jue");
		spellPut("138-121", "zhuang");
		spellPut("138-122", "yan");
		spellPut("138-123", "na,nan");
		spellPut("138-124", "xin");
		spellPut("138-125", "fen");
		spellPut("138-126", "feng");
		spellPut("138-128", "wan,yuan");
		spellPut("138-129", "du");
		spellPut("138-130", "ba");
		spellPut("138-131", "zhuo");
		spellPut("138-132", "zhao");
		spellPut("138-133", "ni,nai");
		spellPut("138-134", "yuan");
		spellPut("138-135", "tou");
		spellPut("138-136", "xian,xuan,xu");
		spellPut("138-137", "zhi,yi");
		spellPut("138-138", "e");
		spellPut("138-139", "mo");
		spellPut("138-140", "bi");
		spellPut("138-141", "shen");
		spellPut("138-142", "e");
		spellPut("138-143", "he");
		spellPut("138-144", "xu");
		spellPut("138-145", "fa");
		spellPut("138-146", "zheng");
		spellPut("138-147", "min");
		spellPut("138-148", "ban");
		spellPut("138-149", "fu");
		spellPut("138-150", "ling");
		spellPut("138-151", "zi");
		spellPut("138-152", "ran");
		spellPut("138-153", "shan");
		spellPut("138-154", "yang");
		spellPut("138-155", "gan");
		spellPut("138-156", "zi");
		spellPut("138-157", "ju");
		spellPut("138-158", "ren");
		spellPut("138-159", "dong");
		spellPut("138-160", "ji");
		spellPut("138-161", "gai");
		spellPut("138-162", "xiang");
		spellPut("138-163", "hua,huo");
		spellPut("138-164", "juan");
		spellPut("138-165", "gou,du");
		spellPut("138-166", "jian");
		spellPut("138-167", "jian");
		spellPut("138-168", "nian");
		spellPut("138-169", "zhi");
		spellPut("138-170", "zhen");
		spellPut("138-171", "xian");
		spellPut("138-172", "heng");
		spellPut("138-173", "guang");
		spellPut("138-174", "jun,xun");
		spellPut("138-175", "kua,hu");
		spellPut("138-176", "yan");
		spellPut("138-177", "ming");
		spellPut("138-178", "lie");
		spellPut("138-179", "pei");
		spellPut("138-180", "e,ya");
		spellPut("138-181", "you");
		spellPut("138-182", "yan");
		spellPut("138-183", "shen,xian");
		spellPut("138-184", "shi");
		spellPut("138-185", "gui");
		spellPut("138-186", "quan");
		spellPut("138-187", "song");
		spellPut("138-188", "hong");
		spellPut("138-189", "xian");
		spellPut("138-190", "shao");
		spellPut("138-191", "cheng,sheng");
		spellPut("138-192", "xie");
		spellPut("138-193", "mang");
		spellPut("138-194", "fu");
		spellPut("138-195", "wu,mu");
		spellPut("138-196", "ke");
		spellPut("138-197", "chuo,lai");
		spellPut("138-198", "chuo");
		spellPut("138-199", "ting");
		spellPut("138-200", "xing");
		spellPut("138-201", "nan");
		spellPut("138-202", "yu");
		spellPut("138-203", "pou,bi");
		spellPut("138-204", "nei,sui");
		spellPut("138-205", "zhi");
		spellPut("138-206", "han");
		spellPut("138-207", "zhuang");
		spellPut("138-208", "pin");
		spellPut("138-209", "tui");
		spellPut("138-210", "man");
		spellPut("138-211", "wu,yu");
		spellPut("138-212", "yan");
		spellPut("138-213", "wu");
		spellPut("138-214", "xi,ai");
		spellPut("138-215", "yan");
		spellPut("138-216", "yu");
		spellPut("138-217", "si");
		spellPut("138-218", "li");
		spellPut("138-219", "ju");
		spellPut("138-220", "zhui,shui");
		spellPut("138-221", "qi");
		spellPut("138-222", "xian");
		spellPut("138-223", "zhuo");
		spellPut("138-224", "dong");
		spellPut("138-225", "lu");
		spellPut("138-226", "ai,e");
		spellPut("138-227", "e");
		spellPut("138-228", "lou");
		spellPut("138-229", "mian");
		spellPut("138-230", "cong");
		spellPut("138-231", "pou,pei,bu");
		spellPut("138-232", "ju");
		spellPut("138-233", "cai");
		spellPut("138-234", "ling");
		spellPut("138-235", "xiao");
		spellPut("138-236", "shu");
		spellPut("138-237", "qi");
		spellPut("138-238", "hui");
		spellPut("138-239", "fu,fan");
		spellPut("138-240", "wo");
		spellPut("138-241", "wo");
		spellPut("138-242", "tan");
		spellPut("138-243", "fei");
		spellPut("138-244", "fei");
		spellPut("138-245", "tian");
		spellPut("138-246", "ni");
		spellPut("138-247", "quan,juan");
		spellPut("138-248", "jing");
		spellPut("138-249", "jing");
		spellPut("138-250", "qian,jin");
		spellPut("138-251", "dian");
		spellPut("138-252", "xing");
		spellPut("138-253", "hu");
		spellPut("138-254", "wan,wa");
	}

	private static void init10() {
		spellPut("139-64", "lai");
		spellPut("139-65", "yin");
		spellPut("139-66", "zhou,chou");
		spellPut("139-67", "chuo,nao");
		spellPut("139-68", "fu");
		spellPut("139-69", "lun");
		spellPut("139-70", "an,n<e");
		spellPut("139-71", "hun,kun");
		spellPut("139-72", "yin");
		spellPut("139-73", "ya");
		spellPut("139-74", "ju");
		spellPut("139-75", "li");
		spellPut("139-76", "dian");
		spellPut("139-77", "xian");
		spellPut("139-78", "huB,dB tBi");
		spellPut("139-79", "hua");
		spellPut("139-80", "dang,yang");
		spellPut("139-81", "yao");
		spellPut("139-82", "nan");
		spellPut("139-83", "ruo,chuo");
		spellPut("139-84", "jia");
		spellPut("139-85", "tou,yu");
		spellPut("139-86", "yu");
		spellPut("139-87", "wei");
		spellPut("139-88", "di,ti");
		spellPut("139-89", "rou");
		spellPut("139-90", "mei");
		spellPut("139-91", "dan");
		spellPut("139-92", "ruan,nen");
		spellPut("139-93", "qin");
		spellPut("139-94", "hui");
		spellPut("139-95", "wo");
		spellPut("139-96", "qian");
		spellPut("139-97", "chun");
		spellPut("139-98", "miao");
		spellPut("139-99", "fu");
		spellPut("139-100", "jie");
		spellPut("139-101", "duan");
		spellPut("139-102", "yi,pei");
		spellPut("139-103", "zhong");
		spellPut("139-104", "huang");
		spellPut("139-105", "mian");
		spellPut("139-106", "an");
		spellPut("139-107", "ying");
		spellPut("139-108", "xuan");
		spellPut("139-109", "jie");
		spellPut("139-110", "wei");
		spellPut("139-111", "zheng");
		spellPut("139-112", "qiu");
		spellPut("139-113", "ti");
		spellPut("139-114", "xie");
		spellPut("139-115", "tuo,duo");
		spellPut("139-116", "lian");
		spellPut("139-117", "mao");
		spellPut("139-118", "ran");
		spellPut("139-119", "si");
		spellPut("139-120", "pian");
		spellPut("139-121", "wei");
		spellPut("139-122", "wa");
		spellPut("139-123", "cu");
		spellPut("139-124", "hu");
		spellPut("139-125", "jie");
		spellPut("139-126", "bao");
		spellPut("139-128", "xu");
		spellPut("139-129", "tou,yu");
		spellPut("139-130", "gui");
		spellPut("139-131", "chu,zou");
		spellPut("139-132", "yao");
		spellPut("139-133", "yuan");
		spellPut("139-134", "rong");
		spellPut("139-135", "ru");
		spellPut("139-136", "liu");
		spellPut("139-137", "mei");
		spellPut("139-138", "pan");
		spellPut("139-139", "ao,yun,wo");
		spellPut("139-140", "ma");
		spellPut("139-141", "kui");
		spellPut("139-142", "qin,shen");
		spellPut("139-143", "zhen");
		spellPut("139-144", "yuan");
		spellPut("139-145", "jie,suo");
		spellPut("139-146", "rong");
		spellPut("139-147", "ming");
		spellPut("139-148", "ying");
		spellPut("139-149", "su");
		spellPut("139-150", "niao");
		spellPut("139-151", "tao");
		spellPut("139-152", "pang");
		spellPut("139-153", "lang");
		spellPut("139-154", "nao");
		spellPut("139-155", "biao");
		spellPut("139-156", "pi");
		spellPut("139-157", "yi");
		spellPut("139-158", "yu");
		spellPut("139-159", "xuan");
		spellPut("139-160", "man");
		spellPut("139-161", "yi");
		spellPut("139-162", "kang");
		spellPut("139-163", "yong");
		spellPut("139-164", "ni");
		spellPut("139-165", "gui");
		spellPut("139-166", "jin");
		spellPut("139-167", "zhuan");
		spellPut("139-168", "ze");
		spellPut("139-169", "han,nan");
		spellPut("139-170", "lao");
		spellPut("139-171", "zhe");
		spellPut("139-172", "hu");
		spellPut("139-173", "hu");
		spellPut("139-174", "ao");
		spellPut("139-175", "nen");
		spellPut("139-176", "ma");
		spellPut("139-177", "pie");
		spellPut("139-178", "gu");
		spellPut("139-179", "wu");
		spellPut("139-180", "qiao");
		spellPut("139-181", "tuo");
		spellPut("139-182", "zhan");
		spellPut("139-183", "miao");
		spellPut("139-184", "xian");
		spellPut("139-185", "xian");
		spellPut("139-186", "mo");
		spellPut("139-187", "liao");
		spellPut("139-188", "lian");
		spellPut("139-189", "hua");
		spellPut("139-190", "gui");
		spellPut("139-191", "deng");
		spellPut("139-192", "zhi");
		spellPut("139-193", "xu");
		spellPut("139-194", "yi");
		spellPut("139-195", "hua");
		spellPut("139-196", "xi");
		spellPut("139-197", "kui");
		spellPut("139-198", "rao");
		spellPut("139-199", "yan");
		spellPut("139-200", "chan");
		spellPut("139-201", "jiao");
		spellPut("139-202", "mei");
		spellPut("139-203", "fan");
		spellPut("139-204", "fan");
		spellPut("139-205", "xian,yan,jin");
		spellPut("139-206", "yi");
		spellPut("139-207", "hui");
		spellPut("139-208", "jiao");
		spellPut("139-209", "fu");
		spellPut("139-210", "shi");
		spellPut("139-211", "sui");
		spellPut("139-212", "qiang");
		spellPut("139-213", "lian");
		spellPut("139-214", "huan,xuan,qiong");
		spellPut("139-215", "xin");
		spellPut("139-216", "niao");
		spellPut("139-217", "dong");
		spellPut("139-218", "yi");
		spellPut("139-219", "can");
		spellPut("139-220", "ai");
		spellPut("139-221", "niang");
		spellPut("139-222", "ning");
		spellPut("139-223", "mo");
		spellPut("139-224", "tiao");
		spellPut("139-225", "chou");
		spellPut("139-226", "jin");
		spellPut("139-227", "ci");
		spellPut("139-228", "yu");
		spellPut("139-229", "pin");
		spellPut("139-230", "rong");
		spellPut("139-231", "ru");
		spellPut("139-232", "nai");
		spellPut("139-233", "yan");
		spellPut("139-234", "tai");
		spellPut("139-235", "ying");
		spellPut("139-236", "qian");
		spellPut("139-237", "yue");
		spellPut("139-238", "mian");
		spellPut("139-239", "ka ka a");
		spellPut("139-240", "shen");
		spellPut("139-241", "xing");
		spellPut("139-242", "ni");
		spellPut("139-243", "du");
		spellPut("139-244", "liu");
		spellPut("139-245", "yuan");
		spellPut("139-246", "lan");
		spellPut("139-247", "yan");
		spellPut("139-248", "ling");
		spellPut("139-249", "jiao");
		spellPut("139-250", "niang");
		spellPut("139-251", "lan");
		spellPut("139-252", "xian,qian");
		spellPut("139-253", "ying");
		spellPut("139-254", "shuang");
	}

	private static void init11() {
		spellPut("140-64", "xie,hui");
		spellPut("140-65", "huan,quan");
		spellPut("140-66", "mi");
		spellPut("140-67", "li");
		spellPut("140-68", "luan");
		spellPut("140-69", "yan");
		spellPut("140-70", "zhu,chuo");
		spellPut("140-71", "lan");
		spellPut("140-72", "jue");
		spellPut("140-73", "zi,ma");
		spellPut("140-74", "xin");
		spellPut("140-75", "si");
		spellPut("140-76", "tai");
		spellPut("140-77", "you");
		spellPut("140-78", "zhuan");
		spellPut("140-79", "sun,xun");
		spellPut("140-80", "mie");
		spellPut("140-81", "cong");
		spellPut("140-82", "qian");
		spellPut("140-83", "ya");
		spellPut("140-84", "ni");
		spellPut("140-85", "zi");
		spellPut("140-86", "li");
		spellPut("140-87", "xue");
		spellPut("140-88", "bo");
		spellPut("140-89", "nai");
		spellPut("140-90", "nie");
		spellPut("140-91", "ying");
		spellPut("140-92", "luan");
		spellPut("140-93", "rong");
		spellPut("140-94", "qiong");
		spellPut("140-95", "tu,jia");
		spellPut("140-96", "rou");
		spellPut("140-97", "yao");
		spellPut("140-98", "yi");
		spellPut("140-99", "jing");
		spellPut("140-100", "zhun");
		spellPut("140-101", "zhu");
		spellPut("140-102", "hong");
		spellPut("140-103", "shi");
		spellPut("140-104", "yi");
		spellPut("140-105", "tiao");
		spellPut("140-106", "shi");
		spellPut("140-107", "cheng");
		spellPut("140-108", "qun");
		spellPut("140-109", "gong");
		spellPut("140-110", "xiao");
		spellPut("140-111", "zha");
		spellPut("140-112", "bao,shi");
		spellPut("140-113", "cai");
		spellPut("140-114", "huang");
		spellPut("140-115", "mi");
		spellPut("140-116", "kou");
		spellPut("140-117", "cai");
		spellPut("140-118", "zan");
		spellPut("140-119", "yuan");
		spellPut("140-120", "qing");
		spellPut("140-121", "he");
		spellPut("140-122", "zhen");
		spellPut("140-123", "jian");
		spellPut("140-124", "ning");
		spellPut("140-125", "bing");
		spellPut("140-126", "huan");
		spellPut("140-128", "qin");
		spellPut("140-129", "shi");
		spellPut("140-130", "ning");
		spellPut("140-131", "jin,qin");
		spellPut("140-132", "ning");
		spellPut("140-133", "zhi");
		spellPut("140-134", "yu");
		spellPut("140-135", "bao");
		spellPut("140-136", "kuan");
		spellPut("140-137", "ning");
		spellPut("140-138", "ju,lou");
		spellPut("140-139", "qin");
		spellPut("140-140", "hu");
		spellPut("140-141", "shi");
		spellPut("140-142", "ning");
		spellPut("140-143", "shen");
		spellPut("140-144", "wei");
		spellPut("140-145", "xie");
		spellPut("140-146", "kuan");
		spellPut("140-147", "hui");
		spellPut("140-148", "jun");
		spellPut("140-149", "yi");
		spellPut("140-150", "yi");
		spellPut("140-151", "bao");
		spellPut("140-152", "qin");
		spellPut("140-153", "chong");
		spellPut("140-154", "bao");
		spellPut("140-155", "feng");
		spellPut("140-156", "l<e,luo");
		spellPut("140-157", "dui");
		spellPut("140-158", "po");
		spellPut("140-159", "zhuan");
		spellPut("140-160", "fu");
		spellPut("140-161", "kei,ke");
		spellPut("140-162", "jiang");
		spellPut("140-163", "zhuan");
		spellPut("140-164", "xun");
		spellPut("140-165", "shu,zhu");
		spellPut("140-166", "dui");
		spellPut("140-167", "dao");
		spellPut("140-168", "jie,ji");
		spellPut("140-169", "er");
		spellPut("140-170", "er");
		spellPut("140-171", "shu");
		spellPut("140-172", "shang");
		spellPut("140-173", "mo");
		spellPut("140-174", "liao");
		spellPut("140-175", "xian");
		spellPut("140-176", "xian");
		spellPut("140-177", "hun");
		spellPut("140-178", "wang");
		spellPut("140-179", "liao");
		spellPut("140-180", "long,mang,meng,pang");
		spellPut("140-181", "wang");
		spellPut("140-182", "wang");
		spellPut("140-183", "wang");
		spellPut("140-184", "yao");
		spellPut("140-185", "duo");
		spellPut("140-186", "kui");
		spellPut("140-187", "zhong");
		spellPut("140-188", "gan");
		spellPut("140-189", "gu");
		spellPut("140-190", "tui");
		spellPut("140-191", "gan");
		spellPut("140-192", "gan");
		spellPut("140-193", "xi");
		spellPut("140-194", "bi");
		spellPut("140-195", "jie");
		spellPut("140-196", "tian");
		spellPut("140-197", "diao");
		spellPut("140-198", "shi");
		spellPut("140-199", "zhen");
		spellPut("140-200", "xi");
		spellPut("140-201", "ni");
		spellPut("140-202", "xi");
		spellPut("140-203", "uu");
		spellPut("140-204", "man");
		spellPut("140-205", "lou");
		spellPut("140-206", "ping,bing");
		spellPut("140-207", "ti");
		spellPut("140-208", "fei");
		spellPut("140-209", "xie,ti");
		spellPut("140-210", "lv");
		spellPut("140-211", "ceng");
		spellPut("140-212", "xie");
		spellPut("140-213", "ju");
		spellPut("140-214", "jue");
		spellPut("140-215", "liao");
		spellPut("140-216", "jue");
		spellPut("140-217", "shu,zhu");
		spellPut("140-218", "xi");
		spellPut("140-219", "ni,ji");
		spellPut("140-220", "wa");
		spellPut("140-221", "xian");
		spellPut("140-222", "li");
		spellPut("140-223", "an");
		spellPut("140-224", "hui");
		spellPut("140-225", "hui");
		spellPut("140-226", "hong,long");
		spellPut("140-227", "ren");
		spellPut("140-228", "wu");
		spellPut("140-229", "han,an");
		spellPut("140-230", "shen");
		spellPut("140-231", "chu");
		spellPut("140-232", "yin");
		spellPut("140-233", "yue");
		spellPut("140-234", "ban");
		spellPut("140-235", "yao");
		spellPut("140-236", "ang");
		spellPut("140-237", "wu");
		spellPut("140-238", "jie");
		spellPut("140-239", "e");
		spellPut("140-240", "fen");
		spellPut("140-241", "wan");
		spellPut("140-242", "qian");
		spellPut("140-243", "qi");
		spellPut("140-244", "jie");
		spellPut("140-245", "zuo");
		spellPut("140-246", "zuo");
		spellPut("140-247", "yang");
		spellPut("140-248", "ju");
		spellPut("140-249", "gang");
		spellPut("140-250", "xue");
		spellPut("140-251", "po");
		spellPut("140-252", "li");
		spellPut("140-253", "tiao");
		spellPut("140-254", "ju");
	}

	private static void init12() {
		spellPut("141-64", "fu");
		spellPut("141-65", "tuo");
		spellPut("141-66", "pi");
		spellPut("141-67", "ao");
		spellPut("141-68", "kuang");
		spellPut("141-69", "qu");
		spellPut("141-70", "po");
		spellPut("141-71", "tiao");
		spellPut("141-72", "ling");
		spellPut("141-73", "di");
		spellPut("141-74", "ping");
		spellPut("141-75", "zBi,ze mo");
		spellPut("141-76", "xiu");
		spellPut("141-77", "tong");
		spellPut("141-78", "xue");
		spellPut("141-79", "biBn");
		spellPut("141-80", "he");
		spellPut("141-81", "ke,ba");
		spellPut("141-82", "luo");
		spellPut("141-83", "e");
		spellPut("141-84", "fu,nie");
		spellPut("141-85", "die");
		spellPut("141-86", "lu");
		spellPut("141-87", "en");
		spellPut("141-88", "er");
		spellPut("141-89", "gai");
		spellPut("141-90", "quan");
		spellPut("141-91", "yi");
		spellPut("141-92", "mu");
		spellPut("141-93", "shi");
		spellPut("141-94", "an");
		spellPut("141-95", "wei");
		spellPut("141-96", "huan");
		spellPut("141-97", "mi");
		spellPut("141-98", "li");
		spellPut("141-99", "fa");
		spellPut("141-100", "tong");
		spellPut("141-101", "wei");
		spellPut("141-102", "you");
		spellPut("141-103", "qia");
		spellPut("141-104", "li");
		spellPut("141-105", "yao");
		spellPut("141-106", "jiao");
		spellPut("141-107", "e");
		spellPut("141-108", "xie,ye");
		spellPut("141-109", "bu");
		spellPut("141-110", "qun");
		spellPut("141-111", "feng");
		spellPut("141-112", "nao");
		spellPut("141-113", "li");
		spellPut("141-114", "you");
		spellPut("141-115", "xian");
		spellPut("141-116", "rong");
		spellPut("141-117", "dao");
		spellPut("141-118", "shen");
		spellPut("141-119", "cheng");
		spellPut("141-120", "tu");
		spellPut("141-121", "geng");
		spellPut("141-122", "gao");
		spellPut("141-123", "xia");
		spellPut("141-124", "yin");
		spellPut("141-125", "wu");
		spellPut("141-126", "lang");
		spellPut("141-128", "kan");
		spellPut("141-129", "xian");
		spellPut("141-130", "que");
		spellPut("141-131", "chong");
		spellPut("141-132", "ta");
		spellPut("141-133", "lin");
		spellPut("141-134", "hua");
		spellPut("141-135", "ju");
		spellPut("141-136", "lai");
		spellPut("141-137", "min");
		spellPut("141-138", "kun");
		spellPut("141-139", "kun");
		spellPut("141-140", "zu,cui");
		spellPut("141-141", "gu");
		spellPut("141-142", "ya");
		spellPut("141-143", "gang");
		spellPut("141-144", "lun");
		spellPut("141-145", "lun");
		spellPut("141-146", "ling");
		spellPut("141-147", "duo");
		spellPut("141-148", "zheng");
		spellPut("141-149", "yin");
		spellPut("141-150", "dong");
		spellPut("141-151", "han");
		spellPut("141-152", "zheng");
		spellPut("141-153", "wei");
		spellPut("141-154", "pi,bi");
		spellPut("141-155", "jie");
		spellPut("141-156", "zu");
		spellPut("141-157", "jue");
		spellPut("141-158", "dong");
		spellPut("141-159", "yin");
		spellPut("141-160", "zi");
		spellPut("141-161", "ze");
		spellPut("141-162", "huang");
		spellPut("141-163", "yu");
		spellPut("141-164", "yang,dang");
		spellPut("141-165", "feng");
		spellPut("141-166", "qiu");
		spellPut("141-167", "yang");
		spellPut("141-168", "ti");
		spellPut("141-169", "yi");
		spellPut("141-170", "zhi,shi");
		spellPut("141-171", "shi,die");
		spellPut("141-172", "e");
		spellPut("141-173", "zhu");
		spellPut("141-174", "kan,zhan");
		spellPut("141-175", "lv");
		spellPut("141-176", "yan");
		spellPut("141-177", "mei");
		spellPut("141-178", "han");
		spellPut("141-179", "ji");
		spellPut("141-180", "huan");
		spellPut("141-181", "ting");
		spellPut("141-182", "wu,mao");
		spellPut("141-183", "yu");
		spellPut("141-184", "zong");
		spellPut("141-185", "lan");
		spellPut("141-186", "ke,jie");
		spellPut("141-187", "yan");
		spellPut("141-188", "yan");
		spellPut("141-189", "wei");
		spellPut("141-190", "zong");
		spellPut("141-191", "cha");
		spellPut("141-192", "sui");
		spellPut("141-193", "ke");
		spellPut("141-194", "qin");
		spellPut("141-195", "qi");
		spellPut("141-196", "tu");
		spellPut("141-197", "cui");
		spellPut("141-198", "xi");
		spellPut("141-199", "weng");
		spellPut("141-200", "cang");
		spellPut("141-201", "dang,tang");
		spellPut("141-202", "rong,ying");
		spellPut("141-203", "jie");
		spellPut("141-204", "kai,ai");
		spellPut("141-205", "liu");
		spellPut("141-206", "wu");
		spellPut("141-207", "kao,qiao");
		spellPut("141-208", "beng");
		spellPut("141-209", "dian");
		spellPut("141-210", "qin,qian");
		spellPut("141-211", "yong");
		spellPut("141-212", "nie");
		spellPut("141-213", "cuo");
		spellPut("141-214", "shi");
		spellPut("141-215", "ruo");
		spellPut("141-216", "song");
		spellPut("141-217", "zong");
		spellPut("141-218", "jiang");
		spellPut("141-219", "liao");
		spellPut("141-220", "kang");
		spellPut("141-221", "yan");
		spellPut("141-222", "die,di");
		spellPut("141-223", "cen");
		spellPut("141-224", "ding");
		spellPut("141-225", "tu");
		spellPut("141-226", "lou");
		spellPut("141-227", "zhan,chan");
		spellPut("141-228", "zhan,chan");
		spellPut("141-229", "ao");
		spellPut("141-230", "cao");
		spellPut("141-231", "qu");
		spellPut("141-232", "qiang");
		spellPut("141-233", "wei");
		spellPut("141-234", "zui");
		spellPut("141-235", "dao");
		spellPut("141-236", "dao");
		spellPut("141-237", "xi");
		spellPut("141-238", "yu");
		spellPut("141-239", "pi,pei");
		spellPut("141-240", "long");
		spellPut("141-241", "xiang");
		spellPut("141-242", "ceng");
		spellPut("141-243", "bo");
		spellPut("141-244", "qin");
		spellPut("141-245", "jiao");
		spellPut("141-246", "yan");
		spellPut("141-247", "lao");
		spellPut("141-248", "zhan");
		spellPut("141-249", "liao");
		spellPut("141-250", "liao");
		spellPut("141-251", "qin");
		spellPut("141-252", "tuo");
		spellPut("141-253", "zun");
		spellPut("141-254", "jiao,qiao");
	}

	private static void init13() {
		spellPut("142-64", "jue,gui");
		spellPut("142-65", "yao");
		spellPut("142-66", "jiao");
		spellPut("142-67", "yao");
		spellPut("142-68", "jue");
		spellPut("142-69", "zhan,shan");
		spellPut("142-70", "yi");
		spellPut("142-71", "xue");
		spellPut("142-72", "nao");
		spellPut("142-73", "ye");
		spellPut("142-74", "ye");
		spellPut("142-75", "yi");
		spellPut("142-76", "nie");
		spellPut("142-77", "xian");
		spellPut("142-78", "ji");
		spellPut("142-79", "xie,jie");
		spellPut("142-80", "ke,jie");
		spellPut("142-81", "gui,xi,juan");
		spellPut("142-82", "di");
		spellPut("142-83", "ao");
		spellPut("142-84", "zui");
		spellPut("142-85", "wei");
		spellPut("142-86", "rong");
		spellPut("142-87", "dao");
		spellPut("142-88", "ling");
		spellPut("142-89", "jie");
		spellPut("142-90", "yu");
		spellPut("142-91", "yue");
		spellPut("142-92", "yin");
		spellPut("142-93", "ru");
		spellPut("142-94", "jie");
		spellPut("142-95", "li,lie");
		spellPut("142-96", "gui,xi,juan");
		spellPut("142-97", "long");
		spellPut("142-98", "long");
		spellPut("142-99", "ying,hong");
		spellPut("142-100", "xi");
		spellPut("142-101", "ju");
		spellPut("142-102", "chan");
		spellPut("142-103", "ying");
		spellPut("142-104", "kui");
		spellPut("142-105", "yan");
		spellPut("142-106", "nao");
		spellPut("142-107", "quan");
		spellPut("142-108", "chao");
		spellPut("142-109", "cuan");
		spellPut("142-110", "luan");
		spellPut("142-111", "dian");
		spellPut("142-112", "dian");
		spellPut("142-113", "nie");
		spellPut("142-114", "yan");
		spellPut("142-115", "yan");
		spellPut("142-116", "yan");
		spellPut("142-117", "kui");
		spellPut("142-118", "yan");
		spellPut("142-119", "kuai");
		spellPut("142-120", "huang");
		spellPut("142-121", "jing,xing");
		spellPut("142-122", "chao");
		spellPut("142-123", "lie");
		spellPut("142-124", "ge xi");
		spellPut("142-125", "pu");
		spellPut("142-126", "bu");
		spellPut("142-128", "qiu");
		spellPut("142-129", "zhi");
		spellPut("142-130", "zhao");
		spellPut("142-131", "yi");
		spellPut("142-132", "jin");
		spellPut("142-133", "xun");
		spellPut("142-134", "juan");
		spellPut("142-135", "pB xi");
		spellPut("142-136", "fu");
		spellPut("142-137", "za");
		spellPut("142-138", "ding");
		spellPut("142-139", "nie");
		spellPut("142-140", "fen");
		spellPut("142-141", "pa");
		spellPut("142-142", "zhi");
		spellPut("142-143", "hu");
		spellPut("142-144", "dan");
		spellPut("142-145", "dai");
		spellPut("142-146", "mo,wa");
		spellPut("142-147", "fu");
		spellPut("142-148", "mo");
		spellPut("142-149", "yi");
		spellPut("142-150", "yi");
		spellPut("142-151", "ping");
		spellPut("142-152", "qia");
		spellPut("142-153", "juan");
		spellPut("142-154", "ru");
		spellPut("142-155", "shuai");
		spellPut("142-156", "shui");
		spellPut("142-157", "qiao");
		spellPut("142-158", "zhen");
		spellPut("142-159", "shi");
		spellPut("142-160", "qun");
		spellPut("142-161", "dai");
		spellPut("142-162", "gui");
		spellPut("142-163", "ping");
		spellPut("142-164", "zhang");
		spellPut("142-165", "jian,san");
		spellPut("142-166", "wan");
		spellPut("142-167", "dai");
		spellPut("142-168", "sha,qie");
		spellPut("142-169", "qi,ji");
		spellPut("142-170", "zhu");
		spellPut("142-171", "hou");
		spellPut("142-172", "zhen");
		spellPut("142-173", "zheng");
		spellPut("142-174", "wei");
		spellPut("142-175", "yi");
		spellPut("142-176", "bang");
		spellPut("142-177", "ping");
		spellPut("142-178", "die");
		spellPut("142-179", "gong");
		spellPut("142-180", "pan");
		spellPut("142-181", "tao");
		spellPut("142-182", "mi");
		spellPut("142-183", "jia");
		spellPut("142-184", "teng");
		spellPut("142-185", "hui");
		spellPut("142-186", "zhong");
		spellPut("142-187", "shan,qiao,shen");
		spellPut("142-188", "biao");
		spellPut("142-189", "guo");
		spellPut("142-190", "ze");
		spellPut("142-191", "mu");
		spellPut("142-192", "bang");
		spellPut("142-193", "jing");
		spellPut("142-194", "chan");
		spellPut("142-195", "zhi");
		spellPut("142-196", "hu");
		spellPut("142-197", "bi");
		spellPut("142-198", "bi");
		spellPut("142-199", "zhBng");
		spellPut("142-200", "mi");
		spellPut("142-201", "qiao");
		spellPut("142-202", "chan");
		spellPut("142-203", "fen");
		spellPut("142-204", "meng");
		spellPut("142-205", "bang");
		spellPut("142-206", "chou,dao");
		spellPut("142-207", "mie");
		spellPut("142-208", "chu");
		spellPut("142-209", "jie");
		spellPut("142-210", "xian");
		spellPut("142-211", "lan");
		spellPut("142-212", "jian");
		spellPut("142-213", "bing");
		spellPut("142-214", "gan");
		spellPut("142-215", "ji");
		spellPut("142-216", "ting");
		spellPut("142-217", "ze");
		spellPut("142-218", "guang");
		spellPut("142-219", "me,mo");
		spellPut("142-220", "qin");
		spellPut("142-221", "dun,tun");
		spellPut("142-222", "ya");
		spellPut("142-223", "bai,ting");
		spellPut("142-224", "jie");
		spellPut("142-225", "zhuang");
		spellPut("142-226", "ya");
		spellPut("142-227", "ci");
		spellPut("142-228", "tong");
		spellPut("142-229", "yi");
		spellPut("142-230", "zhi");
		spellPut("142-231", "tiao");
		spellPut("142-232", "zhi");
		spellPut("142-233", "xiao");
		spellPut("142-234", "tu");
		spellPut("142-235", "gui");
		spellPut("142-236", "ku");
		spellPut("142-237", "mang,meng,pang");
		spellPut("142-238", "you");
		spellPut("142-239", "bu");
		spellPut("142-240", "bing,ping");
		spellPut("142-241", "cheng");
		spellPut("142-242", "lai");
		spellPut("142-243", "ji,cuo");
		spellPut("142-244", "song");
		spellPut("142-245", "shu");
		spellPut("142-246", "qing");
		spellPut("142-247", "yu");
		spellPut("142-248", "miao");
		spellPut("142-249", "sou");
		spellPut("142-250", "ce");
		spellPut("142-251", "xiang");
		spellPut("142-252", "fei");
		spellPut("142-253", "jiu");
		spellPut("142-254", "e");
	}

	private static void init14() {
		spellPut("143-64", "gui,wei,hui");
		spellPut("143-65", "liu");
		spellPut("143-66", "sha,xia");
		spellPut("143-67", "sou");
		spellPut("143-68", "zhi");
		spellPut("143-69", "bu");
		spellPut("143-70", "qing");
		spellPut("143-71", "jiu");
		spellPut("143-72", "jiu");
		spellPut("143-73", "lou");
		spellPut("143-74", "yin");
		spellPut("143-75", "dai");
		spellPut("143-76", "lu");
		spellPut("143-77", "yi");
		spellPut("143-78", "chu");
		spellPut("143-79", "tu");
		spellPut("143-80", "si");
		spellPut("143-81", "xin");
		spellPut("143-82", "miao");
		spellPut("143-83", "chang");
		spellPut("143-84", "wu");
		spellPut("143-85", "fei");
		spellPut("143-86", "guang");
		spellPut("143-87", "kBo x");
		spellPut("143-88", "kuai");
		spellPut("143-89", "bi");
		spellPut("143-90", "qiang,se");
		spellPut("143-91", "lin");
		spellPut("143-92", "liao");
		spellPut("143-93", "lu");
		spellPut("143-94", "ji");
		spellPut("143-95", "ying");
		spellPut("143-96", "xian");
		spellPut("143-97", "ting");
		spellPut("143-98", "yong");
		spellPut("143-99", "li");
		spellPut("143-100", "ting");
		spellPut("143-101", "xun");
		spellPut("143-102", "di");
		spellPut("143-103", "po,pai");
		spellPut("143-104", "hui");
		spellPut("143-105", "nai");
		spellPut("143-106", "hui");
		spellPut("143-107", "fen");
		spellPut("143-108", "ju");
		spellPut("143-109", "yan");
		spellPut("143-110", "zang");
		spellPut("143-111", "yi");
		spellPut("143-112", "er");
		spellPut("143-113", "san");
		spellPut("143-114", "er");
		spellPut("143-115", "shi");
		spellPut("143-116", "diao");
		spellPut("143-117", "hu");
		spellPut("143-118", "wu");
		spellPut("143-119", "tui");
		spellPut("143-120", "jiang");
		spellPut("143-121", "ba");
		spellPut("143-122", "shen");
		spellPut("143-123", "jue,zhang");
		spellPut("143-124", "tao");
		spellPut("143-125", "fu");
		spellPut("143-126", "di");
		spellPut("143-128", "chao");
		spellPut("143-129", "zhen");
		spellPut("143-130", "yi");
		spellPut("143-131", "juan,quan");
		spellPut("143-132", "shao");
		spellPut("143-133", "xuan,yuan");
		spellPut("143-134", "jing");
		spellPut("143-135", "diao");
		spellPut("143-136", "zhang");
		spellPut("143-137", "jiang");
		spellPut("143-138", "qiang,jiang");
		spellPut("143-139", "peng");
		spellPut("143-140", "bi");
		spellPut("143-141", "she");
		spellPut("143-142", "dan,tan");
		spellPut("143-143", "jian");
		spellPut("143-144", "ge");
		spellPut("143-145", "fa");
		spellPut("143-146", "bi");
		spellPut("143-147", "kou");
		spellPut("143-148", "jiBn");
		spellPut("143-149", "bie");
		spellPut("143-150", "xiao");
		spellPut("143-151", "dan,tan");
		spellPut("143-152", "guo");
		spellPut("143-153", "qiang,jiang");
		spellPut("143-154", "hong");
		spellPut("143-155", "mi");
		spellPut("143-156", "guo");
		spellPut("143-157", "wan");
		spellPut("143-158", "jue");
		spellPut("143-159", "ji");
		spellPut("143-160", "lu");
		spellPut("143-161", "hui");
		spellPut("143-162", "hui");
		spellPut("143-163", "yi");
		spellPut("143-164", "yi");
		spellPut("143-165", "yi");
		spellPut("143-166", "huo");
		spellPut("143-167", "huo");
		spellPut("143-168", "wen");
		spellPut("143-169", "yan");
		spellPut("143-170", "yu");
		spellPut("143-171", "chi");
		spellPut("143-172", "diao");
		spellPut("143-173", "yong");
		spellPut("143-174", "piao");
		spellPut("143-175", "chi");
		spellPut("143-176", "zhuo,bo");
		spellPut("143-177", "tuo,yi");
		spellPut("143-178", "ji");
		spellPut("143-179", "zhong");
		spellPut("143-180", "wang");
		spellPut("143-181", "di");
		spellPut("143-182", "ling");
		spellPut("143-183", "fu");
		spellPut("143-184", "wang");
		spellPut("143-185", "xi");
		spellPut("143-186", "wang,jia,wa");
		spellPut("143-187", "cheng,zheng");
		spellPut("143-188", "zhi");
		spellPut("143-189", "jing");
		spellPut("143-190", "cong");
		spellPut("143-191", "cong");
		spellPut("143-192", "cong");
		spellPut("143-193", "uu");
		spellPut("143-194", "ji");
		spellPut("143-195", "zhi");
		spellPut("143-196", "cong,zong");
		spellPut("143-197", "zhou");
		spellPut("143-198", "lai");
		spellPut("143-199", "xie");
		spellPut("143-200", "jie");
		spellPut("143-201", "jian");
		spellPut("143-202", "shi,ti");
		spellPut("143-203", "jia,xia");
		spellPut("143-204", "bian");
		spellPut("143-205", "fu");
		spellPut("143-206", "wei");
		spellPut("143-207", "pang");
		spellPut("143-208", "xi");
		spellPut("143-209", "zheng");
		spellPut("143-210", "piao");
		spellPut("143-211", "ti,chi");
		spellPut("143-212", "de");
		spellPut("143-213", "zhi,zheng");
		spellPut("143-214", "bie");
		spellPut("143-215", "zhong,chong");
		spellPut("143-216", "che");
		spellPut("143-217", "jiao,yao");
		spellPut("143-218", "hui");
		spellPut("143-219", "mei");
		spellPut("143-220", "long");
		spellPut("143-221", "xiang");
		spellPut("143-222", "bao");
		spellPut("143-223", "qu,ju");
		spellPut("143-224", "le");
		spellPut("143-225", "ren");
		spellPut("143-226", "ding,ting");
		spellPut("143-227", "gai");
		spellPut("143-228", "ren");
		spellPut("143-229", "gan,han");
		spellPut("143-230", "yi,qi");
		spellPut("143-231", "shi,tai");
		spellPut("143-232", "xi,lie");
		spellPut("143-233", "fan");
		spellPut("143-234", "ying");
		spellPut("143-235", "min,wen");
		spellPut("143-236", "min,wen");
		spellPut("143-237", "wu");
		spellPut("143-238", "ji");
		spellPut("143-239", "xi");
		spellPut("143-240", "jia");
		spellPut("143-241", "wan");
		spellPut("143-242", "cong");
		spellPut("143-243", "yu,shu");
		spellPut("143-244", "qi,shi");
		spellPut("143-245", "cui");
		spellPut("143-246", "tai");
		spellPut("143-247", "tun,zhun,dun");
		spellPut("143-248", "qian,qin");
		spellPut("143-249", "hun");
		spellPut("143-250", "xiong");
		spellPut("143-251", "kuang,wang");
		spellPut("143-252", "xian");
		spellPut("143-253", "kang,hang");
		spellPut("143-254", "ju");
	}

	private static void init15() {
		spellPut("144-64", "yi");
		spellPut("144-65", "bao");
		spellPut("144-66", "min,men");
		spellPut("144-67", "pei");
		spellPut("144-68", "kou,ju");
		spellPut("144-69", "ban");
		spellPut("144-70", "nao,niu");
		spellPut("144-71", "tie,zhan");
		spellPut("144-72", "hu,gu");
		spellPut("144-73", "cu,ju,zu");
		spellPut("144-74", "you,chou");
		spellPut("144-75", "di");
		spellPut("144-76", "tu,die");
		spellPut("144-77", "you");
		spellPut("144-78", "fu");
		spellPut("144-79", "xi");
		spellPut("144-80", "bi");
		spellPut("144-81", "you,yao");
		spellPut("144-82", "xuan");
		spellPut("144-83", "cong");
		spellPut("144-84", "bing");
		spellPut("144-85", "huang");
		spellPut("144-86", "xu,xue");
		spellPut("144-87", "bi,pi");
		spellPut("144-88", "shu");
		spellPut("144-89", "xi,shu");
		spellPut("144-90", "tan");
		spellPut("144-91", "yong");
		spellPut("144-92", "mi");
		spellPut("144-93", "gi");
		spellPut("144-94", "shi");
		spellPut("144-95", "xi");
		spellPut("144-96", "lao");
		spellPut("144-97", "heng");
		spellPut("144-98", "kuang");
		spellPut("144-99", "mou");
		spellPut("144-100", "zhi");
		spellPut("144-101", "xie");
		spellPut("144-102", "tiao,yao");
		spellPut("144-103", "die");
		spellPut("144-104", "hao");
		spellPut("144-105", "gui");
		spellPut("144-106", "xi,qi,xu");
		spellPut("144-107", "xiao,jiao");
		spellPut("144-108", "si");
		spellPut("144-109", "hu,kua");
		spellPut("144-110", "qiu");
		spellPut("144-111", "hui");
		spellPut("144-112", "chi");
		spellPut("144-113", "yi");
		spellPut("144-114", "xiong");
		spellPut("144-115", "guai");
		spellPut("144-116", "lin");
		spellPut("144-117", "chi");
		spellPut("144-118", "shang");
		spellPut("144-119", "quan,zhuan");
		spellPut("144-120", "yue");
		spellPut("144-121", "peng");
		spellPut("144-122", "de");
		spellPut("144-123", "hui");
		spellPut("144-124", "qiu");
		spellPut("144-125", "mang");
		spellPut("144-126", "yong");
		spellPut("144-128", "yuan,juan");
		spellPut("144-129", "pi");
		spellPut("144-130", "yue");
		spellPut("144-131", "yu,shu");
		spellPut("144-132", "tu");
		spellPut("144-133", "jie,ke");
		spellPut("144-134", "zhe");
		spellPut("144-135", "lin");
		spellPut("144-136", "hao,jiao");
		spellPut("144-137", "qie");
		spellPut("144-138", "ti");
		spellPut("144-139", "bu");
		spellPut("144-140", "qian");
		spellPut("144-141", "xi");
		spellPut("144-142", "man,men");
		spellPut("144-143", "yi");
		spellPut("144-144", "heng");
		spellPut("144-145", "cheng");
		spellPut("144-146", "wu");
		spellPut("144-147", "li");
		spellPut("144-148", "liang");
		spellPut("144-149", "cong");
		spellPut("144-150", "yi,nian");
		spellPut("144-151", "li");
		spellPut("144-152", "nao");
		spellPut("144-153", "e");
		spellPut("144-154", "wu");
		spellPut("144-155", "cong");
		spellPut("144-156", "de");
		spellPut("144-157", "chang");
		spellPut("144-158", "men");
		spellPut("144-159", "li");
		spellPut("144-160", "guan");
		spellPut("144-161", "guan");
		spellPut("144-162", "qi");
		spellPut("144-163", "kong");
		spellPut("144-164", "tian");
		spellPut("144-165", "lun");
		spellPut("144-166", "xi");
		spellPut("144-167", "kan");
		spellPut("144-168", "gun");
		spellPut("144-169", "ni");
		spellPut("144-170", "dun");
		spellPut("144-171", "guo");
		spellPut("144-172", "zhan");
		spellPut("144-173", "yuan,wan");
		spellPut("144-174", "jin");
		spellPut("144-175", "ji");
		spellPut("144-176", "lan,lin");
		spellPut("144-177", "yu,xu");
		spellPut("144-178", "he");
		spellPut("144-179", "juan,quan");
		spellPut("144-180", "tan,dan");
		spellPut("144-181", "ti");
		spellPut("144-182", "nian");
		spellPut("144-183", "chuo,chui");
		spellPut("144-184", "hun,men");
		spellPut("144-185", "xin");
		spellPut("144-186", "e,wu");
		spellPut("144-187", "suo,rui");
		spellPut("144-188", "zong");
		spellPut("144-189", "jian");
		spellPut("144-190", "yong");
		spellPut("144-191", "de");
		spellPut("144-192", "nao");
		spellPut("144-193", "yun");
		spellPut("144-194", "die");
		spellPut("144-195", "chun");
		spellPut("144-196", "qiong");
		spellPut("144-197", "ce");
		spellPut("144-198", "bian");
		spellPut("144-199", "min");
		spellPut("144-200", "zong");
		spellPut("144-201", "ti,shi");
		spellPut("144-202", "bei");
		spellPut("144-203", "xuan");
		spellPut("144-204", "wei");
		spellPut("144-205", "ge");
		spellPut("144-206", "wei");
		spellPut("144-207", "bi");
		spellPut("144-208", "xuan");
		spellPut("144-209", "huan");
		spellPut("144-210", "mian");
		spellPut("144-211", "yong");
		spellPut("144-212", "qi,kai");
		spellPut("144-213", "dang,shang,tang,yang");
		spellPut("144-214", "yin");
		spellPut("144-215", "chen,xin,dan");
		spellPut("144-216", "mao");
		spellPut("144-217", "ke,qia");
		spellPut("144-218", "ke");
		spellPut("144-219", "ai");
		spellPut("144-220", "qie");
		spellPut("144-221", "yan");
		spellPut("144-222", "nuo");
		spellPut("144-223", "cong,song");
		spellPut("144-224", "sai,si");
		spellPut("144-225", "ying");
		spellPut("144-226", "que");
		spellPut("144-227", "gong,hong");
		spellPut("144-228", "yun");
		spellPut("144-229", "su,shuo");
		spellPut("144-230", "qi");
		spellPut("144-231", "yao");
		spellPut("144-232", "song");
		spellPut("144-233", "huang");
		spellPut("144-234", "ji");
		spellPut("144-235", "gu");
		spellPut("144-236", "ju");
		spellPut("144-237", "chuang");
		spellPut("144-238", "ni");
		spellPut("144-239", "xie");
		spellPut("144-240", "kai");
		spellPut("144-241", "zheng");
		spellPut("144-242", "yong");
		spellPut("144-243", "cao");
		spellPut("144-244", "xun");
		spellPut("144-245", "shen");
		spellPut("144-246", "bo");
		spellPut("144-247", "kai,xi");
		spellPut("144-248", "xi,xie");
		spellPut("144-249", "hun");
		spellPut("144-250", "yong");
		spellPut("144-251", "yang");
		spellPut("144-252", "li");
		spellPut("144-253", "cao,sao");
		spellPut("144-254", "tao");
	}

	private static void init16() {
		spellPut("145-64", "yin");
		spellPut("145-65", "xu,chu");
		spellPut("145-66", "tai");
		spellPut("145-67", "yun");
		spellPut("145-68", "ming");
		spellPut("145-69", "gong,hong");
		spellPut("145-70", "cao,cong");
		spellPut("145-71", "piao");
		spellPut("145-72", "mu");
		spellPut("145-73", "guo");
		spellPut("145-74", "chi");
		spellPut("145-75", "can");
		spellPut("145-76", "can");
		spellPut("145-77", "can");
		spellPut("145-78", "cui");
		spellPut("145-79", "min");
		spellPut("145-80", "zhang");
		spellPut("145-81", "tong");
		spellPut("145-82", "ao");
		spellPut("145-83", "shuang");
		spellPut("145-84", "guan");
		spellPut("145-85", "que");
		spellPut("145-86", "zao");
		spellPut("145-87", "jiu");
		spellPut("145-88", "lian");
		spellPut("145-89", "ou");
		spellPut("145-90", "song");
		spellPut("145-91", "qin,jin");
		spellPut("145-92", "yin");
		spellPut("145-93", "lv");
		spellPut("145-94", "shang");
		spellPut("145-95", "tuan");
		spellPut("145-96", "man");
		spellPut("145-97", "qian");
		spellPut("145-98", "she");
		spellPut("145-99", "qing");
		spellPut("145-100", "di,chi");
		spellPut("145-101", "zhi,zhe");
		spellPut("145-102", "lou,lv");
		spellPut("145-103", "juan");
		spellPut("145-104", "qi");
		spellPut("145-105", "qi");
		spellPut("145-106", "yu");
		spellPut("145-107", "ping");
		spellPut("145-108", "liao");
		spellPut("145-109", "cong");
		spellPut("145-110", "you");
		spellPut("145-111", "chong");
		spellPut("145-112", "zhi");
		spellPut("145-113", "tong");
		spellPut("145-114", "cheng");
		spellPut("145-115", "qi");
		spellPut("145-116", "qu");
		spellPut("145-117", "peng");
		spellPut("145-118", "bei");
		spellPut("145-119", "qiong");
		spellPut("145-120", "jiao");
		spellPut("145-121", "chi");
		spellPut("145-122", "lian");
		spellPut("145-123", "ping");
		spellPut("145-124", "kui");
		spellPut("145-125", "hui");
		spellPut("145-126", "cheng,deng,zheng");
		spellPut("145-128", "yin");
		spellPut("145-129", "yin");
		spellPut("145-130", "xi");
		spellPut("145-131", "xi");
		spellPut("145-132", "dan,da");
		spellPut("145-133", "tan");
		spellPut("145-134", "duo");
		spellPut("145-135", "dui,dun,tun");
		spellPut("145-136", "su");
		spellPut("145-137", "jue");
		spellPut("145-138", "ce");
		spellPut("145-139", "xiao,jiao");
		spellPut("145-140", "fan");
		spellPut("145-141", "fen");
		spellPut("145-142", "lao");
		spellPut("145-143", "lao");
		spellPut("145-144", "xian");
		spellPut("145-145", "min");
		spellPut("145-146", "liao");
		spellPut("145-147", "wu");
		spellPut("145-148", "can");
		spellPut("145-149", "jue");
		spellPut("145-150", "cu");
		spellPut("145-151", "xian");
		spellPut("145-152", "tan");
		spellPut("145-153", "sheng");
		spellPut("145-154", "pi");
		spellPut("145-155", "yi");
		spellPut("145-156", "xian");
		spellPut("145-157", "nao,nang");
		spellPut("145-158", "dan");
		spellPut("145-159", "tan");
		spellPut("145-160", "jing");
		spellPut("145-161", "song");
		spellPut("145-162", "jiao,ji");
		spellPut("145-163", "wei");
		spellPut("145-164", "xuan,huan");
		spellPut("145-165", "qin");
		spellPut("145-166", "qin");
		spellPut("145-167", "ju");
		spellPut("145-168", "cao,sao");
		spellPut("145-169", "ken");
		spellPut("145-170", "ying");
		spellPut("145-171", "yi");
		spellPut("145-172", "lin");
		spellPut("145-173", "se");
		spellPut("145-174", "jun");
		spellPut("145-175", "huai");
		spellPut("145-176", "ai");
		spellPut("145-177", "yan");
		spellPut("145-178", "guo");
		spellPut("145-179", "xia");
		spellPut("145-180", "chi");
		spellPut("145-181", "yu");
		spellPut("145-182", "yin");
		spellPut("145-183", "dai");
		spellPut("145-184", "meng");
		spellPut("145-185", "ai,yi,ni");
		spellPut("145-186", "meng");
		spellPut("145-187", "dui");
		spellPut("145-188", "qi,ji");
		spellPut("145-189", "mo");
		spellPut("145-190", "lan,xian");
		spellPut("145-191", "men");
		spellPut("145-192", "chou");
		spellPut("145-193", "zhi");
		spellPut("145-194", "nuo");
		spellPut("145-195", "yan");
		spellPut("145-196", "yang");
		spellPut("145-197", "bo");
		spellPut("145-198", "zhi");
		spellPut("145-199", "kuang");
		spellPut("145-200", "kuang");
		spellPut("145-201", "you");
		spellPut("145-202", "fu");
		spellPut("145-203", "liu");
		spellPut("145-204", "mie");
		spellPut("145-205", "cheng");
		spellPut("145-206", "hui");
		spellPut("145-207", "chan");
		spellPut("145-208", "lan");
		spellPut("145-209", "huai");
		spellPut("145-210", "xuan");
		spellPut("145-211", "rang");
		spellPut("145-212", "chan");
		spellPut("145-213", "ji");
		spellPut("145-214", "ju");
		spellPut("145-215", "huan");
		spellPut("145-216", "she");
		spellPut("145-217", "lian");
		spellPut("145-218", "nan");
		spellPut("145-219", "mi,mo");
		spellPut("145-220", "tang");
		spellPut("145-221", "jue");
		spellPut("145-222", "gang,zhuang");
		spellPut("145-223", "gang,zhuang");
		spellPut("145-224", "yue");
		spellPut("145-225", "ge");
		spellPut("145-226", "jian");
		spellPut("145-227", "dong");
		spellPut("145-228", "die");
		spellPut("145-229", "zei");
		spellPut("145-230", "jia");
		spellPut("145-231", "zhi");
		spellPut("145-232", "kui");
		spellPut("145-233", "zhan");
		spellPut("145-234", "qiang");
		spellPut("145-235", "ge");
		spellPut("145-236", "jian");
		spellPut("145-237", "yu");
		spellPut("145-238", "yan");
		spellPut("145-239", "xi,hu");
		spellPut("145-240", "zhan");
		spellPut("145-241", "xi,hu");
		spellPut("145-242", "xi,hu");
		spellPut("145-243", "qu");
		spellPut("145-244", "hu");
		spellPut("145-245", "hu");
		spellPut("145-246", "e");
		spellPut("145-247", "shi");
		spellPut("145-248", "ti");
		spellPut("145-249", "mao");
		spellPut("145-250", "dian");
		spellPut("145-251", "shang,jiong");
		spellPut("145-252", "yi");
		spellPut("145-253", "yi");
		spellPut("145-254", "yan");
	}

	private static void init17() {
		spellPut("146-64", "qiu");
		spellPut("146-65", "le,li,cai");
		spellPut("146-66", "fan,fu");
		spellPut("146-67", "hB me ru");
		spellPut("146-68", "zai");
		spellPut("146-69", "zhang");
		spellPut("146-70", "diao,di,yue,li");
		spellPut("146-71", "yu,wu");
		spellPut("146-72", "yu,wu,ku");
		spellPut("146-73", "han");
		spellPut("146-74", "shen");
		spellPut("146-75", "cha");
		spellPut("146-76", "tuo,chi,yi");
		spellPut("146-77", "gu,xi,ge,jie");
		spellPut("146-78", "wu");
		spellPut("146-79", "den");
		spellPut("146-80", "sB te");
		spellPut("146-81", "xi,cha,qi");
		spellPut("146-82", "qian,qin");
		spellPut("146-83", "jia");
		spellPut("146-84", "yu");
		spellPut("146-85", "ba,ao");
		spellPut("146-86", "xi,zhe");
		spellPut("146-87", "zhi");
		spellPut("146-88", "zhi,sun,kan");
		spellPut("146-89", "den");
		spellPut("146-90", "yan");
		spellPut("146-91", "kuang,wang,zai");
		spellPut("146-92", "bian");
		spellPut("146-93", "ju");
		spellPut("146-94", "wen");
		spellPut("146-95", "hu,gu");
		spellPut("146-96", "yue");
		spellPut("146-97", "qin");
		spellPut("146-98", "dan,shen");
		spellPut("146-99", "zheng");
		spellPut("146-100", "yun");
		spellPut("146-101", "wan");
		spellPut("146-102", "ne,ni,rui,na");
		spellPut("146-103", "pou");
		spellPut("146-104", "pou,fu");
		spellPut("146-105", "bB");
		spellPut("146-106", "ao,niu");
		spellPut("146-107", "ze,zhBi");
		spellPut("146-108", "yun");
		spellPut("146-109", "bing");
		spellPut("146-110", "zhi,zhai");
		spellPut("146-111", "nan");
		spellPut("146-112", "bu,pu");
		spellPut("146-113", "yao,tao");
		spellPut("146-114", "zhen");
		spellPut("146-115", "zha");
		spellPut("146-116", "yang");
		spellPut("146-117", "he,qia");
		spellPut("146-118", "ni");
		spellPut("146-119", "ye");
		spellPut("146-120", "chi");
		spellPut("146-121", "pi,pei");
		spellPut("146-122", "jia");
		spellPut("146-123", "mei");
		spellPut("146-124", "qu");
		spellPut("146-125", "zhu");
		spellPut("146-126", "jia,ya");
		spellPut("146-128", "zha");
		spellPut("146-129", "pao");
		spellPut("146-130", "na");
		spellPut("146-131", "qian");
		spellPut("146-132", "tuo");
		spellPut("146-133", "bai");
		spellPut("146-134", "di");
		spellPut("146-135", "ju");
		spellPut("146-136", "kuo");
		spellPut("146-137", "qia");
		spellPut("146-138", "qian");
		spellPut("146-139", "hen");
		spellPut("146-140", "nin");
		spellPut("146-141", "gong");
		spellPut("146-142", "cun,zun");
		spellPut("146-143", "yi,chi,hai");
		spellPut("146-144", "xie");
		spellPut("146-145", "ce,se,chuo");
		spellPut("146-146", "hui");
		spellPut("146-147", "bai");
		spellPut("146-148", "zhi");
		spellPut("146-149", "kuo,guang");
		spellPut("146-150", "duo");
		spellPut("146-151", "duo");
		spellPut("146-152", "nong");
		spellPut("146-153", "zhen");
		spellPut("146-154", "ge");
		spellPut("146-155", "jiao");
		spellPut("146-156", "dong");
		spellPut("146-157", "ru,na");
		spellPut("146-158", "lie");
		spellPut("146-159", "zha");
		spellPut("146-160", "lv");
		spellPut("146-161", "die,she");
		spellPut("146-162", "jue");
		spellPut("146-163", "lie ri");
		spellPut("146-164", "ju");
		spellPut("146-165", "ya");
		spellPut("146-166", "xian");
		spellPut("146-167", "yu");
		spellPut("146-168", "tuo,shui");
		spellPut("146-169", "bo");
		spellPut("146-170", "geng");
		spellPut("146-171", "ti");
		spellPut("146-172", "cheng");
		spellPut("146-173", "suo,sB,shB");
		spellPut("146-174", "keng,qian");
		spellPut("146-175", "mei");
		spellPut("146-176", "nong");
		spellPut("146-177", "ju");
		spellPut("146-178", "bang,peng");
		spellPut("146-179", "jian");
		spellPut("146-180", "shan");
		spellPut("146-181", "nuo");
		spellPut("146-182", "xie,jia");
		spellPut("146-183", "cha");
		spellPut("146-184", "peng");
		spellPut("146-185", "jiao,ku");
		spellPut("146-186", "jiu");
		spellPut("146-187", "huo,chi");
		spellPut("146-188", "tu,shu,cha");
		spellPut("146-189", "pou,fu");
		spellPut("146-190", "ze");
		spellPut("146-191", "shu,song,sou");
		spellPut("146-192", "ye,yu");
		spellPut("146-193", "jue,zhuo");
		spellPut("146-194", "wan");
		spellPut("146-195", "bu,pu,zhi");
		spellPut("146-196", "zun");
		spellPut("146-197", "ye");
		spellPut("146-198", "zhai");
		spellPut("146-199", "lv");
		spellPut("146-200", "sou");
		spellPut("146-201", "tuo,shui");
		spellPut("146-202", "bang");
		spellPut("146-203", "wei");
		spellPut("146-204", "wan,yu");
		spellPut("146-205", "qin");
		spellPut("146-206", "she");
		spellPut("146-207", "min");
		spellPut("146-208", "men");
		spellPut("146-209", "fu,bu");
		spellPut("146-210", "dao");
		spellPut("146-211", "wo,luo");
		spellPut("146-212", "juan,quan");
		spellPut("146-213", "yue");
		spellPut("146-214", "zong");
		spellPut("146-215", "chen");
		spellPut("146-216", "tu");
		spellPut("146-217", "ben");
		spellPut("146-218", "ruo,wei,re");
		spellPut("146-219", "zuo");
		spellPut("146-220", "wo,xia");
		spellPut("146-221", "qi");
		spellPut("146-222", "cheng");
		spellPut("146-223", "sao");
		spellPut("146-224", "lun");
		spellPut("146-225", "qing,qian");
		spellPut("146-226", "gang");
		spellPut("146-227", "di");
		spellPut("146-228", "hun");
		spellPut("146-229", "qi");
		spellPut("146-230", "shu");
		spellPut("146-231", "qian,wan");
		spellPut("146-232", "ling");
		spellPut("146-233", "ya");
		spellPut("146-234", "zheng");
		spellPut("146-235", "liang");
		spellPut("146-236", "gua");
		spellPut("146-237", "ni,nie,yi");
		spellPut("146-238", "huo,xu");
		spellPut("146-239", "shan,yan");
		spellPut("146-240", "zheng,ding");
		spellPut("146-241", "cai");
		spellPut("146-242", "bing");
		spellPut("146-243", "ti");
		spellPut("146-244", "zou,zhou,chou");
		spellPut("146-245", "ken");
		spellPut("146-246", "pa");
		spellPut("146-247", "jie");
		spellPut("146-248", "ming");
		spellPut("146-249", "jie");
		spellPut("146-250", "meng");
		spellPut("146-251", "sao");
		spellPut("146-252", "peng");
		spellPut("146-253", "nuo");
		spellPut("146-254", "jian");
	}

	private static void init18() {
		spellPut("147-64", "zheng,keng");
		spellPut("147-65", "jiu,you");
		spellPut("147-66", "jian");
		spellPut("147-67", "yan");
		spellPut("147-68", "nan");
		spellPut("147-69", "hong");
		spellPut("147-70", "pi,che");
		spellPut("147-71", "wei");
		spellPut("147-72", "sai,zong,cai");
		spellPut("147-73", "nie");
		spellPut("147-74", "shi");
		spellPut("147-75", "zong,song");
		spellPut("147-76", "zhen");
		spellPut("147-77", "xun");
		spellPut("147-78", "huang,yong");
		spellPut("147-79", "bian");
		spellPut("147-80", "yang");
		spellPut("147-81", "huan");
		spellPut("147-82", "yan");
		spellPut("147-83", "zan,zuan");
		spellPut("147-84", "xu,ju");
		spellPut("147-85", "ke,qia");
		spellPut("147-86", "ji");
		spellPut("147-87", "ti,di");
		spellPut("147-88", "la");
		spellPut("147-89", "la");
		spellPut("147-90", "cheng");
		spellPut("147-91", "jiu");
		spellPut("147-92", "tu");
		spellPut("147-93", "hui");
		spellPut("147-94", "gen");
		spellPut("147-95", "chong,dong");
		spellPut("147-96", "xiao");
		spellPut("147-97", "xie");
		spellPut("147-98", "qian,jian");
		spellPut("147-99", "cha");
		spellPut("147-100", "bei");
		spellPut("147-101", "yao");
		spellPut("147-102", "wei");
		spellPut("147-103", "beng");
		spellPut("147-104", "wen");
		spellPut("147-105", "zong");
		spellPut("147-106", "gen");
		spellPut("147-107", "gou");
		spellPut("147-108", "qin");
		spellPut("147-109", "rong");
		spellPut("147-110", "que");
		spellPut("147-111", "chou,zou");
		spellPut("147-112", "sun");
		spellPut("147-113", "sun");
		spellPut("147-114", "rong,nang");
		spellPut("147-115", "bang,peng");
		spellPut("147-116", "ke,e");
		spellPut("147-117", "yao");
		spellPut("147-118", "dao");
		spellPut("147-119", "zhi");
		spellPut("147-120", "nu,nuo,nou");
		spellPut("147-121", "la,xie,xian");
		spellPut("147-122", "qiu");
		spellPut("147-123", "xian");
		spellPut("147-124", "jin");
		spellPut("147-125", "mie");
		spellPut("147-126", "e");
		spellPut("147-128", "chui");
		spellPut("147-129", "shan");
		spellPut("147-130", "ta");
		spellPut("147-131", "jie,zhe");
		spellPut("147-132", "pan,ban,po");
		spellPut("147-133", "li");
		spellPut("147-134", "tao");
		spellPut("147-135", "hu,ku");
		spellPut("147-136", "zhi,nai");
		spellPut("147-137", "wa");
		spellPut("147-138", "hua");
		spellPut("147-139", "wen");
		spellPut("147-140", "qiang,cheng");
		spellPut("147-141", "tian,shen");
		spellPut("147-142", "zhen");
		spellPut("147-143", "e");
		spellPut("147-144", "na,nuo");
		spellPut("147-145", "quan");
		spellPut("147-146", "zha");
		spellPut("147-147", "wu");
		spellPut("147-148", "she");
		spellPut("147-149", "gang");
		spellPut("147-150", "sou");
		spellPut("147-151", "sa,sha,shai");
		spellPut("147-152", "chan,sun");
		spellPut("147-153", "suo");
		spellPut("147-154", "jiu,liu,liao,jiao,nao");
		spellPut("147-155", "chong");
		spellPut("147-156", "chuang");
		spellPut("147-157", "guai");
		spellPut("147-158", "feng,peng");
		spellPut("147-159", "di,tu,zhi");
		spellPut("147-160", "qi,ji,cha");
		spellPut("147-161", "sou,song");
		spellPut("147-162", "lian");
		spellPut("147-163", "cheng");
		spellPut("147-164", "chi");
		spellPut("147-165", "guan");
		spellPut("147-166", "lu");
		spellPut("147-167", "lou");
		spellPut("147-168", "zong");
		spellPut("147-169", "gai,xi");
		spellPut("147-170", "hu,chu");
		spellPut("147-171", "zha");
		spellPut("147-172", "qiang");
		spellPut("147-173", "tang");
		spellPut("147-174", "hua");
		spellPut("147-175", "zhi,nai");
		spellPut("147-176", "jiang,qiang");
		spellPut("147-177", "gui");
		spellPut("147-178", "ying");
		spellPut("147-179", "ao,qiao");
		spellPut("147-180", "zhi");
		spellPut("147-181", "nie,che");
		spellPut("147-182", "man");
		spellPut("147-183", "chan,can");
		spellPut("147-184", "kou");
		spellPut("147-185", "chu");
		spellPut("147-186", "se,mi,su");
		spellPut("147-187", "tuan");
		spellPut("147-188", "jiao,chao");
		spellPut("147-189", "chan,xian,can,shan");
		spellPut("147-190", "keng,qian");
		spellPut("147-191", "biao");
		spellPut("147-192", "jiang");
		spellPut("147-193", "yao");
		spellPut("147-194", "gou");
		spellPut("147-195", "qian");
		spellPut("147-196", "ji");
		spellPut("147-197", "pie");
		spellPut("147-198", "lao");
		spellPut("147-199", "dun");
		spellPut("147-200", "xian");
		spellPut("147-201", "ruan");
		spellPut("147-202", "gui");
		spellPut("147-203", "zan,zen,qian");
		spellPut("147-204", "yi");
		spellPut("147-205", "xian");
		spellPut("147-206", "cheng");
		spellPut("147-207", "nao");
		spellPut("147-208", "hong");
		spellPut("147-209", "heng,guang");
		spellPut("147-210", "da");
		spellPut("147-211", "nian");
		spellPut("147-212", "lin");
		spellPut("147-213", "zheng,cheng");
		spellPut("147-214", "hui,wei");
		spellPut("147-215", "jiao");
		spellPut("147-216", "ji");
		spellPut("147-217", "cao");
		spellPut("147-218", "dan");
		spellPut("147-219", "dan,shan");
		spellPut("147-220", "bo");
		spellPut("147-221", "che");
		spellPut("147-222", "jue");
		spellPut("147-223", "xiao,sou");
		spellPut("147-224", "ben");
		spellPut("147-225", "fu");
		spellPut("147-226", "zhuo");
		spellPut("147-227", "wei,tuo");
		spellPut("147-228", "pu");
		spellPut("147-229", "qin");
		spellPut("147-230", "dun");
		spellPut("147-231", "hua");
		spellPut("147-232", "jiao");
		spellPut("147-233", "ta");
		spellPut("147-234", "qiao,yao,ji");
		spellPut("147-235", "zhua,wo");
		spellPut("147-236", "jian");
		spellPut("147-237", "yong");
		spellPut("147-238", "nang");
		spellPut("147-239", "lu");
		spellPut("147-240", "zhuo");
		spellPut("147-241", "ze,zhai");
		spellPut("147-242", "pu");
		spellPut("147-243", "chuo");
		spellPut("147-244", "ji");
		spellPut("147-245", "dang");
		spellPut("147-246", "se");
		spellPut("147-247", "qing,jing");
		spellPut("147-248", "jie");
		spellPut("147-249", "kuai");
		spellPut("147-250", "dan");
		spellPut("147-251", "xie");
		spellPut("147-252", "qia,jia,ye");
		spellPut("147-253", "ao");
		spellPut("147-254", "ju");
	}

	private static void init19() {
		spellPut("148-64", "ye");
		spellPut("148-65", "e");
		spellPut("148-66", "meng");
		spellPut("148-67", "mi");
		spellPut("148-68", "ji");
		spellPut("148-69", "tai");
		spellPut("148-70", "dao");
		spellPut("148-71", "lan");
		spellPut("148-72", "ju");
		spellPut("148-73", "ye");
		spellPut("148-74", "ru");
		spellPut("148-75", "ye");
		spellPut("148-76", "ye");
		spellPut("148-77", "ni");
		spellPut("148-78", "huo");
		spellPut("148-79", "jie");
		spellPut("148-80", "bin");
		spellPut("148-81", "ning");
		spellPut("148-82", "ge");
		spellPut("148-83", "zhi");
		spellPut("148-84", "zhi,jie");
		spellPut("148-85", "kuo");
		spellPut("148-86", "mo");
		spellPut("148-87", "jian");
		spellPut("148-88", "xie");
		spellPut("148-89", "lie,la");
		spellPut("148-90", "tan");
		spellPut("148-91", "bai");
		spellPut("148-92", "sou");
		spellPut("148-93", "lu");
		spellPut("148-94", "li,luo,yue");
		spellPut("148-95", "rao");
		spellPut("148-96", "ti,zhi,zhai");
		spellPut("148-97", "yang");
		spellPut("148-98", "lei");
		spellPut("148-99", "ca,sa");
		spellPut("148-100", "shu");
		spellPut("148-101", "zan");
		spellPut("148-102", "nian");
		spellPut("148-103", "xian");
		spellPut("148-104", "jun,pei");
		spellPut("148-105", "li,luo");
		spellPut("148-106", "la,lai");
		spellPut("148-107", "huan");
		spellPut("148-108", "ying");
		spellPut("148-109", "lu,luo");
		spellPut("148-110", "long");
		spellPut("148-111", "qian");
		spellPut("148-112", "qian");
		spellPut("148-113", "qian");
		spellPut("148-114", "lan");
		spellPut("148-115", "xian,jian");
		spellPut("148-116", "ying");
		spellPut("148-117", "mei");
		spellPut("148-118", "chan");
		spellPut("148-119", "weng");
		spellPut("148-120", "cuan");
		spellPut("148-121", "xie");
		spellPut("148-122", "she,nie");
		spellPut("148-123", "luo");
		spellPut("148-124", "jun");
		spellPut("148-125", "mi,mo");
		spellPut("148-126", "chi");
		spellPut("148-128", "zan,cuan");
		spellPut("148-129", "luan");
		spellPut("148-130", "tan");
		spellPut("148-131", "li,shai");
		spellPut("148-132", "dian");
		spellPut("148-133", "wa");
		spellPut("148-134", "dang");
		spellPut("148-135", "jiao");
		spellPut("148-136", "lan");
		spellPut("148-137", "li,luo");
		spellPut("148-138", "gui");
		spellPut("148-139", "gui");
		spellPut("148-140", "qi,yi,ji");
		spellPut("148-141", "xun");
		spellPut("148-142", "kao");
		spellPut("148-143", "yi");
		spellPut("148-144", "gan,han");
		spellPut("148-145", "ban");
		spellPut("148-146", "po");
		spellPut("148-147", "dian");
		spellPut("148-148", "kou");
		spellPut("148-149", "min");
		spellPut("148-150", "wu,mou");
		spellPut("148-151", "he");
		spellPut("148-152", "ce");
		spellPut("148-153", "chu,shou");
		spellPut("148-154", "ge,guo,e");
		spellPut("148-155", "xu");
		spellPut("148-156", "jiao");
		spellPut("148-157", "chen");
		spellPut("148-158", "shen");
		spellPut("148-159", "duo,dui");
		spellPut("148-160", "yu");
		spellPut("148-161", "bai");
		spellPut("148-162", "xu");
		spellPut("148-163", "duo,dui");
		spellPut("148-164", "nie");
		spellPut("148-165", "dian");
		spellPut("148-166", "duo,que");
		spellPut("148-167", "yi");
		spellPut("148-168", "ke");
		spellPut("148-169", "yan");
		spellPut("148-170", "qi,yi,ji");
		spellPut("148-171", "tou");
		spellPut("148-172", "xiao,xue");
		spellPut("148-173", "duo,que");
		spellPut("148-174", "yang");
		spellPut("148-175", "xia");
		spellPut("148-176", "min");
		spellPut("148-177", "ai,zhu");
		spellPut("148-178", "ai,zhu");
		spellPut("148-179", "di");
		spellPut("148-180", "chen");
		spellPut("148-181", "shu,shuo");
		spellPut("148-182", "liao");
		spellPut("148-183", "qu");
		spellPut("148-184", "xiong,xuan");
		spellPut("148-185", "yi");
		spellPut("148-186", "jiao");
		spellPut("148-187", "shan");
		spellPut("148-188", "jiao");
		spellPut("148-189", "zhuo,zhu");
		spellPut("148-190", "yi,du");
		spellPut("148-191", "lian");
		spellPut("148-192", "bi");
		spellPut("148-193", "li,tai");
		spellPut("148-194", "xiao");
		spellPut("148-195", "xiao");
		spellPut("148-196", "xue");
		spellPut("148-197", "qi");
		spellPut("148-198", "qi");
		spellPut("148-199", "jue,jiao");
		spellPut("148-200", "zhai");
		spellPut("148-201", "lang");
		spellPut("148-202", "ban");
		spellPut("148-203", "yu,zhong");
		spellPut("148-204", "lan");
		spellPut("148-205", "wei,men");
		spellPut("148-206", "sheng");
		spellPut("148-207", "jia");
		spellPut("148-208", "jia");
		spellPut("148-209", "yu");
		spellPut("148-210", "jiao");
		spellPut("148-211", "tou,tiao");
		spellPut("148-212", "dou");
		spellPut("148-213", "yin,zhi");
		spellPut("148-214", "qiang");
		spellPut("148-215", "qu");
		spellPut("148-216", "zhan");
		spellPut("148-217", "zhuo");
		spellPut("148-218", "zhuo");
		spellPut("148-219", "zhuo");
		spellPut("148-220", "qin");
		spellPut("148-221", "lin");
		spellPut("148-222", "zhuo");
		spellPut("148-223", "chu");
		spellPut("148-224", "duan");
		spellPut("148-225", "zhu");
		spellPut("148-226", "chan,jie");
		spellPut("148-227", "hang");
		spellPut("148-228", "pei");
		spellPut("148-229", "liu,you");
		spellPut("148-230", "mie");
		spellPut("148-231", "qi");
		spellPut("148-232", "pi,bi");
		spellPut("148-233", "liu");
		spellPut("148-234", "fu");
		spellPut("148-235", "fang");
		spellPut("148-236", "jing");
		spellPut("148-237", "zhao");
		spellPut("148-238", "yi");
		spellPut("148-239", "shao");
		spellPut("148-240", "jian");
		spellPut("148-241", "e o si");
		spellPut("148-242", "zhi");
		spellPut("148-243", "fan");
		spellPut("148-244", "piao");
		spellPut("148-245", "fan");
		spellPut("148-246", "zhan");
		spellPut("148-247", "kuai");
		spellPut("148-248", "sui");
		spellPut("148-249", "yu");
		spellPut("148-250", "ji");
		spellPut("148-251", "ji");
		spellPut("148-252", "huo");
		spellPut("148-253", "xie");
		spellPut("148-254", "tiao");
	}

	private static void init20() {
		spellPut("149-64", "tai,ying");
		spellPut("149-65", "di,de");
		spellPut("149-66", "xu");
		spellPut("149-67", "chan");
		spellPut("149-68", "yang");
		spellPut("149-69", "shi");
		spellPut("149-70", "min");
		spellPut("149-71", "min");
		spellPut("149-72", "tun,zhun");
		spellPut("149-73", "chun");
		spellPut("149-74", "wu");
		spellPut("149-75", "bei");
		spellPut("149-76", "ban");
		spellPut("149-77", "jie");
		spellPut("149-78", "sheng");
		spellPut("149-79", "hu");
		spellPut("149-80", "fang");
		spellPut("149-81", "gui");
		spellPut("149-82", "xuan");
		spellPut("149-83", "fen");
		spellPut("149-84", "qin");
		spellPut("149-85", "hu");
		spellPut("149-86", "yan");
		spellPut("149-87", "ze");
		spellPut("149-88", "fang");
		spellPut("149-89", "shen");
		spellPut("149-90", "ju");
		spellPut("149-91", "yang");
		spellPut("149-92", "bing");
		spellPut("149-93", "xuan");
		spellPut("149-94", "po");
		spellPut("149-95", "zhen");
		spellPut("149-96", "ling");
		spellPut("149-97", "hao");
		spellPut("149-98", "mo");
		spellPut("149-99", "bian");
		spellPut("149-100", "xu");
		spellPut("149-101", "hun");
		spellPut("149-102", "zong");
		spellPut("149-103", "shi");
		spellPut("149-104", "fei");
		spellPut("149-105", "die,yi");
		spellPut("149-106", "wen");
		spellPut("149-107", "dong");
		spellPut("149-108", "ai");
		spellPut("149-109", "bing");
		spellPut("149-110", "ang");
		spellPut("149-111", "long");
		spellPut("149-112", "kuang");
		spellPut("149-113", "tiao");
		spellPut("149-114", "shi");
		spellPut("149-115", "huang");
		spellPut("149-116", "xuan");
		spellPut("149-117", "kui");
		spellPut("149-118", "xu,kua");
		spellPut("149-119", "jiao");
		spellPut("149-120", "jin");
		spellPut("149-121", "zhi");
		spellPut("149-122", "tong");
		spellPut("149-123", "hong");
		spellPut("149-124", "gai");
		spellPut("149-125", "xiang");
		spellPut("149-126", "han");
		spellPut("149-128", "jun");
		spellPut("149-129", "xian");
		spellPut("149-130", "kun");
		spellPut("149-131", "zhou");
		spellPut("149-132", "xi");
		spellPut("149-133", "sheng");
		spellPut("149-134", "zhe");
		spellPut("149-135", "zhe");
		spellPut("149-136", "wan");
		spellPut("149-137", "hao");
		spellPut("149-138", "wan");
		spellPut("149-139", "tian");
		spellPut("149-140", "zhuo");
		spellPut("149-141", "zui");
		spellPut("149-142", "zhou");
		spellPut("149-143", "shan");
		spellPut("149-144", "ni");
		spellPut("149-145", "xi");
		spellPut("149-146", "qi,du");
		spellPut("149-147", "zheng");
		spellPut("149-148", "yi");
		spellPut("149-149", "an,yan");
		spellPut("149-150", "wan");
		spellPut("149-151", "lin");
		spellPut("149-152", "cheng");
		spellPut("149-153", "wang");
		spellPut("149-154", "xiao");
		spellPut("149-155", "fei");
		spellPut("149-156", "xuan");
		spellPut("149-157", "yi");
		spellPut("149-158", "yun");
		spellPut("149-159", "hui");
		spellPut("149-160", "xu");
		spellPut("149-161", "min");
		spellPut("149-162", "ye");
		spellPut("149-163", "ying");
		spellPut("149-164", "shu,du");
		spellPut("149-165", "wei");
		spellPut("149-166", "qing");
		spellPut("149-167", "mao");
		spellPut("149-168", "nan");
		spellPut("149-169", "jian,lan");
		spellPut("149-170", "yang");
		spellPut("149-171", "chun");
		spellPut("149-172", "yao");
		spellPut("149-173", "suo");
		spellPut("149-174", "pu");
		spellPut("149-175", "jiao");
		spellPut("149-176", "kai");
		spellPut("149-177", "hao");
		spellPut("149-178", "weng");
		spellPut("149-179", "chang");
		spellPut("149-180", "qi");
		spellPut("149-181", "hao");
		spellPut("149-182", "yan");
		spellPut("149-183", "li");
		spellPut("149-184", "ji");
		spellPut("149-185", "men");
		spellPut("149-186", "zan");
		spellPut("149-187", "xie");
		spellPut("149-188", "hao");
		spellPut("149-189", "mu");
		spellPut("149-190", "cong");
		spellPut("149-191", "ni");
		spellPut("149-192", "zhang");
		spellPut("149-193", "hui");
		spellPut("149-194", "han");
		spellPut("149-195", "xuan");
		spellPut("149-196", "chuan");
		spellPut("149-197", "liao");
		spellPut("149-198", "tan");
		spellPut("149-199", "jing");
		spellPut("149-200", "pie");
		spellPut("149-201", "lin");
		spellPut("149-202", "xi");
		spellPut("149-203", "yi");
		spellPut("149-204", "ji");
		spellPut("149-205", "huang");
		spellPut("149-206", "dai");
		spellPut("149-207", "ye");
		spellPut("149-208", "ye");
		spellPut("149-209", "li");
		spellPut("149-210", "tan");
		spellPut("149-211", "tong");
		spellPut("149-212", "xiao");
		spellPut("149-213", "fei");
		spellPut("149-214", "shen");
		spellPut("149-215", "zhao");
		spellPut("149-216", "hao");
		spellPut("149-217", "yi");
		spellPut("149-218", "xiang");
		spellPut("149-219", "xing");
		spellPut("149-220", "shen");
		spellPut("149-221", "jiao");
		spellPut("149-222", "bao");
		spellPut("149-223", "jing");
		spellPut("149-224", "yan");
		spellPut("149-225", "ai");
		spellPut("149-226", "ye");
		spellPut("149-227", "ru");
		spellPut("149-228", "meng");
		spellPut("149-229", "li");
		spellPut("149-230", "chen");
		spellPut("149-231", "kuang");
		spellPut("149-232", "die");
		spellPut("149-233", "uu");
		spellPut("149-234", "yan");
		spellPut("149-235", "huo");
		spellPut("149-236", "lu");
		spellPut("149-237", "rong");
		spellPut("149-238", "long");
		spellPut("149-239", "luo");
		spellPut("149-240", "luan");
		spellPut("149-241", "shai");
		spellPut("149-242", "tang");
		spellPut("149-243", "yan");
		spellPut("149-244", "zhu");
		spellPut("149-245", "yue");
		spellPut("149-246", "ye");
		spellPut("149-247", "hu");
		spellPut("149-248", "shu");
		spellPut("149-249", "cao");
		spellPut("149-250", "sheng");
		spellPut("149-251", "zeng,ceng");
		spellPut("149-252", "can,qian,jian");
		spellPut("149-253", "xu");
		spellPut("149-254", "hui,kuai");
	}

	private static void init21() {
		spellPut("150-64", "yin");
		spellPut("150-65", "qie,he");
		spellPut("150-66", "fen");
		spellPut("150-67", "bi,pi");
		spellPut("150-68", "fen,ban");
		spellPut("150-69", "ling");
		spellPut("150-70", "fei,ku");
		spellPut("150-71", "uu");
		spellPut("150-72", "nv,ga");
		spellPut("150-73", "tiao");
		spellPut("150-74", "lang");
		spellPut("150-75", "juan,zui");
		spellPut("150-76", "ming");
		spellPut("150-77", "huang,mang,wang");
		spellPut("150-78", "tun");
		spellPut("150-79", "ji");
		spellPut("150-80", "ying");
		spellPut("150-81", "zong");
		spellPut("150-82", "wang");
		spellPut("150-83", "tong,chuang");
		spellPut("150-84", "lang");
		spellPut("150-85", "lBo");
		spellPut("150-86", "long");
		spellPut("150-87", "pin");
		spellPut("150-88", "shu,zhu");
		spellPut("150-89", "te wu le");
		spellPut("150-90", "ren");
		spellPut("150-91", "ba");
		spellPut("150-92", "duo");
		spellPut("150-93", "dao,tiao,mu");
		spellPut("150-94", "li");
		spellPut("150-95", "qiu,gui");
		spellPut("150-96", "jiu");
		spellPut("150-97", "bi");
		spellPut("150-98", "cheng");
		spellPut("150-99", "ci");
		spellPut("150-100", "ru");
		spellPut("150-101", "qian");
		spellPut("150-102", "yu,wu");
		spellPut("150-103", "wu");
		spellPut("150-104", "xun");
		spellPut("150-105", "fan");
		spellPut("150-106", "zi");
		spellPut("150-107", "ren,er");
		spellPut("150-108", "tuo,zhe");
		spellPut("150-109", "di,duo");
		spellPut("150-110", "mang");
		spellPut("150-111", "chi");
		spellPut("150-112", "yi");
		spellPut("150-113", "gu,gai");
		spellPut("150-114", "gong");
		spellPut("150-115", "yi,li,duo,tuo");
		spellPut("150-116", "jie");
		spellPut("150-117", "mian");
		spellPut("150-118", "wBn");
		spellPut("150-119", "jiu");
		spellPut("150-120", "mang");
		spellPut("150-121", "si,zhi,xi");
		spellPut("150-122", "yuan,wan");
		spellPut("150-123", "fei,bei");
		spellPut("150-124", "dong");
		spellPut("150-125", "xian");
		spellPut("150-126", "chun");
		spellPut("150-128", "shu,dui");
		spellPut("150-129", "hua");
		spellPut("150-130", "xin");
		spellPut("150-131", "niu,chou");
		spellPut("150-132", "chou");
		spellPut("150-133", "song");
		spellPut("150-134", "wo,yue");
		spellPut("150-135", "jin");
		spellPut("150-136", "ji");
		spellPut("150-137", "mao");
		spellPut("150-138", "pi,mi");
		spellPut("150-139", "ang");
		spellPut("150-140", "fen");
		spellPut("150-141", "yi");
		spellPut("150-142", "fu");
		spellPut("150-143", "nan");
		spellPut("150-144", "hu,di");
		spellPut("150-145", "ya");
		spellPut("150-146", "dou");
		spellPut("150-147", "xin");
		spellPut("150-148", "yao");
		spellPut("150-149", "e");
		spellPut("150-150", "zhao");
		spellPut("150-151", "yun");
		spellPut("150-152", "hua");
		spellPut("150-153", "sheng");
		spellPut("150-154", "di,duo");
		spellPut("150-155", "lu");
		spellPut("150-156", "song,mB ti su");
		spellPut("150-157", "zhan");
		spellPut("150-158", "xian,zhen");
		spellPut("150-159", "si,tai");
		spellPut("150-160", "xi");
		spellPut("150-161", "guai");
		spellPut("150-162", "bao,fu");
		spellPut("150-163", "mo");
		spellPut("150-164", "yi,xie");
		spellPut("150-165", "ye");
		spellPut("150-166", "ye");
		spellPut("150-167", "shi");
		spellPut("150-168", "nie");
		spellPut("150-169", "bi");
		spellPut("150-170", "yi,duo,li");
		spellPut("150-171", "ni,chi");
		spellPut("150-172", "la");
		spellPut("150-173", "he");
		spellPut("150-174", "pan,ban");
		spellPut("150-175", "fan");
		spellPut("150-176", "zhong");
		spellPut("150-177", "dai");
		spellPut("150-178", "ci");
		spellPut("150-179", "yang,ying");
		spellPut("150-180", "fu");
		spellPut("150-181", "mao");
		spellPut("150-182", "shao");
		spellPut("150-183", "song");
		spellPut("150-184", "shen");
		spellPut("150-185", "nan");
		spellPut("150-186", "yong");
		spellPut("150-187", "zhi,die");
		spellPut("150-188", "zha,zu");
		spellPut("150-189", "dan");
		spellPut("150-190", "gu");
		spellPut("150-191", "bu,pu");
		spellPut("150-192", "ao");
		spellPut("150-193", "fu");
		spellPut("150-194", "ba,fu,pei,bo,bie");
		spellPut("150-195", "duo,zuo,wu");
		spellPut("150-196", "bi,bie");
		spellPut("150-197", "shan");
		spellPut("150-198", "si");
		spellPut("150-199", "zhu");
		spellPut("150-200", "bei,pei");
		spellPut("150-201", "shi,fei");
		spellPut("150-202", "guai");
		spellPut("150-203", "cha,zha");
		spellPut("150-204", "yao");
		spellPut("150-205", "jiu");
		spellPut("150-206", "liu");
		spellPut("150-207", "mei");
		spellPut("150-208", "li");
		spellPut("150-209", "rong");
		spellPut("150-210", "zBo");
		spellPut("150-211", "sB ying");
		spellPut("150-212", "yong");
		spellPut("150-213", "xun");
		spellPut("150-214", "qi,qie");
		spellPut("150-215", "chen");
		spellPut("150-216", "yi");
		spellPut("150-217", "xiang");
		spellPut("150-218", "zhen");
		spellPut("150-219", "li");
		spellPut("150-220", "se");
		spellPut("150-221", "kan");
		spellPut("150-222", "ben,bing");
		spellPut("150-223", "ren");
		spellPut("150-224", "bai");
		spellPut("150-225", "ren");
		spellPut("150-226", "bing");
		spellPut("150-227", "zi");
		spellPut("150-228", "chou");
		spellPut("150-229", "yi,xie");
		spellPut("150-230", "ci");
		spellPut("150-231", "jian,zun");
		spellPut("150-232", "zui");
		spellPut("150-233", "er");
		spellPut("150-234", "er");
		spellPut("150-235", "you,yu");
		spellPut("150-236", "fa");
		spellPut("150-237", "gong");
		spellPut("150-238", "zhan");
		spellPut("150-239", "lie");
		spellPut("150-240", "yin");
		spellPut("150-241", "zhi,yi");
		spellPut("150-242", "shi");
		spellPut("150-243", "fu");
		spellPut("150-244", "ru");
		spellPut("150-245", "yi,ti");
		spellPut("150-246", "ku");
		spellPut("150-247", "qiong");
		spellPut("150-248", "sang");
		spellPut("150-249", "xue");
		spellPut("150-250", "duo");
		spellPut("150-251", "chui");
		spellPut("150-252", "yu,mou");
		spellPut("150-253", "za,zan");
		spellPut("150-254", "kB sei");
	}

	private static void init22() {
		spellPut("151-64", "ying");
		spellPut("151-65", "jie");
		spellPut("151-66", "liu");
		spellPut("151-67", "zhan");
		spellPut("151-68", "xun");
		spellPut("151-69", "sha");
		spellPut("151-70", "chen,zhen");
		spellPut("151-71", "bei");
		spellPut("151-72", "ting,ying");
		spellPut("151-73", "gua");
		spellPut("151-74", "jing");
		spellPut("151-75", "bo");
		spellPut("151-76", "ben,fan");
		spellPut("151-77", "rui");
		spellPut("151-78", "xi");
		spellPut("151-79", "lang");
		spellPut("151-80", "liu");
		spellPut("151-81", "feng");
		spellPut("151-82", "qi");
		spellPut("151-83", "wen");
		spellPut("151-84", "jun");
		spellPut("151-85", "gan");
		spellPut("151-86", "su,yin");
		spellPut("151-87", "qiu");
		spellPut("151-88", "you");
		spellPut("151-89", "long");
		spellPut("151-90", "peng");
		spellPut("151-91", "zhuang");
		spellPut("151-92", "di");
		spellPut("151-93", "xuan,juan,xie");
		spellPut("151-94", "tu,cha");
		spellPut("151-95", "zao");
		spellPut("151-96", "ao,you");
		spellPut("151-97", "bi");
		spellPut("151-98", "di");
		spellPut("151-99", "han");
		spellPut("151-100", "zhi");
		spellPut("151-101", "ren,er");
		spellPut("151-102", "bei");
		spellPut("151-103", "jian");
		spellPut("151-104", "huan");
		spellPut("151-105", "wan");
		spellPut("151-106", "nuo");
		spellPut("151-107", "jia");
		spellPut("151-108", "tiao");
		spellPut("151-109", "ji");
		spellPut("151-110", "xiao");
		spellPut("151-111", "lv");
		spellPut("151-112", "kuan");
		spellPut("151-113", "chen");
		spellPut("151-114", "fen");
		spellPut("151-115", "song");
		spellPut("151-116", "si,qi");
		spellPut("151-117", "dou");
		spellPut("151-118", "qin");
		spellPut("151-119", "ying");
		spellPut("151-120", "ju");
		spellPut("151-121", "kun");
		spellPut("151-122", "zhuo");
		spellPut("151-123", "chan,yan");
		spellPut("151-124", "wei");
		spellPut("151-125", "jing");
		spellPut("151-126", "li");
		spellPut("151-128", "bin,bing");
		spellPut("151-129", "xiB");
		spellPut("151-130", "xi ki mi");
		spellPut("151-131", "chou,tao,dao");
		spellPut("151-132", "zhi");
		spellPut("151-133", "lai");
		spellPut("151-134", "lian");
		spellPut("151-135", "zhuo");
		spellPut("151-136", "li");
		spellPut("151-137", "qi");
		spellPut("151-138", "bing");
		spellPut("151-139", "lun");
		spellPut("151-140", "cong,song");
		spellPut("151-141", "qian");
		spellPut("151-142", "qi");
		spellPut("151-143", "cai");
		spellPut("151-144", "chan");
		spellPut("151-145", "de,zhe");
		spellPut("151-146", "fei");
		spellPut("151-147", "pai,bei,pei");
		spellPut("151-148", "bang,pou,bei");
		spellPut("151-149", "hun");
		spellPut("151-150", "cheng");
		spellPut("151-151", "zao");
		spellPut("151-152", "li,lie");
		spellPut("151-153", "yu");
		spellPut("151-154", "yu");
		spellPut("151-155", "gu");
		spellPut("151-156", "jun");
		spellPut("151-157", "dong");
		spellPut("151-158", "gang");
		spellPut("151-159", "wang");
		spellPut("151-160", "que");
		spellPut("151-161", "fan");
		spellPut("151-162", "cheng");
		spellPut("151-163", "zhan");
		spellPut("151-164", "qi");
		spellPut("151-165", "yuan");
		spellPut("151-166", "yan");
		spellPut("151-167", "yu");
		spellPut("151-168", "quan,juan");
		spellPut("151-169", "yi");
		spellPut("151-170", "ren,shen");
		spellPut("151-171", "qi");
		spellPut("151-172", "zhuo");
		spellPut("151-173", "fu,su");
		spellPut("151-174", "lai");
		spellPut("151-175", "zou,sou");
		spellPut("151-176", "zou");
		spellPut("151-177", "fen");
		spellPut("151-178", "chen");
		spellPut("151-179", "qing");
		spellPut("151-180", "ni");
		spellPut("151-181", "wan");
		spellPut("151-182", "lu");
		spellPut("151-183", "hao");
		spellPut("151-184", "jie,qie");
		spellPut("151-185", "chou,zhou,diao");
		spellPut("151-186", "ju");
		spellPut("151-187", "ju");
		spellPut("151-188", "cheng,sheng");
		spellPut("151-189", "zu,cui");
		spellPut("151-190", "qiang,kong");
		spellPut("151-191", "ya");
		spellPut("151-192", "bei");
		spellPut("151-193", "zhuo");
		spellPut("151-194", "zi");
		spellPut("151-195", "bin");
		spellPut("151-196", "peng");
		spellPut("151-197", "ding");
		spellPut("151-198", "chu");
		spellPut("151-199", "chBng");
		spellPut("151-200", "men");
		spellPut("151-201", "huB");
		spellPut("151-202", "jian");
		spellPut("151-203", "gui");
		spellPut("151-204", "xi");
		spellPut("151-205", "dBo");
		spellPut("151-206", "gui");
		spellPut("151-207", "diBn");
		spellPut("151-208", "zhi");
		spellPut("151-209", "quan,juan");
		spellPut("151-210", "mi eng");
		spellPut("151-211", "fu");
		spellPut("151-212", "geng");
		spellPut("151-213", "peng");
		spellPut("151-214", "shan");
		spellPut("151-215", "yi");
		spellPut("151-216", "sen");
		spellPut("151-217", "duo,chuan");
		spellPut("151-218", "fu");
		spellPut("151-219", "wei,hui");
		spellPut("151-220", "wei");
		spellPut("151-221", "jia");
		spellPut("151-222", "zong");
		spellPut("151-223", "jian,han");
		spellPut("151-224", "yi");
		spellPut("151-225", "xi");
		spellPut("151-226", "yan,ya");
		spellPut("151-227", "yan");
		spellPut("151-228", "jian");
		spellPut("151-229", "yu");
		spellPut("151-230", "he");
		spellPut("151-231", "wo");
		spellPut("151-232", "pian");
		spellPut("151-233", "bi");
		spellPut("151-234", "yao");
		spellPut("151-235", "guo,kua");
		spellPut("151-236", "xu");
		spellPut("151-237", "ruo");
		spellPut("151-238", "yang");
		spellPut("151-239", "la");
		spellPut("151-240", "yan");
		spellPut("151-241", "ben");
		spellPut("151-242", "hui");
		spellPut("151-243", "kui");
		spellPut("151-244", "jie");
		spellPut("151-245", "kui");
		spellPut("151-246", "si");
		spellPut("151-247", "feng");
		spellPut("151-248", "tuo");
		spellPut("151-249", "ji,zhi");
		spellPut("151-250", "mu");
		spellPut("151-251", "mao");
		spellPut("151-252", "ku,hu");
		spellPut("151-253", "hu");
		spellPut("151-254", "ting");
	}

	private static void init23() {
		spellPut("152-64", "yu");
		spellPut("152-65", "you");
		spellPut("152-66", "song,cong");
		spellPut("152-67", "xuan,yuan");
		spellPut("152-68", "yang,ying");
		spellPut("152-69", "zhen");
		spellPut("152-70", "pian");
		spellPut("152-71", "die,ye");
		spellPut("152-72", "jie");
		spellPut("152-73", "ye");
		spellPut("152-74", "shun,dun");
		spellPut("152-75", "yu");
		spellPut("152-76", "wei");
		spellPut("152-77", "mei");
		spellPut("152-78", "di,shi");
		spellPut("152-79", "ji");
		spellPut("152-80", "jie");
		spellPut("152-81", "rou");
		spellPut("152-82", "huang");
		spellPut("152-83", "le,yue");
		spellPut("152-84", "hB ni zB wu");
		spellPut("152-85", "kB tui lB");
		spellPut("152-86", "mu le");
		spellPut("152-87", "tan");
		spellPut("152-88", "wen,yun");
		spellPut("152-89", "shen");
		spellPut("152-90", "chu");
		spellPut("152-91", "bi,pi");
		spellPut("152-92", "jia");
		spellPut("152-93", "yi");
		spellPut("152-94", "zhan,nian,zhen");
		spellPut("152-95", "fu,bo");
		spellPut("152-96", "nuo");
		spellPut("152-97", "mi");
		spellPut("152-98", "gu");
		spellPut("152-99", "jian,jin");
		spellPut("152-100", "ta");
		spellPut("152-101", "yao");
		spellPut("152-102", "sha,xie");
		spellPut("152-103", "yuan");
		spellPut("152-104", "zi");
		spellPut("152-105", "ming");
		spellPut("152-106", "su");
		spellPut("152-107", "jia");
		spellPut("152-108", "yao");
		spellPut("152-109", "jie");
		spellPut("152-110", "huang");
		spellPut("152-111", "gan");
		spellPut("152-112", "qian");
		spellPut("152-113", "ma");
		spellPut("152-114", "yuan");
		spellPut("152-115", "rong");
		spellPut("152-116", "shi");
		spellPut("152-117", "zhi");
		spellPut("152-118", "wen");
		spellPut("152-119", "ting");
		spellPut("152-120", "rong");
		spellPut("152-121", "tang");
		spellPut("152-122", "zhai");
		spellPut("152-123", "si");
		spellPut("152-124", "sheng");
		spellPut("152-125", "ke");
		spellPut("152-126", "xi");
		spellPut("152-128", "gu");
		spellPut("152-129", "qi");
		spellPut("152-130", "gao");
		spellPut("152-131", "sun");
		spellPut("152-132", "pan");
		spellPut("152-133", "tao");
		spellPut("152-134", "ge");
		spellPut("152-135", "chun");
		spellPut("152-136", "dian");
		spellPut("152-137", "nou");
		spellPut("152-138", "ji");
		spellPut("152-139", "gou");
		spellPut("152-140", "qiang");
		spellPut("152-141", "qian,lian,xian");
		spellPut("152-142", "mei");
		spellPut("152-143", "xu");
		spellPut("152-144", "gang");
		spellPut("152-145", "zhuo");
		spellPut("152-146", "tuo");
		spellPut("152-147", "qiao");
		spellPut("152-148", "yang");
		spellPut("152-149", "dian,zhen");
		spellPut("152-150", "jia");
		spellPut("152-151", "zui");
		spellPut("152-152", "dBo");
		spellPut("152-153", "long");
		spellPut("152-154", "sang");
		spellPut("152-155", "xi,die");
		spellPut("152-156", "ji,gui");
		spellPut("152-157", "lian");
		spellPut("152-158", "hui");
		spellPut("152-159", "rong,yong");
		spellPut("152-160", "qian");
		spellPut("152-161", "guo");
		spellPut("152-162", "gai");
		spellPut("152-163", "gai");
		spellPut("152-164", "tuan,shuan,quan");
		spellPut("152-165", "hua");
		spellPut("152-166", "sen");
		spellPut("152-167", "cui,zhi");
		spellPut("152-168", "peng");
		spellPut("152-169", "you,chao");
		spellPut("152-170", "jiang");
		spellPut("152-171", "hu");
		spellPut("152-172", "huan");
		spellPut("152-173", "gui");
		spellPut("152-174", "nie");
		spellPut("152-175", "yi");
		spellPut("152-176", "gao");
		spellPut("152-177", "kang");
		spellPut("152-178", "gui");
		spellPut("152-179", "gui");
		spellPut("152-180", "man,wan");
		spellPut("152-181", "di");
		spellPut("152-182", "zhuang");
		spellPut("152-183", "le,yue");
		spellPut("152-184", "lang");
		spellPut("152-185", "chen");
		spellPut("152-186", "cong,zong");
		spellPut("152-187", "li,chi");
		spellPut("152-188", "xiu");
		spellPut("152-189", "qing");
		spellPut("152-190", "shang");
		spellPut("152-191", "tong");
		spellPut("152-192", "guan");
		spellPut("152-193", "ze");
		spellPut("152-194", "su");
		spellPut("152-195", "lei");
		spellPut("152-196", "lu");
		spellPut("152-197", "liang");
		spellPut("152-198", "mi");
		spellPut("152-199", "lou");
		spellPut("152-200", "chao,jiao");
		spellPut("152-201", "su");
		spellPut("152-202", "ke");
		spellPut("152-203", "biao");
		spellPut("152-204", "lu");
		spellPut("152-205", "jiu,liao");
		spellPut("152-206", "zhe");
		spellPut("152-207", "zha");
		spellPut("152-208", "shu");
		spellPut("152-209", "man");
		spellPut("152-210", "niao,mu");
		spellPut("152-211", "yang");
		spellPut("152-212", "tiao");
		spellPut("152-213", "peng");
		spellPut("152-214", "zhu");
		spellPut("152-215", "sha,xie");
		spellPut("152-216", "quan");
		spellPut("152-217", "jian");
		spellPut("152-218", "cong");
		spellPut("152-219", "ji");
		spellPut("152-220", "yBn");
		spellPut("152-221", "xue");
		spellPut("152-222", "er");
		spellPut("152-223", "xun");
		spellPut("152-224", "zhi");
		spellPut("152-225", "zui");
		spellPut("152-226", "cong");
		spellPut("152-227", "pu");
		spellPut("152-228", "shu");
		spellPut("152-229", "hua");
		spellPut("152-230", "gui");
		spellPut("152-231", "zhen");
		spellPut("152-232", "shan");
		spellPut("152-233", "xi");
		spellPut("152-234", "chun");
		spellPut("152-235", "dian");
		spellPut("152-236", "fa,fei");
		spellPut("152-237", "mo");
		spellPut("152-238", "wu");
		spellPut("152-239", "rao,nao");
		spellPut("152-240", "lin");
		spellPut("152-241", "liu");
		spellPut("152-242", "qiao");
		spellPut("152-243", "xian");
		spellPut("152-244", "run");
		spellPut("152-245", "fan");
		spellPut("152-246", "zhan,jian");
		spellPut("152-247", "liao");
		spellPut("152-248", "yun");
		spellPut("152-249", "shun");
		spellPut("152-250", "tui,dun");
		spellPut("152-251", "cheng");
		spellPut("152-252", "tang,cheng");
		spellPut("152-253", "meng");
		spellPut("152-254", "su,qiu");
	}

	private static void init24() {
		spellPut("153-64", "jue");
		spellPut("153-65", "tan,dian");
		spellPut("153-66", "hui");
		spellPut("153-67", "ji");
		spellPut("153-68", "nuo");
		spellPut("153-69", "tuo");
		spellPut("153-70", "ning");
		spellPut("153-71", "rui");
		spellPut("153-72", "tong,chuang");
		spellPut("153-73", "zeng,ceng");
		spellPut("153-74", "fen,fei");
		spellPut("153-75", "qiong");
		spellPut("153-76", "ran,yan");
		spellPut("153-77", "heng");
		spellPut("153-78", "qian");
		spellPut("153-79", "gu");
		spellPut("153-80", "liu");
		spellPut("153-81", "lao");
		spellPut("153-82", "gao");
		spellPut("153-83", "xi");
		spellPut("153-84", "sheng");
		spellPut("153-85", "zB");
		spellPut("153-86", "zan");
		spellPut("153-87", "ji");
		spellPut("153-88", "dou");
		spellPut("153-89", "jing");
		spellPut("153-90", "xian");
		spellPut("153-91", "cu,chu");
		spellPut("153-92", "ta");
		spellPut("153-93", "shu,qiao");
		spellPut("153-94", "jiang");
		spellPut("153-95", "lin");
		spellPut("153-96", "nong");
		spellPut("153-97", "yin");
		spellPut("153-98", "hui");
		spellPut("153-99", "shan");
		spellPut("153-100", "zui");
		spellPut("153-101", "xuan");
		spellPut("153-102", "cheng");
		spellPut("153-103", "gan");
		spellPut("153-104", "ju");
		spellPut("153-105", "zui");
		spellPut("153-106", "yi");
		spellPut("153-107", "pu");
		spellPut("153-108", "feng");
		spellPut("153-109", "hui");
		spellPut("153-110", "dang");
		spellPut("153-111", "ji");
		spellPut("153-112", "sui");
		spellPut("153-113", "ping,bo");
		spellPut("153-114", "cheng");
		spellPut("153-115", "chu");
		spellPut("153-116", "zhua");
		spellPut("153-117", "gui,hui");
		spellPut("153-118", "ji");
		spellPut("153-119", "jie");
		spellPut("153-120", "jia");
		spellPut("153-121", "zhai,shi,tu");
		spellPut("153-122", "jian");
		spellPut("153-123", "qiang");
		spellPut("153-124", "dao");
		spellPut("153-125", "yi");
		spellPut("153-126", "biao");
		spellPut("153-128", "song");
		spellPut("153-129", "she");
		spellPut("153-130", "li");
		spellPut("153-131", "yin");
		spellPut("153-132", "chou,tao,dao");
		spellPut("153-133", "tai");
		spellPut("153-134", "mian");
		spellPut("153-135", "qi");
		spellPut("153-136", "tuan");
		spellPut("153-137", "bin,bing");
		spellPut("153-138", "huo");
		spellPut("153-139", "ji");
		spellPut("153-140", "qian,lian");
		spellPut("153-141", "ni,mi");
		spellPut("153-142", "ning");
		spellPut("153-143", "yi");
		spellPut("153-144", "gao");
		spellPut("153-145", "jian,kan");
		spellPut("153-146", "yin");
		spellPut("153-147", "nou,ruan,ru");
		spellPut("153-148", "qing");
		spellPut("153-149", "yan");
		spellPut("153-150", "qi");
		spellPut("153-151", "mi");
		spellPut("153-152", "zhao");
		spellPut("153-153", "gui");
		spellPut("153-154", "chun");
		spellPut("153-155", "ji");
		spellPut("153-156", "kui");
		spellPut("153-157", "po");
		spellPut("153-158", "deng");
		spellPut("153-159", "chu");
		spellPut("153-160", "ge");
		spellPut("153-161", "mian");
		spellPut("153-162", "you");
		spellPut("153-163", "zhi");
		spellPut("153-164", "huang,guo,gu");
		spellPut("153-165", "qian");
		spellPut("153-166", "lei");
		spellPut("153-167", "lei");
		spellPut("153-168", "sa");
		spellPut("153-169", "lu");
		spellPut("153-170", "li");
		spellPut("153-171", "cuan");
		spellPut("153-172", "lv,chu");
		spellPut("153-173", "mie,mei");
		spellPut("153-174", "hui");
		spellPut("153-175", "ou");
		spellPut("153-176", "lv");
		spellPut("153-177", "zhi");
		spellPut("153-178", "gao");
		spellPut("153-179", "du");
		spellPut("153-180", "yuan");
		spellPut("153-181", "li,yue");
		spellPut("153-182", "fei");
		spellPut("153-183", "zhuo,zhu");
		spellPut("153-184", "sou");
		spellPut("153-185", "lian");
		spellPut("153-186", "jiBng");
		spellPut("153-187", "chu");
		spellPut("153-188", "qing");
		spellPut("153-189", "zhu");
		spellPut("153-190", "lu");
		spellPut("153-191", "yan");
		spellPut("153-192", "li");
		spellPut("153-193", "zhu");
		spellPut("153-194", "chen");
		spellPut("153-195", "jue,ji");
		spellPut("153-196", "e");
		spellPut("153-197", "su");
		spellPut("153-198", "huai,gui");
		spellPut("153-199", "nie");
		spellPut("153-200", "yu");
		spellPut("153-201", "long");
		spellPut("153-202", "la,lai");
		spellPut("153-203", "qiao");
		spellPut("153-204", "xian");
		spellPut("153-205", "gui");
		spellPut("153-206", "ju");
		spellPut("153-207", "xiao");
		spellPut("153-208", "ling");
		spellPut("153-209", "ying");
		spellPut("153-210", "jian");
		spellPut("153-211", "yin");
		spellPut("153-212", "you");
		spellPut("153-213", "ying");
		spellPut("153-214", "xiang");
		spellPut("153-215", "nong");
		spellPut("153-216", "bo");
		spellPut("153-217", "chan,zhan");
		spellPut("153-218", "lan");
		spellPut("153-219", "ju");
		spellPut("153-220", "shuang");
		spellPut("153-221", "she");
		spellPut("153-222", "wei,zui");
		spellPut("153-223", "cong");
		spellPut("153-224", "quan");
		spellPut("153-225", "qu");
		spellPut("153-226", "zBng");
		spellPut("153-227", "jiu");
		spellPut("153-228", "yu");
		spellPut("153-229", "luo");
		spellPut("153-230", "li");
		spellPut("153-231", "cuan");
		spellPut("153-232", "luan");
		spellPut("153-233", "dang");
		spellPut("153-234", "qu");
		spellPut("153-235", "e mi");
		spellPut("153-236", "lan");
		spellPut("153-237", "lan");
		spellPut("153-238", "zhu");
		spellPut("153-239", "lei");
		spellPut("153-240", "li");
		spellPut("153-241", "ba");
		spellPut("153-242", "nang");
		spellPut("153-243", "yu");
		spellPut("153-244", "ling");
		spellPut("153-245", "guan");
		spellPut("153-246", "yu,yi");
		spellPut("153-247", "qian,xian");
		spellPut("153-248", "xu");
		spellPut("153-249", "chao");
		spellPut("153-250", "chu,qu,xi");
		spellPut("153-251", "qi");
		spellPut("153-252", "ke,ai");
		spellPut("153-253", "yi,yin");
		spellPut("153-254", "jue");
	}

	private static void init25() {
		spellPut("154-64", "xi,kai");
		spellPut("154-65", "xu");
		spellPut("154-66", "he");
		spellPut("154-67", "kuai");
		spellPut("154-68", "lang");
		spellPut("154-69", "kuan");
		spellPut("154-70", "shuo,sou");
		spellPut("154-71", "ei,ai");
		spellPut("154-72", "xu,chua");
		spellPut("154-73", "chi,chuai");
		spellPut("154-74", "qin");
		spellPut("154-75", "kan,qian");
		spellPut("154-76", "kuan");
		spellPut("154-77", "kan,ke");
		spellPut("154-78", "chuan");
		spellPut("154-79", "gua");
		spellPut("154-80", "yan,yin");
		spellPut("154-81", "yu");
		spellPut("154-82", "xiao");
		spellPut("154-83", "ye");
		spellPut("154-84", "wu");
		spellPut("154-85", "tan");
		spellPut("154-86", "jin,qun");
		spellPut("154-87", "ou");
		spellPut("154-88", "hu");
		spellPut("154-89", "ti");
		spellPut("154-90", "huan");
		spellPut("154-91", "xu");
		spellPut("154-92", "pen");
		spellPut("154-93", "xi");
		spellPut("154-94", "xiao");
		spellPut("154-95", "xu");
		spellPut("154-96", "shan");
		spellPut("154-97", "lian,han");
		spellPut("154-98", "chu");
		spellPut("154-99", "yi");
		spellPut("154-100", "e");
		spellPut("154-101", "yu");
		spellPut("154-102", "chuo");
		spellPut("154-103", "huan");
		spellPut("154-104", "bu");
		spellPut("154-105", "bu");
		spellPut("154-106", "ju");
		spellPut("154-107", "qian");
		spellPut("154-108", "zhi,chi");
		spellPut("154-109", "se");
		spellPut("154-110", "chi");
		spellPut("154-111", "se,sha");
		spellPut("154-112", "zhong");
		spellPut("154-113", "sui");
		spellPut("154-114", "sui");
		spellPut("154-115", "li");
		spellPut("154-116", "ze");
		spellPut("154-117", "yu");
		spellPut("154-118", "li");
		spellPut("154-119", "gui");
		spellPut("154-120", "dai");
		spellPut("154-121", "zhe");
		spellPut("154-122", "mo,wen");
		spellPut("154-123", "mo");
		spellPut("154-124", "yao");
		spellPut("154-125", "sheng");
		spellPut("154-126", "xu");
		spellPut("154-128", "jing");
		spellPut("154-129", "qia");
		spellPut("154-130", "qiu");
		spellPut("154-131", "su");
		spellPut("154-132", "qing,jing");
		spellPut("154-133", "yi");
		spellPut("154-134", "fou,bo");
		spellPut("154-135", "ye,yan");
		spellPut("154-136", "can");
		spellPut("154-137", "hun,mei");
		spellPut("154-138", "die");
		spellPut("154-139", "zhen");
		spellPut("154-140", "yun");
		spellPut("154-141", "wen");
		spellPut("154-142", "chou");
		spellPut("154-143", "ti");
		spellPut("154-144", "jin");
		spellPut("154-145", "shang");
		spellPut("154-146", "yin");
		spellPut("154-147", "chi");
		spellPut("154-148", "jiu");
		spellPut("154-149", "kui,hui");
		spellPut("154-150", "cuan");
		spellPut("154-151", "dan");
		spellPut("154-152", "du");
		spellPut("154-153", "jiang");
		spellPut("154-154", "lian");
		spellPut("154-155", "bin");
		spellPut("154-156", "du");
		spellPut("154-157", "jian");
		spellPut("154-158", "jian");
		spellPut("154-159", "zhu");
		spellPut("154-160", "qing,keng,sheng");
		spellPut("154-161", "yi");
		spellPut("154-162", "sha");
		spellPut("154-163", "ke,qiao");
		spellPut("154-164", "ke,qiao");
		spellPut("154-165", "xiao,yao");
		spellPut("154-166", "xun");
		spellPut("154-167", "hui");
		spellPut("154-168", "qiao");
		spellPut("154-169", "ji");
		spellPut("154-170", "ou");
		spellPut("154-171", "hui");
		spellPut("154-172", "duan");
		spellPut("154-173", "yi");
		spellPut("154-174", "xiao");
		spellPut("154-175", "guan,wan");
		spellPut("154-176", "mei");
		spellPut("154-177", "ai");
		spellPut("154-178", "jie");
		spellPut("154-179", "pi");
		spellPut("154-180", "chan");
		spellPut("154-181", "uu");
		spellPut("154-182", "uu");
		spellPut("154-183", "bi");
		spellPut("154-184", "mBo");
		spellPut("154-185", "jia");
		spellPut("154-186", "sai");
		spellPut("154-187", "mu");
		spellPut("154-188", "tuo");
		spellPut("154-189", "xun");
		spellPut("154-190", "er");
		spellPut("154-191", "rong");
		spellPut("154-192", "xian");
		spellPut("154-193", "ju");
		spellPut("154-194", "qiu");
		spellPut("154-195", "dou,nuo");
		spellPut("154-196", "uu");
		spellPut("154-197", "pei");
		spellPut("154-198", "ju");
		spellPut("154-199", "duo");
		spellPut("154-200", "bi");
		spellPut("154-201", "san");
		spellPut("154-202", "mao");
		spellPut("154-203", "sai,sui");
		spellPut("154-204", "shu");
		spellPut("154-205", "tuo");
		spellPut("154-206", "he");
		spellPut("154-207", "ta");
		spellPut("154-208", "san");
		spellPut("154-209", "lv");
		spellPut("154-210", "mu");
		spellPut("154-211", "mao");
		spellPut("154-212", "tong");
		spellPut("154-213", "rong");
		spellPut("154-214", "zhan");
		spellPut("154-215", "sao");
		spellPut("154-216", "zhan");
		spellPut("154-217", "meng");
		spellPut("154-218", "lu");
		spellPut("154-219", "die");
		spellPut("154-220", "jue");
		spellPut("154-221", "qi");
		spellPut("154-222", "yang,ri");
		spellPut("154-223", "nei");
		spellPut("154-224", "nei");
		spellPut("154-225", "shen");
		spellPut("154-226", "qi");
		spellPut("154-227", "xi");
		spellPut("154-228", "qing");
		spellPut("154-229", "ya");
		spellPut("154-230", "dong");
		spellPut("154-231", "yang");
		spellPut("154-232", "yun");
		spellPut("154-233", "zheng,cheng");
		spellPut("154-234", "bing");
		spellPut("154-235", "dang");
		spellPut("154-236", "shui");
		spellPut("154-237", "le");
		spellPut("154-238", "ni");
		spellPut("154-239", "fan");
		spellPut("154-240", "gui,jiu");
		spellPut("154-241", "bin,pa");
		spellPut("154-242", "ze");
		spellPut("154-243", "mian");
		spellPut("154-244", "diao");
		spellPut("154-245", "zhuo,que");
		spellPut("154-246", "chuan");
		spellPut("154-247", "wan");
		spellPut("154-248", "fan");
		spellPut("154-249", "tai");
		spellPut("154-250", "tuo");
		spellPut("154-251", "mang");
		spellPut("154-252", "qiu");
		spellPut("154-253", "pin");
		spellPut("154-254", "qian");
	}

	private static void init26() {
		spellPut("155-64", "wu");
		spellPut("155-65", "wu");
		spellPut("155-66", "tu");
		spellPut("155-67", "jiu");
		spellPut("155-68", "zhi,ji");
		spellPut("155-69", "zhi");
		spellPut("155-70", "qian");
		spellPut("155-71", "jing");
		spellPut("155-72", "jing");
		spellPut("155-73", "rui");
		spellPut("155-74", "jun");
		spellPut("155-75", "hong");
		spellPut("155-76", "tai");
		spellPut("155-77", "bian");
		spellPut("155-78", "gan,han,cen");
		spellPut("155-79", "zhong");
		spellPut("155-80", "fang,pang");
		spellPut("155-81", "jue");
		spellPut("155-82", "hu,huang");
		spellPut("155-83", "niu,you");
		spellPut("155-84", "xu");
		spellPut("155-85", "xu");
		spellPut("155-86", "yun");
		spellPut("155-87", "yan");
		spellPut("155-88", "dan");
		spellPut("155-89", "you");
		spellPut("155-90", "hu");
		spellPut("155-91", "huo");
		spellPut("155-92", "nv,niu");
		spellPut("155-93", "mei,mo");
		spellPut("155-94", "mi,wu");
		spellPut("155-95", "chong");
		spellPut("155-96", "hong,pang");
		spellPut("155-97", "bi");
		spellPut("155-98", "zhi");
		spellPut("155-99", "pan");
		spellPut("155-100", "zhui,zi");
		spellPut("155-101", "za");
		spellPut("155-102", "pai");
		spellPut("155-103", "ze");
		spellPut("155-104", "feng");
		spellPut("155-105", "mei");
		spellPut("155-106", "za");
		spellPut("155-107", "tuo,duo");
		spellPut("155-108", "li");
		spellPut("155-109", "mi,li");
		spellPut("155-110", "yi,chi");
		spellPut("155-111", "fa");
		spellPut("155-112", "tian");
		spellPut("155-113", "si");
		spellPut("155-114", "kuang");
		spellPut("155-115", "jiong");
		spellPut("155-116", "ju");
		spellPut("155-117", "yi,die");
		spellPut("155-118", "jia");
		spellPut("155-119", "zhong");
		spellPut("155-120", "hui");
		spellPut("155-121", "ben");
		spellPut("155-122", "ze");
		spellPut("155-123", "chu,she");
		spellPut("155-124", "you,ao");
		spellPut("155-125", "gu");
		spellPut("155-126", "hu");
		spellPut("155-128", "peng,ping");
		spellPut("155-129", "ci");
		spellPut("155-130", "zhi");
		spellPut("155-131", "su");
		spellPut("155-132", "cheng");
		spellPut("155-133", "si");
		spellPut("155-134", "ju");
		spellPut("155-135", "yue,sa");
		spellPut("155-136", "sheng");
		spellPut("155-137", "jue,xue");
		spellPut("155-138", "fu");
		spellPut("155-139", "ji");
		spellPut("155-140", "guan");
		spellPut("155-141", "dan");
		spellPut("155-142", "yin");
		spellPut("155-143", "pan");
		spellPut("155-144", "yie");
		spellPut("155-145", "hui");
		spellPut("155-146", "zai");
		spellPut("155-147", "cheng");
		spellPut("155-148", "wei");
		spellPut("155-149", "hou");
		spellPut("155-150", "jian");
		spellPut("155-151", "si");
		spellPut("155-152", "er");
		spellPut("155-153", "xing");
		spellPut("155-154", "fu");
		spellPut("155-155", "se,qi,zi");
		spellPut("155-156", "zhi");
		spellPut("155-157", "yin");
		spellPut("155-158", "wu");
		spellPut("155-159", "kao");
		spellPut("155-160", "luo");
		spellPut("155-161", "an,yan,e");
		spellPut("155-162", "yi");
		spellPut("155-163", "si");
		spellPut("155-164", "lei");
		spellPut("155-165", "yi");
		spellPut("155-166", "mi");
		spellPut("155-167", "quan");
		spellPut("155-168", "po");
		spellPut("155-169", "xiao");
		spellPut("155-170", "xie");
		spellPut("155-171", "su,shuo");
		spellPut("155-172", "kuang");
		spellPut("155-173", "qie,jie");
		spellPut("155-174", "ju");
		spellPut("155-175", "ping");
		spellPut("155-176", "xiong");
		spellPut("155-177", "zhi");
		spellPut("155-178", "guang");
		spellPut("155-179", "ming");
		spellPut("155-180", "wu");
		spellPut("155-181", "qu");
		spellPut("155-182", "yi");
		spellPut("155-183", "jing");
		spellPut("155-184", "shi");
		spellPut("155-185", "pe o le");
		spellPut("155-186", "chan");
		spellPut("155-187", "jin");
		spellPut("155-188", "lie");
		spellPut("155-189", "qiu");
		spellPut("155-190", "wei");
		spellPut("155-191", "han");
		spellPut("155-192", "mang");
		spellPut("155-193", "you,di");
		spellPut("155-194", "bo");
		spellPut("155-195", "dou");
		spellPut("155-196", "hong");
		spellPut("155-197", "yi");
		spellPut("155-198", "ying,cheng");
		spellPut("155-199", "lan");
		spellPut("155-200", "han");
		spellPut("155-201", "li");
		spellPut("155-202", "geng");
		spellPut("155-203", "li");
		spellPut("155-204", "chun");
		spellPut("155-205", "feng,hong");
		spellPut("155-206", "yi");
		spellPut("155-207", "tong");
		spellPut("155-208", "lao");
		spellPut("155-209", "jia");
		spellPut("155-210", "chong");
		spellPut("155-211", "jiong");
		spellPut("155-212", "sui,nei");
		spellPut("155-213", "cheng");
		spellPut("155-214", "pei");
		spellPut("155-215", "xian");
		spellPut("155-216", "shen");
		spellPut("155-217", "kun");
		spellPut("155-218", "ping");
		spellPut("155-219", "han");
		spellPut("155-220", "jing");
		spellPut("155-221", "nian");
		spellPut("155-222", "tu");
		spellPut("155-223", "xiao");
		spellPut("155-224", "ting");
		spellPut("155-225", "e");
		spellPut("155-226", "tun,yun");
		spellPut("155-227", "li");
		spellPut("155-228", "shui");
		spellPut("155-229", "si");
		spellPut("155-230", "lei");
		spellPut("155-231", "shui");
		spellPut("155-232", "to ko");
		spellPut("155-233", "yun");
		spellPut("155-234", "heng");
		spellPut("155-235", "xing");
		spellPut("155-236", "shou,tao");
		spellPut("155-237", "chuo");
		spellPut("155-238", "zhang");
		spellPut("155-239", "kong,nang");
		spellPut("155-240", "wan,wo,yuan");
		spellPut("155-241", "tuo");
		spellPut("155-242", "dong");
		spellPut("155-243", "wo");
		spellPut("155-244", "ju");
		spellPut("155-245", "she");
		spellPut("155-246", "liang");
		spellPut("155-247", "hun");
		spellPut("155-248", "ta");
		spellPut("155-249", "qie,ji");
		spellPut("155-250", "de");
		spellPut("155-251", "juan");
		spellPut("155-252", "gu");
		spellPut("155-253", "guo,guan");
		spellPut("155-254", "yan");
	}

	private static void init27() {
		spellPut("156-64", "zhou");
		spellPut("156-65", "peng");
		spellPut("156-66", "hao");
		spellPut("156-67", "chang");
		spellPut("156-68", "qi");
		spellPut("156-69", "fang");
		spellPut("156-70", "zhi");
		spellPut("156-71", "lu");
		spellPut("156-72", "ju");
		spellPut("156-73", "lei");
		spellPut("156-74", "zhe");
		spellPut("156-75", "ping,peng");
		spellPut("156-76", "tian");
		spellPut("156-77", "yu,xu");
		spellPut("156-78", "ni");
		spellPut("156-79", "lu");
		spellPut("156-80", "mi");
		spellPut("156-81", "jing,cheng");
		spellPut("156-82", "ling");
		spellPut("156-83", "lun");
		spellPut("156-84", "qu");
		spellPut("156-85", "yu");
		spellPut("156-86", "nian,shen");
		spellPut("156-87", "biao,hu");
		spellPut("156-88", "hu");
		spellPut("156-89", "yuan");
		spellPut("156-90", "lai");
		spellPut("156-91", "qing");
		spellPut("156-92", "qian");
		spellPut("156-93", "zhi");
		spellPut("156-94", "yin");
		spellPut("156-95", "bo");
		spellPut("156-96", "ben");
		spellPut("156-97", "yuan");
		spellPut("156-98", "wen,min");
		spellPut("156-99", "ruo,re,luo");
		spellPut("156-100", "fei");
		spellPut("156-101", "yuan");
		spellPut("156-102", "ke");
		spellPut("156-103", "ji");
		spellPut("156-104", "she");
		spellPut("156-105", "se");
		spellPut("156-106", "yi");
		spellPut("156-107", "pai");
		spellPut("156-108", "xi");
		spellPut("156-109", "yuan");
		spellPut("156-110", "rou");
		spellPut("156-111", "huan");
		spellPut("156-112", "jian");
		spellPut("156-113", "nuan");
		spellPut("156-114", "qiu,wu");
		spellPut("156-115", "ting");
		spellPut("156-116", "feng");
		spellPut("156-117", "wo,guo");
		spellPut("156-118", "ti,di");
		spellPut("156-119", "wei");
		spellPut("156-120", "ru");
		spellPut("156-121", "ce");
		spellPut("156-122", "he");
		spellPut("156-123", "yan");
		spellPut("156-124", "hong");
		spellPut("156-125", "mi");
		spellPut("156-126", "mao");
		spellPut("156-128", "ying");
		spellPut("156-129", "yan");
		spellPut("156-130", "hong,qing");
		spellPut("156-131", "sheng");
		spellPut("156-132", "mei");
		spellPut("156-133", "zai");
		spellPut("156-134", "hun");
		spellPut("156-135", "nai");
		spellPut("156-136", "gui");
		spellPut("156-137", "chi");
		spellPut("156-138", "e");
		spellPut("156-139", "lian");
		spellPut("156-140", "qi");
		spellPut("156-141", "qi");
		spellPut("156-142", "mei");
		spellPut("156-143", "tian");
		spellPut("156-144", "cou");
		spellPut("156-145", "wei");
		spellPut("156-146", "can");
		spellPut("156-147", "hui,min,xu");
		spellPut("156-148", "po");
		spellPut("156-149", "xu");
		spellPut("156-150", "ji");
		spellPut("156-151", "jian");
		spellPut("156-152", "feng");
		spellPut("156-153", "yi");
		spellPut("156-154", "yin");
		spellPut("156-155", "shi");
		spellPut("156-156", "jie");
		spellPut("156-157", "zhen");
		spellPut("156-158", "tan");
		spellPut("156-159", "yu");
		spellPut("156-160", "bi");
		spellPut("156-161", "min,hun");
		spellPut("156-162", "shi");
		spellPut("156-163", "tu");
		spellPut("156-164", "sheng");
		spellPut("156-165", "yong");
		spellPut("156-166", "ju");
		spellPut("156-167", "dong");
		spellPut("156-168", "tuan,nuan");
		spellPut("156-169", "qiu,jiao");
		spellPut("156-170", "qiu");
		spellPut("156-171", "tang,shang");
		spellPut("156-172", "long");
		spellPut("156-173", "huo");
		spellPut("156-174", "yuan");
		spellPut("156-175", "nan");
		spellPut("156-176", "ban,pan");
		spellPut("156-177", "you");
		spellPut("156-178", "quan");
		spellPut("156-179", "zhuang,hun");
		spellPut("156-180", "liang");
		spellPut("156-181", "chan");
		spellPut("156-182", "xian");
		spellPut("156-183", "chun");
		spellPut("156-184", "nie");
		spellPut("156-185", "zi");
		spellPut("156-186", "man");
		spellPut("156-187", "ying");
		spellPut("156-188", "lB");
		spellPut("156-189", "feng,hong");
		spellPut("156-190", "lou");
		spellPut("156-191", "wei");
		spellPut("156-192", "bo");
		spellPut("156-193", "ying");
		spellPut("156-194", "ha tu");
		spellPut("156-195", "jin");
		spellPut("156-196", "yan,gui");
		spellPut("156-197", "suo");
		spellPut("156-198", "yuan");
		spellPut("156-199", "lian,nian,xian");
		spellPut("156-200", "yao");
		spellPut("156-201", "meng");
		spellPut("156-202", "zhun");
		spellPut("156-203", "cheng");
		spellPut("156-204", "tai");
		spellPut("156-205", "da,ta");
		spellPut("156-206", "wa");
		spellPut("156-207", "gou");
		spellPut("156-208", "sao");
		spellPut("156-209", "zha");
		spellPut("156-210", "shi");
		spellPut("156-211", "lun");
		spellPut("156-212", "ma");
		spellPut("156-213", "wei");
		spellPut("156-214", "zai");
		spellPut("156-215", "wu");
		spellPut("156-216", "wen");
		spellPut("156-217", "qiang");
		spellPut("156-218", "ze");
		spellPut("156-219", "shi");
		spellPut("156-220", "ai");
		spellPut("156-221", "yun");
		spellPut("156-222", "yin");
		spellPut("156-223", "su");
		spellPut("156-224", "suo");
		spellPut("156-225", "shi");
		spellPut("156-226", "ai");
		spellPut("156-227", "pan");
		spellPut("156-228", "chu,xu");
		spellPut("156-229", "weng");
		spellPut("156-230", "cang");
		spellPut("156-231", "mie");
		spellPut("156-232", "ge");
		spellPut("156-233", "hao,xue");
		spellPut("156-234", "huang");
		spellPut("156-235", "qi,xi,xie");
		spellPut("156-236", "di");
		spellPut("156-237", "zhi");
		spellPut("156-238", "xing,ying");
		spellPut("156-239", "jie");
		spellPut("156-240", "ge");
		spellPut("156-241", "sui");
		spellPut("156-242", "jiao");
		spellPut("156-243", "hui");
		spellPut("156-244", "yin");
		spellPut("156-245", "ze,hao");
		spellPut("156-246", "long");
		spellPut("156-247", "chun");
		spellPut("156-248", "yao");
		spellPut("156-249", "yu");
		spellPut("156-250", "xiu");
		spellPut("156-251", "hu");
		spellPut("156-252", "bi");
		spellPut("156-253", "biao");
		spellPut("156-254", "zhi");
	}

	private static void init28() {
		spellPut("157-64", "jiang");
		spellPut("157-65", "kou");
		spellPut("157-66", "shen");
		spellPut("157-67", "shang");
		spellPut("157-68", "mi");
		spellPut("157-69", "ao");
		spellPut("157-70", "lu");
		spellPut("157-71", "hu,xu");
		spellPut("157-72", "you");
		spellPut("157-73", "chan");
		spellPut("157-74", "fan");
		spellPut("157-75", "yong");
		spellPut("157-76", "gun");
		spellPut("157-77", "man");
		spellPut("157-78", "qing");
		spellPut("157-79", "yu");
		spellPut("157-80", "ji");
		spellPut("157-81", "ya");
		spellPut("157-82", "chao");
		spellPut("157-83", "xi");
		spellPut("157-84", "ji");
		spellPut("157-85", "lou");
		spellPut("157-86", "long");
		spellPut("157-87", "jin");
		spellPut("157-88", "guo");
		spellPut("157-89", "cong,song");
		spellPut("157-90", "zhi");
		spellPut("157-91", "gai");
		spellPut("157-92", "qiang");
		spellPut("157-93", "jiao");
		spellPut("157-94", "cong");
		spellPut("157-95", "chun");
		spellPut("157-96", "tuan,zhuan");
		spellPut("157-97", "ou");
		spellPut("157-98", "teng");
		spellPut("157-99", "ye");
		spellPut("157-100", "xi");
		spellPut("157-101", "mi");
		spellPut("157-102", "tang");
		spellPut("157-103", "shang");
		spellPut("157-104", "han");
		spellPut("157-105", "lian");
		spellPut("157-106", "wa");
		spellPut("157-107", "chi");
		spellPut("157-108", "gan");
		spellPut("157-109", "feng,peng");
		spellPut("157-110", "zi");
		spellPut("157-111", "kang");
		spellPut("157-112", "ben,peng");
		spellPut("157-113", "zhang");
		spellPut("157-114", "chong,zhuang");
		spellPut("157-115", "xu");
		spellPut("157-116", "huo,kuo");
		spellPut("157-117", "jian");
		spellPut("157-118", "yan");
		spellPut("157-119", "shuang");
		spellPut("157-120", "liao,liu");
		spellPut("157-121", "cui");
		spellPut("157-122", "ti");
		spellPut("157-123", "jiang");
		spellPut("157-124", "cong,zong");
		spellPut("157-125", "ying");
		spellPut("157-126", "hong");
		spellPut("157-128", "xiu");
		spellPut("157-129", "shu");
		spellPut("157-130", "guan");
		spellPut("157-131", "cong,zong");
		spellPut("157-132", "kun");
		spellPut("157-133", "xu");
		spellPut("157-134", "zhi");
		spellPut("157-135", "pi,pie");
		spellPut("157-136", "yu");
		spellPut("157-137", "jiao,qiao");
		spellPut("157-138", "po");
		spellPut("157-139", "dang,xiang");
		spellPut("157-140", "hui");
		spellPut("157-141", "jie");
		spellPut("157-142", "wu");
		spellPut("157-143", "pa");
		spellPut("157-144", "ji");
		spellPut("157-145", "wei");
		spellPut("157-146", "su");
		spellPut("157-147", "qian");
		spellPut("157-148", "xi,ya");
		spellPut("157-149", "xi");
		spellPut("157-150", "xun");
		spellPut("157-151", "dun");
		spellPut("157-152", "min");
		spellPut("157-153", "run");
		spellPut("157-154", "su");
		spellPut("157-155", "zhen");
		spellPut("157-156", "cong,zong");
		spellPut("157-157", "yi");
		spellPut("157-158", "zhi");
		spellPut("157-159", "wan");
		spellPut("157-160", "tan,shan");
		spellPut("157-161", "xun");
		spellPut("157-162", "kui,hui");
		spellPut("157-163", "ye");
		spellPut("157-164", "tu,zha");
		spellPut("157-165", "san,sa");
		spellPut("157-166", "hei");
		spellPut("157-167", "bi");
		spellPut("157-168", "chan");
		spellPut("157-169", "shu");
		spellPut("157-170", "pu");
		spellPut("157-171", "lin");
		spellPut("157-172", "wei");
		spellPut("157-173", "se");
		spellPut("157-174", "se");
		spellPut("157-175", "cheng");
		spellPut("157-176", "jiong");
		spellPut("157-177", "hua");
		spellPut("157-178", "jiao");
		spellPut("157-179", "lao");
		spellPut("157-180", "cun");
		spellPut("157-181", "jing");
		spellPut("157-182", "han");
		spellPut("157-183", "yun");
		spellPut("157-184", "liu");
		spellPut("157-185", "hong,gong");
		spellPut("157-186", "fu");
		spellPut("157-187", "hao");
		spellPut("157-188", "he");
		spellPut("157-189", "xian");
		spellPut("157-190", "jian");
		spellPut("157-191", "shan");
		spellPut("157-192", "xi");
		spellPut("157-193", "Bo");
		spellPut("157-194", "lu");
		spellPut("157-195", "ning");
		spellPut("157-196", "yu");
		spellPut("157-197", "lin");
		spellPut("157-198", "mian,sheng");
		spellPut("157-199", "dang");
		spellPut("157-200", "huan");
		spellPut("157-201", "ze,shi");
		spellPut("157-202", "xie");
		spellPut("157-203", "yu");
		spellPut("157-204", "shi");
		spellPut("157-205", "xue");
		spellPut("157-206", "ling");
		spellPut("157-207", "wan,man");
		spellPut("157-208", "zi");
		spellPut("157-209", "yong");
		spellPut("157-210", "kuai,hui");
		spellPut("157-211", "can");
		spellPut("157-212", "lian");
		spellPut("157-213", "dian");
		spellPut("157-214", "ye");
		spellPut("157-215", "huan");
		spellPut("157-216", "zhen");
		spellPut("157-217", "man");
		spellPut("157-218", "gan");
		spellPut("157-219", "yi");
		spellPut("157-220", "sui");
		spellPut("157-221", "pi");
		spellPut("157-222", "ju");
		spellPut("157-223", "ta");
		spellPut("157-224", "qin");
		spellPut("157-225", "zhuo");
		spellPut("157-226", "nong");
		spellPut("157-227", "guo,wo");
		spellPut("157-228", "jin");
		spellPut("157-229", "fen,pen");
		spellPut("157-230", "se");
		spellPut("157-231", "ji,sha");
		spellPut("157-232", "hui,huo");
		spellPut("157-233", "chu");
		spellPut("157-234", "ta");
		spellPut("157-235", "song");
		spellPut("157-236", "ding,ting");
		spellPut("157-237", "se");
		spellPut("157-238", "zhu");
		spellPut("157-239", "lian");
		spellPut("157-240", "mi,ni");
		spellPut("157-241", "shi");
		spellPut("157-242", "shu");
		spellPut("157-243", "mi");
		spellPut("157-244", "ning");
		spellPut("157-245", "ying");
		spellPut("157-246", "ying");
		spellPut("157-247", "meng");
		spellPut("157-248", "jin");
		spellPut("157-249", "qi");
		spellPut("157-250", "ji");
		spellPut("157-251", "cui,zui");
		spellPut("157-252", "wo");
		spellPut("157-253", "tao");
		spellPut("157-254", "yin");
	}

	private static void init29() {
		spellPut("158-64", "yin");
		spellPut("158-65", "dui");
		spellPut("158-66", "ci");
		spellPut("158-67", "huo,hu");
		spellPut("158-68", "qing");
		spellPut("158-69", "lan");
		spellPut("158-70", "jun,xun");
		spellPut("158-71", "ai,kai,ke");
		spellPut("158-72", "wei");
		spellPut("158-73", "bin");
		spellPut("158-74", "gu");
		spellPut("158-75", "qian");
		spellPut("158-76", "ying");
		spellPut("158-77", "bin");
		spellPut("158-78", "kuo");
		spellPut("158-79", "fei");
		spellPut("158-80", "cBng");
		spellPut("158-81", "bo ku");
		spellPut("158-82", "jian");
		spellPut("158-83", "wei,dui");
		spellPut("158-84", "luo,po");
		spellPut("158-85", "zan,cuan");
		spellPut("158-86", "lv");
		spellPut("158-87", "li");
		spellPut("158-88", "you");
		spellPut("158-89", "yang");
		spellPut("158-90", "lu");
		spellPut("158-91", "si");
		spellPut("158-92", "zhi");
		spellPut("158-93", "ying");
		spellPut("158-94", "du,dou");
		spellPut("158-95", "wang");
		spellPut("158-96", "hui");
		spellPut("158-97", "xie");
		spellPut("158-98", "pan");
		spellPut("158-99", "shen");
		spellPut("158-100", "biao");
		spellPut("158-101", "chan");
		spellPut("158-102", "mie,mo");
		spellPut("158-103", "liu");
		spellPut("158-104", "jian");
		spellPut("158-105", "se");
		spellPut("158-106", "cheng,deng");
		spellPut("158-107", "gu");
		spellPut("158-108", "bin");
		spellPut("158-109", "huo");
		spellPut("158-110", "xian");
		spellPut("158-111", "lu");
		spellPut("158-112", "qin");
		spellPut("158-113", "rong");
		spellPut("158-114", "li");
		spellPut("158-115", "jing");
		spellPut("158-116", "xiao");
		spellPut("158-117", "ying");
		spellPut("158-118", "sui");
		spellPut("158-119", "wei,dui");
		spellPut("158-120", "huai,wai");
		spellPut("158-121", "xue");
		spellPut("158-122", "zhu");
		spellPut("158-123", "long,shuang");
		spellPut("158-124", "lai");
		spellPut("158-125", "dui");
		spellPut("158-126", "fan");
		spellPut("158-128", "hu");
		spellPut("158-129", "lai");
		spellPut("158-130", "shu");
		spellPut("158-131", "lian");
		spellPut("158-132", "ying");
		spellPut("158-133", "mi");
		spellPut("158-134", "ji");
		spellPut("158-135", "lian");
		spellPut("158-136", "jian,zun");
		spellPut("158-137", "ying");
		spellPut("158-138", "lin");
		spellPut("158-139", "yi");
		spellPut("158-140", "jian");
		spellPut("158-141", "chan");
		spellPut("158-142", "dai");
		spellPut("158-143", "rang,nang");
		spellPut("158-144", "jian");
		spellPut("158-145", "lan");
		spellPut("158-146", "fan");
		spellPut("158-147", "shuang");
		spellPut("158-148", "yuan");
		spellPut("158-149", "zhuo,jiao,ze");
		spellPut("158-150", "feng");
		spellPut("158-151", "she");
		spellPut("158-152", "lei");
		spellPut("158-153", "lan");
		spellPut("158-154", "cong");
		spellPut("158-155", "qu");
		spellPut("158-156", "yong");
		spellPut("158-157", "qian");
		spellPut("158-158", "fa");
		spellPut("158-159", "jue");
		spellPut("158-160", "yan");
		spellPut("158-161", "ying");
		spellPut("158-162", "sa");
		spellPut("158-163", "zan,cuan");
		spellPut("158-164", "luan");
		spellPut("158-165", "yan");
		spellPut("158-166", "li");
		spellPut("158-167", "mi");
		spellPut("158-168", "shan");
		spellPut("158-169", "tan");
		spellPut("158-170", "dang,tang");
		spellPut("158-171", "jiao");
		spellPut("158-172", "chan");
		spellPut("158-173", "ying");
		spellPut("158-174", "hao");
		spellPut("158-175", "zhu");
		spellPut("158-176", "lan");
		spellPut("158-177", "lan");
		spellPut("158-178", "nang");
		spellPut("158-179", "wan");
		spellPut("158-180", "luan");
		spellPut("158-181", "xun,quan");
		spellPut("158-182", "xian");
		spellPut("158-183", "yan");
		spellPut("158-184", "gan");
		spellPut("158-185", "yan");
		spellPut("158-186", "yu");
		spellPut("158-187", "guang");
		spellPut("158-188", "xiao");
		spellPut("158-189", "xiao");
		spellPut("158-190", "hui");
		spellPut("158-191", "hong");
		spellPut("158-192", "zhuan");
		spellPut("158-193", "zha,yu");
		spellPut("158-194", "xie");
		spellPut("158-195", "chi");
		spellPut("158-196", "zai");
		spellPut("158-197", "qi");
		spellPut("158-198", "zhong");
		spellPut("158-199", "fen,ben");
		spellPut("158-200", "niu");
		spellPut("158-201", "wen");
		spellPut("158-202", "pu");
		spellPut("158-203", "yi");
		spellPut("158-204", "pi");
		spellPut("158-205", "kai");
		spellPut("158-206", "pan");
		spellPut("158-207", "yan");
		spellPut("158-208", "pang,feng");
		spellPut("158-209", "mu");
		spellPut("158-210", "liao");
		spellPut("158-211", "guang");
		spellPut("158-212", "xin");
		spellPut("158-213", "guang");
		spellPut("158-214", "guang");
		spellPut("158-215", "bian");
		spellPut("158-216", "da");
		spellPut("158-217", "xia");
		spellPut("158-218", "zheng");
		spellPut("158-219", "zhu");
		spellPut("158-220", "ke");
		spellPut("158-221", "zhao");
		spellPut("158-222", "fu");
		spellPut("158-223", "ba");
		spellPut("158-224", "xie");
		spellPut("158-225", "xie");
		spellPut("158-226", "ling");
		spellPut("158-227", "zhuo,chu");
		spellPut("158-228", "pao,fou");
		spellPut("158-229", "tai");
		spellPut("158-230", "yang");
		spellPut("158-231", "tong");
		spellPut("158-232", "shan,qian");
		spellPut("158-233", "wei");
		spellPut("158-234", "huang");
		spellPut("158-235", "zhou");
		spellPut("158-236", "jiao,yao");
		spellPut("158-237", "xu");
		spellPut("158-238", "heng");
		spellPut("158-239", "quan");
		spellPut("158-240", "huan");
		spellPut("158-241", "xiao");
		spellPut("158-242", "xiu");
		spellPut("158-243", "xian");
		spellPut("158-244", "yin");
		spellPut("158-245", "wu");
		spellPut("158-246", "zhou");
		spellPut("158-247", "yao");
		spellPut("158-248", "shi");
		spellPut("158-249", "wei");
		spellPut("158-250", "tong,dong");
		spellPut("158-251", "mie");
		spellPut("158-252", "zai");
		spellPut("158-253", "kai");
		spellPut("158-254", "xia");
	}

	private static void init30() {
		spellPut("159-64", "xuan");
		spellPut("159-65", "zheng");
		spellPut("159-66", "po");
		spellPut("159-67", "hui");
		spellPut("159-68", "guang");
		spellPut("159-69", "che");
		spellPut("159-70", "hui");
		spellPut("159-71", "chen");
		spellPut("159-72", "uu");
		spellPut("159-73", "lie");
		spellPut("159-74", "fu,pao");
		spellPut("159-75", "jiong");
		spellPut("159-76", "xie,che");
		spellPut("159-77", "pu");
		spellPut("159-78", "ting");
		spellPut("159-79", "zhuo");
		spellPut("159-80", "ting");
		spellPut("159-81", "hai");
		spellPut("159-82", "lang");
		spellPut("159-83", "yan");
		spellPut("159-84", "xu");
		spellPut("159-85", "chi");
		spellPut("159-86", "rong");
		spellPut("159-87", "hu");
		spellPut("159-88", "xi");
		spellPut("159-89", "shu");
		spellPut("159-90", "he");
		spellPut("159-91", "xun,hun");
		spellPut("159-92", "ku");
		spellPut("159-93", "juan,ye");
		spellPut("159-94", "xiao");
		spellPut("159-95", "xi");
		spellPut("159-96", "zhuang");
		spellPut("159-97", "qu,jun");
		spellPut("159-98", "di");
		spellPut("159-99", "xie,che");
		spellPut("159-100", "ji,qi");
		spellPut("159-101", "uu");
		spellPut("159-102", "l<");
		spellPut("159-103", "yan");
		spellPut("159-104", "ju");
		spellPut("159-105", "lin");
		spellPut("159-106", "kun");
		spellPut("159-107", "hun");
		spellPut("159-108", "tun");
		spellPut("159-109", "xi");
		spellPut("159-110", "cui");
		spellPut("159-111", "wu");
		spellPut("159-112", "hong");
		spellPut("159-113", "chao,ju");
		spellPut("159-114", "fu");
		spellPut("159-115", "wo,ai");
		spellPut("159-116", "zong,cong");
		spellPut("159-117", "feng");
		spellPut("159-118", "ping");
		spellPut("159-119", "qiong");
		spellPut("159-120", "ruo");
		spellPut("159-121", "xi,yi");
		spellPut("159-122", "qiong");
		spellPut("159-123", "xin");
		spellPut("159-124", "yi");
		spellPut("159-125", "jue");
		spellPut("159-126", "yu");
		spellPut("159-128", "gang");
		spellPut("159-129", "pi");
		spellPut("159-130", "xiong,ying");
		spellPut("159-131", "gang");
		spellPut("159-132", "sheng");
		spellPut("159-133", "chang");
		spellPut("159-134", "shao");
		spellPut("159-135", "xiong,ying");
		spellPut("159-136", "ne mu");
		spellPut("159-137", "geng");
		spellPut("159-138", "qu");
		spellPut("159-139", "chen");
		spellPut("159-140", "he");
		spellPut("159-141", "kui");
		spellPut("159-142", "zhong");
		spellPut("159-143", "xia");
		spellPut("159-144", "hui,yun,xun");
		spellPut("159-145", "feng");
		spellPut("159-146", "lian");
		spellPut("159-147", "xing");
		spellPut("159-148", "jiao");
		spellPut("159-149", "bi");
		spellPut("159-150", "ying");
		spellPut("159-151", "zhu");
		spellPut("159-152", "wei");
		spellPut("159-153", "tuan");
		spellPut("159-154", "shan,qian");
		spellPut("159-155", "xi,yi");
		spellPut("159-156", "nuan");
		spellPut("159-157", "nuan");
		spellPut("159-158", "chan");
		spellPut("159-159", "yan");
		spellPut("159-160", "jiong");
		spellPut("159-161", "jiong");
		spellPut("159-162", "mei");
		spellPut("159-163", "wei");
		spellPut("159-164", "ye,zha");
		spellPut("159-165", "jin");
		spellPut("159-166", "qiong");
		spellPut("159-167", "rou");
		spellPut("159-168", "huan");
		spellPut("159-169", "fan");
		spellPut("159-170", "qiu");
		spellPut("159-171", "sui");
		spellPut("159-172", "yang");
		spellPut("159-173", "lie");
		spellPut("159-174", "jie");
		spellPut("159-175", "zao");
		spellPut("159-176", "gua");
		spellPut("159-177", "yun");
		spellPut("159-178", "nan");
		spellPut("159-179", "shi");
		spellPut("159-180", "huo");
		spellPut("159-181", "gou");
		spellPut("159-182", "tang");
		spellPut("159-183", "chao");
		spellPut("159-184", "en,yun");
		spellPut("159-185", "bo");
		spellPut("159-186", "huang");
		spellPut("159-187", "xie");
		spellPut("159-188", "xi");
		spellPut("159-189", "wu");
		spellPut("159-190", "yun");
		spellPut("159-191", "he");
		spellPut("159-192", "he,xiao");
		spellPut("159-193", "xi");
		spellPut("159-194", "yun");
		spellPut("159-195", "xiong");
		spellPut("159-196", "shan");
		spellPut("159-197", "qiong");
		spellPut("159-198", "yao");
		spellPut("159-199", "mi");
		spellPut("159-200", "lian");
		spellPut("159-201", "ying");
		spellPut("159-202", "wu");
		spellPut("159-203", "gong");
		spellPut("159-204", "yan");
		spellPut("159-205", "qiang");
		spellPut("159-206", "bi");
		spellPut("159-207", "biao");
		spellPut("159-208", "cong,zong");
		spellPut("159-209", "lu,ao");
		spellPut("159-210", "jian");
		spellPut("159-211", "lou");
		spellPut("159-212", "peng,feng");
		spellPut("159-213", "sui,cui");
		spellPut("159-214", "yi");
		spellPut("159-215", "teng");
		spellPut("159-216", "jue");
		spellPut("159-217", "zong");
		spellPut("159-218", "hu");
		spellPut("159-219", "yi");
		spellPut("159-220", "zhi");
		spellPut("159-221", "wei");
		spellPut("159-222", "liu");
		spellPut("159-223", "han,ran");
		spellPut("159-224", "ou");
		spellPut("159-225", "re");
		spellPut("159-226", "jiong");
		spellPut("159-227", "kun");
		spellPut("159-228", "cuan");
		spellPut("159-229", "zeng");
		spellPut("159-230", "jian");
		spellPut("159-231", "xi");
		spellPut("159-232", "xi");
		spellPut("159-233", "yi");
		spellPut("159-234", "xiao");
		spellPut("159-235", "chi");
		spellPut("159-236", "huang");
		spellPut("159-237", "chan,dan");
		spellPut("159-238", "ye");
		spellPut("159-239", "tan");
		spellPut("159-240", "yan");
		spellPut("159-241", "xun");
		spellPut("159-242", "qiao");
		spellPut("159-243", "jun");
		spellPut("159-244", "deng");
		spellPut("159-245", "dun");
		spellPut("159-246", "shen");
		spellPut("159-247", "jiao,qiao,jue,zhuo");
		spellPut("159-248", "fen");
		spellPut("159-249", "si");
		spellPut("159-250", "yu");
		spellPut("159-251", "lin");
		spellPut("159-252", "tong,dong");
		spellPut("159-253", "shao");
		spellPut("159-254", "fen");
	}

	private static void init31() {
		spellPut("160-64", "xun");
		spellPut("160-65", "lan");
		spellPut("160-66", "mei");
		spellPut("160-67", "tang");
		spellPut("160-68", "yi");
		spellPut("160-69", "jiong");
		spellPut("160-70", "men");
		spellPut("160-71", "zhu");
		spellPut("160-72", "uu");
		spellPut("160-73", "ying");
		spellPut("160-74", "yi");
		spellPut("160-75", "xue");
		spellPut("160-76", "lan");
		spellPut("160-77", "tai,lie");
		spellPut("160-78", "can");
		spellPut("160-79", "xi");
		spellPut("160-80", "que");
		spellPut("160-81", "zong");
		spellPut("160-82", "lian");
		spellPut("160-83", "hui");
		spellPut("160-84", "zhu");
		spellPut("160-85", "ling");
		spellPut("160-86", "wei");
		spellPut("160-87", "yi");
		spellPut("160-88", "xie");
		spellPut("160-89", "zhao");
		spellPut("160-90", "hui");
		spellPut("160-91", "ta tui");
		spellPut("160-92", "nong");
		spellPut("160-93", "lan");
		spellPut("160-94", "xu");
		spellPut("160-95", "he");
		spellPut("160-96", "xun");
		spellPut("160-97", "jin");
		spellPut("160-98", "chou");
		spellPut("160-99", "dao");
		spellPut("160-100", "yao");
		spellPut("160-101", "he");
		spellPut("160-102", "lan");
		spellPut("160-103", "biao");
		spellPut("160-104", "rong,ying");
		spellPut("160-105", "li,lie");
		spellPut("160-106", "mo");
		spellPut("160-107", "ruo");
		spellPut("160-108", "lv");
		spellPut("160-109", "la,lie");
		spellPut("160-110", "ao");
		spellPut("160-111", "xun");
		spellPut("160-112", "kuang,huang");
		spellPut("160-113", "shuo");
		spellPut("160-114", "liao");
		spellPut("160-115", "li");
		spellPut("160-116", "lu");
		spellPut("160-117", "jue");
		spellPut("160-118", "liao");
		spellPut("160-119", "yan,xun");
		spellPut("160-120", "xi");
		spellPut("160-121", "xie");
		spellPut("160-122", "long");
		spellPut("160-123", "ye");
		spellPut("160-124", "cBn");
		spellPut("160-125", "rang");
		spellPut("160-126", "yue");
		spellPut("160-128", "lan");
		spellPut("160-129", "cong");
		spellPut("160-130", "chong");
		spellPut("160-131", "guan");
		spellPut("160-132", "qu");
		spellPut("160-133", "che");
		spellPut("160-134", "mi");
		spellPut("160-135", "tang");
		spellPut("160-136", "lan");
		spellPut("160-137", "zhu");
		spellPut("160-138", "lan");
		spellPut("160-139", "ling");
		spellPut("160-140", "yu");
		spellPut("160-141", "zhao,zhua");
		spellPut("160-142", "zheng");
		spellPut("160-143", "pao");
		spellPut("160-144", "cheng,chen");
		spellPut("160-145", "wei");
		spellPut("160-146", "hBn");
		spellPut("160-147", "jue");
		spellPut("160-148", "ye");
		spellPut("160-149", "zu");
		spellPut("160-150", "er");
		spellPut("160-151", "chuang");
		spellPut("160-152", "ke");
		spellPut("160-153", "zang");
		spellPut("160-154", "die");
		spellPut("160-155", "qiang");
		spellPut("160-156", "yong");
		spellPut("160-157", "qiang");
		spellPut("160-158", "pan");
		spellPut("160-159", "chao");
		spellPut("160-160", "jian");
		spellPut("160-161", "chuang");
		spellPut("160-162", "yu");
		spellPut("160-163", "zha");
		spellPut("160-164", "bian,mian");
		spellPut("160-165", "bang");
		spellPut("160-166", "bo");
		spellPut("160-167", "chuang");
		spellPut("160-168", "you,yong");
		spellPut("160-169", "du");
		spellPut("160-170", "cheng");
		spellPut("160-171", "niu");
		spellPut("160-172", "jiu,le");
		spellPut("160-173", "ta");
		spellPut("160-174", "ren");
		spellPut("160-175", "mang");
		spellPut("160-176", "fang");
		spellPut("160-177", "gang");
		spellPut("160-178", "yan");
		spellPut("160-179", "ge,qiu");
		spellPut("160-180", "bei");
		spellPut("160-181", "si");
		spellPut("160-182", "you,chou");
		spellPut("160-183", "ke");
		spellPut("160-184", "mu");
		spellPut("160-185", "di");
		spellPut("160-186", "quan");
		spellPut("160-187", "quan");
		spellPut("160-188", "zi");
		spellPut("160-189", "mang");
		spellPut("160-190", "keng");
		spellPut("160-191", "qian");
		spellPut("160-192", "li");
		spellPut("160-193", "pou");
		spellPut("160-194", "gang");
		spellPut("160-195", "zhi,te");
		spellPut("160-196", "ben");
		spellPut("160-197", "quan");
		spellPut("160-198", "chun");
		spellPut("160-199", "jia");
		spellPut("160-200", "feng");
		spellPut("160-201", "ke");
		spellPut("160-202", "ju");
		spellPut("160-203", "chu");
		spellPut("160-204", "xi");
		spellPut("160-205", "bei");
		spellPut("160-206", "luo");
		spellPut("160-207", "jie");
		spellPut("160-208", "ma");
		spellPut("160-209", "san");
		spellPut("160-210", "wei");
		spellPut("160-211", "mao,li");
		spellPut("160-212", "dun");
		spellPut("160-213", "tong");
		spellPut("160-214", "qiao");
		spellPut("160-215", "xi");
		spellPut("160-216", "li");
		spellPut("160-217", "du");
		spellPut("160-218", "lie");
		spellPut("160-219", "bai");
		spellPut("160-220", "piao");
		spellPut("160-221", "bao");
		spellPut("160-222", "xi");
		spellPut("160-223", "chou");
		spellPut("160-224", "wei");
		spellPut("160-225", "kui");
		spellPut("160-226", "chou");
		spellPut("160-227", "quan,ba");
		spellPut("160-228", "ji");
		spellPut("160-229", "chai");
		spellPut("160-230", "zhuo,bao");
		spellPut("160-231", "ge");
		spellPut("160-232", "kang,gang");
		spellPut("160-233", "pei,fei");
		spellPut("160-234", "hou");
		spellPut("160-235", "ya");
		spellPut("160-236", "yin");
		spellPut("160-237", "huan,fan");
		spellPut("160-238", "zhuang");
		spellPut("160-239", "kuang");
		spellPut("160-240", "zhong");
		spellPut("160-241", "mu");
		spellPut("160-242", "pi");
		spellPut("160-243", "ju");
		spellPut("160-244", "yi,quan,chi");
		spellPut("160-245", "sheng,xing");
		spellPut("160-246", "tuo,yi");
		spellPut("160-247", "ling");
		spellPut("160-248", "pi");
		spellPut("160-249", "ni");
		spellPut("160-250", "yao");
		spellPut("160-251", "you");
		spellPut("160-252", "xue");
		spellPut("160-253", "dan");
		spellPut("160-254", "bo");
	}

	private static void init32() {
		spellPut("170-64", "ku");
		spellPut("170-65", "xian");
		spellPut("170-66", "huan");
		spellPut("170-67", "he,mo");
		spellPut("170-68", "zhao");
		spellPut("170-69", "jie");
		spellPut("170-70", "xun");
		spellPut("170-71", "shan");
		spellPut("170-72", "ta,shi");
		spellPut("170-73", "tong,dong");
		spellPut("170-74", "lao");
		spellPut("170-75", "mang,dou");
		spellPut("170-76", "xi,shi");
		spellPut("170-77", "xia");
		spellPut("170-78", "bei");
		spellPut("170-79", "zhi");
		spellPut("170-80", "yan");
		spellPut("170-81", "sha");
		spellPut("170-82", "han");
		spellPut("170-83", "jing");
		spellPut("170-84", "pai");
		spellPut("170-85", "fei");
		spellPut("170-86", "xiao");
		spellPut("170-87", "bai,pi");
		spellPut("170-88", "qi");
		spellPut("170-89", "biao");
		spellPut("170-90", "yin");
		spellPut("170-91", "lai");
		spellPut("170-92", "jian,yan");
		spellPut("170-93", "qiang");
		spellPut("170-94", "kun");
		spellPut("170-95", "yan");
		spellPut("170-96", "zong");
		spellPut("170-97", "zhi");
		spellPut("170-98", "zheng");
		spellPut("170-99", "ya,wei");
		spellPut("170-100", "lie");
		spellPut("170-101", "ce o n");
		spellPut("170-102", "zong");
		spellPut("170-103", "gui");
		spellPut("170-104", "feng");
		spellPut("170-105", "wo");
		spellPut("170-106", "yuan");
		spellPut("170-107", "chuan");
		spellPut("170-108", "tuan");
		spellPut("170-109", "ya,jia,qie");
		spellPut("170-110", "xie,he,ge,hai");
		spellPut("170-111", "jia");
		spellPut("170-112", "bian,pian");
		spellPut("170-113", "you");
		spellPut("170-114", "yao");
		spellPut("170-115", "sun");
		spellPut("170-116", "bo,po");
		spellPut("170-117", "ming");
		spellPut("170-118", "sou");
		spellPut("170-119", "ma");
		spellPut("170-120", "huan");
		spellPut("170-121", "dai");
		spellPut("170-122", "yu");
		spellPut("170-123", "shi");
		spellPut("170-124", "hao");
		spellPut("170-125", "qiang");
		spellPut("170-126", "yi");
		spellPut("170-128", "zhen");
		spellPut("170-129", "cang");
		spellPut("170-130", "hao,gao");
		spellPut("170-131", "man");
		spellPut("170-132", "jiang");
		spellPut("170-133", "mo");
		spellPut("170-134", "chan");
		spellPut("170-135", "ao");
		spellPut("170-136", "hao");
		spellPut("170-137", "suo");
		spellPut("170-138", "fen");
		spellPut("170-139", "bi");
		spellPut("170-140", "bi");
		spellPut("170-141", "huang");
		spellPut("170-142", "pu");
		spellPut("170-143", "lin");
		spellPut("170-144", "xu");
		spellPut("170-145", "tong");
		spellPut("170-146", "yao,xiao");
		spellPut("170-147", "shuo,xi");
		spellPut("170-148", "xiao");
		spellPut("170-149", "shou");
		spellPut("170-150", "du n");
		spellPut("170-151", "jiao");
		spellPut("170-152", "ge,lie,xie");
		spellPut("170-153", "juan");
		spellPut("170-154", "du");
		spellPut("170-155", "hui");
		spellPut("170-156", "kuai");
		spellPut("170-157", "xian");
		spellPut("170-158", "xian");
		spellPut("170-159", "ning");
		spellPut("170-160", "bian,pian");
	}

	private static void init33() {
		spellPut("171-64", "huo");
		spellPut("171-65", "nou,ru");
		spellPut("171-66", "meng");
		spellPut("171-67", "lie");
		spellPut("171-68", "nao,you");
		spellPut("171-69", "guang");
		spellPut("171-70", "shou");
		spellPut("171-71", "lu");
		spellPut("171-72", "ta");
		spellPut("171-73", "xian");
		spellPut("171-74", "mi");
		spellPut("171-75", "rang");
		spellPut("171-76", "nao,you");
		spellPut("171-77", "luo");
		spellPut("171-78", "xian");
		spellPut("171-79", "qi");
		spellPut("171-80", "jue");
		spellPut("171-81", "miao");
		spellPut("171-82", "zi");
		spellPut("171-83", "lu");
		spellPut("171-84", "su");
		spellPut("171-85", "qiu");
		spellPut("171-86", "ga");
		spellPut("171-87", "le");
		spellPut("171-88", "ba");
		spellPut("171-89", "hong");
		spellPut("171-90", "di");
		spellPut("171-91", "chuan");
		spellPut("171-92", "gan");
		spellPut("171-93", "yu");
		spellPut("171-94", "qi");
		spellPut("171-95", "yu");
		spellPut("171-96", "chang,yang");
		spellPut("171-97", "hong");
		spellPut("171-98", "wu");
		spellPut("171-99", "fu");
		spellPut("171-100", "jie");
		spellPut("171-101", "ya");
		spellPut("171-102", "bian");
		spellPut("171-103", "bang");
		spellPut("171-104", "yue");
		spellPut("171-105", "jue");
		spellPut("171-106", "men,yun");
		spellPut("171-107", "jue");
		spellPut("171-108", "jian,qian");
		spellPut("171-109", "dan");
		spellPut("171-110", "pin");
		spellPut("171-111", "qiang,cang");
		spellPut("171-112", "yi");
		spellPut("171-113", "an,gan");
		spellPut("171-114", "ping");
		spellPut("171-115", "fu");
		spellPut("171-116", "xuan,xian");
		spellPut("171-117", "ci");
		spellPut("171-118", "gou");
		spellPut("171-119", "jia");
		spellPut("171-120", "shao");
		spellPut("171-121", "ci");
		spellPut("171-122", "ran");
		spellPut("171-123", "sheng");
		spellPut("171-124", "shen");
		spellPut("171-125", "yi,tai");
		spellPut("171-126", "zu,ju");
		spellPut("171-128", "liu");
		spellPut("171-129", "bi");
		spellPut("171-130", "zhen");
		spellPut("171-131", "jin");
		spellPut("171-132", "jiao");
		spellPut("171-133", "jian");
		spellPut("171-134", "li");
		spellPut("171-135", "guang");
		spellPut("171-136", "xian");
		spellPut("171-137", "zhou");
		spellPut("171-138", "yan");
		spellPut("171-139", "xiu");
		spellPut("171-140", "yang");
		spellPut("171-141", "xu");
		spellPut("171-142", "su");
		spellPut("171-143", "qin");
		spellPut("171-144", "yin,ken");
		spellPut("171-145", "xun");
		spellPut("171-146", "bao");
		spellPut("171-147", "xiang");
		spellPut("171-148", "xia");
		spellPut("171-149", "gui");
		spellPut("171-150", "chong");
		spellPut("171-151", "xu");
		spellPut("171-152", "pei");
		spellPut("171-153", "lao");
		spellPut("171-154", "dang");
		spellPut("171-155", "ying");
		spellPut("171-156", "wen");
		spellPut("171-157", "e");
		spellPut("171-158", "cheng");
		spellPut("171-159", "di,ti");
		spellPut("171-160", "wu");
	}

	private static void init34() {
		spellPut("172-64", "wu");
		spellPut("172-65", "cheng");
		spellPut("172-66", "jun");
		spellPut("172-67", "mei");
		spellPut("172-68", "bei");
		spellPut("172-69", "ting");
		spellPut("172-70", "xian");
		spellPut("172-71", "chu");
		spellPut("172-72", "han");
		spellPut("172-73", "xuan,qiong");
		spellPut("172-74", "yan");
		spellPut("172-75", "xuan");
		spellPut("172-76", "xiu");
		spellPut("172-77", "fu");
		spellPut("172-78", "xi");
		spellPut("172-79", "ling");
		spellPut("172-80", "li");
		spellPut("172-81", "jin");
		spellPut("172-82", "suo");
		spellPut("172-83", "feng");
		spellPut("172-84", "wBn");
		spellPut("172-85", "dian");
		spellPut("172-86", "pin,bing");
		spellPut("172-87", "zhan");
		spellPut("172-88", "cui,se");
		spellPut("172-89", "min");
		spellPut("172-90", "yu");
		spellPut("172-91", "lai");
		spellPut("172-92", "min");
		spellPut("172-93", "sheng");
		spellPut("172-94", "wei,yu");
		spellPut("172-95", "tian");
		spellPut("172-96", "shu");
		spellPut("172-97", "beng,pei");
		spellPut("172-98", "cheng");
		spellPut("172-99", "e");
		spellPut("172-100", "chang");
		spellPut("172-101", "beng");
		spellPut("172-102", "lu");
		spellPut("172-103", "guan");
		spellPut("172-104", "diao");
		spellPut("172-105", "bei");
		spellPut("172-106", "que");
		spellPut("172-107", "zhuo");
		spellPut("172-108", "qin");
		spellPut("172-109", "fa");
		spellPut("172-110", "jin");
		spellPut("172-111", "du");
		spellPut("172-112", "jie");
		spellPut("172-113", "hun,hui");
		spellPut("172-114", "yu");
		spellPut("172-115", "mei");
		spellPut("172-116", "chun");
		spellPut("172-117", "xuan");
		spellPut("172-118", "ti");
		spellPut("172-119", "xing");
		spellPut("172-120", "dai");
		spellPut("172-121", "rou");
		spellPut("172-122", "min");
		spellPut("172-123", "jian");
		spellPut("172-124", "wei");
		spellPut("172-125", "ruan");
		spellPut("172-126", "huan");
		spellPut("172-128", "xie,jie");
		spellPut("172-129", "chuan");
		spellPut("172-130", "jian");
		spellPut("172-131", "zhuan");
		spellPut("172-132", "chang,yang");
		spellPut("172-133", "lian");
		spellPut("172-134", "quan");
		spellPut("172-135", "duan");
		spellPut("172-136", "ye");
		spellPut("172-137", "huang");
		spellPut("172-138", "liu");
		spellPut("172-139", "shi");
		spellPut("172-140", "rong");
		spellPut("172-141", "suo");
		spellPut("172-142", "yao");
		spellPut("172-143", "wen");
		spellPut("172-144", "wu");
		spellPut("172-145", "zhen");
		spellPut("172-146", "jin");
		spellPut("172-147", "ying");
		spellPut("172-148", "ma");
		spellPut("172-149", "tao");
		spellPut("172-150", "liu");
		spellPut("172-151", "li");
		spellPut("172-152", "lang");
		spellPut("172-153", "tian,zhen");
		spellPut("172-154", "qiang,cang");
		spellPut("172-155", "cuo");
		spellPut("172-156", "jue");
		spellPut("172-157", "zhao");
		spellPut("172-158", "bin,pian");
		spellPut("172-159", "tu,shu");
		spellPut("172-160", "chang");
	}

	private static void init35() {
		spellPut("173-64", "kun");
		spellPut("173-65", "zhuan");
		spellPut("173-66", "cong");
		spellPut("173-67", "yi");
		spellPut("173-68", "qi");
		spellPut("173-69", "jing");
		spellPut("173-70", "zao,suo");
		spellPut("173-71", "qiu");
		spellPut("173-72", "ao");
		spellPut("173-73", "lian");
		spellPut("173-74", "men");
		spellPut("173-75", "yin");
		spellPut("173-76", "ye");
		spellPut("173-77", "zhi");
		spellPut("173-78", "wu");
		spellPut("173-79", "deng");
		spellPut("173-80", "xiu");
		spellPut("173-81", "zeng");
		spellPut("173-82", "xun");
		spellPut("173-83", "qu");
		spellPut("173-84", "dang");
		spellPut("173-85", "lin");
		spellPut("173-86", "liao");
		spellPut("173-87", "qiong,jue");
		spellPut("173-88", "su");
		spellPut("173-89", "gui");
		spellPut("173-90", "jing");
		spellPut("173-91", "fan");
		spellPut("173-92", "jin");
		spellPut("173-93", "liu");
		spellPut("173-94", "ji");
		spellPut("173-95", "hui");
		spellPut("173-96", "jing");
		spellPut("173-97", "ai");
		spellPut("173-98", "zao");
		spellPut("173-99", "dang");
		spellPut("173-100", "jiao");
		spellPut("173-101", "guan");
		spellPut("173-102", "tan");
		spellPut("173-103", "hui,kuai");
		spellPut("173-104", "huan");
		spellPut("173-105", "se");
		spellPut("173-106", "sui");
		spellPut("173-107", "tian");
		spellPut("173-108", "chu");
		spellPut("173-109", "yu");
		spellPut("173-110", "jin");
		spellPut("173-111", "lu,fu");
		spellPut("173-112", "bin,pian");
		spellPut("173-113", "shu");
		spellPut("173-114", "zui");
		spellPut("173-115", "lan");
		spellPut("173-116", "xi");
		spellPut("173-117", "ji,zi");
		spellPut("173-118", "xuan");
		spellPut("173-119", "ruan");
		spellPut("173-120", "wo");
		spellPut("173-121", "gai");
		spellPut("173-122", "lei");
		spellPut("173-123", "du");
		spellPut("173-124", "li");
		spellPut("173-125", "zhi");
		spellPut("173-126", "rou");
		spellPut("173-128", "li");
		spellPut("173-129", "zan");
		spellPut("173-130", "qiong");
		spellPut("173-131", "ti");
		spellPut("173-132", "gui");
		spellPut("173-133", "sui");
		spellPut("173-134", "la");
		spellPut("173-135", "long");
		spellPut("173-136", "lu");
		spellPut("173-137", "li");
		spellPut("173-138", "lan");
		spellPut("173-139", "ying");
		spellPut("173-140", "mi,xi");
		spellPut("173-141", "xiang");
		spellPut("173-142", "qiong,wei");
		spellPut("173-143", "guan");
		spellPut("173-144", "dao");
		spellPut("173-145", "zan");
		spellPut("173-146", "huan,ye,ya");
		spellPut("173-147", "bo");
		spellPut("173-148", "bo,pao");
		spellPut("173-149", "zhi,hu");
		spellPut("173-150", "li");
		spellPut("173-151", "shiwa");
		spellPut("173-152", "xiang,hong");
		spellPut("173-153", "qianwa");
		spellPut("173-154", "ban");
		spellPut("173-155", "pen");
		spellPut("173-156", "fang");
		spellPut("173-157", "dan");
		spellPut("173-158", "fenwa");
		spellPut("173-159", "maowa");
		spellPut("173-160", "ki ro ton,mao wa");
	}

	private static void init36() {
		spellPut("174-64", "hu");
		spellPut("174-65", "yi");
		spellPut("174-66", "bai wa");
		spellPut("174-67", "juan");
		spellPut("174-68", "chang");
		spellPut("174-69", "chi");
		spellPut("174-70", "liwa");
		spellPut("174-71", "dang");
		spellPut("174-72", "wa");
		spellPut("174-73", "zhui");
		spellPut("174-74", "ping");
		spellPut("174-75", "bian");
		spellPut("174-76", "zhou");
		spellPut("174-77", "li wB");
		spellPut("174-78", "ci");
		spellPut("174-79", "ying");
		spellPut("174-80", "qi");
		spellPut("174-81", "xian");
		spellPut("174-82", "lou");
		spellPut("174-83", "di");
		spellPut("174-84", "ou");
		spellPut("174-85", "zhuan");
		spellPut("174-86", "lin");
		spellPut("174-87", "wu");
		spellPut("174-88", "dan");
		spellPut("174-89", "weng");
		spellPut("174-90", "ying");
		spellPut("174-91", "yan");
		spellPut("174-92", "tian");
		spellPut("174-93", "han");
		spellPut("174-94", "chang");
		spellPut("174-95", "qing");
		spellPut("174-96", "shen");
		spellPut("174-97", "chan");
		spellPut("174-98", "chan");
		spellPut("174-99", "rui");
		spellPut("174-100", "su");
		spellPut("174-101", "shen");
		spellPut("174-102", "lu");
		spellPut("174-103", "beng");
		spellPut("174-104", "you");
		spellPut("174-105", "fu");
		spellPut("174-106", "ping");
		spellPut("174-107", "ting,ding");
		spellPut("174-108", "zhen");
		spellPut("174-109", "meng");
		spellPut("174-110", "bi,qi");
		spellPut("174-111", "mu");
		spellPut("174-112", "xun");
		spellPut("174-113", "liu");
		spellPut("174-114", "mu");
		spellPut("174-115", "yun");
		spellPut("174-116", "fu");
		spellPut("174-117", "geng");
		spellPut("174-118", "jie");
		spellPut("174-119", "fu,bi");
		spellPut("174-120", "tian");
		spellPut("174-121", "mu");
		spellPut("174-122", "da bo");
		spellPut("174-123", "jiang");
		spellPut("174-124", "wa");
		spellPut("174-125", "da,fu");
		spellPut("174-126", "nan");
		spellPut("174-128", "mu");
		spellPut("174-129", "mu");
		spellPut("174-130", "ce,ji");
		spellPut("174-131", "zai,zi");
		spellPut("174-132", "gai");
		spellPut("174-133", "bi");
		spellPut("174-134", "da");
		spellPut("174-135", "zhi,chou,shi");
		spellPut("174-136", "l<e");
		spellPut("174-137", "fan,pan");
		spellPut("174-138", "yi");
		spellPut("174-139", "hua");
		spellPut("174-140", "she,yu");
		spellPut("174-141", "she");
		spellPut("174-142", "mu");
		spellPut("174-143", "jun");
		spellPut("174-144", "yi");
		spellPut("174-145", "liu");
		spellPut("174-146", "die");
		spellPut("174-147", "hua");
		spellPut("174-148", "dang");
		spellPut("174-149", "zhui");
		spellPut("174-150", "jiang");
		spellPut("174-151", "cheng");
		spellPut("174-152", "chang");
		spellPut("174-153", "tuan");
		spellPut("174-154", "lei");
		spellPut("174-155", "cha");
		spellPut("174-156", "liu");
		spellPut("174-157", "die");
		spellPut("174-158", "lin");
		spellPut("174-159", "jiang");
		spellPut("174-160", "chou");
	}

	private static void init37() {
		spellPut("175-64", "pi");
		spellPut("175-65", "die");
		spellPut("175-66", "die");
		spellPut("175-67", "jie,qie");
		spellPut("175-68", "dan");
		spellPut("175-69", "shu");
		spellPut("175-70", "zhi,di");
		spellPut("175-71", "nai");
		spellPut("175-72", "bi");
		spellPut("175-73", "gang");
		spellPut("175-74", "zhou");
		spellPut("175-75", "xia");
		spellPut("175-76", "xu");
		spellPut("175-77", "chen");
		spellPut("175-78", "jue,xue");
		spellPut("175-79", "qi");
		spellPut("175-80", "ya,xia");
		spellPut("175-81", "cui");
		spellPut("175-82", "bi");
		spellPut("175-83", "zong");
		spellPut("175-84", "xue");
		spellPut("175-85", "zhi");
		spellPut("175-86", "fa,bian");
		spellPut("175-87", "zhi");
		spellPut("175-88", "fei");
		spellPut("175-89", "gou");
		spellPut("175-90", "shan,dian");
		spellPut("175-91", "nie");
		spellPut("175-92", "teng,chong");
		spellPut("175-93", "tong");
		spellPut("175-94", "jie");
		spellPut("175-95", "wei,you,yu");
		spellPut("175-96", "hui");
		spellPut("175-97", "tan,shi");
		spellPut("175-98", "zhi");
		spellPut("175-99", "mei");
		spellPut("175-100", "jing");
		spellPut("175-101", "xiao");
		spellPut("175-102", "tu");
		spellPut("175-103", "mang");
		spellPut("175-104", "xiao");
		spellPut("175-105", "suan");
		spellPut("175-106", "pu");
		spellPut("175-107", "duo");
		spellPut("175-108", "shou");
		spellPut("175-109", "yi");
		spellPut("175-110", "beng,peng");
		spellPut("175-111", "zhang");
		spellPut("175-112", "guan");
		spellPut("175-113", "ma");
		spellPut("175-114", "ma,lin");
		spellPut("175-115", "ji");
		spellPut("175-116", "tian,dian");
		spellPut("175-117", "an,ye,e");
		spellPut("175-118", "chi");
		spellPut("175-119", "bi");
		spellPut("175-120", "min");
		spellPut("175-121", "dui");
		spellPut("175-122", "ke,e");
		spellPut("175-123", "ya");
		spellPut("175-124", "cu");
		spellPut("175-125", "shen");
		spellPut("175-126", "zhong");
		spellPut("175-128", "zhi,chi");
		spellPut("175-129", "yu");
		spellPut("175-130", "feng");
		spellPut("175-131", "yang");
		spellPut("175-132", "chen");
		spellPut("175-133", "tu");
		spellPut("175-134", "guo");
		spellPut("175-135", "wen");
		spellPut("175-136", "huan");
		spellPut("175-137", "ku");
		spellPut("175-138", "yin");
		spellPut("175-139", "jue");
		spellPut("175-140", "xi");
		spellPut("175-141", "guan");
		spellPut("175-142", "yi");
		spellPut("175-143", "chuang");
		spellPut("175-144", "hui,lei");
		spellPut("175-145", "n<e,yao");
		spellPut("175-146", "dian,chen");
		spellPut("175-147", "zhang");
		spellPut("175-148", "shen");
		spellPut("175-149", "cu");
		spellPut("175-150", "yi");
		spellPut("175-151", "zong");
		spellPut("175-152", "sou");
		spellPut("175-153", "se");
		spellPut("175-154", "diao");
		spellPut("175-155", "lou");
		spellPut("175-156", "lou");
		spellPut("175-157", "qin");
		spellPut("175-158", "fu");
		spellPut("175-159", "liao");
		spellPut("175-160", "qiao,jiao");
	}

	private static void init38() {
		spellPut("176-64", "liu");
		spellPut("176-65", "lao");
		spellPut("176-66", "xian");
		spellPut("176-67", "fei");
		spellPut("176-68", "dan");
		spellPut("176-69", "yin");
		spellPut("176-70", "he");
		spellPut("176-71", "xian");
		spellPut("176-72", "guan");
		spellPut("176-73", "gui,wei");
		spellPut("176-74", "nong");
		spellPut("176-75", "yu");
		spellPut("176-76", "wei");
		spellPut("176-77", "yong");
		spellPut("176-78", "lei");
		spellPut("176-79", "li,lai");
		spellPut("176-80", "shu");
		spellPut("176-81", "dan");
		spellPut("176-82", "lin");
		spellPut("176-83", "lin");
		spellPut("176-84", "bie");
		spellPut("176-85", "ji");
		spellPut("176-86", "chi");
		spellPut("176-87", "yang");
		spellPut("176-88", "jie");
		spellPut("176-89", "zheng");
		spellPut("176-90", "mo");
		spellPut("176-91", "li");
		spellPut("176-92", "huo");
		spellPut("176-93", "lai");
		spellPut("176-94", "ji");
		spellPut("176-95", "xuan");
		spellPut("176-96", "ying");
		spellPut("176-97", "yin");
		spellPut("176-98", "yong");
		spellPut("176-99", "tan");
		spellPut("176-100", "dian");
		spellPut("176-101", "luo");
		spellPut("176-102", "luan");
		spellPut("176-103", "luan");
		spellPut("176-104", "bo");
		spellPut("176-105", "uu");
		spellPut("176-106", "ba");
		spellPut("176-107", "fa");
		spellPut("176-108", "fa");
		spellPut("176-109", "qie");
		spellPut("176-110", "ji,bi");
		spellPut("176-111", "zao");
		spellPut("176-112", "mao");
		spellPut("176-113", "pa,ba");
		spellPut("176-114", "ci");
		spellPut("176-115", "ling");
		spellPut("176-116", "mo");
		spellPut("176-117", "ji");
		spellPut("176-118", "peng");
		spellPut("176-119", "gao,yao");
		spellPut("176-120", "e");
		spellPut("176-121", "han");
		spellPut("176-122", "bi");
		spellPut("176-123", "chou");
		spellPut("176-124", "qian");
		spellPut("176-125", "ai");
		spellPut("176-126", "xiao");
		spellPut("176-128", "hao");
		spellPut("176-129", "huang");
		spellPut("176-130", "hao");
		spellPut("176-131", "ze");
		spellPut("176-132", "cui");
		spellPut("176-133", "hao");
		spellPut("176-134", "xiao");
		spellPut("176-135", "ye");
		spellPut("176-136", "hao");
		spellPut("176-137", "jiao");
		spellPut("176-138", "ai");
		spellPut("176-139", "xing");
		spellPut("176-140", "huang");
		spellPut("176-141", "li,luo,bo");
		spellPut("176-142", "piao");
		spellPut("176-143", "he");
		spellPut("176-144", "jiao");
		spellPut("176-145", "gan");
		spellPut("176-146", "pao");
		spellPut("176-147", "qiu");
		spellPut("176-148", "que");
		spellPut("176-149", "zha");
		spellPut("176-150", "gu");
		spellPut("176-151", "jun");
		spellPut("176-152", "jun");
		spellPut("176-153", "zhou");
		spellPut("176-154", "zha,cu");
		spellPut("176-155", "gu");
		spellPut("176-156", "zhao,zhan,dan");
		spellPut("176-157", "du");
		spellPut("176-158", "qi");
		spellPut("176-159", "ying");
		spellPut("176-160", "bei");
		spellPut("176-161", "a,B");
		spellPut("176-162", "a");
		spellPut("176-163", "ai");
		spellPut("176-164", "ai");
		spellPut("176-165", "ai");
		spellPut("176-166", "ai");
		spellPut("176-167", "ai");
		spellPut("176-168", "ai");
		spellPut("176-169", "ai");
		spellPut("176-170", "ai");
		spellPut("176-171", "ai");
		spellPut("176-172", "ai,yi");
		spellPut("176-173", "ai");
		spellPut("176-174", "ai");
		spellPut("176-175", "ai");
		spellPut("176-176", "an");
		spellPut("176-177", "an");
		spellPut("176-178", "an");
		spellPut("176-179", "an");
		spellPut("176-180", "an");
		spellPut("176-181", "an");
		spellPut("176-182", "an");
		spellPut("176-183", "an");
		spellPut("176-184", "an");
		spellPut("176-185", "ang");
		spellPut("176-186", "ang");
		spellPut("176-187", "ang");
		spellPut("176-188", "ao,wa");
		spellPut("176-189", "ao");
		spellPut("176-190", "ao");
		spellPut("176-191", "ao");
		spellPut("176-192", "ao");
		spellPut("176-193", "ao");
		spellPut("176-194", "ao,yu");
		spellPut("176-195", "ao");
		spellPut("176-196", "ao");
		spellPut("176-197", "ba");
		spellPut("176-198", "ba");
		spellPut("176-199", "ba,pa");
		spellPut("176-200", "ba");
		spellPut("176-201", "ba,bB");
		spellPut("176-202", "ba");
		spellPut("176-203", "ba");
		spellPut("176-204", "ba");
		spellPut("176-205", "ba");
		spellPut("176-206", "ba");
		spellPut("176-207", "ba");
		spellPut("176-208", "ba");
		spellPut("176-209", "ba");
		spellPut("176-210", "ba,pa");
		spellPut("176-211", "ba");
		spellPut("176-212", "ba");
		spellPut("176-213", "ba,bB,pi");
		spellPut("176-214", "ba");
		spellPut("176-215", "bai");
		spellPut("176-216", "bai,bo");
		spellPut("176-217", "bai");
		spellPut("176-218", "bai");
		spellPut("176-219", "bai");
		spellPut("176-220", "bai");
		spellPut("176-221", "bai");
		spellPut("176-222", "bai");
		spellPut("176-223", "ban");
		spellPut("176-224", "ban");
		spellPut("176-225", "ban");
		spellPut("176-226", "ban");
		spellPut("176-227", "ban");
		spellPut("176-228", "ban");
		spellPut("176-229", "ban");
		spellPut("176-230", "ban");
		spellPut("176-231", "ban");
		spellPut("176-232", "ban,pan");
		spellPut("176-233", "ban");
		spellPut("176-234", "ban");
		spellPut("176-235", "ban");
		spellPut("176-236", "ban");
		spellPut("176-237", "ban");
		spellPut("176-238", "bang");
		spellPut("176-239", "bang");
		spellPut("176-240", "bang");
		spellPut("176-241", "bang");
		spellPut("176-242", "bang");
		spellPut("176-243", "bang");
		spellPut("176-244", "bang");
		spellPut("176-245", "bang,pang");
		spellPut("176-246", "bang,beng");
		spellPut("176-247", "bang");
		spellPut("176-248", "bang");
		spellPut("176-249", "bang");
		spellPut("176-250", "bao");
		spellPut("176-251", "bao");
		spellPut("176-252", "bao");
		spellPut("176-253", "bao");
		spellPut("176-254", "bao,bo");
	}

	private static void init39() {
		spellPut("177-64", "diao");
		spellPut("177-65", "he");
		spellPut("177-66", "he");
		spellPut("177-67", "bo");
		spellPut("177-68", "wan");
		spellPut("177-69", "yu");
		spellPut("177-70", "fan");
		spellPut("177-71", "fu");
		spellPut("177-72", "qiu");
		spellPut("177-73", "dao");
		spellPut("177-74", "lu");
		spellPut("177-75", "zhan");
		spellPut("177-76", "li");
		spellPut("177-77", "jin");
		spellPut("177-78", "xu");
		spellPut("177-79", "jian");
		spellPut("177-80", "pan");
		spellPut("177-81", "an");
		spellPut("177-82", "lu");
		spellPut("177-83", "xu");
		spellPut("177-84", "zhou,chou");
		spellPut("177-85", "dang");
		spellPut("177-86", "an");
		spellPut("177-87", "gu");
		spellPut("177-88", "li");
		spellPut("177-89", "gan");
		spellPut("177-90", "mang,wang");
		spellPut("177-91", "qi");
		spellPut("177-92", "yuan");
		spellPut("177-93", "xian,tian");
		spellPut("177-94", "xin");
		spellPut("177-95", "xi,pan");
		spellPut("177-96", "feng");
		spellPut("177-97", "min");
		spellPut("177-98", "ming");
		spellPut("177-99", "shi");
		spellPut("177-100", "yun,hun");
		spellPut("177-101", "pan");
		spellPut("177-102", "fang");
		spellPut("177-103", "mao");
		spellPut("177-104", "xian");
		spellPut("177-105", "shi");
		spellPut("177-106", "yang,ying");
		spellPut("177-107", "zheng");
		spellPut("177-108", "yao,ao");
		spellPut("177-109", "shen");
		spellPut("177-110", "huo");
		spellPut("177-111", "da");
		spellPut("177-112", "zhen");
		spellPut("177-113", "kuang");
		spellPut("177-114", "ju,xu,kou");
		spellPut("177-115", "shen");
		spellPut("177-116", "mei");
		spellPut("177-117", "mo,mie");
		spellPut("177-118", "zhu");
		spellPut("177-119", "zhen");
		spellPut("177-120", "shi");
		spellPut("177-121", "die,ti");
		spellPut("177-122", "ni");
		spellPut("177-123", "zi");
		spellPut("177-124", "chao");
		spellPut("177-125", "bing,fang");
		spellPut("177-126", "pang,pan");
		spellPut("177-128", "long");
		spellPut("177-129", "tong");
		spellPut("177-130", "die,zhi");
		spellPut("177-131", "di");
		spellPut("177-132", "ne");
		spellPut("177-133", "ming");
		spellPut("177-134", "xuan,shun,xun");
		spellPut("177-135", "zhen");
		spellPut("177-136", "yang");
		spellPut("177-137", "mo");
		spellPut("177-138", "zhong");
		spellPut("177-139", "mo");
		spellPut("177-140", "mei");
		spellPut("177-141", "qiao,shao,xiao");
		spellPut("177-142", "han");
		spellPut("177-143", "huan");
		spellPut("177-144", "cheng");
		spellPut("177-145", "cuo,zhuai");
		spellPut("177-146", "juan");
		spellPut("177-147", "e");
		spellPut("177-148", "mian");
		spellPut("177-149", "xian");
		spellPut("177-150", "xi");
		spellPut("177-151", "kun");
		spellPut("177-152", "shan");
		spellPut("177-153", "tian");
		spellPut("177-154", "gun");
		spellPut("177-155", "wan");
		spellPut("177-156", "leng");
		spellPut("177-157", "shi");
		spellPut("177-158", "qiong");
		spellPut("177-159", "li");
		spellPut("177-160", "zheng");
		spellPut("177-161", "bao,bo");
		spellPut("177-162", "bao");
		spellPut("177-163", "bao");
		spellPut("177-164", "bao,bu,pu");
		spellPut("177-165", "bao");
		spellPut("177-166", "bao");
		spellPut("177-167", "bao");
		spellPut("177-168", "bao");
		spellPut("177-169", "bao,pu");
		spellPut("177-170", "bao");
		spellPut("177-171", "bao");
		spellPut("177-172", "bao");
		spellPut("177-173", "bei");
		spellPut("177-174", "bei");
		spellPut("177-175", "bei");
		spellPut("177-176", "bei");
		spellPut("177-177", "bei");
		spellPut("177-178", "bei");
		spellPut("177-179", "bei");
		spellPut("177-180", "bei");
		spellPut("177-181", "bei");
		spellPut("177-182", "bei");
		spellPut("177-183", "bei");
		spellPut("177-184", "bei");
		spellPut("177-185", "bei");
		spellPut("177-186", "bei");
		spellPut("177-187", "bei,pi");
		spellPut("177-188", "ben");
		spellPut("177-189", "ben");
		spellPut("177-190", "ben");
		spellPut("177-191", "ben");
		spellPut("177-192", "beng");
		spellPut("177-193", "beng");
		spellPut("177-194", "beng");
		spellPut("177-195", "beng");
		spellPut("177-196", "beng");
		spellPut("177-197", "beng");
		spellPut("177-198", "bi");
		spellPut("177-199", "bi");
		spellPut("177-200", "bi");
		spellPut("177-201", "bi");
		spellPut("177-202", "bi");
		spellPut("177-203", "bi");
		spellPut("177-204", "bi");
		spellPut("177-205", "bi");
		spellPut("177-206", "bi");
		spellPut("177-207", "bi");
		spellPut("177-208", "bi");
		spellPut("177-209", "bi");
		spellPut("177-210", "bi");
		spellPut("177-211", "bi");
		spellPut("177-212", "bi");
		spellPut("177-213", "bi");
		spellPut("177-214", "bi");
		spellPut("177-215", "bi");
		spellPut("177-216", "bi");
		spellPut("177-217", "bi,pi");
		spellPut("177-218", "bi");
		spellPut("177-219", "bi,bei");
		spellPut("177-220", "bi");
		spellPut("177-221", "bi");
		spellPut("177-222", "bian");
		spellPut("177-223", "bian");
		spellPut("177-224", "bian");
		spellPut("177-225", "bian");
		spellPut("177-226", "bian,pian");
		spellPut("177-227", "bian,pian");
		spellPut("177-228", "bian");
		spellPut("177-229", "bian");
		spellPut("177-230", "bian");
		spellPut("177-231", "bian");
		spellPut("177-232", "bian");
		spellPut("177-233", "bian");
		spellPut("177-234", "biao");
		spellPut("177-235", "biao");
		spellPut("177-236", "biao");
		spellPut("177-237", "biao");
		spellPut("177-238", "bie");
		spellPut("177-239", "bie");
		spellPut("177-240", "bie");
		spellPut("177-241", "bie");
		spellPut("177-242", "bin");
		spellPut("177-243", "bin");
		spellPut("177-244", "bin");
		spellPut("177-245", "bin");
		spellPut("177-246", "bin");
		spellPut("177-247", "bin");
		spellPut("177-248", "bing");
		spellPut("177-249", "bing");
		spellPut("177-250", "bing");
		spellPut("177-251", "bing");
		spellPut("177-252", "bing");
		spellPut("177-253", "bing");
		spellPut("177-254", "bing");
	}

	private static void init40() {
		spellPut("178-64", "li");
		spellPut("178-65", "lai");
		spellPut("178-66", "sui,zui");
		spellPut("178-67", "juan");
		spellPut("178-68", "bi");
		spellPut("178-69", "hun");
		spellPut("178-70", "lu");
		spellPut("178-71", "yi,ze,gao");
		spellPut("178-72", "zhou");
		spellPut("178-73", "yu");
		spellPut("178-74", "hun");
		spellPut("178-75", "ma");
		spellPut("178-76", "xia");
		spellPut("178-77", "xing");
		spellPut("178-78", "hui");
		spellPut("178-79", "hun");
		spellPut("178-80", "zai");
		spellPut("178-81", "chun");
		spellPut("178-82", "jian");
		spellPut("178-83", "mei");
		spellPut("178-84", "hou");
		spellPut("178-85", "xuan");
		spellPut("178-86", "ti");
		spellPut("178-87", "xu");
		spellPut("178-88", "fa");
		spellPut("178-89", "wo");
		spellPut("178-90", "gui,wei,kui");
		spellPut("178-91", "mi");
		spellPut("178-92", "weng");
		spellPut("178-93", "kou,ji");
		spellPut("178-94", "dang");
		spellPut("178-95", "chen");
		spellPut("178-96", "qiong,huan");
		spellPut("178-97", "mo");
		spellPut("178-98", "fen");
		spellPut("178-99", "ze");
		spellPut("178-100", "zhang");
		spellPut("178-101", "yi");
		spellPut("178-102", "diao,dou");
		spellPut("178-103", "kou");
		spellPut("178-104", "mo");
		spellPut("178-105", "shun");
		spellPut("178-106", "cong");
		spellPut("178-107", "lou,lv");
		spellPut("178-108", "chi");
		spellPut("178-109", "man,men");
		spellPut("178-110", "gui");
		spellPut("178-111", "wan");
		spellPut("178-112", "run,shun");
		spellPut("178-113", "xi");
		spellPut("178-114", "pu");
		spellPut("178-115", "shen");
		spellPut("178-116", "liao");
		spellPut("178-117", "che");
		spellPut("178-118", "xian,jian");
		spellPut("178-119", "ye");
		spellPut("178-120", "xue");
		spellPut("178-121", "wu,mi");
		spellPut("178-122", "gui,kui");
		spellPut("178-123", "jian");
		spellPut("178-124", "ye");
		spellPut("178-125", "ai");
		spellPut("178-126", "hui");
		spellPut("178-128", "jian");
		spellPut("178-129", "zhao");
		spellPut("178-130", "wei");
		spellPut("178-131", "chou");
		spellPut("178-132", "sao");
		spellPut("178-133", "ning,cheng");
		spellPut("178-134", "xun");
		spellPut("178-135", "yao");
		spellPut("178-136", "huo,yue");
		spellPut("178-137", "meng");
		spellPut("178-138", "mian");
		spellPut("178-139", "pin");
		spellPut("178-140", "mian");
		spellPut("178-141", "lei");
		spellPut("178-142", "kuang,guo");
		spellPut("178-143", "xuan");
		spellPut("178-144", "mian");
		spellPut("178-145", "huo");
		spellPut("178-146", "lu");
		spellPut("178-147", "meng");
		spellPut("178-148", "long");
		spellPut("178-149", "guan,quan");
		spellPut("178-150", "man");
		spellPut("178-151", "xi");
		spellPut("178-152", "tang");
		spellPut("178-153", "kan");
		spellPut("178-154", "zhu");
		spellPut("178-155", "jin,qin,guan");
		spellPut("178-156", "yu,xu,jue");
		spellPut("178-157", "shuo");
		spellPut("178-158", "ze");
		spellPut("178-159", "jue");
		spellPut("178-160", "shen");
		spellPut("178-161", "bing");
		spellPut("178-162", "bing");
		spellPut("178-163", "bo");
		spellPut("178-164", "bo");
		spellPut("178-165", "bo");
		spellPut("178-166", "bo");
		spellPut("178-167", "bo");
		spellPut("178-168", "bo");
		spellPut("178-169", "bo");
		spellPut("178-170", "bo,bei");
		spellPut("178-171", "bo");
		spellPut("178-172", "bo");
		spellPut("178-173", "bo");
		spellPut("178-174", "bo,bai,ba");
		spellPut("178-175", "bo");
		spellPut("178-176", "bo");
		spellPut("178-177", "bo");
		spellPut("178-178", "bo");
		spellPut("178-179", "bo");
		spellPut("178-180", "bo,po");
		spellPut("178-181", "bo");
		spellPut("178-182", "bu");
		spellPut("178-183", "bu,bo");
		spellPut("178-184", "bu");
		spellPut("178-185", "bu");
		spellPut("178-186", "bu");
		spellPut("178-187", "bu,fou");
		spellPut("178-188", "bu");
		spellPut("178-189", "bu");
		spellPut("178-190", "bu,bo");
		spellPut("178-191", "bu");
		spellPut("178-192", "bu");
		spellPut("178-193", "ca");
		spellPut("178-194", "cai");
		spellPut("178-195", "cai");
		spellPut("178-196", "cai");
		spellPut("178-197", "cai");
		spellPut("178-198", "cai");
		spellPut("178-199", "cai");
		spellPut("178-200", "cai");
		spellPut("178-201", "cai");
		spellPut("178-202", "cai");
		spellPut("178-203", "cai");
		spellPut("178-204", "cai");
		spellPut("178-205", "can");
		spellPut("178-206", "can,shen,cen,san");
		spellPut("178-207", "can");
		spellPut("178-208", "can");
		spellPut("178-209", "can");
		spellPut("178-210", "can");
		spellPut("178-211", "can");
		spellPut("178-212", "cang");
		spellPut("178-213", "cang");
		spellPut("178-214", "cang");
		spellPut("178-215", "cang");
		spellPut("178-216", "cang,zang");
		spellPut("178-217", "cao");
		spellPut("178-218", "cao");
		spellPut("178-219", "cao");
		spellPut("178-220", "cao");
		spellPut("178-221", "cao");
		spellPut("178-222", "ce");
		spellPut("178-223", "ce");
		spellPut("178-224", "ce,ze,zhai");
		spellPut("178-225", "ce");
		spellPut("178-226", "ce");
		spellPut("178-227", "ceng");
		spellPut("178-228", "ceng");
		spellPut("178-229", "cha");
		spellPut("178-230", "cha");
		spellPut("178-231", "cha");
		spellPut("178-232", "cha");
		spellPut("178-233", "cha,zha");
		spellPut("178-234", "cha");
		spellPut("178-235", "cha");
		spellPut("178-236", "cha");
		spellPut("178-237", "cha");
		spellPut("178-238", "cha,chai,ci");
		spellPut("178-239", "cha");
		spellPut("178-240", "chai,ca");
		spellPut("178-241", "chai");
		spellPut("178-242", "chai");
		spellPut("178-243", "chan");
		spellPut("178-244", "chan,xian,can,shan");
		spellPut("178-245", "chan");
		spellPut("178-246", "chan");
		spellPut("178-247", "chan");
		spellPut("178-248", "chan");
		spellPut("178-249", "chan");
		spellPut("178-250", "chan");
		spellPut("178-251", "chan");
		spellPut("178-252", "chan,zhan");
		spellPut("178-253", "chang");
		spellPut("178-254", "chang");
	}

	private static void init41() {
		spellPut("179-64", "hou");
		spellPut("179-65", "ying");
		spellPut("179-66", "zhou");
		spellPut("179-67", "jiao");
		spellPut("179-68", "zeng");
		spellPut("179-69", "yue");
		spellPut("179-70", "ba");
		spellPut("179-71", "ding");
		spellPut("179-72", "qi");
		spellPut("179-73", "zi");
		spellPut("179-74", "wu");
		spellPut("179-75", "zhe");
		spellPut("179-76", "ku");
		spellPut("179-77", "gang,qiang,kong");
		spellPut("179-78", "dan");
		spellPut("179-79", "jue");
		spellPut("179-80", "li");
		spellPut("179-81", "fu");
		spellPut("179-82", "min");
		spellPut("179-83", "e");
		spellPut("179-84", "kang");
		spellPut("179-85", "zhi");
		spellPut("179-86", "jie");
		spellPut("179-87", "pin,bin,fen");
		spellPut("179-88", "e");
		spellPut("179-89", "zhe");
		spellPut("179-90", "sui");
		spellPut("179-91", "wa");
		spellPut("179-92", "jin");
		spellPut("179-93", "mo");
		spellPut("179-94", "ju");
		spellPut("179-95", "yu");
		spellPut("179-96", "ke,luo");
		spellPut("179-97", "tuo");
		spellPut("179-98", "e");
		spellPut("179-99", "mu");
		spellPut("179-100", "zhu");
		spellPut("179-101", "nu");
		spellPut("179-102", "ping");
		spellPut("179-103", "ling");
		spellPut("179-104", "pao");
		spellPut("179-105", "le");
		spellPut("179-106", "bo");
		spellPut("179-107", "po");
		spellPut("179-108", "yong");
		spellPut("179-109", "kuang");
		spellPut("179-110", "keng");
		spellPut("179-111", "quan");
		spellPut("179-112", "zhu");
		spellPut("179-113", "kuang,guang");
		spellPut("179-114", "e");
		spellPut("179-115", "qia");
		spellPut("179-116", "lu");
		spellPut("179-117", "wei,gui");
		spellPut("179-118", "ai");
		spellPut("179-119", "ken,xian,gun,yin");
		spellPut("179-120", "yan");
		spellPut("179-121", "peng,ping");
		spellPut("179-122", "lBo");
		spellPut("179-123", "hong");
		spellPut("179-124", "qing");
		spellPut("179-125", "wei,ai,gai");
		spellPut("179-126", "qiao");
		spellPut("179-128", "ce o ke");
		spellPut("179-129", "keng");
		spellPut("179-130", "que,ke,ku");
		spellPut("179-131", "chan");
		spellPut("179-132", "lang");
		spellPut("179-133", "hong");
		spellPut("179-134", "yu");
		spellPut("179-135", "xiao");
		spellPut("179-136", "xia");
		spellPut("179-137", "mang,bang");
		spellPut("179-138", "luo,long");
		spellPut("179-139", "yong,tong");
		spellPut("179-140", "che");
		spellPut("179-141", "che");
		spellPut("179-142", "yan");
		spellPut("179-143", "sha");
		spellPut("179-144", "kun");
		spellPut("179-145", "yu");
		spellPut("179-146", "ze xi");
		spellPut("179-147", "huB");
		spellPut("179-148", "lu");
		spellPut("179-149", "chen");
		spellPut("179-150", "n<e");
		spellPut("179-151", "song");
		spellPut("179-152", "zhuo");
		spellPut("179-153", "keng");
		spellPut("179-154", "yan");
		spellPut("179-155", "zhui,chui,duo");
		spellPut("179-156", "kong");
		spellPut("179-157", "cheng");
		spellPut("179-158", "qi");
		spellPut("179-159", "zong,cong");
		spellPut("179-160", "qing");
		spellPut("179-161", "chang");
		spellPut("179-162", "chang");
		spellPut("179-163", "chang");
		spellPut("179-164", "chang");
		spellPut("179-165", "chang");
		spellPut("179-166", "chang");
		spellPut("179-167", "chang,an,han");
		spellPut("179-168", "chang");
		spellPut("179-169", "chang");
		spellPut("179-170", "chang");
		spellPut("179-171", "chang");
		spellPut("179-172", "chao");
		spellPut("179-173", "chao");
		spellPut("179-174", "chao");
		spellPut("179-175", "zhao,chao");
		spellPut("179-176", "chao,zhao");
		spellPut("179-177", "chao");
		spellPut("179-178", "chao");
		spellPut("179-179", "chao");
		spellPut("179-180", "chao");
		spellPut("179-181", "che");
		spellPut("179-182", "che");
		spellPut("179-183", "che");
		spellPut("179-184", "che");
		spellPut("179-185", "che");
		spellPut("179-186", "che");
		spellPut("179-187", "chen");
		spellPut("179-188", "chen");
		spellPut("179-189", "chen");
		spellPut("179-190", "chen");
		spellPut("179-191", "chen");
		spellPut("179-192", "chen");
		spellPut("179-193", "chen");
		spellPut("179-194", "chen");
		spellPut("179-195", "chen");
		spellPut("179-196", "chen");
		spellPut("179-197", "cheng");
		spellPut("179-198", "cheng,chen");
		spellPut("179-199", "cheng");
		spellPut("179-200", "cheng");
		spellPut("179-201", "cheng");
		spellPut("179-202", "cheng");
		spellPut("179-203", "cheng,sheng");
		spellPut("179-204", "cheng");
		spellPut("179-205", "cheng");
		spellPut("179-206", "cheng,deng");
		spellPut("179-207", "cheng");
		spellPut("179-208", "cheng");
		spellPut("179-209", "cheng");
		spellPut("179-210", "cheng");
		spellPut("179-211", "cheng");
		spellPut("179-212", "chi");
		spellPut("179-213", "chi");
		spellPut("179-214", "chi");
		spellPut("179-215", "chi,shi");
		spellPut("179-216", "chi");
		spellPut("179-217", "chi");
		spellPut("179-218", "chi");
		spellPut("179-219", "chi");
		spellPut("179-220", "chi");
		spellPut("179-221", "chi");
		spellPut("179-222", "chi");
		spellPut("179-223", "chi,che");
		spellPut("179-224", "chi");
		spellPut("179-225", "chi");
		spellPut("179-226", "chi");
		spellPut("179-227", "chi");
		spellPut("179-228", "chong");
		spellPut("179-229", "chong");
		spellPut("179-230", "chong");
		spellPut("179-231", "chong");
		spellPut("179-232", "chong");
		spellPut("179-233", "chou");
		spellPut("179-234", "chou");
		spellPut("179-235", "chou");
		spellPut("179-236", "chou");
		spellPut("179-237", "chou");
		spellPut("179-238", "chou");
		spellPut("179-239", "chou");
		spellPut("179-240", "chou,qiu");
		spellPut("179-241", "chou");
		spellPut("179-242", "chou");
		spellPut("179-243", "chou");
		spellPut("179-244", "chou,xiu");
		spellPut("179-245", "chu");
		spellPut("179-246", "chu");
		spellPut("179-247", "chu");
		spellPut("179-248", "chu");
		spellPut("179-249", "chu");
		spellPut("179-250", "chu");
		spellPut("179-251", "chu");
		spellPut("179-252", "chu");
		spellPut("179-253", "chu");
		spellPut("179-254", "chu");
	}

	private static void init42() {
		spellPut("180-64", "lin");
		spellPut("180-65", "jun");
		spellPut("180-66", "bo");
		spellPut("180-67", "min");
		spellPut("180-68", "jian,zhan");
		spellPut("180-69", "he");
		spellPut("180-70", "que,xi");
		spellPut("180-71", "leng");
		spellPut("180-72", "yin");
		spellPut("180-73", "wu");
		spellPut("180-74", "qi");
		spellPut("180-75", "lun");
		spellPut("180-76", "nao,gang");
		spellPut("180-77", "ruan");
		spellPut("180-78", "yan");
		spellPut("180-79", "ding");
		spellPut("180-80", "tuo");
		spellPut("180-81", "ying");
		spellPut("180-82", "ke");
		spellPut("180-83", "wei");
		spellPut("180-84", "shuo,shi");
		spellPut("180-85", "zhen");
		spellPut("180-86", "duan");
		spellPut("180-87", "xia");
		spellPut("180-88", "dang");
		spellPut("180-89", "ti,di");
		spellPut("180-90", "nao");
		spellPut("180-91", "tian");
		spellPut("180-92", "qi");
		spellPut("180-93", "dun");
		spellPut("180-94", "feng");
		spellPut("180-95", "que");
		spellPut("180-96", "que,qiao");
		spellPut("180-97", "ma");
		spellPut("180-98", "gong");
		spellPut("180-99", "su,xie");
		spellPut("180-100", "e");
		spellPut("180-101", "liu");
		spellPut("180-102", "si,ti");
		spellPut("180-103", "tang");
		spellPut("180-104", "hua,ke,gu");
		spellPut("180-105", "pi");
		spellPut("180-106", "kui,wei");
		spellPut("180-107", "tian");
		spellPut("180-108", "xia,qia,ya");
		spellPut("180-109", "xi");
		spellPut("180-110", "lian,qian");
		spellPut("180-111", "wei,ai,gai");
		spellPut("180-112", "yun");
		spellPut("180-113", "dui");
		spellPut("180-114", "la");
		spellPut("180-115", "zhuan");
		spellPut("180-116", "yao");
		spellPut("180-117", "zhuan");
		spellPut("180-118", "chan");
		spellPut("180-119", "qi");
		spellPut("180-120", "ao,qiao");
		spellPut("180-121", "peng");
		spellPut("180-122", "liu");
		spellPut("180-123", "lu");
		spellPut("180-124", "kan");
		spellPut("180-125", "chuang");
		spellPut("180-126", "chen");
		spellPut("180-128", "yin");
		spellPut("180-129", "lei");
		spellPut("180-130", "biao");
		spellPut("180-131", "qi");
		spellPut("180-132", "qi,zhu");
		spellPut("180-133", "cui");
		spellPut("180-134", "zong");
		spellPut("180-135", "chuo");
		spellPut("180-136", "lun");
		spellPut("180-137", "ji");
		spellPut("180-138", "shan");
		spellPut("180-139", "lao,luo");
		spellPut("180-140", "zeng");
		spellPut("180-141", "jian");
		spellPut("180-142", "xi");
		spellPut("180-143", "ding");
		spellPut("180-144", "dian");
		spellPut("180-145", "pan,bo");
		spellPut("180-146", "ji,she");
		spellPut("180-147", "qiao");
		spellPut("180-148", "di");
		spellPut("180-149", "li");
		spellPut("180-150", "jian");
		spellPut("180-151", "xi");
		spellPut("180-152", "zhang");
		spellPut("180-153", "qiao");
		spellPut("180-154", "jian");
		spellPut("180-155", "yu");
		spellPut("180-156", "zhui");
		spellPut("180-157", "he,qiao");
		spellPut("180-158", "ke,huo");
		spellPut("180-159", "ze");
		spellPut("180-160", "lei");
		spellPut("180-161", "chu");
		spellPut("180-162", "chu");
		spellPut("180-163", "chu");
		spellPut("180-164", "chu");
		spellPut("180-165", "chu");
		spellPut("180-166", "chu");
		spellPut("180-167", "chuai,tuan,zhui");
		spellPut("180-168", "chuan");
		spellPut("180-169", "chuan");
		spellPut("180-170", "chuan");
		spellPut("180-171", "chuan,zhuan");
		spellPut("180-172", "chuan");
		spellPut("180-173", "chuan");
		spellPut("180-174", "chuan");
		spellPut("180-175", "chuang");
		spellPut("180-176", "chuang");
		spellPut("180-177", "chuang,zhuang");
		spellPut("180-178", "chuang");
		spellPut("180-179", "chuang");
		spellPut("180-180", "chuang");
		spellPut("180-181", "chui");
		spellPut("180-182", "chui");
		spellPut("180-183", "chui");
		spellPut("180-184", "chui");
		spellPut("180-185", "chui");
		spellPut("180-186", "chun");
		spellPut("180-187", "chun");
		spellPut("180-188", "chun");
		spellPut("180-189", "chun");
		spellPut("180-190", "chun,zhun");
		spellPut("180-191", "chun");
		spellPut("180-192", "chun");
		spellPut("180-193", "chuo");
		spellPut("180-194", "chuo,chao");
		spellPut("180-195", "ci");
		spellPut("180-196", "ci");
		spellPut("180-197", "ci");
		spellPut("180-198", "ci");
		spellPut("180-199", "ci");
		spellPut("180-200", "ci");
		spellPut("180-201", "ci");
		spellPut("180-202", "ci");
		spellPut("180-203", "ci");
		spellPut("180-204", "ci");
		spellPut("180-205", "ci");
		spellPut("180-206", "ci");
		spellPut("180-207", "cong");
		spellPut("180-208", "cong");
		spellPut("180-209", "cong");
		spellPut("180-210", "cong");
		spellPut("180-211", "cong,zong");
		spellPut("180-212", "cong");
		spellPut("180-213", "cou");
		spellPut("180-214", "cu");
		spellPut("180-215", "cu");
		spellPut("180-216", "cu");
		spellPut("180-217", "cu");
		spellPut("180-218", "cuan");
		spellPut("180-219", "cuan");
		spellPut("180-220", "cuan");
		spellPut("180-221", "cui");
		spellPut("180-222", "cui");
		spellPut("180-223", "cui");
		spellPut("180-224", "cui");
		spellPut("180-225", "cui");
		spellPut("180-226", "cui");
		spellPut("180-227", "cui");
		spellPut("180-228", "cui");
		spellPut("180-229", "cun");
		spellPut("180-230", "cun");
		spellPut("180-231", "cun");
		spellPut("180-232", "cuo");
		spellPut("180-233", "cuo,zuo");
		spellPut("180-234", "cuo");
		spellPut("180-235", "cuo");
		spellPut("180-236", "cuo");
		spellPut("180-237", "cuo");
		spellPut("180-238", "da");
		spellPut("180-239", "da");
		spellPut("180-240", "da");
		spellPut("180-241", "da,dB");
		spellPut("180-242", "da");
		spellPut("180-243", "da,dai,tai");
		spellPut("180-244", "dai");
		spellPut("180-245", "dai");
		spellPut("180-246", "dai");
		spellPut("180-247", "dai");
		spellPut("180-248", "dai");
		spellPut("180-249", "dai");
		spellPut("180-250", "dai");
		spellPut("180-251", "dai");
		spellPut("180-252", "dai");
		spellPut("180-253", "dai");
		spellPut("180-254", "dai");
	}

	private static void init43() {
		spellPut("181-64", "jie");
		spellPut("181-65", "chu");
		spellPut("181-66", "ye");
		spellPut("181-67", "que,hu");
		spellPut("181-68", "dang");
		spellPut("181-69", "yi");
		spellPut("181-70", "pi");
		spellPut("181-71", "pi");
		spellPut("181-72", "yu");
		spellPut("181-73", "pin");
		spellPut("181-74", "e,qi");
		spellPut("181-75", "ai");
		spellPut("181-76", "ke");
		spellPut("181-77", "jian");
		spellPut("181-78", "yu");
		spellPut("181-79", "ruan");
		spellPut("181-80", "pao");
		spellPut("181-81", "ci");
		spellPut("181-82", "bo");
		spellPut("181-83", "yBng");
		spellPut("181-84", "mie");
		spellPut("181-85", "xian,xin");
		spellPut("181-86", "kuang");
		spellPut("181-87", "lei");
		spellPut("181-88", "lei");
		spellPut("181-89", "zhi");
		spellPut("181-90", "li");
		spellPut("181-91", "li");
		spellPut("181-92", "fan");
		spellPut("181-93", "que");
		spellPut("181-94", "pao");
		spellPut("181-95", "ying");
		spellPut("181-96", "li");
		spellPut("181-97", "long");
		spellPut("181-98", "long");
		spellPut("181-99", "mo");
		spellPut("181-100", "shuang");
		spellPut("181-101", "guan");
		spellPut("181-102", "jian");
		spellPut("181-103", "ca");
		spellPut("181-104", "yan");
		spellPut("181-105", "reng");
		spellPut("181-106", "yue");
		spellPut("181-107", "ta");
		spellPut("181-108", "ma");
		spellPut("181-109", "xie");
		spellPut("181-110", "yao");
		spellPut("181-111", "zhi,qi");
		spellPut("181-112", "beng,fang");
		spellPut("181-113", "dui");
		spellPut("181-114", "zhong");
		spellPut("181-115", "ren");
		spellPut("181-116", "yi");
		spellPut("181-117", "shi");
		spellPut("181-118", "you");
		spellPut("181-119", "zhi");
		spellPut("181-120", "tiao");
		spellPut("181-121", "fu");
		spellPut("181-122", "mi,bi");
		spellPut("181-123", "suan");
		spellPut("181-124", "mei");
		spellPut("181-125", "chai");
		spellPut("181-126", "lv");
		spellPut("181-128", "yu");
		spellPut("181-129", "wu");
		spellPut("181-130", "zhu");
		spellPut("181-131", "gui");
		spellPut("181-132", "xia");
		spellPut("181-133", "zhi");
		spellPut("181-134", "gao");
		spellPut("181-135", "gao");
		spellPut("181-136", "shui,lei");
		spellPut("181-137", "jin");
		spellPut("181-138", "shen");
		spellPut("181-139", "gai");
		spellPut("181-140", "kun");
		spellPut("181-141", "di");
		spellPut("181-142", "tao");
		spellPut("181-143", "gu");
		spellPut("181-144", "guan");
		spellPut("181-145", "zui");
		spellPut("181-146", "ling");
		spellPut("181-147", "lu");
		spellPut("181-148", "dao");
		spellPut("181-149", "zhi");
		spellPut("181-150", "bi,pi");
		spellPut("181-151", "chu");
		spellPut("181-152", "hui");
		spellPut("181-153", "you,chao");
		spellPut("181-154", "yin");
		spellPut("181-155", "zi");
		spellPut("181-156", "huo");
		spellPut("181-157", "zhen");
		spellPut("181-158", "yuan");
		spellPut("181-159", "xu");
		spellPut("181-160", "xian");
		spellPut("181-161", "dai");
		spellPut("181-162", "dan");
		spellPut("181-163", "dan");
		spellPut("181-164", "dan");
		spellPut("181-165", "dan,shan,chan");
		spellPut("181-166", "dan");
		spellPut("181-167", "dan,shan");
		spellPut("181-168", "dan");
		spellPut("181-169", "dan");
		spellPut("181-170", "dan");
		spellPut("181-171", "dan");
		spellPut("181-172", "dan,da");
		spellPut("181-173", "dan");
		spellPut("181-174", "dan");
		spellPut("181-175", "dan,tan");
		spellPut("181-176", "dan");
		spellPut("181-177", "dang");
		spellPut("181-178", "dang");
		spellPut("181-179", "dang");
		spellPut("181-180", "dang");
		spellPut("181-181", "dang");
		spellPut("181-182", "dao");
		spellPut("181-183", "dao");
		spellPut("181-184", "dao");
		spellPut("181-185", "dao");
		spellPut("181-186", "dao");
		spellPut("181-187", "dao");
		spellPut("181-188", "dao");
		spellPut("181-189", "dao");
		spellPut("181-190", "dao");
		spellPut("181-191", "dao");
		spellPut("181-192", "dao");
		spellPut("181-193", "dao");
		spellPut("181-194", "de");
		spellPut("181-195", "de,dei");
		spellPut("181-196", "di,de");
		spellPut("181-197", "deng");
		spellPut("181-198", "deng");
		spellPut("181-199", "deng");
		spellPut("181-200", "deng");
		spellPut("181-201", "deng");
		spellPut("181-202", "deng");
		spellPut("181-203", "deng");
		spellPut("181-204", "di");
		spellPut("181-205", "di");
		spellPut("181-206", "di");
		spellPut("181-207", "di");
		spellPut("181-208", "di");
		spellPut("181-209", "di");
		spellPut("181-210", "di");
		spellPut("181-211", "di");
		spellPut("181-212", "di,zhai");
		spellPut("181-213", "di");
		spellPut("181-214", "di");
		spellPut("181-215", "di,de");
		spellPut("181-216", "di,de");
		spellPut("181-217", "di");
		spellPut("181-218", "di");
		spellPut("181-219", "di");
		spellPut("181-220", "di,ti,tui");
		spellPut("181-221", "di");
		spellPut("181-222", "di");
		spellPut("181-223", "dian");
		spellPut("181-224", "dian");
		spellPut("181-225", "dian");
		spellPut("181-226", "dian");
		spellPut("181-227", "dian");
		spellPut("181-228", "dian");
		spellPut("181-229", "dian");
		spellPut("181-230", "dian");
		spellPut("181-231", "dian");
		spellPut("181-232", "dian,tian");
		spellPut("181-233", "dian,tian,sheng");
		spellPut("181-234", "dian");
		spellPut("181-235", "dian");
		spellPut("181-236", "dian");
		spellPut("181-237", "dian");
		spellPut("181-238", "dian");
		spellPut("181-239", "diao");
		spellPut("181-240", "diao");
		spellPut("181-241", "diao");
		spellPut("181-242", "diao");
		spellPut("181-243", "diao");
		spellPut("181-244", "diao");
		spellPut("181-245", "diao");
		spellPut("181-246", "diao");
		spellPut("181-247", "diao");
		spellPut("181-248", "die");
		spellPut("181-249", "die");
		spellPut("181-250", "die");
		spellPut("181-251", "die");
		spellPut("181-252", "die");
		spellPut("181-253", "die");
		spellPut("181-254", "die");
	}

	private static void init44() {
		spellPut("182-64", "shang,yang");
		spellPut("182-65", "ti,zhi");
		spellPut("182-66", "yi");
		spellPut("182-67", "mei");
		spellPut("182-68", "si");
		spellPut("182-69", "di");
		spellPut("182-70", "bei");
		spellPut("182-71", "zhen");
		spellPut("182-72", "ying");
		spellPut("182-73", "ji");
		spellPut("182-74", "gao");
		spellPut("182-75", "tang");
		spellPut("182-76", "si");
		spellPut("182-77", "ma");
		spellPut("182-78", "ta");
		spellPut("182-79", "fu");
		spellPut("182-80", "xuan");
		spellPut("182-81", "qi");
		spellPut("182-82", "yu");
		spellPut("182-83", "ji");
		spellPut("182-84", "si");
		spellPut("182-85", "shan,chan");
		spellPut("182-86", "dan");
		spellPut("182-87", "gui");
		spellPut("182-88", "sui");
		spellPut("182-89", "li");
		spellPut("182-90", "nong");
		spellPut("182-91", "mi");
		spellPut("182-92", "dao");
		spellPut("182-93", "li");
		spellPut("182-94", "yue");
		spellPut("182-95", "ti");
		spellPut("182-96", "zan");
		spellPut("182-97", "lei");
		spellPut("182-98", "rou");
		spellPut("182-99", "xie");
		spellPut("182-100", "tu");
		spellPut("182-101", "ren");
		spellPut("182-102", "zi");
		spellPut("182-103", "cha,na");
		spellPut("182-104", "yi,zhi");
		spellPut("182-105", "xian");
		spellPut("182-106", "nian");
		spellPut("182-107", "qiu");
		spellPut("182-108", "fen");
		spellPut("182-109", "hao,mao");
		spellPut("182-110", "yun");
		spellPut("182-111", "zhi");
		spellPut("182-112", "jing");
		spellPut("182-113", "zhi");
		spellPut("182-114", "yu");
		spellPut("182-115", "ku");
		spellPut("182-116", "ban");
		spellPut("182-117", "pi");
		spellPut("182-118", "ni");
		spellPut("182-119", "li");
		spellPut("182-120", "you");
		spellPut("182-121", "pi");
		spellPut("182-122", "bo");
		spellPut("182-123", "ling");
		spellPut("182-124", "nian");
		spellPut("182-125", "zuo");
		spellPut("182-126", "di");
		spellPut("182-128", "ju");
		spellPut("182-129", "huo,kuo");
		spellPut("182-130", "tong");
		spellPut("182-131", "shi,zhi");
		spellPut("182-132", "huo,kuo");
		spellPut("182-133", "huo");
		spellPut("182-134", "yin");
		spellPut("182-135", "zi");
		spellPut("182-136", "zhi");
		spellPut("182-137", "ren");
		spellPut("182-138", "du");
		spellPut("182-139", "zhu");
		spellPut("182-140", "nong");
		spellPut("182-141", "fu,pu");
		spellPut("182-142", "gao");
		spellPut("182-143", "xun,ze");
		spellPut("182-144", "shui");
		spellPut("182-145", "kun");
		spellPut("182-146", "gan");
		spellPut("182-147", "jing");
		spellPut("182-148", "ti");
		spellPut("182-149", "tu,shu");
		spellPut("182-150", "ya");
		spellPut("182-151", "lun");
		spellPut("182-152", "lu");
		spellPut("182-153", "gu");
		spellPut("182-154", "zuo");
		spellPut("182-155", "zhun");
		spellPut("182-156", "bang");
		spellPut("182-157", "ji,qi");
		spellPut("182-158", "zhi");
		spellPut("182-159", "kun");
		spellPut("182-160", "leng,ling");
		spellPut("182-161", "ding,zheng");
		spellPut("182-162", "ding");
		spellPut("182-163", "ding");
		spellPut("182-164", "ding");
		spellPut("182-165", "ding");
		spellPut("182-166", "ding");
		spellPut("182-167", "ding");
		spellPut("182-168", "ding");
		spellPut("182-169", "ding");
		spellPut("182-170", "diu");
		spellPut("182-171", "dong");
		spellPut("182-172", "dong");
		spellPut("182-173", "dong");
		spellPut("182-174", "dong");
		spellPut("182-175", "dong");
		spellPut("182-176", "dong");
		spellPut("182-177", "dong,tong");
		spellPut("182-178", "dong");
		spellPut("182-179", "dong");
		spellPut("182-180", "dong");
		spellPut("182-181", "dou");
		spellPut("182-182", "dou");
		spellPut("182-183", "dou");
		spellPut("182-184", "dou");
		spellPut("182-185", "dou");
		spellPut("182-186", "dou");
		spellPut("182-187", "dou");
		spellPut("182-188", "du,dou");
		spellPut("182-189", "du");
		spellPut("182-190", "du,dai");
		spellPut("182-191", "du");
		spellPut("182-192", "du");
		spellPut("182-193", "du,dou");
		spellPut("182-194", "du");
		spellPut("182-195", "du");
		spellPut("182-196", "du");
		spellPut("182-197", "du");
		spellPut("182-198", "du");
		spellPut("182-199", "du");
		spellPut("182-200", "du,duo");
		spellPut("182-201", "du");
		spellPut("182-202", "du");
		spellPut("182-203", "duan");
		spellPut("182-204", "duan");
		spellPut("182-205", "duan");
		spellPut("182-206", "duan");
		spellPut("182-207", "duan");
		spellPut("182-208", "duan");
		spellPut("182-209", "dui");
		spellPut("182-210", "dui,rui,yue");
		spellPut("182-211", "dui");
		spellPut("182-212", "dui");
		spellPut("182-213", "dun");
		spellPut("182-214", "dun");
		spellPut("182-215", "dun");
		spellPut("182-216", "dun,dui");
		spellPut("182-217", "dun");
		spellPut("182-218", "dun,tun");
		spellPut("182-219", "dun");
		spellPut("182-220", "dun");
		spellPut("182-221", "dun");
		spellPut("182-222", "duo");
		spellPut("182-223", "duo");
		spellPut("182-224", "duo");
		spellPut("182-225", "duo");
		spellPut("182-226", "duo");
		spellPut("182-227", "duo");
		spellPut("182-228", "duo");
		spellPut("182-229", "duo");
		spellPut("182-230", "duo");
		spellPut("182-231", "duo");
		spellPut("182-232", "duo");
		spellPut("182-233", "duo,hui");
		spellPut("182-234", "e,yi");
		spellPut("182-235", "e");
		spellPut("182-236", "e");
		spellPut("182-237", "e");
		spellPut("182-238", "e");
		spellPut("182-239", "e");
		spellPut("182-240", "e");
		spellPut("182-241", "e,wu");
		spellPut("182-242", "e");
		spellPut("182-243", "e");
		spellPut("182-244", "e");
		spellPut("182-245", "e");
		spellPut("182-246", "e");
		spellPut("182-247", "en");
		spellPut("182-248", "er");
		spellPut("182-249", "er");
		spellPut("182-250", "er");
		spellPut("182-251", "er");
		spellPut("182-252", "er");
		spellPut("182-253", "er");
		spellPut("182-254", "er");
	}

	private static void init45() {
		spellPut("183-64", "peng");
		spellPut("183-65", "bing");
		spellPut("183-66", "zui,zu,su");
		spellPut("183-67", "yu");
		spellPut("183-68", "l<e");
		spellPut("183-69", "uu");
		spellPut("183-70", "yi");
		spellPut("183-71", "xi,qie");
		spellPut("183-72", "bian");
		spellPut("183-73", "ji");
		spellPut("183-74", "fu");
		spellPut("183-75", "pi,bi");
		spellPut("183-76", "nuo");
		spellPut("183-77", "jie");
		spellPut("183-78", "zhong");
		spellPut("183-79", "zong");
		spellPut("183-80", "xu");
		spellPut("183-81", "cheng,chen");
		spellPut("183-82", "dao");
		spellPut("183-83", "xian,jian,lian");
		spellPut("183-84", "zi,jiu");
		spellPut("183-85", "yu");
		spellPut("183-86", "xu");
		spellPut("183-87", "zhi");
		spellPut("183-88", "gao");
		spellPut("183-89", "gu");
		spellPut("183-90", "rong");
		spellPut("183-91", "sui");
		spellPut("183-92", "rong");
		spellPut("183-93", "ji");
		spellPut("183-94", "kang");
		spellPut("183-95", "can,shan,cen");
		spellPut("183-96", "men,mei");
		spellPut("183-97", "zhi");
		spellPut("183-98", "ji");
		spellPut("183-99", "lu");
		spellPut("183-100", "su");
		spellPut("183-101", "ji");
		spellPut("183-102", "ying");
		spellPut("183-103", "wen");
		spellPut("183-104", "qiu");
		spellPut("183-105", "ke we o ke");
		spellPut("183-106", "yi");
		spellPut("183-107", "huang");
		spellPut("183-108", "qie");
		spellPut("183-109", "ji");
		spellPut("183-110", "xiao,rao");
		spellPut("183-111", "pu");
		spellPut("183-112", "jiao");
		spellPut("183-113", "zhuo,bo");
		spellPut("183-114", "tong,zhong");
		spellPut("183-115", "zuo");
		spellPut("183-116", "lu");
		spellPut("183-117", "sui");
		spellPut("183-118", "nong");
		spellPut("183-119", "se");
		spellPut("183-120", "hui");
		spellPut("183-121", "rang");
		spellPut("183-122", "nuo");
		spellPut("183-123", "yu");
		spellPut("183-124", "pin");
		spellPut("183-125", "ji");
		spellPut("183-126", "tui");
		spellPut("183-128", "wen");
		spellPut("183-129", "cheng,chen");
		spellPut("183-130", "huo");
		spellPut("183-131", "kuang");
		spellPut("183-132", "lv");
		spellPut("183-133", "biao,pao");
		spellPut("183-134", "se");
		spellPut("183-135", "zhuo,jue");
		spellPut("183-136", "li");
		spellPut("183-137", "cuan,zan");
		spellPut("183-138", "wa");
		spellPut("183-139", "yu");
		spellPut("183-140", "shen");
		spellPut("183-141", "jing");
		spellPut("183-142", "yao");
		spellPut("183-143", "lao");
		spellPut("183-144", "yao");
		spellPut("183-145", "bao");
		spellPut("183-146", "bing");
		spellPut("183-147", "wa");
		spellPut("183-148", "zhu,ku");
		spellPut("183-149", "jiao,liao,liu");
		spellPut("183-150", "diao");
		spellPut("183-151", "wu");
		spellPut("183-152", "wa,gui");
		spellPut("183-153", "chuang");
		spellPut("183-154", "yao");
		spellPut("183-155", "xiao");
		spellPut("183-156", "cheng");
		spellPut("183-157", "kou");
		spellPut("183-158", "dan");
		spellPut("183-159", "zhuo");
		spellPut("183-160", "huo");
		spellPut("183-161", "er");
		spellPut("183-162", "fa");
		spellPut("183-163", "fa");
		spellPut("183-164", "fa");
		spellPut("183-165", "fa");
		spellPut("183-166", "fa");
		spellPut("183-167", "fa");
		spellPut("183-168", "fa");
		spellPut("183-169", "fa");
		spellPut("183-170", "fan");
		spellPut("183-171", "fan");
		spellPut("183-172", "fan,pan");
		spellPut("183-173", "fan");
		spellPut("183-174", "fan");
		spellPut("183-175", "fan");
		spellPut("183-176", "fan");
		spellPut("183-177", "fan,po");
		spellPut("183-178", "fan");
		spellPut("183-179", "fan");
		spellPut("183-180", "fan");
		spellPut("183-181", "fan");
		spellPut("183-182", "fan");
		spellPut("183-183", "fan");
		spellPut("183-184", "fan");
		spellPut("183-185", "fan");
		spellPut("183-186", "fan");
		spellPut("183-187", "fang");
		spellPut("183-188", "fang");
		spellPut("183-189", "fang");
		spellPut("183-190", "fang");
		spellPut("183-191", "fang");
		spellPut("183-192", "fang");
		spellPut("183-193", "fang");
		spellPut("183-194", "fang");
		spellPut("183-195", "fang");
		spellPut("183-196", "fang");
		spellPut("183-197", "fang");
		spellPut("183-198", "fei");
		spellPut("183-199", "fei");
		spellPut("183-200", "fei");
		spellPut("183-201", "fei");
		spellPut("183-202", "fei");
		spellPut("183-203", "fei");
		spellPut("183-204", "fei");
		spellPut("183-205", "fei");
		spellPut("183-206", "fei");
		spellPut("183-207", "fei");
		spellPut("183-208", "fei");
		spellPut("183-209", "fei");
		spellPut("183-210", "fen");
		spellPut("183-211", "fen");
		spellPut("183-212", "fen");
		spellPut("183-213", "fen");
		spellPut("183-214", "fen");
		spellPut("183-215", "fen");
		spellPut("183-216", "fen");
		spellPut("183-217", "fen");
		spellPut("183-218", "fen");
		spellPut("183-219", "fen");
		spellPut("183-220", "fen");
		spellPut("183-221", "fen,bin");
		spellPut("183-222", "fen");
		spellPut("183-223", "fen");
		spellPut("183-224", "fen");
		spellPut("183-225", "feng");
		spellPut("183-226", "feng");
		spellPut("183-227", "feng");
		spellPut("183-228", "feng");
		spellPut("183-229", "feng");
		spellPut("183-230", "feng");
		spellPut("183-231", "feng");
		spellPut("183-232", "feng");
		spellPut("183-233", "feng");
		spellPut("183-234", "feng");
		spellPut("183-235", "feng,ping");
		spellPut("183-236", "feng");
		spellPut("183-237", "feng");
		spellPut("183-238", "feng");
		spellPut("183-239", "feng");
		spellPut("183-240", "fo,fu,bi,bo");
		spellPut("183-241", "fou,pi");
		spellPut("183-242", "fu");
		spellPut("183-243", "fu");
		spellPut("183-244", "fu");
		spellPut("183-245", "fu");
		spellPut("183-246", "fu");
		spellPut("183-247", "fu,bi");
		spellPut("183-248", "fu");
		spellPut("183-249", "fu");
		spellPut("183-250", "fu");
		spellPut("183-251", "fu");
		spellPut("183-252", "fu");
		spellPut("183-253", "fu");
		spellPut("183-254", "fu");
	}

	private static void init46() {
		spellPut("184-64", "su");
		spellPut("184-65", "guan");
		spellPut("184-66", "zhuo");
		spellPut("184-67", "wo");
		spellPut("184-68", "wa");
		spellPut("184-69", "ya,ye");
		spellPut("184-70", "qiong");
		spellPut("184-71", "yao");
		spellPut("184-72", "yao");
		spellPut("184-73", "tiao");
		spellPut("184-74", "chao");
		spellPut("184-75", "tian,dian,yan");
		spellPut("184-76", "diao");
		spellPut("184-77", "ju");
		spellPut("184-78", "liao");
		spellPut("184-79", "xi");
		spellPut("184-80", "wu");
		spellPut("184-81", "kui");
		spellPut("184-82", "chuang");
		spellPut("184-83", "chao,ke");
		spellPut("184-84", "kuan,cuan");
		spellPut("184-85", "kuan,cuan");
		spellPut("184-86", "cheng");
		spellPut("184-87", "cui");
		spellPut("184-88", "liao");
		spellPut("184-89", "zao");
		spellPut("184-90", "cuan");
		spellPut("184-91", "qiao");
		spellPut("184-92", "qiong");
		spellPut("184-93", "dou");
		spellPut("184-94", "zao");
		spellPut("184-95", "long");
		spellPut("184-96", "qie");
		spellPut("184-97", "chu");
		spellPut("184-98", "shi");
		spellPut("184-99", "fu");
		spellPut("184-100", "qiBn");
		spellPut("184-101", "chu,qi");
		spellPut("184-102", "hong");
		spellPut("184-103", "qi");
		spellPut("184-104", "hBo");
		spellPut("184-105", "sheng");
		spellPut("184-106", "fen");
		spellPut("184-107", "miao");
		spellPut("184-108", "qu,kou");
		spellPut("184-109", "zhu");
		spellPut("184-110", "ling");
		spellPut("184-111", "long");
		spellPut("184-112", "bing");
		spellPut("184-113", "bBi");
		spellPut("184-114", "si");
		spellPut("184-115", "hong");
		spellPut("184-116", "jing,zhen");
		spellPut("184-117", "diao");
		spellPut("184-118", "yi");
		spellPut("184-119", "shu");
		spellPut("184-120", "jing");
		spellPut("184-121", "qu");
		spellPut("184-122", "ping");
		spellPut("184-123", "li");
		spellPut("184-124", "zhuan");
		spellPut("184-125", "ceng,zeng");
		spellPut("184-126", "deng");
		spellPut("184-128", "cun");
		spellPut("184-129", "wai");
		spellPut("184-130", "jing");
		spellPut("184-131", "kan");
		spellPut("184-132", "jing");
		spellPut("184-133", "le,jin");
		spellPut("184-134", "peng");
		spellPut("184-135", "chi");
		spellPut("184-136", "mang");
		spellPut("184-137", "zhu");
		spellPut("184-138", "wBn");
		spellPut("184-139", "jiao");
		spellPut("184-140", "suan");
		spellPut("184-141", "qin");
		spellPut("184-142", "ya");
		spellPut("184-143", "zhui,rui");
		spellPut("184-144", "yuan");
		spellPut("184-145", "hang");
		spellPut("184-146", "cen,jin,han");
		spellPut("184-147", "pi,bi");
		spellPut("184-148", "yi");
		spellPut("184-149", "dong");
		spellPut("184-150", "shan");
		spellPut("184-151", "da,xia,na");
		spellPut("184-152", "zhu");
		spellPut("184-153", "na");
		spellPut("184-154", "gu");
		spellPut("184-155", "qie");
		spellPut("184-156", "min");
		spellPut("184-157", "bao");
		spellPut("184-158", "ce");
		spellPut("184-159", "fa");
		spellPut("184-160", "ling");
		spellPut("184-161", "fu");
		spellPut("184-162", "fu");
		spellPut("184-163", "fu");
		spellPut("184-164", "fu");
		spellPut("184-165", "fu");
		spellPut("184-166", "fu");
		spellPut("184-167", "fu");
		spellPut("184-168", "fu");
		spellPut("184-169", "fu");
		spellPut("184-170", "fu");
		spellPut("184-171", "fu");
		spellPut("184-172", "fu");
		spellPut("184-173", "fu");
		spellPut("184-174", "fu");
		spellPut("184-175", "fu");
		spellPut("184-176", "fu");
		spellPut("184-177", "fu,pi");
		spellPut("184-178", "fu");
		spellPut("184-179", "fu");
		spellPut("184-180", "fu");
		spellPut("184-181", "fu");
		spellPut("184-182", "fu");
		spellPut("184-183", "fu");
		spellPut("184-184", "fu");
		spellPut("184-185", "fu");
		spellPut("184-186", "fu");
		spellPut("184-187", "fu");
		spellPut("184-188", "fu");
		spellPut("184-189", "fu");
		spellPut("184-190", "fu");
		spellPut("184-191", "fu");
		spellPut("184-192", "fu");
		spellPut("184-193", "ga");
		spellPut("184-194", "ga");
		spellPut("184-195", "gai");
		spellPut("184-196", "gai");
		spellPut("184-197", "gai");
		spellPut("184-198", "gai");
		spellPut("184-199", "gai,ge,he");
		spellPut("184-200", "gai");
		spellPut("184-201", "gan");
		spellPut("184-202", "gan");
		spellPut("184-203", "gan");
		spellPut("184-204", "gan");
		spellPut("184-205", "gan");
		spellPut("184-206", "gan");
		spellPut("184-207", "gan");
		spellPut("184-208", "gan");
		spellPut("184-209", "gan");
		spellPut("184-210", "gan");
		spellPut("184-211", "gan");
		spellPut("184-212", "gang");
		spellPut("184-213", "gang");
		spellPut("184-214", "gang");
		spellPut("184-215", "gang");
		spellPut("184-216", "gang");
		spellPut("184-217", "gang");
		spellPut("184-218", "gang");
		spellPut("184-219", "gang,jiang");
		spellPut("184-220", "gang");
		spellPut("184-221", "gao");
		spellPut("184-222", "gao,yao");
		spellPut("184-223", "gao");
		spellPut("184-224", "gao");
		spellPut("184-225", "gao");
		spellPut("184-226", "gao");
		spellPut("184-227", "gao");
		spellPut("184-228", "gao");
		spellPut("184-229", "gao");
		spellPut("184-230", "gao");
		spellPut("184-231", "ge");
		spellPut("184-232", "ge");
		spellPut("184-233", "ge");
		spellPut("184-234", "ge");
		spellPut("184-235", "ge");
		spellPut("184-236", "ge");
		spellPut("184-237", "ge,yi");
		spellPut("184-238", "ge");
		spellPut("184-239", "ge");
		spellPut("184-240", "ge");
		spellPut("184-241", "ge");
		spellPut("184-242", "ge,ha");
		spellPut("184-243", "ge");
		spellPut("184-244", "ge");
		spellPut("184-245", "ge");
		spellPut("184-246", "ge");
		spellPut("184-247", "ge");
		spellPut("184-248", "gei,ji");
		spellPut("184-249", "gen");
		spellPut("184-250", "gen");
		spellPut("184-251", "geng");
		spellPut("184-252", "geng");
		spellPut("184-253", "geng");
		spellPut("184-254", "geng");
	}

	private static void init47() {
		spellPut("185-64", "nu");
		spellPut("185-65", "fu,fei");
		spellPut("185-66", "fan");
		spellPut("185-67", "ge");
		spellPut("185-68", "fan");
		spellPut("185-69", "shi");
		spellPut("185-70", "mao");
		spellPut("185-71", "ti");
		spellPut("185-72", "qiong");
		spellPut("185-73", "min");
		spellPut("185-74", "luo");
		spellPut("185-75", "gui");
		spellPut("185-76", "qu");
		spellPut("185-77", "chi");
		spellPut("185-78", "yin");
		spellPut("185-79", "yao");
		spellPut("185-80", "bi");
		spellPut("185-81", "kuo");
		spellPut("185-82", "jiao");
		spellPut("185-83", "sun");
		spellPut("185-84", "ru");
		spellPut("185-85", "ji");
		spellPut("185-86", "hang");
		spellPut("185-87", "zhong");
		spellPut("185-88", "lai");
		spellPut("185-89", "dang");
		spellPut("185-90", "ce");
		spellPut("185-91", "fu");
		spellPut("185-92", "tu");
		spellPut("185-93", "li");
		spellPut("185-94", "lang");
		spellPut("185-95", "ju");
		spellPut("185-96", "guan");
		spellPut("185-97", "jian");
		spellPut("185-98", "han");
		spellPut("185-99", "tong");
		spellPut("185-100", "xia");
		spellPut("185-101", "zhi");
		spellPut("185-102", "cheng");
		spellPut("185-103", "suan");
		spellPut("185-104", "zhu");
		spellPut("185-105", "zuo");
		spellPut("185-106", "ting");
		spellPut("185-107", "ce");
		spellPut("185-108", "gao");
		spellPut("185-109", "gan");
		spellPut("185-110", "kuang");
		spellPut("185-111", "yun");
		spellPut("185-112", "o");
		spellPut("185-113", "xiao");
		spellPut("185-114", "pou,bu,fu,pu");
		spellPut("185-115", "lai");
		spellPut("185-116", "zou");
		spellPut("185-117", "pai,bei");
		spellPut("185-118", "bi");
		spellPut("185-119", "ge");
		spellPut("185-120", "tai,chi");
		spellPut("185-121", "guai,dai");
		spellPut("185-122", "yu");
		spellPut("185-123", "jian");
		spellPut("185-124", "zhao,dao");
		spellPut("185-125", "chi");
		spellPut("185-126", "zheng");
		spellPut("185-128", "sha");
		spellPut("185-129", "zhou");
		spellPut("185-130", "lu");
		spellPut("185-131", "lin");
		spellPut("185-132", "jun,qun");
		spellPut("185-133", "fu");
		spellPut("185-134", "zha");
		spellPut("185-135", "gu");
		spellPut("185-136", "quan");
		spellPut("185-137", "jun");
		spellPut("185-138", "chui");
		spellPut("185-139", "ce");
		spellPut("185-140", "zu");
		spellPut("185-141", "po");
		spellPut("185-142", "xuan");
		spellPut("185-143", "bian");
		spellPut("185-144", "sun");
		spellPut("185-145", "xian");
		spellPut("185-146", "ping");
		spellPut("185-147", "xing");
		spellPut("185-148", "hu");
		spellPut("185-149", "shi,yi");
		spellPut("185-150", "yue,yao,chuo");
		spellPut("185-151", "chun");
		spellPut("185-152", "lv");
		spellPut("185-153", "wu");
		spellPut("185-154", "dong");
		spellPut("185-155", "shuo,xiao,qiao");
		spellPut("185-156", "ji");
		spellPut("185-157", "jie");
		spellPut("185-158", "xing");
		spellPut("185-159", "mei");
		spellPut("185-160", "fan");
		spellPut("185-161", "geng");
		spellPut("185-162", "geng");
		spellPut("185-163", "geng");
		spellPut("185-164", "gong");
		spellPut("185-165", "gong");
		spellPut("185-166", "gong");
		spellPut("185-167", "gong");
		spellPut("185-168", "gong");
		spellPut("185-169", "gong");
		spellPut("185-170", "gong");
		spellPut("185-171", "gong");
		spellPut("185-172", "gong");
		spellPut("185-173", "gong");
		spellPut("185-174", "gong");
		spellPut("185-175", "gong");
		spellPut("185-176", "gong");
		spellPut("185-177", "gong");
		spellPut("185-178", "gong");
		spellPut("185-179", "gou");
		spellPut("185-180", "gou");
		spellPut("185-181", "gou");
		spellPut("185-182", "gou");
		spellPut("185-183", "gou");
		spellPut("185-184", "gou");
		spellPut("185-185", "gou");
		spellPut("185-186", "gou");
		spellPut("185-187", "gou");
		spellPut("185-188", "gu");
		spellPut("185-189", "gu");
		spellPut("185-190", "gu");
		spellPut("185-191", "gu");
		spellPut("185-192", "gu");
		spellPut("185-193", "gu");
		spellPut("185-194", "gu");
		spellPut("185-195", "gu");
		spellPut("185-196", "gu");
		spellPut("185-197", "gu");
		spellPut("185-198", "gu");
		spellPut("185-199", "gu");
		spellPut("185-200", "gu");
		spellPut("185-201", "gu");
		spellPut("185-202", "gu");
		spellPut("185-203", "gu");
		spellPut("185-204", "gu");
		spellPut("185-205", "gu");
		spellPut("185-206", "gua");
		spellPut("185-207", "gua");
		spellPut("185-208", "gua");
		spellPut("185-209", "gua");
		spellPut("185-210", "gua");
		spellPut("185-211", "gua");
		spellPut("185-212", "guai");
		spellPut("185-213", "guai");
		spellPut("185-214", "guai");
		spellPut("185-215", "guan");
		spellPut("185-216", "guan");
		spellPut("185-217", "guan");
		spellPut("185-218", "guan");
		spellPut("185-219", "guan");
		spellPut("185-220", "guan");
		spellPut("185-221", "guan");
		spellPut("185-222", "guan");
		spellPut("185-223", "guan");
		spellPut("185-224", "guan");
		spellPut("185-225", "guan");
		spellPut("185-226", "guang");
		spellPut("185-227", "guang,an");
		spellPut("185-228", "guang");
		spellPut("185-229", "gui");
		spellPut("185-230", "gui");
		spellPut("185-231", "gui");
		spellPut("185-232", "gui");
		spellPut("185-233", "gui");
		spellPut("185-234", "gui,jun,qiu");
		spellPut("185-235", "gui");
		spellPut("185-236", "gui");
		spellPut("185-237", "gui");
		spellPut("185-238", "gui");
		spellPut("185-239", "gui");
		spellPut("185-240", "gui");
		spellPut("185-241", "gui,ju");
		spellPut("185-242", "gui");
		spellPut("185-243", "gui");
		spellPut("185-244", "gui");
		spellPut("185-245", "gun");
		spellPut("185-246", "gun");
		spellPut("185-247", "gun,hun");
		spellPut("185-248", "guo");
		spellPut("185-249", "guo");
		spellPut("185-250", "guo");
		spellPut("185-251", "guo");
		spellPut("185-252", "guo");
		spellPut("185-253", "guo");
		spellPut("185-254", "ha");
	}

	private static void init48() {
		spellPut("186-64", "chuan");
		spellPut("186-65", "feng");
		spellPut("186-66", "zhu");
		spellPut("186-67", "hong");
		spellPut("186-68", "qie");
		spellPut("186-69", "qiu");
		spellPut("186-70", "miao");
		spellPut("186-71", "qian");
		spellPut("186-72", "gu");
		spellPut("186-73", "yi");
		spellPut("186-74", "yun");
		spellPut("186-75", "he");
		spellPut("186-76", "tang");
		spellPut("186-77", "yue");
		spellPut("186-78", "chou");
		spellPut("186-79", "ruo");
		spellPut("186-80", "zheng");
		spellPut("186-81", "nie");
		spellPut("186-82", "qian");
		spellPut("186-83", "xiao");
		spellPut("186-84", "gong,gan,long");
		spellPut("186-85", "peng,pang");
		spellPut("186-86", "du");
		spellPut("186-87", "zhuo,huo");
		spellPut("186-88", "chu");
		spellPut("186-89", "shai");
		spellPut("186-90", "zhu");
		spellPut("186-91", "qiang,cang");
		spellPut("186-92", "long");
		spellPut("186-93", "jian");
		spellPut("186-94", "bu");
		spellPut("186-95", "hui");
		spellPut("186-96", "bi");
		spellPut("186-97", "zhu,di");
		spellPut("186-98", "cong");
		spellPut("186-99", "yan");
		spellPut("186-100", "cen,zan,can");
		spellPut("186-101", "zhuan,zuan,suan");
		spellPut("186-102", "pi");
		spellPut("186-103", "piao,biao");
		spellPut("186-104", "yu");
		spellPut("186-105", "tuan,zhuan");
		spellPut("186-106", "ze");
		spellPut("186-107", "shai");
		spellPut("186-108", "guo,gui");
		spellPut("186-109", "yi");
		spellPut("186-110", "hu");
		spellPut("186-111", "chan");
		spellPut("186-112", "kou");
		spellPut("186-113", "ping");
		spellPut("186-114", "zao");
		spellPut("186-115", "ji");
		spellPut("186-116", "lou");
		spellPut("186-117", "ce,ji");
		spellPut("186-118", "nian");
		spellPut("186-119", "suo");
		spellPut("186-120", "cuan");
		spellPut("186-121", "sa sa la");
		spellPut("186-122", "suo");
		spellPut("186-123", "le");
		spellPut("186-124", "zhu");
		spellPut("186-125", "xiao");
		spellPut("186-126", "bo");
		spellPut("186-128", "mi,mie");
		spellPut("186-129", "shai,si");
		spellPut("186-130", "dang");
		spellPut("186-131", "liao");
		spellPut("186-132", "dan");
		spellPut("186-133", "fu");
		spellPut("186-134", "jian");
		spellPut("186-135", "min");
		spellPut("186-136", "kui");
		spellPut("186-137", "dai");
		spellPut("186-138", "jiao");
		spellPut("186-139", "sun,zhuan");
		spellPut("186-140", "lao");
		spellPut("186-141", "xiao");
		spellPut("186-142", "lu");
		spellPut("186-143", "shi");
		spellPut("186-144", "zan");
		spellPut("186-145", "qi");
		spellPut("186-146", "pai");
		spellPut("186-147", "qi");
		spellPut("186-148", "pai");
		spellPut("186-149", "gan");
		spellPut("186-150", "ju");
		spellPut("186-151", "lu");
		spellPut("186-152", "lu");
		spellPut("186-153", "yan");
		spellPut("186-154", "dang");
		spellPut("186-155", "sai");
		spellPut("186-156", "zhua");
		spellPut("186-157", "gou");
		spellPut("186-158", "qian");
		spellPut("186-159", "lian");
		spellPut("186-160", "shi");
		spellPut("186-161", "hai");
		spellPut("186-162", "hai");
		spellPut("186-163", "hai");
		spellPut("186-164", "hai");
		spellPut("186-165", "hai");
		spellPut("186-166", "hai");
		spellPut("186-167", "hai");
		spellPut("186-168", "han");
		spellPut("186-169", "han");
		spellPut("186-170", "han");
		spellPut("186-171", "han");
		spellPut("186-172", "han");
		spellPut("186-173", "han");
		spellPut("186-174", "han");
		spellPut("186-175", "han");
		spellPut("186-176", "han");
		spellPut("186-177", "han");
		spellPut("186-178", "han");
		spellPut("186-179", "han");
		spellPut("186-180", "han");
		spellPut("186-181", "han");
		spellPut("186-182", "han");
		spellPut("186-183", "han");
		spellPut("186-184", "han");
		spellPut("186-185", "han");
		spellPut("186-186", "han");
		spellPut("186-187", "hang,ben");
		spellPut("186-188", "hang");
		spellPut("186-189", "hang");
		spellPut("186-190", "hao");
		spellPut("186-191", "hao");
		spellPut("186-192", "hao");
		spellPut("186-193", "hao");
		spellPut("186-194", "hao");
		spellPut("186-195", "hao");
		spellPut("186-196", "hao");
		spellPut("186-197", "hao");
		spellPut("186-198", "hao");
		spellPut("186-199", "he,B,ke");
		spellPut("186-200", "he,ye");
		spellPut("186-201", "he");
		spellPut("186-202", "he");
		spellPut("186-203", "he,hu");
		spellPut("186-204", "he");
		spellPut("186-205", "he,huo,hu");
		spellPut("186-206", "he");
		spellPut("186-207", "he,ge");
		spellPut("186-208", "he");
		spellPut("186-209", "he,hao,mo");
		spellPut("186-210", "he");
		spellPut("186-211", "he");
		spellPut("186-212", "he");
		spellPut("186-213", "he");
		spellPut("186-214", "he");
		spellPut("186-215", "he");
		spellPut("186-216", "he");
		spellPut("186-217", "hei,mo");
		spellPut("186-218", "hei");
		spellPut("186-219", "hen");
		spellPut("186-220", "hen");
		spellPut("186-221", "hen");
		spellPut("186-222", "hen");
		spellPut("186-223", "heng,hng");
		spellPut("186-224", "heng,peng");
		spellPut("186-225", "heng");
		spellPut("186-226", "heng");
		spellPut("186-227", "heng");
		spellPut("186-228", "hong");
		spellPut("186-229", "hong");
		spellPut("186-230", "hong");
		spellPut("186-231", "hong");
		spellPut("186-232", "hong");
		spellPut("186-233", "hong");
		spellPut("186-234", "hong");
		spellPut("186-235", "hong");
		spellPut("186-236", "hong,gong");
		spellPut("186-237", "hou");
		spellPut("186-238", "hou");
		spellPut("186-239", "hou");
		spellPut("186-240", "hou");
		spellPut("186-241", "hou");
		spellPut("186-242", "hou");
		spellPut("186-243", "hou");
		spellPut("186-244", "hu");
		spellPut("186-245", "hu");
		spellPut("186-246", "hu");
		spellPut("186-247", "hu");
		spellPut("186-248", "hu");
		spellPut("186-249", "hu");
		spellPut("186-250", "hu");
		spellPut("186-251", "hu");
		spellPut("186-252", "hu");
		spellPut("186-253", "hu");
		spellPut("186-254", "hu");
	}

	private static void init49() {
		spellPut("187-64", "lan");
		spellPut("187-65", "kui");
		spellPut("187-66", "yu");
		spellPut("187-67", "yue");
		spellPut("187-68", "hao");
		spellPut("187-69", "zhen,jian");
		spellPut("187-70", "tai");
		spellPut("187-71", "ti");
		spellPut("187-72", "nie");
		spellPut("187-73", "chou");
		spellPut("187-74", "yi");
		spellPut("187-75", "qi");
		spellPut("187-76", "teng");
		spellPut("187-77", "zhuan");
		spellPut("187-78", "zhou");
		spellPut("187-79", "fan,pan,bian");
		spellPut("187-80", "sou,shu");
		spellPut("187-81", "zhou");
		spellPut("187-82", "qian");
		spellPut("187-83", "zhuo");
		spellPut("187-84", "teng");
		spellPut("187-85", "lu");
		spellPut("187-86", "lu");
		spellPut("187-87", "jian");
		spellPut("187-88", "tuo");
		spellPut("187-89", "ying");
		spellPut("187-90", "yu");
		spellPut("187-91", "lai");
		spellPut("187-92", "long");
		spellPut("187-93", "shen shi,sen si,qie");
		spellPut("187-94", "lian");
		spellPut("187-95", "lan");
		spellPut("187-96", "qian");
		spellPut("187-97", "yue");
		spellPut("187-98", "zhong");
		spellPut("187-99", "qu");
		spellPut("187-100", "lian");
		spellPut("187-101", "bian");
		spellPut("187-102", "duan");
		spellPut("187-103", "zuan");
		spellPut("187-104", "li");
		spellPut("187-105", "shai");
		spellPut("187-106", "luo");
		spellPut("187-107", "ying");
		spellPut("187-108", "yue");
		spellPut("187-109", "zhuo");
		spellPut("187-110", "yu");
		spellPut("187-111", "fan");
		spellPut("187-112", "shen");
		spellPut("187-113", "zhe");
		spellPut("187-114", "shen");
		spellPut("187-115", "nv");
		spellPut("187-116", "he");
		spellPut("187-117", "ni");
		spellPut("187-118", "cun");
		spellPut("187-119", "zhBng");
		spellPut("187-120", "qiBn");
		spellPut("187-121", "zhBi");
		spellPut("187-122", "bi");
		spellPut("187-123", "ban");
		spellPut("187-124", "wu");
		spellPut("187-125", "sha,chao");
		spellPut("187-126", "kang,jing");
		spellPut("187-128", "rou");
		spellPut("187-129", "bi");
		spellPut("187-130", "cui");
		spellPut("187-131", "yin");
		spellPut("187-132", "zhe");
		spellPut("187-133", "mi");
		spellPut("187-134", "ta");
		spellPut("187-135", "hu");
		spellPut("187-136", "gan");
		spellPut("187-137", "ju");
		spellPut("187-138", "yu");
		spellPut("187-139", "zhou");
		spellPut("187-140", "chi");
		spellPut("187-141", "su");
		spellPut("187-142", "hong");
		spellPut("187-143", "tong");
		spellPut("187-144", "ce,se");
		spellPut("187-145", "lin");
		spellPut("187-146", "zhuang");
		spellPut("187-147", "bBi");
		spellPut("187-148", "lBo");
		spellPut("187-149", "er");
		spellPut("187-150", "qu");
		spellPut("187-151", "he");
		spellPut("187-152", "xian");
		spellPut("187-153", "fu");
		spellPut("187-154", "li");
		spellPut("187-155", "yue");
		spellPut("187-156", "lu");
		spellPut("187-157", "ju");
		spellPut("187-158", "qi");
		spellPut("187-159", "bai");
		spellPut("187-160", "zhang");
		spellPut("187-161", "hu");
		spellPut("187-162", "hu");
		spellPut("187-163", "hu,xia");
		spellPut("187-164", "hu");
		spellPut("187-165", "hu");
		spellPut("187-166", "hu");
		spellPut("187-167", "hu");
		spellPut("187-168", "hua");
		spellPut("187-169", "hua");
		spellPut("187-170", "hua");
		spellPut("187-171", "hua");
		spellPut("187-172", "hua");
		spellPut("187-173", "hua");
		spellPut("187-174", "hua");
		spellPut("187-175", "hua");
		spellPut("187-176", "hua");
		spellPut("187-177", "huai");
		spellPut("187-178", "huai");
		spellPut("187-179", "huai");
		spellPut("187-180", "huai");
		spellPut("187-181", "huai,pei,pi");
		spellPut("187-182", "huan");
		spellPut("187-183", "huan");
		spellPut("187-184", "huan");
		spellPut("187-185", "huan,hai");
		spellPut("187-186", "huan");
		spellPut("187-187", "huan");
		spellPut("187-188", "huan");
		spellPut("187-189", "huan");
		spellPut("187-190", "huan");
		spellPut("187-191", "huan");
		spellPut("187-192", "huan");
		spellPut("187-193", "huan");
		spellPut("187-194", "huan");
		spellPut("187-195", "huan");
		spellPut("187-196", "huang");
		spellPut("187-197", "huang");
		spellPut("187-198", "huang");
		spellPut("187-199", "huang");
		spellPut("187-200", "huang");
		spellPut("187-201", "huang");
		spellPut("187-202", "huang");
		spellPut("187-203", "huang");
		spellPut("187-204", "huang");
		spellPut("187-205", "huang");
		spellPut("187-206", "huang");
		spellPut("187-207", "huang");
		spellPut("187-208", "huang");
		spellPut("187-209", "huang");
		spellPut("187-210", "hui");
		spellPut("187-211", "hui");
		spellPut("187-212", "hui");
		spellPut("187-213", "hui");
		spellPut("187-214", "hui");
		spellPut("187-215", "hui");
		spellPut("187-216", "hui");
		spellPut("187-217", "hui");
		spellPut("187-218", "hui");
		spellPut("187-219", "hui");
		spellPut("187-220", "hui");
		spellPut("187-221", "hui");
		spellPut("187-222", "hui");
		spellPut("187-223", "hui");
		spellPut("187-224", "hui");
		spellPut("187-225", "hui,kuai");
		spellPut("187-226", "hui");
		spellPut("187-227", "hui");
		spellPut("187-228", "hui");
		spellPut("187-229", "hui");
		spellPut("187-230", "hui");
		spellPut("187-231", "hun");
		spellPut("187-232", "hun");
		spellPut("187-233", "hun");
		spellPut("187-234", "hun");
		spellPut("187-235", "hun");
		spellPut("187-236", "hun");
		spellPut("187-237", "huo");
		spellPut("187-238", "huo");
		spellPut("187-239", "huo");
		spellPut("187-240", "huo");
		spellPut("187-241", "huo");
		spellPut("187-242", "huo");
		spellPut("187-243", "huo");
		spellPut("187-244", "huo");
		spellPut("187-245", "huo");
		spellPut("187-246", "huo");
		spellPut("187-247", "ji");
		spellPut("187-248", "ji");
		spellPut("187-249", "ji");
		spellPut("187-250", "ji");
		spellPut("187-251", "ji");
		spellPut("187-252", "ji,qi");
		spellPut("187-253", "ji");
		spellPut("187-254", "ji");
	}

	private static void init50() {
		spellPut("188-64", "guo");
		spellPut("188-65", "huB");
		spellPut("188-66", "shen");
		spellPut("188-67", "tang");
		spellPut("188-68", "bian");
		spellPut("188-69", "mian");
		spellPut("188-70", "zong");
		spellPut("188-71", "jian");
		spellPut("188-72", "li");
		spellPut("188-73", "xie");
		spellPut("188-74", "fu");
		spellPut("188-75", "nuo");
		spellPut("188-76", "bei");
		spellPut("188-77", "gu,gou");
		spellPut("188-78", "xiu");
		spellPut("188-79", "jiB");
		spellPut("188-80", "zhuang");
		spellPut("188-81", "tang");
		spellPut("188-82", "san,shen");
		spellPut("188-83", "fen");
		spellPut("188-84", "jiang");
		spellPut("188-85", "mo");
		spellPut("188-86", "san,shen");
		spellPut("188-87", "san");
		spellPut("188-88", "nuo");
		spellPut("188-89", "xi");
		spellPut("188-90", "liang");
		spellPut("188-91", "kuai");
		spellPut("188-92", "bo");
		spellPut("188-93", "huan");
		spellPut("188-94", "shu");
		spellPut("188-95", "zong");
		spellPut("188-96", "xian");
		spellPut("188-97", "tuan");
		spellPut("188-98", "nie");
		spellPut("188-99", "li");
		spellPut("188-100", "zuo");
		spellPut("188-101", "di");
		spellPut("188-102", "nie");
		spellPut("188-103", "tiao");
		spellPut("188-104", "lan");
		spellPut("188-105", "si");
		spellPut("188-106", "jiu");
		spellPut("188-107", "gong");
		spellPut("188-108", "zheng");
		spellPut("188-109", "jiu");
		spellPut("188-110", "gong");
		spellPut("188-111", "ji");
		spellPut("188-112", "cha");
		spellPut("188-113", "zhou");
		spellPut("188-114", "xun");
		spellPut("188-115", "yue,yao");
		spellPut("188-116", "hong,gong");
		spellPut("188-117", "yu");
		spellPut("188-118", "he,ge");
		spellPut("188-119", "wan");
		spellPut("188-120", "ren");
		spellPut("188-121", "wen");
		spellPut("188-122", "qiu");
		spellPut("188-123", "na");
		spellPut("188-124", "zi");
		spellPut("188-125", "tou");
		spellPut("188-126", "niu");
		spellPut("188-128", "fou");
		spellPut("188-129", "ji,jie");
		spellPut("188-130", "shu");
		spellPut("188-131", "chun");
		spellPut("188-132", "pi,bi");
		spellPut("188-133", "zhen");
		spellPut("188-134", "sha");
		spellPut("188-135", "hong");
		spellPut("188-136", "zhi");
		spellPut("188-137", "ji");
		spellPut("188-138", "fen");
		spellPut("188-139", "yun");
		spellPut("188-140", "ren");
		spellPut("188-141", "dan");
		spellPut("188-142", "jin");
		spellPut("188-143", "fang");
		spellPut("188-144", "cui");
		spellPut("188-145", "jiu");
		spellPut("188-146", "zha,za");
		spellPut("188-147", "ha");
		spellPut("188-148", "fu");
		spellPut("188-149", "zhi");
		spellPut("188-150", "qi");
		spellPut("188-151", "chou");
		spellPut("188-152", "hong");
		spellPut("188-153", "zha,za");
		spellPut("188-154", "xi");
		spellPut("188-155", "fu");
		spellPut("188-156", "xie");
		spellPut("188-157", "shen");
		spellPut("188-158", "bo,bi");
		spellPut("188-159", "zhu");
		spellPut("188-160", "qu");
		spellPut("188-161", "ji");
		spellPut("188-162", "ji");
		spellPut("188-163", "ji");
		spellPut("188-164", "ji");
		spellPut("188-165", "ji");
		spellPut("188-166", "ji");
		spellPut("188-167", "ji");
		spellPut("188-168", "ji");
		spellPut("188-169", "ji,qi");
		spellPut("188-170", "ji");
		spellPut("188-171", "ji");
		spellPut("188-172", "ji");
		spellPut("188-173", "ji");
		spellPut("188-174", "ji");
		spellPut("188-175", "ji");
		spellPut("188-176", "ji");
		spellPut("188-177", "ji");
		spellPut("188-178", "ji");
		spellPut("188-179", "ji");
		spellPut("188-180", "ji");
		spellPut("188-181", "ji");
		spellPut("188-182", "ji");
		spellPut("188-183", "ji");
		spellPut("188-184", "ji");
		spellPut("188-185", "ji");
		spellPut("188-186", "ji");
		spellPut("188-187", "ji");
		spellPut("188-188", "ji");
		spellPut("188-189", "ji");
		spellPut("188-190", "ji");
		spellPut("188-191", "ji,qi");
		spellPut("188-192", "ji,zhai");
		spellPut("188-193", "ji");
		spellPut("188-194", "ji");
		spellPut("188-195", "ji");
		spellPut("188-196", "ji");
		spellPut("188-197", "ji");
		spellPut("188-198", "ji");
		spellPut("188-199", "ji");
		spellPut("188-200", "ji");
		spellPut("188-201", "ji");
		spellPut("188-202", "ji");
		spellPut("188-203", "ji");
		spellPut("188-204", "ji");
		spellPut("188-205", "ji");
		spellPut("188-206", "jia");
		spellPut("188-207", "jia");
		spellPut("188-208", "jia,ga,xia");
		spellPut("188-209", "jia");
		spellPut("188-210", "jia,jiB");
		spellPut("188-211", "jia");
		spellPut("188-212", "jia");
		spellPut("188-213", "jia");
		spellPut("188-214", "jia");
		spellPut("188-215", "jia");
		spellPut("188-216", "jia");
		spellPut("188-217", "jia");
		spellPut("188-218", "jia");
		spellPut("188-219", "jia,jie");
		spellPut("188-220", "jia");
		spellPut("188-221", "jia");
		spellPut("188-222", "jia");
		spellPut("188-223", "jian");
		spellPut("188-224", "jian");
		spellPut("188-225", "jian");
		spellPut("188-226", "jian");
		spellPut("188-227", "jian");
		spellPut("188-228", "jian");
		spellPut("188-229", "jian");
		spellPut("188-230", "jian");
		spellPut("188-231", "jian");
		spellPut("188-232", "jian");
		spellPut("188-233", "jian");
		spellPut("188-234", "jian");
		spellPut("188-235", "jian");
		spellPut("188-236", "jian");
		spellPut("188-237", "jian");
		spellPut("188-238", "jian");
		spellPut("188-239", "jian");
		spellPut("188-240", "jian");
		spellPut("188-241", "jian");
		spellPut("188-242", "jian");
		spellPut("188-243", "jian");
		spellPut("188-244", "jian");
		spellPut("188-245", "jian");
		spellPut("188-246", "jian");
		spellPut("188-247", "jian,kan");
		spellPut("188-248", "jian");
		spellPut("188-249", "jian");
		spellPut("188-250", "jian");
		spellPut("188-251", "jian,xian");
		spellPut("188-252", "jian");
		spellPut("188-253", "jian");
		spellPut("188-254", "jian");
	}

	private static void init51() {
		spellPut("189-64", "ling");
		spellPut("189-65", "zhu");
		spellPut("189-66", "shao");
		spellPut("189-67", "gan");
		spellPut("189-68", "yang");
		spellPut("189-69", "fu");
		spellPut("189-70", "tuo");
		spellPut("189-71", "zhen,tian");
		spellPut("189-72", "dai");
		spellPut("189-73", "chu");
		spellPut("189-74", "shi");
		spellPut("189-75", "zhong");
		spellPut("189-76", "xian");
		spellPut("189-77", "zu");
		spellPut("189-78", "jiong");
		spellPut("189-79", "ban");
		spellPut("189-80", "qu");
		spellPut("189-81", "mo");
		spellPut("189-82", "shu");
		spellPut("189-83", "zui");
		spellPut("189-84", "kuang");
		spellPut("189-85", "jing");
		spellPut("189-86", "ren");
		spellPut("189-87", "hang");
		spellPut("189-88", "xie");
		spellPut("189-89", "jie");
		spellPut("189-90", "zhu");
		spellPut("189-91", "chou");
		spellPut("189-92", "gua,kua");
		spellPut("189-93", "bai,mo");
		spellPut("189-94", "jue");
		spellPut("189-95", "kuang");
		spellPut("189-96", "hu");
		spellPut("189-97", "ci");
		spellPut("189-98", "huan,geng");
		spellPut("189-99", "geng");
		spellPut("189-100", "tao");
		spellPut("189-101", "xie,jie");
		spellPut("189-102", "ku");
		spellPut("189-103", "jiao");
		spellPut("189-104", "quan,shuan");
		spellPut("189-105", "gai,ai");
		spellPut("189-106", "luo,lao");
		spellPut("189-107", "xuan");
		spellPut("189-108", "beng,bing,peng");
		spellPut("189-109", "xian");
		spellPut("189-110", "fu");
		spellPut("189-111", "gei,ji");
		spellPut("189-112", "tong,dong");
		spellPut("189-113", "rong");
		spellPut("189-114", "tiao,diao,dao");
		spellPut("189-115", "yin");
		spellPut("189-116", "lei");
		spellPut("189-117", "xie");
		spellPut("189-118", "juan");
		spellPut("189-119", "gai,hai");
		spellPut("189-120", "die");
		spellPut("189-121", "tong");
		spellPut("189-122", "si");
		spellPut("189-123", "jiang");
		spellPut("189-124", "xiang");
		spellPut("189-125", "hui");
		spellPut("189-126", "jue");
		spellPut("189-128", "jian");
		spellPut("189-129", "juan");
		spellPut("189-130", "chi,zhi");
		spellPut("189-131", "mian,wen,man,wan");
		spellPut("189-132", "zhen");
		spellPut("189-133", "lv");
		spellPut("189-134", "cheng");
		spellPut("189-135", "qiu");
		spellPut("189-136", "shu");
		spellPut("189-137", "bang");
		spellPut("189-138", "tong");
		spellPut("189-139", "xiao");
		spellPut("189-140", "huan,wan");
		spellPut("189-141", "qin,xian");
		spellPut("189-142", "geng");
		spellPut("189-143", "xu");
		spellPut("189-144", "ti");
		spellPut("189-145", "xiu");
		spellPut("189-146", "xie");
		spellPut("189-147", "hong");
		spellPut("189-148", "xi");
		spellPut("189-149", "fu");
		spellPut("189-150", "ting");
		spellPut("189-151", "sui");
		spellPut("189-152", "dui");
		spellPut("189-153", "kun");
		spellPut("189-154", "fu");
		spellPut("189-155", "jing");
		spellPut("189-156", "hu");
		spellPut("189-157", "zhi");
		spellPut("189-158", "yan,xian");
		spellPut("189-159", "jiong");
		spellPut("189-160", "feng");
		spellPut("189-161", "jian");
		spellPut("189-162", "jian");
		spellPut("189-163", "jian");
		spellPut("189-164", "jian");
		spellPut("189-165", "jian");
		spellPut("189-166", "jian");
		spellPut("189-167", "jian");
		spellPut("189-168", "jian");
		spellPut("189-169", "jiang");
		spellPut("189-170", "jiang");
		spellPut("189-171", "jiang");
		spellPut("189-172", "jiang");
		spellPut("189-173", "jiang");
		spellPut("189-174", "jiang,qiang");
		spellPut("189-175", "jiang");
		spellPut("189-176", "jiang");
		spellPut("189-177", "jiang");
		spellPut("189-178", "jiang");
		spellPut("189-179", "jiang");
		spellPut("189-180", "jiang");
		spellPut("189-181", "jiang");
		spellPut("189-182", "jiao");
		spellPut("189-183", "jiao");
		spellPut("189-184", "jiao");
		spellPut("189-185", "jiao");
		spellPut("189-186", "jiao");
		spellPut("189-187", "jiao");
		spellPut("189-188", "jiao");
		spellPut("189-189", "jiao");
		spellPut("189-190", "jiao");
		spellPut("189-191", "jiao");
		spellPut("189-192", "jiao,jue");
		spellPut("189-193", "jiao");
		spellPut("189-194", "jiao");
		spellPut("189-195", "jiao");
		spellPut("189-196", "jiao,yao");
		spellPut("189-197", "jiao");
		spellPut("189-198", "jiao");
		spellPut("189-199", "jiao,jue");
		spellPut("189-200", "jiao");
		spellPut("189-201", "jiao,zhuo");
		spellPut("189-202", "jiao");
		spellPut("189-203", "jiao,chao");
		spellPut("189-204", "jiao");
		spellPut("189-205", "jiao");
		spellPut("189-206", "jiao");
		spellPut("189-207", "jiao");
		spellPut("189-208", "jiao");
		spellPut("189-209", "jiao");
		spellPut("189-210", "jie,qi");
		spellPut("189-211", "jie");
		spellPut("189-212", "jie");
		spellPut("189-213", "jie");
		spellPut("189-214", "jie");
		spellPut("189-215", "jie");
		spellPut("189-216", "jie");
		spellPut("189-217", "jie");
		spellPut("189-218", "jie");
		spellPut("189-219", "jie,ju");
		spellPut("189-220", "jie");
		spellPut("189-221", "jie");
		spellPut("189-222", "jie");
		spellPut("189-223", "jie");
		spellPut("189-224", "jie");
		spellPut("189-225", "jie");
		spellPut("189-226", "jie,xie");
		spellPut("189-227", "jie");
		spellPut("189-228", "jie");
		spellPut("189-229", "jie,ji");
		spellPut("189-230", "jie,gai");
		spellPut("189-231", "jie");
		spellPut("189-232", "jie");
		spellPut("189-233", "jie");
		spellPut("189-234", "jie");
		spellPut("189-235", "jie");
		spellPut("189-236", "jie");
		spellPut("189-237", "jin");
		spellPut("189-238", "jin");
		spellPut("189-239", "jin");
		spellPut("189-240", "jin");
		spellPut("189-241", "jin");
		spellPut("189-242", "jin");
		spellPut("189-243", "jin");
		spellPut("189-244", "jin");
		spellPut("189-245", "jin");
		spellPut("189-246", "jin");
		spellPut("189-247", "jin");
		spellPut("189-248", "jin");
		spellPut("189-249", "jin");
		spellPut("189-250", "jin");
		spellPut("189-251", "jin");
		spellPut("189-252", "jin");
		spellPut("189-253", "jin");
		spellPut("189-254", "jin");
	}

	private static void init52() {
		spellPut("190-64", "ji");
		spellPut("190-65", "xu");
		spellPut("190-66", "kB sei");
		spellPut("190-67", "zong,zeng");
		spellPut("190-68", "lin,chen");
		spellPut("190-69", "duo");
		spellPut("190-70", "li,lie");
		spellPut("190-71", "lv");
		spellPut("190-72", "jing");
		spellPut("190-73", "chou");
		spellPut("190-74", "quan");
		spellPut("190-75", "shao");
		spellPut("190-76", "qi");
		spellPut("190-77", "zhun");
		spellPut("190-78", "ji,qi");
		spellPut("190-79", "wan");
		spellPut("190-80", "qian,qing,zheng");
		spellPut("190-81", "xian");
		spellPut("190-82", "shou");
		spellPut("190-83", "wei");
		spellPut("190-84", "tao");
		spellPut("190-85", "wan");
		spellPut("190-86", "gang");
		spellPut("190-87", "wang");
		spellPut("190-88", "beng");
		spellPut("190-89", "zhui");
		spellPut("190-90", "cai");
		spellPut("190-91", "guo");
		spellPut("190-92", "cui");
		spellPut("190-93", "lun,guan");
		spellPut("190-94", "liu");
		spellPut("190-95", "qi");
		spellPut("190-96", "zhan");
		spellPut("190-97", "bi");
		spellPut("190-98", "chuo,chao");
		spellPut("190-99", "ling");
		spellPut("190-100", "mian");
		spellPut("190-101", "qi");
		spellPut("190-102", "ji");
		spellPut("190-103", "tian,tan,chan");
		spellPut("190-104", "zong");
		spellPut("190-105", "gun");
		spellPut("190-106", "zou");
		spellPut("190-107", "xi");
		spellPut("190-108", "zi");
		spellPut("190-109", "xing");
		spellPut("190-110", "liang");
		spellPut("190-111", "jin");
		spellPut("190-112", "fei");
		spellPut("190-113", "rui");
		spellPut("190-114", "min");
		spellPut("190-115", "yu");
		spellPut("190-116", "zong");
		spellPut("190-117", "fan");
		spellPut("190-118", "lv,lu");
		spellPut("190-119", "xu");
		spellPut("190-120", "ying");
		spellPut("190-121", "shang");
		spellPut("190-122", "zi");
		spellPut("190-123", "xu");
		spellPut("190-124", "xiang");
		spellPut("190-125", "jian");
		spellPut("190-126", "ke");
		spellPut("190-128", "xian");
		spellPut("190-129", "ruan");
		spellPut("190-130", "mian");
		spellPut("190-131", "ji,qi");
		spellPut("190-132", "duan");
		spellPut("190-133", "chong,zhong");
		spellPut("190-134", "di");
		spellPut("190-135", "min");
		spellPut("190-136", "miao,mao");
		spellPut("190-137", "yuan");
		spellPut("190-138", "xie,ye");
		spellPut("190-139", "bao");
		spellPut("190-140", "si");
		spellPut("190-141", "qiu");
		spellPut("190-142", "bian");
		spellPut("190-143", "huan");
		spellPut("190-144", "geng");
		spellPut("190-145", "zong");
		spellPut("190-146", "mian");
		spellPut("190-147", "wei");
		spellPut("190-148", "fu");
		spellPut("190-149", "wei");
		spellPut("190-150", "tou,xu,shu");
		spellPut("190-151", "gou");
		spellPut("190-152", "miao");
		spellPut("190-153", "xie");
		spellPut("190-154", "lian");
		spellPut("190-155", "zong");
		spellPut("190-156", "bian,pian");
		spellPut("190-157", "gun,yun");
		spellPut("190-158", "yin");
		spellPut("190-159", "ti");
		spellPut("190-160", "gua,wo");
		spellPut("190-161", "jin");
		spellPut("190-162", "jin,jing");
		spellPut("190-163", "jing");
		spellPut("190-164", "jing");
		spellPut("190-165", "jing");
		spellPut("190-166", "jing");
		spellPut("190-167", "jing");
		spellPut("190-168", "jing");
		spellPut("190-169", "jing");
		spellPut("190-170", "jing");
		spellPut("190-171", "jing");
		spellPut("190-172", "jing");
		spellPut("190-173", "jing");
		spellPut("190-174", "jing");
		spellPut("190-175", "jing");
		spellPut("190-176", "jing,ying");
		spellPut("190-177", "jing,geng");
		spellPut("190-178", "jing");
		spellPut("190-179", "jing");
		spellPut("190-180", "jing");
		spellPut("190-181", "jing");
		spellPut("190-182", "jing");
		spellPut("190-183", "jing");
		spellPut("190-184", "jing");
		spellPut("190-185", "jing");
		spellPut("190-186", "jing");
		spellPut("190-187", "jing,cheng");
		spellPut("190-188", "jiong");
		spellPut("190-189", "jiong");
		spellPut("190-190", "jiu");
		spellPut("190-191", "jiu");
		spellPut("190-192", "jiu");
		spellPut("190-193", "jiu");
		spellPut("190-194", "jiu");
		spellPut("190-195", "jiu");
		spellPut("190-196", "jiu");
		spellPut("190-197", "jiu");
		spellPut("190-198", "jiu");
		spellPut("190-199", "jiu");
		spellPut("190-200", "jiu");
		spellPut("190-201", "jiu");
		spellPut("190-202", "jiu");
		spellPut("190-203", "jiu");
		spellPut("190-204", "jiu");
		spellPut("190-205", "jiu");
		spellPut("190-206", "jiu");
		spellPut("190-207", "ju");
		spellPut("190-208", "ju,gou");
		spellPut("190-209", "ju");
		spellPut("190-210", "ju");
		spellPut("190-211", "ju");
		spellPut("190-212", "ju");
		spellPut("190-213", "ju");
		spellPut("190-214", "ju");
		spellPut("190-215", "ju,zui");
		spellPut("190-216", "ju");
		spellPut("190-217", "ju");
		spellPut("190-218", "ju");
		spellPut("190-219", "ju");
		spellPut("190-220", "ju");
		spellPut("190-221", "ju");
		spellPut("190-222", "ju");
		spellPut("190-223", "ju");
		spellPut("190-224", "ju");
		spellPut("190-225", "ju");
		spellPut("190-226", "ju");
		spellPut("190-227", "ju");
		spellPut("190-228", "ju,gou");
		spellPut("190-229", "ju");
		spellPut("190-230", "ju");
		spellPut("190-231", "ju");
		spellPut("190-232", "juan");
		spellPut("190-233", "juan");
		spellPut("190-234", "juan");
		spellPut("190-235", "juan");
		spellPut("190-236", "juan");
		spellPut("190-237", "juan");
		spellPut("190-238", "juan");
		spellPut("190-239", "jue");
		spellPut("190-240", "jue");
		spellPut("190-241", "jue");
		spellPut("190-242", "jue");
		spellPut("190-243", "jue");
		spellPut("190-244", "jue");
		spellPut("190-245", "jue,jiao");
		spellPut("190-246", "jue");
		spellPut("190-247", "jue");
		spellPut("190-248", "jue");
		spellPut("190-249", "jun");
		spellPut("190-250", "jun");
		spellPut("190-251", "jun");
		spellPut("190-252", "jun");
		spellPut("190-253", "jun");
		spellPut("190-254", "jun");
	}

	private static void init53() {
		spellPut("191-64", "zhi");
		spellPut("191-65", "yun,wen");
		spellPut("191-66", "cheng");
		spellPut("191-67", "chan");
		spellPut("191-68", "dai");
		spellPut("191-69", "xie");
		spellPut("191-70", "yuan");
		spellPut("191-71", "zong");
		spellPut("191-72", "xu");
		spellPut("191-73", "sheng");
		spellPut("191-74", "ou duo xi");
		spellPut("191-75", "geng");
		spellPut("191-76", "se o ne");
		spellPut("191-77", "ying");
		spellPut("191-78", "jin");
		spellPut("191-79", "yi");
		spellPut("191-80", "zhui");
		spellPut("191-81", "ni");
		spellPut("191-82", "bang");
		spellPut("191-83", "gu,hu");
		spellPut("191-84", "pan");
		spellPut("191-85", "zhou");
		spellPut("191-86", "jian");
		spellPut("191-87", "ci,cuo,suo");
		spellPut("191-88", "quan");
		spellPut("191-89", "shuang");
		spellPut("191-90", "yun,wen");
		spellPut("191-91", "xia");
		spellPut("191-92", "cui,sui,shuai");
		spellPut("191-93", "xi");
		spellPut("191-94", "rong");
		spellPut("191-95", "tao");
		spellPut("191-96", "fu");
		spellPut("191-97", "yun");
		spellPut("191-98", "zhen");
		spellPut("191-99", "gao");
		spellPut("191-100", "ru");
		spellPut("191-101", "hu");
		spellPut("191-102", "zai,zeng");
		spellPut("191-103", "teng");
		spellPut("191-104", "xian,xuan");
		spellPut("191-105", "su");
		spellPut("191-106", "zhen");
		spellPut("191-107", "zong");
		spellPut("191-108", "tao");
		spellPut("191-109", "huBng ho ro");
		spellPut("191-110", "cai");
		spellPut("191-111", "bi");
		spellPut("191-112", "feng");
		spellPut("191-113", "cu");
		spellPut("191-114", "li");
		spellPut("191-115", "suo,su");
		spellPut("191-116", "yan,yin");
		spellPut("191-117", "xi");
		spellPut("191-118", "zong");
		spellPut("191-119", "lei");
		spellPut("191-120", "zhuan,juan");
		spellPut("191-121", "qian");
		spellPut("191-122", "man");
		spellPut("191-123", "zhi");
		spellPut("191-124", "lv");
		spellPut("191-125", "mu,mo");
		spellPut("191-126", "piao");
		spellPut("191-128", "lian");
		spellPut("191-129", "xuan");
		spellPut("191-130", "zong");
		spellPut("191-131", "ji");
		spellPut("191-132", "shan");
		spellPut("191-133", "sui");
		spellPut("191-134", "lv");
		spellPut("191-135", "beng");
		spellPut("191-136", "yi");
		spellPut("191-137", "sao");
		spellPut("191-138", "mou,miu,miao,mu,liao");
		spellPut("191-139", "qiang");
		spellPut("191-140", "sheng");
		spellPut("191-141", "xian");
		spellPut("191-142", "ji");
		spellPut("191-143", "zong");
		spellPut("191-144", "xiu");
		spellPut("191-145", "ran");
		spellPut("191-146", "xuan");
		spellPut("191-147", "sui");
		spellPut("191-148", "qiao");
		spellPut("191-149", "zeng");
		spellPut("191-150", "zuo");
		spellPut("191-151", "zhi");
		spellPut("191-152", "shan");
		spellPut("191-153", "san");
		spellPut("191-154", "lin");
		spellPut("191-155", "ju,jue");
		spellPut("191-156", "fan");
		spellPut("191-157", "liao");
		spellPut("191-158", "chuo");
		spellPut("191-159", "zun");
		spellPut("191-160", "jian");
		spellPut("191-161", "jun");
		spellPut("191-162", "jun");
		spellPut("191-163", "jun,xun");
		spellPut("191-164", "jun");
		spellPut("191-165", "jun");
		spellPut("191-166", "ka");
		spellPut("191-167", "ka,ga");
		spellPut("191-168", "qia,ka");
		spellPut("191-169", "ka,luo,lo,ge");
		spellPut("191-170", "kai");
		spellPut("191-171", "kai");
		spellPut("191-172", "kai,jie");
		spellPut("191-173", "kai");
		spellPut("191-174", "kai");
		spellPut("191-175", "kan");
		spellPut("191-176", "kan");
		spellPut("191-177", "kan");
		spellPut("191-178", "kan");
		spellPut("191-179", "kan");
		spellPut("191-180", "kan");
		spellPut("191-181", "kang");
		spellPut("191-182", "kang");
		spellPut("191-183", "kang");
		spellPut("191-184", "kang,gang");
		spellPut("191-185", "kang");
		spellPut("191-186", "kang");
		spellPut("191-187", "kang");
		spellPut("191-188", "kao");
		spellPut("191-189", "kao");
		spellPut("191-190", "kao");
		spellPut("191-191", "kao");
		spellPut("191-192", "ke");
		spellPut("191-193", "ke,he");
		spellPut("191-194", "ke");
		spellPut("191-195", "ke");
		spellPut("191-196", "ke");
		spellPut("191-197", "ke");
		spellPut("191-198", "ke");
		spellPut("191-199", "ke,qiao");
		spellPut("191-200", "ke,hai");
		spellPut("191-201", "ke");
		spellPut("191-202", "ke");
		spellPut("191-203", "ke");
		spellPut("191-204", "ke");
		spellPut("191-205", "ke");
		spellPut("191-206", "ke");
		spellPut("191-207", "ken");
		spellPut("191-208", "ken");
		spellPut("191-209", "ken");
		spellPut("191-210", "ken");
		spellPut("191-211", "keng");
		spellPut("191-212", "hang,keng");
		spellPut("191-213", "kong");
		spellPut("191-214", "kong");
		spellPut("191-215", "kong");
		spellPut("191-216", "kong");
		spellPut("191-217", "kou");
		spellPut("191-218", "kou");
		spellPut("191-219", "kou");
		spellPut("191-220", "kou");
		spellPut("191-221", "ku");
		spellPut("191-222", "ku");
		spellPut("191-223", "ku");
		spellPut("191-224", "ku");
		spellPut("191-225", "ku");
		spellPut("191-226", "ku");
		spellPut("191-227", "ku");
		spellPut("191-228", "kua");
		spellPut("191-229", "kua");
		spellPut("191-230", "kua,ku");
		spellPut("191-231", "kua");
		spellPut("191-232", "kua");
		spellPut("191-233", "kuai");
		spellPut("191-234", "kuai");
		spellPut("191-235", "kuai");
		spellPut("191-236", "kuai");
		spellPut("191-237", "kuan");
		spellPut("191-238", "kuan");
		spellPut("191-239", "kuang");
		spellPut("191-240", "kuang");
		spellPut("191-241", "kuang");
		spellPut("191-242", "kuang");
		spellPut("191-243", "kuang");
		spellPut("191-244", "kuang");
		spellPut("191-245", "kuang");
		spellPut("191-246", "kuang");
		spellPut("191-247", "kui");
		spellPut("191-248", "kui");
		spellPut("191-249", "kui");
		spellPut("191-250", "kui");
		spellPut("191-251", "kui");
		spellPut("191-252", "kui");
		spellPut("191-253", "kui");
		spellPut("191-254", "kui,gui");
	}

	private static void init54() {
		spellPut("192-64", "rao");
		spellPut("192-65", "chan");
		spellPut("192-66", "rui");
		spellPut("192-67", "xiu");
		spellPut("192-68", "hui");
		spellPut("192-69", "hua");
		spellPut("192-70", "zuan");
		spellPut("192-71", "xi");
		spellPut("192-72", "qiang");
		spellPut("192-73", "wen");
		spellPut("192-74", "dB");
		spellPut("192-75", "sheng");
		spellPut("192-76", "hui");
		spellPut("192-77", "xi,ji");
		spellPut("192-78", "se");
		spellPut("192-79", "jian");
		spellPut("192-80", "jiang");
		spellPut("192-81", "huan");
		spellPut("192-82", "qiao,sao");
		spellPut("192-83", "cong");
		spellPut("192-84", "xie");
		spellPut("192-85", "jiao,zhuo");
		spellPut("192-86", "bi");
		spellPut("192-87", "dan,tan,chan");
		spellPut("192-88", "yi");
		spellPut("192-89", "nong");
		spellPut("192-90", "sui");
		spellPut("192-91", "yi");
		spellPut("192-92", "sha");
		spellPut("192-93", "ru");
		spellPut("192-94", "ji");
		spellPut("192-95", "bin");
		spellPut("192-96", "qian");
		spellPut("192-97", "lan");
		spellPut("192-98", "pu,fu");
		spellPut("192-99", "xun");
		spellPut("192-100", "zi");
		spellPut("192-101", "peng");
		spellPut("192-102", "yao,li");
		spellPut("192-103", "mo");
		spellPut("192-104", "lei");
		spellPut("192-105", "xie");
		spellPut("192-106", "zuan");
		spellPut("192-107", "kuang");
		spellPut("192-108", "you");
		spellPut("192-109", "xu");
		spellPut("192-110", "lei");
		spellPut("192-111", "xian");
		spellPut("192-112", "chan");
		spellPut("192-113", "ko o");
		spellPut("192-114", "lu");
		spellPut("192-115", "chan");
		spellPut("192-116", "ying");
		spellPut("192-117", "cai");
		spellPut("192-118", "xiang,rang");
		spellPut("192-119", "xian");
		spellPut("192-120", "zui");
		spellPut("192-121", "zuan");
		spellPut("192-122", "luo");
		spellPut("192-123", "li,xi,sa");
		spellPut("192-124", "lan");
		spellPut("192-125", "lei");
		spellPut("192-126", "lian");
		spellPut("192-128", "hong");
		spellPut("192-129", "ren");
		spellPut("192-130", "zhu");
		spellPut("192-131", "zhen");
		spellPut("192-132", "die");
		spellPut("192-133", "xi");
		spellPut("192-134", "ying");
		spellPut("192-135", "tao");
		spellPut("192-136", "yun,wen");
		spellPut("192-137", "xian");
		spellPut("192-138", "cui,sui,shuai");
		spellPut("192-139", "xie");
		spellPut("192-140", "fou");
		spellPut("192-141", "fou");
		spellPut("192-142", "que");
		spellPut("192-143", "bo");
		spellPut("192-144", "ping");
		spellPut("192-145", "xiang");
		spellPut("192-146", "zhBo te yo");
		spellPut("192-147", "gang");
		spellPut("192-148", "ying");
		spellPut("192-149", "guan");
		spellPut("192-150", "zun");
		spellPut("192-151", "tan");
		spellPut("192-152", "cheng");
		spellPut("192-153", "qi");
		spellPut("192-154", "weng");
		spellPut("192-155", "ying");
		spellPut("192-156", "lei");
		spellPut("192-157", "tan");
		spellPut("192-158", "lu");
		spellPut("192-159", "wang");
		spellPut("192-160", "wang");
		spellPut("192-161", "kui");
		spellPut("192-162", "kui");
		spellPut("192-163", "kui,hui");
		spellPut("192-164", "kun");
		spellPut("192-165", "kun");
		spellPut("192-166", "kun");
		spellPut("192-167", "kun");
		spellPut("192-168", "kuo,gua");
		spellPut("192-169", "kuo");
		spellPut("192-170", "kuo");
		spellPut("192-171", "kuo");
		spellPut("192-172", "la");
		spellPut("192-173", "la");
		spellPut("192-174", "la");
		spellPut("192-175", "la");
		spellPut("192-176", "xi");
		spellPut("192-177", "la");
		spellPut("192-178", "lB,la");
		spellPut("192-179", "lai");
		spellPut("192-180", "lai");
		spellPut("192-181", "lai");
		spellPut("192-182", "lan");
		spellPut("192-183", "lan");
		spellPut("192-184", "lan");
		spellPut("192-185", "lan");
		spellPut("192-186", "lan");
		spellPut("192-187", "lan");
		spellPut("192-188", "lan");
		spellPut("192-189", "lan");
		spellPut("192-190", "lan");
		spellPut("192-191", "lan");
		spellPut("192-192", "lan");
		spellPut("192-193", "lan");
		spellPut("192-194", "lan");
		spellPut("192-195", "lan");
		spellPut("192-196", "lan");
		spellPut("192-197", "lang");
		spellPut("192-198", "lang");
		spellPut("192-199", "lang");
		spellPut("192-200", "lang");
		spellPut("192-201", "lang");
		spellPut("192-202", "lang");
		spellPut("192-203", "lang");
		spellPut("192-204", "lao");
		spellPut("192-205", "lao");
		spellPut("192-206", "lao");
		spellPut("192-207", "lao");
		spellPut("192-208", "lao");
		spellPut("192-209", "mu,lao");
		spellPut("192-210", "lao");
		spellPut("192-211", "lao,luo");
		spellPut("192-212", "lao");
		spellPut("192-213", "le,lei");
		spellPut("192-214", "le,yue");
		spellPut("192-215", "lei");
		spellPut("192-216", "lei");
		spellPut("192-217", "lei");
		spellPut("192-218", "lei");
		spellPut("192-219", "lei");
		spellPut("192-220", "lei");
		spellPut("192-221", "lei");
		spellPut("192-222", "lei");
		spellPut("192-223", "lei,le");
		spellPut("192-224", "lei");
		spellPut("192-225", "lei");
		spellPut("192-226", "leng,ling");
		spellPut("192-227", "leng");
		spellPut("192-228", "leng");
		spellPut("192-229", "li");
		spellPut("192-230", "li");
		spellPut("192-231", "li");
		spellPut("192-232", "li");
		spellPut("192-233", "li");
		spellPut("192-234", "li");
		spellPut("192-235", "li");
		spellPut("192-236", "li");
		spellPut("192-237", "li");
		spellPut("192-238", "li");
		spellPut("192-239", "li");
		spellPut("192-240", "li");
		spellPut("192-241", "li");
		spellPut("192-242", "li");
		spellPut("192-243", "li");
		spellPut("192-244", "li");
		spellPut("192-245", "li");
		spellPut("192-246", "li");
		spellPut("192-247", "li");
		spellPut("192-248", "li");
		spellPut("192-249", "li");
		spellPut("192-250", "li");
		spellPut("192-251", "li");
		spellPut("192-252", "li");
		spellPut("192-253", "li");
		spellPut("192-254", "li");
	}

	private static void init55() {
		spellPut("193-64", "rB");
		spellPut("193-65", "shen");
		spellPut("193-66", "gu");
		spellPut("193-67", "zhu");
		spellPut("193-68", "ju");
		spellPut("193-69", "mao");
		spellPut("193-70", "min");
		spellPut("193-71", "gua");
		spellPut("193-72", "ti");
		spellPut("193-73", "juan");
		spellPut("193-74", "fu");
		spellPut("193-75", "shen");
		spellPut("193-76", "guai,gua");
		spellPut("193-77", "zhuo");
		spellPut("193-78", "yu");
		spellPut("193-79", "an");
		spellPut("193-80", "fa");
		spellPut("193-81", "si");
		spellPut("193-82", "ma");
		spellPut("193-83", "liu");
		spellPut("193-84", "ba,bB,pi");
		spellPut("193-85", "fa");
		spellPut("193-86", "chao");
		spellPut("193-87", "wei");
		spellPut("193-88", "bi");
		spellPut("193-89", "ji");
		spellPut("193-90", "chong");
		spellPut("193-91", "liu");
		spellPut("193-92", "juan");
		spellPut("193-93", "mi");
		spellPut("193-94", "zhao");
		spellPut("193-95", "luo");
		spellPut("193-96", "pi");
		spellPut("193-97", "ji");
		spellPut("193-98", "ji");
		spellPut("193-99", "luan");
		spellPut("193-100", "mi");
		spellPut("193-101", "da");
		spellPut("193-102", "yang,xiang");
		spellPut("193-103", "ling");
		spellPut("193-104", "you");
		spellPut("193-105", "fen");
		spellPut("193-106", "ba");
		spellPut("193-107", "yang");
		spellPut("193-108", "gu");
		spellPut("193-109", "qiang");
		spellPut("193-110", "zang");
		spellPut("193-111", "mei,gao");
		spellPut("193-112", "yi,xi");
		spellPut("193-113", "zhu");
		spellPut("193-114", "yi");
		spellPut("193-115", "rong");
		spellPut("193-116", "qun");
		spellPut("193-117", "qiang");
		spellPut("193-118", "huan");
		spellPut("193-119", "xian");
		spellPut("193-120", "yi");
		spellPut("193-121", "you");
		spellPut("193-122", "qiang,kong");
		spellPut("193-123", "qian,xian,yan");
		spellPut("193-124", "yu");
		spellPut("193-125", "geng");
		spellPut("193-126", "yuan");
		spellPut("193-128", "fan");
		spellPut("193-129", "shan");
		spellPut("193-130", "fen");
		spellPut("193-131", "shan");
		spellPut("193-132", "lian");
		spellPut("193-133", "nou");
		spellPut("193-134", "qiang");
		spellPut("193-135", "hong,gong");
		spellPut("193-136", "chong");
		spellPut("193-137", "fen");
		spellPut("193-138", "hong");
		spellPut("193-139", "chi");
		spellPut("193-140", "cui");
		spellPut("193-141", "fu");
		spellPut("193-142", "xia");
		spellPut("193-143", "ben");
		spellPut("193-144", "la");
		spellPut("193-145", "pi,bi,po");
		spellPut("193-146", "liu");
		spellPut("193-147", "zhi");
		spellPut("193-148", "qu,yu");
		spellPut("193-149", "xi");
		spellPut("193-150", "xie");
		spellPut("193-151", "xi");
		spellPut("193-152", "ke");
		spellPut("193-153", "hui");
		spellPut("193-154", "hui");
		spellPut("193-155", "xiao");
		spellPut("193-156", "sha");
		spellPut("193-157", "hong");
		spellPut("193-158", "jiang");
		spellPut("193-159", "dao,zhou");
		spellPut("193-160", "sha");
		spellPut("193-161", "li");
		spellPut("193-162", "li");
		spellPut("193-163", "li");
		spellPut("193-164", "li");
		spellPut("193-165", "li,dai");
		spellPut("193-166", "li");
		spellPut("193-167", "li");
		spellPut("193-168", "li");
		spellPut("193-169", "liang,lia");
		spellPut("193-170", "lian");
		spellPut("193-171", "lian");
		spellPut("193-172", "lian");
		spellPut("193-173", "lian");
		spellPut("193-174", "lian");
		spellPut("193-175", "lian");
		spellPut("193-176", "lian");
		spellPut("193-177", "lian");
		spellPut("193-178", "lian");
		spellPut("193-179", "lian");
		spellPut("193-180", "lian");
		spellPut("193-181", "lian");
		spellPut("193-182", "lian");
		spellPut("193-183", "lian");
		spellPut("193-184", "liang");
		spellPut("193-185", "liang");
		spellPut("193-186", "liang");
		spellPut("193-187", "liang");
		spellPut("193-188", "liang");
		spellPut("193-189", "liang");
		spellPut("193-190", "liang");
		spellPut("193-191", "liang");
		spellPut("193-192", "liang");
		spellPut("193-193", "liang");
		spellPut("193-194", "liang");
		spellPut("193-195", "liao");
		spellPut("193-196", "liao");
		spellPut("193-197", "liao");
		spellPut("193-198", "liao");
		spellPut("193-199", "liao");
		spellPut("193-200", "liao");
		spellPut("193-201", "liao");
		spellPut("193-202", "lao,liao");
		spellPut("193-203", "liao,le");
		spellPut("193-204", "liao");
		spellPut("193-205", "liao");
		spellPut("193-206", "liao");
		spellPut("193-207", "liao");
		spellPut("193-208", "lie");
		spellPut("193-209", "lie");
		spellPut("193-210", "lie");
		spellPut("193-211", "lie");
		spellPut("193-212", "lie");
		spellPut("193-213", "lin");
		spellPut("193-214", "lin");
		spellPut("193-215", "lin");
		spellPut("193-216", "lin");
		spellPut("193-217", "lin");
		spellPut("193-218", "lin");
		spellPut("193-219", "lin");
		spellPut("193-220", "lin");
		spellPut("193-221", "lin");
		spellPut("193-222", "lin");
		spellPut("193-223", "lin");
		spellPut("193-224", "lin");
		spellPut("193-225", "ling");
		spellPut("193-226", "ling");
		spellPut("193-227", "ling");
		spellPut("193-228", "ling");
		spellPut("193-229", "ling");
		spellPut("193-230", "ling");
		spellPut("193-231", "ling");
		spellPut("193-232", "ling");
		spellPut("193-233", "ling");
		spellPut("193-234", "ling");
		spellPut("193-235", "ling");
		spellPut("193-236", "ling");
		spellPut("193-237", "ling");
		spellPut("193-238", "ling");
		spellPut("193-239", "liu");
		spellPut("193-240", "liu");
		spellPut("193-241", "liu");
		spellPut("193-242", "liu");
		spellPut("193-243", "liu");
		spellPut("193-244", "liu");
		spellPut("193-245", "liu");
		spellPut("193-246", "liu");
		spellPut("193-247", "liu");
		spellPut("193-248", "liu");
		spellPut("193-249", "liu,lu");
		spellPut("193-250", "long");
		spellPut("193-251", "long");
		spellPut("193-252", "long");
		spellPut("193-253", "long");
		spellPut("193-254", "long");
	}

	private static void init56() {
		spellPut("194-64", "chi");
		spellPut("194-65", "xuan");
		spellPut("194-66", "chi");
		spellPut("194-67", "zong");
		spellPut("194-68", "wan");
		spellPut("194-69", "hui");
		spellPut("194-70", "hou");
		spellPut("194-71", "he");
		spellPut("194-72", "piao");
		spellPut("194-73", "lian");
		spellPut("194-74", "hou,qu");
		spellPut("194-75", "ao");
		spellPut("194-76", "lin");
		spellPut("194-77", "pen");
		spellPut("194-78", "qiao");
		spellPut("194-79", "ao");
		spellPut("194-80", "hui");
		spellPut("194-81", "xuan");
		spellPut("194-82", "dao");
		spellPut("194-83", "lao");
		spellPut("194-84", "gou");
		spellPut("194-85", "gou");
		spellPut("194-86", "gou");
		spellPut("194-87", "die");
		spellPut("194-88", "ruan,nuo");
		spellPut("194-89", "er,nai");
		spellPut("194-90", "duan,zhuan");
		spellPut("194-91", "ting");
		spellPut("194-92", "pi");
		spellPut("194-93", "si,chi");
		spellPut("194-94", "qu,chu");
		spellPut("194-95", "jia");
		spellPut("194-96", "ju");
		spellPut("194-97", "chu");
		spellPut("194-98", "lun");
		spellPut("194-99", "ji,jie");
		spellPut("194-100", "zha,ze");
		spellPut("194-101", "lou");
		spellPut("194-102", "ji");
		spellPut("194-103", "lao");
		spellPut("194-104", "huo");
		spellPut("194-105", "you");
		spellPut("194-106", "huai");
		spellPut("194-107", "yi");
		spellPut("194-108", "qin");
		spellPut("194-109", "yun,ying");
		spellPut("194-110", "dan");
		spellPut("194-111", "hong");
		spellPut("194-112", "zhi");
		spellPut("194-113", "uu");
		spellPut("194-114", "zhen");
		spellPut("194-115", "che");
		spellPut("194-116", "zheng");
		spellPut("194-117", "you");
		spellPut("194-118", "wa,tui,zhuo");
		spellPut("194-119", "tiao");
		spellPut("194-120", "er,nv");
		spellPut("194-121", "ya");
		spellPut("194-122", "tie,zhe");
		spellPut("194-123", "xu");
		spellPut("194-124", "hao");
		spellPut("194-125", "sheng");
		spellPut("194-126", "lie");
		spellPut("194-128", "jing");
		spellPut("194-129", "bi");
		spellPut("194-130", "di,zhi");
		spellPut("194-131", "guo");
		spellPut("194-132", "wen");
		spellPut("194-133", "xu");
		spellPut("194-134", "ping");
		spellPut("194-135", "cong");
		spellPut("194-136", "xi ka li");
		spellPut("194-137", "ni");
		spellPut("194-138", "ting");
		spellPut("194-139", "ju");
		spellPut("194-140", "cong");
		spellPut("194-141", "kui");
		spellPut("194-142", "lian");
		spellPut("194-143", "lian");
		spellPut("194-144", "weng");
		spellPut("194-145", "kui");
		spellPut("194-146", "lian");
		spellPut("194-147", "lian");
		spellPut("194-148", "cong");
		spellPut("194-149", "sheng");
		spellPut("194-150", "song");
		spellPut("194-151", "ting");
		spellPut("194-152", "kui");
		spellPut("194-153", "nie");
		spellPut("194-154", "zhi");
		spellPut("194-155", "dan");
		spellPut("194-156", "ning");
		spellPut("194-157", "qie");
		spellPut("194-158", "ni,jian");
		spellPut("194-159", "ting");
		spellPut("194-160", "ting");
		spellPut("194-161", "long");
		spellPut("194-162", "long");
		spellPut("194-163", "long");
		spellPut("194-164", "long");
		spellPut("194-165", "lou");
		spellPut("194-166", "lou");
		spellPut("194-167", "lou");
		spellPut("194-168", "lou");
		spellPut("194-169", "lou");
		spellPut("194-170", "lou");
		spellPut("194-171", "lu");
		spellPut("194-172", "lu");
		spellPut("194-173", "lu");
		spellPut("194-174", "lu");
		spellPut("194-175", "lu");
		spellPut("194-176", "lu");
		spellPut("194-177", "lu");
		spellPut("194-178", "lu");
		spellPut("194-179", "lu");
		spellPut("194-180", "lu");
		spellPut("194-181", "lu,liu");
		spellPut("194-182", "lu");
		spellPut("194-183", "lu");
		spellPut("194-184", "lu");
		spellPut("194-185", "lu");
		spellPut("194-186", "lu");
		spellPut("194-187", "lu");
		spellPut("194-188", "lu");
		spellPut("194-189", "lu");
		spellPut("194-190", "lu");
		spellPut("194-191", "lv");
		spellPut("194-192", "lv");
		spellPut("194-193", "lv");
		spellPut("194-194", "lv");
		spellPut("194-195", "lv");
		spellPut("194-196", "lv");
		spellPut("194-197", "lv");
		spellPut("194-198", "lv");
		spellPut("194-199", "lv");
		spellPut("194-200", "lv");
		spellPut("194-201", "lv");
		spellPut("194-202", "shuai,lv");
		spellPut("194-203", "lv");
		spellPut("194-204", "lv,lu");
		spellPut("194-205", "luan");
		spellPut("194-206", "luan");
		spellPut("194-207", "luan");
		spellPut("194-208", "luan");
		spellPut("194-209", "luan");
		spellPut("194-210", "luan");
		spellPut("194-211", "l<e");
		spellPut("194-212", "l<e");
		spellPut("194-213", "lun");
		spellPut("194-214", "lun");
		spellPut("194-215", "lun");
		spellPut("194-216", "lun");
		spellPut("194-217", "lun");
		spellPut("194-218", "lun,guan");
		spellPut("194-219", "lun");
		spellPut("194-220", "luo");
		spellPut("194-221", "luo");
		spellPut("194-222", "luo");
		spellPut("194-223", "luo");
		spellPut("194-224", "luo");
		spellPut("194-225", "luo");
		spellPut("194-226", "luo");
		spellPut("194-227", "luo");
		spellPut("194-228", "luo");
		spellPut("194-229", "luo");
		spellPut("194-230", "luo");
		spellPut("194-231", "luo,lao");
		spellPut("194-232", "ma");
		spellPut("194-233", "ma");
		spellPut("194-234", "ma");
		spellPut("194-235", "ma");
		spellPut("194-236", "ma");
		spellPut("194-237", "ma");
		spellPut("194-238", "ma");
		spellPut("194-239", "mB");
		spellPut("194-240", "ma,mB");
		spellPut("194-241", "mai,man");
		spellPut("194-242", "mai");
		spellPut("194-243", "mai");
		spellPut("194-244", "mai");
		spellPut("194-245", "mai");
		spellPut("194-246", "mai");
		spellPut("194-247", "man,men");
		spellPut("194-248", "man");
		spellPut("194-249", "man");
		spellPut("194-250", "man");
		spellPut("194-251", "wan");
		spellPut("194-252", "man");
		spellPut("194-253", "man");
		spellPut("194-254", "man");
	}

	private static void init57() {
		spellPut("195-64", "long");
		spellPut("195-65", "zhao");
		spellPut("195-66", "si");
		spellPut("195-67", "su");
		spellPut("195-68", "zhao");
		spellPut("195-69", "yi");
		spellPut("195-70", "qiu");
		spellPut("195-71", "ken");
		spellPut("195-72", "cao");
		spellPut("195-73", "ge");
		spellPut("195-74", "bo,di");
		spellPut("195-75", "huan");
		spellPut("195-76", "chi");
		spellPut("195-77", "ren");
		spellPut("195-78", "ru");
		spellPut("195-79", "yuan");
		spellPut("195-80", "chai");
		spellPut("195-81", "qin,han");
		spellPut("195-82", "ban");
		spellPut("195-83", "pei");
		spellPut("195-84", "pang,pan");
		spellPut("195-85", "you");
		spellPut("195-86", "ran");
		spellPut("195-87", "wen");
		spellPut("195-88", "qi");
		spellPut("195-89", "pi,bi");
		spellPut("195-90", "xi");
		spellPut("195-91", "xi");
		spellPut("195-92", "ken");
		spellPut("195-93", "die");
		spellPut("195-94", "fei,bi");
		spellPut("195-95", "ba");
		spellPut("195-96", "bo");
		spellPut("195-97", "qu");
		spellPut("195-98", "tian");
		spellPut("195-99", "zi,fei");
		spellPut("195-100", "fei,ku");
		spellPut("195-101", "zhi");
		spellPut("195-102", "ni");
		spellPut("195-103", "ping,peng");
		spellPut("195-104", "zi");
		spellPut("195-105", "fu,zhou");
		spellPut("195-106", "xian");
		spellPut("195-107", "mu");
		spellPut("195-108", "qu");
		spellPut("195-109", "qia");
		spellPut("195-110", "chi");
		spellPut("195-111", "yang");
		spellPut("195-112", "pang");
		spellPut("195-113", "chi");
		spellPut("195-114", "xiong");
		spellPut("195-115", "er");
		spellPut("195-116", "heng");
		spellPut("195-117", "zi");
		spellPut("195-118", "gui,kui");
		spellPut("195-119", "zheng");
		spellPut("195-120", "tiao");
		spellPut("195-121", "cui");
		spellPut("195-122", "mei");
		spellPut("195-123", "xie");
		spellPut("195-124", "xie");
		spellPut("195-125", "mai");
		spellPut("195-126", "xie");
		spellPut("195-128", "nin");
		spellPut("195-129", "wan");
		spellPut("195-130", "wen");
		spellPut("195-131", "xiu");
		spellPut("195-132", "jing");
		spellPut("195-133", "rou");
		spellPut("195-134", "heng");
		spellPut("195-135", "lie");
		spellPut("195-136", "shan");
		spellPut("195-137", "ting");
		spellPut("195-138", "mei");
		spellPut("195-139", "chun");
		spellPut("195-140", "shen");
		spellPut("195-141", "jia");
		spellPut("195-142", "de");
		spellPut("195-143", "juan");
		spellPut("195-144", "cu");
		spellPut("195-145", "xiu");
		spellPut("195-146", "xin");
		spellPut("195-147", "tuo");
		spellPut("195-148", "cheng");
		spellPut("195-149", "nei");
		spellPut("195-150", "dou");
		spellPut("195-151", "nao");
		spellPut("195-152", "pi");
		spellPut("195-153", "gu");
		spellPut("195-154", "li");
		spellPut("195-155", "zhang");
		spellPut("195-156", "cui");
		spellPut("195-157", "jie");
		spellPut("195-158", "liang");
		spellPut("195-159", "shui");
		spellPut("195-160", "biao");
		spellPut("195-161", "man");
		spellPut("195-162", "mang");
		spellPut("195-163", "mang");
		spellPut("195-164", "mang");
		spellPut("195-165", "meng,mang");
		spellPut("195-166", "mang");
		spellPut("195-167", "mang");
		spellPut("195-168", "mao");
		spellPut("195-169", "mao");
		spellPut("195-170", "mao");
		spellPut("195-171", "mao");
		spellPut("195-172", "mao");
		spellPut("195-173", "mao");
		spellPut("195-174", "mao");
		spellPut("195-175", "mao");
		spellPut("195-176", "mao,mo");
		spellPut("195-177", "mao");
		spellPut("195-178", "mao");
		spellPut("195-179", "mao");
		spellPut("195-180", "me,yao,mB");
		spellPut("195-181", "mei");
		spellPut("195-182", "mei");
		spellPut("195-183", "mei");
		spellPut("195-184", "mei");
		spellPut("195-185", "mei");
		spellPut("195-186", "mei");
		spellPut("195-187", "mei,mo");
		spellPut("195-188", "mei");
		spellPut("195-189", "mei");
		spellPut("195-190", "mei");
		spellPut("195-191", "mei");
		spellPut("195-192", "mei");
		spellPut("195-193", "mei");
		spellPut("195-194", "mei");
		spellPut("195-195", "mei");
		spellPut("195-196", "mei");
		spellPut("195-197", "men");
		spellPut("195-198", "men");
		spellPut("195-199", "men");
		spellPut("195-200", "meng");
		spellPut("195-201", "meng");
		spellPut("195-202", "meng");
		spellPut("195-203", "meng");
		spellPut("195-204", "meng");
		spellPut("195-205", "meng");
		spellPut("195-206", "meng");
		spellPut("195-207", "meng");
		spellPut("195-208", "mi");
		spellPut("195-209", "mi");
		spellPut("195-210", "mi");
		spellPut("195-211", "mi,mei");
		spellPut("195-212", "mi");
		spellPut("195-213", "mi");
		spellPut("195-214", "mi");
		spellPut("195-215", "mi");
		spellPut("195-216", "mi,bi");
		spellPut("195-217", "mi");
		spellPut("195-218", "mi,bi");
		spellPut("195-219", "mi");
		spellPut("195-220", "mi");
		spellPut("195-221", "mi");
		spellPut("195-222", "mian");
		spellPut("195-223", "mian");
		spellPut("195-224", "mian");
		spellPut("195-225", "mian");
		spellPut("195-226", "mian");
		spellPut("195-227", "mian");
		spellPut("195-228", "mian");
		spellPut("195-229", "mian");
		spellPut("195-230", "mian");
		spellPut("195-231", "miao");
		spellPut("195-232", "miao");
		spellPut("195-233", "miao");
		spellPut("195-234", "miao");
		spellPut("195-235", "miao");
		spellPut("195-236", "miao");
		spellPut("195-237", "miao");
		spellPut("195-238", "miao");
		spellPut("195-239", "mie");
		spellPut("195-240", "mie");
		spellPut("195-241", "min");
		spellPut("195-242", "min");
		spellPut("195-243", "min");
		spellPut("195-244", "min");
		spellPut("195-245", "min");
		spellPut("195-246", "min");
		spellPut("195-247", "ming");
		spellPut("195-248", "ming");
		spellPut("195-249", "ming");
		spellPut("195-250", "ming");
		spellPut("195-251", "ming");
		spellPut("195-252", "ming");
		spellPut("195-253", "miu");
		spellPut("195-254", "mo");
	}

	private static void init58() {
		spellPut("196-64", "lun");
		spellPut("196-65", "pian");
		spellPut("196-66", "guo");
		spellPut("196-67", "juan");
		spellPut("196-68", "chui");
		spellPut("196-69", "dan");
		spellPut("196-70", "nei");
		spellPut("196-71", "nai");
		spellPut("196-72", "ren");
		spellPut("196-73", "shen");
		spellPut("196-74", "zhui");
		spellPut("196-75", "ju");
		spellPut("196-76", "dong");
		spellPut("196-77", "pi");
		spellPut("196-78", "guo");
		spellPut("196-79", "wo");
		spellPut("196-80", "mei");
		spellPut("196-81", "ruan");
		spellPut("196-82", "zhuan");
		spellPut("196-83", "chi");
		spellPut("196-84", "luo");
		spellPut("196-85", "ou");
		spellPut("196-86", "di");
		spellPut("196-87", "an");
		spellPut("196-88", "nao");
		spellPut("196-89", "shuan");
		spellPut("196-90", "yun");
		spellPut("196-91", "zhong");
		spellPut("196-92", "rou");
		spellPut("196-93", "tu");
		spellPut("196-94", "wei");
		spellPut("196-95", "jiao");
		spellPut("196-96", "jia");
		spellPut("196-97", "duan");
		spellPut("196-98", "bi");
		spellPut("196-99", "chang");
		spellPut("196-100", "qian");
		spellPut("196-101", "wa");
		spellPut("196-102", "shou");
		spellPut("196-103", "tang");
		spellPut("196-104", "su");
		spellPut("196-105", "zhui");
		spellPut("196-106", "yi");
		spellPut("196-107", "liao");
		spellPut("196-108", "ji");
		spellPut("196-109", "pi");
		spellPut("196-110", "xie");
		spellPut("196-111", "lv");
		spellPut("196-112", "ou");
		spellPut("196-113", "chang");
		spellPut("196-114", "lu,biao");
		spellPut("196-115", "guo");
		spellPut("196-116", "pang");
		spellPut("196-117", "chuai");
		spellPut("196-118", "jiang");
		spellPut("196-119", "fu");
		spellPut("196-120", "zhuan,chuan,chun");
		spellPut("196-121", "lv");
		spellPut("196-122", "jiao");
		spellPut("196-123", "ying");
		spellPut("196-124", "lv");
		spellPut("196-125", "xue");
		spellPut("196-126", "cun");
		spellPut("196-128", "tong");
		spellPut("196-129", "ni");
		spellPut("196-130", "liao");
		spellPut("196-131", "cui");
		spellPut("196-132", "kui");
		spellPut("196-133", "xiao");
		spellPut("196-134", "teng");
		spellPut("196-135", "fan,pan");
		spellPut("196-136", "zhi");
		spellPut("196-137", "jiao");
		spellPut("196-138", "hu,wu");
		spellPut("196-139", "cui");
		spellPut("196-140", "run");
		spellPut("196-141", "xiang");
		spellPut("196-142", "sui");
		spellPut("196-143", "fen");
		spellPut("196-144", "zhua");
		spellPut("196-145", "dan");
		spellPut("196-146", "kuai");
		spellPut("196-147", "nong");
		spellPut("196-148", "jue");
		spellPut("196-149", "chu");
		spellPut("196-150", "juan");
		spellPut("196-151", "la,ge");
		spellPut("196-152", "lian");
		spellPut("196-153", "tun");
		spellPut("196-154", "qi");
		spellPut("196-155", "cui");
		spellPut("196-156", "bin");
		spellPut("196-157", "xun");
		spellPut("196-158", "nao");
		spellPut("196-159", "wo,yue");
		spellPut("196-160", "zang");
		spellPut("196-161", "mo");
		spellPut("196-162", "mo");
		spellPut("196-163", "mo,mu");
		spellPut("196-164", "mo");
		spellPut("196-165", "mo");
		spellPut("196-166", "mo,ma");
		spellPut("196-167", "mo");
		spellPut("196-168", "mo,ma");
		spellPut("196-169", "mo");
		spellPut("196-170", "mo,mu");
		spellPut("196-171", "mo");
		spellPut("196-172", "mo");
		spellPut("196-173", "mo");
		spellPut("196-174", "mo");
		spellPut("196-175", "mo");
		spellPut("196-176", "mo");
		spellPut("196-177", "mou");
		spellPut("196-178", "mou,mu");
		spellPut("196-179", "mou");
		spellPut("196-180", "mu");
		spellPut("196-181", "mu");
		spellPut("196-182", "mu");
		spellPut("196-183", "mu");
		spellPut("196-184", "mu");
		spellPut("196-185", "mu");
		spellPut("196-186", "mu");
		spellPut("196-187", "mu");
		spellPut("196-188", "mu");
		spellPut("196-189", "mu");
		spellPut("196-190", "mu");
		spellPut("196-191", "mu");
		spellPut("196-192", "mu");
		spellPut("196-193", "mu");
		spellPut("196-194", "mu");
		spellPut("196-195", "na");
		spellPut("196-196", "na,nei,nB,ne");
		spellPut("196-197", "na,ne");
		spellPut("196-198", "na");
		spellPut("196-199", "na,nei");
		spellPut("196-200", "na,nuo");
		spellPut("196-201", "na");
		spellPut("196-202", "nai");
		spellPut("196-203", "nai");
		spellPut("196-204", "nai");
		spellPut("196-205", "nai");
		spellPut("196-206", "nai");
		spellPut("196-207", "nan,na");
		spellPut("196-208", "nan");
		spellPut("196-209", "nan,nuo");
		spellPut("196-210", "nang");
		spellPut("196-211", "nao");
		spellPut("196-212", "nao");
		spellPut("196-213", "nao");
		spellPut("196-214", "nao");
		spellPut("196-215", "nao,chuo,zhuo");
		spellPut("196-216", "ni,ne");
		spellPut("196-217", "nei");
		spellPut("196-218", "nei,na");
		spellPut("196-219", "nen");
		spellPut("196-220", "neng,nai");
		spellPut("196-221", "ni");
		spellPut("196-222", "ni");
		spellPut("196-223", "ni");
		spellPut("196-224", "ni");
		spellPut("196-225", "ni");
		spellPut("196-226", "ni");
		spellPut("196-227", "ni");
		spellPut("196-228", "ni");
		spellPut("196-229", "ni");
		spellPut("196-230", "ni");
		spellPut("196-231", "ni,niao");
		spellPut("196-232", "nian");
		spellPut("196-233", "nian");
		spellPut("196-234", "nian");
		spellPut("196-235", "nian");
		spellPut("196-236", "nian");
		spellPut("196-237", "nian,nie");
		spellPut("196-238", "nian");
		spellPut("196-239", "niang");
		spellPut("196-240", "niang");
		spellPut("196-241", "niao");
		spellPut("196-242", "niao,sui");
		spellPut("196-243", "nie");
		spellPut("196-244", "nie");
		spellPut("196-245", "nie");
		spellPut("196-246", "nie");
		spellPut("196-247", "nie");
		spellPut("196-248", "nie");
		spellPut("196-249", "nie");
		spellPut("196-250", "nin");
		spellPut("196-251", "ning");
		spellPut("196-252", "ning");
		spellPut("196-253", "ning");
		spellPut("196-254", "ning");
	}

	private static void init59() {
		spellPut("197-64", "xian");
		spellPut("197-65", "biao");
		spellPut("197-66", "xing");
		spellPut("197-67", "kuan");
		spellPut("197-68", "la");
		spellPut("197-69", "yan");
		spellPut("197-70", "lu");
		spellPut("197-71", "huo");
		spellPut("197-72", "za");
		spellPut("197-73", "luo");
		spellPut("197-74", "qu");
		spellPut("197-75", "zang");
		spellPut("197-76", "luan");
		spellPut("197-77", "ni,luan");
		spellPut("197-78", "za");
		spellPut("197-79", "qian,xian");
		spellPut("197-80", "wo");
		spellPut("197-81", "guang,jiong");
		spellPut("197-82", "lin");
		spellPut("197-83", "guang,jiong");
		spellPut("197-84", "jiao");
		spellPut("197-85", "ji");
		spellPut("197-86", "gao");
		spellPut("197-87", "chou");
		spellPut("197-88", "mian,bian");
		spellPut("197-89", "nie");
		spellPut("197-90", "ge");
		spellPut("197-91", "jian");
		spellPut("197-92", "die,zhi");
		spellPut("197-93", "zhi,jin");
		spellPut("197-94", "xiu");
		spellPut("197-95", "tai");
		spellPut("197-96", "xian");
		spellPut("197-97", "cha");
		spellPut("197-98", "xi");
		spellPut("197-99", "yu");
		spellPut("197-100", "xing");
		spellPut("197-101", "ju");
		spellPut("197-102", "jiu");
		spellPut("197-103", "xin");
		spellPut("197-104", "she");
		spellPut("197-105", "jiu");
		spellPut("197-106", "tan");
		spellPut("197-107", "shi");
		spellPut("197-108", "tan");
		spellPut("197-109", "pu");
		spellPut("197-110", "pu");
		spellPut("197-111", "guan");
		spellPut("197-112", "hua");
		spellPut("197-113", "tian");
		spellPut("197-114", "xia");
		spellPut("197-115", "dao");
		spellPut("197-116", "fan");
		spellPut("197-117", "pa");
		spellPut("197-118", "tai");
		spellPut("197-119", "fan");
		spellPut("197-120", "chuan");
		spellPut("197-121", "lu");
		spellPut("197-122", "ling");
		spellPut("197-123", "xia");
		spellPut("197-124", "qiong");
		spellPut("197-125", "pang");
		spellPut("197-126", "kuB");
		spellPut("197-128", "fu");
		spellPut("197-129", "zao");
		spellPut("197-130", "feng");
		spellPut("197-131", "li");
		spellPut("197-132", "yu");
		spellPut("197-133", "lang");
		spellPut("197-134", "uu");
		spellPut("197-135", "bo");
		spellPut("197-136", "nian");
		spellPut("197-137", "ju");
		spellPut("197-138", "huang");
		spellPut("197-139", "ke");
		spellPut("197-140", "bian");
		spellPut("197-141", "mu");
		spellPut("197-142", "die");
		spellPut("197-143", "dao");
		spellPut("197-144", "bang");
		spellPut("197-145", "cha");
		spellPut("197-146", "yi");
		spellPut("197-147", "cang");
		spellPut("197-148", "lou");
		spellPut("197-149", "dai");
		spellPut("197-150", "so ri");
		spellPut("197-151", "yao");
		spellPut("197-152", "deng");
		spellPut("197-153", "dang");
		spellPut("197-154", "qiang");
		spellPut("197-155", "lu");
		spellPut("197-156", "yi");
		spellPut("197-157", "ji");
		spellPut("197-158", "jian");
		spellPut("197-159", "huo");
		spellPut("197-160", "qi");
		spellPut("197-161", "ning");
		spellPut("197-162", "ning");
		spellPut("197-163", "niu");
		spellPut("197-164", "niu");
		spellPut("197-165", "niu");
		spellPut("197-166", "niu");
		spellPut("197-167", "nong");
		spellPut("197-168", "nong");
		spellPut("197-169", "nong");
		spellPut("197-170", "nong,long");
		spellPut("197-171", "nu");
		spellPut("197-172", "nu");
		spellPut("197-173", "nu");
		spellPut("197-174", "nv,ru");
		spellPut("197-175", "nuan");
		spellPut("197-176", "n<e");
		spellPut("197-177", "n<e,yao");
		spellPut("197-178", "nuo");
		spellPut("197-179", "nuo");
		spellPut("197-180", "nuo");
		spellPut("197-181", "nuo");
		spellPut("197-182", "o,e");
		spellPut("197-183", "ou");
		spellPut("197-184", "ou");
		spellPut("197-185", "ou");
		spellPut("197-186", "ou");
		spellPut("197-187", "ou");
		spellPut("197-188", "ou");
		spellPut("197-189", "ou");
		spellPut("197-190", "pa");
		spellPut("197-191", "pa");
		spellPut("197-192", "pa");
		spellPut("197-193", "pa");
		spellPut("197-194", "pa");
		spellPut("197-195", "pa");
		spellPut("197-196", "pai");
		spellPut("197-197", "pai");
		spellPut("197-198", "pai");
		spellPut("197-199", "pai");
		spellPut("197-200", "pai");
		spellPut("197-201", "pai");
		spellPut("197-202", "pan");
		spellPut("197-203", "pan");
		spellPut("197-204", "pan");
		spellPut("197-205", "pan");
		spellPut("197-206", "pan");
		spellPut("197-207", "pan");
		spellPut("197-208", "pan");
		spellPut("197-209", "pan");
		spellPut("197-210", "pang");
		spellPut("197-211", "pang");
		spellPut("197-212", "pang,bang");
		spellPut("197-213", "pang");
		spellPut("197-214", "pang,pan");
		spellPut("197-215", "pao");
		spellPut("197-216", "pao");
		spellPut("197-217", "pao,bao");
		spellPut("197-218", "pao,bao");
		spellPut("197-219", "pao");
		spellPut("197-220", "pao");
		spellPut("197-221", "pao");
		spellPut("197-222", "pei");
		spellPut("197-223", "pei");
		spellPut("197-224", "pei");
		spellPut("197-225", "pei");
		spellPut("197-226", "pei");
		spellPut("197-227", "pei");
		spellPut("197-228", "pei");
		spellPut("197-229", "pei");
		spellPut("197-230", "pei");
		spellPut("197-231", "pen");
		spellPut("197-232", "pen");
		spellPut("197-233", "peng");
		spellPut("197-234", "peng");
		spellPut("197-235", "peng");
		spellPut("197-236", "peng");
		spellPut("197-237", "peng,bang");
		spellPut("197-238", "peng");
		spellPut("197-239", "peng");
		spellPut("197-240", "peng");
		spellPut("197-241", "peng");
		spellPut("197-242", "peng");
		spellPut("197-243", "peng");
		spellPut("197-244", "peng");
		spellPut("197-245", "peng");
		spellPut("197-246", "peng");
		spellPut("197-247", "pi");
		spellPut("197-248", "pi");
		spellPut("197-249", "pi");
		spellPut("197-250", "pi");
		spellPut("197-251", "pi");
		spellPut("197-252", "pi");
		spellPut("197-253", "pi");
		spellPut("197-254", "pi");
	}

	private static void init60() {
		spellPut("198-64", "lu");
		spellPut("198-65", "lu");
		spellPut("198-66", "chan");
		spellPut("198-67", "shuang");
		spellPut("198-68", "jian");
		spellPut("198-69", "ping");
		spellPut("198-70", "yan");
		spellPut("198-71", "yan");
		spellPut("198-72", "cao");
		spellPut("198-73", "le");
		spellPut("198-74", "ding");
		spellPut("198-75", "tiao");
		spellPut("198-76", "qiu");
		spellPut("198-77", "peng");
		spellPut("198-78", "yi");
		spellPut("198-79", "chai,cha");
		spellPut("198-80", "mian");
		spellPut("198-81", "gan");
		spellPut("198-82", "yu");
		spellPut("198-83", "hu,xia");
		spellPut("198-84", "zi");
		spellPut("198-85", "hui,hu");
		spellPut("198-86", "sui");
		spellPut("198-87", "zhi");
		spellPut("198-88", "tun,chun");
		spellPut("198-89", "wei");
		spellPut("198-90", "qi");
		spellPut("198-91", "wen");
		spellPut("198-92", "ren");
		spellPut("198-93", "fu");
		spellPut("198-94", "xu,zhu");
		spellPut("198-95", "lun,hua");
		spellPut("198-96", "jue");
		spellPut("198-97", "gou");
		spellPut("198-98", "ao");
		spellPut("198-99", "chu");
		spellPut("198-100", "mao");
		spellPut("198-101", "reng");
		spellPut("198-102", "hang");
		spellPut("198-103", "chan,yin");
		spellPut("198-104", "you");
		spellPut("198-105", "yi");
		spellPut("198-106", "su sa");
		spellPut("198-107", "pi");
		spellPut("198-108", "di,ti");
		spellPut("198-109", "di");
		spellPut("198-110", "li,ji");
		spellPut("198-111", "yong");
		spellPut("198-112", "bei");
		spellPut("198-113", "yi");
		spellPut("198-114", "zhu,ning");
		spellPut("198-115", "ni");
		spellPut("198-116", "pa,bo");
		spellPut("198-117", "bing");
		spellPut("198-118", "xiu");
		spellPut("198-119", "yao");
		spellPut("198-120", "xian");
		spellPut("198-121", "hong");
		spellPut("198-122", "zuo,zha");
		spellPut("198-123", "dong");
		spellPut("198-124", "die");
		spellPut("198-125", "nie");
		spellPut("198-126", "hu");
		spellPut("198-128", "mei");
		spellPut("198-129", "sheng,rui");
		spellPut("198-130", "gu");
		spellPut("198-131", "bi");
		spellPut("198-132", "wei");
		spellPut("198-133", "fu");
		spellPut("198-134", "zi");
		spellPut("198-135", "zhi");
		spellPut("198-136", "ji");
		spellPut("198-137", "cong");
		spellPut("198-138", "yuan");
		spellPut("198-139", "xue");
		spellPut("198-140", "ge");
		spellPut("198-141", "li");
		spellPut("198-142", "rong");
		spellPut("198-143", "chai");
		spellPut("198-144", "chen");
		spellPut("198-145", "yu");
		spellPut("198-146", "hao");
		spellPut("198-147", "zi");
		spellPut("198-148", "lie");
		spellPut("198-149", "wu");
		spellPut("198-150", "ji");
		spellPut("198-151", "gui");
		spellPut("198-152", "ci");
		spellPut("198-153", "hou");
		spellPut("198-154", "guang");
		spellPut("198-155", "jiao");
		spellPut("198-156", "yu");
		spellPut("198-157", "zi");
		spellPut("198-158", "fa");
		spellPut("198-159", "mang");
		spellPut("198-160", "zhong");
		spellPut("198-161", "pi");
		spellPut("198-162", "pi");
		spellPut("198-163", "pi");
		spellPut("198-164", "pi");
		spellPut("198-165", "pi");
		spellPut("198-166", "pi");
		spellPut("198-167", "pi");
		spellPut("198-168", "pi");
		spellPut("198-169", "pi");
		spellPut("198-170", "pian");
		spellPut("198-171", "pian");
		spellPut("198-172", "pian");
		spellPut("198-173", "pian");
		spellPut("198-174", "piao");
		spellPut("198-175", "piao");
		spellPut("198-176", "piao");
		spellPut("198-177", "piao");
		spellPut("198-178", "pie");
		spellPut("198-179", "pie");
		spellPut("198-180", "pin");
		spellPut("198-181", "pin,bin");
		spellPut("198-182", "pin");
		spellPut("198-183", "pin");
		spellPut("198-184", "pin");
		spellPut("198-185", "ping");
		spellPut("198-186", "ping");
		spellPut("198-187", "ping,peng");
		spellPut("198-188", "ping");
		spellPut("198-189", "ping");
		spellPut("198-190", "ping");
		spellPut("198-191", "ping");
		spellPut("198-192", "ping");
		spellPut("198-193", "ping,bing");
		spellPut("198-194", "po");
		spellPut("198-195", "po");
		spellPut("198-196", "po");
		spellPut("198-197", "po");
		spellPut("198-198", "po");
		spellPut("198-199", "po");
		spellPut("198-200", "po,pai");
		spellPut("198-201", "po");
		spellPut("198-202", "pou");
		spellPut("198-203", "pu");
		spellPut("198-204", "pu");
		spellPut("198-205", "pu");
		spellPut("198-206", "pu");
		spellPut("198-207", "pu");
		spellPut("198-208", "pu");
		spellPut("198-209", "pu");
		spellPut("198-210", "pu,bu");
		spellPut("198-211", "pu,po,piao");
		spellPut("198-212", "pu");
		spellPut("198-213", "pu");
		spellPut("198-214", "pu");
		spellPut("198-215", "pu");
		spellPut("198-216", "pu,bao");
		spellPut("198-217", "pu,bao");
		spellPut("198-218", "qi,ji");
		spellPut("198-219", "qi");
		spellPut("198-220", "qi,xi");
		spellPut("198-221", "qi");
		spellPut("198-222", "qi");
		spellPut("198-223", "qi");
		spellPut("198-224", "qi");
		spellPut("198-225", "qi");
		spellPut("198-226", "qi");
		spellPut("198-227", "qi");
		spellPut("198-228", "qi,ji");
		spellPut("198-229", "qi");
		spellPut("198-230", "qi,ji");
		spellPut("198-231", "qi");
		spellPut("198-232", "qi");
		spellPut("198-233", "qi");
		spellPut("198-234", "qi");
		spellPut("198-235", "qi");
		spellPut("198-236", "qi");
		spellPut("198-237", "qi");
		spellPut("198-238", "qi");
		spellPut("198-239", "qi");
		spellPut("198-240", "qi");
		spellPut("198-241", "qi,kai");
		spellPut("198-242", "qi");
		spellPut("198-243", "qi");
		spellPut("198-244", "qi");
		spellPut("198-245", "qi,qie,xie");
		spellPut("198-246", "qi,qie");
		spellPut("198-247", "qi");
		spellPut("198-248", "qi");
		spellPut("198-249", "qi");
		spellPut("198-250", "qi");
		spellPut("198-251", "qi");
		spellPut("198-252", "qi");
		spellPut("198-253", "qi");
		spellPut("198-254", "qia");
	}

	private static void init61() {
		spellPut("199-64", "qian");
		spellPut("199-65", "zhu");
		spellPut("199-66", "huan");
		spellPut("199-67", "fu");
		spellPut("199-68", "gai");
		spellPut("199-69", "da");
		spellPut("199-70", "chuan");
		spellPut("199-71", "jing");
		spellPut("199-72", "er");
		spellPut("199-73", "an");
		spellPut("199-74", "qiao");
		spellPut("199-75", "chi");
		spellPut("199-76", "ping");
		spellPut("199-77", "jin");
		spellPut("199-78", "lao");
		spellPut("199-79", "shu");
		spellPut("199-80", "zhuang");
		spellPut("199-81", "da");
		spellPut("199-82", "ce");
		spellPut("199-83", "zi");
		spellPut("199-84", "du");
		spellPut("199-85", "wei");
		spellPut("199-86", "li");
		spellPut("199-87", "dou");
		spellPut("199-88", "fu");
		spellPut("199-89", "ren");
		spellPut("199-90", "yin");
		spellPut("199-91", "bu");
		spellPut("199-92", "yun");
		spellPut("199-93", "sui");
		spellPut("199-94", "cheng");
		spellPut("199-95", "chen");
		spellPut("199-96", "wu");
		spellPut("199-97", "bie");
		spellPut("199-98", "xi");
		spellPut("199-99", "geng");
		spellPut("199-100", "zhu");
		spellPut("199-101", "mo");
		spellPut("199-102", "zhuang");
		spellPut("199-103", "zuo");
		spellPut("199-104", "tuo");
		spellPut("199-105", "qiu");
		spellPut("199-106", "suo");
		spellPut("199-107", "chen");
		spellPut("199-108", "peng,feng");
		spellPut("199-109", "meng");
		spellPut("199-110", "xing");
		spellPut("199-111", "jing");
		spellPut("199-112", "che");
		spellPut("199-113", "jun");
		spellPut("199-114", "yan");
		spellPut("199-115", "cuo");
		spellPut("199-116", "han");
		spellPut("199-117", "cuo");
		spellPut("199-118", "jia");
		spellPut("199-119", "wang");
		spellPut("199-120", "su,you");
		spellPut("199-121", "niu");
		spellPut("199-122", "shao,xiao");
		spellPut("199-123", "xian");
		spellPut("199-124", "wen,wan,mian");
		spellPut("199-125", "jie");
		spellPut("199-126", "nan");
		spellPut("199-128", "mu");
		spellPut("199-129", "tu");
		spellPut("199-130", "nu xi");
		spellPut("199-131", "mang");
		spellPut("199-132", "ci");
		spellPut("199-133", "di");
		spellPut("199-134", "qu");
		spellPut("199-135", "dong");
		spellPut("199-136", "zou,chu");
		spellPut("199-137", "la");
		spellPut("199-138", "lu");
		spellPut("199-139", "wei");
		spellPut("199-140", "nie,ren");
		spellPut("199-141", "kun");
		spellPut("199-142", "pu");
		spellPut("199-143", "zi,zai");
		spellPut("199-144", "gao");
		spellPut("199-145", "guo");
		spellPut("199-146", "lun");
		spellPut("199-147", "chou");
		spellPut("199-148", "chui");
		spellPut("199-149", "zhan");
		spellPut("199-150", "men");
		spellPut("199-151", "li");
		spellPut("199-152", "bao");
		spellPut("199-153", "qin");
		spellPut("199-154", "juan");
		spellPut("199-155", "qin");
		spellPut("199-156", "di");
		spellPut("199-157", "jie,sha");
		spellPut("199-158", "jin");
		spellPut("199-159", "qiao,zhao");
		spellPut("199-160", "tai,zhi,chi");
		spellPut("199-161", "qia");
		spellPut("199-162", "qia");
		spellPut("199-163", "qian");
		spellPut("199-164", "qian");
		spellPut("199-165", "qian");
		spellPut("199-166", "qian,yan");
		spellPut("199-167", "qian");
		spellPut("199-168", "qian");
		spellPut("199-169", "qian");
		spellPut("199-170", "qian");
		spellPut("199-171", "qian");
		spellPut("199-172", "qian,gan");
		spellPut("199-173", "qian");
		spellPut("199-174", "qian");
		spellPut("199-175", "qian");
		spellPut("199-176", "qian");
		spellPut("199-177", "qian");
		spellPut("199-178", "qian");
		spellPut("199-179", "qian,jian");
		spellPut("199-180", "qian");
		spellPut("199-181", "qian,zan,jian");
		spellPut("199-182", "qian,kan");
		spellPut("199-183", "qian");
		spellPut("199-184", "qian");
		spellPut("199-185", "qiang");
		spellPut("199-186", "qiang");
		spellPut("199-187", "qiang");
		spellPut("199-188", "qiang");
		spellPut("199-189", "qiang");
		spellPut("199-190", "qiang");
		spellPut("199-191", "qiang,jiang");
		spellPut("199-192", "qiang,cheng");
		spellPut("199-193", "qiao");
		spellPut("199-194", "qiao");
		spellPut("199-195", "qiao");
		spellPut("199-196", "qiao");
		spellPut("199-197", "qiao");
		spellPut("199-198", "qiao");
		spellPut("199-199", "qiao");
		spellPut("199-200", "qiao");
		spellPut("199-201", "qiao");
		spellPut("199-202", "qiao,shao");
		spellPut("199-203", "qiao");
		spellPut("199-204", "qiao");
		spellPut("199-205", "qiao");
		spellPut("199-206", "qiao,xiao");
		spellPut("199-207", "qiao");
		spellPut("199-208", "qie");
		spellPut("199-209", "qie");
		spellPut("199-210", "qie,ju");
		spellPut("199-211", "qie");
		spellPut("199-212", "qie");
		spellPut("199-213", "qin");
		spellPut("199-214", "qin");
		spellPut("199-215", "qin,qing");
		spellPut("199-216", "qin");
		spellPut("199-217", "qin");
		spellPut("199-218", "qin");
		spellPut("199-219", "qin");
		spellPut("199-220", "qin");
		spellPut("199-221", "qin");
		spellPut("199-222", "qin");
		spellPut("199-223", "qin");
		spellPut("199-224", "qing");
		spellPut("199-225", "qing");
		spellPut("199-226", "qing");
		spellPut("199-227", "qing");
		spellPut("199-228", "qing");
		spellPut("199-229", "qing");
		spellPut("199-230", "qing");
		spellPut("199-231", "qing");
		spellPut("199-232", "qing");
		spellPut("199-233", "qing");
		spellPut("199-234", "qing");
		spellPut("199-235", "qing");
		spellPut("199-236", "qing");
		spellPut("199-237", "qiong");
		spellPut("199-238", "qiong");
		spellPut("199-239", "qiu");
		spellPut("199-240", "qiu");
		spellPut("199-241", "qiu");
		spellPut("199-242", "qiu");
		spellPut("199-243", "qiu");
		spellPut("199-244", "qiu");
		spellPut("199-245", "qiu");
		spellPut("199-246", "qiu");
		spellPut("199-247", "qu,cu");
		spellPut("199-248", "qu,ou");
		spellPut("199-249", "qu");
		spellPut("199-250", "qu");
		spellPut("199-251", "qu");
		spellPut("199-252", "qu");
		spellPut("199-253", "qu");
		spellPut("199-254", "qu,ju");
	}

	private static void init62() {
		spellPut("200-64", "geng");
		spellPut("200-65", "hua");
		spellPut("200-66", "qin,jin");
		spellPut("200-67", "an");
		spellPut("200-68", "wang");
		spellPut("200-69", "beng");
		spellPut("200-70", "zhou");
		spellPut("200-71", "jian");
		spellPut("200-72", "lin,ma");
		spellPut("200-73", "tan");
		spellPut("200-74", "tian");
		spellPut("200-75", "dao");
		spellPut("200-76", "hu");
		spellPut("200-77", "he");
		spellPut("200-78", "chun");
		spellPut("200-79", "chang");
		spellPut("200-80", "huan");
		spellPut("200-81", "fei");
		spellPut("200-82", "lai");
		spellPut("200-83", "sha");
		spellPut("200-84", "yan");
		spellPut("200-85", "yi");
		spellPut("200-86", "tiao");
		spellPut("200-87", "qi");
		spellPut("200-88", "wan");
		spellPut("200-89", "ce");
		spellPut("200-90", "ku ta bi lBi");
		spellPut("200-91", "tuo");
		spellPut("200-92", "jiu");
		spellPut("200-93", "bi");
		spellPut("200-94", "yi");
		spellPut("200-95", "pan");
		spellPut("200-96", "bo");
		spellPut("200-97", "pao");
		spellPut("200-98", "ding");
		spellPut("200-99", "qiu");
		spellPut("200-100", "ke");
		spellPut("200-101", "xiang");
		spellPut("200-102", "wan");
		spellPut("200-103", "yu");
		spellPut("200-104", "yu");
		spellPut("200-105", "fu");
		spellPut("200-106", "lian");
		spellPut("200-107", "xuan");
		spellPut("200-108", "nan");
		spellPut("200-109", "ce");
		spellPut("200-110", "wo");
		spellPut("200-111", "chun");
		spellPut("200-112", "shao");
		spellPut("200-113", "bian");
		spellPut("200-114", "mao");
		spellPut("200-115", "an");
		spellPut("200-116", "ying");
		spellPut("200-117", "kuo");
		spellPut("200-118", "kuo");
		spellPut("200-119", "jiang");
		spellPut("200-120", "mian");
		spellPut("200-121", "zuo");
		spellPut("200-122", "zuo");
		spellPut("200-123", "zu");
		spellPut("200-124", "rou");
		spellPut("200-125", "xi");
		spellPut("200-126", "ye");
		spellPut("200-128", "an");
		spellPut("200-129", "qu");
		spellPut("200-130", "jian");
		spellPut("200-131", "fu");
		spellPut("200-132", "lv");
		spellPut("200-133", "jing");
		spellPut("200-134", "pen");
		spellPut("200-135", "hong");
		spellPut("200-136", "hong");
		spellPut("200-137", "hou");
		spellPut("200-138", "xing");
		spellPut("200-139", "tu");
		spellPut("200-140", "zi");
		spellPut("200-141", "qing");
		spellPut("200-142", "mi");
		spellPut("200-143", "huang");
		spellPut("200-144", "shen");
		spellPut("200-145", "gai");
		spellPut("200-146", "zhou");
		spellPut("200-147", "qian");
		spellPut("200-148", "wei");
		spellPut("200-149", "bo");
		spellPut("200-150", "wei");
		spellPut("200-151", "ji");
		spellPut("200-152", "duan");
		spellPut("200-153", "yao");
		spellPut("200-154", "jun");
		spellPut("200-155", "quan");
		spellPut("200-156", "zhen");
		spellPut("200-157", "hun");
		spellPut("200-158", "shi");
		spellPut("200-159", "lan");
		spellPut("200-160", "zong");
		spellPut("200-161", "qu");
		spellPut("200-162", "qu");
		spellPut("200-163", "qu");
		spellPut("200-164", "qu,cu");
		spellPut("200-165", "qu");
		spellPut("200-166", "quan,juan");
		spellPut("200-167", "quan");
		spellPut("200-168", "quan");
		spellPut("200-169", "quan");
		spellPut("200-170", "quan");
		spellPut("200-171", "quan");
		spellPut("200-172", "quan");
		spellPut("200-173", "quan");
		spellPut("200-174", "quan");
		spellPut("200-175", "quan,xuan");
		spellPut("200-176", "quan");
		spellPut("200-177", "que");
		spellPut("200-178", "que");
		spellPut("200-179", "que");
		spellPut("200-180", "que");
		spellPut("200-181", "que");
		spellPut("200-182", "que");
		spellPut("200-183", "que");
		spellPut("200-184", "que,qiao");
		spellPut("200-185", "qun");
		spellPut("200-186", "qun");
		spellPut("200-187", "ran");
		spellPut("200-188", "ran");
		spellPut("200-189", "ran");
		spellPut("200-190", "ran");
		spellPut("200-191", "rang");
		spellPut("200-192", "rang");
		spellPut("200-193", "rang");
		spellPut("200-194", "rang");
		spellPut("200-195", "rang");
		spellPut("200-196", "rao");
		spellPut("200-197", "rao");
		spellPut("200-198", "rao");
		spellPut("200-199", "re");
		spellPut("200-200", "re");
		spellPut("200-201", "ren");
		spellPut("200-202", "ren");
		spellPut("200-203", "ren");
		spellPut("200-204", "ren");
		spellPut("200-205", "ren");
		spellPut("200-206", "ren");
		spellPut("200-207", "ren");
		spellPut("200-208", "ren");
		spellPut("200-209", "ren");
		spellPut("200-210", "ren");
		spellPut("200-211", "reng");
		spellPut("200-212", "reng");
		spellPut("200-213", "ri");
		spellPut("200-214", "rong");
		spellPut("200-215", "rong");
		spellPut("200-216", "rong");
		spellPut("200-217", "rong");
		spellPut("200-218", "rong");
		spellPut("200-219", "rong");
		spellPut("200-220", "rong");
		spellPut("200-221", "rong");
		spellPut("200-222", "rong");
		spellPut("200-223", "rong");
		spellPut("200-224", "rou");
		spellPut("200-225", "rou");
		spellPut("200-226", "rou");
		spellPut("200-227", "ru");
		spellPut("200-228", "ru");
		spellPut("200-229", "ru");
		spellPut("200-230", "ru");
		spellPut("200-231", "ru");
		spellPut("200-232", "ru");
		spellPut("200-233", "ru");
		spellPut("200-234", "ru");
		spellPut("200-235", "ru");
		spellPut("200-236", "ru");
		spellPut("200-237", "ruan");
		spellPut("200-238", "ruan");
		spellPut("200-239", "rui");
		spellPut("200-240", "rui");
		spellPut("200-241", "rui");
		spellPut("200-242", "run");
		spellPut("200-243", "run");
		spellPut("200-244", "ruo,re");
		spellPut("200-245", "ruo");
		spellPut("200-246", "sa");
		spellPut("200-247", "sa,xi");
		spellPut("200-248", "sa");
		spellPut("200-249", "sai");
		spellPut("200-250", "sai,xi");
		spellPut("200-251", "sai,se");
		spellPut("200-252", "sai");
		spellPut("200-253", "san");
		spellPut("200-254", "san");
	}

	private static void init63() {
		spellPut("201-64", "yao");
		spellPut("201-65", "yuan");
		spellPut("201-66", "mei");
		spellPut("201-67", "yun");
		spellPut("201-68", "shu");
		spellPut("201-69", "zhuan");
		spellPut("201-70", "guan");
		spellPut("201-71", "su ku mo");
		spellPut("201-72", "xue");
		spellPut("201-73", "uu");
		spellPut("201-74", "wei");
		spellPut("201-75", "yong");
		spellPut("201-76", "sou");
		spellPut("201-77", "yin");
		spellPut("201-78", "shi");
		spellPut("201-79", "chun");
		spellPut("201-80", "shi");
		spellPut("201-81", "yun");
		spellPut("201-82", "zhen");
		spellPut("201-83", "ru,na");
		spellPut("201-84", "li");
		spellPut("201-85", "que");
		spellPut("201-86", "yuan,huan");
		spellPut("201-87", "li");
		spellPut("201-88", "ju");
		spellPut("201-89", "xi");
		spellPut("201-90", "chu");
		spellPut("201-91", "xu,shu");
		spellPut("201-92", "tu");
		spellPut("201-93", "liu");
		spellPut("201-94", "huo");
		spellPut("201-95", "dian");
		spellPut("201-96", "qian");
		spellPut("201-97", "zu,ju");
		spellPut("201-98", "po");
		spellPut("201-99", "cuo");
		spellPut("201-100", "yuan");
		spellPut("201-101", "chu");
		spellPut("201-102", "yu");
		spellPut("201-103", "pan");
		spellPut("201-104", "pu");
		spellPut("201-105", "na");
		spellPut("201-106", "xi");
		spellPut("201-107", "fen");
		spellPut("201-108", "yun");
		spellPut("201-109", "ruo");
		spellPut("201-110", "cang");
		spellPut("201-111", "mi");
		spellPut("201-112", "sun");
		spellPut("201-113", "ming");
		spellPut("201-114", "sou");
		spellPut("201-115", "liu");
		spellPut("201-116", "xi");
		spellPut("201-117", "gu");
		spellPut("201-118", "lang");
		spellPut("201-119", "gai,ge,he");
		spellPut("201-120", "cuo");
		spellPut("201-121", "tang");
		spellPut("201-122", "luo");
		spellPut("201-123", "xuan");
		spellPut("201-124", "yao,zhuo");
		spellPut("201-125", "gui");
		spellPut("201-126", "zong");
		spellPut("201-128", "gun");
		spellPut("201-129", "go zha");
		spellPut("201-130", "tiao");
		spellPut("201-131", "ce");
		spellPut("201-132", "pei");
		spellPut("201-133", "dan");
		spellPut("201-134", "shen");
		spellPut("201-135", "lang");
		spellPut("201-136", "ling");
		spellPut("201-137", "diao,tiao,di");
		spellPut("201-138", "tiao");
		spellPut("201-139", "mao");
		spellPut("201-140", "tong");
		spellPut("201-141", "zhu");
		spellPut("201-142", "an");
		spellPut("201-143", "lian");
		spellPut("201-144", "cong");
		spellPut("201-145", "ping");
		spellPut("201-146", "qiu,xu,fu");
		spellPut("201-147", "jin");
		spellPut("201-148", "chun");
		spellPut("201-149", "jie");
		spellPut("201-150", "wei");
		spellPut("201-151", "tui");
		spellPut("201-152", "cao");
		spellPut("201-153", "yu");
		spellPut("201-154", "yi");
		spellPut("201-155", "zi,ju");
		spellPut("201-156", "bi");
		spellPut("201-157", "lu");
		spellPut("201-158", "bu");
		spellPut("201-159", "zhang");
		spellPut("201-160", "lei");
		spellPut("201-161", "san");
		spellPut("201-162", "san");
		spellPut("201-163", "sang");
		spellPut("201-164", "sang");
		spellPut("201-165", "sang");
		spellPut("201-166", "sao");
		spellPut("201-167", "sao");
		spellPut("201-168", "sao");
		spellPut("201-169", "sao");
		spellPut("201-170", "se");
		spellPut("201-171", "se");
		spellPut("201-172", "se");
		spellPut("201-173", "sen");
		spellPut("201-174", "seng");
		spellPut("201-175", "suo,sha");
		spellPut("201-176", "sha");
		spellPut("201-177", "sha");
		spellPut("201-178", "cha,sha");
		spellPut("201-179", "sha");
		spellPut("201-180", "sha");
		spellPut("201-181", "sha");
		spellPut("201-182", "sha");
		spellPut("201-183", "sha");
		spellPut("201-184", "shai");
		spellPut("201-185", "shai");
		spellPut("201-186", "shan");
		spellPut("201-187", "shan");
		spellPut("201-188", "shan,sha");
		spellPut("201-189", "shan");
		spellPut("201-190", "shan");
		spellPut("201-191", "shan");
		spellPut("201-192", "shan");
		spellPut("201-193", "shan");
		spellPut("201-194", "shan");
		spellPut("201-195", "shan");
		spellPut("201-196", "shan");
		spellPut("201-197", "shan");
		spellPut("201-198", "shan");
		spellPut("201-199", "shan");
		spellPut("201-200", "shan");
		spellPut("201-201", "shan");
		spellPut("201-202", "shang");
		spellPut("201-203", "shang");
		spellPut("201-204", "shang");
		spellPut("201-205", "shang");
		spellPut("201-206", "shang");
		spellPut("201-207", "shang");
		spellPut("201-208", "shang");
		spellPut("201-209", "chang,shBng");
		spellPut("201-210", "shao,sao");
		spellPut("201-211", "shao");
		spellPut("201-212", "shao");
		spellPut("201-213", "shao");
		spellPut("201-214", "shao");
		spellPut("201-215", "shao");
		spellPut("201-216", "shao");
		spellPut("201-217", "shao");
		spellPut("201-218", "shao");
		spellPut("201-219", "shao");
		spellPut("201-220", "shao");
		spellPut("201-221", "she");
		spellPut("201-222", "she");
		spellPut("201-223", "she,yi");
		spellPut("201-224", "she");
		spellPut("201-225", "she");
		spellPut("201-226", "she");
		spellPut("201-227", "she,nie");
		spellPut("201-228", "she,ye,yi");
		spellPut("201-229", "she");
		spellPut("201-230", "she");
		spellPut("201-231", "she");
		spellPut("201-232", "she");
		spellPut("201-233", "shen");
		spellPut("201-234", "shen");
		spellPut("201-235", "shen");
		spellPut("201-236", "shen");
		spellPut("201-237", "shen");
		spellPut("201-238", "shen");
		spellPut("201-239", "shen");
		spellPut("201-240", "shen");
		spellPut("201-241", "shen");
		spellPut("201-242", "shen,chen");
		spellPut("201-243", "shen");
		spellPut("201-244", "shen");
		spellPut("201-245", "shen");
		spellPut("201-246", "shen");
		spellPut("201-247", "shen");
		spellPut("201-248", "shen");
		spellPut("201-249", "sheng");
		spellPut("201-250", "sheng");
		spellPut("201-251", "sheng");
		spellPut("201-252", "sheng");
		spellPut("201-253", "sheng");
		spellPut("201-254", "sheng");
	}

	private static void init64() {
		spellPut("202-64", "qiang");
		spellPut("202-65", "man");
		spellPut("202-66", "yan");
		spellPut("202-67", "ling");
		spellPut("202-68", "ji");
		spellPut("202-69", "biao");
		spellPut("202-70", "gun");
		spellPut("202-71", "han");
		spellPut("202-72", "di");
		spellPut("202-73", "lu");
		spellPut("202-74", "she");
		spellPut("202-75", "shang");
		spellPut("202-76", "di");
		spellPut("202-77", "hun");
		spellPut("202-78", "bo");
		spellPut("202-79", "di");
		spellPut("202-80", "cuo");
		spellPut("202-81", "shen");
		spellPut("202-82", "xuan");
		spellPut("202-83", "hu");
		spellPut("202-84", "ao");
		spellPut("202-85", "mi");
		spellPut("202-86", "lou");
		spellPut("202-87", "zhong");
		spellPut("202-88", "po");
		spellPut("202-89", "jiang");
		spellPut("202-90", "mi");
		spellPut("202-91", "cong");
		spellPut("202-92", "niao");
		spellPut("202-93", "hui");
		spellPut("202-94", "juan");
		spellPut("202-95", "yin");
		spellPut("202-96", "jian");
		spellPut("202-97", "yin");
		spellPut("202-98", "guo");
		spellPut("202-99", "chen");
		spellPut("202-100", "hu");
		spellPut("202-101", "sha");
		spellPut("202-102", "kou");
		spellPut("202-103", "qian");
		spellPut("202-104", "ma");
		spellPut("202-105", "zang");
		spellPut("202-106", "ze");
		spellPut("202-107", "li");
		spellPut("202-108", "wei");
		spellPut("202-109", "ji");
		spellPut("202-110", "qian");
		spellPut("202-111", "sheng");
		spellPut("202-112", "meng");
		spellPut("202-113", "ou");
		spellPut("202-114", "chan");
		spellPut("202-115", "dian");
		spellPut("202-116", "rui");
		spellPut("202-117", "lei");
		spellPut("202-118", "yu");
		spellPut("202-119", "qiao");
		spellPut("202-120", "zhu");
		spellPut("202-121", "hua");
		spellPut("202-122", "jian");
		spellPut("202-123", "mBi");
		spellPut("202-124", "yun");
		spellPut("202-125", "bao");
		spellPut("202-126", "you");
		spellPut("202-128", "lu");
		spellPut("202-129", "rao");
		spellPut("202-130", "e");
		spellPut("202-131", "ti");
		spellPut("202-132", "fei");
		spellPut("202-133", "jue");
		spellPut("202-134", "fa");
		spellPut("202-135", "ru");
		spellPut("202-136", "fen");
		spellPut("202-137", "kui");
		spellPut("202-138", "shun");
		spellPut("202-139", "ya");
		spellPut("202-140", "xu");
		spellPut("202-141", "fu");
		spellPut("202-142", "dang");
		spellPut("202-143", "wu");
		spellPut("202-144", "dong");
		spellPut("202-145", "si");
		spellPut("202-146", "xiao");
		spellPut("202-147", "xi");
		spellPut("202-148", "sa");
		spellPut("202-149", "yun");
		spellPut("202-150", "shBo");
		spellPut("202-151", "jian");
		spellPut("202-152", "sun");
		spellPut("202-153", "ling");
		spellPut("202-154", "yu");
		spellPut("202-155", "xia");
		spellPut("202-156", "si");
		spellPut("202-157", "nong");
		spellPut("202-158", "xuan");
		spellPut("202-159", "yun");
		spellPut("202-160", "yu");
		spellPut("202-161", "sheng,xing");
		spellPut("202-162", "sheng,cheng");
		spellPut("202-163", "sheng");
		spellPut("202-164", "sheng");
		spellPut("202-165", "sheng");
		spellPut("202-166", "shi");
		spellPut("202-167", "shi");
		spellPut("202-168", "shi");
		spellPut("202-169", "shi");
		spellPut("202-170", "shi");
		spellPut("202-171", "shi");
		spellPut("202-172", "shi");
		spellPut("202-173", "shi");
		spellPut("202-174", "shi");
		spellPut("202-175", "shi,dan");
		spellPut("202-176", "shi,she");
		spellPut("202-177", "shi");
		spellPut("202-178", "shi,shen");
		spellPut("202-179", "shi,si,yi");
		spellPut("202-180", "shi");
		spellPut("202-181", "shi");
		spellPut("202-182", "shi,zhi");
		spellPut("202-183", "shi");
		spellPut("202-184", "shi");
		spellPut("202-185", "shi");
		spellPut("202-186", "shi");
		spellPut("202-187", "shi");
		spellPut("202-188", "shi");
		spellPut("202-189", "shi");
		spellPut("202-190", "shi");
		spellPut("202-191", "shi");
		spellPut("202-192", "shi");
		spellPut("202-193", "shi");
		spellPut("202-194", "shi");
		spellPut("202-195", "shi");
		spellPut("202-196", "shi");
		spellPut("202-197", "shi");
		spellPut("202-198", "shi");
		spellPut("202-199", "shi");
		spellPut("202-200", "shi");
		spellPut("202-201", "shi");
		spellPut("202-202", "shi");
		spellPut("202-203", "shi");
		spellPut("202-204", "shi");
		spellPut("202-205", "shi");
		spellPut("202-206", "shi");
		spellPut("202-207", "shi,zhi");
		spellPut("202-208", "shi");
		spellPut("202-209", "shi");
		spellPut("202-210", "shi");
		spellPut("202-211", "shi");
		spellPut("202-212", "shi");
		spellPut("202-213", "shou");
		spellPut("202-214", "shou");
		spellPut("202-215", "shou");
		spellPut("202-216", "shou");
		spellPut("202-217", "shou");
		spellPut("202-218", "shou");
		spellPut("202-219", "shou");
		spellPut("202-220", "shou");
		spellPut("202-221", "shou");
		spellPut("202-222", "shou");
		spellPut("202-223", "shu");
		spellPut("202-224", "shu");
		spellPut("202-225", "shu");
		spellPut("202-226", "shu");
		spellPut("202-227", "shu");
		spellPut("202-228", "shu");
		spellPut("202-229", "shu");
		spellPut("202-230", "shu");
		spellPut("202-231", "shu");
		spellPut("202-232", "shu");
		spellPut("202-233", "shu");
		spellPut("202-234", "shu");
		spellPut("202-235", "shu");
		spellPut("202-236", "shu");
		spellPut("202-237", "shu");
		spellPut("202-238", "shu");
		spellPut("202-239", "shu");
		spellPut("202-240", "shu");
		spellPut("202-241", "shu");
		spellPut("202-242", "shu");
		spellPut("202-243", "shu");
		spellPut("202-244", "shu,zhu");
		spellPut("202-245", "shu,zhu");
		spellPut("202-246", "shu");
		spellPut("202-247", "shu");
		spellPut("202-248", "shu");
		spellPut("202-249", "shu");
		spellPut("202-250", "shu");
		spellPut("202-251", "shu");
		spellPut("202-252", "shu");
		spellPut("202-253", "shu,shuo");
		spellPut("202-254", "shu");
	}

	private static void init65() {
		spellPut("203-64", "xi,xiao");
		spellPut("203-65", "hao");
		spellPut("203-66", "ai");
		spellPut("203-67", "hui");
		spellPut("203-68", "hui");
		spellPut("203-69", "ji");
		spellPut("203-70", "ci,zi");
		spellPut("203-71", "xiang");
		spellPut("203-72", "wan,luan");
		spellPut("203-73", "mie");
		spellPut("203-74", "leng");
		spellPut("203-75", "jiang");
		spellPut("203-76", "can");
		spellPut("203-77", "shen");
		spellPut("203-78", "qiang,se");
		spellPut("203-79", "lian");
		spellPut("203-80", "ke");
		spellPut("203-81", "yuan");
		spellPut("203-82", "da");
		spellPut("203-83", "ti");
		spellPut("203-84", "tang");
		spellPut("203-85", "zhan");
		spellPut("203-86", "sun");
		spellPut("203-87", "xian,lian");
		spellPut("203-88", "fan");
		spellPut("203-89", "ding");
		spellPut("203-90", "xie");
		spellPut("203-91", "gu");
		spellPut("203-92", "shu");
		spellPut("203-93", "jian");
		spellPut("203-94", "hao,kao");
		spellPut("203-95", "sa");
		spellPut("203-96", "xun");
		spellPut("203-97", "yao");
		spellPut("203-98", "bai");
		spellPut("203-99", "dui");
		spellPut("203-100", "pin");
		spellPut("203-101", "yuan,wei");
		spellPut("203-102", "ning");
		spellPut("203-103", "chou,zhou");
		spellPut("203-104", "mai,wo");
		spellPut("203-105", "piao");
		spellPut("203-106", "ji,qi");
		spellPut("203-107", "zao");
		spellPut("203-108", "chen");
		spellPut("203-109", "zhen");
		spellPut("203-110", "er");
		spellPut("203-111", "ni");
		spellPut("203-112", "ying");
		spellPut("203-113", "cong");
		spellPut("203-114", "xiao,hao");
		spellPut("203-115", "qi");
		spellPut("203-116", "fa");
		spellPut("203-117", "jian");
		spellPut("203-118", "xu,yu");
		spellPut("203-119", "kui");
		spellPut("203-120", "bian");
		spellPut("203-121", "diao,zhuo");
		spellPut("203-122", "mi");
		spellPut("203-123", "lan");
		spellPut("203-124", "jin");
		spellPut("203-125", "qiong");
		spellPut("203-126", "qi");
		spellPut("203-128", "liao");
		spellPut("203-129", "xian");
		spellPut("203-130", "su");
		spellPut("203-131", "lv");
		spellPut("203-132", "yi");
		spellPut("203-133", "xu");
		spellPut("203-134", "xie");
		spellPut("203-135", "yi");
		spellPut("203-136", "la");
		spellPut("203-137", "lei");
		spellPut("203-138", "jiao");
		spellPut("203-139", "di");
		spellPut("203-140", "zhi");
		spellPut("203-141", "bei");
		spellPut("203-142", "yao,yue");
		spellPut("203-143", "mo");
		spellPut("203-144", "huan");
		spellPut("203-145", "biao,pao");
		spellPut("203-146", "sou");
		spellPut("203-147", "tan");
		spellPut("203-148", "tui");
		spellPut("203-149", "qiong");
		spellPut("203-150", "qiao");
		spellPut("203-151", "wei");
		spellPut("203-152", "liu");
		spellPut("203-153", "hui");
		spellPut("203-154", "ou");
		spellPut("203-155", "gao");
		spellPut("203-156", "yun");
		spellPut("203-157", "bBo");
		spellPut("203-158", "li");
		spellPut("203-159", "shu");
		spellPut("203-160", "zhu,chu");
		spellPut("203-161", "shu");
		spellPut("203-162", "shua");
		spellPut("203-163", "shua");
		spellPut("203-164", "shuai");
		spellPut("203-165", "shuai");
		spellPut("203-166", "shuai");
		spellPut("203-167", "shuai");
		spellPut("203-168", "shuan");
		spellPut("203-169", "shuan");
		spellPut("203-170", "shuang");
		spellPut("203-171", "shuang");
		spellPut("203-172", "shuang");
		spellPut("203-173", "shui");
		spellPut("203-174", "shui");
		spellPut("203-175", "shui");
		spellPut("203-176", "shui");
		spellPut("203-177", "shun");
		spellPut("203-178", "shun");
		spellPut("203-179", "shun");
		spellPut("203-180", "shun");
		spellPut("203-181", "shuo,shui,yue");
		spellPut("203-182", "shuo,shi");
		spellPut("203-183", "shuo");
		spellPut("203-184", "shuo");
		spellPut("203-185", "si");
		spellPut("203-186", "si");
		spellPut("203-187", "si");
		spellPut("203-188", "si,sai");
		spellPut("203-189", "si");
		spellPut("203-190", "si");
		spellPut("203-191", "si");
		spellPut("203-192", "si");
		spellPut("203-193", "si");
		spellPut("203-194", "si");
		spellPut("203-195", "si");
		spellPut("203-196", "si");
		spellPut("203-197", "si,ci");
		spellPut("203-198", "si,shi");
		spellPut("203-199", "si");
		spellPut("203-200", "si");
		spellPut("203-201", "song");
		spellPut("203-202", "song");
		spellPut("203-203", "song");
		spellPut("203-204", "song");
		spellPut("203-205", "song");
		spellPut("203-206", "song");
		spellPut("203-207", "song");
		spellPut("203-208", "song");
		spellPut("203-209", "sou");
		spellPut("203-210", "sou");
		spellPut("203-211", "sou");
		spellPut("203-212", "sou");
		spellPut("203-213", "su");
		spellPut("203-214", "su");
		spellPut("203-215", "su");
		spellPut("203-216", "su");
		spellPut("203-217", "su");
		spellPut("203-218", "su");
		spellPut("203-219", "su");
		spellPut("203-220", "su");
		spellPut("203-221", "su");
		spellPut("203-222", "su,xiu");
		spellPut("203-223", "su");
		spellPut("203-224", "su");
		spellPut("203-225", "suan");
		spellPut("203-226", "suan");
		spellPut("203-227", "suan");
		spellPut("203-228", "sui");
		spellPut("203-229", "sui,duo");
		spellPut("203-230", "sui");
		spellPut("203-231", "sui");
		spellPut("203-232", "sui");
		spellPut("203-233", "sui");
		spellPut("203-234", "sui");
		spellPut("203-235", "sui");
		spellPut("203-236", "sui");
		spellPut("203-237", "sui");
		spellPut("203-238", "sui");
		spellPut("203-239", "sun,xun");
		spellPut("203-240", "sun");
		spellPut("203-241", "sun");
		spellPut("203-242", "suo");
		spellPut("203-243", "suo");
		spellPut("203-244", "suo");
		spellPut("203-245", "suo,su");
		spellPut("203-246", "suo");
		spellPut("203-247", "suo");
		spellPut("203-248", "suo");
		spellPut("203-249", "suo");
		spellPut("203-250", "ta");
		spellPut("203-251", "ta");
		spellPut("203-252", "ta");
		spellPut("203-253", "ta,jie");
		spellPut("203-254", "ta");
	}

	private static void init66() {
		spellPut("204-64", "ai");
		spellPut("204-65", "lin");
		spellPut("204-66", "xuan");
		spellPut("204-67", "qin");
		spellPut("204-68", "lai");
		spellPut("204-69", "tuo");
		spellPut("204-70", "wu");
		spellPut("204-71", "rui");
		spellPut("204-72", "rui");
		spellPut("204-73", "qi");
		spellPut("204-74", "lu");
		spellPut("204-75", "su");
		spellPut("204-76", "tui");
		spellPut("204-77", "mang");
		spellPut("204-78", "yun");
		spellPut("204-79", "pin");
		spellPut("204-80", "yu");
		spellPut("204-81", "xun");
		spellPut("204-82", "ji");
		spellPut("204-83", "jiong");
		spellPut("204-84", "xuan");
		spellPut("204-85", "qiu");
		spellPut("204-86", "su");
		spellPut("204-87", "jiong");
		spellPut("204-88", "peng");
		spellPut("204-89", "bo");
		spellPut("204-90", "rang");
		spellPut("204-91", "yi");
		spellPut("204-92", "xian");
		spellPut("204-93", "yu");
		spellPut("204-94", "ju");
		spellPut("204-95", "lian");
		spellPut("204-96", "lian");
		spellPut("204-97", "yin");
		spellPut("204-98", "qiang");
		spellPut("204-99", "ying");
		spellPut("204-100", "long");
		spellPut("204-101", "tou");
		spellPut("204-102", "hua");
		spellPut("204-103", "yue");
		spellPut("204-104", "ling");
		spellPut("204-105", "yao");
		spellPut("204-106", "mi");
		spellPut("204-107", "lan");
		spellPut("204-108", "gui");
		spellPut("204-109", "lan");
		spellPut("204-110", "ji");
		spellPut("204-111", "dang");
		spellPut("204-112", "kB te su rB");
		spellPut("204-113", "lei");
		spellPut("204-114", "lei");
		spellPut("204-115", "hui");
		spellPut("204-116", "feng");
		spellPut("204-117", "zhi");
		spellPut("204-118", "wei");
		spellPut("204-119", "kui");
		spellPut("204-120", "huai");
		spellPut("204-121", "li");
		spellPut("204-122", "ji");
		spellPut("204-123", "lei");
		spellPut("204-124", "huai");
		spellPut("204-125", "luo");
		spellPut("204-126", "ji");
		spellPut("204-128", "kui");
		spellPut("204-129", "lu");
		spellPut("204-130", "jian");
		spellPut("204-131", "sa ri");
		spellPut("204-132", "teng");
		spellPut("204-133", "lei");
		spellPut("204-134", "quan");
		spellPut("204-135", "xiao");
		spellPut("204-136", "yi");
		spellPut("204-137", "luan");
		spellPut("204-138", "men");
		spellPut("204-139", "bie");
		spellPut("204-140", "si");
		spellPut("204-141", "xiao");
		spellPut("204-142", "chu");
		spellPut("204-143", "hu");
		spellPut("204-144", "xu");
		spellPut("204-145", "cuo");
		spellPut("204-146", "fu");
		spellPut("204-147", "xu");
		spellPut("204-148", "lu");
		spellPut("204-149", "hu");
		spellPut("204-150", "hao");
		spellPut("204-151", "jiao");
		spellPut("204-152", "ju");
		spellPut("204-153", "bao");
		spellPut("204-154", "yan");
		spellPut("204-155", "zhan");
		spellPut("204-156", "zhan");
		spellPut("204-157", "kui");
		spellPut("204-158", "bin");
		spellPut("204-159", "xi");
		spellPut("204-160", "shu");
		spellPut("204-161", "ta");
		spellPut("204-162", "ta");
		spellPut("204-163", "ta");
		spellPut("204-164", "ta");
		spellPut("204-165", "tai");
		spellPut("204-166", "tai");
		spellPut("204-167", "tai");
		spellPut("204-168", "tai");
		spellPut("204-169", "tai");
		spellPut("204-170", "tai");
		spellPut("204-171", "tai");
		spellPut("204-172", "tai");
		spellPut("204-173", "tai");
		spellPut("204-174", "tan");
		spellPut("204-175", "tan");
		spellPut("204-176", "tan");
		spellPut("204-177", "tan");
		spellPut("204-178", "tan");
		spellPut("204-179", "tan");
		spellPut("204-180", "tan");
		spellPut("204-181", "tan");
		spellPut("204-182", "tan");
		spellPut("204-183", "tan");
		spellPut("204-184", "tan");
		spellPut("204-185", "tan");
		spellPut("204-186", "tan");
		spellPut("204-187", "tan");
		spellPut("204-188", "tan");
		spellPut("204-189", "tan");
		spellPut("204-190", "tan");
		spellPut("204-191", "tan");
		spellPut("204-192", "tang,shang");
		spellPut("204-193", "tang");
		spellPut("204-194", "tang");
		spellPut("204-195", "tang");
		spellPut("204-196", "tang");
		spellPut("204-197", "tang");
		spellPut("204-198", "tang");
		spellPut("204-199", "tang");
		spellPut("204-200", "tang,chang");
		spellPut("204-201", "tang");
		spellPut("204-202", "tang,chang");
		spellPut("204-203", "tang");
		spellPut("204-204", "tang");
		spellPut("204-205", "tao");
		spellPut("204-206", "tao");
		spellPut("204-207", "tao");
		spellPut("204-208", "tao");
		spellPut("204-209", "tao");
		spellPut("204-210", "tao");
		spellPut("204-211", "tao");
		spellPut("204-212", "tao");
		spellPut("204-213", "tao");
		spellPut("204-214", "tao");
		spellPut("204-215", "tao");
		spellPut("204-216", "te");
		spellPut("204-217", "teng");
		spellPut("204-218", "teng");
		spellPut("204-219", "teng");
		spellPut("204-220", "teng");
		spellPut("204-221", "ti");
		spellPut("204-222", "ti");
		spellPut("204-223", "ti");
		spellPut("204-224", "ti");
		spellPut("204-225", "ti,di");
		spellPut("204-226", "ti");
		spellPut("204-227", "ti");
		spellPut("204-228", "ti");
		spellPut("204-229", "ti,ben");
		spellPut("204-230", "ti");
		spellPut("204-231", "ti");
		spellPut("204-232", "ti");
		spellPut("204-233", "ti");
		spellPut("204-234", "ti");
		spellPut("204-235", "ti");
		spellPut("204-236", "tian");
		spellPut("204-237", "tian");
		spellPut("204-238", "tian,zhen");
		spellPut("204-239", "tian");
		spellPut("204-240", "tian");
		spellPut("204-241", "tian");
		spellPut("204-242", "tian");
		spellPut("204-243", "tian");
		spellPut("204-244", "tiao");
		spellPut("204-245", "tiao");
		spellPut("204-246", "tiao");
		spellPut("204-247", "tiao");
		spellPut("204-248", "tiao,tao");
		spellPut("204-249", "tie");
		spellPut("204-250", "tie");
		spellPut("204-251", "tie");
		spellPut("204-252", "ting");
		spellPut("204-253", "ting");
		spellPut("204-254", "ting");
	}

	private static void init67() {
		spellPut("205-64", "diao");
		spellPut("205-65", "qiu");
		spellPut("205-66", "ding");
		spellPut("205-67", "uu");
		spellPut("205-68", "jue");
		spellPut("205-69", "zhe");
		spellPut("205-70", "she");
		spellPut("205-71", "yu");
		spellPut("205-72", "han");
		spellPut("205-73", "zi");
		spellPut("205-74", "xiang");
		spellPut("205-75", "fang,bang");
		spellPut("205-76", "e");
		spellPut("205-77", "ba");
		spellPut("205-78", "chi");
		spellPut("205-79", "qian");
		spellPut("205-80", "wen");
		spellPut("205-81", "yue");
		spellPut("205-82", "yue");
		spellPut("205-83", "jun");
		spellPut("205-84", "qi");
		spellPut("205-85", "tong");
		spellPut("205-86", "qi,zhi");
		spellPut("205-87", "yuan,wan");
		spellPut("205-88", "jue,que");
		spellPut("205-89", "hui");
		spellPut("205-90", "qin,qian");
		spellPut("205-91", "qi");
		spellPut("205-92", "zhong");
		spellPut("205-93", "mu");
		spellPut("205-94", "wang");
		spellPut("205-95", "fen");
		spellPut("205-96", "fen");
		spellPut("205-97", "hang");
		spellPut("205-98", "fu");
		spellPut("205-99", "ran");
		spellPut("205-100", "bao");
		spellPut("205-101", "ni");
		spellPut("205-102", "dai,de");
		spellPut("205-103", "ping");
		spellPut("205-104", "chi");
		spellPut("205-105", "ju");
		spellPut("205-106", "li");
		spellPut("205-107", "fu");
		spellPut("205-108", "zha");
		spellPut("205-109", "gou,qu,xu");
		spellPut("205-110", "pi");
		spellPut("205-111", "pi,bo");
		spellPut("205-112", "xian");
		spellPut("205-113", "diao");
		spellPut("205-114", "bie");
		spellPut("205-115", "bing");
		spellPut("205-116", "zhan");
		spellPut("205-117", "tie");
		spellPut("205-118", "tun");
		spellPut("205-119", "ying");
		spellPut("205-120", "ge,luo");
		spellPut("205-121", "ci");
		spellPut("205-122", "hui");
		spellPut("205-123", "mang,bang");
		spellPut("205-124", "fu");
		spellPut("205-125", "lie");
		spellPut("205-126", "yi");
		spellPut("205-128", "xian");
		spellPut("205-129", "li");
		spellPut("205-130", "yi,xu");
		spellPut("205-131", "ping");
		spellPut("205-132", "jie");
		spellPut("205-133", "she");
		spellPut("205-134", "yi");
		spellPut("205-135", "wang");
		spellPut("205-136", "mo");
		spellPut("205-137", "qie,ni");
		spellPut("205-138", "gui");
		spellPut("205-139", "qiong");
		spellPut("205-140", "e bi");
		spellPut("205-141", "xing");
		spellPut("205-142", "jie");
		spellPut("205-143", "qiu");
		spellPut("205-144", "jia");
		spellPut("205-145", "tui");
		spellPut("205-146", "che");
		spellPut("205-147", "bei");
		spellPut("205-148", "han");
		spellPut("205-149", "xuan");
		spellPut("205-150", "shen");
		spellPut("205-151", "fu");
		spellPut("205-152", "xian");
		spellPut("205-153", "lang");
		spellPut("205-154", "bi");
		spellPut("205-155", "yuan");
		spellPut("205-156", "you");
		spellPut("205-157", "jie");
		spellPut("205-158", "dan");
		spellPut("205-159", "dian");
		spellPut("205-160", "hui");
		spellPut("205-161", "ting");
		spellPut("205-162", "ting");
		spellPut("205-163", "ting");
		spellPut("205-164", "ting");
		spellPut("205-165", "ting");
		spellPut("205-166", "ting");
		spellPut("205-167", "ting");
		spellPut("205-168", "tong");
		spellPut("205-169", "tong");
		spellPut("205-170", "tong");
		spellPut("205-171", "tong");
		spellPut("205-172", "tong");
		spellPut("205-173", "tong");
		spellPut("205-174", "tong");
		spellPut("205-175", "tong");
		spellPut("205-176", "tong");
		spellPut("205-177", "tong");
		spellPut("205-178", "tong");
		spellPut("205-179", "tong");
		spellPut("205-180", "tong");
		spellPut("205-181", "tou");
		spellPut("205-182", "tou");
		spellPut("205-183", "tou");
		spellPut("205-184", "tou");
		spellPut("205-185", "tu");
		spellPut("205-186", "tu");
		spellPut("205-187", "tu");
		spellPut("205-188", "tu");
		spellPut("205-189", "tu");
		spellPut("205-190", "tu");
		spellPut("205-191", "tu");
		spellPut("205-192", "tu");
		spellPut("205-193", "tu");
		spellPut("205-194", "tu");
		spellPut("205-195", "tu");
		spellPut("205-196", "tuan");
		spellPut("205-197", "tuan");
		spellPut("205-198", "tui");
		spellPut("205-199", "tui");
		spellPut("205-200", "tui");
		spellPut("205-201", "tui");
		spellPut("205-202", "tun");
		spellPut("205-203", "tui");
		spellPut("205-204", "tun");
		spellPut("205-205", "tun,zhun");
		spellPut("205-206", "tun");
		spellPut("205-207", "tuo");
		spellPut("205-208", "tuo");
		spellPut("205-209", "tuo");
		spellPut("205-210", "tuo");
		spellPut("205-211", "tuo");
		spellPut("205-212", "tuo");
		spellPut("205-213", "tuo");
		spellPut("205-214", "tuo");
		spellPut("205-215", "tuo");
		spellPut("205-216", "tuo,ta,zhi");
		spellPut("205-217", "tuo");
		spellPut("205-218", "wa");
		spellPut("205-219", "wa,wB");
		spellPut("205-220", "wa");
		spellPut("205-221", "wa");
		spellPut("205-222", "wa");
		spellPut("205-223", "wa");
		spellPut("205-224", "wa");
		spellPut("205-225", "wai");
		spellPut("205-226", "wai");
		spellPut("205-227", "wan");
		spellPut("205-228", "wan");
		spellPut("205-229", "wan");
		spellPut("205-230", "wan");
		spellPut("205-231", "wan");
		spellPut("205-232", "wan");
		spellPut("205-233", "wan");
		spellPut("205-234", "wan");
		spellPut("205-235", "wan");
		spellPut("205-236", "wan");
		spellPut("205-237", "wan");
		spellPut("205-238", "wan");
		spellPut("205-239", "wan");
		spellPut("205-240", "wan,yuan");
		spellPut("205-241", "wan");
		spellPut("205-242", "wan,mo");
		spellPut("205-243", "wan");
		spellPut("205-244", "wang");
		spellPut("205-245", "wang");
		spellPut("205-246", "wang,wu");
		spellPut("205-247", "wang");
		spellPut("205-248", "wang");
		spellPut("205-249", "wang");
		spellPut("205-250", "wang");
		spellPut("205-251", "wang");
		spellPut("205-252", "wang");
		spellPut("205-253", "wang");
		spellPut("205-254", "wei");
	}

	private static void init68() {
		spellPut("206-64", "zhong");
		spellPut("206-65", "ju");
		spellPut("206-66", "qi");
		spellPut("206-67", "yu");
		spellPut("206-68", "jun");
		spellPut("206-69", "si");
		spellPut("206-70", "lun");
		spellPut("206-71", "li");
		spellPut("206-72", "die");
		spellPut("206-73", "tao");
		spellPut("206-74", "kun");
		spellPut("206-75", "han");
		spellPut("206-76", "han");
		spellPut("206-77", "bang");
		spellPut("206-78", "fei");
		spellPut("206-79", "wei");
		spellPut("206-80", "dun");
		spellPut("206-81", "yuan");
		spellPut("206-82", "suo");
		spellPut("206-83", "qian");
		spellPut("206-84", "rui");
		spellPut("206-85", "ni");
		spellPut("206-86", "wei");
		spellPut("206-87", "liang");
		spellPut("206-88", "dong");
		spellPut("206-89", "e");
		spellPut("206-90", "ban");
		spellPut("206-91", "di");
		spellPut("206-92", "wang");
		spellPut("206-93", "can");
		spellPut("206-94", "yang");
		spellPut("206-95", "uu");
		spellPut("206-96", "la");
		spellPut("206-97", "ji");
		spellPut("206-98", "ting");
		spellPut("206-99", "mao");
		spellPut("206-100", "xu");
		spellPut("206-101", "mian");
		spellPut("206-102", "jie");
		spellPut("206-103", "shi");
		spellPut("206-104", "xuan");
		spellPut("206-105", "yan");
		spellPut("206-106", "rou");
		spellPut("206-107", "wei");
		spellPut("206-108", "fu");
		spellPut("206-109", "yuan");
		spellPut("206-110", "mei");
		spellPut("206-111", "wei");
		spellPut("206-112", "ru");
		spellPut("206-113", "xie");
		spellPut("206-114", "xia");
		spellPut("206-115", "ying");
		spellPut("206-116", "shi");
		spellPut("206-117", "chong");
		spellPut("206-118", "tang");
		spellPut("206-119", "zhu");
		spellPut("206-120", "zong");
		spellPut("206-121", "di");
		spellPut("206-122", "yuan");
		spellPut("206-123", "meng");
		spellPut("206-124", "la");
		spellPut("206-125", "dai");
		spellPut("206-126", "qiu");
		spellPut("206-128", "li");
		spellPut("206-129", "wo");
		spellPut("206-130", "yun");
		spellPut("206-131", "qu");
		spellPut("206-132", "ying");
		spellPut("206-133", "jiang");
		spellPut("206-134", "bBn");
		spellPut("206-135", "si");
		spellPut("206-136", "ci");
		spellPut("206-137", "xi,qi");
		spellPut("206-138", "weng");
		spellPut("206-139", "lian");
		spellPut("206-140", "ban");
		spellPut("206-141", "rong");
		spellPut("206-142", "ji");
		spellPut("206-143", "wu");
		spellPut("206-144", "xiu");
		spellPut("206-145", "han");
		spellPut("206-146", "yi");
		spellPut("206-147", "bi,pi");
		spellPut("206-148", "hua");
		spellPut("206-149", "yi");
		spellPut("206-150", "du");
		spellPut("206-151", "nai,neng");
		spellPut("206-152", "he,xia");
		spellPut("206-153", "hu");
		spellPut("206-154", "gui,hui");
		spellPut("206-155", "ma");
		spellPut("206-156", "yi");
		spellPut("206-157", "wen");
		spellPut("206-158", "ying");
		spellPut("206-159", "teng");
		spellPut("206-160", "zhong");
		spellPut("206-161", "wei");
		spellPut("206-162", "wei");
		spellPut("206-163", "wei");
		spellPut("206-164", "wei");
		spellPut("206-165", "wei");
		spellPut("206-166", "wei");
		spellPut("206-167", "wei");
		spellPut("206-168", "wei");
		spellPut("206-169", "wei");
		spellPut("206-170", "wei");
		spellPut("206-171", "wei");
		spellPut("206-172", "wei");
		spellPut("206-173", "wei");
		spellPut("206-174", "wei");
		spellPut("206-175", "wei");
		spellPut("206-176", "wei");
		spellPut("206-177", "wei");
		spellPut("206-178", "wei,yi");
		spellPut("206-179", "wei");
		spellPut("206-180", "wei");
		spellPut("206-181", "wei");
		spellPut("206-182", "wei");
		spellPut("206-183", "wei");
		spellPut("206-184", "wei");
		spellPut("206-185", "wei");
		spellPut("206-186", "wei");
		spellPut("206-187", "wei");
		spellPut("206-188", "wei");
		spellPut("206-189", "wei");
		spellPut("206-190", "wei,yu");
		spellPut("206-191", "wei");
		spellPut("206-192", "wei");
		spellPut("206-193", "wen");
		spellPut("206-194", "wen");
		spellPut("206-195", "wen");
		spellPut("206-196", "wen");
		spellPut("206-197", "wen");
		spellPut("206-198", "wen");
		spellPut("206-199", "wen");
		spellPut("206-200", "wen");
		spellPut("206-201", "wen");
		spellPut("206-202", "wen");
		spellPut("206-203", "weng");
		spellPut("206-204", "weng");
		spellPut("206-205", "weng");
		spellPut("206-206", "zhua,wo");
		spellPut("206-207", "wo");
		spellPut("206-208", "wo,guo");
		spellPut("206-209", "wo");
		spellPut("206-210", "wo");
		spellPut("206-211", "wo,guan");
		spellPut("206-212", "wo");
		spellPut("206-213", "wo");
		spellPut("206-214", "wo");
		spellPut("206-215", "wu");
		spellPut("206-216", "wu");
		spellPut("206-217", "wu");
		spellPut("206-218", "wu");
		spellPut("206-219", "wu");
		spellPut("206-220", "wu");
		spellPut("206-221", "wu");
		spellPut("206-222", "wu");
		spellPut("206-223", "wu");
		spellPut("206-224", "wu");
		spellPut("206-225", "wu,yu");
		spellPut("206-226", "wu");
		spellPut("206-227", "wu");
		spellPut("206-228", "wu");
		spellPut("206-229", "wu");
		spellPut("206-230", "wu");
		spellPut("206-231", "wu");
		spellPut("206-232", "wu");
		spellPut("206-233", "wu");
		spellPut("206-234", "wu");
		spellPut("206-235", "wu");
		spellPut("206-236", "wu");
		spellPut("206-237", "wu");
		spellPut("206-238", "wu");
		spellPut("206-239", "wu");
		spellPut("206-240", "wu");
		spellPut("206-241", "wu");
		spellPut("206-242", "wu");
		spellPut("206-243", "wu");
		spellPut("206-244", "xi");
		spellPut("206-245", "xi");
		spellPut("206-246", "xi");
		spellPut("206-247", "xi");
		spellPut("206-248", "xi");
		spellPut("206-249", "xi");
		spellPut("206-250", "xi");
		spellPut("206-251", "xi");
		spellPut("206-252", "xi");
		spellPut("206-253", "xi");
		spellPut("206-254", "xi");
	}

	private static void init69() {
		spellPut("207-64", "cang");
		spellPut("207-65", "sao");
		spellPut("207-66", "qi");
		spellPut("207-67", "dao");
		spellPut("207-68", "shang");
		spellPut("207-69", "di");
		spellPut("207-70", "lu");
		spellPut("207-71", "wei");
		spellPut("207-72", "die,zhi");
		spellPut("207-73", "chen");
		spellPut("207-74", "qu,ju");
		spellPut("207-75", "pi");
		spellPut("207-76", "yu");
		spellPut("207-77", "chan,jian");
		spellPut("207-78", "lou");
		spellPut("207-79", "qin");
		spellPut("207-80", "yin");
		spellPut("207-81", "jiang");
		spellPut("207-82", "wen");
		spellPut("207-83", "xiao");
		spellPut("207-84", "wan");
		spellPut("207-85", "zhe");
		spellPut("207-86", "zhe");
		spellPut("207-87", "mB");
		spellPut("207-88", "guo");
		spellPut("207-89", "liu");
		spellPut("207-90", "cong");
		spellPut("207-91", "li");
		spellPut("207-92", "man");
		spellPut("207-93", "xiao");
		spellPut("207-94", "chBng");
		spellPut("207-95", "mo");
		spellPut("207-96", "zui");
		spellPut("207-97", "si");
		spellPut("207-98", "qiu");
		spellPut("207-99", "te");
		spellPut("207-100", "zhi");
		spellPut("207-101", "peng");
		spellPut("207-102", "jiao");
		spellPut("207-103", "qu");
		spellPut("207-104", "bie");
		spellPut("207-105", "liao");
		spellPut("207-106", "gui");
		spellPut("207-107", "xi");
		spellPut("207-108", "ji");
		spellPut("207-109", "zhuan");
		spellPut("207-110", "fei,ben");
		spellPut("207-111", "lao,liao");
		spellPut("207-112", "jue");
		spellPut("207-113", "jue");
		spellPut("207-114", "yin,xun");
		spellPut("207-115", "chan");
		spellPut("207-116", "jiao");
		spellPut("207-117", "nao");
		spellPut("207-118", "xiao");
		spellPut("207-119", "wu");
		spellPut("207-120", "chong");
		spellPut("207-121", "xun");
		spellPut("207-122", "si");
		spellPut("207-123", "chu");
		spellPut("207-124", "cheng");
		spellPut("207-125", "dang");
		spellPut("207-126", "li");
		spellPut("207-128", "shan");
		spellPut("207-129", "yi");
		spellPut("207-130", "jing");
		spellPut("207-131", "da");
		spellPut("207-132", "qi");
		spellPut("207-133", "ci");
		spellPut("207-134", "xiang");
		spellPut("207-135", "she");
		spellPut("207-136", "qin");
		spellPut("207-137", "ying");
		spellPut("207-138", "chai");
		spellPut("207-139", "li");
		spellPut("207-140", "zei");
		spellPut("207-141", "xuan");
		spellPut("207-142", "zhu");
		spellPut("207-143", "ze");
		spellPut("207-144", "xie");
		spellPut("207-145", "mang");
		spellPut("207-146", "xie");
		spellPut("207-147", "qi");
		spellPut("207-148", "rong");
		spellPut("207-149", "jian");
		spellPut("207-150", "hao");
		spellPut("207-151", "zhuo");
		spellPut("207-152", "jie");
		spellPut("207-153", "pin");
		spellPut("207-154", "he");
		spellPut("207-155", "fan");
		spellPut("207-156", "lei");
		spellPut("207-157", "jie");
		spellPut("207-158", "la");
		spellPut("207-159", "min");
		spellPut("207-160", "li");
		spellPut("207-161", "xi");
		spellPut("207-162", "xi");
		spellPut("207-163", "xi");
		spellPut("207-164", "xi");
		spellPut("207-165", "xi");
		spellPut("207-166", "xi");
		spellPut("207-167", "xi");
		spellPut("207-168", "xi");
		spellPut("207-169", "xi");
		spellPut("207-170", "xi");
		spellPut("207-171", "xi");
		spellPut("207-172", "xi");
		spellPut("207-173", "xi");
		spellPut("207-174", "xi");
		spellPut("207-175", "xi");
		spellPut("207-176", "xi");
		spellPut("207-177", "xi");
		spellPut("207-178", "xi");
		spellPut("207-179", "xian,xi");
		spellPut("207-180", "xi,xian");
		spellPut("207-181", "xi,ji");
		spellPut("207-182", "xi");
		spellPut("207-183", "xi,hu");
		spellPut("207-184", "xi");
		spellPut("207-185", "xia");
		spellPut("207-186", "xia");
		spellPut("207-187", "xia");
		spellPut("207-188", "xia");
		spellPut("207-189", "xia");
		spellPut("207-190", "xia");
		spellPut("207-191", "xia");
		spellPut("207-192", "xia");
		spellPut("207-193", "xia");
		spellPut("207-194", "xia");
		spellPut("207-195", "sha,xia");
		spellPut("207-196", "xia");
		spellPut("207-197", "xia,he");
		spellPut("207-198", "xian");
		spellPut("207-199", "xian");
		spellPut("207-200", "xian");
		spellPut("207-201", "xian");
		spellPut("207-202", "xian");
		spellPut("207-203", "xian,qian");
		spellPut("207-204", "xian");
		spellPut("207-205", "xian");
		spellPut("207-206", "xian");
		spellPut("207-207", "xian");
		spellPut("207-208", "xian");
		spellPut("207-209", "xian");
		spellPut("207-210", "xian");
		spellPut("207-211", "xian");
		spellPut("207-212", "xian");
		spellPut("207-213", "xian");
		spellPut("207-214", "xian");
		spellPut("207-215", "xian");
		spellPut("207-216", "xian,xuan");
		spellPut("207-217", "xian");
		spellPut("207-218", "xian");
		spellPut("207-219", "xian");
		spellPut("207-220", "xian");
		spellPut("207-221", "xian");
		spellPut("207-222", "xian");
		spellPut("207-223", "xian");
		spellPut("207-224", "xiang");
		spellPut("207-225", "xiang");
		spellPut("207-226", "xiang");
		spellPut("207-227", "xiang");
		spellPut("207-228", "xiang");
		spellPut("207-229", "xiang");
		spellPut("207-230", "xiang");
		spellPut("207-231", "xiang");
		spellPut("207-232", "xiang");
		spellPut("207-233", "xiang");
		spellPut("207-234", "xiang,yang");
		spellPut("207-235", "xiang");
		spellPut("207-236", "xiang");
		spellPut("207-237", "xiang");
		spellPut("207-238", "xiang");
		spellPut("207-239", "xiang,hang");
		spellPut("207-240", "xiang");
		spellPut("207-241", "xiang");
		spellPut("207-242", "xiang");
		spellPut("207-243", "xiang");
		spellPut("207-244", "xiao");
		spellPut("207-245", "xiao");
		spellPut("207-246", "xiao");
		spellPut("207-247", "xiao,xue");
		spellPut("207-248", "xiao");
		spellPut("207-249", "xiao");
		spellPut("207-250", "xiao");
		spellPut("207-251", "xiao");
		spellPut("207-252", "xiao");
		spellPut("207-253", "xiao");
		spellPut("207-254", "xiao");
	}

	private static void init70() {
		spellPut("208-64", "qiu");
		spellPut("208-65", "nie");
		spellPut("208-66", "lu");
		spellPut("208-67", "du");
		spellPut("208-68", "xiao");
		spellPut("208-69", "zhu");
		spellPut("208-70", "long");
		spellPut("208-71", "li");
		spellPut("208-72", "long");
		spellPut("208-73", "feng");
		spellPut("208-74", "ye");
		spellPut("208-75", "pi");
		spellPut("208-76", "nang");
		spellPut("208-77", "gu");
		spellPut("208-78", "ying");
		spellPut("208-79", "shu");
		spellPut("208-80", "xi");
		spellPut("208-81", "can");
		spellPut("208-82", "qu");
		spellPut("208-83", "quan");
		spellPut("208-84", "can");
		spellPut("208-85", "man");
		spellPut("208-86", "jie");
		spellPut("208-87", "zhu");
		spellPut("208-88", "zhuo");
		spellPut("208-89", "huang");
		spellPut("208-90", "nv");
		spellPut("208-91", "pei");
		spellPut("208-92", "zhong");
		spellPut("208-93", "mai");
		spellPut("208-94", "er");
		spellPut("208-95", "ke");
		spellPut("208-96", "mie");
		spellPut("208-97", "xi");
		spellPut("208-98", "kan");
		spellPut("208-99", "yuan");
		spellPut("208-100", "qu");
		spellPut("208-101", "ling");
		spellPut("208-102", "xuan");
		spellPut("208-103", "shu");
		spellPut("208-104", "tong");
		spellPut("208-105", "xiang");
		spellPut("208-106", "xiBn");
		spellPut("208-107", "hu");
		spellPut("208-108", "wei");
		spellPut("208-109", "dao");
		spellPut("208-110", "chong");
		spellPut("208-111", "wei");
		spellPut("208-112", "dao");
		spellPut("208-113", "zhun");
		spellPut("208-114", "gan");
		spellPut("208-115", "yu");
		spellPut("208-116", "yi");
		spellPut("208-117", "fu");
		spellPut("208-118", "fen");
		spellPut("208-119", "jie");
		spellPut("208-120", "zhong");
		spellPut("208-121", "dan");
		spellPut("208-122", "ri");
		spellPut("208-123", "zhong");
		spellPut("208-124", "jie");
		spellPut("208-125", "zhi");
		spellPut("208-126", "xie");
		spellPut("208-128", "ran");
		spellPut("208-129", "zhi");
		spellPut("208-130", "jun");
		spellPut("208-131", "chai");
		spellPut("208-132", "hui");
		spellPut("208-133", "ran");
		spellPut("208-134", "tuo");
		spellPut("208-135", "ling");
		spellPut("208-136", "bao,pao");
		spellPut("208-137", "yao");
		spellPut("208-138", "zuo");
		spellPut("208-139", "bi");
		spellPut("208-140", "shao");
		spellPut("208-141", "ju,jie");
		spellPut("208-142", "he,ke");
		spellPut("208-143", "xue");
		spellPut("208-144", "zhen");
		spellPut("208-145", "yi");
		spellPut("208-146", "pa");
		spellPut("208-147", "fu");
		spellPut("208-148", "di");
		spellPut("208-149", "fu");
		spellPut("208-150", "gun");
		spellPut("208-151", "zhi");
		spellPut("208-152", "zhi");
		spellPut("208-153", "ran");
		spellPut("208-154", "yi");
		spellPut("208-155", "tuo");
		spellPut("208-156", "na,jue");
		spellPut("208-157", "gou");
		spellPut("208-158", "xuan");
		spellPut("208-159", "zhe");
		spellPut("208-160", "qu");
		spellPut("208-161", "xiao");
		spellPut("208-162", "xiao");
		spellPut("208-163", "xiao,jiao");
		spellPut("208-164", "xiao");
		spellPut("208-165", "xiao");
		spellPut("208-166", "xiao");
		spellPut("208-167", "xiao");
		spellPut("208-168", "xie");
		spellPut("208-169", "xie,suo");
		spellPut("208-170", "xie");
		spellPut("208-171", "xie");
		spellPut("208-172", "xie");
		spellPut("208-173", "xie");
		spellPut("208-174", "xie,jia");
		spellPut("208-175", "xie");
		spellPut("208-176", "xie,ya,ye,yu,xu");
		spellPut("208-177", "xie");
		spellPut("208-178", "xie");
		spellPut("208-179", "xie");
		spellPut("208-180", "xie");
		spellPut("208-181", "xie");
		spellPut("208-182", "xie");
		spellPut("208-183", "xie");
		spellPut("208-184", "xie");
		spellPut("208-185", "xie,yi");
		spellPut("208-186", "xie");
		spellPut("208-187", "xie");
		spellPut("208-188", "xie");
		spellPut("208-189", "xin");
		spellPut("208-190", "xin");
		spellPut("208-191", "xin");
		spellPut("208-192", "xin");
		spellPut("208-193", "xin");
		spellPut("208-194", "xin");
		spellPut("208-195", "xin");
		spellPut("208-196", "xin");
		spellPut("208-197", "xin,shen");
		spellPut("208-198", "xin");
		spellPut("208-199", "xing");
		spellPut("208-200", "xing");
		spellPut("208-201", "xing");
		spellPut("208-202", "xing");
		spellPut("208-203", "xing");
		spellPut("208-204", "xing");
		spellPut("208-205", "xing");
		spellPut("208-206", "xing");
		spellPut("208-207", "xing");
		spellPut("208-208", "xing");
		spellPut("208-209", "xing");
		spellPut("208-210", "xing");
		spellPut("208-211", "xing");
		spellPut("208-212", "xing");
		spellPut("208-213", "xing");
		spellPut("208-214", "xiong");
		spellPut("208-215", "xiong");
		spellPut("208-216", "xiong");
		spellPut("208-217", "xiong");
		spellPut("208-218", "xiong");
		spellPut("208-219", "xiong");
		spellPut("208-220", "xiong");
		spellPut("208-221", "xiu,xu");
		spellPut("208-222", "xiu");
		spellPut("208-223", "xiu");
		spellPut("208-224", "xiu");
		spellPut("208-225", "xiu");
		spellPut("208-226", "xiu");
		spellPut("208-227", "xiu");
		spellPut("208-228", "xiu");
		spellPut("208-229", "xiu");
		spellPut("208-230", "xu");
		spellPut("208-231", "xu");
		spellPut("208-232", "xu");
		spellPut("208-233", "xu");
		spellPut("208-234", "xu,shi");
		spellPut("208-235", "xu");
		spellPut("208-236", "xu");
		spellPut("208-237", "xu,hu");
		spellPut("208-238", "xu");
		spellPut("208-239", "xu");
		spellPut("208-240", "xu");
		spellPut("208-241", "xu");
		spellPut("208-242", "xu");
		spellPut("208-243", "xu,chu");
		spellPut("208-244", "xu");
		spellPut("208-245", "xu");
		spellPut("208-246", "xu");
		spellPut("208-247", "xu");
		spellPut("208-248", "xu");
		spellPut("208-249", "xuan");
		spellPut("208-250", "xuan");
		spellPut("208-251", "xuan");
		spellPut("208-252", "xuan");
		spellPut("208-253", "xuan");
		spellPut("208-254", "xuan");
	}

	private static void init71() {
		spellPut("209-64", "yu");
		spellPut("209-65", "mi");
		spellPut("209-66", "bo");
		spellPut("209-67", "uu");
		spellPut("209-68", "chi,nuo");
		spellPut("209-69", "chi,qi,duo,nuo");
		spellPut("209-70", "ku");
		spellPut("209-71", "ren");
		spellPut("209-72", "peng");
		spellPut("209-73", "jian,zun");
		spellPut("209-74", "bo,mo");
		spellPut("209-75", "jie");
		spellPut("209-76", "er");
		spellPut("209-77", "ru");
		spellPut("209-78", "zhu");
		spellPut("209-79", "gui,gua");
		spellPut("209-80", "yin");
		spellPut("209-81", "ka mi xi mo");
		spellPut("209-82", "hang");
		spellPut("209-83", "xu");
		spellPut("209-84", "kun");
		spellPut("209-85", "niao");
		spellPut("209-86", "shu");
		spellPut("209-87", "jia");
		spellPut("209-88", "kun");
		spellPut("209-89", "li");
		spellPut("209-90", "juan");
		spellPut("209-91", "shen");
		spellPut("209-92", "ge,jie");
		spellPut("209-93", "zhen");
		spellPut("209-94", "liu");
		spellPut("209-95", "ji");
		spellPut("209-96", "yi");
		spellPut("209-97", "bu");
		spellPut("209-98", "zhuang");
		spellPut("209-99", "shui");
		spellPut("209-100", "qun");
		spellPut("209-101", "li");
		spellPut("209-102", "bao");
		spellPut("209-103", "chan");
		spellPut("209-104", "kun");
		spellPut("209-105", "tao");
		spellPut("209-106", "yuan");
		spellPut("209-107", "ling");
		spellPut("209-108", "chi");
		spellPut("209-109", "chang");
		spellPut("209-110", "chou,dao");
		spellPut("209-111", "liang");
		spellPut("209-112", "pei");
		spellPut("209-113", "fei");
		spellPut("209-114", "yuan,gun");
		spellPut("209-115", "yan,an");
		spellPut("209-116", "du");
		spellPut("209-117", "zhi");
		spellPut("209-118", "yi");
		spellPut("209-119", "qi");
		spellPut("209-120", "guo");
		spellPut("209-121", "ken");
		spellPut("209-122", "qi");
		spellPut("209-123", "ti");
		spellPut("209-124", "ti");
		spellPut("209-125", "fu");
		spellPut("209-126", "chong");
		spellPut("209-128", "xie");
		spellPut("209-129", "die");
		spellPut("209-130", "kun");
		spellPut("209-131", "duan");
		spellPut("209-132", "xiu");
		spellPut("209-133", "xiu");
		spellPut("209-134", "yuan");
		spellPut("209-135", "fu");
		spellPut("209-136", "yu");
		spellPut("209-137", "tuan");
		spellPut("209-138", "yan");
		spellPut("209-139", "hui");
		spellPut("209-140", "pBo");
		spellPut("209-141", "dan");
		spellPut("209-142", "yun");
		spellPut("209-143", "ta");
		spellPut("209-144", "gou");
		spellPut("209-145", "huai");
		spellPut("209-146", "rong");
		spellPut("209-147", "yuan");
		spellPut("209-148", "nai");
		spellPut("209-149", "jiong");
		spellPut("209-150", "suo");
		spellPut("209-151", "ban");
		spellPut("209-152", "sang");
		spellPut("209-153", "niao");
		spellPut("209-154", "ying");
		spellPut("209-155", "jie");
		spellPut("209-156", "huai");
		spellPut("209-157", "ku");
		spellPut("209-158", "lian");
		spellPut("209-159", "li");
		spellPut("209-160", "shi");
		spellPut("209-161", "xuan");
		spellPut("209-162", "xuan");
		spellPut("209-163", "xuan");
		spellPut("209-164", "xuan");
		spellPut("209-165", "xue");
		spellPut("209-166", "xue");
		spellPut("209-167", "xue");
		spellPut("209-168", "xue");
		spellPut("209-169", "xue");
		spellPut("209-170", "xue");
		spellPut("209-171", "xun");
		spellPut("209-172", "xun");
		spellPut("209-173", "xun");
		spellPut("209-174", "xun");
		spellPut("209-175", "xun");
		spellPut("209-176", "xun");
		spellPut("209-177", "xun");
		spellPut("209-178", "xun");
		spellPut("209-179", "xun");
		spellPut("209-180", "xun");
		spellPut("209-181", "xun");
		spellPut("209-182", "xun");
		spellPut("209-183", "xun");
		spellPut("209-184", "xun");
		spellPut("209-185", "ya");
		spellPut("209-186", "ya");
		spellPut("209-187", "ya");
		spellPut("209-188", "ya");
		spellPut("209-189", "ya,yB");
		spellPut("209-190", "ya");
		spellPut("209-191", "ya");
		spellPut("209-192", "ya");
		spellPut("209-193", "ya");
		spellPut("209-194", "ya");
		spellPut("209-195", "ya");
		spellPut("209-196", "ya");
		spellPut("209-197", "ya");
		spellPut("209-198", "ya");
		spellPut("209-199", "ya");
		spellPut("209-200", "ya");
		spellPut("209-201", "yan");
		spellPut("209-202", "yan,ye");
		spellPut("209-203", "yan");
		spellPut("209-204", "yan");
		spellPut("209-205", "yan");
		spellPut("209-206", "yan");
		spellPut("209-207", "yan");
		spellPut("209-208", "yan");
		spellPut("209-209", "yan");
		spellPut("209-210", "yan");
		spellPut("209-211", "yan");
		spellPut("209-212", "yan");
		spellPut("209-213", "yan");
		spellPut("209-214", "yan");
		spellPut("209-215", "yan");
		spellPut("209-216", "yan");
		spellPut("209-217", "yan");
		spellPut("209-218", "yan");
		spellPut("209-219", "yan");
		spellPut("209-220", "yan");
		spellPut("209-221", "yan");
		spellPut("209-222", "yan");
		spellPut("209-223", "yan");
		spellPut("209-224", "yan");
		spellPut("209-225", "yan");
		spellPut("209-226", "yan");
		spellPut("209-227", "yan");
		spellPut("209-228", "yan");
		spellPut("209-229", "yan");
		spellPut("209-230", "yan");
		spellPut("209-231", "yan");
		spellPut("209-232", "yan");
		spellPut("209-233", "yan");
		spellPut("209-234", "yang");
		spellPut("209-235", "yang");
		spellPut("209-236", "yang");
		spellPut("209-237", "yang");
		spellPut("209-238", "yang");
		spellPut("209-239", "yang");
		spellPut("209-240", "yang");
		spellPut("209-241", "yang");
		spellPut("209-242", "yang,xiang");
		spellPut("209-243", "yang");
		spellPut("209-244", "yang");
		spellPut("209-245", "yang");
		spellPut("209-246", "yang,ang");
		spellPut("209-247", "yang");
		spellPut("209-248", "yang");
		spellPut("209-249", "yang");
		spellPut("209-250", "yang");
		spellPut("209-251", "yao");
		spellPut("209-252", "yao");
		spellPut("209-253", "yao");
		spellPut("209-254", "yao");
	}

	private static void init72() {
		spellPut("210-64", "lv");
		spellPut("210-65", "yi");
		spellPut("210-66", "die");
		spellPut("210-67", "xie");
		spellPut("210-68", "xian");
		spellPut("210-69", "wei");
		spellPut("210-70", "biao");
		spellPut("210-71", "cao");
		spellPut("210-72", "ji");
		spellPut("210-73", "sen");
		spellPut("210-74", "bao");
		spellPut("210-75", "qi ha ya");
		spellPut("210-76", "fu");
		spellPut("210-77", "jian");
		spellPut("210-78", "zhuan");
		spellPut("210-79", "jian");
		spellPut("210-80", "cui");
		spellPut("210-81", "ji");
		spellPut("210-82", "dan");
		spellPut("210-83", "za");
		spellPut("210-84", "fan");
		spellPut("210-85", "bo");
		spellPut("210-86", "xiang");
		spellPut("210-87", "xin");
		spellPut("210-88", "bie");
		spellPut("210-89", "rao");
		spellPut("210-90", "mBn");
		spellPut("210-91", "lan");
		spellPut("210-92", "ao");
		spellPut("210-93", "ze");
		spellPut("210-94", "gui");
		spellPut("210-95", "cao");
		spellPut("210-96", "sui");
		spellPut("210-97", "nong");
		spellPut("210-98", "chan");
		spellPut("210-99", "lian");
		spellPut("210-100", "dang");
		spellPut("210-101", "shu");
		spellPut("210-102", "tan");
		spellPut("210-103", "bi");
		spellPut("210-104", "lan");
		spellPut("210-105", "fu");
		spellPut("210-106", "zhi");
		spellPut("210-107", "tB e");
		spellPut("210-108", "shu");
		spellPut("210-109", "wa");
		spellPut("210-110", "shi");
		spellPut("210-111", "bai");
		spellPut("210-112", "xie");
		spellPut("210-113", "bo");
		spellPut("210-114", "chen");
		spellPut("210-115", "lai");
		spellPut("210-116", "long");
		spellPut("210-117", "xi");
		spellPut("210-118", "xian");
		spellPut("210-119", "lan");
		spellPut("210-120", "zhe");
		spellPut("210-121", "dai");
		spellPut("210-122", "ta si ki");
		spellPut("210-123", "zan");
		spellPut("210-124", "shi");
		spellPut("210-125", "jian");
		spellPut("210-126", "yi");
		spellPut("210-128", "lan");
		spellPut("210-129", "ya");
		spellPut("210-130", "ya");
		spellPut("210-131", "feng");
		spellPut("210-132", "fu");
		spellPut("210-133", "fiao");
		spellPut("210-134", "ba,po");
		spellPut("210-135", "he");
		spellPut("210-136", "ji");
		spellPut("210-137", "ji");
		spellPut("210-138", "jian,xian");
		spellPut("210-139", "guan");
		spellPut("210-140", "bian");
		spellPut("210-141", "yan");
		spellPut("210-142", "gui");
		spellPut("210-143", "jue,jiao");
		spellPut("210-144", "pian");
		spellPut("210-145", "mao");
		spellPut("210-146", "mi");
		spellPut("210-147", "mi");
		spellPut("210-148", "pie,mie");
		spellPut("210-149", "shi");
		spellPut("210-150", "si");
		spellPut("210-151", "chan");
		spellPut("210-152", "zhen");
		spellPut("210-153", "jue,jiao");
		spellPut("210-154", "mi");
		spellPut("210-155", "tiao");
		spellPut("210-156", "lian");
		spellPut("210-157", "yao");
		spellPut("210-158", "zhi");
		spellPut("210-159", "jun");
		spellPut("210-160", "xi");
		spellPut("210-161", "yao");
		spellPut("210-162", "yao");
		spellPut("210-163", "yao");
		spellPut("210-164", "yao");
		spellPut("210-165", "yao");
		spellPut("210-166", "yao");
		spellPut("210-167", "yao");
		spellPut("210-168", "yao");
		spellPut("210-169", "yao");
		spellPut("210-170", "yao");
		spellPut("210-171", "yao");
		spellPut("210-172", "ye");
		spellPut("210-173", "ye");
		spellPut("210-174", "ye");
		spellPut("210-175", "ye");
		spellPut("210-176", "ye");
		spellPut("210-177", "ye");
		spellPut("210-178", "ye");
		spellPut("210-179", "ye");
		spellPut("210-180", "ye");
		spellPut("210-181", "ye");
		spellPut("210-182", "ye,xie");
		spellPut("210-183", "ye");
		spellPut("210-184", "ye");
		spellPut("210-185", "ye");
		spellPut("210-186", "ye");
		spellPut("210-187", "yi");
		spellPut("210-188", "yi");
		spellPut("210-189", "yi");
		spellPut("210-190", "yi");
		spellPut("210-191", "yi");
		spellPut("210-192", "yi");
		spellPut("210-193", "yi");
		spellPut("210-194", "yi");
		spellPut("210-195", "yi");
		spellPut("210-196", "yi");
		spellPut("210-197", "yi");
		spellPut("210-198", "yi");
		spellPut("210-199", "yi");
		spellPut("210-200", "yi");
		spellPut("210-201", "yi,ni");
		spellPut("210-202", "yi");
		spellPut("210-203", "yi");
		spellPut("210-204", "yi");
		spellPut("210-205", "yi");
		spellPut("210-206", "yi");
		spellPut("210-207", "yi");
		spellPut("210-208", "yi");
		spellPut("210-209", "yi");
		spellPut("210-210", "yi");
		spellPut("210-211", "yi");
		spellPut("210-212", "yi");
		spellPut("210-213", "yi");
		spellPut("210-214", "yi");
		spellPut("210-215", "yi");
		spellPut("210-216", "yi");
		spellPut("210-217", "yi");
		spellPut("210-218", "yi");
		spellPut("210-219", "yi");
		spellPut("210-220", "yi");
		spellPut("210-221", "yi");
		spellPut("210-222", "yi");
		spellPut("210-223", "yi");
		spellPut("210-224", "yi");
		spellPut("210-225", "yi");
		spellPut("210-226", "yi");
		spellPut("210-227", "yi");
		spellPut("210-228", "yi");
		spellPut("210-229", "yi");
		spellPut("210-230", "yi");
		spellPut("210-231", "yi");
		spellPut("210-232", "yi");
		spellPut("210-233", "yi");
		spellPut("210-234", "yi");
		spellPut("210-235", "yi");
		spellPut("210-236", "yi");
		spellPut("210-237", "yi");
		spellPut("210-238", "yi");
		spellPut("210-239", "yi");
		spellPut("210-240", "yin");
		spellPut("210-241", "yin");
		spellPut("210-242", "yin");
		spellPut("210-243", "yin,yan");
		spellPut("210-244", "yin");
		spellPut("210-245", "yin");
		spellPut("210-246", "yin");
		spellPut("210-247", "yin");
		spellPut("210-248", "yin");
		spellPut("210-249", "yin");
		spellPut("210-250", "yin");
		spellPut("210-251", "yin");
		spellPut("210-252", "yin");
		spellPut("210-253", "yin");
		spellPut("210-254", "yin");
	}

	private static void init73() {
		spellPut("211-64", "shan");
		spellPut("211-65", "wei");
		spellPut("211-66", "xi");
		spellPut("211-67", "tian");
		spellPut("211-68", "yu");
		spellPut("211-69", "lan");
		spellPut("211-70", "e");
		spellPut("211-71", "du");
		spellPut("211-72", "qin,qing");
		spellPut("211-73", "pang");
		spellPut("211-74", "ji");
		spellPut("211-75", "ming");
		spellPut("211-76", "ying");
		spellPut("211-77", "gou");
		spellPut("211-78", "qu");
		spellPut("211-79", "zhan");
		spellPut("211-80", "jin");
		spellPut("211-81", "guan");
		spellPut("211-82", "deng");
		spellPut("211-83", "jian,bian");
		spellPut("211-84", "luo,luan");
		spellPut("211-85", "qu");
		spellPut("211-86", "jian");
		spellPut("211-87", "wei");
		spellPut("211-88", "jue,jiao");
		spellPut("211-89", "qu");
		spellPut("211-90", "luo");
		spellPut("211-91", "lan");
		spellPut("211-92", "shen");
		spellPut("211-93", "di");
		spellPut("211-94", "guan");
		spellPut("211-95", "yan");
		spellPut("211-96", "tian");
		spellPut("211-97", "qiu");
		spellPut("211-98", "jin");
		spellPut("211-99", "cu");
		spellPut("211-100", "zhi");
		spellPut("211-101", "chao");
		spellPut("211-102", "ji");
		spellPut("211-103", "dan");
		spellPut("211-104", "di");
		spellPut("211-105", "hua,xie");
		spellPut("211-106", "quan");
		spellPut("211-107", "ge");
		spellPut("211-108", "shi");
		spellPut("211-109", "gui");
		spellPut("211-110", "jie,xie");
		spellPut("211-111", "hun");
		spellPut("211-112", "qiu");
		spellPut("211-113", "xing");
		spellPut("211-114", "ni");
		spellPut("211-115", "ji,qi");
		spellPut("211-116", "jue");
		spellPut("211-117", "zha");
		spellPut("211-118", "bi");
		spellPut("211-119", "xing");
		spellPut("211-120", "shang");
		spellPut("211-121", "gong");
		spellPut("211-122", "zhi");
		spellPut("211-123", "xue,hu");
		spellPut("211-124", "chu");
		spellPut("211-125", "xi");
		spellPut("211-126", "yi");
		spellPut("211-128", "li,lu");
		spellPut("211-129", "jue");
		spellPut("211-130", "xi");
		spellPut("211-131", "yan");
		spellPut("211-132", "xi");
		spellPut("211-133", "yan");
		spellPut("211-134", "ding");
		spellPut("211-135", "fu");
		spellPut("211-136", "qiu");
		spellPut("211-137", "qiu");
		spellPut("211-138", "jiao");
		spellPut("211-139", "ji");
		spellPut("211-140", "fan");
		spellPut("211-141", "xun");
		spellPut("211-142", "diao");
		spellPut("211-143", "hong");
		spellPut("211-144", "chai");
		spellPut("211-145", "tao");
		spellPut("211-146", "xu");
		spellPut("211-147", "jie");
		spellPut("211-148", "dan");
		spellPut("211-149", "ren");
		spellPut("211-150", "xun");
		spellPut("211-151", "yin");
		spellPut("211-152", "shan");
		spellPut("211-153", "qi");
		spellPut("211-154", "tuo");
		spellPut("211-155", "ji");
		spellPut("211-156", "xun");
		spellPut("211-157", "yin");
		spellPut("211-158", "e");
		spellPut("211-159", "fen");
		spellPut("211-160", "ya");
		spellPut("211-161", "yin");
		spellPut("211-162", "ying");
		spellPut("211-163", "ying");
		spellPut("211-164", "ying");
		spellPut("211-165", "ying");
		spellPut("211-166", "ying");
		spellPut("211-167", "ying");
		spellPut("211-168", "ying");
		spellPut("211-169", "ying");
		spellPut("211-170", "ying");
		spellPut("211-171", "ying");
		spellPut("211-172", "ying");
		spellPut("211-173", "ying");
		spellPut("211-174", "ying");
		spellPut("211-175", "ying");
		spellPut("211-176", "ying");
		spellPut("211-177", "ying");
		spellPut("211-178", "ying");
		spellPut("211-179", "ying");
		spellPut("211-180", "yo");
		spellPut("211-181", "yong");
		spellPut("211-182", "yong");
		spellPut("211-183", "yong");
		spellPut("211-184", "yong");
		spellPut("211-185", "yong");
		spellPut("211-186", "yong");
		spellPut("211-187", "yong");
		spellPut("211-188", "yong");
		spellPut("211-189", "yong");
		spellPut("211-190", "yong");
		spellPut("211-191", "yong,chong");
		spellPut("211-192", "yong");
		spellPut("211-193", "yong");
		spellPut("211-194", "yong");
		spellPut("211-195", "yong");
		spellPut("211-196", "you");
		spellPut("211-197", "you");
		spellPut("211-198", "you");
		spellPut("211-199", "you");
		spellPut("211-200", "you");
		spellPut("211-201", "you");
		spellPut("211-202", "you");
		spellPut("211-203", "you");
		spellPut("211-204", "you");
		spellPut("211-205", "you");
		spellPut("211-206", "you");
		spellPut("211-207", "you");
		spellPut("211-208", "you");
		spellPut("211-209", "you");
		spellPut("211-210", "you");
		spellPut("211-211", "you");
		spellPut("211-212", "you");
		spellPut("211-213", "you");
		spellPut("211-214", "you");
		spellPut("211-215", "you");
		spellPut("211-216", "yu");
		spellPut("211-217", "yu");
		spellPut("211-218", "yu");
		spellPut("211-219", "yu");
		spellPut("211-220", "yu");
		spellPut("211-221", "yu");
		spellPut("211-222", "yu");
		spellPut("211-223", "yu");
		spellPut("211-224", "yu");
		spellPut("211-225", "yu,shu");
		spellPut("211-226", "yu");
		spellPut("211-227", "yu");
		spellPut("211-228", "yu,tou");
		spellPut("211-229", "yu");
		spellPut("211-230", "yu");
		spellPut("211-231", "yu");
		spellPut("211-232", "yu");
		spellPut("211-233", "yu");
		spellPut("211-234", "yu");
		spellPut("211-235", "yu");
		spellPut("211-236", "yu");
		spellPut("211-237", "yu");
		spellPut("211-238", "yu");
		spellPut("211-239", "yu");
		spellPut("211-240", "yu");
		spellPut("211-241", "yu");
		spellPut("211-242", "yu");
		spellPut("211-243", "yu");
		spellPut("211-244", "yu");
		spellPut("211-245", "xu,yu");
		spellPut("211-246", "yu");
		spellPut("211-247", "yu");
		spellPut("211-248", "yu");
		spellPut("211-249", "yu");
		spellPut("211-250", "yu");
		spellPut("211-251", "yu");
		spellPut("211-252", "yu");
		spellPut("211-253", "yu");
		spellPut("211-254", "yu");
	}

	private static void init74() {
		spellPut("212-64", "yao");
		spellPut("212-65", "song");
		spellPut("212-66", "shen");
		spellPut("212-67", "yin");
		spellPut("212-68", "xin");
		spellPut("212-69", "jue");
		spellPut("212-70", "xiao");
		spellPut("212-71", "ne");
		spellPut("212-72", "chen");
		spellPut("212-73", "you");
		spellPut("212-74", "zhi");
		spellPut("212-75", "xiong");
		spellPut("212-76", "fang");
		spellPut("212-77", "xin");
		spellPut("212-78", "chao");
		spellPut("212-79", "she");
		spellPut("212-80", "yan");
		spellPut("212-81", "sa");
		spellPut("212-82", "zhun");
		spellPut("212-83", "xu");
		spellPut("212-84", "yi");
		spellPut("212-85", "yi");
		spellPut("212-86", "su");
		spellPut("212-87", "chi");
		spellPut("212-88", "he");
		spellPut("212-89", "shen");
		spellPut("212-90", "he");
		spellPut("212-91", "xu");
		spellPut("212-92", "zhen");
		spellPut("212-93", "zhu");
		spellPut("212-94", "zheng");
		spellPut("212-95", "gou");
		spellPut("212-96", "zi");
		spellPut("212-97", "zhan");
		spellPut("212-98", "gu");
		spellPut("212-99", "fu");
		spellPut("212-100", "jian");
		spellPut("212-101", "die");
		spellPut("212-102", "ling");
		spellPut("212-103", "di");
		spellPut("212-104", "yang");
		spellPut("212-105", "nao");
		spellPut("212-106", "pan");
		spellPut("212-107", "zhou");
		spellPut("212-108", "gan");
		spellPut("212-109", "yi");
		spellPut("212-110", "ju");
		spellPut("212-111", "yao");
		spellPut("212-112", "zha");
		spellPut("212-113", "tuo");
		spellPut("212-114", "yi");
		spellPut("212-115", "qu");
		spellPut("212-116", "zhao");
		spellPut("212-117", "ping");
		spellPut("212-118", "bi");
		spellPut("212-119", "xiong");
		spellPut("212-120", "qu");
		spellPut("212-121", "ba");
		spellPut("212-122", "da");
		spellPut("212-123", "zu");
		spellPut("212-124", "tao");
		spellPut("212-125", "nuo");
		spellPut("212-126", "ci");
		spellPut("212-128", "zhe");
		spellPut("212-129", "yong");
		spellPut("212-130", "xu");
		spellPut("212-131", "xun");
		spellPut("212-132", "yi");
		spellPut("212-133", "huang");
		spellPut("212-134", "he");
		spellPut("212-135", "shi");
		spellPut("212-136", "cha");
		spellPut("212-137", "xiao");
		spellPut("212-138", "shi");
		spellPut("212-139", "hen");
		spellPut("212-140", "cha");
		spellPut("212-141", "gou");
		spellPut("212-142", "gui");
		spellPut("212-143", "quan");
		spellPut("212-144", "hui");
		spellPut("212-145", "jie");
		spellPut("212-146", "hua");
		spellPut("212-147", "gai");
		spellPut("212-148", "xiang");
		spellPut("212-149", "wei");
		spellPut("212-150", "shen");
		spellPut("212-151", "chou");
		spellPut("212-152", "tong");
		spellPut("212-153", "mi");
		spellPut("212-154", "ming");
		spellPut("212-155", "luo");
		spellPut("212-156", "hui");
		spellPut("212-157", "yan");
		spellPut("212-158", "xiong");
		spellPut("212-159", "gua");
		spellPut("212-160", "er");
		spellPut("212-161", "yu");
		spellPut("212-162", "yu");
		spellPut("212-163", "yu");
		spellPut("212-164", "yu");
		spellPut("212-165", "yu");
		spellPut("212-166", "yu");
		spellPut("212-167", "yuan");
		spellPut("212-168", "yuan");
		spellPut("212-169", "yuan");
		spellPut("212-170", "yuan");
		spellPut("212-171", "yuan");
		spellPut("212-172", "yuan");
		spellPut("212-173", "yuan");
		spellPut("212-174", "yuan");
		spellPut("212-175", "yuan");
		spellPut("212-176", "yuan");
		spellPut("212-177", "yuan,yun");
		spellPut("212-178", "yuan");
		spellPut("212-179", "yuan");
		spellPut("212-180", "yuan");
		spellPut("212-181", "yuan");
		spellPut("212-182", "yuan");
		spellPut("212-183", "yuan");
		spellPut("212-184", "yuan");
		spellPut("212-185", "yuan");
		spellPut("212-186", "yuan");
		spellPut("212-187", "yue");
		spellPut("212-188", "yue,yao");
		spellPut("212-189", "yue");
		spellPut("212-190", "yue");
		spellPut("212-191", "yue,yao");
		spellPut("212-192", "yue");
		spellPut("212-193", "yue");
		spellPut("212-194", "yue");
		spellPut("212-195", "yue");
		spellPut("212-196", "yue");
		spellPut("212-197", "yun");
		spellPut("212-198", "yun");
		spellPut("212-199", "yun");
		spellPut("212-200", "yun");
		spellPut("212-201", "yun");
		spellPut("212-202", "yun");
		spellPut("212-203", "yun");
		spellPut("212-204", "yun");
		spellPut("212-205", "yun");
		spellPut("212-206", "yun");
		spellPut("212-207", "yun");
		spellPut("212-208", "yun");
		spellPut("212-209", "za");
		spellPut("212-210", "za");
		spellPut("212-211", "za");
		spellPut("212-212", "zai");
		spellPut("212-213", "zai");
		spellPut("212-214", "zai");
		spellPut("212-215", "zai");
		spellPut("212-216", "zai");
		spellPut("212-217", "zai");
		spellPut("212-218", "zai");
		spellPut("212-219", "zan,za,zBn");
		spellPut("212-220", "zan,cuan");
		spellPut("212-221", "zan");
		spellPut("212-222", "zan");
		spellPut("212-223", "zang");
		spellPut("212-224", "zang");
		spellPut("212-225", "zang");
		spellPut("212-226", "zao");
		spellPut("212-227", "zao");
		spellPut("212-228", "zao");
		spellPut("212-229", "zao");
		spellPut("212-230", "zao");
		spellPut("212-231", "zao");
		spellPut("212-232", "zao");
		spellPut("212-233", "zao");
		spellPut("212-234", "zao");
		spellPut("212-235", "zao");
		spellPut("212-236", "zao");
		spellPut("212-237", "zao");
		spellPut("212-238", "zao");
		spellPut("212-239", "zao");
		spellPut("212-240", "ze");
		spellPut("212-241", "ze,zhai");
		spellPut("212-242", "ze");
		spellPut("212-243", "ze,shi");
		spellPut("212-244", "zei");
		spellPut("212-245", "zen");
		spellPut("212-246", "zeng");
		spellPut("212-247", "zeng");
		spellPut("212-248", "zeng,ceng");
		spellPut("212-249", "zeng");
		spellPut("212-250", "za,zha");
		spellPut("212-251", "zha,cha");
		spellPut("212-252", "zha");
		spellPut("212-253", "zha");
		spellPut("212-254", "ya");
	}

	private static void init75() {
		spellPut("213-64", "bing");
		spellPut("213-65", "tiao,diao");
		spellPut("213-66", "yi,chi");
		spellPut("213-67", "lei");
		spellPut("213-68", "zhu");
		spellPut("213-69", "kuang");
		spellPut("213-70", "kua");
		spellPut("213-71", "wu");
		spellPut("213-72", "ji");
		spellPut("213-73", "zhi");
		spellPut("213-74", "ren");
		spellPut("213-75", "cu");
		spellPut("213-76", "lang");
		spellPut("213-77", "e");
		spellPut("213-78", "kuang");
		spellPut("213-79", "ei,xi");
		spellPut("213-80", "ting");
		spellPut("213-81", "dan");
		spellPut("213-82", "bei,bo");
		spellPut("213-83", "chan");
		spellPut("213-84", "you");
		spellPut("213-85", "keng");
		spellPut("213-86", "qiao");
		spellPut("213-87", "qin");
		spellPut("213-88", "shua");
		spellPut("213-89", "an");
		spellPut("213-90", "yu");
		spellPut("213-91", "xiao");
		spellPut("213-92", "cheng");
		spellPut("213-93", "jie");
		spellPut("213-94", "xian");
		spellPut("213-95", "wu");
		spellPut("213-96", "wu");
		spellPut("213-97", "gao");
		spellPut("213-98", "song");
		spellPut("213-99", "bu");
		spellPut("213-100", "hui");
		spellPut("213-101", "jing");
		spellPut("213-102", "shuo,shui,yue");
		spellPut("213-103", "zhen");
		spellPut("213-104", "shuo,shui,yue");
		spellPut("213-105", "du");
		spellPut("213-106", "huB");
		spellPut("213-107", "chang");
		spellPut("213-108", "shui,shei");
		spellPut("213-109", "jie");
		spellPut("213-110", "ke");
		spellPut("213-111", "qu,jue");
		spellPut("213-112", "cong");
		spellPut("213-113", "xiao");
		spellPut("213-114", "sui");
		spellPut("213-115", "wang");
		spellPut("213-116", "xian");
		spellPut("213-117", "fei");
		spellPut("213-118", "chi,lai");
		spellPut("213-119", "ta");
		spellPut("213-120", "yi");
		spellPut("213-121", "ni,na");
		spellPut("213-122", "yin");
		spellPut("213-123", "diao,tiao");
		spellPut("213-124", "pi,bei");
		spellPut("213-125", "zhuo");
		spellPut("213-126", "chan");
		spellPut("213-128", "chen");
		spellPut("213-129", "zhun");
		spellPut("213-130", "ji");
		spellPut("213-131", "ji");
		spellPut("213-132", "tan");
		spellPut("213-133", "zhui");
		spellPut("213-134", "wei");
		spellPut("213-135", "ju");
		spellPut("213-136", "qing");
		spellPut("213-137", "dong");
		spellPut("213-138", "zheng");
		spellPut("213-139", "ze,zuo,zha,cuo");
		spellPut("213-140", "zou");
		spellPut("213-141", "qian");
		spellPut("213-142", "zhuo");
		spellPut("213-143", "liang");
		spellPut("213-144", "jian");
		spellPut("213-145", "chu,ji");
		spellPut("213-146", "xia,hao");
		spellPut("213-147", "lun");
		spellPut("213-148", "shen");
		spellPut("213-149", "biao");
		spellPut("213-150", "hua");
		spellPut("213-151", "bian");
		spellPut("213-152", "yu");
		spellPut("213-153", "die");
		spellPut("213-154", "xu");
		spellPut("213-155", "pian");
		spellPut("213-156", "shi,di");
		spellPut("213-157", "xuan");
		spellPut("213-158", "shi");
		spellPut("213-159", "hun");
		spellPut("213-160", "hua,gua");
		spellPut("213-161", "zha");
		spellPut("213-162", "zha");
		spellPut("213-163", "zha");
		spellPut("213-164", "zha,shan,shi,ce");
		spellPut("213-165", "zha");
		spellPut("213-166", "zha,za");
		spellPut("213-167", "zha");
		spellPut("213-168", "zha");
		spellPut("213-169", "zha");
		spellPut("213-170", "zhai");
		spellPut("213-171", "zhai");
		spellPut("213-172", "zhai");
		spellPut("213-173", "zhai");
		spellPut("213-174", "zhai");
		spellPut("213-175", "zhai");
		spellPut("213-176", "zhan");
		spellPut("213-177", "zhan");
		spellPut("213-178", "zhan");
		spellPut("213-179", "zhan");
		spellPut("213-180", "zhan");
		spellPut("213-181", "zhan");
		spellPut("213-182", "zhan");
		spellPut("213-183", "zhan,nian");
		spellPut("213-184", "zhan,chan");
		spellPut("213-185", "zhan");
		spellPut("213-186", "zhan");
		spellPut("213-187", "zhan");
		spellPut("213-188", "zhan");
		spellPut("213-189", "zhan");
		spellPut("213-190", "zhan");
		spellPut("213-191", "zhan");
		spellPut("213-192", "zhan");
		spellPut("213-193", "zhang");
		spellPut("213-194", "zhang");
		spellPut("213-195", "zhang");
		spellPut("213-196", "zhang");
		spellPut("213-197", "zhang");
		spellPut("213-198", "zhang");
		spellPut("213-199", "zhang");
		spellPut("213-200", "zhang");
		spellPut("213-201", "zhang");
		spellPut("213-202", "zhang");
		spellPut("213-203", "zhang");
		spellPut("213-204", "zhang");
		spellPut("213-205", "zhang");
		spellPut("213-206", "zhang");
		spellPut("213-207", "zhang");
		spellPut("213-208", "zhao");
		spellPut("213-209", "zhao");
		spellPut("213-210", "zhao");
		spellPut("213-211", "zhao");
		spellPut("213-212", "zhao");
		spellPut("213-213", "zhao");
		spellPut("213-214", "zhao");
		spellPut("213-215", "zhao");
		spellPut("213-216", "zhao");
		spellPut("213-217", "zhao,shao");
		spellPut("213-218", "zhe");
		spellPut("213-219", "zhe,she");
		spellPut("213-220", "zhe");
		spellPut("213-221", "zhe");
		spellPut("213-222", "zhe");
		spellPut("213-223", "zhe");
		spellPut("213-224", "zhe");
		spellPut("213-225", "zhe");
		spellPut("213-226", "zhe,zhei");
		spellPut("213-227", "zhe");
		spellPut("213-228", "zhen");
		spellPut("213-229", "zhen");
		spellPut("213-230", "zhen");
		spellPut("213-231", "zhen");
		spellPut("213-232", "zhen");
		spellPut("213-233", "zhen");
		spellPut("213-234", "zhen");
		spellPut("213-235", "zhen");
		spellPut("213-236", "zhen");
		spellPut("213-237", "zhen");
		spellPut("213-238", "zhen");
		spellPut("213-239", "zhen");
		spellPut("213-240", "zhen");
		spellPut("213-241", "zhen");
		spellPut("213-242", "zhen");
		spellPut("213-243", "zhen");
		spellPut("213-244", "zheng");
		spellPut("213-245", "zheng");
		spellPut("213-246", "zheng");
		spellPut("213-247", "zheng");
		spellPut("213-248", "zheng");
		spellPut("213-249", "zheng");
		spellPut("213-250", "zheng");
		spellPut("213-251", "zheng");
		spellPut("213-252", "zheng");
		spellPut("213-253", "zheng");
		spellPut("213-254", "zheng");
	}

	private static void init76() {
		spellPut("214-64", "e");
		spellPut("214-65", "zhong");
		spellPut("214-66", "di");
		spellPut("214-67", "xie");
		spellPut("214-68", "fu");
		spellPut("214-69", "pu");
		spellPut("214-70", "ting");
		spellPut("214-71", "jian");
		spellPut("214-72", "qi");
		spellPut("214-73", "yu");
		spellPut("214-74", "zi");
		spellPut("214-75", "zhuan");
		spellPut("214-76", "xi,shai,ai");
		spellPut("214-77", "hui");
		spellPut("214-78", "yin");
		spellPut("214-79", "an");
		spellPut("214-80", "xian");
		spellPut("214-81", "nan");
		spellPut("214-82", "chen");
		spellPut("214-83", "feng");
		spellPut("214-84", "zhu");
		spellPut("214-85", "yang");
		spellPut("214-86", "yan");
		spellPut("214-87", "huang");
		spellPut("214-88", "xuan");
		spellPut("214-89", "ge");
		spellPut("214-90", "nuo");
		spellPut("214-91", "xu");
		spellPut("214-92", "mou");
		spellPut("214-93", "ye");
		spellPut("214-94", "wei");
		spellPut("214-95", "xing");
		spellPut("214-96", "teng");
		spellPut("214-97", "zhou");
		spellPut("214-98", "shan");
		spellPut("214-99", "bo");
		spellPut("214-100", "kui");
		spellPut("214-101", "huang");
		spellPut("214-102", "huo");
		spellPut("214-103", "ge");
		spellPut("214-104", "ying");
		spellPut("214-105", "mi");
		spellPut("214-106", "xiao");
		spellPut("214-107", "mi");
		spellPut("214-108", "xi");
		spellPut("214-109", "qiang");
		spellPut("214-110", "chen");
		spellPut("214-111", "xue");
		spellPut("214-112", "ti");
		spellPut("214-113", "su");
		spellPut("214-114", "bang");
		spellPut("214-115", "chi");
		spellPut("214-116", "qian");
		spellPut("214-117", "shi");
		spellPut("214-118", "jiang");
		spellPut("214-119", "yuan");
		spellPut("214-120", "xie");
		spellPut("214-121", "he");
		spellPut("214-122", "tao");
		spellPut("214-123", "yao");
		spellPut("214-124", "yao");
		spellPut("214-125", "lu");
		spellPut("214-126", "yu");
		spellPut("214-128", "biao");
		spellPut("214-129", "cong");
		spellPut("214-130", "li");
		spellPut("214-131", "mo");
		spellPut("214-132", "mo");
		spellPut("214-133", "shang");
		spellPut("214-134", "zhe");
		spellPut("214-135", "miu");
		spellPut("214-136", "jian");
		spellPut("214-137", "ze");
		spellPut("214-138", "jie");
		spellPut("214-139", "lian");
		spellPut("214-140", "lou");
		spellPut("214-141", "can");
		spellPut("214-142", "ou");
		spellPut("214-143", "gun");
		spellPut("214-144", "xi");
		spellPut("214-145", "zhuo");
		spellPut("214-146", "ao");
		spellPut("214-147", "ao");
		spellPut("214-148", "jin");
		spellPut("214-149", "zhe");
		spellPut("214-150", "yi");
		spellPut("214-151", "hu");
		spellPut("214-152", "jiang");
		spellPut("214-153", "man");
		spellPut("214-154", "chao");
		spellPut("214-155", "han");
		spellPut("214-156", "hua");
		spellPut("214-157", "chan");
		spellPut("214-158", "xu");
		spellPut("214-159", "zeng");
		spellPut("214-160", "se");
		spellPut("214-161", "zhen");
		spellPut("214-162", "zheng");
		spellPut("214-163", "zheng");
		spellPut("214-164", "zheng");
		spellPut("214-165", "zhi");
		spellPut("214-166", "zhi,qi");
		spellPut("214-167", "zhi");
		spellPut("214-168", "zhi,zi");
		spellPut("214-169", "zhi");
		spellPut("214-170", "zhi");
		spellPut("214-171", "zhi");
		spellPut("214-172", "zhi");
		spellPut("214-173", "zhi");
		spellPut("214-174", "zhi");
		spellPut("214-175", "zhi");
		spellPut("214-176", "zhi");
		spellPut("214-177", "zhi");
		spellPut("214-178", "zhi");
		spellPut("214-179", "zhi,shi");
		spellPut("214-180", "zhi");
		spellPut("214-181", "zhi");
		spellPut("214-182", "zhi");
		spellPut("214-183", "zhi");
		spellPut("214-184", "zhi");
		spellPut("214-185", "zhi");
		spellPut("214-186", "zhi");
		spellPut("214-187", "zhi");
		spellPut("214-188", "zhi");
		spellPut("214-189", "zhi");
		spellPut("214-190", "zhi");
		spellPut("214-191", "zhi");
		spellPut("214-192", "zhi");
		spellPut("214-193", "zhi");
		spellPut("214-194", "zhi");
		spellPut("214-195", "zhi");
		spellPut("214-196", "zhi");
		spellPut("214-197", "zhi,shi");
		spellPut("214-198", "zhi");
		spellPut("214-199", "zhi");
		spellPut("214-200", "zhi");
		spellPut("214-201", "zhi");
		spellPut("214-202", "zhi");
		spellPut("214-203", "zhi");
		spellPut("214-204", "zhi");
		spellPut("214-205", "zhi");
		spellPut("214-206", "zhi");
		spellPut("214-207", "zhi");
		spellPut("214-208", "zhong");
		spellPut("214-209", "zhong");
		spellPut("214-210", "zhong");
		spellPut("214-211", "zhong");
		spellPut("214-212", "zhong");
		spellPut("214-213", "zhong");
		spellPut("214-214", "zhong");
		spellPut("214-215", "zhong");
		spellPut("214-216", "zhong,chong");
		spellPut("214-217", "zhong");
		spellPut("214-218", "zhong");
		spellPut("214-219", "zhou");
		spellPut("214-220", "zhou");
		spellPut("214-221", "zhou");
		spellPut("214-222", "zhou");
		spellPut("214-223", "zhou");
		spellPut("214-224", "zhou,yu");
		spellPut("214-225", "zhou");
		spellPut("214-226", "zhou");
		spellPut("214-227", "zhou");
		spellPut("214-228", "zhou");
		spellPut("214-229", "zhou");
		spellPut("214-230", "zhou");
		spellPut("214-231", "zhou");
		spellPut("214-232", "zhou");
		spellPut("214-233", "zhu");
		spellPut("214-234", "zhu");
		spellPut("214-235", "zhu");
		spellPut("214-236", "zhu,shu");
		spellPut("214-237", "zhu");
		spellPut("214-238", "zhu");
		spellPut("214-239", "zhu");
		spellPut("214-240", "zhu");
		spellPut("214-241", "zhu");
		spellPut("214-242", "zhu");
		spellPut("214-243", "zhu");
		spellPut("214-244", "zhu");
		spellPut("214-245", "zhu");
		spellPut("214-246", "zhu");
		spellPut("214-247", "zhu");
		spellPut("214-248", "zhu");
		spellPut("214-249", "zhu");
		spellPut("214-250", "zhu,chu");
		spellPut("214-251", "zhu");
		spellPut("214-252", "zhu");
		spellPut("214-253", "zhu");
		spellPut("214-254", "zhu");
	}

	private static void init77() {
		spellPut("215-64", "xi");
		spellPut("215-65", "zha");
		spellPut("215-66", "dui");
		spellPut("215-67", "zheng");
		spellPut("215-68", "nao");
		spellPut("215-69", "lan");
		spellPut("215-70", "e");
		spellPut("215-71", "ying");
		spellPut("215-72", "jue");
		spellPut("215-73", "ji");
		spellPut("215-74", "zun");
		spellPut("215-75", "jiao");
		spellPut("215-76", "bo");
		spellPut("215-77", "hui");
		spellPut("215-78", "zhuan");
		spellPut("215-79", "wu");
		spellPut("215-80", "zen");
		spellPut("215-81", "zha");
		spellPut("215-82", "shi");
		spellPut("215-83", "qiao");
		spellPut("215-84", "tan");
		spellPut("215-85", "jian");
		spellPut("215-86", "pu");
		spellPut("215-87", "sheng");
		spellPut("215-88", "xuan");
		spellPut("215-89", "zao");
		spellPut("215-90", "tan");
		spellPut("215-91", "dang");
		spellPut("215-92", "sui");
		spellPut("215-93", "xian");
		spellPut("215-94", "ji");
		spellPut("215-95", "jiao");
		spellPut("215-96", "zhan");
		spellPut("215-97", "nong");
		spellPut("215-98", "yi");
		spellPut("215-99", "ai");
		spellPut("215-100", "zhan");
		spellPut("215-101", "hui");
		spellPut("215-102", "hua");
		spellPut("215-103", "yi");
		spellPut("215-104", "yi");
		spellPut("215-105", "shan");
		spellPut("215-106", "rang");
		spellPut("215-107", "rou");
		spellPut("215-108", "qian");
		spellPut("215-109", "dui");
		spellPut("215-110", "ta");
		spellPut("215-111", "hu");
		spellPut("215-112", "zhou");
		spellPut("215-113", "hao");
		spellPut("215-114", "ai");
		spellPut("215-115", "ying");
		spellPut("215-116", "jian");
		spellPut("215-117", "yu");
		spellPut("215-118", "jian");
		spellPut("215-119", "hui");
		spellPut("215-120", "du");
		spellPut("215-121", "zhe");
		spellPut("215-122", "juan,xuan");
		spellPut("215-123", "zan");
		spellPut("215-124", "lei");
		spellPut("215-125", "shen");
		spellPut("215-126", "wei");
		spellPut("215-128", "chan");
		spellPut("215-129", "li");
		spellPut("215-130", "yi,tui");
		spellPut("215-131", "bian");
		spellPut("215-132", "zhe");
		spellPut("215-133", "yan");
		spellPut("215-134", "e");
		spellPut("215-135", "chou");
		spellPut("215-136", "wei");
		spellPut("215-137", "chou");
		spellPut("215-138", "yao");
		spellPut("215-139", "chan");
		spellPut("215-140", "rang");
		spellPut("215-141", "yin");
		spellPut("215-142", "lan");
		spellPut("215-143", "chen");
		spellPut("215-144", "xie");
		spellPut("215-145", "nie");
		spellPut("215-146", "huan");
		spellPut("215-147", "zan");
		spellPut("215-148", "yi");
		spellPut("215-149", "dang");
		spellPut("215-150", "zhan");
		spellPut("215-151", "yan");
		spellPut("215-152", "du");
		spellPut("215-153", "tuo");
		spellPut("215-154", "ren");
		spellPut("215-155", "xiong");
		spellPut("215-156", "xiong");
		spellPut("215-157", "bi");
		spellPut("215-158", "zhou,chou");
		spellPut("215-159", "shen");
		spellPut("215-160", "xu");
		spellPut("215-161", "zhu");
		spellPut("215-162", "zhu");
		spellPut("215-163", "zhu");
		spellPut("215-164", "zhu");
		spellPut("215-165", "zhua");
		spellPut("215-166", "zhao,zhua");
		spellPut("215-167", "zhuai,ye");
		spellPut("215-168", "zhuan");
		spellPut("215-169", "zhuan");
		spellPut("215-170", "zhuan");
		spellPut("215-171", "zhuan");
		spellPut("215-172", "zhuan");
		spellPut("215-173", "zhuan");
		spellPut("215-174", "zhuang");
		spellPut("215-175", "zhuang");
		spellPut("215-176", "zhuang");
		spellPut("215-177", "zhuang");
		spellPut("215-178", "zhuang");
		spellPut("215-179", "zhuang");
		spellPut("215-180", "zhuang");
		spellPut("215-181", "zhui,chui");
		spellPut("215-182", "zhui");
		spellPut("215-183", "zhui,dui");
		spellPut("215-184", "zhui");
		spellPut("215-185", "zhui");
		spellPut("215-186", "zhui");
		spellPut("215-187", "zhun");
		spellPut("215-188", "zhun");
		spellPut("215-189", "zhuo");
		spellPut("215-190", "zhuo");
		spellPut("215-191", "zhuo");
		spellPut("215-192", "zhuo");
		spellPut("215-193", "zhuo,zuo");
		spellPut("215-194", "zhuo");
		spellPut("215-195", "zhuo");
		spellPut("215-196", "zhuo");
		spellPut("215-197", "zhuo,zhao,zhe");
		spellPut("215-198", "zhuo");
		spellPut("215-199", "zhuo");
		spellPut("215-200", "zi,ci");
		spellPut("215-201", "zi");
		spellPut("215-202", "zi");
		spellPut("215-203", "zi");
		spellPut("215-204", "zi");
		spellPut("215-205", "zi");
		spellPut("215-206", "zi");
		spellPut("215-207", "zi");
		spellPut("215-208", "zi,zai");
		spellPut("215-209", "zi");
		spellPut("215-210", "zi");
		spellPut("215-211", "zi");
		spellPut("215-212", "zi");
		spellPut("215-213", "zi");
		spellPut("215-214", "zi");
		spellPut("215-215", "zong");
		spellPut("215-216", "zong");
		spellPut("215-217", "zong");
		spellPut("215-218", "zong");
		spellPut("215-219", "zong,zeng");
		spellPut("215-220", "zong");
		spellPut("215-221", "zong");
		spellPut("215-222", "zou");
		spellPut("215-223", "zou");
		spellPut("215-224", "zou");
		spellPut("215-225", "zou");
		spellPut("215-226", "zu");
		spellPut("215-227", "zu");
		spellPut("215-228", "zu,cu");
		spellPut("215-229", "zu");
		spellPut("215-230", "zu");
		spellPut("215-231", "zu");
		spellPut("215-232", "zu");
		spellPut("215-233", "zu");
		spellPut("215-234", "zuan");
		spellPut("215-235", "zuan");
		spellPut("215-236", "zui");
		spellPut("215-237", "zui");
		spellPut("215-238", "zui");
		spellPut("215-239", "zui");
		spellPut("215-240", "zun");
		spellPut("215-241", "zun");
		spellPut("215-242", "zuo");
		spellPut("215-243", "zuo");
		spellPut("215-244", "zuo");
		spellPut("215-245", "zuo,zha");
		spellPut("215-246", "zuo");
		spellPut("215-247", "zuo");
		spellPut("215-248", "zuo");
		spellPut("215-249", "zuo");
	}

	private static void init78() {
		spellPut("216-64", "qian");
		spellPut("216-65", "hong");
		spellPut("216-66", "xia");
		spellPut("216-67", "ji");
		spellPut("216-68", "hong");
		spellPut("216-69", "han");
		spellPut("216-70", "hong");
		spellPut("216-71", "xi");
		spellPut("216-72", "xi");
		spellPut("216-73", "liao");
		spellPut("216-74", "han");
		spellPut("216-75", "du");
		spellPut("216-76", "long");
		spellPut("216-77", "qi");
		spellPut("216-78", "li");
		spellPut("216-79", "deng");
		spellPut("216-80", "bi");
		spellPut("216-81", "shu");
		spellPut("216-82", "xian");
		spellPut("216-83", "feng");
		spellPut("216-84", "zhi");
		spellPut("216-85", "zhi");
		spellPut("216-86", "yan");
		spellPut("216-87", "yan");
		spellPut("216-88", "chu");
		spellPut("216-89", "hui");
		spellPut("216-90", "tun");
		spellPut("216-91", "yi");
		spellPut("216-92", "yi");
		spellPut("216-93", "jian");
		spellPut("216-94", "ba");
		spellPut("216-95", "hou");
		spellPut("216-96", "e");
		spellPut("216-97", "chu");
		spellPut("216-98", "jiBn");
		spellPut("216-99", "ken");
		spellPut("216-100", "gai");
		spellPut("216-101", "ju");
		spellPut("216-102", "fu");
		spellPut("216-103", "xi");
		spellPut("216-104", "bin");
		spellPut("216-105", "zhu");
		spellPut("216-106", "jia");
		spellPut("216-107", "fen");
		spellPut("216-108", "xi");
		spellPut("216-109", "hu");
		spellPut("216-110", "wen");
		spellPut("216-111", "huan");
		spellPut("216-112", "di");
		spellPut("216-113", "zong");
		spellPut("216-114", "fen");
		spellPut("216-115", "yi");
		spellPut("216-116", "an");
		spellPut("216-117", "pi");
		spellPut("216-118", "na");
		spellPut("216-119", "pi");
		spellPut("216-120", "gou");
		spellPut("216-121", "na");
		spellPut("216-122", "you");
		spellPut("216-123", "mo");
		spellPut("216-124", "si");
		spellPut("216-125", "huan");
		spellPut("216-126", "ken,kun");
		spellPut("216-128", "he,mo");
		spellPut("216-129", "an");
		spellPut("216-130", "li");
		spellPut("216-131", "ni");
		spellPut("216-132", "bi");
		spellPut("216-133", "yu");
		spellPut("216-134", "jia");
		spellPut("216-135", "tuan");
		spellPut("216-136", "mao");
		spellPut("216-137", "xi");
		spellPut("216-138", "yi");
		spellPut("216-139", "ju,lou");
		spellPut("216-140", "chu");
		spellPut("216-141", "tan");
		spellPut("216-142", "huan");
		spellPut("216-143", "jue");
		spellPut("216-144", "bei");
		spellPut("216-145", "zhen");
		spellPut("216-146", "yuan,yun");
		spellPut("216-147", "fu");
		spellPut("216-148", "cai");
		spellPut("216-149", "gong");
		spellPut("216-150", "dai");
		spellPut("216-151", "yi");
		spellPut("216-152", "hang");
		spellPut("216-153", "wan");
		spellPut("216-154", "pin");
		spellPut("216-155", "huo");
		spellPut("216-156", "fan");
		spellPut("216-157", "tan");
		spellPut("216-158", "guan");
		spellPut("216-159", "ze,zhai");
		spellPut("216-160", "zhi");
		spellPut("216-161", "chu");
		spellPut("216-162", "qi,ji");
		spellPut("216-163", "wu");
		spellPut("216-164", "gai");
		spellPut("216-165", "nian");
		spellPut("216-166", "sa");
		spellPut("216-167", "pi");
		spellPut("216-168", "gen");
		spellPut("216-169", "cheng");
		spellPut("216-170", "ge");
		spellPut("216-171", "nao");
		spellPut("216-172", "e");
		spellPut("216-173", "gun");
		spellPut("216-174", "yu,ou");
		spellPut("216-175", "pie");
		spellPut("216-176", "bi");
		spellPut("216-177", "tuo,zhe");
		spellPut("216-178", "yao");
		spellPut("216-179", "yao");
		spellPut("216-180", "zhi");
		spellPut("216-181", "di");
		spellPut("216-182", "xin");
		spellPut("216-183", "yin");
		spellPut("216-184", "kui");
		spellPut("216-185", "yu");
		spellPut("216-186", "gao");
		spellPut("216-187", "tao");
		spellPut("216-188", "zhu");
		spellPut("216-189", "ji,qi");
		spellPut("216-190", "nai");
		spellPut("216-191", "mie,nie");
		spellPut("216-192", "ji");
		spellPut("216-193", "qi");
		spellPut("216-194", "mie");
		spellPut("216-195", "bei");
		spellPut("216-196", "se");
		spellPut("216-197", "gu");
		spellPut("216-198", "ze");
		spellPut("216-199", "she");
		spellPut("216-200", "cuo");
		spellPut("216-201", "yan");
		spellPut("216-202", "jue");
		spellPut("216-203", "si");
		spellPut("216-204", "ye");
		spellPut("216-205", "yan");
		spellPut("216-206", "fang");
		spellPut("216-207", "po");
		spellPut("216-208", "gui");
		spellPut("216-209", "kui,gui");
		spellPut("216-210", "bian");
		spellPut("216-211", "ze");
		spellPut("216-212", "gua");
		spellPut("216-213", "you");
		spellPut("216-214", "dao");
		spellPut("216-215", "yi");
		spellPut("216-216", "wen");
		spellPut("216-217", "jing");
		spellPut("216-218", "ku");
		spellPut("216-219", "gui");
		spellPut("216-220", "kai");
		spellPut("216-221", "la");
		spellPut("216-222", "ji");
		spellPut("216-223", "yan,shan");
		spellPut("216-224", "wan");
		spellPut("216-225", "kuai");
		spellPut("216-226", "piao");
		spellPut("216-227", "jue");
		spellPut("216-228", "qiao");
		spellPut("216-229", "huo");
		spellPut("216-230", "yi");
		spellPut("216-231", "jiong");
		spellPut("216-232", "wang");
		spellPut("216-233", "ren");
		spellPut("216-234", "ding");
		spellPut("216-235", "zhang");
		spellPut("216-236", "le");
		spellPut("216-237", "sa");
		spellPut("216-238", "yi,ge");
		spellPut("216-239", "mu");
		spellPut("216-240", "ren");
		spellPut("216-241", "yu");
		spellPut("216-242", "pi");
		spellPut("216-243", "ya");
		spellPut("216-244", "wa");
		spellPut("216-245", "wu");
		spellPut("216-246", "chang");
		spellPut("216-247", "cang,chen");
		spellPut("216-248", "kang");
		spellPut("216-249", "zhu");
		spellPut("216-250", "ning");
		spellPut("216-251", "ka");
		spellPut("216-252", "you");
		spellPut("216-253", "yi,die");
		spellPut("216-254", "gou,kou");
	}

	private static void init79() {
		spellPut("217-64", "er");
		spellPut("217-65", "zhu");
		spellPut("217-66", "shi");
		spellPut("217-67", "bi");
		spellPut("217-68", "zi");
		spellPut("217-69", "er");
		spellPut("217-70", "gui");
		spellPut("217-71", "pian");
		spellPut("217-72", "bian");
		spellPut("217-73", "mai");
		spellPut("217-74", "dai,te");
		spellPut("217-75", "sheng");
		spellPut("217-76", "kuang");
		spellPut("217-77", "fei");
		spellPut("217-78", "tie");
		spellPut("217-79", "yi");
		spellPut("217-80", "chi");
		spellPut("217-81", "mao");
		spellPut("217-82", "he");
		spellPut("217-83", "bi,ben");
		spellPut("217-84", "lu");
		spellPut("217-85", "lin");
		spellPut("217-86", "hui");
		spellPut("217-87", "gai");
		spellPut("217-88", "pian");
		spellPut("217-89", "zi");
		spellPut("217-90", "jia,gu");
		spellPut("217-91", "xu");
		spellPut("217-92", "zei");
		spellPut("217-93", "jiao");
		spellPut("217-94", "gai");
		spellPut("217-95", "zang");
		spellPut("217-96", "jian");
		spellPut("217-97", "ying");
		spellPut("217-98", "jun");
		spellPut("217-99", "zhen");
		spellPut("217-100", "she");
		spellPut("217-101", "bin");
		spellPut("217-102", "bin");
		spellPut("217-103", "qiu");
		spellPut("217-104", "she");
		spellPut("217-105", "chuan");
		spellPut("217-106", "zang");
		spellPut("217-107", "zhou");
		spellPut("217-108", "lai");
		spellPut("217-109", "zan");
		spellPut("217-110", "ci");
		spellPut("217-111", "chen");
		spellPut("217-112", "shang");
		spellPut("217-113", "tian");
		spellPut("217-114", "pei");
		spellPut("217-115", "geng");
		spellPut("217-116", "xian");
		spellPut("217-117", "mai");
		spellPut("217-118", "jian");
		spellPut("217-119", "sui");
		spellPut("217-120", "fu");
		spellPut("217-121", "dan");
		spellPut("217-122", "cong");
		spellPut("217-123", "cong");
		spellPut("217-124", "zhi");
		spellPut("217-125", "lai");
		spellPut("217-126", "zhang");
		spellPut("217-128", "du");
		spellPut("217-129", "jin");
		spellPut("217-130", "xiong,min");
		spellPut("217-131", "chun");
		spellPut("217-132", "yun");
		spellPut("217-133", "bao");
		spellPut("217-134", "zai");
		spellPut("217-135", "lai");
		spellPut("217-136", "feng");
		spellPut("217-137", "cang");
		spellPut("217-138", "ji");
		spellPut("217-139", "sheng");
		spellPut("217-140", "ai");
		spellPut("217-141", "zhuan,zuan");
		spellPut("217-142", "fu");
		spellPut("217-143", "gou");
		spellPut("217-144", "sai");
		spellPut("217-145", "ze");
		spellPut("217-146", "liao");
		spellPut("217-147", "yi");
		spellPut("217-148", "bai");
		spellPut("217-149", "chen");
		spellPut("217-150", "wan");
		spellPut("217-151", "zhi");
		spellPut("217-152", "zhui");
		spellPut("217-153", "biao");
		spellPut("217-154", "yun");
		spellPut("217-155", "zeng");
		spellPut("217-156", "dan");
		spellPut("217-157", "zan");
		spellPut("217-158", "yan");
		spellPut("217-159", "pu");
		spellPut("217-160", "shan");
		spellPut("217-161", "tong");
		spellPut("217-162", "tuo");
		spellPut("217-163", "ni");
		spellPut("217-164", "qie,jia,ga");
		spellPut("217-165", "ji");
		spellPut("217-166", "er,nai");
		spellPut("217-167", "you");
		spellPut("217-168", "kua");
		spellPut("217-169", "kan");
		spellPut("217-170", "zhu");
		spellPut("217-171", "yi");
		spellPut("217-172", "tiao");
		spellPut("217-173", "chai");
		spellPut("217-174", "jiao");
		spellPut("217-175", "nong");
		spellPut("217-176", "mou");
		spellPut("217-177", "chou");
		spellPut("217-178", "yan");
		spellPut("217-179", "li");
		spellPut("217-180", "qiu");
		spellPut("217-181", "li");
		spellPut("217-182", "yu");
		spellPut("217-183", "ping");
		spellPut("217-184", "yong");
		spellPut("217-185", "si,qi");
		spellPut("217-186", "feng");
		spellPut("217-187", "qian");
		spellPut("217-188", "ruo");
		spellPut("217-189", "pai");
		spellPut("217-190", "zhuo");
		spellPut("217-191", "shu");
		spellPut("217-192", "luo");
		spellPut("217-193", "wo,wei");
		spellPut("217-194", "bi");
		spellPut("217-195", "ti");
		spellPut("217-196", "guan");
		spellPut("217-197", "kong");
		spellPut("217-198", "ju");
		spellPut("217-199", "fen");
		spellPut("217-200", "yan");
		spellPut("217-201", "xie");
		spellPut("217-202", "ji,jie");
		spellPut("217-203", "wei");
		spellPut("217-204", "zong");
		spellPut("217-205", "lv,lou");
		spellPut("217-206", "tang");
		spellPut("217-207", "bin");
		spellPut("217-208", "nuo");
		spellPut("217-209", "chi");
		spellPut("217-210", "xi");
		spellPut("217-211", "jing");
		spellPut("217-212", "jian");
		spellPut("217-213", "jiao");
		spellPut("217-214", "jiu");
		spellPut("217-215", "tong,zhuang");
		spellPut("217-216", "xuan");
		spellPut("217-217", "dan");
		spellPut("217-218", "tong");
		spellPut("217-219", "tun");
		spellPut("217-220", "she");
		spellPut("217-221", "qian");
		spellPut("217-222", "zu");
		spellPut("217-223", "yue");
		spellPut("217-224", "cuan");
		spellPut("217-225", "di");
		spellPut("217-226", "xi");
		spellPut("217-227", "xun");
		spellPut("217-228", "hong");
		spellPut("217-229", "guo");
		spellPut("217-230", "chan");
		spellPut("217-231", "kui");
		spellPut("217-232", "bao");
		spellPut("217-233", "pu");
		spellPut("217-234", "hong");
		spellPut("217-235", "fu");
		spellPut("217-236", "fu");
		spellPut("217-237", "su");
		spellPut("217-238", "si");
		spellPut("217-239", "tou");
		spellPut("217-240", "yan");
		spellPut("217-241", "bo");
		spellPut("217-242", "gun");
		spellPut("217-243", "mao");
		spellPut("217-244", "xie");
		spellPut("217-245", "luan");
		spellPut("217-246", "pou");
		spellPut("217-247", "bing");
		spellPut("217-248", "ying");
		spellPut("217-249", "luo");
		spellPut("217-250", "lei");
		spellPut("217-251", "bing");
		spellPut("217-252", "hu");
		spellPut("217-253", "lie");
		spellPut("217-254", "xian");
	}

	private static void init80() {
		spellPut("218-64", "wan");
		spellPut("218-65", "ying");
		spellPut("218-66", "jin");
		spellPut("218-67", "gan");
		spellPut("218-68", "xian");
		spellPut("218-69", "zang");
		spellPut("218-70", "bi");
		spellPut("218-71", "du");
		spellPut("218-72", "shu");
		spellPut("218-73", "yan");
		spellPut("218-74", "shang");
		spellPut("218-75", "xuan");
		spellPut("218-76", "long");
		spellPut("218-77", "gan");
		spellPut("218-78", "zang");
		spellPut("218-79", "yuan");
		spellPut("218-80", "bi");
		spellPut("218-81", "zhou");
		spellPut("218-82", "feng");
		spellPut("218-83", "yun");
		spellPut("218-84", "xi");
		spellPut("218-85", "tong");
		spellPut("218-86", "xi");
		spellPut("218-87", "cheng");
		spellPut("218-88", "cheng");
		spellPut("218-89", "xia");
		spellPut("218-90", "tang");
		spellPut("218-91", "zou");
		spellPut("218-92", "li");
		spellPut("218-93", "shan");
		spellPut("218-94", "qiong");
		spellPut("218-95", "yin");
		spellPut("218-96", "xian");
		spellPut("218-97", "zi");
		spellPut("218-98", "jue");
		spellPut("218-99", "qin");
		spellPut("218-100", "chi");
		spellPut("218-101", "ci");
		spellPut("218-102", "chen");
		spellPut("218-103", "die,tu");
		spellPut("218-104", "di");
		spellPut("218-105", "xi");
		spellPut("218-106", "zhan");
		spellPut("218-107", "jue");
		spellPut("218-108", "ji,jie");
		spellPut("218-109", "qu");
		spellPut("218-110", "chu");
		spellPut("218-111", "gua,huo");
		spellPut("218-112", "xue");
		spellPut("218-113", "tiao");
		spellPut("218-114", "duo");
		spellPut("218-115", "gan");
		spellPut("218-116", "suo");
		spellPut("218-117", "cu");
		spellPut("218-118", "xi");
		spellPut("218-119", "zhao");
		spellPut("218-120", "su");
		spellPut("218-121", "yin");
		spellPut("218-122", "ju");
		spellPut("218-123", "jian");
		spellPut("218-124", "que,qi,ji");
		spellPut("218-125", "chuo");
		spellPut("218-126", "cui");
		spellPut("218-128", "lu");
		spellPut("218-129", "dang");
		spellPut("218-130", "qiu");
		spellPut("218-131", "zi");
		spellPut("218-132", "ti");
		spellPut("218-133", "qu,cu");
		spellPut("218-134", "chi");
		spellPut("218-135", "huang");
		spellPut("218-136", "qiao");
		spellPut("218-137", "qiao");
		spellPut("218-138", "jiao");
		spellPut("218-139", "zao");
		spellPut("218-140", "ti,yue");
		spellPut("218-141", "er");
		spellPut("218-142", "zan");
		spellPut("218-143", "kua,wu");
		spellPut("218-144", "ke");
		spellPut("218-145", "jue,gui");
		spellPut("218-146", "chen");
		spellPut("218-147", "fang,pang");
		spellPut("218-148", "yue");
		spellPut("218-149", "ba,pao");
		spellPut("218-150", "qi");
		spellPut("218-151", "tuo");
		spellPut("218-152", "yi");
		spellPut("218-153", "jian,chen");
		spellPut("218-154", "ling");
		spellPut("218-155", "mei");
		spellPut("218-156", "ku");
		spellPut("218-157", "ci");
		spellPut("218-158", "qia");
		spellPut("218-159", "zhu");
		spellPut("218-160", "ju");
		spellPut("218-161", "song");
		spellPut("218-162", "mi");
		spellPut("218-163", "zhong");
		spellPut("218-164", "ming");
		spellPut("218-165", "yan");
		spellPut("218-166", "jie");
		spellPut("218-167", "hong");
		spellPut("218-168", "shan");
		spellPut("218-169", "ou");
		spellPut("218-170", "ju");
		spellPut("218-171", "ne");
		spellPut("218-172", "gu");
		spellPut("218-173", "he");
		spellPut("218-174", "di");
		spellPut("218-175", "zhao");
		spellPut("218-176", "qu");
		spellPut("218-177", "yi,dai");
		spellPut("218-178", "kuang");
		spellPut("218-179", "lei");
		spellPut("218-180", "gua");
		spellPut("218-181", "jie,ji");
		spellPut("218-182", "hui");
		spellPut("218-183", "shen");
		spellPut("218-184", "gou");
		spellPut("218-185", "quan");
		spellPut("218-186", "zheng");
		spellPut("218-187", "hun");
		spellPut("218-188", "xu");
		spellPut("218-189", "qiao");
		spellPut("218-190", "gao");
		spellPut("218-191", "kuang");
		spellPut("218-192", "ei,xi");
		spellPut("218-193", "zou");
		spellPut("218-194", "zhuo");
		spellPut("218-195", "wei");
		spellPut("218-196", "yu");
		spellPut("218-197", "shen");
		spellPut("218-198", "chan");
		spellPut("218-199", "sui");
		spellPut("218-200", "chen");
		spellPut("218-201", "jian");
		spellPut("218-202", "xue");
		spellPut("218-203", "ye");
		spellPut("218-204", "e");
		spellPut("218-205", "yu");
		spellPut("218-206", "xuan");
		spellPut("218-207", "an");
		spellPut("218-208", "di");
		spellPut("218-209", "zi");
		spellPut("218-210", "pian");
		spellPut("218-211", "mo");
		spellPut("218-212", "dang");
		spellPut("218-213", "su");
		spellPut("218-214", "shi");
		spellPut("218-215", "mi");
		spellPut("218-216", "zhe");
		spellPut("218-217", "jian");
		spellPut("218-218", "zen");
		spellPut("218-219", "qiao");
		spellPut("218-220", "jue");
		spellPut("218-221", "yan");
		spellPut("218-222", "zhan");
		spellPut("218-223", "chen");
		spellPut("218-224", "jie");
		spellPut("218-225", "jin");
		spellPut("218-226", "fu");
		spellPut("218-227", "wu");
		spellPut("218-228", "qian");
		spellPut("218-229", "jing");
		spellPut("218-230", "ban");
		spellPut("218-231", "dian");
		spellPut("218-232", "zuo");
		spellPut("218-233", "bei");
		spellPut("218-234", "xing");
		spellPut("218-235", "gai");
		spellPut("218-236", "zhi");
		spellPut("218-237", "nie");
		spellPut("218-238", "zou");
		spellPut("218-239", "chui");
		spellPut("218-240", "pi");
		spellPut("218-241", "wei");
		spellPut("218-242", "huang");
		spellPut("218-243", "wei,kui");
		spellPut("218-244", "xi");
		spellPut("218-245", "han");
		spellPut("218-246", "qiong");
		spellPut("218-247", "kuang");
		spellPut("218-248", "mang");
		spellPut("218-249", "wu");
		spellPut("218-250", "fang");
		spellPut("218-251", "bing");
		spellPut("218-252", "pi");
		spellPut("218-253", "bei");
		spellPut("218-254", "ye");
	}

	private static void init81() {
		spellPut("219-64", "dian,tie,die");
		spellPut("219-65", "pan,ban");
		spellPut("219-66", "ju,qie");
		spellPut("219-67", "ni");
		spellPut("219-68", "yi");
		spellPut("219-69", "ji");
		spellPut("219-70", "dai,duo,chi");
		spellPut("219-71", "duo");
		spellPut("219-72", "zhu");
		spellPut("219-73", "quan");
		spellPut("219-74", "zhuai");
		spellPut("219-75", "xiang");
		spellPut("219-76", "die");
		spellPut("219-77", "pian,beng");
		spellPut("219-78", "zhi");
		spellPut("219-79", "jie");
		spellPut("219-80", "cai");
		spellPut("219-81", "da");
		spellPut("219-82", "ju");
		spellPut("219-83", "shu,chou");
		spellPut("219-84", "tu");
		spellPut("219-85", "chuo");
		spellPut("219-86", "jing");
		spellPut("219-87", "nie");
		spellPut("219-88", "xiao");
		spellPut("219-89", "bu");
		spellPut("219-90", "qun");
		spellPut("219-91", "mu");
		spellPut("219-92", "shu");
		spellPut("219-93", "jiao");
		spellPut("219-94", "qiao");
		spellPut("219-95", "mou");
		spellPut("219-96", "jian");
		spellPut("219-97", "ji");
		spellPut("219-98", "wo");
		spellPut("219-99", "wei");
		spellPut("219-100", "jie");
		spellPut("219-101", "ji");
		spellPut("219-102", "nie");
		spellPut("219-103", "ju");
		spellPut("219-104", "nie");
		spellPut("219-105", "lun");
		spellPut("219-106", "lu");
		spellPut("219-107", "leng");
		spellPut("219-108", "wan");
		spellPut("219-109", "quan");
		spellPut("219-110", "zu");
		spellPut("219-111", "qie");
		spellPut("219-112", "qi");
		spellPut("219-113", "cu");
		spellPut("219-114", "zong");
		spellPut("219-115", "peng");
		spellPut("219-116", "zheng");
		spellPut("219-117", "yu");
		spellPut("219-118", "dun");
		spellPut("219-119", "chuan");
		spellPut("219-120", "yong");
		spellPut("219-121", "di");
		spellPut("219-122", "zhe");
		spellPut("219-123", "chen");
		spellPut("219-124", "gua");
		spellPut("219-125", "tang");
		spellPut("219-126", "fu");
		spellPut("219-128", "cu");
		spellPut("219-129", "nuo");
		spellPut("219-130", "cha");
		spellPut("219-131", "tui");
		spellPut("219-132", "qiang");
		spellPut("219-133", "nian");
		spellPut("219-134", "dian");
		spellPut("219-135", "ti");
		spellPut("219-136", "ji");
		spellPut("219-137", "liu");
		spellPut("219-138", "zan");
		spellPut("219-139", "bi");
		spellPut("219-140", "chong");
		spellPut("219-141", "lu");
		spellPut("219-142", "liao");
		spellPut("219-143", "tang");
		spellPut("219-144", "dai");
		spellPut("219-145", "su");
		spellPut("219-146", "xi");
		spellPut("219-147", "kui");
		spellPut("219-148", "ji");
		spellPut("219-149", "zhi");
		spellPut("219-150", "qiang");
		spellPut("219-151", "di");
		spellPut("219-152", "pan");
		spellPut("219-153", "zong");
		spellPut("219-154", "lian");
		spellPut("219-155", "zao");
		spellPut("219-156", "nian");
		spellPut("219-157", "tui");
		spellPut("219-158", "ju");
		spellPut("219-159", "xian");
		spellPut("219-160", "zhong");
		spellPut("219-161", "di");
		spellPut("219-162", "tai");
		spellPut("219-163", "jia");
		spellPut("219-164", "zhi");
		spellPut("219-165", "zhu");
		spellPut("219-166", "kuai");
		spellPut("219-167", "qie,xi");
		spellPut("219-168", "xun,huan");
		spellPut("219-169", "yun");
		spellPut("219-170", "li,zhi");
		spellPut("219-171", "ying");
		spellPut("219-172", "gao");
		spellPut("219-173", "xi");
		spellPut("219-174", "fu");
		spellPut("219-175", "pi");
		spellPut("219-176", "tan");
		spellPut("219-177", "yan");
		spellPut("219-178", "juan");
		spellPut("219-179", "yan");
		spellPut("219-180", "yin");
		spellPut("219-181", "zhang");
		spellPut("219-182", "po");
		spellPut("219-183", "shan");
		spellPut("219-184", "zou");
		spellPut("219-185", "ling");
		spellPut("219-186", "feng");
		spellPut("219-187", "chu");
		spellPut("219-188", "huan");
		spellPut("219-189", "mai");
		spellPut("219-190", "qu");
		spellPut("219-191", "shao");
		spellPut("219-192", "he");
		spellPut("219-193", "ge,jia");
		spellPut("219-194", "meng");
		spellPut("219-195", "xu");
		spellPut("219-196", "xie");
		spellPut("219-197", "sou");
		spellPut("219-198", "xie");
		spellPut("219-199", "jue");
		spellPut("219-200", "yin");
		spellPut("219-201", "kan,qian");
		spellPut("219-202", "dang");
		spellPut("219-203", "chang");
		spellPut("219-204", "si,mou");
		spellPut("219-205", "bian");
		spellPut("219-206", "ben");
		spellPut("219-207", "qiu");
		spellPut("219-208", "ben");
		spellPut("219-209", "e");
		spellPut("219-210", "fa");
		spellPut("219-211", "shu");
		spellPut("219-212", "ji");
		spellPut("219-213", "yong");
		spellPut("219-214", "he");
		spellPut("219-215", "wei,xu");
		spellPut("219-216", "wu");
		spellPut("219-217", "ge");
		spellPut("219-218", "zhen");
		spellPut("219-219", "kuang");
		spellPut("219-220", "pi");
		spellPut("219-221", "yi");
		spellPut("219-222", "li");
		spellPut("219-223", "qi,yin");
		spellPut("219-224", "ban");
		spellPut("219-225", "gan");
		spellPut("219-226", "long");
		spellPut("219-227", "dian");
		spellPut("219-228", "lu");
		spellPut("219-229", "che");
		spellPut("219-230", "di,chi");
		spellPut("219-231", "tuo");
		spellPut("219-232", "ni");
		spellPut("219-233", "mu");
		spellPut("219-234", "ao");
		spellPut("219-235", "ya");
		spellPut("219-236", "die");
		spellPut("219-237", "dong,tong");
		spellPut("219-238", "kai");
		spellPut("219-239", "yan,shan");
		spellPut("219-240", "shang");
		spellPut("219-241", "nao");
		spellPut("219-242", "gai");
		spellPut("219-243", "yin");
		spellPut("219-244", "cheng");
		spellPut("219-245", "shi");
		spellPut("219-246", "guo");
		spellPut("219-247", "xun");
		spellPut("219-248", "lie");
		spellPut("219-249", "yuan,huan");
		spellPut("219-250", "zhi");
		spellPut("219-251", "an");
		spellPut("219-252", "yi");
		spellPut("219-253", "pi");
		spellPut("219-254", "nian");
	}

	private static void init82() {
		spellPut("220-64", "bo");
		spellPut("220-65", "cu");
		spellPut("220-66", "jue");
		spellPut("220-67", "lin");
		spellPut("220-68", "ta");
		spellPut("220-69", "qiao");
		spellPut("220-70", "qiao");
		spellPut("220-71", "liao");
		spellPut("220-72", "dun");
		spellPut("220-73", "guan");
		spellPut("220-74", "dB");
		spellPut("220-75", "bi");
		spellPut("220-76", "bi");
		spellPut("220-77", "ju");
		spellPut("220-78", "qiao");
		spellPut("220-79", "dun");
		spellPut("220-80", "chou");
		spellPut("220-81", "ji");
		spellPut("220-82", "wu");
		spellPut("220-83", "yue");
		spellPut("220-84", "nian");
		spellPut("220-85", "zhi");
		spellPut("220-86", "li,luo");
		spellPut("220-87", "zhi");
		spellPut("220-88", "chu");
		spellPut("220-89", "duan");
		spellPut("220-90", "wei");
		spellPut("220-91", "long");
		spellPut("220-92", "lin");
		spellPut("220-93", "xian");
		spellPut("220-94", "wei");
		spellPut("220-95", "lan");
		spellPut("220-96", "rang");
		spellPut("220-97", "sa,xie");
		spellPut("220-98", "nie");
		spellPut("220-99", "ta");
		spellPut("220-100", "qu");
		spellPut("220-101", "ji");
		spellPut("220-102", "cuan");
		spellPut("220-103", "zuan");
		spellPut("220-104", "xi");
		spellPut("220-105", "kui");
		spellPut("220-106", "jue");
		spellPut("220-107", "lin");
		spellPut("220-108", "dan");
		spellPut("220-109", "sai ga lai re");
		spellPut("220-110", "ti");
		spellPut("220-111", "duo");
		spellPut("220-112", "gong");
		spellPut("220-113", "lang");
		spellPut("220-114", "hai la wu");
		spellPut("220-115", "luo");
		spellPut("220-116", "ai");
		spellPut("220-117", "ji");
		spellPut("220-118", "ju");
		spellPut("220-119", "wu te su ke");
		spellPut("220-120", "lao");
		spellPut("220-121", "yan");
		spellPut("220-122", "xi tui kBi");
		spellPut("220-123", "kang");
		spellPut("220-124", "qu");
		spellPut("220-125", "lou");
		spellPut("220-126", "lao");
		spellPut("220-128", "duo");
		spellPut("220-129", "zhi");
		spellPut("220-130", "yBn");
		spellPut("220-131", "ti");
		spellPut("220-132", "dao");
		spellPut("220-133", "ya ga tei");
		spellPut("220-134", "yu");
		spellPut("220-135", "che,ju");
		spellPut("220-136", "ya,zha,ga");
		spellPut("220-137", "gui");
		spellPut("220-138", "jun");
		spellPut("220-139", "yue");
		spellPut("220-140", "xin,xian");
		spellPut("220-141", "dai");
		spellPut("220-142", "xuan");
		spellPut("220-143", "fan,gui");
		spellPut("220-144", "ren");
		spellPut("220-145", "shan");
		spellPut("220-146", "kuang");
		spellPut("220-147", "shu");
		spellPut("220-148", "tun");
		spellPut("220-149", "chen");
		spellPut("220-150", "dai");
		spellPut("220-151", "e");
		spellPut("220-152", "na");
		spellPut("220-153", "qi");
		spellPut("220-154", "mao");
		spellPut("220-155", "ruan");
		spellPut("220-156", "kuang");
		spellPut("220-157", "qian");
		spellPut("220-158", "zhuan");
		spellPut("220-159", "hong");
		spellPut("220-160", "hu");
		spellPut("220-161", "peng,beng");
		spellPut("220-162", "tu");
		spellPut("220-163", "sao");
		spellPut("220-164", "dai");
		spellPut("220-165", "ku");
		spellPut("220-166", "die");
		spellPut("220-167", "yin");
		spellPut("220-168", "leng");
		spellPut("220-169", "hou");
		spellPut("220-170", "ge");
		spellPut("220-171", "yuan");
		spellPut("220-172", "man");
		spellPut("220-173", "yong");
		spellPut("220-174", "liang");
		spellPut("220-175", "chi");
		spellPut("220-176", "xin");
		spellPut("220-177", "pi");
		spellPut("220-178", "yi");
		spellPut("220-179", "ao");
		spellPut("220-180", "qiu");
		spellPut("220-181", "nai");
		spellPut("220-182", "du");
		spellPut("220-183", "qian");
		spellPut("220-184", "ji");
		spellPut("220-185", "wan");
		spellPut("220-186", "xiong");
		spellPut("220-187", "qi");
		spellPut("220-188", "xiang");
		spellPut("220-189", "fu");
		spellPut("220-190", "yuan,yan");
		spellPut("220-191", "yun");
		spellPut("220-192", "fei,fu");
		spellPut("220-193", "ji");
		spellPut("220-194", "li");
		spellPut("220-195", "e");
		spellPut("220-196", "ju,qu");
		spellPut("220-197", "bi,pi");
		spellPut("220-198", "zhi");
		spellPut("220-199", "rui");
		spellPut("220-200", "xian");
		spellPut("220-201", "chang");
		spellPut("220-202", "cong");
		spellPut("220-203", "qin");
		spellPut("220-204", "wu,hu");
		spellPut("220-205", "qian");
		spellPut("220-206", "qi");
		spellPut("220-207", "shan");
		spellPut("220-208", "bian");
		spellPut("220-209", "zhu");
		spellPut("220-210", "kou");
		spellPut("220-211", "yi");
		spellPut("220-212", "mo");
		spellPut("220-213", "gan");
		spellPut("220-214", "pie");
		spellPut("220-215", "long");
		spellPut("220-216", "ba");
		spellPut("220-217", "mu");
		spellPut("220-218", "ju,cha");
		spellPut("220-219", "ran");
		spellPut("220-220", "qing");
		spellPut("220-221", "chi");
		spellPut("220-222", "fu");
		spellPut("220-223", "ling");
		spellPut("220-224", "niao");
		spellPut("220-225", "yin");
		spellPut("220-226", "mao");
		spellPut("220-227", "ying");
		spellPut("220-228", "qiong");
		spellPut("220-229", "min");
		spellPut("220-230", "tiao,shao");
		spellPut("220-231", "qian");
		spellPut("220-232", "yi");
		spellPut("220-233", "rao");
		spellPut("220-234", "bi");
		spellPut("220-235", "zi");
		spellPut("220-236", "ju");
		spellPut("220-237", "tong");
		spellPut("220-238", "hui");
		spellPut("220-239", "zhu");
		spellPut("220-240", "ting");
		spellPut("220-241", "qiao");
		spellPut("220-242", "fu");
		spellPut("220-243", "ren");
		spellPut("220-244", "xing");
		spellPut("220-245", "quan");
		spellPut("220-246", "hui");
		spellPut("220-247", "xun");
		spellPut("220-248", "ming");
		spellPut("220-249", "ji");
		spellPut("220-250", "jiao");
		spellPut("220-251", "chong");
		spellPut("220-252", "jiang");
		spellPut("220-253", "luo");
		spellPut("220-254", "xing");
	}

	private static void init83() {
		spellPut("221-64", "qu");
		spellPut("221-65", "kuang");
		spellPut("221-66", "di");
		spellPut("221-67", "ling");
		spellPut("221-68", "dai");
		spellPut("221-69", "ao");
		spellPut("221-70", "zhen");
		spellPut("221-71", "fan");
		spellPut("221-72", "kuang");
		spellPut("221-73", "yang");
		spellPut("221-74", "peng");
		spellPut("221-75", "bei");
		spellPut("221-76", "gu");
		spellPut("221-77", "gu");
		spellPut("221-78", "pao");
		spellPut("221-79", "zhu");
		spellPut("221-80", "rong");
		spellPut("221-81", "e");
		spellPut("221-82", "ba");
		spellPut("221-83", "zhou");
		spellPut("221-84", "zhi");
		spellPut("221-85", "yao");
		spellPut("221-86", "ke");
		spellPut("221-87", "yi,die");
		spellPut("221-88", "qing");
		spellPut("221-89", "shi");
		spellPut("221-90", "ping");
		spellPut("221-91", "er");
		spellPut("221-92", "gong");
		spellPut("221-93", "ju");
		spellPut("221-94", "jiao");
		spellPut("221-95", "guang");
		spellPut("221-96", "lu");
		spellPut("221-97", "kai");
		spellPut("221-98", "quan");
		spellPut("221-99", "zhou");
		spellPut("221-100", "zai");
		spellPut("221-101", "zhi");
		spellPut("221-102", "she");
		spellPut("221-103", "liang");
		spellPut("221-104", "yu");
		spellPut("221-105", "shao");
		spellPut("221-106", "you");
		spellPut("221-107", "wan");
		spellPut("221-108", "yin");
		spellPut("221-109", "zhe");
		spellPut("221-110", "wan");
		spellPut("221-111", "fu");
		spellPut("221-112", "qing");
		spellPut("221-113", "zhou");
		spellPut("221-114", "ni");
		spellPut("221-115", "ling");
		spellPut("221-116", "zhe");
		spellPut("221-117", "han");
		spellPut("221-118", "liang");
		spellPut("221-119", "zi");
		spellPut("221-120", "hui");
		spellPut("221-121", "wang");
		spellPut("221-122", "chuo");
		spellPut("221-123", "guo");
		spellPut("221-124", "kan");
		spellPut("221-125", "yi");
		spellPut("221-126", "peng");
		spellPut("221-128", "qian");
		spellPut("221-129", "gun");
		spellPut("221-130", "nian");
		spellPut("221-131", "peng");
		spellPut("221-132", "guan");
		spellPut("221-133", "bei");
		spellPut("221-134", "lun");
		spellPut("221-135", "pai");
		spellPut("221-136", "liang");
		spellPut("221-137", "ruan");
		spellPut("221-138", "rou");
		spellPut("221-139", "ji");
		spellPut("221-140", "yang");
		spellPut("221-141", "xian");
		spellPut("221-142", "chuan");
		spellPut("221-143", "cou");
		spellPut("221-144", "chun");
		spellPut("221-145", "ge");
		spellPut("221-146", "you");
		spellPut("221-147", "hong");
		spellPut("221-148", "shu");
		spellPut("221-149", "fu");
		spellPut("221-150", "zi");
		spellPut("221-151", "fu");
		spellPut("221-152", "wen");
		spellPut("221-153", "fan");
		spellPut("221-154", "zhan");
		spellPut("221-155", "yu");
		spellPut("221-156", "wen");
		spellPut("221-157", "tao");
		spellPut("221-158", "gu");
		spellPut("221-159", "zhen");
		spellPut("221-160", "xia");
		spellPut("221-161", "qian");
		spellPut("221-162", "gen");
		spellPut("221-163", "jin");
		spellPut("221-164", "mai");
		spellPut("221-165", "sun");
		spellPut("221-166", "hong");
		spellPut("221-167", "zhou");
		spellPut("221-168", "kan");
		spellPut("221-169", "bi");
		spellPut("221-170", "shi");
		spellPut("221-171", "wo");
		spellPut("221-172", "you");
		spellPut("221-173", "e");
		spellPut("221-174", "mei");
		spellPut("221-175", "you");
		spellPut("221-176", "li");
		spellPut("221-177", "tu");
		spellPut("221-178", "xian,lian");
		spellPut("221-179", "fu,piao");
		spellPut("221-180", "sui");
		spellPut("221-181", "you");
		spellPut("221-182", "di");
		spellPut("221-183", "shen,xin");
		spellPut("221-184", "guan,wan");
		spellPut("221-185", "lang,liang");
		spellPut("221-186", "ying");
		spellPut("221-187", "chun");
		spellPut("221-188", "jing");
		spellPut("221-189", "qi");
		spellPut("221-190", "xi");
		spellPut("221-191", "song");
		spellPut("221-192", "jin");
		spellPut("221-193", "nai");
		spellPut("221-194", "qi");
		spellPut("221-195", "ba");
		spellPut("221-196", "shu");
		spellPut("221-197", "chang");
		spellPut("221-198", "tie");
		spellPut("221-199", "yu");
		spellPut("221-200", "huan");
		spellPut("221-201", "bi");
		spellPut("221-202", "fu");
		spellPut("221-203", "tu");
		spellPut("221-204", "dan");
		spellPut("221-205", "cui");
		spellPut("221-206", "yan");
		spellPut("221-207", "zu");
		spellPut("221-208", "dang");
		spellPut("221-209", "jian");
		spellPut("221-210", "wan,yun");
		spellPut("221-211", "ying");
		spellPut("221-212", "gu");
		spellPut("221-213", "han");
		spellPut("221-214", "qia");
		spellPut("221-215", "feng");
		spellPut("221-216", "shen");
		spellPut("221-217", "xiang");
		spellPut("221-218", "wei");
		spellPut("221-219", "chan");
		spellPut("221-220", "kai");
		spellPut("221-221", "qi");
		spellPut("221-222", "kui,kuai");
		spellPut("221-223", "xi");
		spellPut("221-224", "e");
		spellPut("221-225", "bao");
		spellPut("221-226", "pa");
		spellPut("221-227", "ting");
		spellPut("221-228", "lou");
		spellPut("221-229", "pai");
		spellPut("221-230", "xuan");
		spellPut("221-231", "jia");
		spellPut("221-232", "zhen");
		spellPut("221-233", "shi");
		spellPut("221-234", "ru");
		spellPut("221-235", "mo");
		spellPut("221-236", "en");
		spellPut("221-237", "bei");
		spellPut("221-238", "weng");
		spellPut("221-239", "hao");
		spellPut("221-240", "ji");
		spellPut("221-241", "li");
		spellPut("221-242", "bang");
		spellPut("221-243", "jian");
		spellPut("221-244", "shuo");
		spellPut("221-245", "lang");
		spellPut("221-246", "ying");
		spellPut("221-247", "yu");
		spellPut("221-248", "su");
		spellPut("221-249", "meng");
		spellPut("221-250", "dou");
		spellPut("221-251", "xi");
		spellPut("221-252", "lian");
		spellPut("221-253", "cu");
		spellPut("221-254", "lin");
	}

	private static void init84() {
		spellPut("222-64", "yuan");
		spellPut("222-65", "lu");
		spellPut("222-66", "jiao");
		spellPut("222-67", "chao");
		spellPut("222-68", "zhuan");
		spellPut("222-69", "wei");
		spellPut("222-70", "hun");
		spellPut("222-71", "xue");
		spellPut("222-72", "zhe");
		spellPut("222-73", "jiao");
		spellPut("222-74", "zhan");
		spellPut("222-75", "bu");
		spellPut("222-76", "lao");
		spellPut("222-77", "fen");
		spellPut("222-78", "fan");
		spellPut("222-79", "lin");
		spellPut("222-80", "ge");
		spellPut("222-81", "se");
		spellPut("222-82", "kan");
		spellPut("222-83", "huan");
		spellPut("222-84", "yi");
		spellPut("222-85", "ji");
		spellPut("222-86", "dui");
		spellPut("222-87", "er");
		spellPut("222-88", "yu");
		spellPut("222-89", "jian");
		spellPut("222-90", "hong");
		spellPut("222-91", "lei");
		spellPut("222-92", "pei");
		spellPut("222-93", "li");
		spellPut("222-94", "li");
		spellPut("222-95", "lu");
		spellPut("222-96", "lin");
		spellPut("222-97", "dai");
		spellPut("222-98", "zhou");
		spellPut("222-99", "liang");
		spellPut("222-100", "wen");
		spellPut("222-101", "ci");
		spellPut("222-102", "zui");
		spellPut("222-103", "bian");
		spellPut("222-104", "la");
		spellPut("222-105", "ci");
		spellPut("222-106", "xue");
		spellPut("222-107", "ban");
		spellPut("222-108", "bian");
		spellPut("222-109", "xue");
		spellPut("222-110", "ban");
		spellPut("222-111", "ci");
		spellPut("222-112", "bian");
		spellPut("222-113", "bian");
		spellPut("222-114", "nong");
		spellPut("222-115", "nong");
		spellPut("222-116", "zhen");
		spellPut("222-117", "chuo");
		spellPut("222-118", "yi");
		spellPut("222-119", "reng");
		spellPut("222-120", "dao,bian");
		spellPut("222-121", "shi");
		spellPut("222-122", "yu");
		spellPut("222-123", "chan");
		spellPut("222-124", "gan");
		spellPut("222-125", "yu");
		spellPut("222-126", "yi");
		spellPut("222-128", "qi");
		spellPut("222-129", "bi");
		spellPut("222-130", "wang,kuang");
		spellPut("222-131", "tu");
		spellPut("222-132", "zhun");
		spellPut("222-133", "da");
		spellPut("222-134", "hang");
		spellPut("222-135", "da");
		spellPut("222-136", "e");
		spellPut("222-137", "da");
		spellPut("222-138", "che");
		spellPut("222-139", "chi");
		spellPut("222-140", "zhi,li");
		spellPut("222-141", "chen");
		spellPut("222-142", "zhu,wang");
		spellPut("222-143", "tao");
		spellPut("222-144", "yi");
		spellPut("222-145", "ke o pi");
		spellPut("222-146", "hui");
		spellPut("222-147", "dong");
		spellPut("222-148", "you");
		spellPut("222-149", "nai");
		spellPut("222-150", "yi");
		spellPut("222-151", "jie");
		spellPut("222-152", "lie");
		spellPut("222-153", "xun");
		spellPut("222-154", "dun");
		spellPut("222-155", "jiong");
		spellPut("222-156", "you");
		spellPut("222-157", "qiu");
		spellPut("222-158", "di");
		spellPut("222-159", "jing");
		spellPut("222-160", "yi");
		spellPut("222-161", "qu");
		spellPut("222-162", "kou");
		spellPut("222-163", "xu");
		spellPut("222-164", "liao,lu");
		spellPut("222-165", "hui");
		spellPut("222-166", "xun");
		spellPut("222-167", "jue");
		spellPut("222-168", "rui");
		spellPut("222-169", "zui");
		spellPut("222-170", "ji");
		spellPut("222-171", "meng");
		spellPut("222-172", "fan");
		spellPut("222-173", "qi");
		spellPut("222-174", "hong");
		spellPut("222-175", "xie");
		spellPut("222-176", "hong");
		spellPut("222-177", "wei");
		spellPut("222-178", "yi");
		spellPut("222-179", "weng");
		spellPut("222-180", "sou");
		spellPut("222-181", "bi");
		spellPut("222-182", "hao");
		spellPut("222-183", "tai");
		spellPut("222-184", "ru");
		spellPut("222-185", "xun");
		spellPut("222-186", "xian");
		spellPut("222-187", "gao");
		spellPut("222-188", "li");
		spellPut("222-189", "huo");
		spellPut("222-190", "qu");
		spellPut("222-191", "heng");
		spellPut("222-192", "fan");
		spellPut("222-193", "nie");
		spellPut("222-194", "mi");
		spellPut("222-195", "gong");
		spellPut("222-196", "yi");
		spellPut("222-197", "kuang");
		spellPut("222-198", "lian");
		spellPut("222-199", "da");
		spellPut("222-200", "yi");
		spellPut("222-201", "xi");
		spellPut("222-202", "zang,zhuang");
		spellPut("222-203", "pao");
		spellPut("222-204", "you");
		spellPut("222-205", "liao");
		spellPut("222-206", "ga");
		spellPut("222-207", "gan");
		spellPut("222-208", "shou");
		spellPut("222-209", "men");
		spellPut("222-210", "tuan");
		spellPut("222-211", "chen");
		spellPut("222-212", "fu");
		spellPut("222-213", "pan,pin,fan");
		spellPut("222-214", "ao,niu");
		spellPut("222-215", "jie,jia");
		spellPut("222-216", "jiao");
		spellPut("222-217", "za,zan");
		spellPut("222-218", "yi");
		spellPut("222-219", "luo,lv");
		spellPut("222-220", "jun");
		spellPut("222-221", "tian");
		spellPut("222-222", "ye");
		spellPut("222-223", "ai");
		spellPut("222-224", "na");
		spellPut("222-225", "ji");
		spellPut("222-226", "guai");
		spellPut("222-227", "bai");
		spellPut("222-228", "ju");
		spellPut("222-229", "pou");
		spellPut("222-230", "lie");
		spellPut("222-231", "qian");
		spellPut("222-232", "guan");
		spellPut("222-233", "she,die,ye");
		spellPut("222-234", "zha");
		spellPut("222-235", "ya");
		spellPut("222-236", "qin");
		spellPut("222-237", "yu");
		spellPut("222-238", "an");
		spellPut("222-239", "xuan");
		spellPut("222-240", "bing");
		spellPut("222-241", "kui");
		spellPut("222-242", "yuan");
		spellPut("222-243", "shu");
		spellPut("222-244", "en");
		spellPut("222-245", "chuai");
		spellPut("222-246", "jian");
		spellPut("222-247", "shuo");
		spellPut("222-248", "zhan");
		spellPut("222-249", "nuo");
		spellPut("222-250", "sang");
		spellPut("222-251", "luo");
		spellPut("222-252", "ying");
		spellPut("222-253", "zhi");
		spellPut("222-254", "han");
	}

	private static void init85() {
		spellPut("223-64", "zhe");
		spellPut("223-65", "wu");
		spellPut("223-66", "lian");
		spellPut("223-67", "suo");
		spellPut("223-68", "hui");
		spellPut("223-69", "gu");
		spellPut("223-70", "lai");
		spellPut("223-71", "ben");
		spellPut("223-72", "cuo");
		spellPut("223-73", "zhu");
		spellPut("223-74", "beng");
		spellPut("223-75", "you");
		spellPut("223-76", "zhou");
		spellPut("223-77", "jin");
		spellPut("223-78", "yu");
		spellPut("223-79", "chuo");
		spellPut("223-80", "ti");
		spellPut("223-81", "da");
		spellPut("223-82", "yuan");
		spellPut("223-83", "nuo");
		spellPut("223-84", "dang");
		spellPut("223-85", "sui");
		spellPut("223-86", "yan");
		spellPut("223-87", "chi");
		spellPut("223-88", "di");
		spellPut("223-89", "shi");
		spellPut("223-90", "zhen");
		spellPut("223-91", "you");
		spellPut("223-92", "yun");
		spellPut("223-93", "e");
		spellPut("223-94", "guo");
		spellPut("223-95", "da");
		spellPut("223-96", "wei");
		spellPut("223-97", "nBn");
		spellPut("223-98", "yao");
		spellPut("223-99", "chou");
		spellPut("223-100", "xun");
		spellPut("223-101", "ta");
		spellPut("223-102", "di");
		spellPut("223-103", "chi");
		spellPut("223-104", "yuan");
		spellPut("223-105", "su");
		spellPut("223-106", "he wo ong");
		spellPut("223-107", "guan");
		spellPut("223-108", "zhang");
		spellPut("223-109", "shi");
		spellPut("223-110", "ca");
		spellPut("223-111", "chi");
		spellPut("223-112", "su");
		spellPut("223-113", "dun");
		spellPut("223-114", "di");
		spellPut("223-115", "lou");
		spellPut("223-116", "chi");
		spellPut("223-117", "cuo");
		spellPut("223-118", "rao");
		spellPut("223-119", "qian");
		spellPut("223-120", "xuan");
		spellPut("223-121", "yu");
		spellPut("223-122", "yi");
		spellPut("223-123", "e");
		spellPut("223-124", "liao");
		spellPut("223-125", "shi");
		spellPut("223-126", "mai");
		spellPut("223-128", "huan,hai");
		spellPut("223-129", "zhan");
		spellPut("223-130", "teng");
		spellPut("223-131", "er");
		spellPut("223-132", "bian");
		spellPut("223-133", "bian");
		spellPut("223-134", "li,chi");
		spellPut("223-135", "yuan");
		spellPut("223-136", "yao");
		spellPut("223-137", "luo");
		spellPut("223-138", "li");
		spellPut("223-139", "ting");
		spellPut("223-140", "qi");
		spellPut("223-141", "shan");
		spellPut("223-142", "yu");
		spellPut("223-143", "ru");
		spellPut("223-144", "xi");
		spellPut("223-145", "fu");
		spellPut("223-146", "kang,hang");
		spellPut("223-147", "bin");
		spellPut("223-148", "xin");
		spellPut("223-149", "shen");
		spellPut("223-150", "yuan");
		spellPut("223-151", "cun");
		spellPut("223-152", "huo");
		spellPut("223-153", "bang");
		spellPut("223-154", "ju");
		spellPut("223-155", "bi");
		spellPut("223-156", "wa");
		spellPut("223-157", "kuang");
		spellPut("223-158", "gui");
		spellPut("223-159", "shi");
		spellPut("223-160", "ku");
		spellPut("223-161", "zhe");
		spellPut("223-162", "xie");
		spellPut("223-163", "lu");
		spellPut("223-164", "zun");
		spellPut("223-165", "cuan");
		spellPut("223-166", "gan");
		spellPut("223-167", "huan");
		spellPut("223-168", "pi,bo");
		spellPut("223-169", "xing");
		spellPut("223-170", "zhuo");
		spellPut("223-171", "huo");
		spellPut("223-172", "zuan");
		spellPut("223-173", "nang");
		spellPut("223-174", "yi");
		spellPut("223-175", "te,tui");
		spellPut("223-176", "dai");
		spellPut("223-177", "shi");
		spellPut("223-178", "bu");
		spellPut("223-179", "chi");
		spellPut("223-180", "ji");
		spellPut("223-181", "kou");
		spellPut("223-182", "tao,dao");
		spellPut("223-183", "le");
		spellPut("223-184", "zha");
		spellPut("223-185", "ya,a");
		spellPut("223-186", "yao");
		spellPut("223-187", "fu");
		spellPut("223-188", "fu,?");
		spellPut("223-189", "yi");
		spellPut("223-190", "dai");
		spellPut("223-191", "li");
		spellPut("223-192", "e");
		spellPut("223-193", "pi,bi");
		spellPut("223-194", "bei,bai");
		spellPut("223-195", "wai,he,wo,wa,gua,guo");
		spellPut("223-196", "qin");
		spellPut("223-197", "yin,shen");
		spellPut("223-198", "za");
		spellPut("223-199", "ka");
		spellPut("223-200", "xia");
		spellPut("223-201", "gua,gu");
		spellPut("223-202", "ling");
		spellPut("223-203", "dong");
		spellPut("223-204", "ning");
		spellPut("223-205", "duo");
		spellPut("223-206", "nao");
		spellPut("223-207", "you");
		spellPut("223-208", "si");
		spellPut("223-209", "kuang");
		spellPut("223-210", "ji,xi,qia");
		spellPut("223-211", "shen");
		spellPut("223-212", "hui");
		spellPut("223-213", "da");
		spellPut("223-214", "lie");
		spellPut("223-215", "yi");
		spellPut("223-216", "xiao");
		spellPut("223-217", "bi");
		spellPut("223-218", "zi,ci");
		spellPut("223-219", "guang");
		spellPut("223-220", "yue,hui");
		spellPut("223-221", "xiu");
		spellPut("223-222", "yi");
		spellPut("223-223", "pai");
		spellPut("223-224", "kuai");
		spellPut("223-225", "duo");
		spellPut("223-226", "ji,jie,zhai");
		spellPut("223-227", "mie");
		spellPut("223-228", "mi");
		spellPut("223-229", "zha");
		spellPut("223-230", "nong");
		spellPut("223-231", "gen,hen");
		spellPut("223-232", "mou");
		spellPut("223-233", "ma");
		spellPut("223-234", "chi");
		spellPut("223-235", "lao");
		spellPut("223-236", "geng");
		spellPut("223-237", "?g,m");
		spellPut("223-238", "zha");
		spellPut("223-239", "suo");
		spellPut("223-240", "zao");
		spellPut("223-241", "xi");
		spellPut("223-242", "zuo");
		spellPut("223-243", "ji");
		spellPut("223-244", "feng");
		spellPut("223-245", "ze");
		spellPut("223-246", "nuo,re");
		spellPut("223-247", "miao");
		spellPut("223-248", "lan,lin");
		spellPut("223-249", "zhuan");
		spellPut("223-250", "zhou,zhao,tiao");
		spellPut("223-251", "tao");
		spellPut("223-252", "hu");
		spellPut("223-253", "cui,qi");
		spellPut("223-254", "sha");
	}

	private static void init86() {
		spellPut("224-64", "gai,hai");
		spellPut("224-65", "he");
		spellPut("224-66", "ji");
		spellPut("224-67", "hou");
		spellPut("224-68", "xing");
		spellPut("224-69", "xi");
		spellPut("224-70", "gui");
		spellPut("224-71", "na");
		spellPut("224-72", "lang");
		spellPut("224-73", "yan");
		spellPut("224-74", "cheng");
		spellPut("224-75", "dou");
		spellPut("224-76", "lv");
		spellPut("224-77", "fu");
		spellPut("224-78", "wu");
		spellPut("224-79", "lang");
		spellPut("224-80", "jia");
		spellPut("224-81", "geng");
		spellPut("224-82", "bo");
		spellPut("224-83", "xi");
		spellPut("224-84", "bei");
		spellPut("224-85", "xiao,ao");
		spellPut("224-86", "qi");
		spellPut("224-87", "qing");
		spellPut("224-88", "zhou");
		spellPut("224-89", "zou");
		spellPut("224-90", "ping");
		spellPut("224-91", "lai");
		spellPut("224-92", "ni");
		spellPut("224-93", "you");
		spellPut("224-94", "bu");
		spellPut("224-95", "xiang");
		spellPut("224-96", "ju");
		spellPut("224-97", "yong");
		spellPut("224-98", "qiao");
		spellPut("224-99", "yi");
		spellPut("224-100", "mei");
		spellPut("224-101", "ruo");
		spellPut("224-102", "bei");
		spellPut("224-103", "shu");
		spellPut("224-104", "yu");
		spellPut("224-105", "yun");
		spellPut("224-106", "hou");
		spellPut("224-107", "kui");
		spellPut("224-108", "xiang");
		spellPut("224-109", "xiang");
		spellPut("224-110", "sou");
		spellPut("224-111", "tang");
		spellPut("224-112", "ming");
		spellPut("224-113", "xi");
		spellPut("224-114", "ru");
		spellPut("224-115", "chu");
		spellPut("224-116", "zi");
		spellPut("224-117", "zou");
		spellPut("224-118", "yi");
		spellPut("224-119", "wu");
		spellPut("224-120", "xiang");
		spellPut("224-121", "yun");
		spellPut("224-122", "hao");
		spellPut("224-123", "yong");
		spellPut("224-124", "mao");
		spellPut("224-125", "chao");
		spellPut("224-126", "fu");
		spellPut("224-128", "liao");
		spellPut("224-129", "zhuan");
		spellPut("224-130", "hu");
		spellPut("224-131", "qiao");
		spellPut("224-132", "man");
		spellPut("224-133", "qiao");
		spellPut("224-134", "xu");
		spellPut("224-135", "deng");
		spellPut("224-136", "bi");
		spellPut("224-137", "xun");
		spellPut("224-138", "bi");
		spellPut("224-139", "zeng");
		spellPut("224-140", "wei");
		spellPut("224-141", "zheng");
		spellPut("224-142", "mao");
		spellPut("224-143", "lin");
		spellPut("224-144", "dan");
		spellPut("224-145", "meng");
		spellPut("224-146", "ye");
		spellPut("224-147", "cao");
		spellPut("224-148", "kuai");
		spellPut("224-149", "feng");
		spellPut("224-150", "meng");
		spellPut("224-151", "kuang");
		spellPut("224-152", "lian");
		spellPut("224-153", "zan");
		spellPut("224-154", "chan");
		spellPut("224-155", "you");
		spellPut("224-156", "qi");
		spellPut("224-157", "yan");
		spellPut("224-158", "chan");
		spellPut("224-159", "zan");
		spellPut("224-160", "huan");
		spellPut("224-161", "yo");
		spellPut("224-162", "dan");
		spellPut("224-163", "bo");
		spellPut("224-164", "ding");
		spellPut("224-165", "lang");
		spellPut("224-166", "li");
		spellPut("224-167", "shua");
		spellPut("224-168", "chuo,chuai");
		spellPut("224-169", "die,zha");
		spellPut("224-170", "ta,da");
		spellPut("224-171", "nan");
		spellPut("224-172", "li");
		spellPut("224-173", "kui");
		spellPut("224-174", "jie");
		spellPut("224-175", "yong");
		spellPut("224-176", "kui");
		spellPut("224-177", "jiu");
		spellPut("224-178", "sou");
		spellPut("224-179", "yin");
		spellPut("224-180", "chi");
		spellPut("224-181", "jie");
		spellPut("224-182", "lou");
		spellPut("224-183", "ku");
		spellPut("224-184", "o,wo");
		spellPut("224-185", "hui");
		spellPut("224-186", "qin");
		spellPut("224-187", "ao");
		spellPut("224-188", "su");
		spellPut("224-189", "du");
		spellPut("224-190", "ke");
		spellPut("224-191", "nie");
		spellPut("224-192", "he");
		spellPut("224-193", "chen");
		spellPut("224-194", "suo");
		spellPut("224-195", "ge");
		spellPut("224-196", "sha,a");
		spellPut("224-197", "?g,?g, g");
		spellPut("224-198", "hao");
		spellPut("224-199", "dia");
		spellPut("224-200", "ai");
		spellPut("224-201", "yi,ai");
		spellPut("224-202", "suo");
		spellPut("224-203", "hai,hei");
		spellPut("224-204", "tong");
		spellPut("224-205", "chi");
		spellPut("224-206", "pei");
		spellPut("224-207", "lei");
		spellPut("224-208", "cao");
		spellPut("224-209", "piao");
		spellPut("224-210", "qi");
		spellPut("224-211", "ying");
		spellPut("224-212", "beng");
		spellPut("224-213", "sou");
		spellPut("224-214", "di");
		spellPut("224-215", "mi");
		spellPut("224-216", "peng");
		spellPut("224-217", "jue");
		spellPut("224-218", "liao");
		spellPut("224-219", "pu");
		spellPut("224-220", "zuo");
		spellPut("224-221", "jiao");
		spellPut("224-222", "o");
		spellPut("224-223", "qin");
		spellPut("224-224", "lu");
		spellPut("224-225", "ceng");
		spellPut("224-226", "deng");
		spellPut("224-227", "hao");
		spellPut("224-228", "jin");
		spellPut("224-229", "jue,xue");
		spellPut("224-230", "yi");
		spellPut("224-231", "sai");
		spellPut("224-232", "pi");
		spellPut("224-233", "ru");
		spellPut("224-234", "ca,cha");
		spellPut("224-235", "huo");
		spellPut("224-236", "nang");
		spellPut("224-237", "wei,guo");
		spellPut("224-238", "jian,nan");
		spellPut("224-239", "nan");
		spellPut("224-240", "lun");
		spellPut("224-241", "hu");
		spellPut("224-242", "ling");
		spellPut("224-243", "you");
		spellPut("224-244", "yu");
		spellPut("224-245", "qing");
		spellPut("224-246", "yu");
		spellPut("224-247", "huan,yuan");
		spellPut("224-248", "wei");
		spellPut("224-249", "zhi");
		spellPut("224-250", "pei");
		spellPut("224-251", "tang,nu");
		spellPut("224-252", "chou,dao");
		spellPut("224-253", "ze");
		spellPut("224-254", "guo");
	}

	private static void init87() {
		spellPut("225-64", "xi");
		spellPut("225-65", "zan");
		spellPut("225-66", "li");
		spellPut("225-67", "yu");
		spellPut("225-68", "yan");
		spellPut("225-69", "zui");
		spellPut("225-70", "mao");
		spellPut("225-71", "dan");
		spellPut("225-72", "dou");
		spellPut("225-73", "zhen");
		spellPut("225-74", "ki mo to");
		spellPut("225-75", "fu");
		spellPut("225-76", "tian");
		spellPut("225-77", "qia");
		spellPut("225-78", "po");
		spellPut("225-79", "chou");
		spellPut("225-80", "zai");
		spellPut("225-81", "chuo");
		spellPut("225-82", "you");
		spellPut("225-83", "yin");
		spellPut("225-84", "pu");
		spellPut("225-85", "zui");
		spellPut("225-86", "hai");
		spellPut("225-87", "wei");
		spellPut("225-88", "lu");
		spellPut("225-89", "lan");
		spellPut("225-90", "yan");
		spellPut("225-91", "tao");
		spellPut("225-92", "zhan");
		spellPut("225-93", "tan,dan");
		spellPut("225-94", "zhui");
		spellPut("225-95", "xian");
		spellPut("225-96", "du");
		spellPut("225-97", "tan");
		spellPut("225-98", "qiu,chou");
		spellPut("225-99", "chun");
		spellPut("225-100", "yun");
		spellPut("225-101", "po,fa");
		spellPut("225-102", "ke");
		spellPut("225-103", "sou");
		spellPut("225-104", "chou");
		spellPut("225-105", "cuo");
		spellPut("225-106", "yun");
		spellPut("225-107", "yong");
		spellPut("225-108", "ang");
		spellPut("225-109", "zha");
		spellPut("225-110", "jiang");
		spellPut("225-111", "piao");
		spellPut("225-112", "chan,chen");
		spellPut("225-113", "yu");
		spellPut("225-114", "li");
		spellPut("225-115", "zao");
		spellPut("225-116", "yi");
		spellPut("225-117", "jiang");
		spellPut("225-118", "tan");
		spellPut("225-119", "po,fa");
		spellPut("225-120", "nong");
		spellPut("225-121", "yi,shi");
		spellPut("225-122", "yan,lian,xian");
		spellPut("225-123", "yi");
		spellPut("225-124", "niang");
		spellPut("225-125", "ru");
		spellPut("225-126", "chou");
		spellPut("225-128", "yan");
		spellPut("225-129", "ling");
		spellPut("225-130", "mi");
		spellPut("225-131", "mi");
		spellPut("225-132", "niang");
		spellPut("225-133", "xin");
		spellPut("225-134", "jiao");
		spellPut("225-135", "shi");
		spellPut("225-136", "mi");
		spellPut("225-137", "yan");
		spellPut("225-138", "bian");
		spellPut("225-139", "shi");
		spellPut("225-140", "shi");
		spellPut("225-141", "li,xi");
		spellPut("225-142", "jin");
		spellPut("225-143", "ga");
		spellPut("225-144", "yi");
		spellPut("225-145", "liao");
		spellPut("225-146", "dao");
		spellPut("225-147", "zhao");
		spellPut("225-148", "ding");
		spellPut("225-149", "po");
		spellPut("225-150", "qiu");
		spellPut("225-151", "he");
		spellPut("225-152", "zhen");
		spellPut("225-153", "zhi");
		spellPut("225-154", "ba");
		spellPut("225-155", "luan");
		spellPut("225-156", "fu");
		spellPut("225-157", "nai");
		spellPut("225-158", "diao");
		spellPut("225-159", "shan");
		spellPut("225-160", "qiao,jiao");
		spellPut("225-161", "wei");
		spellPut("225-162", "wo");
		spellPut("225-163", "man");
		spellPut("225-164", "zhang");
		spellPut("225-165", "fu");
		spellPut("225-166", "fan");
		spellPut("225-167", "ji");
		spellPut("225-168", "qi");
		spellPut("225-169", "qian");
		spellPut("225-170", "qi");
		spellPut("225-171", "qu");
		spellPut("225-172", "ya");
		spellPut("225-173", "xian");
		spellPut("225-174", "ao");
		spellPut("225-175", "cen");
		spellPut("225-176", "lan");
		spellPut("225-177", "ba");
		spellPut("225-178", "hu");
		spellPut("225-179", "ke");
		spellPut("225-180", "dong");
		spellPut("225-181", "jia");
		spellPut("225-182", "xiu");
		spellPut("225-183", "dai");
		spellPut("225-184", "gou");
		spellPut("225-185", "mao");
		spellPut("225-186", "min");
		spellPut("225-187", "yi");
		spellPut("225-188", "tong,dong");
		spellPut("225-189", "jiao,qiao");
		spellPut("225-190", "xun");
		spellPut("225-191", "zheng");
		spellPut("225-192", "lao");
		spellPut("225-193", "lai");
		spellPut("225-194", "song");
		spellPut("225-195", "yan");
		spellPut("225-196", "gu");
		spellPut("225-197", "xiao");
		spellPut("225-198", "guo");
		spellPut("225-199", "kong");
		spellPut("225-200", "jue");
		spellPut("225-201", "rong");
		spellPut("225-202", "yao");
		spellPut("225-203", "wai,wei");
		spellPut("225-204", "zai");
		spellPut("225-205", "wei");
		spellPut("225-206", "yu");
		spellPut("225-207", "cuo");
		spellPut("225-208", "lou");
		spellPut("225-209", "zi");
		spellPut("225-210", "mei");
		spellPut("225-211", "sheng");
		spellPut("225-212", "song");
		spellPut("225-213", "ji");
		spellPut("225-214", "zhang");
		spellPut("225-215", "lin");
		spellPut("225-216", "deng");
		spellPut("225-217", "bin");
		spellPut("225-218", "yi");
		spellPut("225-219", "dian");
		spellPut("225-220", "chi");
		spellPut("225-221", "pang,fang");
		spellPut("225-222", "cu");
		spellPut("225-223", "xun");
		spellPut("225-224", "yang");
		spellPut("225-225", "hou");
		spellPut("225-226", "lai");
		spellPut("225-227", "xi");
		spellPut("225-228", "chang");
		spellPut("225-229", "huang");
		spellPut("225-230", "yao");
		spellPut("225-231", "zhi,zheng");
		spellPut("225-232", "jiao");
		spellPut("225-233", "qu");
		spellPut("225-234", "shan,xian");
		spellPut("225-235", "quan");
		spellPut("225-236", "qiu");
		spellPut("225-237", "han,an");
		spellPut("225-238", "guang");
		spellPut("225-239", "ma");
		spellPut("225-240", "niu");
		spellPut("225-241", "yun");
		spellPut("225-242", "xia");
		spellPut("225-243", "pao");
		spellPut("225-244", "fei");
		spellPut("225-245", "rong");
		spellPut("225-246", "kuai");
		spellPut("225-247", "shou");
		spellPut("225-248", "sun");
		spellPut("225-249", "bi");
		spellPut("225-250", "juan");
		spellPut("225-251", "li");
		spellPut("225-252", "yu");
		spellPut("225-253", "xian");
		spellPut("225-254", "yin");
	}

	private static void init88() {
		spellPut("226-64", "kou");
		spellPut("226-65", "chuan");
		spellPut("226-66", "zi");
		spellPut("226-67", "fan");
		spellPut("226-68", "hua,yu");
		spellPut("226-69", "hua,wu");
		spellPut("226-70", "han");
		spellPut("226-71", "gang");
		spellPut("226-72", "qi");
		spellPut("226-73", "mang");
		spellPut("226-74", "ri,ren,jian");
		spellPut("226-75", "di,dai");
		spellPut("226-76", "si");
		spellPut("226-77", "xi");
		spellPut("226-78", "yi");
		spellPut("226-79", "chai");
		spellPut("226-80", "shi,yi");
		spellPut("226-81", "tu");
		spellPut("226-82", "xi");
		spellPut("226-83", "nv");
		spellPut("226-84", "qian");
		spellPut("226-85", "qiu");
		spellPut("226-86", "ri,ren,jian");
		spellPut("226-87", "pi,zhao");
		spellPut("226-88", "ye,ya");
		spellPut("226-89", "jin");
		spellPut("226-90", "ba");
		spellPut("226-91", "fang");
		spellPut("226-92", "chen");
		spellPut("226-93", "xing");
		spellPut("226-94", "dou");
		spellPut("226-95", "yue");
		spellPut("226-96", "qian");
		spellPut("226-97", "fu");
		spellPut("226-98", "bu");
		spellPut("226-99", "na");
		spellPut("226-100", "xin");
		spellPut("226-101", "e");
		spellPut("226-102", "jue");
		spellPut("226-103", "dun");
		spellPut("226-104", "gou");
		spellPut("226-105", "yin");
		spellPut("226-106", "qian");
		spellPut("226-107", "ban");
		spellPut("226-108", "sa");
		spellPut("226-109", "ren");
		spellPut("226-110", "chao");
		spellPut("226-111", "niu");
		spellPut("226-112", "fen");
		spellPut("226-113", "yun");
		spellPut("226-114", "yi");
		spellPut("226-115", "qin");
		spellPut("226-116", "pi");
		spellPut("226-117", "guo");
		spellPut("226-118", "hong");
		spellPut("226-119", "yin");
		spellPut("226-120", "jun");
		spellPut("226-121", "diao");
		spellPut("226-122", "yi");
		spellPut("226-123", "zhong");
		spellPut("226-124", "xi");
		spellPut("226-125", "gai");
		spellPut("226-126", "ri");
		spellPut("226-128", "huo");
		spellPut("226-129", "tai");
		spellPut("226-130", "kang");
		spellPut("226-131", "ha ba ki");
		spellPut("226-132", "lu");
		spellPut("226-133", "e");
		spellPut("226-134", "qin");
		spellPut("226-135", "duo");
		spellPut("226-136", "zi");
		spellPut("226-137", "ni");
		spellPut("226-138", "tu");
		spellPut("226-139", "shi");
		spellPut("226-140", "min");
		spellPut("226-141", "gu");
		spellPut("226-142", "ke");
		spellPut("226-143", "ling");
		spellPut("226-144", "bing");
		spellPut("226-145", "si");
		spellPut("226-146", "gu");
		spellPut("226-147", "bo");
		spellPut("226-148", "pi");
		spellPut("226-149", "yu");
		spellPut("226-150", "si");
		spellPut("226-151", "zuo");
		spellPut("226-152", "bu");
		spellPut("226-153", "you");
		spellPut("226-154", "dian");
		spellPut("226-155", "jia");
		spellPut("226-156", "zhen");
		spellPut("226-157", "shi");
		spellPut("226-158", "shi");
		spellPut("226-159", "tie");
		spellPut("226-160", "ju");
		spellPut("226-161", "suan");
		spellPut("226-162", "yi");
		spellPut("226-163", "guo");
		spellPut("226-164", "luo");
		spellPut("226-165", "ni");
		spellPut("226-166", "she");
		spellPut("226-167", "cu");
		spellPut("226-168", "mi");
		spellPut("226-169", "hu");
		spellPut("226-170", "cha");
		spellPut("226-171", "wei");
		spellPut("226-172", "wei");
		spellPut("226-173", "mei");
		spellPut("226-174", "nao");
		spellPut("226-175", "zhang");
		spellPut("226-176", "jing");
		spellPut("226-177", "jue");
		spellPut("226-178", "liao");
		spellPut("226-179", "xie");
		spellPut("226-180", "xun");
		spellPut("226-181", "huan");
		spellPut("226-182", "chuan");
		spellPut("226-183", "huo");
		spellPut("226-184", "sun");
		spellPut("226-185", "yin");
		spellPut("226-186", "zhi,zhong");
		spellPut("226-187", "shi");
		spellPut("226-188", "xing");
		spellPut("226-189", "tun");
		spellPut("226-190", "xi");
		spellPut("226-191", "ren");
		spellPut("226-192", "yu");
		spellPut("226-193", "chi");
		spellPut("226-194", "yi");
		spellPut("226-195", "xiang");
		spellPut("226-196", "bo");
		spellPut("226-197", "yu");
		spellPut("226-198", "hun");
		spellPut("226-199", "cha");
		spellPut("226-200", "sou");
		spellPut("226-201", "mo");
		spellPut("226-202", "xiu");
		spellPut("226-203", "jin");
		spellPut("226-204", "san");
		spellPut("226-205", "zhuan");
		spellPut("226-206", "nang");
		spellPut("226-207", "pi");
		spellPut("226-208", "wu");
		spellPut("226-209", "gui");
		spellPut("226-210", "pao");
		spellPut("226-211", "xiu");
		spellPut("226-212", "xiang");
		spellPut("226-213", "tuo");
		spellPut("226-214", "an");
		spellPut("226-215", "yu");
		spellPut("226-216", "bei");
		spellPut("226-217", "geng");
		spellPut("226-218", "ao");
		spellPut("226-219", "jin,qin");
		spellPut("226-220", "chan");
		spellPut("226-221", "xie");
		spellPut("226-222", "lin");
		spellPut("226-223", "ying");
		spellPut("226-224", "xin");
		spellPut("226-225", "dao");
		spellPut("226-226", "cun");
		spellPut("226-227", "chan");
		spellPut("226-228", "wu");
		spellPut("226-229", "zhi");
		spellPut("226-230", "ou");
		spellPut("226-231", "chong");
		spellPut("226-232", "wu");
		spellPut("226-233", "kai,xi");
		spellPut("226-234", "chang");
		spellPut("226-235", "chuang");
		spellPut("226-236", "song,zhong");
		spellPut("226-237", "bian");
		spellPut("226-238", "niu");
		spellPut("226-239", "hu");
		spellPut("226-240", "chu");
		spellPut("226-241", "peng");
		spellPut("226-242", "da");
		spellPut("226-243", "yang");
		spellPut("226-244", "zuo,zha");
		spellPut("226-245", "ni");
		spellPut("226-246", "fu");
		spellPut("226-247", "chao");
		spellPut("226-248", "yi");
		spellPut("226-249", "yi");
		spellPut("226-250", "tong");
		spellPut("226-251", "yan");
		spellPut("226-252", "ce");
		spellPut("226-253", "kai");
		spellPut("226-254", "xun");
	}

	private static void init89() {
		spellPut("227-64", "zuan");
		spellPut("227-65", "shi");
		spellPut("227-66", "ta");
		spellPut("227-67", "xuan");
		spellPut("227-68", "zhao");
		spellPut("227-69", "bao");
		spellPut("227-70", "he");
		spellPut("227-71", "bi");
		spellPut("227-72", "sheng");
		spellPut("227-73", "chu");
		spellPut("227-74", "shi");
		spellPut("227-75", "bo");
		spellPut("227-76", "zhu");
		spellPut("227-77", "chi");
		spellPut("227-78", "za");
		spellPut("227-79", "po");
		spellPut("227-80", "tong");
		spellPut("227-81", "qian");
		spellPut("227-82", "fu");
		spellPut("227-83", "zhai");
		spellPut("227-84", "mao");
		spellPut("227-85", "qian");
		spellPut("227-86", "fu");
		spellPut("227-87", "li");
		spellPut("227-88", "yue");
		spellPut("227-89", "pi");
		spellPut("227-90", "yang");
		spellPut("227-91", "ban");
		spellPut("227-92", "bo");
		spellPut("227-93", "jie");
		spellPut("227-94", "gou");
		spellPut("227-95", "shu");
		spellPut("227-96", "zheng");
		spellPut("227-97", "mu");
		spellPut("227-98", "xi");
		spellPut("227-99", "xi");
		spellPut("227-100", "di");
		spellPut("227-101", "jia");
		spellPut("227-102", "mu");
		spellPut("227-103", "tan");
		spellPut("227-104", "shen");
		spellPut("227-105", "yi");
		spellPut("227-106", "si");
		spellPut("227-107", "kuang");
		spellPut("227-108", "ka");
		spellPut("227-109", "bei");
		spellPut("227-110", "tong");
		spellPut("227-111", "xing");
		spellPut("227-112", "hong");
		spellPut("227-113", "jiao");
		spellPut("227-114", "chi");
		spellPut("227-115", "er");
		spellPut("227-116", "ge");
		spellPut("227-117", "bing");
		spellPut("227-118", "shi");
		spellPut("227-119", "mao");
		spellPut("227-120", "ha");
		spellPut("227-121", "yin");
		spellPut("227-122", "jun");
		spellPut("227-123", "zhou");
		spellPut("227-124", "chong");
		spellPut("227-125", "xiang,jiong");
		spellPut("227-126", "tong");
		spellPut("227-128", "mo");
		spellPut("227-129", "lei");
		spellPut("227-130", "ji");
		spellPut("227-131", "yu,si");
		spellPut("227-132", "xu,hui");
		spellPut("227-133", "ren");
		spellPut("227-134", "zun");
		spellPut("227-135", "zhi");
		spellPut("227-136", "shan,shuo");
		spellPut("227-137", "chi,li");
		spellPut("227-138", "xian,xi");
		spellPut("227-139", "xing");
		spellPut("227-140", "quan");
		spellPut("227-141", "pi");
		spellPut("227-142", "tie");
		spellPut("227-143", "zhu");
		spellPut("227-144", "hou,xiang");
		spellPut("227-145", "ming");
		spellPut("227-146", "kua");
		spellPut("227-147", "diao,tiao,yao");
		spellPut("227-148", "xian,kuo,tian,gua");
		spellPut("227-149", "xian");
		spellPut("227-150", "xiu");
		spellPut("227-151", "jun");
		spellPut("227-152", "cha");
		spellPut("227-153", "lao");
		spellPut("227-154", "ji");
		spellPut("227-155", "pi");
		spellPut("227-156", "ru");
		spellPut("227-157", "mi");
		spellPut("227-158", "yi");
		spellPut("227-159", "yin");
		spellPut("227-160", "guang");
		spellPut("227-161", "ke");
		spellPut("227-162", "yun");
		spellPut("227-163", "bei");
		spellPut("227-164", "song");
		spellPut("227-165", "qian");
		spellPut("227-166", "kui,li");
		spellPut("227-167", "kun");
		spellPut("227-168", "yi");
		spellPut("227-169", "ti");
		spellPut("227-170", "quan");
		spellPut("227-171", "qie");
		spellPut("227-172", "xing");
		spellPut("227-173", "fei");
		spellPut("227-174", "chang");
		spellPut("227-175", "wang");
		spellPut("227-176", "chou");
		spellPut("227-177", "hu");
		spellPut("227-178", "cui");
		spellPut("227-179", "yun");
		spellPut("227-180", "kui");
		spellPut("227-181", "e");
		spellPut("227-182", "leng");
		spellPut("227-183", "zhui");
		spellPut("227-184", "qiao");
		spellPut("227-185", "bi");
		spellPut("227-186", "su");
		spellPut("227-187", "qian,qie");
		spellPut("227-188", "yong");
		spellPut("227-189", "jing");
		spellPut("227-190", "qiao");
		spellPut("227-191", "chong");
		spellPut("227-192", "chu");
		spellPut("227-193", "lin");
		spellPut("227-194", "meng");
		spellPut("227-195", "tian");
		spellPut("227-196", "hui,duo");
		spellPut("227-197", "shuan");
		spellPut("227-198", "yan");
		spellPut("227-199", "wei");
		spellPut("227-200", "hong");
		spellPut("227-201", "min");
		spellPut("227-202", "kang");
		spellPut("227-203", "ta");
		spellPut("227-204", "lv");
		spellPut("227-205", "kun");
		spellPut("227-206", "jiu");
		spellPut("227-207", "lang");
		spellPut("227-208", "yu");
		spellPut("227-209", "chang");
		spellPut("227-210", "xi");
		spellPut("227-211", "wen");
		spellPut("227-212", "hun");
		spellPut("227-213", "e");
		spellPut("227-214", "qu");
		spellPut("227-215", "que");
		spellPut("227-216", "he");
		spellPut("227-217", "tian");
		spellPut("227-218", "que");
		spellPut("227-219", "kan");
		spellPut("227-220", "pan");
		spellPut("227-221", "pan");
		spellPut("227-222", "qiang");
		spellPut("227-223", "shui");
		spellPut("227-224", "qi");
		spellPut("227-225", "si");
		spellPut("227-226", "cha");
		spellPut("227-227", "feng");
		spellPut("227-228", "yuan");
		spellPut("227-229", "mu");
		spellPut("227-230", "mian");
		spellPut("227-231", "dun");
		spellPut("227-232", "mi");
		spellPut("227-233", "gu,yu");
		spellPut("227-234", "bian");
		spellPut("227-235", "wen,men");
		spellPut("227-236", "hang");
		spellPut("227-237", "wei");
		spellPut("227-238", "le");
		spellPut("227-239", "gan");
		spellPut("227-240", "shu");
		spellPut("227-241", "long,shuang");
		spellPut("227-242", "lu");
		spellPut("227-243", "yang");
		spellPut("227-244", "si");
		spellPut("227-245", "tuo,duo");
		spellPut("227-246", "ling");
		spellPut("227-247", "mao");
		spellPut("227-248", "luo,po");
		spellPut("227-249", "xuan");
		spellPut("227-250", "pan");
		spellPut("227-251", "tuo");
		spellPut("227-252", "hong");
		spellPut("227-253", "min");
		spellPut("227-254", "jing");
	}

	private static void init90() {
		spellPut("228-64", "an");
		spellPut("228-65", "diu");
		spellPut("228-66", "you");
		spellPut("228-67", "se");
		spellPut("228-68", "kao");
		spellPut("228-69", "qian");
		spellPut("228-70", "ka si ga yi");
		spellPut("228-71", "ngBi");
		spellPut("228-72", "diao");
		spellPut("228-73", "han");
		spellPut("228-74", "rui");
		spellPut("228-75", "shi,zhi");
		spellPut("228-76", "keng");
		spellPut("228-77", "qiu");
		spellPut("228-78", "xiao");
		spellPut("228-79", "zhe,nie");
		spellPut("228-80", "xiu");
		spellPut("228-81", "zang");
		spellPut("228-82", "ti");
		spellPut("228-83", "cuo");
		spellPut("228-84", "xian,kuo,tian,gua");
		spellPut("228-85", "hong,gong");
		spellPut("228-86", "zhong,yong");
		spellPut("228-87", "tou,tu,dou");
		spellPut("228-88", "lv");
		spellPut("228-89", "mei,meng");
		spellPut("228-90", "lang");
		spellPut("228-91", "wan,jian");
		spellPut("228-92", "xin");
		spellPut("228-93", "yun");
		spellPut("228-94", "bei");
		spellPut("228-95", "su");
		spellPut("228-96", "yu");
		spellPut("228-97", "chan");
		spellPut("228-98", "ting,ding");
		spellPut("228-99", "bo");
		spellPut("228-100", "han");
		spellPut("228-101", "jia");
		spellPut("228-102", "hong");
		spellPut("228-103", "juan,jian,cuan");
		spellPut("228-104", "feng");
		spellPut("228-105", "chan");
		spellPut("228-106", "wan");
		spellPut("228-107", "zhi");
		spellPut("228-108", "si,tuo");
		spellPut("228-109", "xuan,juan");
		spellPut("228-110", "hua,wu");
		spellPut("228-111", "wu");
		spellPut("228-112", "tiao");
		spellPut("228-113", "kuang");
		spellPut("228-114", "zhuo,chuo");
		spellPut("228-115", "l<e");
		spellPut("228-116", "xing,jing");
		spellPut("228-117", "qin");
		spellPut("228-118", "shen");
		spellPut("228-119", "han");
		spellPut("228-120", "l<e");
		spellPut("228-121", "ye");
		spellPut("228-122", "chu");
		spellPut("228-123", "zeng");
		spellPut("228-124", "ju");
		spellPut("228-125", "xian");
		spellPut("228-126", "e");
		spellPut("228-128", "mang");
		spellPut("228-129", "pu");
		spellPut("228-130", "li");
		spellPut("228-131", "pan");
		spellPut("228-132", "rui");
		spellPut("228-133", "cheng");
		spellPut("228-134", "gao");
		spellPut("228-135", "li");
		spellPut("228-136", "te");
		spellPut("228-137", "biBo");
		spellPut("228-138", "zhu");
		spellPut("228-139", "zhen");
		spellPut("228-140", "tu");
		spellPut("228-141", "liu");
		spellPut("228-142", "zui,nie");
		spellPut("228-143", "ju");
		spellPut("228-144", "chang");
		spellPut("228-145", "yuan,wan");
		spellPut("228-146", "jian");
		spellPut("228-147", "gang");
		spellPut("228-148", "diao");
		spellPut("228-149", "tao");
		spellPut("228-150", "shang");
		spellPut("228-151", "lun");
		spellPut("228-152", "ke");
		spellPut("228-153", "ling");
		spellPut("228-154", "pi");
		spellPut("228-155", "lu");
		spellPut("228-156", "li");
		spellPut("228-157", "qing");
		spellPut("228-158", "pei");
		spellPut("228-159", "juan");
		spellPut("228-160", "min");
		spellPut("228-161", "huan");
		spellPut("228-162", "wei");
		spellPut("228-163", "lie");
		spellPut("228-164", "jia");
		spellPut("228-165", "zhen");
		spellPut("228-166", "yin");
		spellPut("228-167", "hui");
		spellPut("228-168", "zhu");
		spellPut("228-169", "ji");
		spellPut("228-170", "xu");
		spellPut("228-171", "kuai,hui");
		spellPut("228-172", "tao");
		spellPut("228-173", "xun");
		spellPut("228-174", "jiang");
		spellPut("228-175", "liu");
		spellPut("228-176", "hu,xu");
		spellPut("228-177", "xun");
		spellPut("228-178", "ru");
		spellPut("228-179", "su");
		spellPut("228-180", "wu");
		spellPut("228-181", "lai");
		spellPut("228-182", "wei");
		spellPut("228-183", "zhuo");
		spellPut("228-184", "juan");
		spellPut("228-185", "cen");
		spellPut("228-186", "bang");
		spellPut("228-187", "xi");
		spellPut("228-188", "mei");
		spellPut("228-189", "huan");
		spellPut("228-190", "zhu");
		spellPut("228-191", "qi");
		spellPut("228-192", "xi");
		spellPut("228-193", "song");
		spellPut("228-194", "du,dou");
		spellPut("228-195", "zhuo");
		spellPut("228-196", "pi,pei");
		spellPut("228-197", "mian,sheng");
		spellPut("228-198", "gan");
		spellPut("228-199", "fei");
		spellPut("228-200", "cong");
		spellPut("228-201", "shen");
		spellPut("228-202", "guan");
		spellPut("228-203", "lu");
		spellPut("228-204", "shuan");
		spellPut("228-205", "xie");
		spellPut("228-206", "yan,yin");
		spellPut("228-207", "mian");
		spellPut("228-208", "qiu,jiao");
		spellPut("228-209", "sou");
		spellPut("228-210", "huang");
		spellPut("228-211", "xu");
		spellPut("228-212", "pen");
		spellPut("228-213", "jian");
		spellPut("228-214", "xuan");
		spellPut("228-215", "wo");
		spellPut("228-216", "mei");
		spellPut("228-217", "yan");
		spellPut("228-218", "zhen,qin");
		spellPut("228-219", "ke");
		spellPut("228-220", "she");
		spellPut("228-221", "mang");
		spellPut("228-222", "ying");
		spellPut("228-223", "pu");
		spellPut("228-224", "li");
		spellPut("228-225", "ru");
		spellPut("228-226", "ta");
		spellPut("228-227", "hun");
		spellPut("228-228", "bi");
		spellPut("228-229", "xiu");
		spellPut("228-230", "fu");
		spellPut("228-231", "tang");
		spellPut("228-232", "pang");
		spellPut("228-233", "ming");
		spellPut("228-234", "huang,guang");
		spellPut("228-235", "ying");
		spellPut("228-236", "xiao");
		spellPut("228-237", "lan");
		spellPut("228-238", "cao");
		spellPut("228-239", "hu");
		spellPut("228-240", "luo,ta");
		spellPut("228-241", "huan");
		spellPut("228-242", "lian");
		spellPut("228-243", "zhu");
		spellPut("228-244", "yi");
		spellPut("228-245", "lu");
		spellPut("228-246", "xuan");
		spellPut("228-247", "gan");
		spellPut("228-248", "shu,zhu");
		spellPut("228-249", "si");
		spellPut("228-250", "shan");
		spellPut("228-251", "shao");
		spellPut("228-252", "tong");
		spellPut("228-253", "chan");
		spellPut("228-254", "lai");
	}

	private static void init91() {
		spellPut("229-64", "zui");
		spellPut("229-65", "peng");
		spellPut("229-66", "an");
		spellPut("229-67", "pi");
		spellPut("229-68", "xian");
		spellPut("229-69", "ya");
		spellPut("229-70", "zhui");
		spellPut("229-71", "lei");
		spellPut("229-72", "a");
		spellPut("229-73", "kong");
		spellPut("229-74", "ta");
		spellPut("229-75", "kun");
		spellPut("229-76", "du");
		spellPut("229-77", "nei");
		spellPut("229-78", "chui");
		spellPut("229-79", "zi");
		spellPut("229-80", "zheng");
		spellPut("229-81", "ben");
		spellPut("229-82", "nie");
		spellPut("229-83", "cong");
		spellPut("229-84", "chun");
		spellPut("229-85", "tan");
		spellPut("229-86", "ding");
		spellPut("229-87", "qi");
		spellPut("229-88", "qian");
		spellPut("229-89", "zhui");
		spellPut("229-90", "ji");
		spellPut("229-91", "yu");
		spellPut("229-92", "jin");
		spellPut("229-93", "guan");
		spellPut("229-94", "mao");
		spellPut("229-95", "chang");
		spellPut("229-96", "tian");
		spellPut("229-97", "xi");
		spellPut("229-98", "lian");
		spellPut("229-99", "diao");
		spellPut("229-100", "gu");
		spellPut("229-101", "cuo");
		spellPut("229-102", "shu");
		spellPut("229-103", "zhen");
		spellPut("229-104", "lu");
		spellPut("229-105", "meng");
		spellPut("229-106", "lu");
		spellPut("229-107", "hua");
		spellPut("229-108", "biao");
		spellPut("229-109", "ga");
		spellPut("229-110", "lai");
		spellPut("229-111", "ken");
		spellPut("229-112", "ka za li");
		spellPut("229-113", "bu");
		spellPut("229-114", "nai");
		spellPut("229-115", "wan");
		spellPut("229-116", "hu");
		spellPut("229-117", "de");
		spellPut("229-118", "xian");
		spellPut("229-119", "uu");
		spellPut("229-120", "huo");
		spellPut("229-121", "liang");
		spellPut("229-122", "fB");
		spellPut("229-123", "men");
		spellPut("229-124", "kai");
		spellPut("229-125", "yang");
		spellPut("229-126", "chi");
		spellPut("229-128", "lian");
		spellPut("229-129", "guo");
		spellPut("229-130", "xian");
		spellPut("229-131", "du");
		spellPut("229-132", "tu");
		spellPut("229-133", "wei");
		spellPut("229-134", "zong");
		spellPut("229-135", "fu");
		spellPut("229-136", "rou");
		spellPut("229-137", "ji");
		spellPut("229-138", "e");
		spellPut("229-139", "jun");
		spellPut("229-140", "chen");
		spellPut("229-141", "ti");
		spellPut("229-142", "zha");
		spellPut("229-143", "hu");
		spellPut("229-144", "yang");
		spellPut("229-145", "duan");
		spellPut("229-146", "xia");
		spellPut("229-147", "yu");
		spellPut("229-148", "keng");
		spellPut("229-149", "sheng");
		spellPut("229-150", "huang");
		spellPut("229-151", "wei");
		spellPut("229-152", "fu");
		spellPut("229-153", "zhao");
		spellPut("229-154", "cha");
		spellPut("229-155", "qie");
		spellPut("229-156", "shi");
		spellPut("229-157", "hong");
		spellPut("229-158", "kui");
		spellPut("229-159", "nuo");
		spellPut("229-160", "qiao");
		spellPut("229-161", "sui");
		spellPut("229-162", "li");
		spellPut("229-163", "dan,tan");
		spellPut("229-164", "chan");
		spellPut("229-165", "lian");
		spellPut("229-166", "ru");
		spellPut("229-167", "pu");
		spellPut("229-168", "bi,pi");
		spellPut("229-169", "hao");
		spellPut("229-170", "zhuo,zhao");
		spellPut("229-171", "han");
		spellPut("229-172", "xie");
		spellPut("229-173", "ying");
		spellPut("229-174", "yue");
		spellPut("229-175", "fen");
		spellPut("229-176", "hao");
		spellPut("229-177", "ba");
		spellPut("229-178", "mian");
		spellPut("229-179", "gui");
		spellPut("229-180", "dang");
		spellPut("229-181", "mi,fu");
		spellPut("229-182", "you");
		spellPut("229-183", "chen");
		spellPut("229-184", "ning");
		spellPut("229-185", "qian");
		spellPut("229-186", "qian");
		spellPut("229-187", "wu");
		spellPut("229-188", "liao");
		spellPut("229-189", "qian");
		spellPut("229-190", "huan");
		spellPut("229-191", "jian");
		spellPut("229-192", "jian");
		spellPut("229-193", "chuo");
		spellPut("229-194", "ya");
		spellPut("229-195", "wu");
		spellPut("229-196", "jiong");
		spellPut("229-197", "ze");
		spellPut("229-198", "yi");
		spellPut("229-199", "er");
		spellPut("229-200", "jia");
		spellPut("229-201", "jing");
		spellPut("229-202", "dai");
		spellPut("229-203", "hou");
		spellPut("229-204", "pang");
		spellPut("229-205", "bu");
		spellPut("229-206", "li");
		spellPut("229-207", "qiu");
		spellPut("229-208", "xiao");
		spellPut("229-209", "ti");
		spellPut("229-210", "qun");
		spellPut("229-211", "kui");
		spellPut("229-212", "wei");
		spellPut("229-213", "huan");
		spellPut("229-214", "lu");
		spellPut("229-215", "chuan");
		spellPut("229-216", "huang");
		spellPut("229-217", "qiu");
		spellPut("229-218", "xia");
		spellPut("229-219", "ao");
		spellPut("229-220", "gou");
		spellPut("229-221", "ta");
		spellPut("229-222", "liu");
		spellPut("229-223", "xian");
		spellPut("229-224", "lin");
		spellPut("229-225", "ju");
		spellPut("229-226", "xie");
		spellPut("229-227", "miao");
		spellPut("229-228", "sui");
		spellPut("229-229", "la");
		spellPut("229-230", "xue");
		spellPut("229-231", "hui");
		spellPut("229-232", "tuan");
		spellPut("229-233", "zhi");
		spellPut("229-234", "kao");
		spellPut("229-235", "zhi");
		spellPut("229-236", "ji");
		spellPut("229-237", "e");
		spellPut("229-238", "chan,can");
		spellPut("229-239", "xi");
		spellPut("229-240", "ju");
		spellPut("229-241", "chan");
		spellPut("229-242", "jing");
		spellPut("229-243", "nu");
		spellPut("229-244", "mi");
		spellPut("229-245", "fu");
		spellPut("229-246", "bi");
		spellPut("229-247", "yu");
		spellPut("229-248", "che,cao");
		spellPut("229-249", "shuo");
		spellPut("229-250", "fei,pei");
		spellPut("229-251", "yan");
		spellPut("229-252", "wu");
		spellPut("229-253", "yu");
		spellPut("229-254", "bi");
	}

	private static void init92() {
		spellPut("230-64", "qiao");
		spellPut("230-65", "hou");
		spellPut("230-66", "tou");
		spellPut("230-67", "cong");
		spellPut("230-68", "huan");
		spellPut("230-69", "ye");
		spellPut("230-70", "min");
		spellPut("230-71", "jian");
		spellPut("230-72", "duan");
		spellPut("230-73", "jian");
		spellPut("230-74", "si");
		spellPut("230-75", "kui");
		spellPut("230-76", "hu");
		spellPut("230-77", "xuan");
		spellPut("230-78", "zhe");
		spellPut("230-79", "jie");
		spellPut("230-80", "zhen");
		spellPut("230-81", "bian");
		spellPut("230-82", "zhong");
		spellPut("230-83", "zi");
		spellPut("230-84", "xiu");
		spellPut("230-85", "ye");
		spellPut("230-86", "mei");
		spellPut("230-87", "pai");
		spellPut("230-88", "ai");
		spellPut("230-89", "jie");
		spellPut("230-90", "qiBn");
		spellPut("230-91", "mei");
		spellPut("230-92", "cuo,cha");
		spellPut("230-93", "da,ta");
		spellPut("230-94", "bang");
		spellPut("230-95", "xia");
		spellPut("230-96", "lian");
		spellPut("230-97", "suo,se");
		spellPut("230-98", "kai");
		spellPut("230-99", "yao,zu");
		spellPut("230-100", "ye,ta,ge");
		spellPut("230-101", "nou");
		spellPut("230-102", "weng");
		spellPut("230-103", "rong");
		spellPut("230-104", "tang");
		spellPut("230-105", "suo");
		spellPut("230-106", "qiang,cheng");
		spellPut("230-107", "ge,li");
		spellPut("230-108", "shuo");
		spellPut("230-109", "chui");
		spellPut("230-110", "bo");
		spellPut("230-111", "pan");
		spellPut("230-112", "da");
		spellPut("230-113", "bi,pi");
		spellPut("230-114", "sang");
		spellPut("230-115", "gang");
		spellPut("230-116", "zi");
		spellPut("230-117", "wu");
		spellPut("230-118", "ying");
		spellPut("230-119", "huang");
		spellPut("230-120", "tiao");
		spellPut("230-121", "liu");
		spellPut("230-122", "kai");
		spellPut("230-123", "sun");
		spellPut("230-124", "sha");
		spellPut("230-125", "sou");
		spellPut("230-126", "wan,jian");
		spellPut("230-128", "gao,hao");
		spellPut("230-129", "zhen");
		spellPut("230-130", "zhen");
		spellPut("230-131", "lang");
		spellPut("230-132", "yi");
		spellPut("230-133", "yuan");
		spellPut("230-134", "tang");
		spellPut("230-135", "nie");
		spellPut("230-136", "xi");
		spellPut("230-137", "jia");
		spellPut("230-138", "ge");
		spellPut("230-139", "ma");
		spellPut("230-140", "juan");
		spellPut("230-141", "ka su gai");
		spellPut("230-142", "ha ba ki");
		spellPut("230-143", "suo");
		spellPut("230-144", "xia");
		spellPut("230-145", "feng");
		spellPut("230-146", "wen");
		spellPut("230-147", "na");
		spellPut("230-148", "lu");
		spellPut("230-149", "suo");
		spellPut("230-150", "ou");
		spellPut("230-151", "zu,chuo");
		spellPut("230-152", "tuan");
		spellPut("230-153", "xiu");
		spellPut("230-154", "guan");
		spellPut("230-155", "xuan");
		spellPut("230-156", "lian");
		spellPut("230-157", "shou,sou");
		spellPut("230-158", "man");
		spellPut("230-159", "mo");
		spellPut("230-160", "luo");
		spellPut("230-161", "jin");
		spellPut("230-162", "zi");
		spellPut("230-163", "gui");
		spellPut("230-164", "niu");
		spellPut("230-165", "yu");
		spellPut("230-166", "si");
		spellPut("230-167", "da");
		spellPut("230-168", "zhou");
		spellPut("230-169", "shan");
		spellPut("230-170", "qie");
		spellPut("230-171", "ya");
		spellPut("230-172", "rao");
		spellPut("230-173", "shu");
		spellPut("230-174", "luan");
		spellPut("230-175", "jiao,xiao");
		spellPut("230-176", "pin");
		spellPut("230-177", "cha");
		spellPut("230-178", "li");
		spellPut("230-179", "ping");
		spellPut("230-180", "wa");
		spellPut("230-181", "xian");
		spellPut("230-182", "suo");
		spellPut("230-183", "di");
		spellPut("230-184", "wei");
		spellPut("230-185", "e");
		spellPut("230-186", "jing");
		spellPut("230-187", "biao");
		spellPut("230-188", "jie");
		spellPut("230-189", "chang");
		spellPut("230-190", "bi");
		spellPut("230-191", "chan");
		spellPut("230-192", "nu");
		spellPut("230-193", "ao,yun,wo");
		spellPut("230-194", "yuan");
		spellPut("230-195", "ting");
		spellPut("230-196", "wu");
		spellPut("230-197", "gou");
		spellPut("230-198", "mo");
		spellPut("230-199", "pi");
		spellPut("230-200", "ai");
		spellPut("230-201", "pin");
		spellPut("230-202", "chi");
		spellPut("230-203", "li");
		spellPut("230-204", "yan");
		spellPut("230-205", "qiang");
		spellPut("230-206", "piao");
		spellPut("230-207", "chang");
		spellPut("230-208", "lei");
		spellPut("230-209", "zhang");
		spellPut("230-210", "xi");
		spellPut("230-211", "shan");
		spellPut("230-212", "bi");
		spellPut("230-213", "niao");
		spellPut("230-214", "mo");
		spellPut("230-215", "shuang");
		spellPut("230-216", "ga");
		spellPut("230-217", "ga");
		spellPut("230-218", "fu");
		spellPut("230-219", "nu");
		spellPut("230-220", "zi");
		spellPut("230-221", "jie");
		spellPut("230-222", "jue");
		spellPut("230-223", "bao");
		spellPut("230-224", "zang");
		spellPut("230-225", "si");
		spellPut("230-226", "fu");
		spellPut("230-227", "zou");
		spellPut("230-228", "yi");
		spellPut("230-229", "nu");
		spellPut("230-230", "tai");
		spellPut("230-231", "xiao");
		spellPut("230-232", "hua");
		spellPut("230-233", "pian");
		spellPut("230-234", "li");
		spellPut("230-235", "qi");
		spellPut("230-236", "ke");
		spellPut("230-237", "zhui");
		spellPut("230-238", "can");
		spellPut("230-239", "zhi");
		spellPut("230-240", "wu");
		spellPut("230-241", "ao");
		spellPut("230-242", "liu");
		spellPut("230-243", "shan");
		spellPut("230-244", "piao,biao");
		spellPut("230-245", "cong");
		spellPut("230-246", "chan");
		spellPut("230-247", "ji");
		spellPut("230-248", "xiang");
		spellPut("230-249", "si");
		spellPut("230-250", "yu");
		spellPut("230-251", "zhou");
		spellPut("230-252", "he,ge");
		spellPut("230-253", "wan");
		spellPut("230-254", "kuang");
	}

	private static void init93() {
		spellPut("231-64", "bi");
		spellPut("231-65", "wei");
		spellPut("231-66", "liu");
		spellPut("231-67", "di");
		spellPut("231-68", "san,qiao,can");
		spellPut("231-69", "cong");
		spellPut("231-70", "yi");
		spellPut("231-71", "lu,ao");
		spellPut("231-72", "keng");
		spellPut("231-73", "qiang");
		spellPut("231-74", "cui");
		spellPut("231-75", "qi");
		spellPut("231-76", "shang");
		spellPut("231-77", "tang");
		spellPut("231-78", "man");
		spellPut("231-79", "yong");
		spellPut("231-80", "chan");
		spellPut("231-81", "feng");
		spellPut("231-82", "jing");
		spellPut("231-83", "biao");
		spellPut("231-84", "shu");
		spellPut("231-85", "lou");
		spellPut("231-86", "xiu");
		spellPut("231-87", "cong");
		spellPut("231-88", "long");
		spellPut("231-89", "zan");
		spellPut("231-90", "jian,zan");
		spellPut("231-91", "cao");
		spellPut("231-92", "li");
		spellPut("231-93", "xia");
		spellPut("231-94", "xi");
		spellPut("231-95", "kang");
		spellPut("231-96", "shuBng");
		spellPut("231-97", "beng");
		spellPut("231-98", "zhBng");
		spellPut("231-99", "qiBn");
		spellPut("231-100", "zheng");
		spellPut("231-101", "lu");
		spellPut("231-102", "hua");
		spellPut("231-103", "ji");
		spellPut("231-104", "pu");
		spellPut("231-105", "hui,sui,rui");
		spellPut("231-106", "qiang");
		spellPut("231-107", "po");
		spellPut("231-108", "lin");
		spellPut("231-109", "se");
		spellPut("231-110", "xiu");
		spellPut("231-111", "san,xian,sa");
		spellPut("231-112", "cheng");
		spellPut("231-113", "gui");
		spellPut("231-114", "si");
		spellPut("231-115", "liu");
		spellPut("231-116", "nao");
		spellPut("231-117", "huang");
		spellPut("231-118", "pie");
		spellPut("231-119", "sui");
		spellPut("231-120", "fan");
		spellPut("231-121", "qiao");
		spellPut("231-122", "quan");
		spellPut("231-123", "xi");
		spellPut("231-124", "tang");
		spellPut("231-125", "xiang");
		spellPut("231-126", "jue");
		spellPut("231-128", "jiao");
		spellPut("231-129", "zun");
		spellPut("231-130", "liao");
		spellPut("231-131", "qi");
		spellPut("231-132", "lao");
		spellPut("231-133", "dui");
		spellPut("231-134", "xin");
		spellPut("231-135", "zan");
		spellPut("231-136", "ji");
		spellPut("231-137", "jian");
		spellPut("231-138", "zhong");
		spellPut("231-139", "deng");
		spellPut("231-140", "ya");
		spellPut("231-141", "ying");
		spellPut("231-142", "dui");
		spellPut("231-143", "jue");
		spellPut("231-144", "nou");
		spellPut("231-145", "zan");
		spellPut("231-146", "pu");
		spellPut("231-147", "te te su");
		spellPut("231-148", "uu");
		spellPut("231-149", "cheng");
		spellPut("231-150", "ding");
		spellPut("231-151", "shan");
		spellPut("231-152", "kai");
		spellPut("231-153", "jian");
		spellPut("231-154", "fei");
		spellPut("231-155", "sui");
		spellPut("231-156", "lu");
		spellPut("231-157", "juan");
		spellPut("231-158", "hui");
		spellPut("231-159", "yu");
		spellPut("231-160", "lian");
		spellPut("231-161", "yun");
		spellPut("231-162", "pi,bi");
		spellPut("231-163", "shu");
		spellPut("231-164", "gan");
		spellPut("231-165", "xie");
		spellPut("231-166", "fu");
		spellPut("231-167", "zhou");
		spellPut("231-168", "fu");
		spellPut("231-169", "chu");
		spellPut("231-170", "dai");
		spellPut("231-171", "ku");
		spellPut("231-172", "hang");
		spellPut("231-173", "jiang");
		spellPut("231-174", "geng");
		spellPut("231-175", "xiao");
		spellPut("231-176", "ti");
		spellPut("231-177", "ling");
		spellPut("231-178", "qi");
		spellPut("231-179", "fei");
		spellPut("231-180", "shang");
		spellPut("231-181", "gun");
		spellPut("231-182", "duo");
		spellPut("231-183", "shou");
		spellPut("231-184", "liu");
		spellPut("231-185", "quan");
		spellPut("231-186", "wan");
		spellPut("231-187", "zi");
		spellPut("231-188", "ke");
		spellPut("231-189", "xiang");
		spellPut("231-190", "ti");
		spellPut("231-191", "miao");
		spellPut("231-192", "hui");
		spellPut("231-193", "si");
		spellPut("231-194", "bian,pian");
		spellPut("231-195", "gou");
		spellPut("231-196", "zhui");
		spellPut("231-197", "min");
		spellPut("231-198", "jin");
		spellPut("231-199", "zhen");
		spellPut("231-200", "ru");
		spellPut("231-201", "gao");
		spellPut("231-202", "li");
		spellPut("231-203", "yi");
		spellPut("231-204", "jian");
		spellPut("231-205", "bin");
		spellPut("231-206", "piao");
		spellPut("231-207", "man");
		spellPut("231-208", "lei");
		spellPut("231-209", "mou,miu,miao,mu,liao");
		spellPut("231-210", "sao");
		spellPut("231-211", "xie");
		spellPut("231-212", "liao");
		spellPut("231-213", "zeng");
		spellPut("231-214", "jiang");
		spellPut("231-215", "qian");
		spellPut("231-216", "qiao,sao");
		spellPut("231-217", "huan");
		spellPut("231-218", "zuan");
		spellPut("231-219", "yao");
		spellPut("231-220", "ji");
		spellPut("231-221", "chuan");
		spellPut("231-222", "zai,zi");
		spellPut("231-223", "yong");
		spellPut("231-224", "ding");
		spellPut("231-225", "ji");
		spellPut("231-226", "wei");
		spellPut("231-227", "bin,fen");
		spellPut("231-228", "min,wen");
		spellPut("231-229", "jue");
		spellPut("231-230", "ke");
		spellPut("231-231", "long");
		spellPut("231-232", "dian");
		spellPut("231-233", "dai");
		spellPut("231-234", "po");
		spellPut("231-235", "min");
		spellPut("231-236", "jia");
		spellPut("231-237", "er");
		spellPut("231-238", "gong");
		spellPut("231-239", "xu");
		spellPut("231-240", "ya");
		spellPut("231-241", "heng");
		spellPut("231-242", "yao");
		spellPut("231-243", "luo");
		spellPut("231-244", "xi");
		spellPut("231-245", "hun,hui");
		spellPut("231-246", "lian");
		spellPut("231-247", "qi");
		spellPut("231-248", "ying");
		spellPut("231-249", "qi");
		spellPut("231-250", "hu");
		spellPut("231-251", "kun");
		spellPut("231-252", "yan");
		spellPut("231-253", "cong");
		spellPut("231-254", "wan");
	}

	private static void init94() {
		spellPut("232-64", "zhuo");
		spellPut("232-65", "qiao");
		spellPut("232-66", "jian");
		spellPut("232-67", "zhuo");
		spellPut("232-68", "lei");
		spellPut("232-69", "bi");
		spellPut("232-70", "tie");
		spellPut("232-71", "huan");
		spellPut("232-72", "ye");
		spellPut("232-73", "duo");
		spellPut("232-74", "guo");
		spellPut("232-75", "dang");
		spellPut("232-76", "ju");
		spellPut("232-77", "fen");
		spellPut("232-78", "da");
		spellPut("232-79", "yi");
		spellPut("232-80", "ai");
		spellPut("232-81", "zong");
		spellPut("232-82", "xun");
		spellPut("232-83", "diao");
		spellPut("232-84", "zhu");
		spellPut("232-85", "heng");
		spellPut("232-86", "zhui");
		spellPut("232-87", "ji");
		spellPut("232-88", "nie");
		spellPut("232-89", "he");
		spellPut("232-90", "huo");
		spellPut("232-91", "qing");
		spellPut("232-92", "bin");
		spellPut("232-93", "ying");
		spellPut("232-94", "gui");
		spellPut("232-95", "ning");
		spellPut("232-96", "xu");
		spellPut("232-97", "jian");
		spellPut("232-98", "jian");
		spellPut("232-99", "ya ri");
		spellPut("232-100", "cha");
		spellPut("232-101", "zhi");
		spellPut("232-102", "mie");
		spellPut("232-103", "li");
		spellPut("232-104", "lei");
		spellPut("232-105", "ji");
		spellPut("232-106", "zuan");
		spellPut("232-107", "kuang");
		spellPut("232-108", "shang");
		spellPut("232-109", "peng");
		spellPut("232-110", "la");
		spellPut("232-111", "du");
		spellPut("232-112", "shuo");
		spellPut("232-113", "chuo");
		spellPut("232-114", "lv");
		spellPut("232-115", "biao");
		spellPut("232-116", "bao");
		spellPut("232-117", "lu");
		spellPut("232-118", "xiBn");
		spellPut("232-119", "kuBn");
		spellPut("232-120", "long");
		spellPut("232-121", "e");
		spellPut("232-122", "lu");
		spellPut("232-123", "jian");
		spellPut("232-124", "lan");
		spellPut("232-125", "bo");
		spellPut("232-126", "jian");
		spellPut("232-128", "yue");
		spellPut("232-129", "chan");
		spellPut("232-130", "xiang");
		spellPut("232-131", "jian");
		spellPut("232-132", "xi");
		spellPut("232-133", "guan");
		spellPut("232-134", "cang");
		spellPut("232-135", "nie");
		spellPut("232-136", "lei");
		spellPut("232-137", "cuan");
		spellPut("232-138", "qu");
		spellPut("232-139", "pan");
		spellPut("232-140", "luo");
		spellPut("232-141", "zuan");
		spellPut("232-142", "luan");
		spellPut("232-143", "zao");
		spellPut("232-144", "nie");
		spellPut("232-145", "jue");
		spellPut("232-146", "tang");
		spellPut("232-147", "zhu");
		spellPut("232-148", "lan");
		spellPut("232-149", "sa,xi");
		spellPut("232-150", "yang");
		spellPut("232-151", "xing");
		spellPut("232-152", "bao");
		spellPut("232-153", "xing");
		spellPut("232-154", "mang");
		spellPut("232-155", "ya");
		spellPut("232-156", "zhi");
		spellPut("232-157", "xian,kuo,tian,gua");
		spellPut("232-158", "wu");
		spellPut("232-159", "qi");
		spellPut("232-160", "chang");
		spellPut("232-161", "chen");
		spellPut("232-162", "ju");
		spellPut("232-163", "mao");
		spellPut("232-164", "yu");
		spellPut("232-165", "yuan");
		spellPut("232-166", "xia");
		spellPut("232-167", "nao");
		spellPut("232-168", "ai");
		spellPut("232-169", "tang");
		spellPut("232-170", "jin");
		spellPut("232-171", "huang");
		spellPut("232-172", "ying");
		spellPut("232-173", "cui");
		spellPut("232-174", "cong");
		spellPut("232-175", "xuan");
		spellPut("232-176", "zhang");
		spellPut("232-177", "pu");
		spellPut("232-178", "can");
		spellPut("232-179", "qu");
		spellPut("232-180", "lu");
		spellPut("232-181", "bi");
		spellPut("232-182", "zan");
		spellPut("232-183", "wen");
		spellPut("232-184", "wei");
		spellPut("232-185", "yun,wen");
		spellPut("232-186", "tao");
		spellPut("232-187", "wu");
		spellPut("232-188", "shao,biao");
		spellPut("232-189", "qi");
		spellPut("232-190", "cha");
		spellPut("232-191", "ma");
		spellPut("232-192", "li");
		spellPut("232-193", "pi");
		spellPut("232-194", "miao");
		spellPut("232-195", "yao");
		spellPut("232-196", "rui");
		spellPut("232-197", "jian");
		spellPut("232-198", "chu");
		spellPut("232-199", "cheng");
		spellPut("232-200", "cong,zong");
		spellPut("232-201", "xiao");
		spellPut("232-202", "fang,bing");
		spellPut("232-203", "pa");
		spellPut("232-204", "zhu");
		spellPut("232-205", "nai");
		spellPut("232-206", "zhi");
		spellPut("232-207", "zhe");
		spellPut("232-208", "long");
		spellPut("232-209", "jiu");
		spellPut("232-210", "ping");
		spellPut("232-211", "lu");
		spellPut("232-212", "xia");
		spellPut("232-213", "xiao");
		spellPut("232-214", "you");
		spellPut("232-215", "zhi");
		spellPut("232-216", "tuo");
		spellPut("232-217", "zhi");
		spellPut("232-218", "ling");
		spellPut("232-219", "ju,gou");
		spellPut("232-220", "di");
		spellPut("232-221", "li,yue");
		spellPut("232-222", "tuo,duo");
		spellPut("232-223", "cheng");
		spellPut("232-224", "kao");
		spellPut("232-225", "lao");
		spellPut("232-226", "ya");
		spellPut("232-227", "rao,nao");
		spellPut("232-228", "zhi");
		spellPut("232-229", "zhen");
		spellPut("232-230", "guang");
		spellPut("232-231", "qi");
		spellPut("232-232", "ting");
		spellPut("232-233", "gua,tian");
		spellPut("232-234", "jiu");
		spellPut("232-235", "hua");
		spellPut("232-236", "heng,hang");
		spellPut("232-237", "gui,hui");
		spellPut("232-238", "jie");
		spellPut("232-239", "luan");
		spellPut("232-240", "juan");
		spellPut("232-241", "an");
		spellPut("232-242", "xu");
		spellPut("232-243", "fan");
		spellPut("232-244", "gu");
		spellPut("232-245", "fu");
		spellPut("232-246", "jue");
		spellPut("232-247", "zi");
		spellPut("232-248", "suo");
		spellPut("232-249", "ling");
		spellPut("232-250", "chu");
		spellPut("232-251", "fen");
		spellPut("232-252", "du");
		spellPut("232-253", "qian");
		spellPut("232-254", "zhao,zhuo");
	}

	private static void init95() {
		spellPut("233-64", "zhi");
		spellPut("233-65", "yang");
		spellPut("233-66", "huang");
		spellPut("233-67", "zi");
		spellPut("233-68", "bo");
		spellPut("233-69", "tang");
		spellPut("233-70", "rong");
		spellPut("233-71", "beng");
		spellPut("233-72", "liu");
		spellPut("233-73", "huan");
		spellPut("233-74", "la");
		spellPut("233-75", "chan");
		spellPut("233-76", "chang");
		spellPut("233-77", "chang");
		spellPut("233-78", "jiu");
		spellPut("233-79", "ao");
		spellPut("233-80", "die");
		spellPut("233-81", "jie");
		spellPut("233-82", "liao");
		spellPut("233-83", "mi");
		spellPut("233-84", "men");
		spellPut("233-85", "ma");
		spellPut("233-86", "shuan");
		spellPut("233-87", "shan");
		spellPut("233-88", "huo,shan");
		spellPut("233-89", "men");
		spellPut("233-90", "yan");
		spellPut("233-91", "bi");
		spellPut("233-92", "han,bi");
		spellPut("233-93", "bi");
		spellPut("233-94", "ci ka Bi lu");
		spellPut("233-95", "kai");
		spellPut("233-96", "kang");
		spellPut("233-97", "beng");
		spellPut("233-98", "hong");
		spellPut("233-99", "run");
		spellPut("233-100", "san");
		spellPut("233-101", "xian");
		spellPut("233-102", "xian,jian");
		spellPut("233-103", "jian");
		spellPut("233-104", "min");
		spellPut("233-105", "xia");
		spellPut("233-106", "lao");
		spellPut("233-107", "dou");
		spellPut("233-108", "zha");
		spellPut("233-109", "nao");
		spellPut("233-110", "zhan");
		spellPut("233-111", "peng");
		spellPut("233-112", "xia,ke");
		spellPut("233-113", "ling");
		spellPut("233-114", "bian,guan");
		spellPut("233-115", "bi");
		spellPut("233-116", "run");
		spellPut("233-117", "he");
		spellPut("233-118", "guan");
		spellPut("233-119", "ge");
		spellPut("233-120", "he,ge");
		spellPut("233-121", "fa");
		spellPut("233-122", "chu");
		spellPut("233-123", "hong,xiang");
		spellPut("233-124", "gui");
		spellPut("233-125", "min");
		spellPut("233-126", "se");
		spellPut("233-128", "kun");
		spellPut("233-129", "lang");
		spellPut("233-130", "lv");
		spellPut("233-131", "ting");
		spellPut("233-132", "sha");
		spellPut("233-133", "ju");
		spellPut("233-134", "yue");
		spellPut("233-135", "yue");
		spellPut("233-136", "chan");
		spellPut("233-137", "qu");
		spellPut("233-138", "lin");
		spellPut("233-139", "chang");
		spellPut("233-140", "sha");
		spellPut("233-141", "kun");
		spellPut("233-142", "yan");
		spellPut("233-143", "wen");
		spellPut("233-144", "yan");
		spellPut("233-145", "e,yan");
		spellPut("233-146", "hun");
		spellPut("233-147", "yu");
		spellPut("233-148", "wen");
		spellPut("233-149", "hong");
		spellPut("233-150", "bao");
		spellPut("233-151", "hong,juan,xiang");
		spellPut("233-152", "qu");
		spellPut("233-153", "yao");
		spellPut("233-154", "wen");
		spellPut("233-155", "ban,pan");
		spellPut("233-156", "an");
		spellPut("233-157", "wei");
		spellPut("233-158", "yin");
		spellPut("233-159", "kuo");
		spellPut("233-160", "que");
		spellPut("233-161", "luo");
		spellPut("233-162", "chui");
		spellPut("233-163", "liang");
		spellPut("233-164", "guo");
		spellPut("233-165", "jian");
		spellPut("233-166", "di,dai,ti");
		spellPut("233-167", "ju");
		spellPut("233-168", "cou,zou");
		spellPut("233-169", "zhen,shen");
		spellPut("233-170", "nan");
		spellPut("233-171", "zha,cha");
		spellPut("233-172", "lian");
		spellPut("233-173", "lan");
		spellPut("233-174", "ji");
		spellPut("233-175", "pin");
		spellPut("233-176", "ju");
		spellPut("233-177", "qiu");
		spellPut("233-178", "duan");
		spellPut("233-179", "chui");
		spellPut("233-180", "chen");
		spellPut("233-181", "lv");
		spellPut("233-182", "cha");
		spellPut("233-183", "ju");
		spellPut("233-184", "xuan");
		spellPut("233-185", "mei");
		spellPut("233-186", "ying");
		spellPut("233-187", "zhen");
		spellPut("233-188", "fei");
		spellPut("233-189", "ta");
		spellPut("233-190", "sun");
		spellPut("233-191", "xie");
		spellPut("233-192", "gao");
		spellPut("233-193", "cui");
		spellPut("233-194", "gao");
		spellPut("233-195", "shuo");
		spellPut("233-196", "bin,bing");
		spellPut("233-197", "rong");
		spellPut("233-198", "zhu");
		spellPut("233-199", "xie");
		spellPut("233-200", "jin");
		spellPut("233-201", "qiang");
		spellPut("233-202", "qi,se");
		spellPut("233-203", "chu");
		spellPut("233-204", "tang");
		spellPut("233-205", "zhu");
		spellPut("233-206", "hu");
		spellPut("233-207", "gan");
		spellPut("233-208", "yue");
		spellPut("233-209", "qing");
		spellPut("233-210", "tuo");
		spellPut("233-211", "jue");
		spellPut("233-212", "qiao");
		spellPut("233-213", "qin");
		spellPut("233-214", "lu");
		spellPut("233-215", "zun");
		spellPut("233-216", "xi");
		spellPut("233-217", "ju");
		spellPut("233-218", "yuan");
		spellPut("233-219", "lei");
		spellPut("233-220", "yan");
		spellPut("233-221", "lin");
		spellPut("233-222", "bo");
		spellPut("233-223", "cha");
		spellPut("233-224", "you");
		spellPut("233-225", "ao");
		spellPut("233-226", "mo");
		spellPut("233-227", "cu");
		spellPut("233-228", "shang");
		spellPut("233-229", "tian");
		spellPut("233-230", "yun");
		spellPut("233-231", "lian");
		spellPut("233-232", "piao");
		spellPut("233-233", "dan");
		spellPut("233-234", "ji");
		spellPut("233-235", "bin");
		spellPut("233-236", "yi");
		spellPut("233-237", "ren");
		spellPut("233-238", "e");
		spellPut("233-239", "gu");
		spellPut("233-240", "ke");
		spellPut("233-241", "lu");
		spellPut("233-242", "zhi");
		spellPut("233-243", "yi");
		spellPut("233-244", "zhen");
		spellPut("233-245", "hu");
		spellPut("233-246", "li");
		spellPut("233-247", "yao");
		spellPut("233-248", "shi");
		spellPut("233-249", "zhi");
		spellPut("233-250", "quan");
		spellPut("233-251", "lu");
		spellPut("233-252", "zhe");
		spellPut("233-253", "nian");
		spellPut("233-254", "wang");
	}

	private static void init96() {
		spellPut("234-64", "lan");
		spellPut("234-65", "du,she");
		spellPut("234-66", "quBn");
		spellPut("234-67", "pBi ying,po he deng");
		spellPut("234-68", "tian");
		spellPut("234-69", "nie");
		spellPut("234-70", "ta");
		spellPut("234-71", "kai");
		spellPut("234-72", "he");
		spellPut("234-73", "que");
		spellPut("234-74", "chuang");
		spellPut("234-75", "guan");
		spellPut("234-76", "dou");
		spellPut("234-77", "qi");
		spellPut("234-78", "kui");
		spellPut("234-79", "tang,chang");
		spellPut("234-80", "guan");
		spellPut("234-81", "piao");
		spellPut("234-82", "kan,han");
		spellPut("234-83", "xi,se,ta");
		spellPut("234-84", "hui");
		spellPut("234-85", "chan");
		spellPut("234-86", "pi");
		spellPut("234-87", "dang");
		spellPut("234-88", "huan");
		spellPut("234-89", "ta");
		spellPut("234-90", "wen");
		spellPut("234-91", "uu");
		spellPut("234-92", "han,bi");
		spellPut("234-93", "kai");
		spellPut("234-94", "du");
		spellPut("234-95", "hui");
		spellPut("234-96", "ta");
		spellPut("234-97", "huan");
		spellPut("234-98", "le");
		spellPut("234-99", "xin");
		spellPut("234-100", "yi");
		spellPut("234-101", "tuo");
		spellPut("234-102", "yin");
		spellPut("234-103", "yang");
		spellPut("234-104", "dou");
		spellPut("234-105", "e");
		spellPut("234-106", "sheng");
		spellPut("234-107", "pei");
		spellPut("234-108", "keng");
		spellPut("234-109", "yun");
		spellPut("234-110", "zhi");
		spellPut("234-111", "pi");
		spellPut("234-112", "cheng");
		spellPut("234-113", "e");
		spellPut("234-114", "qu");
		spellPut("234-115", "di");
		spellPut("234-116", "lin");
		spellPut("234-117", "tuo");
		spellPut("234-118", "bing");
		spellPut("234-119", "duo");
		spellPut("234-120", "shu");
		spellPut("234-121", "duo");
		spellPut("234-122", "er");
		spellPut("234-123", "gui");
		spellPut("234-124", "yu");
		spellPut("234-125", "jun");
		spellPut("234-126", "qiao");
		spellPut("234-128", "xing");
		spellPut("234-129", "chun");
		spellPut("234-130", "wu");
		spellPut("234-131", "xia");
		spellPut("234-132", "shan");
		spellPut("234-133", "sheng");
		spellPut("234-134", "pu");
		spellPut("234-135", "zhen");
		spellPut("234-136", "xian");
		spellPut("234-137", "dao");
		spellPut("234-138", "fei");
		spellPut("234-139", "qi");
		spellPut("234-140", "dui");
		spellPut("234-141", "lun");
		spellPut("234-142", "yin");
		spellPut("234-143", "ju");
		spellPut("234-144", "chen");
		spellPut("234-145", "lu");
		spellPut("234-146", "sheng");
		spellPut("234-147", "xian");
		spellPut("234-148", "yin");
		spellPut("234-149", "zhu");
		spellPut("234-150", "yang");
		spellPut("234-151", "reng");
		spellPut("234-152", "xia");
		spellPut("234-153", "chong");
		spellPut("234-154", "yan");
		spellPut("234-155", "yin");
		spellPut("234-156", "yu,yao,shu");
		spellPut("234-157", "di");
		spellPut("234-158", "wei");
		spellPut("234-159", "nie");
		spellPut("234-160", "dui,zhui");
		spellPut("234-161", "chuo");
		spellPut("234-162", "zi");
		spellPut("234-163", "cou");
		spellPut("234-164", "lu");
		spellPut("234-165", "lin");
		spellPut("234-166", "wei");
		spellPut("234-167", "jian");
		spellPut("234-168", "qiang");
		spellPut("234-169", "jia");
		spellPut("234-170", "ji");
		spellPut("234-171", "ji");
		spellPut("234-172", "kan");
		spellPut("234-173", "deng");
		spellPut("234-174", "gai");
		spellPut("234-175", "jian");
		spellPut("234-176", "zang,cang");
		spellPut("234-177", "ou");
		spellPut("234-178", "ling");
		spellPut("234-179", "bu");
		spellPut("234-180", "beng");
		spellPut("234-181", "zeng");
		spellPut("234-182", "pi");
		spellPut("234-183", "pu");
		spellPut("234-184", "ga");
		spellPut("234-185", "la");
		spellPut("234-186", "gan,han");
		spellPut("234-187", "hao");
		spellPut("234-188", "tan");
		spellPut("234-189", "gao");
		spellPut("234-190", "ze");
		spellPut("234-191", "xin");
		spellPut("234-192", "yun");
		spellPut("234-193", "jiong,gui");
		spellPut("234-194", "he");
		spellPut("234-195", "zan");
		spellPut("234-196", "mao");
		spellPut("234-197", "yu");
		spellPut("234-198", "chang");
		spellPut("234-199", "ni");
		spellPut("234-200", "qi,shi");
		spellPut("234-201", "sheng,cheng");
		spellPut("234-202", "ye");
		spellPut("234-203", "chao");
		spellPut("234-204", "yan");
		spellPut("234-205", "hui");
		spellPut("234-206", "bu");
		spellPut("234-207", "han");
		spellPut("234-208", "gui");
		spellPut("234-209", "xuan");
		spellPut("234-210", "kui");
		spellPut("234-211", "ai");
		spellPut("234-212", "ming");
		spellPut("234-213", "tun");
		spellPut("234-214", "xun");
		spellPut("234-215", "yao");
		spellPut("234-216", "xi");
		spellPut("234-217", "nang");
		spellPut("234-218", "bi");
		spellPut("234-219", "shi");
		spellPut("234-220", "kuang");
		spellPut("234-221", "yi");
		spellPut("234-222", "zhi");
		spellPut("234-223", "zi");
		spellPut("234-224", "gai");
		spellPut("234-225", "jin");
		spellPut("234-226", "zhen");
		spellPut("234-227", "lai");
		spellPut("234-228", "qiu");
		spellPut("234-229", "ji");
		spellPut("234-230", "dan");
		spellPut("234-231", "fu");
		spellPut("234-232", "chan");
		spellPut("234-233", "ji");
		spellPut("234-234", "xi");
		spellPut("234-235", "di");
		spellPut("234-236", "yu");
		spellPut("234-237", "gou");
		spellPut("234-238", "jin");
		spellPut("234-239", "qu");
		spellPut("234-240", "jian");
		spellPut("234-241", "jiang");
		spellPut("234-242", "pin");
		spellPut("234-243", "mao");
		spellPut("234-244", "gu");
		spellPut("234-245", "wu");
		spellPut("234-246", "gu");
		spellPut("234-247", "ji");
		spellPut("234-248", "ju");
		spellPut("234-249", "jian,qian");
		spellPut("234-250", "pian");
		spellPut("234-251", "kao");
		spellPut("234-252", "qie");
		spellPut("234-253", "suo,sB,shB");
		spellPut("234-254", "bai");
	}

	private static void init97() {
		spellPut("235-64", "an");
		spellPut("235-65", "jie");
		spellPut("235-66", "qi,gai,ai");
		spellPut("235-67", "yan");
		spellPut("235-68", "hui,duo");
		spellPut("235-69", "yun");
		spellPut("235-70", "wu");
		spellPut("235-71", "tang");
		spellPut("235-72", "ji");
		spellPut("235-73", "dao");
		spellPut("235-74", "ao");
		spellPut("235-75", "xi");
		spellPut("235-76", "yin");
		spellPut("235-77", "sB");
		spellPut("235-78", "rao");
		spellPut("235-79", "lin");
		spellPut("235-80", "tui");
		spellPut("235-81", "deng");
		spellPut("235-82", "pi");
		spellPut("235-83", "sui");
		spellPut("235-84", "ao,yu");
		spellPut("235-85", "xian");
		spellPut("235-86", "fen");
		spellPut("235-87", "ni");
		spellPut("235-88", "er");
		spellPut("235-89", "ji");
		spellPut("235-90", "dao");
		spellPut("235-91", "yin");
		spellPut("235-92", "zhi");
		spellPut("235-93", "long");
		spellPut("235-94", "xi");
		spellPut("235-95", "li,dai");
		spellPut("235-96", "li,dai");
		spellPut("235-97", "hu,he");
		spellPut("235-98", "zhi");
		spellPut("235-99", "yi");
		spellPut("235-100", "qin");
		spellPut("235-101", "jian");
		spellPut("235-102", "huan");
		spellPut("235-103", "gou");
		spellPut("235-104", "jun,juan");
		spellPut("235-105", "hu");
		spellPut("235-106", "za");
		spellPut("235-107", "yu");
		spellPut("235-108", "chou");
		spellPut("235-109", "sui");
		spellPut("235-110", "han");
		spellPut("235-111", "huo");
		spellPut("235-112", "shuang");
		spellPut("235-113", "guan,huan");
		spellPut("235-114", "chu");
		spellPut("235-115", "za");
		spellPut("235-116", "yong");
		spellPut("235-117", "ji");
		spellPut("235-118", "gui,xi");
		spellPut("235-119", "liu");
		spellPut("235-120", "li");
		spellPut("235-121", "nan,nuo");
		spellPut("235-122", "yu");
		spellPut("235-123", "za");
		spellPut("235-124", "chou");
		spellPut("235-125", "ji");
		spellPut("235-126", "na");
		spellPut("235-128", "fou");
		spellPut("235-129", "se,xi");
		spellPut("235-130", "mu");
		spellPut("235-131", "fen");
		spellPut("235-132", "pang");
		spellPut("235-133", "yun");
		spellPut("235-134", "chi");
		spellPut("235-135", "yang");
		spellPut("235-136", "an");
		spellPut("235-137", "wu,meng");
		spellPut("235-138", "dian");
		spellPut("235-139", "dang");
		spellPut("235-140", "hu");
		spellPut("235-141", "diao");
		spellPut("235-142", "mu");
		spellPut("235-143", "chen");
		spellPut("235-144", "zha");
		spellPut("235-145", "ling");
		spellPut("235-146", "qi");
		spellPut("235-147", "zhou");
		spellPut("235-148", "hong");
		spellPut("235-149", "zhan");
		spellPut("235-150", "yin");
		spellPut("235-151", "shu");
		spellPut("235-152", "tun");
		spellPut("235-153", "ling");
		spellPut("235-154", "dong");
		spellPut("235-155", "ying");
		spellPut("235-156", "wu");
		spellPut("235-157", "ling");
		spellPut("235-158", "ling");
		spellPut("235-159", "hong");
		spellPut("235-160", "yin");
		spellPut("235-161", "ge");
		spellPut("235-162", "bo,bai");
		spellPut("235-163", "mao");
		spellPut("235-164", "mu");
		spellPut("235-165", "cui");
		spellPut("235-166", "jian");
		spellPut("235-167", "san");
		spellPut("235-168", "shu");
		spellPut("235-169", "chang");
		spellPut("235-170", "lu");
		spellPut("235-171", "pu");
		spellPut("235-172", "qu");
		spellPut("235-173", "pie");
		spellPut("235-174", "dao");
		spellPut("235-175", "xian");
		spellPut("235-176", "chuan");
		spellPut("235-177", "dong");
		spellPut("235-178", "ya");
		spellPut("235-179", "yin");
		spellPut("235-180", "ke");
		spellPut("235-181", "yun");
		spellPut("235-182", "pu");
		spellPut("235-183", "chi");
		spellPut("235-184", "jiao");
		spellPut("235-185", "du");
		spellPut("235-186", "die");
		spellPut("235-187", "you");
		spellPut("235-188", "yuan");
		spellPut("235-189", "guo");
		spellPut("235-190", "yue");
		spellPut("235-191", "wo");
		spellPut("235-192", "rong,chen");
		spellPut("235-193", "huang");
		spellPut("235-194", "jing");
		spellPut("235-195", "ruan");
		spellPut("235-196", "tai");
		spellPut("235-197", "gong");
		spellPut("235-198", "zhun,chun");
		spellPut("235-199", "na");
		spellPut("235-200", "yao");
		spellPut("235-201", "qian");
		spellPut("235-202", "long");
		spellPut("235-203", "dong");
		spellPut("235-204", "ka");
		spellPut("235-205", "lu");
		spellPut("235-206", "jia");
		spellPut("235-207", "shen");
		spellPut("235-208", "zhou");
		spellPut("235-209", "zuo");
		spellPut("235-210", "gua");
		spellPut("235-211", "zhen");
		spellPut("235-212", "qu,xu,chun");
		spellPut("235-213", "zhi");
		spellPut("235-214", "jing");
		spellPut("235-215", "guang");
		spellPut("235-216", "dong");
		spellPut("235-217", "yan");
		spellPut("235-218", "kuai");
		spellPut("235-219", "sa");
		spellPut("235-220", "hai");
		spellPut("235-221", "pian");
		spellPut("235-222", "zhen");
		spellPut("235-223", "mi");
		spellPut("235-224", "tun");
		spellPut("235-225", "luo");
		spellPut("235-226", "cuo");
		spellPut("235-227", "pao");
		spellPut("235-228", "wan");
		spellPut("235-229", "niao");
		spellPut("235-230", "jing");
		spellPut("235-231", "yan");
		spellPut("235-232", "fei");
		spellPut("235-233", "yu");
		spellPut("235-234", "zong");
		spellPut("235-235", "ding");
		spellPut("235-236", "jian");
		spellPut("235-237", "cou");
		spellPut("235-238", "nan");
		spellPut("235-239", "mian");
		spellPut("235-240", "wa");
		spellPut("235-241", "e");
		spellPut("235-242", "shu");
		spellPut("235-243", "cheng");
		spellPut("235-244", "ying");
		spellPut("235-245", "ge");
		spellPut("235-246", "lv");
		spellPut("235-247", "bin");
		spellPut("235-248", "teng");
		spellPut("235-249", "zhi");
		spellPut("235-250", "chuai");
		spellPut("235-251", "gu");
		spellPut("235-252", "meng");
		spellPut("235-253", "sao");
		spellPut("235-254", "shan,dan");
	}

	private static void init98() {
		spellPut("236-64", "mai");
		spellPut("236-65", "mai");
		spellPut("236-66", "yun");
		spellPut("236-67", "liu");
		spellPut("236-68", "meng");
		spellPut("236-69", "bin");
		spellPut("236-70", "wu");
		spellPut("236-71", "wei");
		spellPut("236-72", "kuo");
		spellPut("236-73", "xi");
		spellPut("236-74", "yi");
		spellPut("236-75", "dan");
		spellPut("236-76", "teng");
		spellPut("236-77", "yu");
		spellPut("236-78", "long");
		spellPut("236-79", "dai");
		spellPut("236-80", "ji");
		spellPut("236-81", "pang");
		spellPut("236-82", "yang");
		spellPut("236-83", "wei");
		spellPut("236-84", "uu");
		spellPut("236-85", "xi");
		spellPut("236-86", "ji");
		spellPut("236-87", "meng");
		spellPut("236-88", "meng");
		spellPut("236-89", "lei");
		spellPut("236-90", "li");
		spellPut("236-91", "huo");
		spellPut("236-92", "ai");
		spellPut("236-93", "fei");
		spellPut("236-94", "dai");
		spellPut("236-95", "long");
		spellPut("236-96", "ling");
		spellPut("236-97", "ai");
		spellPut("236-98", "feng");
		spellPut("236-99", "li");
		spellPut("236-100", "bao");
		spellPut("236-101", "he");
		spellPut("236-102", "he");
		spellPut("236-103", "he");
		spellPut("236-104", "bing");
		spellPut("236-105", "qing");
		spellPut("236-106", "tian");
		spellPut("236-107", "zheng");
		spellPut("236-108", "cheng");
		spellPut("236-109", "qing");
		spellPut("236-110", "jing");
		spellPut("236-111", "jing");
		spellPut("236-112", "tian");
		spellPut("236-113", "fei");
		spellPut("236-114", "mian");
		spellPut("236-115", "pao");
		spellPut("236-116", "mian");
		spellPut("236-117", "hui");
		spellPut("236-118", "ye");
		spellPut("236-119", "ding");
		spellPut("236-120", "cha");
		spellPut("236-121", "jian");
		spellPut("236-122", "ren");
		spellPut("236-123", "di");
		spellPut("236-124", "du");
		spellPut("236-125", "wu");
		spellPut("236-126", "ren");
		spellPut("236-128", "qin");
		spellPut("236-129", "niu");
		spellPut("236-130", "yin");
		spellPut("236-131", "sa");
		spellPut("236-132", "na");
		spellPut("236-133", "mo");
		spellPut("236-134", "zu");
		spellPut("236-135", "ban");
		spellPut("236-136", "xie");
		spellPut("236-137", "yao");
		spellPut("236-138", "tao");
		spellPut("236-139", "bei");
		spellPut("236-140", "jie");
		spellPut("236-141", "hong");
		spellPut("236-142", "pao");
		spellPut("236-143", "bing");
		spellPut("236-144", "yin");
		spellPut("236-145", "ge,ta,sa");
		spellPut("236-146", "tao");
		spellPut("236-147", "jie,ji");
		spellPut("236-148", "an");
		spellPut("236-149", "hen");
		spellPut("236-150", "gong");
		spellPut("236-151", "ko ha zei");
		spellPut("236-152", "ting");
		spellPut("236-153", "bian,ying");
		spellPut("236-154", "sui");
		spellPut("236-155", "tiao");
		spellPut("236-156", "xuan,juan");
		spellPut("236-157", "kong");
		spellPut("236-158", "beng");
		spellPut("236-159", "ta");
		spellPut("236-160", "shang,zhang");
		spellPut("236-161", "lian");
		spellPut("236-162", "lin");
		spellPut("236-163", "yu");
		spellPut("236-164", "xi");
		spellPut("236-165", "qi");
		spellPut("236-166", "sha");
		spellPut("236-167", "xin");
		spellPut("236-168", "xi,she");
		spellPut("236-169", "biao");
		spellPut("236-170", "sa");
		spellPut("236-171", "ju");
		spellPut("236-172", "sou");
		spellPut("236-173", "biao");
		spellPut("236-174", "biao");
		spellPut("236-175", "shu");
		spellPut("236-176", "gou");
		spellPut("236-177", "gu");
		spellPut("236-178", "hu");
		spellPut("236-179", "fei");
		spellPut("236-180", "ji");
		spellPut("236-181", "lan");
		spellPut("236-182", "yu,wu");
		spellPut("236-183", "pei");
		spellPut("236-184", "mao");
		spellPut("236-185", "zhan");
		spellPut("236-186", "jing");
		spellPut("236-187", "ni");
		spellPut("236-188", "liu");
		spellPut("236-189", "yi");
		spellPut("236-190", "yang");
		spellPut("236-191", "wei");
		spellPut("236-192", "dun");
		spellPut("236-193", "qiang");
		spellPut("236-194", "shi");
		spellPut("236-195", "hu");
		spellPut("236-196", "zhu");
		spellPut("236-197", "xuan");
		spellPut("236-198", "tai");
		spellPut("236-199", "ye");
		spellPut("236-200", "yang");
		spellPut("236-201", "wu");
		spellPut("236-202", "han");
		spellPut("236-203", "men");
		spellPut("236-204", "zhuo,chao");
		spellPut("236-205", "yan");
		spellPut("236-206", "hu");
		spellPut("236-207", "yu");
		spellPut("236-208", "wei");
		spellPut("236-209", "duan");
		spellPut("236-210", "bao");
		spellPut("236-211", "xuan");
		spellPut("236-212", "bian");
		spellPut("236-213", "tui");
		spellPut("236-214", "liu");
		spellPut("236-215", "man");
		spellPut("236-216", "shang");
		spellPut("236-217", "yun,yu");
		spellPut("236-218", "yi");
		spellPut("236-219", "yu");
		spellPut("236-220", "fan");
		spellPut("236-221", "sui");
		spellPut("236-222", "xian");
		spellPut("236-223", "jue");
		spellPut("236-224", "cuan");
		spellPut("236-225", "huo,biao");
		spellPut("236-226", "dao");
		spellPut("236-227", "xu");
		spellPut("236-228", "xi");
		spellPut("236-229", "li");
		spellPut("236-230", "hu");
		spellPut("236-231", "jiong");
		spellPut("236-232", "hu");
		spellPut("236-233", "fei");
		spellPut("236-234", "shi");
		spellPut("236-235", "si");
		spellPut("236-236", "xian");
		spellPut("236-237", "zhi");
		spellPut("236-238", "qu");
		spellPut("236-239", "hu");
		spellPut("236-240", "fu");
		spellPut("236-241", "zuo");
		spellPut("236-242", "mi");
		spellPut("236-243", "zhi");
		spellPut("236-244", "ci");
		spellPut("236-245", "zhen");
		spellPut("236-246", "tiao");
		spellPut("236-247", "qi");
		spellPut("236-248", "chan,shan");
		spellPut("236-249", "xi");
		spellPut("236-250", "zhuo");
		spellPut("236-251", "xi");
		spellPut("236-252", "rang");
		spellPut("236-253", "te");
		spellPut("236-254", "tan");
	}

	private static void init99() {
		spellPut("237-64", "bing,pi,bi,bei");
		spellPut("237-65", "kuo");
		spellPut("237-66", "lB");
		spellPut("237-67", "xie,die");
		spellPut("237-68", "bang");
		spellPut("237-69", "eng");
		spellPut("237-70", "qiu");
		spellPut("237-71", "qiu");
		spellPut("237-72", "he");
		spellPut("237-73", "qiao");
		spellPut("237-74", "mu,mou");
		spellPut("237-75", "jian");
		spellPut("237-76", "di");
		spellPut("237-77", "wen,yun");
		spellPut("237-78", "tao");
		spellPut("237-79", "ta");
		spellPut("237-80", "xie");
		spellPut("237-81", "pan");
		spellPut("237-82", "ge");
		spellPut("237-83", "bi,bing");
		spellPut("237-84", "kuo");
		spellPut("237-85", "tang");
		spellPut("237-86", "lou");
		spellPut("237-87", "gui");
		spellPut("237-88", "qiao");
		spellPut("237-89", "xue");
		spellPut("237-90", "ji");
		spellPut("237-91", "jian");
		spellPut("237-92", "jiang");
		spellPut("237-93", "chan");
		spellPut("237-94", "da");
		spellPut("237-95", "huo");
		spellPut("237-96", "xian");
		spellPut("237-97", "qian");
		spellPut("237-98", "du");
		spellPut("237-99", "wa");
		spellPut("237-100", "jian");
		spellPut("237-101", "lan");
		spellPut("237-102", "wei");
		spellPut("237-103", "ren");
		spellPut("237-104", "fu");
		spellPut("237-105", "mei,wa");
		spellPut("237-106", "quan");
		spellPut("237-107", "ge");
		spellPut("237-108", "wei");
		spellPut("237-109", "qiao");
		spellPut("237-110", "han");
		spellPut("237-111", "chang");
		spellPut("237-112", "kuo");
		spellPut("237-113", "rou");
		spellPut("237-114", "yun");
		spellPut("237-115", "she,xie");
		spellPut("237-116", "wei");
		spellPut("237-117", "ge");
		spellPut("237-118", "bai");
		spellPut("237-119", "tao");
		spellPut("237-120", "gou");
		spellPut("237-121", "yun");
		spellPut("237-122", "gao");
		spellPut("237-123", "bi");
		spellPut("237-124", "wei");
		spellPut("237-125", "sui");
		spellPut("237-126", "du");
		spellPut("237-128", "wa");
		spellPut("237-129", "du");
		spellPut("237-130", "fu");
		spellPut("237-131", "jiu");
		spellPut("237-132", "xian");
		spellPut("237-133", "xie");
		spellPut("237-134", "xian");
		spellPut("237-135", "ji");
		spellPut("237-136", "za");
		spellPut("237-137", "le");
		spellPut("237-138", "peng");
		spellPut("237-139", "huang");
		spellPut("237-140", "ying");
		spellPut("237-141", "yun");
		spellPut("237-142", "peng");
		spellPut("237-143", "an");
		spellPut("237-144", "yin");
		spellPut("237-145", "xiang");
		spellPut("237-146", "hu");
		spellPut("237-147", "ye");
		spellPut("237-148", "ding");
		spellPut("237-149", "qing");
		spellPut("237-150", "qiu");
		spellPut("237-151", "xiang");
		spellPut("237-152", "shun");
		spellPut("237-153", "han");
		spellPut("237-154", "xu");
		spellPut("237-155", "yi");
		spellPut("237-156", "xu");
		spellPut("237-157", "e");
		spellPut("237-158", "song");
		spellPut("237-159", "kui");
		spellPut("237-160", "qi");
		spellPut("237-161", "dui");
		spellPut("237-162", "jia");
		spellPut("237-163", "hui");
		spellPut("237-164", "nv");
		spellPut("237-165", "nen,nin");
		spellPut("237-166", "yang");
		spellPut("237-167", "zi");
		spellPut("237-168", "que");
		spellPut("237-169", "qian");
		spellPut("237-170", "min");
		spellPut("237-171", "te");
		spellPut("237-172", "qi");
		spellPut("237-173", "dui");
		spellPut("237-174", "mao");
		spellPut("237-175", "men");
		spellPut("237-176", "gang,zhuang");
		spellPut("237-177", "yu");
		spellPut("237-178", "yu");
		spellPut("237-179", "ta,da");
		spellPut("237-180", "xue");
		spellPut("237-181", "miao");
		spellPut("237-182", "ji");
		spellPut("237-183", "gan");
		spellPut("237-184", "dang");
		spellPut("237-185", "xu,hua");
		spellPut("237-186", "che");
		spellPut("237-187", "dun");
		spellPut("237-188", "ya");
		spellPut("237-189", "zhuo");
		spellPut("237-190", "bian");
		spellPut("237-191", "feng");
		spellPut("237-192", "fa");
		spellPut("237-193", "ai");
		spellPut("237-194", "li");
		spellPut("237-195", "long");
		spellPut("237-196", "zha");
		spellPut("237-197", "tong");
		spellPut("237-198", "di");
		spellPut("237-199", "li,la");
		spellPut("237-200", "tuo");
		spellPut("237-201", "fu,fei");
		spellPut("237-202", "xing");
		spellPut("237-203", "mang");
		spellPut("237-204", "xia");
		spellPut("237-205", "qiao");
		spellPut("237-206", "zhai");
		spellPut("237-207", "dong");
		spellPut("237-208", "nao");
		spellPut("237-209", "luo,ge");
		spellPut("237-210", "wo");
		spellPut("237-211", "qi");
		spellPut("237-212", "dui");
		spellPut("237-213", "bei");
		spellPut("237-214", "ding");
		spellPut("237-215", "chen");
		spellPut("237-216", "zhou");
		spellPut("237-217", "jie,ya");
		spellPut("237-218", "di");
		spellPut("237-219", "xuan");
		spellPut("237-220", "bian");
		spellPut("237-221", "zhe");
		spellPut("237-222", "gun");
		spellPut("237-223", "sang");
		spellPut("237-224", "qing");
		spellPut("237-225", "qu");
		spellPut("237-226", "dun");
		spellPut("237-227", "deng");
		spellPut("237-228", "jiang");
		spellPut("237-229", "ca");
		spellPut("237-230", "meng");
		spellPut("237-231", "bo");
		spellPut("237-232", "kan");
		spellPut("237-233", "zhi");
		spellPut("237-234", "fu");
		spellPut("237-235", "fu");
		spellPut("237-236", "xu");
		spellPut("237-237", "mian");
		spellPut("237-238", "kou");
		spellPut("237-239", "dun");
		spellPut("237-240", "miao");
		spellPut("237-241", "dan");
		spellPut("237-242", "sheng");
		spellPut("237-243", "yuan");
		spellPut("237-244", "yi,chi");
		spellPut("237-245", "gui,sui");
		spellPut("237-246", "zi");
		spellPut("237-247", "chi");
		spellPut("237-248", "mou");
		spellPut("237-249", "lai");
		spellPut("237-250", "jian");
		spellPut("237-251", "di");
		spellPut("237-252", "suo");
		spellPut("237-253", "ya");
		spellPut("237-254", "ni");
	}

	private static void init100() {
		spellPut("238-64", "hang");
		spellPut("238-65", "yu");
		spellPut("238-66", "wan");
		spellPut("238-67", "ban");
		spellPut("238-68", "dun");
		spellPut("238-69", "di");
		spellPut("238-70", "dan");
		spellPut("238-71", "pan");
		spellPut("238-72", "po");
		spellPut("238-73", "ling");
		spellPut("238-74", "che");
		spellPut("238-75", "jing");
		spellPut("238-76", "lei");
		spellPut("238-77", "he");
		spellPut("238-78", "qiao");
		spellPut("238-79", "e");
		spellPut("238-80", "e");
		spellPut("238-81", "wei");
		spellPut("238-82", "jie");
		spellPut("238-83", "kuo");
		spellPut("238-84", "shen");
		spellPut("238-85", "yi");
		spellPut("238-86", "yi");
		spellPut("238-87", "ke");
		spellPut("238-88", "dui");
		spellPut("238-89", "yu");
		spellPut("238-90", "ping");
		spellPut("238-91", "lei");
		spellPut("238-92", "fu");
		spellPut("238-93", "jia");
		spellPut("238-94", "tou");
		spellPut("238-95", "hui");
		spellPut("238-96", "kui");
		spellPut("238-97", "jia");
		spellPut("238-98", "luo");
		spellPut("238-99", "ting");
		spellPut("238-100", "cheng");
		spellPut("238-101", "ying");
		spellPut("238-102", "jun");
		spellPut("238-103", "hu");
		spellPut("238-104", "han");
		spellPut("238-105", "jing");
		spellPut("238-106", "tui");
		spellPut("238-107", "tui");
		spellPut("238-108", "bin");
		spellPut("238-109", "lai");
		spellPut("238-110", "tui");
		spellPut("238-111", "zi");
		spellPut("238-112", "zi");
		spellPut("238-113", "chui");
		spellPut("238-114", "ding");
		spellPut("238-115", "lai");
		spellPut("238-116", "tan");
		spellPut("238-117", "han");
		spellPut("238-118", "qian");
		spellPut("238-119", "ke");
		spellPut("238-120", "cui");
		spellPut("238-121", "jiong");
		spellPut("238-122", "qin");
		spellPut("238-123", "yi");
		spellPut("238-124", "sai");
		spellPut("238-125", "ti");
		spellPut("238-126", "e");
		spellPut("238-128", "e");
		spellPut("238-129", "yan");
		spellPut("238-130", "wen");
		spellPut("238-131", "kan");
		spellPut("238-132", "yong");
		spellPut("238-133", "zhuan");
		spellPut("238-134", "yan");
		spellPut("238-135", "xian");
		spellPut("238-136", "xin");
		spellPut("238-137", "yi");
		spellPut("238-138", "yuan");
		spellPut("238-139", "sang");
		spellPut("238-140", "dian");
		spellPut("238-141", "dian");
		spellPut("238-142", "jiang");
		spellPut("238-143", "kui");
		spellPut("238-144", "lei");
		spellPut("238-145", "lao");
		spellPut("238-146", "piao");
		spellPut("238-147", "wai");
		spellPut("238-148", "man");
		spellPut("238-149", "cu");
		spellPut("238-150", "yao");
		spellPut("238-151", "hao");
		spellPut("238-152", "qiao");
		spellPut("238-153", "gu");
		spellPut("238-154", "xun");
		spellPut("238-155", "yan");
		spellPut("238-156", "hui");
		spellPut("238-157", "chan");
		spellPut("238-158", "ru");
		spellPut("238-159", "meng");
		spellPut("238-160", "bin");
		spellPut("238-161", "sui");
		spellPut("238-162", "bi");
		spellPut("238-163", "rui");
		spellPut("238-164", "sou");
		spellPut("238-165", "kui");
		spellPut("238-166", "mao");
		spellPut("238-167", "ke");
		spellPut("238-168", "ming");
		spellPut("238-169", "piao");
		spellPut("238-170", "cheng");
		spellPut("238-171", "kan");
		spellPut("238-172", "lin");
		spellPut("238-173", "gu");
		spellPut("238-174", "ting,ding");
		spellPut("238-175", "bi");
		spellPut("238-176", "quan");
		spellPut("238-177", "tian");
		spellPut("238-178", "fan");
		spellPut("238-179", "zhen");
		spellPut("238-180", "she");
		spellPut("238-181", "wan");
		spellPut("238-182", "tuan");
		spellPut("238-183", "fu");
		spellPut("238-184", "gang");
		spellPut("238-185", "gu");
		spellPut("238-186", "li");
		spellPut("238-187", "yan");
		spellPut("238-188", "pi");
		spellPut("238-189", "lan");
		spellPut("238-190", "li");
		spellPut("238-191", "ji");
		spellPut("238-192", "zeng");
		spellPut("238-193", "he");
		spellPut("238-194", "guan");
		spellPut("238-195", "juan");
		spellPut("238-196", "jin");
		spellPut("238-197", "ga");
		spellPut("238-198", "yi");
		spellPut("238-199", "po");
		spellPut("238-200", "zhao");
		spellPut("238-201", "liao");
		spellPut("238-202", "tu");
		spellPut("238-203", "chuan");
		spellPut("238-204", "shan");
		spellPut("238-205", "men");
		spellPut("238-206", "chai");
		spellPut("238-207", "nv");
		spellPut("238-208", "bu");
		spellPut("238-209", "tai");
		spellPut("238-210", "ju");
		spellPut("238-211", "ban");
		spellPut("238-212", "qian");
		spellPut("238-213", "fang");
		spellPut("238-214", "kang");
		spellPut("238-215", "dou");
		spellPut("238-216", "huo");
		spellPut("238-217", "ba,pa");
		spellPut("238-218", "yu");
		spellPut("238-219", "zheng");
		spellPut("238-220", "gu");
		spellPut("238-221", "ke");
		spellPut("238-222", "po");
		spellPut("238-223", "bu");
		spellPut("238-224", "bo");
		spellPut("238-225", "yue");
		spellPut("238-226", "mu");
		spellPut("238-227", "tan");
		spellPut("238-228", "dian,tian");
		spellPut("238-229", "shuo");
		spellPut("238-230", "shi");
		spellPut("238-231", "xuan");
		spellPut("238-232", "ta,tuo");
		spellPut("238-233", "bi");
		spellPut("238-234", "ni");
		spellPut("238-235", "pi");
		spellPut("238-236", "duo");
		spellPut("238-237", "kao");
		spellPut("238-238", "lao");
		spellPut("238-239", "er");
		spellPut("238-240", "you");
		spellPut("238-241", "cheng");
		spellPut("238-242", "jia");
		spellPut("238-243", "nao");
		spellPut("238-244", "ye");
		spellPut("238-245", "dang,cheng");
		spellPut("238-246", "diao");
		spellPut("238-247", "yin");
		spellPut("238-248", "kai");
		spellPut("238-249", "zhu");
		spellPut("238-250", "ting,ding");
		spellPut("238-251", "diu");
		spellPut("238-252", "hua");
		spellPut("238-253", "quan");
		spellPut("238-254", "ha,ke");
	}

	private static void init101() {
		spellPut("239-64", "xian");
		spellPut("239-65", "pin");
		spellPut("239-66", "lu");
		spellPut("239-67", "lan");
		spellPut("239-68", "nie");
		spellPut("239-69", "quan");
		spellPut("239-70", "ting");
		spellPut("239-71", "jiong");
		spellPut("239-72", "hui");
		spellPut("239-73", "ying");
		spellPut("239-74", "yong");
		spellPut("239-75", "lei");
		spellPut("239-76", "feng");
		spellPut("239-77", "biao,diu");
		spellPut("239-78", "guB");
		spellPut("239-79", "fu");
		spellPut("239-80", "xia");
		spellPut("239-81", "zhan");
		spellPut("239-82", "biao");
		spellPut("239-83", "sa");
		spellPut("239-84", "ba,fu");
		spellPut("239-85", "tai");
		spellPut("239-86", "lie");
		spellPut("239-87", "gua");
		spellPut("239-88", "xuan");
		spellPut("239-89", "xiao");
		spellPut("239-90", "ju");
		spellPut("239-91", "biao");
		spellPut("239-92", "si");
		spellPut("239-93", "wei");
		spellPut("239-94", "yang");
		spellPut("239-95", "yao");
		spellPut("239-96", "sou");
		spellPut("239-97", "kai");
		spellPut("239-98", "sao,sou");
		spellPut("239-99", "fan");
		spellPut("239-100", "liu");
		spellPut("239-101", "xi");
		spellPut("239-102", "liu,liao");
		spellPut("239-103", "piao");
		spellPut("239-104", "piao");
		spellPut("239-105", "liu");
		spellPut("239-106", "biao");
		spellPut("239-107", "biao");
		spellPut("239-108", "biao");
		spellPut("239-109", "liao");
		spellPut("239-110", "biao");
		spellPut("239-111", "se");
		spellPut("239-112", "feng");
		spellPut("239-113", "xiu");
		spellPut("239-114", "yang");
		spellPut("239-115", "zhan");
		spellPut("239-116", "si");
		spellPut("239-117", "yao");
		spellPut("239-118", "liu");
		spellPut("239-119", "fei");
		spellPut("239-120", "fan");
		spellPut("239-121", "fei");
		spellPut("239-122", "shi");
		spellPut("239-123", "can");
		spellPut("239-124", "ji");
		spellPut("239-125", "ding");
		spellPut("239-126", "si");
		spellPut("239-128", "tuo");
		spellPut("239-129", "zhan");
		spellPut("239-130", "tun");
		spellPut("239-131", "ren");
		spellPut("239-132", "yu");
		spellPut("239-133", "yang,juan");
		spellPut("239-134", "chi");
		spellPut("239-135", "yin");
		spellPut("239-136", "fan");
		spellPut("239-137", "fan");
		spellPut("239-138", "sun");
		spellPut("239-139", "yin");
		spellPut("239-140", "zhu,tou");
		spellPut("239-141", "yi,si");
		spellPut("239-142", "zuo,ze,zha");
		spellPut("239-143", "bi");
		spellPut("239-144", "jie");
		spellPut("239-145", "tao");
		spellPut("239-146", "bao");
		spellPut("239-147", "ci");
		spellPut("239-148", "tie");
		spellPut("239-149", "si");
		spellPut("239-150", "bao");
		spellPut("239-151", "shi");
		spellPut("239-152", "duo");
		spellPut("239-153", "hai");
		spellPut("239-154", "ren");
		spellPut("239-155", "tian");
		spellPut("239-156", "jiao");
		spellPut("239-157", "he");
		spellPut("239-158", "bing");
		spellPut("239-159", "yao");
		spellPut("239-160", "tong");
		spellPut("239-161", "sha");
		spellPut("239-162", "diao,tiao,yao");
		spellPut("239-163", "zheng");
		spellPut("239-164", "se");
		spellPut("239-165", "chong");
		spellPut("239-166", "tang");
		spellPut("239-167", "an");
		spellPut("239-168", "ru");
		spellPut("239-169", "lao");
		spellPut("239-170", "lai");
		spellPut("239-171", "te");
		spellPut("239-172", "keng");
		spellPut("239-173", "zeng");
		spellPut("239-174", "li");
		spellPut("239-175", "gao");
		spellPut("239-176", "e");
		spellPut("239-177", "cuo");
		spellPut("239-178", "l<e");
		spellPut("239-179", "liu");
		spellPut("239-180", "kai");
		spellPut("239-181", "jian");
		spellPut("239-182", "lang");
		spellPut("239-183", "qin");
		spellPut("239-184", "ju");
		spellPut("239-185", "a");
		spellPut("239-186", "qiang");
		spellPut("239-187", "nuo");
		spellPut("239-188", "ben");
		spellPut("239-189", "de");
		spellPut("239-190", "ke");
		spellPut("239-191", "kun");
		spellPut("239-192", "gu");
		spellPut("239-193", "huo");
		spellPut("239-194", "pei");
		spellPut("239-195", "juan");
		spellPut("239-196", "tan");
		spellPut("239-197", "zi");
		spellPut("239-198", "qie");
		spellPut("239-199", "kai");
		spellPut("239-200", "si");
		spellPut("239-201", "e");
		spellPut("239-202", "cha");
		spellPut("239-203", "sou");
		spellPut("239-204", "huan");
		spellPut("239-205", "ai");
		spellPut("239-206", "lou");
		spellPut("239-207", "qiang");
		spellPut("239-208", "fei");
		spellPut("239-209", "mei");
		spellPut("239-210", "mo");
		spellPut("239-211", "ge");
		spellPut("239-212", "juan");
		spellPut("239-213", "na");
		spellPut("239-214", "liu");
		spellPut("239-215", "yi");
		spellPut("239-216", "jia");
		spellPut("239-217", "bin");
		spellPut("239-218", "biao");
		spellPut("239-219", "tang");
		spellPut("239-220", "man");
		spellPut("239-221", "luo");
		spellPut("239-222", "yong");
		spellPut("239-223", "zu");
		spellPut("239-224", "xuan");
		spellPut("239-225", "di");
		spellPut("239-226", "xin");
		spellPut("239-227", "jue");
		spellPut("239-228", "pu");
		spellPut("239-229", "lu");
		spellPut("239-230", "dui");
		spellPut("239-231", "lan");
		spellPut("239-232", "pu");
		spellPut("239-233", "cuan");
		spellPut("239-234", "qiang");
		spellPut("239-235", "deng");
		spellPut("239-236", "huo");
		spellPut("239-237", "zhuo");
		spellPut("239-238", "yi");
		spellPut("239-239", "cha");
		spellPut("239-240", "biao");
		spellPut("239-241", "zhong");
		spellPut("239-242", "shen");
		spellPut("239-243", "cuo");
		spellPut("239-244", "zhi");
		spellPut("239-245", "bi");
		spellPut("239-246", "zi");
		spellPut("239-247", "mo");
		spellPut("239-248", "shu");
		spellPut("239-249", "lv");
		spellPut("239-250", "ji");
		spellPut("239-251", "fu");
		spellPut("239-252", "lang");
		spellPut("239-253", "ke");
		spellPut("239-254", "ren");
	}

	private static void init102() {
		spellPut("240-64", "ci");
		spellPut("240-65", "xiang");
		spellPut("240-66", "yang");
		spellPut("240-67", "juan");
		spellPut("240-68", "er");
		spellPut("240-69", "le");
		spellPut("240-70", "xi");
		spellPut("240-71", "bo");
		spellPut("240-72", "nei");
		spellPut("240-73", "e");
		spellPut("240-74", "bu");
		spellPut("240-75", "jun");
		spellPut("240-76", "dou");
		spellPut("240-77", "su");
		spellPut("240-78", "yu");
		spellPut("240-79", "shi");
		spellPut("240-80", "yao");
		spellPut("240-81", "hun");
		spellPut("240-82", "guo");
		spellPut("240-83", "shi");
		spellPut("240-84", "jian");
		spellPut("240-85", "chuo");
		spellPut("240-86", "bing");
		spellPut("240-87", "xian");
		spellPut("240-88", "bu");
		spellPut("240-89", "ye");
		spellPut("240-90", "dan");
		spellPut("240-91", "fei");
		spellPut("240-92", "zhang");
		spellPut("240-93", "wei");
		spellPut("240-94", "guan");
		spellPut("240-95", "e");
		spellPut("240-96", "nuan");
		spellPut("240-97", "yun");
		spellPut("240-98", "hu");
		spellPut("240-99", "huang");
		spellPut("240-100", "hui");
		spellPut("240-101", "jian");
		spellPut("240-102", "hou");
		spellPut("240-103", "ai");
		spellPut("240-104", "xing");
		spellPut("240-105", "fen");
		spellPut("240-106", "wei");
		spellPut("240-107", "gu");
		spellPut("240-108", "cha");
		spellPut("240-109", "song");
		spellPut("240-110", "tang");
		spellPut("240-111", "bo");
		spellPut("240-112", "gao");
		spellPut("240-113", "xi");
		spellPut("240-114", "kui");
		spellPut("240-115", "liu");
		spellPut("240-116", "sou");
		spellPut("240-117", "tao");
		spellPut("240-118", "ye");
		spellPut("240-119", "wen");
		spellPut("240-120", "mo");
		spellPut("240-121", "tang");
		spellPut("240-122", "man");
		spellPut("240-123", "bi");
		spellPut("240-124", "yu");
		spellPut("240-125", "xiu");
		spellPut("240-126", "jin");
		spellPut("240-128", "san");
		spellPut("240-129", "kui");
		spellPut("240-130", "zhuan");
		spellPut("240-131", "shan");
		spellPut("240-132", "xi");
		spellPut("240-133", "dan");
		spellPut("240-134", "yi");
		spellPut("240-135", "ji");
		spellPut("240-136", "rao");
		spellPut("240-137", "cheng");
		spellPut("240-138", "wei");
		spellPut("240-139", "xiang");
		spellPut("240-140", "zhan");
		spellPut("240-141", "fen");
		spellPut("240-142", "hai");
		spellPut("240-143", "meng");
		spellPut("240-144", "yan");
		spellPut("240-145", "mo");
		spellPut("240-146", "chan");
		spellPut("240-147", "xiang");
		spellPut("240-148", "luo");
		spellPut("240-149", "zan");
		spellPut("240-150", "nang");
		spellPut("240-151", "ding");
		spellPut("240-152", "tuo");
		spellPut("240-153", "duo");
		spellPut("240-154", "he");
		spellPut("240-155", "le");
		spellPut("240-156", "xi");
		spellPut("240-157", "dou");
		spellPut("240-158", "jun");
		spellPut("240-159", "guo");
		spellPut("240-160", "gu");
		spellPut("240-161", "zhen");
		spellPut("240-162", "ji");
		spellPut("240-163", "se");
		spellPut("240-164", "nian");
		spellPut("240-165", "fu");
		spellPut("240-166", "rang");
		spellPut("240-167", "gui");
		spellPut("240-168", "jiao");
		spellPut("240-169", "hao");
		spellPut("240-170", "xi");
		spellPut("240-171", "po");
		spellPut("240-172", "die");
		spellPut("240-173", "hu");
		spellPut("240-174", "yong");
		spellPut("240-175", "jiu");
		spellPut("240-176", "yuan");
		spellPut("240-177", "bao");
		spellPut("240-178", "zhen");
		spellPut("240-179", "gu");
		spellPut("240-180", "dong");
		spellPut("240-181", "lu");
		spellPut("240-182", "qu");
		spellPut("240-183", "chi");
		spellPut("240-184", "si");
		spellPut("240-185", "er");
		spellPut("240-186", "zhi");
		spellPut("240-187", "gua");
		spellPut("240-188", "xiu");
		spellPut("240-189", "luan");
		spellPut("240-190", "bo");
		spellPut("240-191", "li");
		spellPut("240-192", "hu");
		spellPut("240-193", "yu");
		spellPut("240-194", "xian");
		spellPut("240-195", "ti");
		spellPut("240-196", "wu");
		spellPut("240-197", "miao");
		spellPut("240-198", "an");
		spellPut("240-199", "bei");
		spellPut("240-200", "chun");
		spellPut("240-201", "hu");
		spellPut("240-202", "e");
		spellPut("240-203", "ci");
		spellPut("240-204", "mei");
		spellPut("240-205", "wu");
		spellPut("240-206", "yao");
		spellPut("240-207", "jian");
		spellPut("240-208", "ying");
		spellPut("240-209", "zhe");
		spellPut("240-210", "liu");
		spellPut("240-211", "liao");
		spellPut("240-212", "jiao");
		spellPut("240-213", "jiu");
		spellPut("240-214", "yu");
		spellPut("240-215", "hu");
		spellPut("240-216", "lu");
		spellPut("240-217", "guan");
		spellPut("240-218", "ne");
		spellPut("240-219", "ding");
		spellPut("240-220", "jie");
		spellPut("240-221", "li,lai");
		spellPut("240-222", "shan");
		spellPut("240-223", "li");
		spellPut("240-224", "you");
		spellPut("240-225", "gan");
		spellPut("240-226", "ke");
		spellPut("240-227", "dan");
		spellPut("240-228", "zha");
		spellPut("240-229", "pao");
		spellPut("240-230", "zhu");
		spellPut("240-231", "xuan");
		spellPut("240-232", "jia");
		spellPut("240-233", "ya");
		spellPut("240-234", "yi");
		spellPut("240-235", "zhi");
		spellPut("240-236", "lao");
		spellPut("240-237", "wu");
		spellPut("240-238", "cuo");
		spellPut("240-239", "xian");
		spellPut("240-240", "sha");
		spellPut("240-241", "zhu");
		spellPut("240-242", "fei");
		spellPut("240-243", "gu");
		spellPut("240-244", "wei");
		spellPut("240-245", "yu");
		spellPut("240-246", "yu");
		spellPut("240-247", "dan");
		spellPut("240-248", "la");
		spellPut("240-249", "yi");
		spellPut("240-250", "hou");
		spellPut("240-251", "chai,cuo");
		spellPut("240-252", "lou");
		spellPut("240-253", "jia,xia");
		spellPut("240-254", "sao");
	}

	private static void init103() {
		spellPut("241-64", "ye");
		spellPut("241-65", "bo");
		spellPut("241-66", "fen");
		spellPut("241-67", "bo");
		spellPut("241-68", "ni");
		spellPut("241-69", "bi");
		spellPut("241-70", "bo");
		spellPut("241-71", "tu");
		spellPut("241-72", "han");
		spellPut("241-73", "fei");
		spellPut("241-74", "jian");
		spellPut("241-75", "an");
		spellPut("241-76", "ai");
		spellPut("241-77", "xian");
		spellPut("241-78", "yun,wo");
		spellPut("241-79", "fen");
		spellPut("241-80", "pin");
		spellPut("241-81", "xin");
		spellPut("241-82", "ma");
		spellPut("241-83", "yu");
		spellPut("241-84", "feng,ping");
		spellPut("241-85", "han");
		spellPut("241-86", "di");
		spellPut("241-87", "tuo,duo");
		spellPut("241-88", "tuo,zhe");
		spellPut("241-89", "chi");
		spellPut("241-90", "xun");
		spellPut("241-91", "zhu");
		spellPut("241-92", "zhi,shi");
		spellPut("241-93", "pei");
		spellPut("241-94", "xin,jin");
		spellPut("241-95", "ri");
		spellPut("241-96", "sa");
		spellPut("241-97", "yun");
		spellPut("241-98", "wen");
		spellPut("241-99", "zhi");
		spellPut("241-100", "dan");
		spellPut("241-101", "lu");
		spellPut("241-102", "you");
		spellPut("241-103", "bo");
		spellPut("241-104", "bao");
		spellPut("241-105", "jue,kuai");
		spellPut("241-106", "tuo,duo");
		spellPut("241-107", "yi");
		spellPut("241-108", "qu");
		spellPut("241-109", "wen");
		spellPut("241-110", "qu");
		spellPut("241-111", "jiong");
		spellPut("241-112", "po");
		spellPut("241-113", "zhao");
		spellPut("241-114", "yuan");
		spellPut("241-115", "peng");
		spellPut("241-116", "zhou");
		spellPut("241-117", "ju");
		spellPut("241-118", "zhu");
		spellPut("241-119", "nu");
		spellPut("241-120", "ju");
		spellPut("241-121", "pi");
		spellPut("241-122", "zang");
		spellPut("241-123", "jia");
		spellPut("241-124", "ling");
		spellPut("241-125", "zhen");
		spellPut("241-126", "tai,dai");
		spellPut("241-128", "fu");
		spellPut("241-129", "yang");
		spellPut("241-130", "shi");
		spellPut("241-131", "bi");
		spellPut("241-132", "tuo");
		spellPut("241-133", "tuo");
		spellPut("241-134", "si");
		spellPut("241-135", "liu");
		spellPut("241-136", "ma");
		spellPut("241-137", "pian");
		spellPut("241-138", "tao");
		spellPut("241-139", "zhi");
		spellPut("241-140", "rong");
		spellPut("241-141", "teng");
		spellPut("241-142", "dong");
		spellPut("241-143", "xun,xuan");
		spellPut("241-144", "quan");
		spellPut("241-145", "shen");
		spellPut("241-146", "jiong");
		spellPut("241-147", "er");
		spellPut("241-148", "hai");
		spellPut("241-149", "bo");
		spellPut("241-150", "zhu");
		spellPut("241-151", "yin");
		spellPut("241-152", "luo");
		spellPut("241-153", "zhou");
		spellPut("241-154", "dan");
		spellPut("241-155", "hai");
		spellPut("241-156", "liu");
		spellPut("241-157", "ju");
		spellPut("241-158", "song");
		spellPut("241-159", "qin");
		spellPut("241-160", "mang");
		spellPut("241-161", "chi");
		spellPut("241-162", "mo");
		spellPut("241-163", "ban");
		spellPut("241-164", "ji");
		spellPut("241-165", "huang");
		spellPut("241-166", "biao");
		spellPut("241-167", "luo");
		spellPut("241-168", "ying");
		spellPut("241-169", "zhai");
		spellPut("241-170", "long");
		spellPut("241-171", "yin");
		spellPut("241-172", "chou");
		spellPut("241-173", "ban");
		spellPut("241-174", "lai");
		spellPut("241-175", "yi");
		spellPut("241-176", "dian");
		spellPut("241-177", "pi");
		spellPut("241-178", "dian");
		spellPut("241-179", "qu");
		spellPut("241-180", "yi");
		spellPut("241-181", "song");
		spellPut("241-182", "xi");
		spellPut("241-183", "qiong");
		spellPut("241-184", "zhun");
		spellPut("241-185", "bian");
		spellPut("241-186", "yao");
		spellPut("241-187", "tiao,yao");
		spellPut("241-188", "dou");
		spellPut("241-189", "ke");
		spellPut("241-190", "yu");
		spellPut("241-191", "yin,xun");
		spellPut("241-192", "ju");
		spellPut("241-193", "yu");
		spellPut("241-194", "yi");
		spellPut("241-195", "cha");
		spellPut("241-196", "na");
		spellPut("241-197", "ren");
		spellPut("241-198", "jin");
		spellPut("241-199", "mei");
		spellPut("241-200", "pan");
		spellPut("241-201", "dang");
		spellPut("241-202", "jia,jie,qia");
		spellPut("241-203", "ge");
		spellPut("241-204", "ken");
		spellPut("241-205", "lian");
		spellPut("241-206", "cheng");
		spellPut("241-207", "lian");
		spellPut("241-208", "jian");
		spellPut("241-209", "biao");
		spellPut("241-210", "zhu");
		spellPut("241-211", "xi,ti");
		spellPut("241-212", "bi,pi");
		spellPut("241-213", "ju");
		spellPut("241-214", "duo");
		spellPut("241-215", "da");
		spellPut("241-216", "bei");
		spellPut("241-217", "bao");
		spellPut("241-218", "lv");
		spellPut("241-219", "bian");
		spellPut("241-220", "lan");
		spellPut("241-221", "chi");
		spellPut("241-222", "zhe");
		spellPut("241-223", "qiang");
		spellPut("241-224", "ru");
		spellPut("241-225", "pan");
		spellPut("241-226", "pi,ya,shu");
		spellPut("241-227", "xu");
		spellPut("241-228", "jun");
		spellPut("241-229", "cun");
		spellPut("241-230", "jin,qin,guan");
		spellPut("241-231", "lei");
		spellPut("241-232", "zi");
		spellPut("241-233", "chao");
		spellPut("241-234", "si");
		spellPut("241-235", "huo");
		spellPut("241-236", "lao");
		spellPut("241-237", "tang");
		spellPut("241-238", "ou");
		spellPut("241-239", "lou");
		spellPut("241-240", "jiang");
		spellPut("241-241", "nou");
		spellPut("241-242", "mo");
		spellPut("241-243", "die");
		spellPut("241-244", "ding");
		spellPut("241-245", "dan");
		spellPut("241-246", "ling");
		spellPut("241-247", "ning");
		spellPut("241-248", "guo");
		spellPut("241-249", "kui");
		spellPut("241-250", "ao");
		spellPut("241-251", "tan,qin");
		spellPut("241-252", "han");
		spellPut("241-253", "qi");
		spellPut("241-254", "hang");
	}

	private static void init104() {
		spellPut("242-64", "liang,lang");
		spellPut("242-65", "han");
		spellPut("242-66", "tu");
		spellPut("242-67", "xuan");
		spellPut("242-68", "tui");
		spellPut("242-69", "jun");
		spellPut("242-70", "e");
		spellPut("242-71", "cheng");
		spellPut("242-72", "xing");
		spellPut("242-73", "si");
		spellPut("242-74", "lu");
		spellPut("242-75", "zhui");
		spellPut("242-76", "zhou");
		spellPut("242-77", "she");
		spellPut("242-78", "pian");
		spellPut("242-79", "kun");
		spellPut("242-80", "tao");
		spellPut("242-81", "lai");
		spellPut("242-82", "zong");
		spellPut("242-83", "ke");
		spellPut("242-84", "qi");
		spellPut("242-85", "qi");
		spellPut("242-86", "yan");
		spellPut("242-87", "fei");
		spellPut("242-88", "sao");
		spellPut("242-89", "yan");
		spellPut("242-90", "ge");
		spellPut("242-91", "yao");
		spellPut("242-92", "wu");
		spellPut("242-93", "pian");
		spellPut("242-94", "cong");
		spellPut("242-95", "pian");
		spellPut("242-96", "qian");
		spellPut("242-97", "fei");
		spellPut("242-98", "huang");
		spellPut("242-99", "qian");
		spellPut("242-100", "huo");
		spellPut("242-101", "yu");
		spellPut("242-102", "ti");
		spellPut("242-103", "quan");
		spellPut("242-104", "xia");
		spellPut("242-105", "zong");
		spellPut("242-106", "kui");
		spellPut("242-107", "rou");
		spellPut("242-108", "si");
		spellPut("242-109", "gua");
		spellPut("242-110", "tuo");
		spellPut("242-111", "gui");
		spellPut("242-112", "sou");
		spellPut("242-113", "qian");
		spellPut("242-114", "cheng");
		spellPut("242-115", "zhi");
		spellPut("242-116", "liu");
		spellPut("242-117", "peng");
		spellPut("242-118", "teng");
		spellPut("242-119", "xi");
		spellPut("242-120", "cao");
		spellPut("242-121", "du");
		spellPut("242-122", "yan");
		spellPut("242-123", "yuan");
		spellPut("242-124", "zou");
		spellPut("242-125", "sao");
		spellPut("242-126", "shan");
		spellPut("242-128", "qi");
		spellPut("242-129", "zhi");
		spellPut("242-130", "shuang");
		spellPut("242-131", "lu");
		spellPut("242-132", "xi");
		spellPut("242-133", "luo");
		spellPut("242-134", "zhang");
		spellPut("242-135", "mo");
		spellPut("242-136", "ao");
		spellPut("242-137", "can");
		spellPut("242-138", "piao");
		spellPut("242-139", "cong");
		spellPut("242-140", "qu");
		spellPut("242-141", "bi");
		spellPut("242-142", "zhi");
		spellPut("242-143", "yu");
		spellPut("242-144", "xu");
		spellPut("242-145", "hua");
		spellPut("242-146", "bo");
		spellPut("242-147", "su");
		spellPut("242-148", "xiao");
		spellPut("242-149", "lin");
		spellPut("242-150", "zhan");
		spellPut("242-151", "dun");
		spellPut("242-152", "liu");
		spellPut("242-153", "tuo");
		spellPut("242-154", "ceng");
		spellPut("242-155", "dian");
		spellPut("242-156", "jiao");
		spellPut("242-157", "tie");
		spellPut("242-158", "yan");
		spellPut("242-159", "luo");
		spellPut("242-160", "zhan");
		spellPut("242-161", "jie,xie,jia");
		spellPut("242-162", "he,ge");
		spellPut("242-163", "ying");
		spellPut("242-164", "ke");
		spellPut("242-165", "han");
		spellPut("242-166", "e");
		spellPut("242-167", "zhuan");
		spellPut("242-168", "nie");
		spellPut("242-169", "man");
		spellPut("242-170", "sang");
		spellPut("242-171", "hao");
		spellPut("242-172", "ru");
		spellPut("242-173", "pin");
		spellPut("242-174", "hu");
		spellPut("242-175", "qian");
		spellPut("242-176", "qiu");
		spellPut("242-177", "ji");
		spellPut("242-178", "chai");
		spellPut("242-179", "hui");
		spellPut("242-180", "ge");
		spellPut("242-181", "meng");
		spellPut("242-182", "fu");
		spellPut("242-183", "pi");
		spellPut("242-184", "rui");
		spellPut("242-185", "xian");
		spellPut("242-186", "hao");
		spellPut("242-187", "jie");
		spellPut("242-188", "gong,zhong");
		spellPut("242-189", "dou");
		spellPut("242-190", "yin");
		spellPut("242-191", "chi");
		spellPut("242-192", "han");
		spellPut("242-193", "gu");
		spellPut("242-194", "ke");
		spellPut("242-195", "li");
		spellPut("242-196", "you");
		spellPut("242-197", "ran");
		spellPut("242-198", "zha");
		spellPut("242-199", "qiu");
		spellPut("242-200", "ling");
		spellPut("242-201", "cheng");
		spellPut("242-202", "you");
		spellPut("242-203", "qiong");
		spellPut("242-204", "jia");
		spellPut("242-205", "nao");
		spellPut("242-206", "zhi");
		spellPut("242-207", "si");
		spellPut("242-208", "qu");
		spellPut("242-209", "ting");
		spellPut("242-210", "kuo");
		spellPut("242-211", "qi");
		spellPut("242-212", "jiao");
		spellPut("242-213", "yang");
		spellPut("242-214", "mou");
		spellPut("242-215", "shen");
		spellPut("242-216", "zhe");
		spellPut("242-217", "xiao");
		spellPut("242-218", "wu");
		spellPut("242-219", "li");
		spellPut("242-220", "chu");
		spellPut("242-221", "fu");
		spellPut("242-222", "qiang");
		spellPut("242-223", "qing");
		spellPut("242-224", "qi");
		spellPut("242-225", "xi");
		spellPut("242-226", "yu");
		spellPut("242-227", "fei");
		spellPut("242-228", "guo");
		spellPut("242-229", "guo");
		spellPut("242-230", "yi");
		spellPut("242-231", "pi");
		spellPut("242-232", "tiao");
		spellPut("242-233", "quan");
		spellPut("242-234", "wan");
		spellPut("242-235", "lang");
		spellPut("242-236", "meng");
		spellPut("242-237", "chun");
		spellPut("242-238", "rong");
		spellPut("242-239", "nan");
		spellPut("242-240", "fu");
		spellPut("242-241", "kui");
		spellPut("242-242", "ke");
		spellPut("242-243", "fu");
		spellPut("242-244", "sou");
		spellPut("242-245", "yu");
		spellPut("242-246", "you");
		spellPut("242-247", "lou");
		spellPut("242-248", "qiu");
		spellPut("242-249", "bian");
		spellPut("242-250", "mao");
		spellPut("242-251", "qin");
		spellPut("242-252", "ao");
		spellPut("242-253", "man");
		spellPut("242-254", "mang,meng");
	}

	private static void init105() {
		spellPut("243-64", "jing");
		spellPut("243-65", "yi");
		spellPut("243-66", "ye");
		spellPut("243-67", "tuo");
		spellPut("243-68", "pin");
		spellPut("243-69", "zhou");
		spellPut("243-70", "yan");
		spellPut("243-71", "long");
		spellPut("243-72", "lv");
		spellPut("243-73", "teng");
		spellPut("243-74", "xiang");
		spellPut("243-75", "ji");
		spellPut("243-76", "shuang");
		spellPut("243-77", "ju");
		spellPut("243-78", "xi");
		spellPut("243-79", "huan");
		spellPut("243-80", "li");
		spellPut("243-81", "biao");
		spellPut("243-82", "ri");
		spellPut("243-83", "yin");
		spellPut("243-84", "biao");
		spellPut("243-85", "xing");
		spellPut("243-86", "qin");
		spellPut("243-87", "zong");
		spellPut("243-88", "su");
		spellPut("243-89", "kui");
		spellPut("243-90", "shuang");
		spellPut("243-91", "wei");
		spellPut("243-92", "wei");
		spellPut("243-93", "wei");
		spellPut("243-94", "yu");
		spellPut("243-95", "gan");
		spellPut("243-96", "yi");
		spellPut("243-97", "ang");
		spellPut("243-98", "bao");
		spellPut("243-99", "bei,mo");
		spellPut("243-100", "ci");
		spellPut("243-101", "ti");
		spellPut("243-102", "qiao,xiao");
		spellPut("243-103", "kua");
		spellPut("243-104", "tui");
		spellPut("243-105", "geng");
		spellPut("243-106", "pian");
		spellPut("243-107", "ou");
		spellPut("243-108", "sui");
		spellPut("243-109", "bo");
		spellPut("243-110", "xiao");
		spellPut("243-111", "bang");
		spellPut("243-112", "bo,jue");
		spellPut("243-113", "ci");
		spellPut("243-114", "mo");
		spellPut("243-115", "liao");
		spellPut("243-116", "lou");
		spellPut("243-117", "xiao");
		spellPut("243-118", "zang");
		spellPut("243-119", "ti");
		spellPut("243-120", "bin");
		spellPut("243-121", "kuan");
		spellPut("243-122", "lu");
		spellPut("243-123", "gao");
		spellPut("243-124", "qiao");
		spellPut("243-125", "kao");
		spellPut("243-126", "qiao");
		spellPut("243-128", "lao");
		spellPut("243-129", "sao");
		spellPut("243-130", "kun");
		spellPut("243-131", "di");
		spellPut("243-132", "fang");
		spellPut("243-133", "xiu");
		spellPut("243-134", "ran");
		spellPut("243-135", "dan");
		spellPut("243-136", "kun");
		spellPut("243-137", "bin");
		spellPut("243-138", "fa");
		spellPut("243-139", "pi");
		spellPut("243-140", "fa");
		spellPut("243-141", "ti");
		spellPut("243-142", "bao");
		spellPut("243-143", "bi,po");
		spellPut("243-144", "mao,meng");
		spellPut("243-145", "fu");
		spellPut("243-146", "er");
		spellPut("243-147", "er");
		spellPut("243-148", "qu");
		spellPut("243-149", "gong");
		spellPut("243-150", "kuo,yue");
		spellPut("243-151", "peng");
		spellPut("243-152", "zhua");
		spellPut("243-153", "shao");
		spellPut("243-154", "sha");
		spellPut("243-155", "ti");
		spellPut("243-156", "li");
		spellPut("243-157", "bin");
		spellPut("243-158", "ti");
		spellPut("243-159", "peng");
		spellPut("243-160", "song");
		spellPut("243-161", "mB");
		spellPut("243-162", "yuan");
		spellPut("243-163", "xi");
		spellPut("243-164", "chi");
		spellPut("243-165", "tang");
		spellPut("243-166", "pang");
		spellPut("243-167", "shi,zhe");
		spellPut("243-168", "huang");
		spellPut("243-169", "cao");
		spellPut("243-170", "piao");
		spellPut("243-171", "tang");
		spellPut("243-172", "xi");
		spellPut("243-173", "xiang");
		spellPut("243-174", "zhong");
		spellPut("243-175", "zhang");
		spellPut("243-176", "shuai");
		spellPut("243-177", "mao");
		spellPut("243-178", "peng");
		spellPut("243-179", "hui");
		spellPut("243-180", "pan");
		spellPut("243-181", "shan");
		spellPut("243-182", "huo");
		spellPut("243-183", "meng");
		spellPut("243-184", "chan");
		spellPut("243-185", "lian");
		spellPut("243-186", "mie");
		spellPut("243-187", "li");
		spellPut("243-188", "du");
		spellPut("243-189", "qu");
		spellPut("243-190", "fou");
		spellPut("243-191", "ying");
		spellPut("243-192", "qing");
		spellPut("243-193", "xia");
		spellPut("243-194", "shi");
		spellPut("243-195", "zhu,du");
		spellPut("243-196", "yu");
		spellPut("243-197", "ji");
		spellPut("243-198", "du");
		spellPut("243-199", "ji");
		spellPut("243-200", "jian");
		spellPut("243-201", "zhao");
		spellPut("243-202", "zi");
		spellPut("243-203", "hu");
		spellPut("243-204", "qiong");
		spellPut("243-205", "po");
		spellPut("243-206", "da");
		spellPut("243-207", "sheng");
		spellPut("243-208", "zuo,ze");
		spellPut("243-209", "gou");
		spellPut("243-210", "li");
		spellPut("243-211", "si");
		spellPut("243-212", "tiao");
		spellPut("243-213", "jia");
		spellPut("243-214", "bian");
		spellPut("243-215", "chi");
		spellPut("243-216", "kou");
		spellPut("243-217", "bi");
		spellPut("243-218", "xian");
		spellPut("243-219", "yan");
		spellPut("243-220", "quan");
		spellPut("243-221", "zheng");
		spellPut("243-222", "yun,jun");
		spellPut("243-223", "shi");
		spellPut("243-224", "gang");
		spellPut("243-225", "pa");
		spellPut("243-226", "shao");
		spellPut("243-227", "xiao");
		spellPut("243-228", "qing,jing");
		spellPut("243-229", "ze");
		spellPut("243-230", "qie");
		spellPut("243-231", "zhu");
		spellPut("243-232", "ruo");
		spellPut("243-233", "qian");
		spellPut("243-234", "tuo");
		spellPut("243-235", "bi");
		spellPut("243-236", "dan");
		spellPut("243-237", "kong");
		spellPut("243-238", "wan,yuan");
		spellPut("243-239", "xiao");
		spellPut("243-240", "zhen");
		spellPut("243-241", "kui");
		spellPut("243-242", "huang");
		spellPut("243-243", "hou");
		spellPut("243-244", "gou");
		spellPut("243-245", "fei");
		spellPut("243-246", "li");
		spellPut("243-247", "bi");
		spellPut("243-248", "chi");
		spellPut("243-249", "su");
		spellPut("243-250", "mie");
		spellPut("243-251", "dou");
		spellPut("243-252", "lu");
		spellPut("243-253", "duan");
		spellPut("243-254", "gui");
	}

	private static void init106() {
		spellPut("244-64", "zheng");
		spellPut("244-65", "zong");
		spellPut("244-66", "shun");
		spellPut("244-67", "jian");
		spellPut("244-68", "duo");
		spellPut("244-69", "hu");
		spellPut("244-70", "la");
		spellPut("244-71", "qi");
		spellPut("244-72", "lian");
		spellPut("244-73", "zhen");
		spellPut("244-74", "peng");
		spellPut("244-75", "ma");
		spellPut("244-76", "san");
		spellPut("244-77", "man");
		spellPut("244-78", "man");
		spellPut("244-79", "seng");
		spellPut("244-80", "xu");
		spellPut("244-81", "lie");
		spellPut("244-82", "qian");
		spellPut("244-83", "qian");
		spellPut("244-84", "nong");
		spellPut("244-85", "kuo");
		spellPut("244-86", "ning");
		spellPut("244-87", "bin");
		spellPut("244-88", "rang");
		spellPut("244-89", "dou");
		spellPut("244-90", "dou");
		spellPut("244-91", "nao");
		spellPut("244-92", "hong");
		spellPut("244-93", "xi");
		spellPut("244-94", "dou");
		spellPut("244-95", "kan");
		spellPut("244-96", "dou");
		spellPut("244-97", "dou");
		spellPut("244-98", "jiu");
		spellPut("244-99", "yu");
		spellPut("244-100", "yu");
		spellPut("244-101", "yan");
		spellPut("244-102", "fu");
		spellPut("244-103", "zeng");
		spellPut("244-104", "gui");
		spellPut("244-105", "zong");
		spellPut("244-106", "liu");
		spellPut("244-107", "gui");
		spellPut("244-108", "shang");
		spellPut("244-109", "mei");
		spellPut("244-110", "ji");
		spellPut("244-111", "qi");
		spellPut("244-112", "ga");
		spellPut("244-113", "xu");
		spellPut("244-114", "yu");
		spellPut("244-115", "tui");
		spellPut("244-116", "qi");
		spellPut("244-117", "liang");
		spellPut("244-118", "gan");
		spellPut("244-119", "piao");
		spellPut("244-120", "bi");
		spellPut("244-121", "ji");
		spellPut("244-122", "xu");
		spellPut("244-123", "chou");
		spellPut("244-124", "yan");
		spellPut("244-125", "zhan");
		spellPut("244-126", "yu");
		spellPut("244-128", "dao");
		spellPut("244-129", "ren");
		spellPut("244-130", "ji");
		spellPut("244-131", "Bi li");
		spellPut("244-132", "hong");
		spellPut("244-133", "tuo");
		spellPut("244-134", "diao");
		spellPut("244-135", "ji");
		spellPut("244-136", "yu");
		spellPut("244-137", "e");
		spellPut("244-138", "ji");
		spellPut("244-139", "sha");
		spellPut("244-140", "hang");
		spellPut("244-141", "tun");
		spellPut("244-142", "mo");
		spellPut("244-143", "jie");
		spellPut("244-144", "shen");
		spellPut("244-145", "ban");
		spellPut("244-146", "yuan");
		spellPut("244-147", "pi");
		spellPut("244-148", "lu");
		spellPut("244-149", "wen");
		spellPut("244-150", "hu");
		spellPut("244-151", "lu");
		spellPut("244-152", "za");
		spellPut("244-153", "fang");
		spellPut("244-154", "fen");
		spellPut("244-155", "na");
		spellPut("244-156", "you");
		spellPut("244-157", "na ma zi");
		spellPut("244-158", "mo");
		spellPut("244-159", "he");
		spellPut("244-160", "xia");
		spellPut("244-161", "dian");
		spellPut("244-162", "zan");
		spellPut("244-163", "deng");
		spellPut("244-164", "bo");
		spellPut("244-165", "lai");
		spellPut("244-166", "zhou");
		spellPut("244-167", "yu");
		spellPut("244-168", "yu");
		spellPut("244-169", "chong");
		spellPut("244-170", "xi");
		spellPut("244-171", "nie");
		spellPut("244-172", "nv");
		spellPut("244-173", "chuan");
		spellPut("244-174", "shan");
		spellPut("244-175", "yi");
		spellPut("244-176", "bi");
		spellPut("244-177", "zhong");
		spellPut("244-178", "ban");
		spellPut("244-179", "fang");
		spellPut("244-180", "ge");
		spellPut("244-181", "lu");
		spellPut("244-182", "zhu");
		spellPut("244-183", "ze");
		spellPut("244-184", "xi");
		spellPut("244-185", "shao");
		spellPut("244-186", "wei");
		spellPut("244-187", "meng");
		spellPut("244-188", "shou");
		spellPut("244-189", "cao");
		spellPut("244-190", "chong");
		spellPut("244-191", "meng");
		spellPut("244-192", "qin");
		spellPut("244-193", "niao");
		spellPut("244-194", "jia");
		spellPut("244-195", "qiu");
		spellPut("244-196", "sha");
		spellPut("244-197", "bi");
		spellPut("244-198", "di");
		spellPut("244-199", "qiang");
		spellPut("244-200", "suo");
		spellPut("244-201", "jie");
		spellPut("244-202", "tang");
		spellPut("244-203", "xi");
		spellPut("244-204", "xian");
		spellPut("244-205", "mi");
		spellPut("244-206", "ba");
		spellPut("244-207", "li");
		spellPut("244-208", "tiao");
		spellPut("244-209", "xi");
		spellPut("244-210", "zi,ci");
		spellPut("244-211", "can");
		spellPut("244-212", "lin");
		spellPut("244-213", "zong");
		spellPut("244-214", "san,shen");
		spellPut("244-215", "hou");
		spellPut("244-216", "zan");
		spellPut("244-217", "ci");
		spellPut("244-218", "xu");
		spellPut("244-219", "rou");
		spellPut("244-220", "qiu");
		spellPut("244-221", "jiang");
		spellPut("244-222", "gen");
		spellPut("244-223", "ji");
		spellPut("244-224", "yi");
		spellPut("244-225", "ling");
		spellPut("244-226", "xi");
		spellPut("244-227", "zhu");
		spellPut("244-228", "fei");
		spellPut("244-229", "jian");
		spellPut("244-230", "pian");
		spellPut("244-231", "he");
		spellPut("244-232", "yi");
		spellPut("244-233", "mi,si");
		spellPut("244-234", "zhi");
		spellPut("244-235", "qi");
		spellPut("244-236", "qing,qi");
		spellPut("244-237", "yao,you,zhou");
		spellPut("244-238", "dao");
		spellPut("244-239", "fu");
		spellPut("244-240", "qu");
		spellPut("244-241", "jiu");
		spellPut("244-242", "qie,ju");
		spellPut("244-243", "lie");
		spellPut("244-244", "zi");
		spellPut("244-245", "zan");
		spellPut("244-246", "nan");
		spellPut("244-247", "zhe");
		spellPut("244-248", "jiang");
		spellPut("244-249", "chi");
		spellPut("244-250", "ding");
		spellPut("244-251", "gan");
		spellPut("244-252", "zhou");
		spellPut("244-253", "yi");
		spellPut("244-254", "gu");
	}

	private static void init107() {
		spellPut("245-64", "qu");
		spellPut("245-65", "han");
		spellPut("245-66", "pi");
		spellPut("245-67", "ling");
		spellPut("245-68", "tuo");
		spellPut("245-69", "ba");
		spellPut("245-70", "qiu");
		spellPut("245-71", "ping");
		spellPut("245-72", "fu");
		spellPut("245-73", "bi");
		spellPut("245-74", "ci,ji");
		spellPut("245-75", "wei");
		spellPut("245-76", "ju");
		spellPut("245-77", "diao");
		spellPut("245-78", "bo,ba");
		spellPut("245-79", "you");
		spellPut("245-80", "gun");
		spellPut("245-81", "pi");
		spellPut("245-82", "nian");
		spellPut("245-83", "xing");
		spellPut("245-84", "tai");
		spellPut("245-85", "bao");
		spellPut("245-86", "fu");
		spellPut("245-87", "zha");
		spellPut("245-88", "ju");
		spellPut("245-89", "gu");
		spellPut("245-90", "shi");
		spellPut("245-91", "dong");
		spellPut("245-92", "chou");
		spellPut("245-93", "ta");
		spellPut("245-94", "jie");
		spellPut("245-95", "shu");
		spellPut("245-96", "hou");
		spellPut("245-97", "xiang");
		spellPut("245-98", "er");
		spellPut("245-99", "an");
		spellPut("245-100", "wei");
		spellPut("245-101", "zhao");
		spellPut("245-102", "zhu");
		spellPut("245-103", "yin");
		spellPut("245-104", "lie");
		spellPut("245-105", "luo,ge");
		spellPut("245-106", "tong");
		spellPut("245-107", "yi");
		spellPut("245-108", "yi");
		spellPut("245-109", "bing");
		spellPut("245-110", "wei");
		spellPut("245-111", "jiao");
		spellPut("245-112", "ku");
		spellPut("245-113", "gui,xie,wa,kui");
		spellPut("245-114", "xian");
		spellPut("245-115", "ge");
		spellPut("245-116", "hui");
		spellPut("245-117", "luo la");
		spellPut("245-118", "ma tBi");
		spellPut("245-119", "kao");
		spellPut("245-120", "xiu");
		spellPut("245-121", "tuo");
		spellPut("245-122", "jun");
		spellPut("245-123", "ti");
		spellPut("245-124", "mian");
		spellPut("245-125", "shao");
		spellPut("245-126", "zha");
		spellPut("245-128", "suo");
		spellPut("245-129", "qin");
		spellPut("245-130", "yu");
		spellPut("245-131", "nei");
		spellPut("245-132", "zhe");
		spellPut("245-133", "gun");
		spellPut("245-134", "geng");
		spellPut("245-135", "su");
		spellPut("245-136", "wu");
		spellPut("245-137", "qiu");
		spellPut("245-138", "shan");
		spellPut("245-139", "pu,bu");
		spellPut("245-140", "huan");
		spellPut("245-141", "tiao");
		spellPut("245-142", "li");
		spellPut("245-143", "sha");
		spellPut("245-144", "sha");
		spellPut("245-145", "kao");
		spellPut("245-146", "meng");
		spellPut("245-147", "cheng");
		spellPut("245-148", "li");
		spellPut("245-149", "si ba xi li");
		spellPut("245-150", "ka zi nou ke");
		spellPut("245-151", "yong");
		spellPut("245-152", "shen");
		spellPut("245-153", "zi");
		spellPut("245-154", "qi");
		spellPut("245-155", "qing");
		spellPut("245-156", "xiang");
		spellPut("245-157", "nei");
		spellPut("245-158", "chun");
		spellPut("245-159", "ji");
		spellPut("245-160", "diao");
		spellPut("245-161", "zuo");
		spellPut("245-162", "tuo");
		spellPut("245-163", "xian");
		spellPut("245-164", "ming");
		spellPut("245-165", "zhi");
		spellPut("245-166", "yan");
		spellPut("245-167", "shi");
		spellPut("245-168", "cheng");
		spellPut("245-169", "tu");
		spellPut("245-170", "lei");
		spellPut("245-171", "kun");
		spellPut("245-172", "pei");
		spellPut("245-173", "hu");
		spellPut("245-174", "ti");
		spellPut("245-175", "xu");
		spellPut("245-176", "hai");
		spellPut("245-177", "tang");
		spellPut("245-178", "lao");
		spellPut("245-179", "bu");
		spellPut("245-180", "jiao");
		spellPut("245-181", "xi");
		spellPut("245-182", "ju");
		spellPut("245-183", "li");
		spellPut("245-184", "xun");
		spellPut("245-185", "shi");
		spellPut("245-186", "cuo");
		spellPut("245-187", "dun");
		spellPut("245-188", "qiong");
		spellPut("245-189", "xue");
		spellPut("245-190", "cu");
		spellPut("245-191", "bie");
		spellPut("245-192", "bao,bo");
		spellPut("245-193", "ta");
		spellPut("245-194", "jian");
		spellPut("245-195", "fu");
		spellPut("245-196", "qiang");
		spellPut("245-197", "zhi");
		spellPut("245-198", "fu");
		spellPut("245-199", "shan");
		spellPut("245-200", "li,luo");
		spellPut("245-201", "tuo");
		spellPut("245-202", "jia");
		spellPut("245-203", "bo");
		spellPut("245-204", "tai");
		spellPut("245-205", "kui");
		spellPut("245-206", "qiao");
		spellPut("245-207", "bi");
		spellPut("245-208", "xian");
		spellPut("245-209", "xian");
		spellPut("245-210", "ji");
		spellPut("245-211", "jiao");
		spellPut("245-212", "liang");
		spellPut("245-213", "ji");
		spellPut("245-214", "chuo");
		spellPut("245-215", "huai");
		spellPut("245-216", "chi");
		spellPut("245-217", "zhi");
		spellPut("245-218", "dian");
		spellPut("245-219", "bo");
		spellPut("245-220", "zhi");
		spellPut("245-221", "jian");
		spellPut("245-222", "die");
		spellPut("245-223", "chuai");
		spellPut("245-224", "zhong");
		spellPut("245-225", "ju");
		spellPut("245-226", "duo");
		spellPut("245-227", "cuo");
		spellPut("245-228", "pian");
		spellPut("245-229", "rou");
		spellPut("245-230", "nie");
		spellPut("245-231", "pan");
		spellPut("245-232", "xi");
		spellPut("245-233", "chu");
		spellPut("245-234", "jue");
		spellPut("245-235", "pu");
		spellPut("245-236", "fan");
		spellPut("245-237", "cu");
		spellPut("245-238", "zhu");
		spellPut("245-239", "lin");
		spellPut("245-240", "chan");
		spellPut("245-241", "lie");
		spellPut("245-242", "zuan");
		spellPut("245-243", "xie");
		spellPut("245-244", "zhi");
		spellPut("245-245", "diao");
		spellPut("245-246", "mo");
		spellPut("245-247", "xiu");
		spellPut("245-248", "mo");
		spellPut("245-249", "pi");
		spellPut("245-250", "hu");
		spellPut("245-251", "jue");
		spellPut("245-252", "shang");
		spellPut("245-253", "gu");
		spellPut("245-254", "zi,zui");
	}

	private static void init108() {
		spellPut("246-64", "qie");
		spellPut("246-65", "gu");
		spellPut("246-66", "zhou");
		spellPut("246-67", "dong");
		spellPut("246-68", "lai");
		spellPut("246-69", "fei");
		spellPut("246-70", "ni");
		spellPut("246-71", "yi,si");
		spellPut("246-72", "kun");
		spellPut("246-73", "lu");
		spellPut("246-74", "jiu");
		spellPut("246-75", "chang");
		spellPut("246-76", "jing");
		spellPut("246-77", "lun");
		spellPut("246-78", "ling");
		spellPut("246-79", "zou");
		spellPut("246-80", "li");
		spellPut("246-81", "meng");
		spellPut("246-82", "zong");
		spellPut("246-83", "zhi");
		spellPut("246-84", "nian");
		spellPut("246-85", "xiB qi ho ko");
		spellPut("246-86", "duo ji ya wu");
		spellPut("246-87", "shu ke tou da ra");
		spellPut("246-88", "shi");
		spellPut("246-89", "shen");
		spellPut("246-90", "huan");
		spellPut("246-91", "ti");
		spellPut("246-92", "hou");
		spellPut("246-93", "xing");
		spellPut("246-94", "zhu");
		spellPut("246-95", "la");
		spellPut("246-96", "zong");
		spellPut("246-97", "ji");
		spellPut("246-98", "bian");
		spellPut("246-99", "bian");
		spellPut("246-100", "huan");
		spellPut("246-101", "quan");
		spellPut("246-102", "zei");
		spellPut("246-103", "wei");
		spellPut("246-104", "wei");
		spellPut("246-105", "yu");
		spellPut("246-106", "chun");
		spellPut("246-107", "rou");
		spellPut("246-108", "die");
		spellPut("246-109", "huang");
		spellPut("246-110", "lian");
		spellPut("246-111", "yan");
		spellPut("246-112", "qiu");
		spellPut("246-113", "qiu");
		spellPut("246-114", "jian");
		spellPut("246-115", "bi");
		spellPut("246-116", "e");
		spellPut("246-117", "yang");
		spellPut("246-118", "fu");
		spellPut("246-119", "sai");
		spellPut("246-120", "jian");
		spellPut("246-121", "xia");
		spellPut("246-122", "tuo");
		spellPut("246-123", "hu");
		spellPut("246-124", "shi");
		spellPut("246-125", "ruo");
		spellPut("246-126", "ha la ka");
		spellPut("246-128", "wen");
		spellPut("246-129", "jian");
		spellPut("246-130", "hao");
		spellPut("246-131", "wu");
		spellPut("246-132", "pang");
		spellPut("246-133", "sao");
		spellPut("246-134", "liu");
		spellPut("246-135", "ma");
		spellPut("246-136", "shi");
		spellPut("246-137", "shi");
		spellPut("246-138", "guan");
		spellPut("246-139", "zi");
		spellPut("246-140", "teng");
		spellPut("246-141", "ta");
		spellPut("246-142", "yao");
		spellPut("246-143", "e");
		spellPut("246-144", "yong");
		spellPut("246-145", "qian");
		spellPut("246-146", "qi");
		spellPut("246-147", "wen");
		spellPut("246-148", "ruo");
		spellPut("246-149", "ha ta ha ta");
		spellPut("246-150", "lian");
		spellPut("246-151", "ao");
		spellPut("246-152", "le");
		spellPut("246-153", "hui");
		spellPut("246-154", "min");
		spellPut("246-155", "ji");
		spellPut("246-156", "tiao");
		spellPut("246-157", "qu");
		spellPut("246-158", "jian");
		spellPut("246-159", "shen");
		spellPut("246-160", "man");
		spellPut("246-161", "gong");
		spellPut("246-162", "su");
		spellPut("246-163", "zhi");
		spellPut("246-164", "zi");
		spellPut("246-165", "qing");
		spellPut("246-166", "jing");
		spellPut("246-167", "yu");
		spellPut("246-168", "li");
		spellPut("246-169", "wen");
		spellPut("246-170", "ting");
		spellPut("246-171", "ji");
		spellPut("246-172", "pei");
		spellPut("246-173", "fei");
		spellPut("246-174", "sha");
		spellPut("246-175", "yin");
		spellPut("246-176", "ai");
		spellPut("246-177", "xian");
		spellPut("246-178", "mai");
		spellPut("246-179", "chen");
		spellPut("246-180", "ju");
		spellPut("246-181", "bao");
		spellPut("246-182", "tiao");
		spellPut("246-183", "zi");
		spellPut("246-184", "yin,ken");
		spellPut("246-185", "yu");
		spellPut("246-186", "chuo");
		spellPut("246-187", "wo");
		spellPut("246-188", "min,mian,meng");
		spellPut("246-189", "yuan");
		spellPut("246-190", "tuo");
		spellPut("246-191", "zhui,cui,wei");
		spellPut("246-192", "sun");
		spellPut("246-193", "jun,juan");
		spellPut("246-194", "ju");
		spellPut("246-195", "luo");
		spellPut("246-196", "qu,ju");
		spellPut("246-197", "chou");
		spellPut("246-198", "qiong");
		spellPut("246-199", "luan");
		spellPut("246-200", "wu");
		spellPut("246-201", "zan");
		spellPut("246-202", "mou");
		spellPut("246-203", "ao");
		spellPut("246-204", "liu");
		spellPut("246-205", "bei");
		spellPut("246-206", "xin");
		spellPut("246-207", "you");
		spellPut("246-208", "fang");
		spellPut("246-209", "ba");
		spellPut("246-210", "ping");
		spellPut("246-211", "nian");
		spellPut("246-212", "lu");
		spellPut("246-213", "su");
		spellPut("246-214", "fu");
		spellPut("246-215", "hou");
		spellPut("246-216", "tai");
		spellPut("246-217", "gui,xie");
		spellPut("246-218", "jie");
		spellPut("246-219", "wei");
		spellPut("246-220", "er");
		spellPut("246-221", "ji");
		spellPut("246-222", "jiao");
		spellPut("246-223", "xiang");
		spellPut("246-224", "xun");
		spellPut("246-225", "geng");
		spellPut("246-226", "li");
		spellPut("246-227", "lian");
		spellPut("246-228", "jian");
		spellPut("246-229", "shi");
		spellPut("246-230", "tiao");
		spellPut("246-231", "gun");
		spellPut("246-232", "sha");
		spellPut("246-233", "huan");
		spellPut("246-234", "ji");
		spellPut("246-235", "qing");
		spellPut("246-236", "ling");
		spellPut("246-237", "zou");
		spellPut("246-238", "fei");
		spellPut("246-239", "kun");
		spellPut("246-240", "chang");
		spellPut("246-241", "gu");
		spellPut("246-242", "ni");
		spellPut("246-243", "nian");
		spellPut("246-244", "diao");
		spellPut("246-245", "shi");
		spellPut("246-246", "zi");
		spellPut("246-247", "fen");
		spellPut("246-248", "die");
		spellPut("246-249", "e");
		spellPut("246-250", "qiu");
		spellPut("246-251", "fu");
		spellPut("246-252", "huang");
		spellPut("246-253", "bian");
		spellPut("246-254", "sao");
	}

	private static void init109() {
		spellPut("247-64", "xi");
		spellPut("247-65", "qiu");
		spellPut("247-66", "piao");
		spellPut("247-67", "ji");
		spellPut("247-68", "ji");
		spellPut("247-69", "zhu");
		spellPut("247-70", "jiang");
		spellPut("247-71", "xiu");
		spellPut("247-72", "zhuan");
		spellPut("247-73", "yong");
		spellPut("247-74", "zhang");
		spellPut("247-75", "kang");
		spellPut("247-76", "xue");
		spellPut("247-77", "bie");
		spellPut("247-78", "yu");
		spellPut("247-79", "qu");
		spellPut("247-80", "xiang");
		spellPut("247-81", "bo");
		spellPut("247-82", "jiao");
		spellPut("247-83", "xun");
		spellPut("247-84", "su");
		spellPut("247-85", "huang");
		spellPut("247-86", "zun");
		spellPut("247-87", "shan");
		spellPut("247-88", "shan");
		spellPut("247-89", "fan");
		spellPut("247-90", "gui");
		spellPut("247-91", "lin");
		spellPut("247-92", "xun");
		spellPut("247-93", "yao");
		spellPut("247-94", "xi");
		spellPut("247-95", "Bi suo");
		spellPut("247-96", "ki ao");
		spellPut("247-97", "fen");
		spellPut("247-98", "guan");
		spellPut("247-99", "hou");
		spellPut("247-100", "kuai");
		spellPut("247-101", "zei");
		spellPut("247-102", "sao");
		spellPut("247-103", "zhan");
		spellPut("247-104", "gan");
		spellPut("247-105", "gui");
		spellPut("247-106", "ying");
		spellPut("247-107", "li");
		spellPut("247-108", "chang");
		spellPut("247-109", "ha ta ha ta");
		spellPut("247-110", "se");
		spellPut("247-111", "Bi");
		spellPut("247-112", "ru");
		spellPut("247-113", "ji");
		spellPut("247-114", "xu");
		spellPut("247-115", "hu");
		spellPut("247-116", "shi ra");
		spellPut("247-117", "li");
		spellPut("247-118", "lie");
		spellPut("247-119", "le");
		spellPut("247-120", "mie");
		spellPut("247-121", "zhen");
		spellPut("247-122", "xiang");
		spellPut("247-123", "e");
		spellPut("247-124", "lu");
		spellPut("247-125", "guan");
		spellPut("247-126", "li");
		spellPut("247-128", "xian");
		spellPut("247-129", "dao");
		spellPut("247-130", "ji");
		spellPut("247-131", "tun");
		spellPut("247-132", "ba");
		spellPut("247-133", "he,ge");
		spellPut("247-134", "you");
		spellPut("247-135", "zha");
		spellPut("247-136", "bo,ba");
		spellPut("247-137", "pi");
		spellPut("247-138", "kao");
		spellPut("247-139", "tong");
		spellPut("247-140", "zei");
		spellPut("247-141", "hou");
		spellPut("247-142", "kuai");
		spellPut("247-143", "zha");
		spellPut("247-144", "jun");
		spellPut("247-145", "yong");
		spellPut("247-146", "qi");
		spellPut("247-147", "shen");
		spellPut("247-148", "bi");
		spellPut("247-149", "chang");
		spellPut("247-150", "ti");
		spellPut("247-151", "wen");
		spellPut("247-152", "wei");
		spellPut("247-153", "quan");
		spellPut("247-154", "jiang");
		spellPut("247-155", "pang");
		spellPut("247-156", "jian");
		spellPut("247-157", "wei");
		spellPut("247-158", "xi");
		spellPut("247-159", "hu");
		spellPut("247-160", "gan");
		spellPut("247-161", "ao");
		spellPut("247-162", "qi");
		spellPut("247-163", "ta");
		spellPut("247-164", "guan");
		spellPut("247-165", "yao");
		spellPut("247-166", "le");
		spellPut("247-167", "biao");
		spellPut("247-168", "xue");
		spellPut("247-169", "man");
		spellPut("247-170", "min");
		spellPut("247-171", "yong");
		spellPut("247-172", "gui,jue");
		spellPut("247-173", "shan");
		spellPut("247-174", "zun");
		spellPut("247-175", "li");
		spellPut("247-176", "da");
		spellPut("247-177", "yang");
		spellPut("247-178", "da");
		spellPut("247-179", "qiao");
		spellPut("247-180", "man,men");
		spellPut("247-181", "jian");
		spellPut("247-182", "ju");
		spellPut("247-183", "rou");
		spellPut("247-184", "gou");
		spellPut("247-185", "bei");
		spellPut("247-186", "jie");
		spellPut("247-187", "tou");
		spellPut("247-188", "ku");
		spellPut("247-189", "gu");
		spellPut("247-190", "di");
		spellPut("247-191", "hou");
		spellPut("247-192", "ge");
		spellPut("247-193", "ke");
		spellPut("247-194", "bi");
		spellPut("247-195", "lou");
		spellPut("247-196", "qia");
		spellPut("247-197", "kuan");
		spellPut("247-198", "bin");
		spellPut("247-199", "du");
		spellPut("247-200", "mei");
		spellPut("247-201", "ba");
		spellPut("247-202", "yan");
		spellPut("247-203", "liang");
		spellPut("247-204", "xiao");
		spellPut("247-205", "wang");
		spellPut("247-206", "chi");
		spellPut("247-207", "xiang");
		spellPut("247-208", "yan");
		spellPut("247-209", "tie");
		spellPut("247-210", "tao");
		spellPut("247-211", "yong");
		spellPut("247-212", "biao");
		spellPut("247-213", "kun");
		spellPut("247-214", "mao");
		spellPut("247-215", "ran");
		spellPut("247-216", "tiao");
		spellPut("247-217", "ji");
		spellPut("247-218", "zi");
		spellPut("247-219", "xiu");
		spellPut("247-220", "quan");
		spellPut("247-221", "jiu");
		spellPut("247-222", "bin");
		spellPut("247-223", "huan");
		spellPut("247-224", "lie");
		spellPut("247-225", "mo,me");
		spellPut("247-226", "hui");
		spellPut("247-227", "mi");
		spellPut("247-228", "ji");
		spellPut("247-229", "jun,qun");
		spellPut("247-230", "zhu");
		spellPut("247-231", "mi");
		spellPut("247-232", "qi");
		spellPut("247-233", "ao");
		spellPut("247-234", "she");
		spellPut("247-235", "lin");
		spellPut("247-236", "dai");
		spellPut("247-237", "chu");
		spellPut("247-238", "you");
		spellPut("247-239", "xia");
		spellPut("247-240", "yi");
		spellPut("247-241", "qu");
		spellPut("247-242", "du");
		spellPut("247-243", "li");
		spellPut("247-244", "qing");
		spellPut("247-245", "can");
		spellPut("247-246", "an");
		spellPut("247-247", "fen");
		spellPut("247-248", "you");
		spellPut("247-249", "wu");
		spellPut("247-250", "yan");
		spellPut("247-251", "xi");
		spellPut("247-252", "qiu");
		spellPut("247-253", "han");
		spellPut("247-254", "zha");
	}

	private static void init110() {
		spellPut("248-64", "zhan,shan");
		spellPut("248-65", "guan");
		spellPut("248-66", "niao,diao");
		spellPut("248-67", "yi");
		spellPut("248-68", "fu");
		spellPut("248-69", "li");
		spellPut("248-70", "jiu");
		spellPut("248-71", "bu");
		spellPut("248-72", "yan");
		spellPut("248-73", "fu");
		spellPut("248-74", "diao,zhao");
		spellPut("248-75", "ji");
		spellPut("248-76", "feng");
		spellPut("248-77", "ni o");
		spellPut("248-78", "gan,han,yan");
		spellPut("248-79", "shi");
		spellPut("248-80", "feng");
		spellPut("248-81", "ming");
		spellPut("248-82", "bao");
		spellPut("248-83", "yuan");
		spellPut("248-84", "zhi");
		spellPut("248-85", "hu");
		spellPut("248-86", "qin");
		spellPut("248-87", "fu,gui");
		spellPut("248-88", "ban,fen");
		spellPut("248-89", "wen");
		spellPut("248-90", "jian,qian,zhan");
		spellPut("248-91", "shi");
		spellPut("248-92", "yu");
		spellPut("248-93", "fou");
		spellPut("248-94", "yao");
		spellPut("248-95", "jue");
		spellPut("248-96", "jue");
		spellPut("248-97", "pi");
		spellPut("248-98", "huan");
		spellPut("248-99", "zhen");
		spellPut("248-100", "bao");
		spellPut("248-101", "yan");
		spellPut("248-102", "ya");
		spellPut("248-103", "zheng");
		spellPut("248-104", "fang");
		spellPut("248-105", "feng");
		spellPut("248-106", "wen");
		spellPut("248-107", "ou");
		spellPut("248-108", "dai");
		spellPut("248-109", "jia");
		spellPut("248-110", "ru");
		spellPut("248-111", "ling");
		spellPut("248-112", "mie");
		spellPut("248-113", "fu");
		spellPut("248-114", "tuo");
		spellPut("248-115", "min");
		spellPut("248-116", "li");
		spellPut("248-117", "bian");
		spellPut("248-118", "zhi");
		spellPut("248-119", "ge");
		spellPut("248-120", "yuan");
		spellPut("248-121", "ci");
		spellPut("248-122", "qu");
		spellPut("248-123", "xiao");
		spellPut("248-124", "chi");
		spellPut("248-125", "dan");
		spellPut("248-126", "ju");
		spellPut("248-128", "yao");
		spellPut("248-129", "gu");
		spellPut("248-130", "zhong");
		spellPut("248-131", "yu");
		spellPut("248-132", "yang");
		spellPut("248-133", "yu");
		spellPut("248-134", "ya");
		spellPut("248-135", "die");
		spellPut("248-136", "yu");
		spellPut("248-137", "tiBn");
		spellPut("248-138", "ying");
		spellPut("248-139", "dui");
		spellPut("248-140", "wu");
		spellPut("248-141", "er");
		spellPut("248-142", "gua");
		spellPut("248-143", "ai");
		spellPut("248-144", "zhi");
		spellPut("248-145", "yan");
		spellPut("248-146", "heng");
		spellPut("248-147", "xiao");
		spellPut("248-148", "jia");
		spellPut("248-149", "lie");
		spellPut("248-150", "zhu");
		spellPut("248-151", "yang");
		spellPut("248-152", "yi");
		spellPut("248-153", "hong");
		spellPut("248-154", "lu");
		spellPut("248-155", "ru");
		spellPut("248-156", "mou");
		spellPut("248-157", "ge");
		spellPut("248-158", "ren");
		spellPut("248-159", "jiao");
		spellPut("248-160", "xiu");
	}

	private static void init111() {
		spellPut("249-64", "zhou");
		spellPut("249-65", "chi");
		spellPut("249-66", "luo");
		spellPut("249-67", "qi duo li");
		spellPut("249-68", "tuo ki");
		spellPut("249-69", "e");
		spellPut("249-70", "luan");
		spellPut("249-71", "jia");
		spellPut("249-72", "ji");
		spellPut("249-73", "tu");
		spellPut("249-74", "huan");
		spellPut("249-75", "tuo");
		spellPut("249-76", "bu");
		spellPut("249-77", "wu");
		spellPut("249-78", "jian");
		spellPut("249-79", "yu");
		spellPut("249-80", "bo");
		spellPut("249-81", "jun");
		spellPut("249-82", "jun");
		spellPut("249-83", "bi");
		spellPut("249-84", "xi");
		spellPut("249-85", "jun");
		spellPut("249-86", "ju");
		spellPut("249-87", "tu");
		spellPut("249-88", "jing");
		spellPut("249-89", "ti");
		spellPut("249-90", "e");
		spellPut("249-91", "e");
		spellPut("249-92", "kuang");
		spellPut("249-93", "hu");
		spellPut("249-94", "wu");
		spellPut("249-95", "shen");
		spellPut("249-96", "lai");
		spellPut("249-97", "zan");
		spellPut("249-98", "ka kai si");
		spellPut("249-99", "lu");
		spellPut("249-100", "pi");
		spellPut("249-101", "shu");
		spellPut("249-102", "fu");
		spellPut("249-103", "an");
		spellPut("249-104", "zhuo");
		spellPut("249-105", "peng");
		spellPut("249-106", "qin");
		spellPut("249-107", "qian");
		spellPut("249-108", "bei");
		spellPut("249-109", "diao");
		spellPut("249-110", "lu");
		spellPut("249-111", "que");
		spellPut("249-112", "jian");
		spellPut("249-113", "ju");
		spellPut("249-114", "tu");
		spellPut("249-115", "ya");
		spellPut("249-116", "yuan");
		spellPut("249-117", "qi");
		spellPut("249-118", "li");
		spellPut("249-119", "ye");
		spellPut("249-120", "zhui");
		spellPut("249-121", "kong");
		spellPut("249-122", "duo");
		spellPut("249-123", "kun");
		spellPut("249-124", "sheng");
		spellPut("249-125", "qi");
		spellPut("249-126", "jing");
		spellPut("249-128", "yi");
		spellPut("249-129", "yi");
		spellPut("249-130", "jing");
		spellPut("249-131", "zi");
		spellPut("249-132", "lai");
		spellPut("249-133", "dong");
		spellPut("249-134", "qi");
		spellPut("249-135", "chun");
		spellPut("249-136", "geng");
		spellPut("249-137", "ju");
		spellPut("249-138", "qu");
		spellPut("249-139", "yi si ka");
		spellPut("249-140", "ki ku yi ta da ki");
		spellPut("249-141", "ji");
		spellPut("249-142", "shu");
		spellPut("249-143", "ying");
		spellPut("249-144", "chi");
		spellPut("249-145", "miao");
		spellPut("249-146", "rou");
		spellPut("249-147", "an");
		spellPut("249-148", "qiu");
		spellPut("249-149", "ti,chi");
		spellPut("249-150", "hu");
		spellPut("249-151", "ti,chi");
		spellPut("249-152", "e");
		spellPut("249-153", "jie");
		spellPut("249-154", "mao");
		spellPut("249-155", "fu,bi");
		spellPut("249-156", "chun");
		spellPut("249-157", "tu");
		spellPut("249-158", "yan");
		spellPut("249-159", "he,jie");
		spellPut("249-160", "yuan");
	}

	private static void init112() {
		spellPut("250-64", "pian,bian");
		spellPut("250-65", "kun");
		spellPut("250-66", "mei");
		spellPut("250-67", "hu");
		spellPut("250-68", "ying");
		spellPut("250-69", "chuan,zhi");
		spellPut("250-70", "wu");
		spellPut("250-71", "ju");
		spellPut("250-72", "dong");
		spellPut("250-73", "cang,qiang");
		spellPut("250-74", "fang");
		spellPut("250-75", "he,hu");
		spellPut("250-76", "ying");
		spellPut("250-77", "yuan");
		spellPut("250-78", "xian");
		spellPut("250-79", "weng");
		spellPut("250-80", "shi");
		spellPut("250-81", "he");
		spellPut("250-82", "chu");
		spellPut("250-83", "tang");
		spellPut("250-84", "xia");
		spellPut("250-85", "ruo");
		spellPut("250-86", "liu");
		spellPut("250-87", "ji");
		spellPut("250-88", "gu,hu");
		spellPut("250-89", "jian");
		spellPut("250-90", "sun,xun");
		spellPut("250-91", "han");
		spellPut("250-92", "ci");
		spellPut("250-93", "ci");
		spellPut("250-94", "yi");
		spellPut("250-95", "yao");
		spellPut("250-96", "yan");
		spellPut("250-97", "ji");
		spellPut("250-98", "li");
		spellPut("250-99", "tian");
		spellPut("250-100", "kou");
		spellPut("250-101", "ti");
		spellPut("250-102", "ti");
		spellPut("250-103", "yi");
		spellPut("250-104", "tu");
		spellPut("250-105", "ma");
		spellPut("250-106", "xiao");
		spellPut("250-107", "gao");
		spellPut("250-108", "tian");
		spellPut("250-109", "chen");
		spellPut("250-110", "ji");
		spellPut("250-111", "tuan");
		spellPut("250-112", "zhe");
		spellPut("250-113", "ao");
		spellPut("250-114", "yao");
		spellPut("250-115", "yi");
		spellPut("250-116", "ou");
		spellPut("250-117", "chi");
		spellPut("250-118", "zhi");
		spellPut("250-119", "liu");
		spellPut("250-120", "yong");
		spellPut("250-121", "lou,lv");
		spellPut("250-122", "bi");
		spellPut("250-123", "shuang");
		spellPut("250-124", "zhuo");
		spellPut("250-125", "yu");
		spellPut("250-126", "wu");
		spellPut("250-128", "jue");
		spellPut("250-129", "yin");
		spellPut("250-130", "ti");
		spellPut("250-131", "si");
		spellPut("250-132", "jiao");
		spellPut("250-133", "yi");
		spellPut("250-134", "hua");
		spellPut("250-135", "bi");
		spellPut("250-136", "ying");
		spellPut("250-137", "su");
		spellPut("250-138", "huang");
		spellPut("250-139", "fan");
		spellPut("250-140", "jiao");
		spellPut("250-141", "liao");
		spellPut("250-142", "yan");
		spellPut("250-143", "gao");
		spellPut("250-144", "jiu");
		spellPut("250-145", "xian");
		spellPut("250-146", "xian");
		spellPut("250-147", "tu");
		spellPut("250-148", "mai");
		spellPut("250-149", "zun");
		spellPut("250-150", "yu");
		spellPut("250-151", "ying");
		spellPut("250-152", "lu");
		spellPut("250-153", "tuan");
		spellPut("250-154", "xian");
		spellPut("250-155", "xue");
		spellPut("250-156", "yi");
		spellPut("250-157", "pi");
		spellPut("250-158", "zhu");
		spellPut("250-159", "luo");
		spellPut("250-160", "xi");
	}

	private static void init113() {
		spellPut("251-64", "yi");
		spellPut("251-65", "ji");
		spellPut("251-66", "ze");
		spellPut("251-67", "yu");
		spellPut("251-68", "zhan");
		spellPut("251-69", "ye");
		spellPut("251-70", "yang");
		spellPut("251-71", "pi");
		spellPut("251-72", "ning");
		spellPut("251-73", "hu");
		spellPut("251-74", "mi");
		spellPut("251-75", "ying");
		spellPut("251-76", "meng");
		spellPut("251-77", "di");
		spellPut("251-78", "yue");
		spellPut("251-79", "yu");
		spellPut("251-80", "lei");
		spellPut("251-81", "bu");
		spellPut("251-82", "lu");
		spellPut("251-83", "he");
		spellPut("251-84", "long");
		spellPut("251-85", "shuang");
		spellPut("251-86", "yue");
		spellPut("251-87", "ying");
		spellPut("251-88", "guan");
		spellPut("251-89", "qu");
		spellPut("251-90", "li");
		spellPut("251-91", "luan");
		spellPut("251-92", "shi");
		spellPut("251-93", "cang");
		spellPut("251-94", "xiao");
		spellPut("251-95", "ling");
		spellPut("251-96", "xue");
		spellPut("251-97", "heng");
		spellPut("251-98", "zhou");
		spellPut("251-99", "wu");
		spellPut("251-100", "kun");
		spellPut("251-101", "qian");
		spellPut("251-102", "geng");
		spellPut("251-103", "yuan");
		spellPut("251-104", "su");
		spellPut("251-105", "he");
		spellPut("251-106", "qiu");
		spellPut("251-107", "yi");
		spellPut("251-108", "weng");
		spellPut("251-109", "liu");
		spellPut("251-110", "ji");
		spellPut("251-111", "yi");
		spellPut("251-112", "yi");
		spellPut("251-113", "huan");
		spellPut("251-114", "zhan");
		spellPut("251-115", "meng");
		spellPut("251-116", "shuang");
		spellPut("251-117", "lu");
		spellPut("251-118", "jin");
		spellPut("251-119", "ling");
		spellPut("251-120", "jian");
		spellPut("251-121", "xian");
		spellPut("251-122", "cuo");
		spellPut("251-123", "jian");
		spellPut("251-124", "jian");
		spellPut("251-125", "yan");
		spellPut("251-126", "you");
		spellPut("251-128", "cu");
		spellPut("251-129", "pao,biao");
		spellPut("251-130", "cu");
		spellPut("251-131", "pao");
		spellPut("251-132", "zhu,cu");
		spellPut("251-133", "jiBn");
		spellPut("251-134", "mi");
		spellPut("251-135", "yu");
		spellPut("251-136", "liu");
		spellPut("251-137", "chen");
		spellPut("251-138", "jun");
		spellPut("251-139", "lin");
		spellPut("251-140", "ni");
		spellPut("251-141", "jiu");
		spellPut("251-142", "jun");
		spellPut("251-143", "jing");
		spellPut("251-144", "li");
		spellPut("251-145", "xiang");
		spellPut("251-146", "xian");
		spellPut("251-147", "jia");
		spellPut("251-148", "mi");
		spellPut("251-149", "li");
		spellPut("251-150", "zhang");
		spellPut("251-151", "jing");
		spellPut("251-152", "qi");
		spellPut("251-153", "ling");
		spellPut("251-154", "yan");
		spellPut("251-155", "cu");
		spellPut("251-156", "mai");
		spellPut("251-157", "he");
		spellPut("251-158", "chao");
		spellPut("251-159", "fu");
		spellPut("251-160", "mian");
	}

	private static void init114() {
		spellPut("252-64", "mian");
		spellPut("252-65", "fu");
		spellPut("252-66", "pao");
		spellPut("252-67", "qu");
		spellPut("252-68", "qu");
		spellPut("252-69", "mou");
		spellPut("252-70", "fu");
		spellPut("252-71", "xian");
		spellPut("252-72", "lai");
		spellPut("252-73", "mian");
		spellPut("252-74", "chi");
		spellPut("252-75", "feng");
		spellPut("252-76", "qu");
		spellPut("252-77", "mian");
		spellPut("252-78", "mo,me");
		spellPut("252-79", "mi");
		spellPut("252-80", "zou");
		spellPut("252-81", "nun");
		spellPut("252-82", "fen");
		spellPut("252-83", "huang");
		spellPut("252-84", "jin");
		spellPut("252-85", "guang");
		spellPut("252-86", "tian");
		spellPut("252-87", "tou");
		spellPut("252-88", "hua");
		spellPut("252-89", "kuang");
		spellPut("252-90", "hong");
		spellPut("252-91", "chi");
		spellPut("252-92", "hei");
		spellPut("252-93", "yi");
		spellPut("252-94", "dan");
		spellPut("252-95", "xi");
		spellPut("252-96", "tun");
		spellPut("252-97", "mo");
		spellPut("252-98", "qian");
		spellPut("252-99", "dian");
		spellPut("252-100", "yan");
		spellPut("252-101", "mei");
		spellPut("252-102", "yan");
		spellPut("252-103", "yue");
		spellPut("252-104", "dang");
		spellPut("252-105", "yan");
		spellPut("252-106", "yan");
		spellPut("252-107", "yan");
		spellPut("252-108", "dan,shen");
		spellPut("252-109", "zhen,yan");
		spellPut("252-110", "dai");
		spellPut("252-111", "can");
		spellPut("252-112", "yi");
		spellPut("252-113", "mei");
		spellPut("252-114", "dan,zhan");
		spellPut("252-115", "yan");
		spellPut("252-116", "du");
		spellPut("252-117", "lu");
		spellPut("252-118", "fen");
		spellPut("252-119", "min,mian,meng");
		spellPut("252-120", "yuan");
		spellPut("252-121", "cu");
		spellPut("252-122", "qu");
		spellPut("252-123", "chao");
		spellPut("252-124", "wa");
		spellPut("252-125", "zhu");
		spellPut("252-126", "zhi");
		spellPut("252-128", "meng");
		spellPut("252-129", "ao");
		spellPut("252-130", "bie");
		spellPut("252-131", "tuo");
		spellPut("252-132", "bi");
		spellPut("252-133", "chao");
		spellPut("252-134", "mi");
		spellPut("252-135", "ding");
		spellPut("252-136", "zi");
		spellPut("252-137", "gu");
		spellPut("252-138", "dong");
		spellPut("252-139", "fen");
		spellPut("252-140", "yuan");
		spellPut("252-141", "chang");
		spellPut("252-142", "gao");
		spellPut("252-143", "cao");
		spellPut("252-144", "yuan");
		spellPut("252-145", "tang");
		spellPut("252-146", "teng");
		spellPut("252-147", "ne zu mi");
		spellPut("252-148", "fei");
		spellPut("252-149", "wen");
		spellPut("252-150", "ba");
		spellPut("252-151", "diao");
		spellPut("252-152", "tuo");
		spellPut("252-153", "zhong");
		spellPut("252-154", "qu");
		spellPut("252-155", "sheng");
		spellPut("252-156", "shi");
		spellPut("252-157", "shi");
		spellPut("252-158", "ting");
		spellPut("252-159", "ju");
		spellPut("252-160", "jing");
	}

	private static void init115() {
		spellPut("253-64", "hun");
		spellPut("253-65", "ju");
		spellPut("253-66", "yan");
		spellPut("253-67", "tu");
		spellPut("253-68", "si");
		spellPut("253-69", "xian");
		spellPut("253-70", "lei");
		spellPut("253-71", "yao");
		spellPut("253-72", "wu");
		spellPut("253-73", "wu");
		spellPut("253-74", "hou");
		spellPut("253-75", "xie");
		spellPut("253-76", "e");
		spellPut("253-77", "xiu");
		spellPut("253-78", "weng");
		spellPut("253-79", "zha");
		spellPut("253-80", "nong");
		spellPut("253-81", "nang");
		spellPut("253-82", "qi");
		spellPut("253-83", "zhai");
		spellPut("253-84", "ji");
		spellPut("253-85", "zi");
		spellPut("253-86", "ji");
		spellPut("253-87", "ji");
		spellPut("253-88", "chi");
		spellPut("253-89", "chen");
		spellPut("253-90", "chen");
		spellPut("253-91", "he");
		spellPut("253-92", "ya");
		spellPut("253-93", "yin");
		spellPut("253-94", "xie");
		spellPut("253-95", "bao");
		spellPut("253-96", "ze");
		spellPut("253-97", "xie");
		spellPut("253-98", "zi");
		spellPut("253-99", "chi");
		spellPut("253-100", "yan");
		spellPut("253-101", "ju");
		spellPut("253-102", "tiao");
		spellPut("253-103", "ling");
		spellPut("253-104", "ling");
		spellPut("253-105", "chu");
		spellPut("253-106", "quan");
		spellPut("253-107", "xie");
		spellPut("253-108", "yin");
		spellPut("253-109", "nie");
		spellPut("253-110", "jiu");
		spellPut("253-111", "yao");
		spellPut("253-112", "chuo");
		spellPut("253-113", "yun");
		spellPut("253-114", "yu");
		spellPut("253-115", "chu");
		spellPut("253-116", "yi");
		spellPut("253-117", "ni");
		spellPut("253-118", "ze");
		spellPut("253-119", "zou");
		spellPut("253-120", "qu");
		spellPut("253-121", "yun");
		spellPut("253-122", "yan");
		spellPut("253-123", "yu");
		spellPut("253-124", "e");
		spellPut("253-125", "wo");
		spellPut("253-126", "yi");
		spellPut("253-128", "ci");
		spellPut("253-129", "zou");
		spellPut("253-130", "dian");
		spellPut("253-131", "chu");
		spellPut("253-132", "jin");
		spellPut("253-133", "ya");
		spellPut("253-134", "he");
		spellPut("253-135", "yin,ken");
		spellPut("253-136", "long");
		spellPut("253-137", "pang");
		spellPut("253-138", "gong,wo");
		spellPut("253-139", "pang");
		spellPut("253-140", "yan");
		spellPut("253-141", "long");
		spellPut("253-142", "long");
		spellPut("253-143", "gong");
		spellPut("253-144", "kan");
		spellPut("253-145", "da");
		spellPut("253-146", "ling");
		spellPut("253-147", "da");
		spellPut("253-148", "gui,jun,qiu");
		spellPut("253-149", "qiu");
		spellPut("253-150", "bie");
		spellPut("253-151", "chui");
		spellPut("253-152", "he");
		spellPut("253-153", "jiao");
		spellPut("253-154", "xie");
	}

	/**
	 * 获得单个汉字的Ascii，并用"-"连接成一个字符串
	 * 
	 * @param cn char 汉字字符
	 * @return string 错误返回 空字符串,否则返回ascii
	 */
	public static String getCnAscii(char cn) {
		byte bytes[] = String.valueOf(cn).getBytes();
		System.out.println(bytes.length);
		if (bytes == null || bytes.length > 2 || bytes.length <= 0)
			return "";
		//如果是英文則不再進行轉換，直接返回
		if (bytes.length == 1)
			return new String(bytes);
		//中文則進行轉換
		if (bytes.length == 2) {
			int hightByte = 256 + bytes[0];
			int lowByte = 256 + bytes[1];
			String ascii = (new StringBuilder(String.valueOf(hightByte)))
					.append("-").append(lowByte).toString();
			System.out.println((new StringBuilder("ASCII=")).append(ascii)
					.toString());
			return ascii;
		} else {
			return "";
		}
	}

	/**
	 * 根据ASCII码连接成的字符串到SpellMap中查找对应的拼音
	 * 
	 * @param ascii 字符对应的ASCII连接的字符串
	 * @return String 拼音,首先判断是否是中文如果是英文直接返回字符，如果是中文返回拼音,
	 * 
	 * 否则到SpellMap中查找,如果没有找到拼音,则返回null,如果找到则返回拼音.
	 */
	public static String getSpellByAscii(String ascii) {
		if (ascii.indexOf("-") > -1)
			return (String) spellMap.get(ascii);
		else
			return ascii;
	}

	/**
	 * 返回字符串的全拼,是汉字转化为全拼,其它字符不进行转换
	 * 
	 * @param cnStr String字符串
	 * @return String 转换成全拼后的字符串
	 */
	public static String getFullSpell(String cnStr) {
		if (cnStr == null || "".equals(cnStr.trim()))
			return cnStr;
		char chars[] = cnStr.toCharArray();
		StringBuffer retuBuf = new StringBuffer();
		int i = 0;
		for (int Len = chars.length; i < Len; i++) {
			String ascii = getCnAscii(chars[i]);
			if (ascii.length() == 0) {//獲取AscII碼出錯
				retuBuf.append(chars[i]);
			} else {
				String spell = getSpellByAscii(ascii);
				if (spell == null)
					retuBuf.append(chars[i]);
				else
					retuBuf.append(spell);
			}
		}

		return retuBuf.toString();
	}

	/**
	 * 获取汉语字符串的声母组合，每个汉字取拼音的第一个字符组成的一个字符串
	 * @param cnStr 汉字的字符串
	 * @return 每个汉字拼音的第一个字母所组成的汉字
	 */
	public static String getFirstSpell(String cnStr) {
		if (cnStr == null || "".equals(cnStr.trim()))
			return cnStr;
		char chars[] = cnStr.toCharArray();
		StringBuffer retuBuf = new StringBuffer();
		int i = 0;
		for (int Len = chars.length; i < Len; i++) {
			String ascii = getCnAscii(chars[i]);
			System.out.println(ascii);
			if (ascii.length() == 1) {
				retuBuf.append(chars[i]);
			} else {
				String spell = getSpellByAscii(ascii).substring(0, 1);
				System.out.println(spell);
				if (spell == null)
					retuBuf.append(chars[i]);
				else
					retuBuf.append(spell);
			}
		}

		return retuBuf.toString();
	}

	public static void main(String args[]) {
		//		Date start = new Date();
		//		System.out.println(start.getTime());
		long t1 = System.currentTimeMillis();

		String str = null;
		//		str = "我 们 乐";
		//		str="逯 闫 艾 涝 汶";
		str = "四国岛兵库县京都府中京区大宫道15町2所靳冰漩";
		System.out.println((new StringBuilder("Spell=")).append(
				getFullSpell(str)).toString());
		System.out.println((new StringBuilder("Spell=")).append(
				getFirstSpell(str)).toString());
		//		Date end = new Date();
		//		System.out.println(end.getTime());
		long t2 = System.currentTimeMillis();

		System.out.println(t2 - t1);
	}

	static {
		spellMap = null;
		if (spellMap == null)
			spellMap = new LinkedHashMap<String, String>(20901);
		initialize();
	}
}