/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.table.structure;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.oiue.table.structure.Field;
import org.oiue.table.structure.ForeignField;
import org.oiue.table.structure.Table;
import org.oiue.table.structure.TableModel;
import org.oiue.tools.list.ListUtil;

public class TableExt
extends Table
implements Serializable {
    String parentAutoCode = "";

    public TableModel convertTM(TableModel tm) {
        tm.put("filedName", this.getName());
        tm.put("autoCode", this.getParentAutoCode());
        tm.put("name", this.getComment());
        tm.put("description", this.getComment());
        return tm;
    }

    public String getParentAutoCode() {
        return this.parentAutoCode;
    }

    public void setParentAutoCode(String parentAutoCode) {
        this.parentAutoCode = parentAutoCode;
    }

    public TableExt() {
        this("", "");
    }

    public TableExt(String name) {
        this(name, "");
    }

    public TableExt(String name, String id) {
        this(name, id, "");
    }

    public TableExt(String name, String id, String idGenerator) {
        super(name, id, idGenerator);
    }

    @Override
    public String toString() {
        return "TABLE\tname=" + this.getTableName() + ";field number=" + this.getFields().size() + ";pk field number=" + this.getPrimaryField().size() + ";id=" + this.getId() + ";generator=" + this.getIdGenerator();
    }

    public void addField(String key, Field field) {
        super.getFields().put(key, field);
    }

    public void removeField(String fieldName) {
        super.getFields().remove(fieldName);
    }

    public Field findField(String fieldName) {
        return super.getFields().get(fieldName);
    }

    public Field findFieldIgnoreCase(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (Field field : super.getFields().values()) {
            if (!fieldName.equalsIgnoreCase(field.getName())) continue;
            return field;
        }
        return null;
    }

    public Field getField(String popertyName) {
        Field filed = this.findField(popertyName);
        if (filed == null) {
            filed = this.findForeignFiled(popertyName);
        }
        return filed;
    }

    public Map<String, Field> getAllFields() {
        HashMap<String, Field> ret = new HashMap<String, Field>(super.getFields());
        ret.putAll(super.getPrimaryField());
        return ret;
    }

    public void addForeignFiled(String name, ForeignField Field2) {
        super.getForeignField().put(name, Field2);
    }

    public ForeignField findForeignFiled(String popertyName) {
        return super.getForeignField().get(popertyName);
    }

    public void addPrimaryField(String name) {
        if (super.getPrimaryField().get(name) == null && this.getFields().get(name) != null) {
            super.getPrimaryField().put(name, this.getFields().get(name));
            super.getFields().remove(name);
        }
    }

    public void addPrimaryField(String name, Field field) {
        super.getPrimaryField().put(name, field);
    }

    public String getPrimaryStr() {
        if (this.getPrimaryField().size() > 1) {
            return ListUtil.ArrayJoin(this.getPrimaryField().keySet().toArray(), ",");
        }
        return this.getId();
    }

    public Field getKeyField() {
        return super.getFields().get(super.getId());
    }

    public void setLazy(String lazy) {
        if (lazy != null && lazy.equalsIgnoreCase("true")) {
            super.setLazy(true);
        } else {
            super.setLazy(false);
        }
    }

    public void concat(Table table) {
        super.getFields().putAll(table.getFields());
        super.getForeignField().putAll(table.getForeignField());
        if ("".equals(super.getName())) {
            super.setName(table.getName());
        }
        if ("".equals(super.getId())) {
            super.setId(table.getId());
        }
        if ("".equals(super.getIdGenerator())) {
            super.setIdGenerator(table.getIdGenerator());
        }
    }

    public Map getFields(int key) {
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        for (String fieldName : super.getFields().keySet()) {
            Field field = super.getFields().get(fieldName);
            if (field.getCmdKey() == key) {
                fieldMap.put(fieldName, field);
                continue;
            }
            if (key >= 0 || field.getCmdKey() <= 0) continue;
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }
}

