/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.bytes;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ByteUtil {
    private static final char[] HEX_UPPERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] getBytesGBK(String src) {
        if (src == null) {
            throw new IllegalArgumentException("src\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return src.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("\u4e0d\u652f\u6301GBK\u7f16\u7801\uff1a" + e.getMessage());
        }
    }

    public static boolean startsWith(byte[] src, byte[] starts) {
        if (src == null || starts == null || src.length < starts.length) {
            return false;
        }
        for (int i = 0; i < starts.length; ++i) {
            if ((src[i] & 0xFF) == (starts[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public static byte[] long2bytes(long v, int len) {
        byte[] b = new byte[len];
        for (int i = 7; i > 0 && i > 8 - len; --i) {
            b[i - (8 - len)] = (byte)(v >>> 56 - i * 8);
        }
        return b;
    }

    public static byte[] double2bytes(double v, int len) {
        byte[] b = new byte[len];
        long l = Double.doubleToLongBits(v);
        for (int i = 0; i < len && i < 8; ++i) {
            b[i] = new Long(l).byteValue();
            l >>= 8;
        }
        return b;
    }

    public static byte[] long2bytes(long v) {
        return ByteUtil.long2bytes(v, 8);
    }

    public static long bytes2long(byte[] bs) {
        long rl = 0L;
        if (bs == null) {
            throw new NullPointerException("\u5b57\u8282\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bs.length > 8) {
            throw new IllegalArgumentException("\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u8d85\u8fc78\u4e2a\u5b57\u8282\uff0c\u4e0d\u80fd\u8f6c\u6362\u6210long\u7c7b\u578b\uff1a" + ByteUtil.toHexString(bs));
        }
        for (int i = 0; i < bs.length; ++i) {
            rl += (long)((bs[i] & 0xFF) << 56 - i * 8);
        }
        return rl;
    }

    public static byte[] int2bytes(int v, int len) throws IllegalArgumentException {
        if (len <= 0 || len > 4) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e4\uff1a" + len);
        }
        byte[] tmp = new byte[4];
        switch (len) {
            case 4: {
                tmp[0] = (byte)(v >>> 24 & 0xFF);
            }
            case 3: {
                tmp[1] = (byte)(v >>> 16 & 0xFF);
            }
            case 2: {
                tmp[2] = (byte)(v >>> 8 & 0xFF);
            }
            case 1: {
                tmp[3] = (byte)v;
            }
        }
        byte[] ret = new byte[len];
        System.arraycopy(tmp, 4 - len, ret, 0, len);
        return ret;
    }

    public static int bytes2Int(byte ... b) throws NullPointerException, IllegalArgumentException {
        return ByteUtil.bytes2Int(b, 0);
    }

    public static int bytes2Int(byte[] b, int pos) throws NullPointerException, IllegalArgumentException {
        if (b == null) {
            throw new NullPointerException("\u5b57\u8282\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (b.length - pos < 4) {
            return ByteUtil.bytes2Int(b, pos, b.length - pos);
        }
        return ByteUtil.bytes2Int(b, pos, 4);
    }

    public static int bytes2Int(byte[] b, int pos, int len) {
        if (b == null) {
            throw new NullPointerException("\u5b57\u8282\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pos < 0 || len <= 0 || len > 4 || pos + len > b.length) {
            throw new IllegalArgumentException("pos(" + pos + ") < 0 || len(" + len + ") <= 0 || len > 4 || (pos + len) > b.length(" + b.length + ")");
        }
        int v = 0;
        switch (len) {
            case 4: {
                v |= b[pos++] << 24 & 0xFF000000;
            }
            case 3: {
                v |= b[pos++] << 16 & 0xFF0000;
            }
            case 2: {
                v |= b[pos++] << 8 & 0xFF00;
            }
            case 1: {
                v |= b[pos++] & 0xFF;
            }
        }
        return v;
    }

    public static int bcdBytes2Int(byte ... bs) throws NullPointerException, IllegalArgumentException {
        if (bs == null) {
            throw new NullPointerException("\u5b57\u8282\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bs.length > 4) {
            throw new IllegalArgumentException("\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u8d85\u8fc74\u4e2a\u5b57\u8282\uff0c\u4e0d\u80fd\u8f6c\u6362\u6210Int\u7c7b\u578b\uff1a" + ByteUtil.toHexString(bs));
        }
        return Integer.parseInt(ByteUtil.bcdBytes2Str(bs));
    }

    private static byte int2bcdByte(int hRadix10, int lRadix10) {
        int bcd = ((hRadix10 & 0xF) << 4) + (lRadix10 & 0xF);
        return (byte)bcd;
    }

    public static String bcdBytes2Str(byte b) throws IllegalArgumentException {
        int high4 = (b & 0xF0) >>> 4;
        int low4 = b & 0xF;
        if (high4 >= 10 || low4 >= 10) {
            throw new IllegalArgumentException("BCD\u7801\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u6709\u5927\u4e8e9\u7684\u503c\uff1a" + ByteUtil.hex(b, true));
        }
        return String.valueOf(high4) + String.valueOf(low4);
    }

    public static String bcdBytes2Str(byte ... bs) throws IllegalArgumentException {
        if (bs == null || bs.length <= 0) {
            throw new IllegalArgumentException("\u5b57\u8282\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u957f\u5ea6\u4e0d\u80fd\u4e3a0:" + bs == null ? "null" : String.valueOf(bs.length));
        }
        StringBuilder bcd = new StringBuilder();
        try {
            for (byte b : bs) {
                int high4 = (b & 0xF0) >>> 4;
                int low4 = b & 0xF;
                if (high4 >= 10 || low4 >= 10) {
                    throw new IllegalArgumentException("BCD\u7801\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u6709\u5927\u4e8e9\u7684\u503c\uff1a" + Integer.toHexString(b & 0xFF));
                }
                bcd.append(high4).append(low4);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u8f6c\u6362BCD\u7801\u5931\u8d25\uff1a" + ByteUtil.toHexString(bs) + " " + e.getMessage());
        }
        return bcd.toString();
    }

    public static byte[] str2bcdBytes(String radix10Str, int len) {
        if (radix10Str == null) {
            throw new NullPointerException("radix10Str\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (radix10Str.length() != len * 2) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u957f\u5ea6\u4e0e\u5b57\u8282\u957f\u5ea6\u4e0d\u4e00\u81f4\uff1a" + radix10Str + ", \u5b57\u8282\u957f\u5ea6" + len + " * 2");
        }
        return ByteUtil.str2bcdBytes(radix10Str, len, 0);
    }

    public static byte[] str2bcdBytes(String radix10Str, int len, int additional) {
        if (len <= 0) {
            throw new IllegalArgumentException("len\u5fc5\u987b\u5927\u4e8e0\uff1a" + len);
        }
        int bcdLen = len * 2;
        if (radix10Str == null || radix10Str.length() > bcdLen) {
            throw new IllegalArgumentException("10\u8fdb\u5236\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e\u9650\u5b9a\u7684len: " + radix10Str + (radix10Str == null ? "" : ", " + bcdLen));
        }
        if (additional < 0 || additional > 9) {
            throw new IllegalArgumentException("\u4f4d\u6570\u4e0d\u8db3\u65f6\u7684\u8865\u5145\u5185\u5bb9\u53ea\u80fd\u4e3a0\uff5e9\uff1a" + additional);
        }
        if (!radix10Str.matches("\\d*")) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e2d\u542b\u6709\u975e\u6570\u5b57\u5185\u5bb9\uff1a" + radix10Str);
        }
        int[] radix10Int = new int[bcdLen];
        int addLen = radix10Int.length - radix10Str.length();
        int radix10StrIndex = 0;
        for (int i = 0; i < radix10Int.length; ++i) {
            radix10Int[i] = i < addLen ? additional : Character.digit(radix10Str.charAt(radix10StrIndex++), 10);
        }
        byte[] bcd = new byte[len];
        int i = len - 1;
        int j = radix10Int.length - 1;
        while (i >= 0) {
            bcd[i] = ByteUtil.int2bcdByte(radix10Int[j - 1], radix10Int[j]);
            --i;
            j -= 2;
        }
        return bcd;
    }

    public static byte[] join(byte[] s, byte[] d) {
        if (d == null) {
            return s;
        }
        if (s == null) {
            return d;
        }
        byte[] rtn = new byte[s.length + d.length];
        System.arraycopy(s, 0, rtn, 0, s.length);
        System.arraycopy(d, 0, rtn, s.length, d.length);
        return rtn;
    }

    public static int charAtReverseNot0(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] == 0) continue;
            return i;
        }
        return 0;
    }

    private static char hex(int val, boolean upCase) {
        switch (val) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return upCase ? (char)'A' : 'a';
            }
            case 11: {
                return upCase ? (char)'B' : 'b';
            }
            case 12: {
                return upCase ? (char)'C' : 'c';
            }
            case 13: {
                return upCase ? (char)'D' : 'd';
            }
            case 14: {
                return upCase ? (char)'E' : 'e';
            }
            case 15: {
                return upCase ? (char)'F' : 'f';
            }
        }
        throw new IllegalArgumentException("val\u5fc5\u987b\u4e3a0\uff5e15\u7684\u6570\u503c\uff1a" + val);
    }

    public static String toHexString(byte ... bytes) {
        if (bytes == null) {
            return "";
        }
        return ByteUtil.toHexString(bytes, ' ', 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, char separated, int pos, int len) {
        if (bytes == null || bytes.length <= 0 || len == 0) {
            return "";
        }
        if (pos < 0 || len < 0 || pos + len > bytes.length) {
            throw new IllegalArgumentException("\u53c2\u6570\u8303\u56f4\u9519\u8bef\uff1apos(" + pos + ") < 0 || len(" + len + ") < 0 || (pos + len) > bytes.length(" + bytes.length + ")");
        }
        StringBuilder hexStr = new StringBuilder();
        for (int i = pos; i < pos + len; ++i) {
            char h4 = HEX_UPPERCASE[(bytes[i] & 0xF0) >>> 4];
            char l4 = HEX_UPPERCASE[bytes[i] & 0xF];
            hexStr.append(h4).append(l4).append(separated);
        }
        hexStr.deleteCharAt(hexStr.length() - 1);
        return hexStr.toString();
    }

    public static String toHexString(ByteBuffer buf) {
        return ByteUtil.toHexString(buf, buf.position(), buf.remaining());
    }

    public static String toHexString(ByteBuffer buf, int pos, int len) {
        if (buf == null || buf.capacity() <= 0 || len == 0) {
            return "";
        }
        if (pos < 0 || len < 0 || pos + len > buf.capacity()) {
            throw new IllegalArgumentException("\u53c2\u6570\u8303\u56f4\u9519\u8bef\uff1apos(" + pos + ") < 0 || len(" + len + ") < 0 || (pos + len) > bytes.length(" + buf.capacity() + ")");
        }
        StringBuilder hexStr = new StringBuilder();
        for (int i = pos; i < pos + len; ++i) {
            byte b = buf.get(i);
            char h4 = HEX_UPPERCASE[(b & 0xF0) >>> 4];
            char l4 = HEX_UPPERCASE[b & 0xF];
            hexStr.append(h4).append(l4).append(' ');
        }
        hexStr.deleteCharAt(hexStr.length() - 1);
        return hexStr.toString();
    }

    public static byte[] toBytes4HexString(String str) {
        if (str == null) {
            return new byte[0];
        }
        String[] strArr = str.split(" ");
        byte[] array = new byte[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            array[i] = (byte)Integer.parseInt(strArr[i], 16);
        }
        return array;
    }
}

