/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.date;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.oiue.tools.date.TimeUtil;

public class DateUtil
extends TimeUtil {
    public static boolean isStartDateBeforeEndDate(Date p_startDate, Date p_endDate) throws ParseException {
        long l_endTime;
        long l_startTime = DateUtil.getMillisOfDate(p_startDate);
        return l_startTime - (l_endTime = DateUtil.getMillisOfDate(p_endDate)) > 0L;
    }

    public static long getDaysOfTowDiffDate(String p_startDate, String p_endDate) throws ParseException {
        Date l_startDate = DateUtil.toUtilDateFromStrDateByFormat(p_startDate, "yyyy-MM-dd");
        Date l_endDate = DateUtil.toUtilDateFromStrDateByFormat(p_endDate, "yyyy-MM-dd");
        long l_startTime = DateUtil.getMillisOfDate(l_startDate);
        long l_endTime = DateUtil.getMillisOfDate(l_endDate);
        long betweenDays = (l_endTime - l_startTime) / 86400000L;
        return betweenDays;
    }

    public static long getWeeksOfTowDiffDate(String p_startDate, String p_endDate) throws ParseException {
        return DateUtil.getDaysOfTowDiffDate(p_startDate, p_endDate) / 7L;
    }

    public static long getMonthsOfTowDiffDate(String p_startDate, String p_endDate) throws ParseException {
        return DateUtil.getDaysOfTowDiffDate(p_startDate, p_endDate) / 30L;
    }

    public static long getYearsOfTowDiffDate(String p_startDate, String p_endDate) throws ParseException {
        return DateUtil.getDaysOfTowDiffDate(p_startDate, p_endDate) / 365L;
    }

    public static String addDate(Date p_startDate, Integer p_count, Integer p_field, String p_format) throws ParseException {
        if (p_startDate == null) {
            p_startDate = new Date();
        }
        int l_year = DateUtil.getYearOfDate(p_startDate);
        int l_month = DateUtil.getMonthOfDate(p_startDate) - 1;
        int l_day = DateUtil.getDayOfDate(p_startDate);
        int l_hour = DateUtil.getHourOfDate(p_startDate);
        int l_minute = DateUtil.getMinuteOfDate(p_startDate);
        int l_second = DateUtil.getSecondOfDate(p_startDate);
        GregorianCalendar l_calendar = new GregorianCalendar(l_year, l_month, l_day, l_hour, l_minute, l_second);
        ((Calendar)l_calendar).add(p_field, p_count);
        return DateUtil.toStrDateFromUtilDateByFormat(l_calendar.getTime(), p_format);
    }

    public static Date addDate(Date p_startDate, Integer p_count, Integer p_field) throws ParseException {
        if (p_startDate == null) {
            p_startDate = new Date();
        }
        int l_year = DateUtil.getYearOfDate(p_startDate);
        int l_month = DateUtil.getMonthOfDate(p_startDate) - 1;
        int l_day = DateUtil.getDayOfDate(p_startDate);
        int l_hour = DateUtil.getHourOfDate(p_startDate);
        int l_minute = DateUtil.getMinuteOfDate(p_startDate);
        int l_second = DateUtil.getSecondOfDate(p_startDate);
        GregorianCalendar l_calendar = new GregorianCalendar(l_year, l_month, l_day, l_hour, l_minute, l_second);
        ((Calendar)l_calendar).add(p_field, p_count);
        return l_calendar.getTime();
    }

    public static boolean isLeapYear(Date p_date) {
        int l_year = DateUtil.getYearOfDate(p_date);
        GregorianCalendar l_calendar = new GregorianCalendar();
        return l_calendar.isLeapYear(l_year);
    }

    public static Date getAnotherDate(Date date, int num) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(6, num);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(Date date) throws ParseException {
        String strDate = DateUtil.addDate(date, 1, 2, "yyyy-MM") + "-01 00:00:00";
        strDate = DateUtil.addDate(DateUtil.parseStringToMysqlDate(strDate), -1, 5, "yyyy-MM-dd HH:mm:ss");
        return DateUtil.parseStringToMysqlDate(strDate);
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(date);
        return c.get(3);
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static int getMaxWeekNumOfYear(int year) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        return DateUtil.getWeekOfYear(c.getTime());
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        Calendar calFirst = Calendar.getInstance();
        calFirst.set(year, 0, 7);
        Date firstDate = DateUtil.getFirstDayOfWeek(calFirst.getTime());
        Calendar firstDateCal = Calendar.getInstance();
        firstDateCal.setTime(firstDate);
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, firstDateCal.get(5));
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, (week - 1) * 7);
        firstDate = DateUtil.getFirstDayOfWeek(cal.getTime());
        return firstDate;
    }

    public static Date getLastDayOfWeek(int year, int week) {
        Calendar calLast = Calendar.getInstance();
        calLast.set(year, 0, 7);
        Date firstDate = DateUtil.getLastDayOfWeek(calLast.getTime());
        Calendar firstDateCal = Calendar.getInstance();
        firstDateCal.setTime(firstDate);
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, firstDateCal.get(5));
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, (week - 1) * 7);
        Date lastDate = DateUtil.getLastDayOfWeek(cal.getTime());
        return lastDate;
    }
}

