/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.date;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.oiue.tools.date.StringForDate;

public class TimeUtil
extends StringForDate {
    public static Calendar now = Calendar.getInstance();
    int year = now.get(1);
    int date = now.get(5);
    int month = now.get(2) + 1;
    int hour = now.get(10);
    int min = now.get(12);
    int sec = now.get(13);

    public static Date toUtilDateFromStrDateByFormat(String p_strDate, String p_format) throws ParseException {
        Date l_date = null;
        SimpleDateFormat df = new SimpleDateFormat(p_format);
        if (p_strDate != null && !"".equals(p_strDate) && p_format != null && !"".equals(p_format)) {
            l_date = df.parse(p_strDate);
        }
        return l_date;
    }

    public static java.sql.Date toSqlDateFromStrDate(String p_strDate) throws ParseException {
        java.sql.Date returnDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (p_strDate != null && !"".equals(p_strDate)) {
            returnDate = new java.sql.Date(sdf.parse(p_strDate).getTime());
        }
        return returnDate;
    }

    public static String toStrDateFromUtilDateByFormat(Date p_utilDate, String p_format) throws ParseException {
        String l_result = "";
        if (p_utilDate != null) {
            TimeZone tz = TimeZone.getTimeZone("Asia/Shanghai");
            SimpleDateFormat sdf = new SimpleDateFormat(p_format);
            sdf.setTimeZone(tz);
            long offset = tz.getOffset(p_utilDate.getTime());
            p_utilDate.setTime(p_utilDate.getTime() - offset);
            l_result = sdf.format(p_utilDate);
        }
        return l_result;
    }

    public static Calendar toCalendarFromUtilDate(Date p_utilDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_utilDate);
        return c;
    }

    public static java.sql.Date toSqlDateFromUtilDate(Date p_utilDate) {
        java.sql.Date returnDate = null;
        if (p_utilDate != null) {
            returnDate = new java.sql.Date(p_utilDate.getTime());
        }
        return returnDate;
    }

    public static Time toSqlTimeFromUtilDate(Date p_utilDate) {
        Time returnDate = null;
        if (p_utilDate != null) {
            returnDate = new Time(p_utilDate.getTime());
        }
        return returnDate;
    }

    public static Timestamp toSqlTimestampFromUtilDate(Date p_utilDate) {
        Timestamp returnDate = null;
        if (p_utilDate != null) {
            returnDate = new Timestamp(p_utilDate.getTime());
        }
        return returnDate;
    }

    public static Date toUtilDateFromSqlDate(java.sql.Date p_sqlDate) {
        Date returnDate = null;
        if (p_sqlDate != null) {
            returnDate = new Date(p_sqlDate.getTime());
        }
        return returnDate;
    }

    public static int getYearOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.get(1);
    }

    public static int getMonthOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.get(2) + 1;
    }

    public static int getDayOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.get(5);
    }

    public static int getHourOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.get(11);
    }

    public static int getMinuteOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.get(12);
    }

    public static int getSecondOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.get(13);
    }

    public static long getMillisOfDate(Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.getTimeInMillis();
    }

    public static String getNowOfDateByFormat(String p_format) {
        if (!TimeZone.getDefault().getID().equals("Asia/Shanghai")) {
            System.out.println("\u65f6\u533a\u4e0d\u662f\u4e2d\u56fd\u6807\u51c6\u65f6\u533a\uff0c\u662f" + TimeZone.getDefault().getDisplayName());
        }
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(p_format);
        String dateStr = sdf.format(d);
        return dateStr;
    }

    public static String getStrTimeByUTC(long utc, String format) {
        return new SimpleDateFormat(format).format(new Date(utc));
    }

    public static String getYesterdayOfDateByFormat(String p_format) {
        if (!TimeZone.getDefault().getID().equals("Asia/Shanghai")) {
            System.out.println("\u65f6\u533a\u4e0d\u662f\u4e2d\u56fd\u6807\u51c6\u65f6\u533a\uff0c\u662f" + TimeZone.getDefault().getDisplayName());
        }
        Date p_startDate = new Date();
        int l_year = TimeUtil.getYearOfDate(p_startDate);
        int l_month = TimeUtil.getMonthOfDate(p_startDate) - 1;
        int l_day = TimeUtil.getDayOfDate(p_startDate);
        int l_hour = TimeUtil.getHourOfDate(p_startDate);
        int l_minute = TimeUtil.getMinuteOfDate(p_startDate);
        int l_second = TimeUtil.getSecondOfDate(p_startDate);
        GregorianCalendar l_calendar = new GregorianCalendar(l_year, l_month, l_day, l_hour, l_minute, l_second);
        ((Calendar)l_calendar).add(3, -1);
        SimpleDateFormat sdf = new SimpleDateFormat(p_format);
        String dateStr = sdf.format(l_calendar.getTime());
        return dateStr;
    }

    public static String getSystemOfDateByFormat(String p_format) {
        long time = System.currentTimeMillis();
        Date d2 = new Date();
        Date d = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat(p_format);
        String dateStr = sdf.format(d);
        return dateStr;
    }

    public static long getDayOfMonth(Date p_date) throws ParseException {
        int year = TimeUtil.getYearOfDate(p_date);
        int month = TimeUtil.getMonthOfDate(p_date) - 1;
        int day = TimeUtil.getDayOfDate(p_date);
        int hour = TimeUtil.getHourOfDate(p_date);
        int minute = TimeUtil.getMinuteOfDate(p_date);
        int second = TimeUtil.getSecondOfDate(p_date);
        GregorianCalendar l_calendar = new GregorianCalendar(year, month, day, hour, minute, second);
        return ((Calendar)l_calendar).getActualMaximum(5);
    }

    public static String getDateOfMonthBegin(String p_strDate, String p_format) throws ParseException {
        Date date = TimeUtil.toUtilDateFromStrDateByFormat(p_strDate, p_format);
        return TimeUtil.toStrDateFromUtilDateByFormat(date, "yyyy-MM") + "-01";
    }

    public static String getDateOfMonthEnd(String p_strDate, String p_format) throws ParseException {
        Date date = TimeUtil.toUtilDateFromStrDateByFormat(TimeUtil.getDateOfMonthBegin(p_strDate, p_format), p_format);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.add(6, -1);
        return TimeUtil.toStrDateFromUtilDateByFormat(calendar.getTime(), p_format);
    }

    public static long getHoursOfTowDiffDate(String p_startDate, String p_endDate) throws Throwable {
        return TimeUtil.getMillisOfTowDiffDate(p_startDate, p_endDate) / 3600000L;
    }

    public static long getMinutesOfTowDiffDate(String p_startDate, String p_endDate) throws Throwable {
        return TimeUtil.getMillisOfTowDiffDate(p_startDate, p_endDate) / 60000L;
    }

    public static long getSecondsOfTowDiffDate(String p_startDate, String p_endDate) throws Throwable {
        return TimeUtil.getMillisOfTowDiffDate(p_startDate, p_endDate) / 1000L;
    }

    public static long getMillisOfTowDiffDate(String p_startDate, String p_endDate) throws Throwable {
        Date l_startDate = TimeUtil.toUtilDateFromStrDateByFormat(p_startDate, "yyyy-MM-dd HH:mm:ss");
        Date l_endDate = TimeUtil.toUtilDateFromStrDateByFormat(p_endDate, "yyyy-MM-dd HH:mm:ss");
        long l_startTime = TimeUtil.getMillisOfDate(l_startDate);
        long l_endTime = TimeUtil.getMillisOfDate(l_endDate);
        return l_endTime - l_startTime;
    }

    public static long getMillisOfTowDiffDate(Date p_startDate, Date p_endDate) throws Throwable {
        long l_startTime = TimeUtil.getMillisOfDate(p_startDate);
        long l_endTime = TimeUtil.getMillisOfDate(p_endDate);
        return l_endTime - l_startTime;
    }

    public static long getSeconds() throws Throwable {
        return TimeUtil.getMillisOfTowDiffDate(TimeUtil.getNowOfDateByFormat("yyyy-MM-dd 00:00:00"), TimeUtil.getNowOfDateByFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

