/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class WeekdayUtil {
    private static List<String> _WeekendIsWork;
    private static List<String> _WeekdayIsHoliday;

    public List<String> getWeekendIsWork() {
        return _WeekendIsWork;
    }

    public void setWeekendIsWork(List<String> _WeekendIsWork) {
        WeekdayUtil._WeekendIsWork = _WeekendIsWork;
    }

    public List<String> getWeekdayIsHoliday() {
        return _WeekdayIsHoliday;
    }

    public void setWeekdayIsHoliday(List<String> _WeekdayIsHoliday) {
        WeekdayUtil._WeekdayIsHoliday = _WeekdayIsHoliday;
    }

    public boolean compareWeekday(String beforeDate, String afterDate, int deadline) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date d1 = sdf.parse(beforeDate);
            Date d2 = sdf.parse(afterDate);
            int workDay = 0;
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d1);
            long time = d2.getTime() - d1.getTime();
            long day = time / 3600000L / 24L + 1L;
            if (day < 0L) {
                return false;
            }
            int i = 0;
            while ((long)i < day) {
                if (this.isWeekday(gc)) {
                    ++workDay;
                }
                gc.add(5, 1);
                ++i;
            }
            return workDay <= deadline;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getWeekday(Date beforeDate, Date afterDate) throws ParseException {
        int workDay = 0;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beforeDate);
        long time = afterDate.getTime() - beforeDate.getTime();
        long day = time / 3600000L / 24L + 1L;
        int i = 0;
        while ((long)i < day) {
            if (this.isWeekday(gc)) {
                ++workDay;
            }
            gc.add(5, 1);
            ++i;
        }
        return workDay;
    }

    public boolean isWeekday(GregorianCalendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (calendar.get(7) != 7 && calendar.get(7) != 1) {
            return !this.getWeekdayIsHoliday().contains(sdf.format(calendar.getTime()));
        }
        return this.getWeekendIsWork().contains(sdf.format(calendar.getTime()));
    }
}

