/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.file;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Decompression {
    private static final int BUFFEREDSIZE = 1024;

    public static void unzipFile(String zipFileName) throws Exception {
        try {
            File f = new File(zipFileName);
            ZipFile zipFile = new ZipFile(zipFileName);
            if (!f.exists() && f.length() <= 0L) {
                throw new Exception("\u8981\u89e3\u538b\u7684\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            File tempFile = new File(f.getParent());
            String strPath = tempFile.getAbsolutePath();
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                int c;
                String strtemp;
                ZipEntry zipEnt = (ZipEntry)e.nextElement();
                String gbkPath = zipEnt.getName();
                if (zipEnt.isDirectory()) {
                    strtemp = strPath + File.separator + gbkPath;
                    File dir = new File(strtemp);
                    dir.mkdirs();
                    continue;
                }
                InputStream is = zipFile.getInputStream(zipEnt);
                BufferedInputStream bis = new BufferedInputStream(is);
                gbkPath = zipEnt.getName();
                strtemp = strPath + File.separator + gbkPath;
                String strsubdir = gbkPath;
                for (int i = 0; i < strsubdir.length(); ++i) {
                    String temp;
                    File subdir;
                    if (!strsubdir.substring(i, i + 1).equalsIgnoreCase(File.separator) || (subdir = new File(temp = strPath + File.separator + strsubdir.substring(0, i))).exists()) continue;
                    subdir.mkdir();
                }
                FileOutputStream fos = new FileOutputStream(strtemp);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                while ((c = bis.read()) != -1) {
                    bos.write((byte)c);
                }
                bos.close();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void unzip(String zipFileName, String extPlace) throws Exception {
        try {
            new File(extPlace).mkdirs();
            File f = new File(zipFileName);
            ZipFile zipFile = new ZipFile(zipFileName);
            if (!f.exists() && f.length() <= 0L) {
                throw new Exception("\u8981\u89e3\u538b\u7684\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            File tempFile = new File(extPlace);
            String strPath = tempFile.getAbsolutePath();
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                int c;
                String strtemp;
                ZipEntry zipEnt = (ZipEntry)e.nextElement();
                String gbkPath = zipEnt.getName();
                if (zipEnt.isDirectory()) {
                    strtemp = strPath + File.separator + gbkPath;
                    File dir = new File(strtemp);
                    dir.mkdirs();
                    continue;
                }
                InputStream is = zipFile.getInputStream(zipEnt);
                BufferedInputStream bis = new BufferedInputStream(is);
                gbkPath = zipEnt.getName();
                strtemp = strPath + File.separator + gbkPath;
                String strsubdir = gbkPath;
                for (int i = 0; i < strsubdir.length(); ++i) {
                    String temp;
                    File subdir;
                    if (!strsubdir.substring(i, i + 1).equalsIgnoreCase(File.separator) || (subdir = new File(temp = strPath + File.separator + strsubdir.substring(0, i))).exists()) continue;
                    subdir.mkdir();
                }
                FileOutputStream fos = new FileOutputStream(strtemp);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                while ((c = bis.read()) != -1) {
                    bos.write((byte)c);
                }
                bos.close();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void unzip(String zipFileName, String extPlace, boolean recursive) throws Exception {
        try {
            new File(extPlace).mkdirs();
            File f = new File(zipFileName);
            ZipFile zipFile = new ZipFile(zipFileName);
            if (!f.exists() && f.length() <= 0L) {
                throw new Exception("\u8981\u89e3\u538b\u7684\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            File tempFile = new File(extPlace);
            String strPath = tempFile.getAbsolutePath();
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                int c;
                String strtemp;
                ZipEntry zipEnt = (ZipEntry)e.nextElement();
                String gbkPath = zipEnt.getName();
                if (zipEnt.isDirectory()) {
                    strtemp = strPath + File.separator + gbkPath;
                    File dir = new File(strtemp);
                    dir.mkdirs();
                    continue;
                }
                InputStream is = zipFile.getInputStream(zipEnt);
                BufferedInputStream bis = new BufferedInputStream(is);
                gbkPath = zipEnt.getName();
                strtemp = strPath + File.separator + gbkPath;
                String strsubdir = gbkPath;
                for (int i = 0; i < strsubdir.length(); ++i) {
                    String temp;
                    File subdir;
                    if (!strsubdir.substring(i, i + 1).equalsIgnoreCase(File.separator) || (subdir = new File(temp = strPath + File.separator + strsubdir.substring(0, i))).exists()) continue;
                    subdir.mkdir();
                }
                FileOutputStream fos = new FileOutputStream(strtemp);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                while ((c = bis.read()) != -1) {
                    bos.write((byte)c);
                }
                bos.close();
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void zip(String inputFilename, String zipFilename) throws IOException {
        Decompression.zip(new File(inputFilename), zipFilename);
    }

    public static void zip(File inputFile, String zipFilename) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(zipFilename));){
            Decompression.zip(inputFile, out, "");
        }
    }

    private static void zip(File inputFile, ZipOutputStream out, String base) throws IOException {
        if (inputFile.isDirectory()) {
            File[] inputFiles = inputFile.listFiles();
            out.putNextEntry(new ZipEntry(base + File.separator));
            base = base.length() == 0 ? "" : base + File.separator;
            for (int i = 0; i < inputFiles.length; ++i) {
                Decompression.zip(inputFiles[i], out, base + inputFiles[i].getName());
            }
        } else {
            if (base.length() > 0) {
                out.putNextEntry(new ZipEntry(base));
            } else {
                out.putNextEntry(new ZipEntry(inputFile.getName()));
            }
            try (FileInputStream in = new FileInputStream(inputFile);){
                int c;
                byte[] by = new byte[1024];
                while ((c = in.read(by)) != -1) {
                    out.write(by, 0, c);
                }
            }
        }
    }

    public static String bytes2Str(byte[] b) {
        StringBuffer bs = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            bs.append(b[i] + " ");
        }
        return bs.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untar(String tarFileName, String extPlace) throws Exception {
        InputStream inputstream = null;
        OutputStream outputstream = null;
        TarInputStream zis = null;
        try {
            File file = new File(tarFileName);
            File tempFile = null;
            inputstream = new FileInputStream(file);
            zis = new TarInputStream(inputstream);
            TarEntry tarEntry = null;
            File f = new File(extPlace);
            if (!f.exists()) {
                f.mkdir();
            }
            while ((tarEntry = zis.getNextEntry()) != null) {
                int readsize;
                tempFile = new File(extPlace + File.separator + tarEntry.getName());
                tempFile.createNewFile();
                outputstream = new FileOutputStream(tempFile);
                byte[] buffer = new byte[51200];
                do {
                    readsize = zis.read(buffer);
                    outputstream.write(buffer);
                } while (readsize >= 51200);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputstream.flush();
                inputstream.close();
                zis.close();
                outputstream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void tar(String inputFilename, String tarFilename) throws IOException {
        Decompression.tar(new File(inputFilename), tarFilename);
    }

    public static void tar(File inputFile, String tarFilename) throws IOException {
        try (TarOutputStream out = new TarOutputStream((OutputStream)new FileOutputStream(tarFilename));){
            Decompression.tar(inputFile, out, "");
        }
    }

    private static void tar(File inputFile, TarOutputStream out, String base) throws IOException {
        if (inputFile.isDirectory()) {
            File[] inputFiles = inputFile.listFiles();
            out.putNextEntry(new TarEntry(base + File.separator));
            base = base.length() == 0 ? "" : base + File.separator;
            for (int i = 0; i < inputFiles.length; ++i) {
                Decompression.tar(inputFiles[i], out, base + inputFiles[i].getName());
            }
        } else {
            if (base.length() > 0) {
                out.putNextEntry(new TarEntry(base));
            } else {
                out.putNextEntry(new TarEntry(inputFile.getName()));
            }
            try (FileInputStream in = new FileInputStream(inputFile);){
                int c;
                byte[] by = new byte[1024];
                while ((c = in.read(by)) != -1) {
                    out.write(by, 0, c);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unrar(String rarFileName, String extPlace, List repeatFile, boolean del) throws Exception {
        block27: {
            File f = new File(rarFileName);
            FileOutputStream os = null;
            Archive a = null;
            try {
                try {
                    a = new Archive(f);
                }
                catch (RarException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                extPlace = extPlace == null || extPlace.trim().equals("") ? f.getParent() + File.separator + f.getName().replace(".", "#").split("#")[0] : extPlace;
                File ext = new File(extPlace);
                if (!ext.exists()) {
                    ext.mkdirs();
                }
                if (a == null) break block27;
                a.getMainHeader().print();
                FileHeader fh = a.nextFileHeader();
                while (fh != null) {
                    try {
                        File out = new File(extPlace + File.separator + fh.getFileNameString().trim());
                        if (!out.exists() || !out.isDirectory()) {
                            if (out.exists() && repeatFile != null) {
                                File rFile = new File(extPlace + File.separator + "tempFile");
                                if (!rFile.exists()) {
                                    rFile.mkdirs();
                                }
                                repeatFile.add(fh.getFileNameString().trim());
                                out = new File(extPlace + File.separator + "tempFile" + File.separator + fh.getFileNameString().trim());
                                File pp = new File(out.getParent());
                                if (!pp.exists()) {
                                    pp.mkdirs();
                                }
                                pp = null;
                                os = new FileOutputStream(out);
                            } else {
                                File pp = new File(out.getParent());
                                if (!pp.exists()) {
                                    pp.mkdirs();
                                }
                                pp = null;
                                os = new FileOutputStream(out);
                            }
                        }
                        a.extractFile(fh, (OutputStream)os);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (RarException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (os != null) {
                            os.close();
                            os = null;
                        }
                    }
                    fh = a.nextFileHeader();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                a.close();
                if (del) {
                    f.delete();
                }
            }
        }
    }

    public void unrar(String rarFileName, String extPlace, List repeatFile) throws Exception {
        Decompression.unrar(rarFileName, extPlace, repeatFile, false);
    }

    public void unrar(String rarFileName, List repeatFile) throws Exception {
        Decompression.unrar(rarFileName, null, repeatFile, false);
    }

    public void unrar(String rarFileName, String extPlace) throws Exception {
        Decompression.unrar(rarFileName, extPlace, null, false);
    }

    public void unrar(String rarFileName) throws Exception {
        Decompression.unrar(rarFileName, null, null, false);
    }
}

