/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.file;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.oiue.tools.ITask;
import org.oiue.tools.file.FileStringUtil;
import org.oiue.tools.string.StringUtil;

public class FileSearch {
    public static List FileDirectorySearch(String fileName) {
        ArrayList<Object> fileList = new ArrayList<Object>();
        LinkedList<File> list = new LinkedList<File>();
        File dir = new File(fileName);
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isDirectory()) {
                list.add(file[i]);
                continue;
            }
            fileList.add(file[i]);
        }
        while (!list.isEmpty()) {
            File tmp = (File)list.removeFirst();
            if (tmp.isDirectory()) {
                file = tmp.listFiles();
                if (file == null) continue;
                for (int i = 0; i < file.length; ++i) {
                    if (file[i].isDirectory()) {
                        list.add(file[i]);
                        continue;
                    }
                    fileList.add(file[i]);
                }
                continue;
            }
            fileList.add(tmp.getAbsolutePath());
        }
        return fileList;
    }

    public static List FileDirectorysSearch(String fileName) {
        ArrayList<File> directotyList = new ArrayList<File>();
        LinkedList<File> list = new LinkedList<File>();
        File dir = new File(fileName);
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (!file[i].isDirectory()) continue;
            list.add(file[i]);
            directotyList.add(file[i]);
        }
        while (!list.isEmpty()) {
            File tmp = (File)list.removeFirst();
            if (!tmp.isDirectory() || (file = tmp.listFiles()) == null) continue;
            for (int i = 0; i < file.length; ++i) {
                if (!file[i].isDirectory()) continue;
                list.add(file[i]);
                directotyList.add(file[i]);
            }
        }
        return directotyList;
    }

    public static List ParallelFile(String sourceDir, String targetDir) {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<File> sourceFilelist = new LinkedList<File>();
        LinkedList<File> targetFilelist = new LinkedList<File>();
        File source = new File(sourceDir);
        File[] sourceFile = source.listFiles();
        File target = new File(targetDir);
        File[] targetFile = target.listFiles();
        for (int i = 0; i < targetFile.length; ++i) {
            for (int j = 0; j < sourceFile.length; ++j) {
                if (!targetFile[i].getName().trim().equals(sourceFile[j].getName().trim())) continue;
                if (targetFile[i].isDirectory()) {
                    sourceFilelist.add(sourceFile[j]);
                    targetFilelist.add(targetFile[i]);
                    continue;
                }
                list.add(targetFile[i].getAbsolutePath());
            }
        }
        while (!targetFilelist.isEmpty() && !sourceFilelist.isEmpty()) {
            File targetTmp = (File)targetFilelist.removeFirst();
            File sourceTmp = (File)sourceFilelist.removeFirst();
            if (!targetTmp.isDirectory() || !sourceTmp.isDirectory()) continue;
            targetFile = targetTmp.listFiles();
            sourceFile = sourceTmp.listFiles();
            if (targetFile == null && sourceFile == null) continue;
            for (int i = 0; i < targetFile.length; ++i) {
                for (int j = 0; j < sourceFile.length; ++j) {
                    if (!targetFile[i].getName().trim().equals(sourceFile[j].getName().trim())) continue;
                    if (targetFile[i].isDirectory()) {
                        sourceFilelist.add(sourceFile[j]);
                        targetFilelist.add(targetFile[i]);
                        continue;
                    }
                    list.add(targetFile[i].getAbsolutePath());
                }
            }
        }
        return list;
    }

    public static boolean searchFile(String parentPath, ITask itask) {
        File[] file = null;
        File current = null;
        if (StringUtil.isEmpty(parentPath)) {
            try {
                file = File.listRoots();
            }
            catch (Exception exception) {}
        } else {
            current = new File(parentPath);
            file = new File(parentPath).listFiles();
        }
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                current = file[i];
                if (current.isDirectory()) {
                    FileSearch.searchFile(current.getPath(), itask);
                    continue;
                }
                itask.invoke(current);
            }
        }
        return true;
    }

    public static List FileDirectorySearch(String fileName, List fileType) {
        List list = FileSearch.FileDirectorySearch(fileName);
        ArrayList listList = new ArrayList();
        String fileExtension = "";
        for (int i = 0; i < list.size(); ++i) {
            fileExtension = FileStringUtil.getExtension(list.get(i).toString());
            for (int j = 0; j < fileType.size(); ++j) {
                if (fileExtension == null || !fileExtension.toLowerCase().trim().equals(fileType.get(j).toString().toLowerCase())) continue;
                listList.add(list.get(i));
            }
        }
        return listList;
    }
}

