/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.json.JSONArray;
import org.json.JSONException;
import org.oiue.tools.json.JSONUtil;
import org.oiue.tools.map.MapUtil;

public class ListUtil {
    public static ArrayList<ArrayList<String>> arrayListInit(int row, int cell) {
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < row; ++i) {
            ArrayList<Object> li = new ArrayList<Object>();
            for (int j = 0; j < cell; ++j) {
                li.add(null);
            }
            list.add(li);
        }
        return list;
    }

    public static ArrayList<ArrayList<String>> arrayListInit(int row, int cell, String init) {
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < row; ++i) {
            ArrayList<String> li = new ArrayList<String>();
            for (int j = 0; j < cell; ++j) {
                li.add(init);
            }
            list.add(li);
        }
        return list;
    }

    public static ArrayList<String> arrayListInit(int cell) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < cell; ++i) {
            list.add(null);
        }
        return list;
    }

    public static ArrayList<String> arrayListInit(int cell, String init) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < cell; ++i) {
            list.add(init);
        }
        return list;
    }

    public static ArrayList<ArrayList<String>> clearArrayList(ArrayList<ArrayList<String>> list) {
        if (list != null && list.size() > 0) {
            ArrayList<ArrayList<String>> lis = new ArrayList<ArrayList<String>>();
            int k = 0;
            for (int i = 0; i < list.size(); ++i) {
                k = 0;
                for (int j = 0; j < list.get(i).size(); ++j) {
                    if (list.get(i).get(j) != null && !list.get(i).get(j).trim().equals("") && !list.get(i).get(j).trim().equals("null")) continue;
                    ++k;
                }
                if (k >= list.get(i).size()) continue;
                lis.add(list.get(i));
            }
            return lis;
        }
        return null;
    }

    public static int ArraylistHaveStr(ArrayList<ArrayList> list, String str) {
        int ishave = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).get(0) == null || !list.get(i).get(0).toString().trim().equals(str)) continue;
            ishave = i;
            break;
        }
        return ishave;
    }

    public static void addList(ArrayList oldList, String filed, int index, ArrayList newList) {
        for (int i = 0; i < oldList.size(); ++i) {
            if (i > index + 1) {
                ListUtil.addList((ArrayList)oldList.get(i), filed, index, newList);
                continue;
            }
            if (i != index || !filed.equals(oldList.get(i).toString())) continue;
            oldList.add(newList);
        }
    }

    public static ArrayList getList(ArrayList data, String filed, int index) {
        ArrayList list = null;
        for (int i = 0; i < data.size(); ++i) {
            if (i > index + 1) {
                list = ListUtil.getList((ArrayList)data.get(i), filed, index);
                if (list == null) continue;
                break;
            }
            if (i != index || !filed.equals(data.get(i).toString())) continue;
            list = data;
            break;
        }
        return list;
    }

    public static String ListJoin(List list, String split) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object object : list) {
            sb.append(object + split);
        }
        if (list.size() == 0) {
            sb.append(split);
        }
        return sb.toString().substring(0, split == null ? sb.toString().length() : sb.toString().length() - split.length());
    }

    public static String ArrayJoin(Object[] list, String split) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            sb.append(list[i] + split);
        }
        if (list.length == 0) {
            sb.append(split);
        }
        return sb.toString().substring(0, split == null ? sb.toString().length() : sb.toString().length() - split.length());
    }

    public static void sort(List data, Map<String, Boolean> comperator) {
        ComparatorChain cc = new ComparatorChain();
        for (String filed : comperator.keySet()) {
            cc.addComparator(ComparatorUtils.nullLowComparator((Comparator)new BeanComparator(filed)), comperator.get(filed).booleanValue());
        }
        Collections.sort(data, cc);
    }

    public static List<Object> toList(List<Object> list, Collection<Integer> indexes) {
        if (indexes == null) {
            return null;
        }
        return ListUtil.toList(list, indexes.toArray(new Integer[0]));
    }

    public static List<Object> toList(List<Object> list, Integer[] indexes) {
        if (list == null || indexes == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Integer[] integerArray = indexes;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int e = integerArray[i];
            result.add(list.get(e));
        }
        return list;
    }

    public static List<Object> toList(List<Object> list, List<Object> indexes) {
        if (list == null || indexes == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object e : indexes) {
            if (e instanceof Number) {
                result.add(list.get(((Number)e).intValue()));
                continue;
            }
            result.add(null);
        }
        return list;
    }

    public static String toString(List<Object> list) {
        return new JSONArray(list).toString();
    }

    public static Object get(List<Object> list, int index) {
        return list.get(index);
    }

    public static void put(List<Object> list, Object object) {
        list.add(object);
    }

    public static void put(List<Object> list, int index, Object object) {
        list.add(index, object);
    }

    public static List<Object> fromString(String source) {
        try {
            return JSONUtil.toList(new JSONArray(source));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static boolean contain(List<Object> a, List<Object> b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        for (int i = 0; i < b.size(); ++i) {
            Object av = a.get(i);
            if (av == null) {
                if (b.get(i) == null) continue;
                return false;
            }
            if (!(av instanceof Map ? !MapUtil.contain((Map)av, (Map)b.get(i)) : (av instanceof List ? !ListUtil.contain((List)av, (List)b.get(i)) : !av.equals(b.get(i))))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(List<Object> a, List<Object> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < b.size(); ++i) {
            Object av = a.get(i);
            if (av == null) {
                if (b.get(i) == null) continue;
                return false;
            }
            if (!(av instanceof Map ? !MapUtil.equals((Map)av, (Map)b.get(i)) : (av instanceof List ? !ListUtil.equals((List)av, (List)b.get(i)) : !av.equals(b.get(i))))) continue;
            return false;
        }
        return true;
    }

    public static List<Object> clone(List<Object> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object v : list) {
            if (v instanceof Map) {
                result.add(MapUtil.clone((Map)v));
                continue;
            }
            if (v instanceof List) {
                result.add(ListUtil.clone((List)v));
                continue;
            }
            result.add(v);
        }
        return result;
    }

    public static void mergeTo(List<Object> target, List<Object> source) {
        if (target == null || source == null) {
            return;
        }
        target.addAll(source);
    }

    public static List<Object> merge(List<Object> a, List<Object> b) {
        if (a == null || b == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ListUtil.mergeTo(result, a);
        ListUtil.mergeTo(result, b);
        return result;
    }

    public static String getString(List<Object> list, int index) {
        Object object = list.get(index);
        return object == null ? null : object.toString();
    }

    public static Double getDouble(List<Object> list, int index) {
        Object object = list.get(index);
        return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(object.toString());
    }

    public static boolean getBoolean(List<Object> list, int index) {
        Object object = list.get(index);
        return object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("1") || object instanceof Number && ((Number)object).intValue() == 1;
    }

    public static int getInt(List<Object> list, int index) {
        Object object = list.get(index);
        return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
    }

    public static long getLong(List<Object> list, int index) {
        Object object = list.get(index);
        return object instanceof Number ? ((Number)object).longValue() : Long.parseLong(object.toString());
    }

    public static Object get(List<Object> list, String keys) {
        String[] ks = keys.split("\\.", 2);
        int key = Integer.valueOf(ks[0]);
        if (ks.length == 1) {
            return list.get(key);
        }
        Object ov = list.get(key);
        if (ov instanceof Map) {
            return MapUtil.get((Map)ov, ks[1]);
        }
        if (ov instanceof List) {
            return ListUtil.get((List<Object>)((List)ov), ks[1]);
        }
        throw new RuntimeException("The type of cannot be parsed");
    }

    public static List<Map> convertToTree(List<Map> source, String key, String parentKey, String childKey) {
        return ListUtil.convertToTree(source, null, childKey, parentKey, childKey, null);
    }

    public static List<Map> convertToTree(List<Map> source, Object parent, String key, String parentKey, String childKey) {
        return ListUtil.convertToTree(source, parent, childKey, parentKey, childKey, null);
    }

    public static List<Map> convertToTree(List<Map> source, Object parent, String key, String parentKey, String childKey, String sortKey) {
        if (source != null) {
            Object child;
            Vector<Map> s = new Vector<Map>(source);
            HashMap temp = new HashMap();
            for (Map map : s) {
                temp.put(map.get(key), map);
            }
            for (Map map : s) {
                Map tp;
                Object parentK = map.get(parentKey);
                if (parentK == null || (tp = (Map)temp.get(parentK)) == null) continue;
                child = tp.get(childKey);
                if (child == null) {
                    ArrayList<Map> tc = new ArrayList<Map>();
                    tc.add(map);
                    tp.put(childKey, tc);
                    continue;
                }
                if (child instanceof List) {
                    ((List)child).add(map);
                    continue;
                }
                throw new RuntimeException("childKey[" + childKey + "] error.");
            }
            ArrayList<Map> vs = new ArrayList<Map>(temp.values());
            Iterator iterator = vs.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (!(parent == null ? parent != map.get(parentKey) : !parent.equals(map.get(parentKey)))) continue;
                iterator.remove();
            }
            if (sortKey != null) {
                HashMap<String, Boolean> comperator = new HashMap<String, Boolean>();
                comperator.put(sortKey, false);
                for (Map map : s) {
                    child = map.get(childKey);
                    if (child == null || !(child instanceof List)) continue;
                    ListUtil.sort((List)child, comperator);
                }
                ListUtil.sort(vs, comperator);
            }
            return vs;
        }
        return null;
    }
}

