/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.oiue.tools.json.JSONUtil;
import org.oiue.tools.list.ListUtil;
import org.oiue.tools.string.StringUtil;

public class MapUtil {
    public static Object toLowerCaseKey(Object object) {
        if (object instanceof Iterable) {
            ArrayList<Object> rtnL = new ArrayList<Object>();
            for (Object type : (Iterable)object) {
                rtnL.add(MapUtil.toLowerCaseKey(type));
            }
            return rtnL;
        }
        if (object instanceof Map) {
            HashMap rtnM = new HashMap();
            for (Object key : ((Map)object).keySet()) {
                rtnM.put(key instanceof String ? (key != null ? key.toString().toLowerCase() : key) : key, MapUtil.toLowerCaseKey(((Map)object).get(key)));
            }
            return rtnM;
        }
        return object;
    }

    public static Object getVauleMatchCase(Map map, Object key) {
        if (map == null) {
            return null;
        }
        if (key == null || !key.getClass().getName().equals("String") && !key.getClass().getName().equals("java.lang.String")) {
            return map.get(key);
        }
        if (map.get(key) != null) {
            return map.get(key);
        }
        for (Object keys : map.keySet()) {
            if (keys == null || !keys.getClass().getName().equals("String") && !keys.getClass().getName().equals("java.lang.String") || !((String)keys).equalsIgnoreCase(key + "")) continue;
            return map.get(keys);
        }
        return null;
    }

    public static Object removeMatchCase(Map map, Object key) {
        if (map == null) {
            return null;
        }
        if (key == null || !key.getClass().getName().equals("String") && !key.getClass().getName().equals("java.lang.String")) {
            map.remove(key);
            return map;
        }
        for (Object keys : map.keySet()) {
            if (keys == null || !keys.getClass().getName().equals("String") && !keys.getClass().getName().equals("java.lang.String") || !((String)keys).equalsIgnoreCase(key + "")) continue;
            map.remove(keys);
            break;
        }
        return map;
    }

    public static String mapKeyStr(Map map, String split) {
        if (map == null) {
            return "";
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : map.keySet()) {
            keyList.add(key);
        }
        return ListUtil.ListJoin(keyList, split);
    }

    public static String mapValueStrForMysql(Map map, String split) {
        if (map == null) {
            return "";
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            keyList.add("'" + value + "'");
        }
        return ListUtil.ListJoin(keyList, split);
    }

    public static String mapKeyValueForMysql(Map map, String split) {
        if (map == null) {
            return "";
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            keyList.add(key + "='" + value + "'");
        }
        return ListUtil.ListJoin(keyList, split);
    }

    public static String map2Str(Map map, String firstSeparator, String secondSeparator, String ... thrs) throws Throwable {
        if (map == null || StringUtil.isEmpty(firstSeparator) || StringUtil.isEmpty(secondSeparator)) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6240\u4f20\u53c2\u6570");
        }
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            Object value;
            if (sb.length() != 0) {
                sb.append(firstSeparator);
            }
            if ((value = map.get(key)) instanceof String) {
                sb.append(key + secondSeparator + value);
                continue;
            }
            if (value instanceof String[]) {
                sb.append(key + secondSeparator + ListUtil.ArrayJoin((String[])value, thrs == null || thrs.length == 0 ? "" : thrs[0]));
                continue;
            }
            sb.append(key + secondSeparator + value);
        }
        return sb.toString();
    }

    public static Map grantSum(Object grant, Map<String, String> gm, String split, boolean type) {
        if (gm == null) {
            gm = new HashMap<String, String>();
        }
        if (grant == null) {
            return gm;
        }
        if (grant instanceof ArrayList) {
            String item = "";
            String[] its = null;
            Object[] gms = null;
            String gmvalue = "";
            ArrayList grantList = (ArrayList)grant;
            for (int i = 0; i < grantList.size(); ++i) {
                item = (String)grantList.get(i);
                its = item.split(split);
                if (its.length <= 1) continue;
                gmvalue = gm.get(its[0]);
                if (gmvalue == null) {
                    gmvalue = "0:0:0:0";
                }
                gms = gmvalue.split(":");
                try {
                    if (gms.length > Integer.parseInt(its[1])) {
                        gms[Integer.parseInt((String)its[1])] = (type ? 1 : -1) + "";
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                gm.put(its[0], ListUtil.ArrayJoin(gms, ":"));
            }
        }
        return gm;
    }

    public static Object get(Map map, String keys) {
        if (map == null) {
            return null;
        }
        Object rtn = map.get(keys);
        if (rtn != null) {
            if (rtn instanceof String) {
                rtn = ((String)rtn).trim();
            }
            return rtn;
        }
        String[] ks = keys.split("\\.", 2);
        if (ks.length != 1) {
            Object ov = map.get(ks[0]);
            if (ov instanceof Map) {
                return MapUtil.get((Map)ov, ks[1]);
            }
            if (ov instanceof List) {
                return ListUtil.get((List<Object>)((List)ov), ks[1]);
            }
            throw new RuntimeException("The type of cannot be parsed");
        }
        return null;
    }

    public static void put(Map map, String keys, Object object) {
        if (map == null) {
            return;
        }
        String[] ks = keys.split("\\.", 2);
        if (ks.length == 1) {
            map.put(keys, object);
        } else {
            Object ov = map.get(ks[0]);
            if (ov instanceof Map) {
                MapUtil.put((Map)ov, ks[1], object);
            } else {
                map.put(keys, object);
            }
        }
    }

    public static List<Object> toList(Map<String, Object> map, Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        return MapUtil.toList(map, keys.toArray(new String[0]));
    }

    public static List<Object> toList(Map<String, Object> map, String[] keys) {
        if (map == null || keys == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String e : keys) {
            list.add(MapUtil.get(map, e));
        }
        return list;
    }

    public static List<Object> toList(Map<String, Object> map, List<Object> keySteps) {
        if (map == null || keySteps == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object e : keySteps) {
            if (e instanceof List) {
                result.add(MapUtil.get(map, (List)e));
                continue;
            }
            result.add(MapUtil.get(map, e + ""));
        }
        return result;
    }

    public static Map<String, Object> toMap(Map<String, Object> map, Map<String, String> transMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> e : transMap.entrySet()) {
            result.put(e.getValue(), MapUtil.get(map, e.getKey()));
        }
        return result;
    }

    public static Map<String, Object> toMap(Map<String, Object> map, Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        return MapUtil.toMap(map, keys.toArray(new String[0]));
    }

    public static Map<String, Object> toMap(Map<String, Object> map, String[] keys) {
        if (map == null || keys == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String e : keys) {
            result.put(e, MapUtil.get(map, e));
        }
        return result;
    }

    public static Object get(Map<String, Object> map, List<Object> keyStep) {
        return MapUtil.get(map, keyStep.toArray(new Object[0]));
    }

    public static void put(Map<String, Object> map, List<Object> keyStep, Object object) {
        MapUtil.put(map, keyStep.toArray(new Object[0]), object);
    }

    public static Object get(Map<String, Object> map, Object[] keyStep) {
        if (map == null || keyStep == null) {
            return null;
        }
        Map cursor = map;
        for (int i = 0; i < keyStep.length - 1; ++i) {
            Object tc = cursor.get(keyStep[i]);
            if (!(tc instanceof Map)) {
                cursor = null;
                break;
            }
            cursor = (Map)tc;
        }
        if (cursor == null) {
            return null;
        }
        return cursor.get(keyStep[keyStep.length - 1]);
    }

    public static void put(Map<String, Object> map, Object[] keyStep, Object object) {
        if (map == null || keyStep == null) {
            return;
        }
        HashMap<String, Object> cursor = map;
        for (int i = 0; i < keyStep.length - 1; ++i) {
            Object tc = cursor.get(keyStep[i]);
            if (tc instanceof Map) {
                cursor = (HashMap<String, Object>)tc;
                continue;
            }
            HashMap<String, Object> t = new HashMap<String, Object>();
            cursor.put((String)keyStep[i], t);
            cursor = t;
        }
        cursor.put((String)keyStep[keyStep.length - 1], object);
    }

    public static String toString(Map<String, Object> map) {
        return new JSONObject(map).toString();
    }

    public static Map<String, Object> fromString(String source) {
        try {
            return JSONUtil.toMap(new JSONObject(source));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static boolean contain(Map<String, Object> large, Map<String, Object> small) {
        if (small == null) {
            return true;
        }
        if (large == null) {
            return false;
        }
        for (Map.Entry<String, Object> e : small.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            if (large.containsKey(k)) {
                Object lv = large.get(k);
                if (lv == null) {
                    if (v == null) continue;
                    return false;
                }
                if (lv instanceof Map) {
                    if (v instanceof Map) {
                        if (MapUtil.contain((Map)lv, (Map)v)) continue;
                        return false;
                    }
                    return false;
                }
                if (lv instanceof List) {
                    if (v instanceof List) {
                        if (ListUtil.contain((List)lv, (List)v)) continue;
                        return false;
                    }
                    return false;
                }
                if (lv.equals(v)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean equals(Map<String, Object> a, Map<String, Object> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<String, Object> e : b.entrySet()) {
            String k = e.getKey();
            if (a.containsKey(k)) {
                Object av = a.get(k);
                if (av == null) {
                    if (e.getValue() == null) continue;
                    return false;
                }
                if (!(av instanceof Map ? !MapUtil.equals((Map)av, (Map)e.getValue()) : (av instanceof List ? !ListUtil.equals((List)av, (List)e.getValue()) : !av.equals(e.getValue())))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static void mergeTo(Map<String, Object> target, Map<String, Object> source) {
        if (target == null || source == null) {
            return;
        }
        for (Map.Entry<String, Object> e : source.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            if (target.containsKey(k)) {
                Object tv = target.get(k);
                if (tv instanceof Map) {
                    if (!(v instanceof Map)) continue;
                    MapUtil.mergeTo((Map)tv, (Map)v);
                    continue;
                }
                if (tv instanceof List) {
                    if (v instanceof List) {
                        ListUtil.mergeTo((List)tv, (List)v);
                        continue;
                    }
                    ((List)tv).add(v);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(tv);
                list.add(v);
                target.put(k, list);
                continue;
            }
            target.put(k, v);
        }
    }

    public static Map<String, Object> merge(Map<String, Object> a, Map<String, Object> b) {
        if (a == null || b == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        MapUtil.mergeTo(result, a);
        MapUtil.mergeTo(result, b);
        return result;
    }

    public static Map<String, Object> clone(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object v = e.getValue();
            if (v instanceof Map) {
                result.put(e.getKey(), MapUtil.clone((Map)v));
                continue;
            }
            if (v instanceof List) {
                result.put(e.getKey(), ListUtil.clone((List)v));
                continue;
            }
            result.put(e.getKey(), v);
        }
        return result;
    }

    public static String getString(Map<String, Object> map, String key) {
        Object object = MapUtil.get(map, key);
        return object == null ? null : object.toString();
    }

    public static Double getDouble(Map<String, Object> map, String key) {
        Object object = MapUtil.get(map, key);
        return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(object.toString());
    }

    public static boolean getBoolean(Map<String, Object> map, String key) {
        Object object = MapUtil.get(map, key);
        return object.equals(Boolean.TRUE) || object instanceof String && (((String)object).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("1")) || object instanceof Number && ((Number)object).intValue() == 1;
    }

    public static int getInt(Map<String, Object> map, String key) {
        Object object = MapUtil.get(map, key);
        return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
    }

    public static long getLong(Map<String, Object> map, String key) {
        Object object = MapUtil.get(map, key);
        return object instanceof Number ? ((Number)object).longValue() : Long.parseLong(object.toString());
    }
}

