/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.serializ;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.oiue.tools.bytes.ByteUtil;

public class SerializObject {
    public static boolean serializObj2File(Object o, String path) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        File file = new File(path);
        DataOutputStream to = new DataOutputStream(new FileOutputStream(file));
        bos.writeTo(to);
        return true;
    }

    public static String serializObj2String(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        return ByteUtil.toHexString(bos.toByteArray());
    }

    public static Object serializFile2Obj(String path) throws IOException, ClassNotFoundException {
        File file = new File(path);
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] temp = new byte[1024];
        int size = 0;
        while ((size = in.read(temp)) != -1) {
            out.write(temp, 0, size);
        }
        in.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(out.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois.readObject();
    }

    public static Object serializString2Obj(String line) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(ByteUtil.toBytes4HexString(line));
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois.readObject();
    }

    public static String byte2hex(byte[] b) {
        StringBuffer sb = new StringBuffer();
        String tmp = "";
        for (int i = 0; i < b.length; ++i) {
            tmp = Integer.toHexString(b[i] & 0xFF);
            if (tmp.length() == 1) {
                sb.append("0" + tmp);
                continue;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static byte[] hex2byte(String str) {
        if (str == null) {
            return null;
        }
        int len = (str = str.trim()).length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < str.length(); i += 2) {
                b[i / 2] = (byte)Integer.decode("0X" + str.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }
}

