/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools;

import java.io.Serializable;
import java.net.URL;
import org.oiue.tools.OS;
import org.oiue.tools.string.StringUtil;

public class Application
implements Serializable {
    public static String getRootPath() {
        String result = Application.class.getResource("Application.class").toString();
        int index = result.indexOf("WEB-INF");
        if (index == -1) {
            index = result.indexOf("bin");
        }
        if (index == -1) {
            index = result.indexOf("org.oiue.tools");
        }
        if ((result = result.substring(0, index)).startsWith("jar")) {
            result = result.substring(10);
        } else if (result.startsWith("file")) {
            result = result.substring(6);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        if (OS.isLinux() || OS.isMacOSX()) {
            result = "/" + result;
        }
        result = result.replace("%20", " ");
        result = result.replace("\\", "/");
        return result;
    }

    public static String getClassRootPath() {
        int index;
        String result = Application.class.getResource("Application.class").toString();
        boolean isWeb = false;
        if (result.indexOf("webapps") > 0) {
            isWeb = true;
        }
        if ((index = result.indexOf("WEB-INF")) == -1) {
            index = result.indexOf("bin");
        }
        if (index == -1) {
            index = result.indexOf("org.oiue.tools");
        }
        if ((result = result.substring(0, index)).startsWith("jar")) {
            result = result.substring(10);
        } else if (result.startsWith("file")) {
            result = result.substring(6);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        if (OS.isLinux() || OS.isMacOSX()) {
            result = "/" + result;
        }
        result = isWeb ? result + "/WEB-INF/classes/" : result + "/../bo/";
        result = result.replace("%20", " ");
        result = result.replace("\\", "/");
        return result;
    }

    public static final boolean isWebPublish() {
        String appPath = Application.getRootPath();
        return appPath.indexOf("webapps") >= 0;
    }

    public static String getRealFilePath(String resourcePath) {
        URL inputURL = Application.class.getResource(resourcePath);
        String filePath = inputURL.getFile();
        if (OS.isWindows() && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public static String getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            System.out.println(ste.getClassName() + "." + ste.getMethodName() + "(.);[" + ste.getLineNumber() + "]");
        }
        return "";
    }

    public static String getCaller(int num) {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length && i < num; ++i) {
            StackTraceElement ste = stack[i];
            System.out.println(ste.getClassName() + "." + ste.getMethodName() + "(...);[" + ste.getLineNumber() + "]");
        }
        return "";
    }

    public static String getClassLine(String className) {
        StackTraceElement[] stack;
        if (StringUtil.isEmptys(className)) {
            return null;
        }
        for (StackTraceElement element : stack = new Throwable().getStackTrace()) {
            if (!className.equals(element.getClassName())) continue;
            return element + "";
        }
        return null;
    }

    public static String getNextClassLine(String className) {
        if (StringUtil.isEmptys(className)) {
            return null;
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        boolean next = false;
        for (StackTraceElement element : stack) {
            if (next) {
                return element + "";
            }
            if (!className.equals(element.getClassName())) continue;
            next = true;
        }
        return null;
    }
}

