/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.oiue.tools.exception.OIUEException;

public class Reflection
implements Serializable {
    public Object invokeStaticMethod(String className, String methodName, Object[] args) {
        try {
            Class<?> ownerClass = Class.forName(className);
            Class[] argsClass = null;
            argsClass = args == null ? new Class[]{} : new Class[args.length];
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                if (args[i] == null) continue;
                argsClass[i] = args[i].getClass();
            }
            Method method = ownerClass.getMethod(methodName, argsClass);
            return method.invoke(ownerClass.newInstance(), args);
        }
        catch (Exception e) {
            throw new OIUEException(-500, className + "." + methodName, (Throwable)e);
        }
    }

    public Object newInstance(String className, Object ... args) {
        try {
            Class<?> newoneClass = Class.forName(className);
            Class[] argsClass = new Class[args.length];
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                argsClass[i] = args[i].getClass();
            }
            Constructor<?> cons = newoneClass.getConstructor(argsClass);
            return cons.newInstance(args);
        }
        catch (Exception e) {
            throw new OIUEException(-500, className, (Throwable)e);
        }
    }

    public Object invokeMethod(Object owner, String methodName, Object[] args) {
        Class<?> ownerClass = owner.getClass();
        Class[] argsClass = null;
        argsClass = args == null ? new Class[]{} : new Class[args.length];
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            argsClass[i] = args[i].getClass();
        }
        try {
            Method method = ownerClass.getMethod(methodName, argsClass);
            return method.invoke(owner, args);
        }
        catch (Exception e) {
            throw new OIUEException(-500, owner + "." + methodName, (Throwable)e);
        }
    }

    public Object invokeMethod(Object owner, String methodName, Object[] args, Class[] argsClass) {
        try {
            Class<?> ownerClass = owner.getClass();
            Method method = ownerClass.getMethod(methodName, argsClass);
            return method.invoke(owner, args);
        }
        catch (Exception e) {
            throw new OIUEException(-500, owner + "." + methodName, (Throwable)e);
        }
    }

    public Object getProperty(Object owner, String fieldName) {
        try {
            Class<?> ownerClass = owner.getClass();
            Field field = ownerClass.getField(fieldName);
            Object property = field.get(owner);
            return property;
        }
        catch (Exception e) {
            throw new OIUEException(-500, owner + "." + fieldName, (Throwable)e);
        }
    }

    public Object getStaticProperty(String className, String fieldName) {
        try {
            Class<?> ownerClass = Class.forName(className);
            Field field = ownerClass.getField(fieldName);
            Object property = field.get(ownerClass);
            return property;
        }
        catch (Exception e) {
            throw new OIUEException(-500, className + "." + fieldName, (Throwable)e);
        }
    }

    public boolean isInstance(Object obj, Class cls) {
        return cls.isInstance(obj);
    }

    public Object getByArray(Object array, int index) {
        return Array.get(array, index);
    }
}

