/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.arrays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class ArrayUtil {
    public static int[] swap(int[] ints, int x, int y) {
        int temp = ints[x];
        ints[x] = ints[y];
        ints[y] = temp;
        return ints;
    }

    public static int[] bubbleSort(int[] source) {
        for (int i = 1; i < source.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (source[j] <= source[j + 1]) continue;
                ArrayUtil.swap(source, j, j + 1);
            }
        }
        return source;
    }

    public static int[] selectSort(int[] source) {
        for (int i = 0; i < source.length; ++i) {
            for (int j = i + 1; j < source.length; ++j) {
                if (source[i] <= source[j]) continue;
                ArrayUtil.swap(source, i, j);
            }
        }
        return source;
    }

    public static int[] insertSort(int[] source) {
        for (int i = 1; i < source.length; ++i) {
            for (int j = i; j > 0 && source[j] < source[j - 1]; --j) {
                ArrayUtil.swap(source, j, j - 1);
            }
        }
        return source;
    }

    public static int[] quickSort(int[] source) {
        return ArrayUtil.qsort(source, 0, source.length - 1);
    }

    private static int[] qsort(int[] source, int low, int high) {
        if (low < high) {
            int i = low;
            int j = high;
            int x = source[i];
            while (i < j) {
                while (i < j && source[j] > x) {
                    --j;
                }
                if (i < j) {
                    source[i] = source[j];
                    ++i;
                }
                while (i < j && source[i] < x) {
                    ++i;
                }
                if (i >= j) continue;
                source[j] = source[i];
                --j;
            }
            source[i] = x;
            ArrayUtil.qsort(source, low, i - 1);
            ArrayUtil.qsort(source, i + 1, high);
        }
        return source;
    }

    public static int binarySearch(int[] source, int key) {
        int low = 0;
        int high = source.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (key == source[mid]) {
                return mid;
            }
            if (key < source[mid]) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }

    public static int[] reverse(int[] source) {
        int length = source.length;
        int temp = 0;
        for (int i = 0; i < length >> 1; ++i) {
            temp = source[i];
            source[i] = source[length - 1 - i];
            source[length - 1 - i] = temp;
        }
        return source;
    }

    public static int[] insert(int[] array, int index, int insertNumber) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException();
        }
        if (index - 1 > array.length || index <= 0) {
            throw new IllegalArgumentException();
        }
        int[] dest = new int[array.length + 1];
        System.arraycopy(array, 0, dest, 0, index - 1);
        dest[index - 1] = insertNumber;
        System.arraycopy(array, index - 1, dest, index, dest.length - index);
        return dest;
    }

    public static int[] remove(int[] array, int index) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException();
        }
        if (index > array.length || index <= 0) {
            throw new IllegalArgumentException();
        }
        int[] dest = new int[array.length - 1];
        System.arraycopy(array, 0, dest, 0, index - 1);
        System.arraycopy(array, index, dest, index - 1, array.length - index);
        return dest;
    }

    public static int[] merge(int[] array1, int[] array2) {
        int[] dest = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, dest, 0, array1.length);
        System.arraycopy(array2, 0, dest, array1.length, array2.length);
        return dest;
    }

    public static int[] offsetArray(int[] array, int offset) {
        int length = array.length;
        int moveLength = length - offset;
        int[] temp = Arrays.copyOfRange(array, moveLength, length);
        System.arraycopy(array, 0, array, offset, moveLength);
        System.arraycopy(temp, 0, array, 0, offset);
        return array;
    }

    public static List shuffle(List list) {
        Collections.shuffle(list);
        return list;
    }

    public int[] shuffle(int[] array) {
        Random random = new Random();
        for (int index = array.length - 1; index >= 0; --index) {
            this.exchange(array, random.nextInt(index + 1), index);
        }
        return array;
    }

    private void exchange(int[] array, int p1, int p2) {
        int temp = array[p1];
        array[p1] = array[p2];
        array[p2] = temp;
    }

    private static List<Integer> mergeByList(int[] a, int[] b) {
        ArrayList<Integer> c;
        block6: {
            int bIndex;
            block5: {
                c = new ArrayList<Integer>();
                int aIndex = 0;
                bIndex = 0;
                while (aIndex <= a.length - 1 && bIndex <= b.length - 1) {
                    if (a[aIndex] < b[bIndex]) {
                        c.add(a[aIndex]);
                        ++aIndex;
                        continue;
                    }
                    if (a[aIndex] > b[bIndex]) {
                        c.add(b[bIndex]);
                        ++bIndex;
                        continue;
                    }
                    c.add(a[aIndex]);
                    ++aIndex;
                    ++bIndex;
                }
                if (aIndex > a.length - 1) break block5;
                for (int i = aIndex; i <= a.length - 1; ++i) {
                    c.add(a[i]);
                }
                break block6;
            }
            if (bIndex > b.length - 1) break block6;
            for (int i = bIndex; i <= b.length - 1; ++i) {
                c.add(b[i]);
            }
        }
        return c;
    }

    private static int[] mergeByArray(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            if (a[i] <= b[j]) {
                if (a[i] == b[j]) {
                    ++j;
                    continue;
                }
                c[k] = a[i];
                ++i;
                ++k;
                continue;
            }
            c[k] = b[j];
            ++j;
            ++k;
        }
        while (i < a.length) {
            c[k] = a[i];
            ++k;
            ++i;
        }
        while (j < b.length) {
            c[k] = b[j];
            ++j;
            ++k;
        }
        return c;
    }

    private static Map<Integer, Integer> mergeByTreeMap(int[] a, int[] b) {
        int i;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (i = 0; i < a.length; ++i) {
            map.put(a[i], a[i]);
        }
        for (i = 0; i < b.length; ++i) {
            map.put(b[i], b[i]);
        }
        return map;
    }

    public static String print(int[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append("," + array[i]);
        }
        return sb.toString().substring(1);
    }

    public static int searchOf(byte[] s, byte value, int index) {
        int rtn = 0;
        if (s != null) {
            for (int i = index; i < s.length; ++i) {
                if (value != s[i]) continue;
                ++rtn;
            }
        }
        return rtn;
    }

    public static int indexOf(byte[] s, byte value, int index) {
        int rtn = -1;
        if (s != null) {
            for (int i = index; i < s.length; ++i) {
                if (value != s[i]) continue;
                rtn = i;
                break;
            }
        }
        return rtn;
    }

    public static int indexOf(byte[] s, byte[] value, int index) {
        int rtn = -1;
        boolean start = false;
        if (s != null) {
            for (int i = index; i < s.length; ++i) {
                if (value[0] != s[i]) continue;
                rtn = i;
                break;
            }
        }
        return rtn;
    }
}

