/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileCopy {
    private static final int BUFFEREDSIZE = 1024;

    public static void CopyOFFile(String sourceDir, String targetDir) throws IOException {
        File file = new File(sourceDir);
        new File(targetDir).mkdirs();
        if (file.isFile()) {
            FileCopy.copyFile(file, new File(targetDir));
        } else {
            File[] files = new File(sourceDir).listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    FileCopy.copyFile(files[i], new File(targetDir + File.separator + files[i].getName()));
                }
                if (!files[i].isDirectory()) continue;
                String sourcesDir = sourceDir + File.separator + files[i].getName();
                String targetsDir = targetDir + File.separator + files[i].getName();
                FileCopy.copyDirectiory(sourcesDir, targetsDir);
            }
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int len;
        FileInputStream input = new FileInputStream(sourceFile);
        BufferedInputStream inBuff = new BufferedInputStream(input);
        FileOutputStream output = new FileOutputStream(targetFile);
        BufferedOutputStream outBuff = new BufferedOutputStream(output);
        byte[] b = new byte[5120];
        while ((len = inBuff.read(b)) != -1) {
            outBuff.write(b, 0, len);
        }
        outBuff.flush();
        inBuff.close();
        outBuff.close();
        output.close();
        input.close();
    }

    public static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        new File(targetDir).mkdirs();
        File[] file = new File(sourceDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                File sourceFile = file[i];
                File targetFile = new File(new File(targetDir).getAbsolutePath() + File.separator + file[i].getName());
                FileCopy.copyFile(sourceFile, targetFile);
            }
            if (!file[i].isDirectory()) continue;
            String dir1 = sourceDir + "/" + file[i].getName();
            String dir2 = targetDir + "/" + file[i].getName();
            FileCopy.copyDirectiory(dir1, dir2);
        }
    }
}

