/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.oiue.tools.list.ListUtil;
import org.oiue.tools.map.MapUtil;

public class JSONUtil {
    public static List<Object> toList(JSONArray array) {
        return JSONUtil.toList(array, true);
    }

    public static List<Object> toList(JSONArray array, boolean force) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (array == null) {
            return result;
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.opt(i);
            if (value instanceof JSONObject) {
                result.add(JSONUtil.toMap((JSONObject)value, force));
                continue;
            }
            if (value instanceof JSONArray) {
                result.add(JSONUtil.toList((JSONArray)value, force));
                continue;
            }
            if (value.toString().startsWith("{") && force) {
                result.add(JSONUtil.parserToMap(new JSONObject(value.toString())));
                continue;
            }
            if (value.toString().startsWith("[") && force) {
                result.add(JSONUtil.parserToList(new JSONArray(value.toString())));
                continue;
            }
            result.add(value);
        }
        return result;
    }

    public static Map<String, Object> toMap(JSONObject json) {
        return JSONUtil.toMap(json, true);
    }

    public static Map<String, Object> toMap(JSONObject json, boolean force) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (json == null || json.length() == 0) {
            return result;
        }
        for (String e : JSONObject.getNames(json)) {
            Object value = json.opt(e);
            if (value instanceof JSONObject) {
                result.put(e, JSONUtil.toMap((JSONObject)value, force));
                continue;
            }
            if (value instanceof JSONArray) {
                result.put(e, JSONUtil.toList((JSONArray)value, force));
                continue;
            }
            if (value == null) {
                result.put(e, value);
                continue;
            }
            if (value.toString().startsWith("{") && force) {
                result.put(e, JSONUtil.parserToMap(new JSONObject(value.toString())));
                continue;
            }
            if (value.toString().startsWith("[") && force) {
                result.put(e, JSONUtil.parserToList(new JSONArray(value.toString())));
                continue;
            }
            result.put(e, value);
        }
        return result;
    }

    public static Map<?, Object> parserToMap(JSONObject json) {
        return JSONUtil.parserToMap(json, true);
    }

    public static Map<?, Object> parserToMap(JSONObject json, boolean force) {
        return JSONUtil.toMap(json, force);
    }

    public static List<?> parserToList(JSONArray json) {
        return JSONUtil.parserToList(json, true);
    }

    public static List<?> parserToList(JSONArray json, boolean force) {
        return JSONUtil.toList(json, force);
    }

    public static Map<?, Object> parserStrToMap(String jsonStr) throws JSONException {
        return JSONUtil.parserStrToMap(jsonStr, true);
    }

    public static Map<?, Object> parserStrToMap(String jsonStr, boolean force) throws JSONException {
        try {
            return JSONUtil.parserToMap(new JSONObject(jsonStr), force);
        }
        catch (Throwable e) {
            GsonBuilder gb = new GsonBuilder();
            Gson g = gb.create();
            Map map = (Map)g.fromJson(jsonStr, new TypeToken<Map>(){}.getType());
            return map;
        }
    }

    public static List<?> parserStrToList(String jsonAry) throws JSONException {
        return JSONUtil.parserStrToList(jsonAry, true);
    }

    public static List<?> parserStrToList(String jsonAry, boolean force) throws JSONException {
        return JSONUtil.parserToList(new JSONArray(jsonAry), force);
    }

    public static String parserToStr(Map map) {
        return new JSONObject(map).toString();
    }

    public static String parserToStr(List list) {
        return new JSONArray(list).toString();
    }

    public static String getJSONString(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        if (string.startsWith("{") || string.startsWith("[")) {
            return string;
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String getJSONString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof List) {
            stringBuffer.append(ListUtil.toString((List)object));
        } else if (object instanceof Iterable) {
            stringBuffer.append(JSONUtil.parserToStr((List)object));
        } else if (object instanceof Map) {
            stringBuffer.append(MapUtil.toString((Map)object));
        } else if (object instanceof String) {
            stringBuffer.append("{\"v\":");
            stringBuffer.append(JSONUtil.getJSONString((String)object));
            stringBuffer.append("}");
        } else if (object != null) {
            stringBuffer.append(object);
        } else {
            stringBuffer.append("{\"v\":null}");
        }
        stringBuffer.trimToSize();
        return stringBuffer.toString();
    }
}

