/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class liense
implements Serializable {
    public static Map<Integer, String> getLocalIP() {
        Map<Integer, String> macList = new HashMap<Integer, String>();
        String os = System.getProperty("os.name");
        if (os != null) {
            if ((os = os.toLowerCase()).indexOf("window") >= 0) {
                macList = liense.getLocalIPOfWindows();
            }
            if (os.indexOf("linux") >= 0) {
                macList = liense.getLocalIPOfLinux();
            }
        }
        return macList;
    }

    public static Map<Integer, String> getLocalIPOfWindows() {
        HashMap<Integer, String> macList = new HashMap<Integer, String>();
        String address = "";
        int inc = 0;
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("ipconfig", "/all");
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                if ((line = line.toLowerCase()).indexOf("ip address") == -1) continue;
                int index = line.indexOf(":");
                address = line.substring(index + 1).trim();
                macList.put(++inc, address);
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return macList;
    }

    public static Map<Integer, String> getLocalIPOfLinux() {
        HashMap<Integer, String> macList = new HashMap<Integer, String>();
        int inc = 0;
        String address = "";
        String strFlag = "inet addr:";
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("ifconfig -a | grep \"inet addr\"");
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (line.indexOf(strFlag) == -1) continue;
                int index = line.indexOf(strFlag);
                address = line.substring(index + strFlag.length()).trim();
                address = address.substring(0, address.indexOf(" "));
                macList.put(++inc, address);
                System.out.println("address=" + address + "\t" + line);
            }
            br.close();
            return macList;
        }
        catch (IOException iOException) {
            return macList;
        }
    }

    public static Map<Integer, String> getLocalMACAddress() {
        Map<Integer, String> macList = new HashMap<Integer, String>();
        String os = System.getProperty("os.name");
        if (os != null) {
            if ((os = os.toLowerCase()).indexOf("window") >= 0) {
                macList = liense.getLocalMACAddressOfWindows();
            }
            if (os.indexOf("linux") >= 0) {
                macList = liense.getLocalMACAddressOfLinux();
            }
        }
        return macList;
    }

    public static Map<Integer, String> getLocalMACAddressOfWindows() {
        HashMap<Integer, String> macList = new HashMap<Integer, String>();
        String address = "";
        int inc = 0;
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("ipconfig", "/all");
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                if ((line = line.toLowerCase()).indexOf("physical address") == -1) continue;
                int index = line.indexOf(":");
                address = line.substring(index + 1).trim();
                address = address.replaceAll("-", ":");
                macList.put(++inc, address);
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return macList;
    }

    public static Map<Integer, String> getLocalMACAddressOfLinux() {
        HashMap<Integer, String> macList = new HashMap<Integer, String>();
        int inc = 0;
        String address = "";
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("ifconfig", "-a");
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                if (line.indexOf("Link encap:Ethernet  HWaddr") == -1) continue;
                int index = line.indexOf("HWaddr");
                address = line.substring(index + 7).trim();
                address = address.replaceAll("-", ":");
                macList.put(++inc, address);
            }
            br.close();
            return macList;
        }
        catch (IOException iOException) {
            return macList;
        }
    }
}

