/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.security;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.oiue.tools.exception.OIUEException;

public class SecurityUtil {
    private static final String KEY_DH = "DH";
    public static final String PUBLIC_KEY = "DHPublicKey";
    public static final String PRIVATE_KEY = "DHPrivateKey";
    public static final String KEY_DH_DES = "DES";

    public static Map<String, Object> initKey() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_DH);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            DHPublicKey publicKey = (DHPublicKey)keyPair.getPublic();
            DHPrivateKey privateKey = (DHPrivateKey)keyPair.getPrivate();
            HashMap<String, Object> keyMap = new HashMap<String, Object>();
            keyMap.put(PUBLIC_KEY, publicKey);
            keyMap.put(PRIVATE_KEY, privateKey);
            return keyMap;
        }
        catch (Throwable e) {
            throw new OIUEException(-120, "", e);
        }
    }

    public static Map<String, Object> initKey(byte[] key) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_DH);
            DHPublicKey dhPublicKey = (DHPublicKey)keyFactory.generatePublic(keySpec);
            DHParameterSpec dhParameterSpec = dhPublicKey.getParams();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_DH);
            keyPairGenerator.initialize(dhParameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            DHPublicKey publicKey = (DHPublicKey)keyPair.getPublic();
            DHPrivateKey privateKey = (DHPrivateKey)keyPair.getPrivate();
            HashMap<String, Object> keyMap = new HashMap<String, Object>();
            keyMap.put(PUBLIC_KEY, publicKey);
            keyMap.put(PRIVATE_KEY, privateKey);
            return keyMap;
        }
        catch (Throwable e) {
            throw new OIUEException(-120, "", e);
        }
    }

    public static byte[] getSecretKeyBytes(byte[] publicKey, byte[] privateKey) {
        try {
            return SecurityUtil.getSecretKey(publicKey, privateKey).getEncoded();
        }
        catch (Throwable e) {
            throw new OIUEException(-120, "", e);
        }
    }

    public static SecretKey getSecretKey(byte[] publicKey, byte[] privateKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_DH);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(privateKey);
            PrivateKey priKey = keyFactory.generatePrivate(priKeySpec);
            KeyAgreement keyAgreement = KeyAgreement.getInstance(KEY_DH);
            keyAgreement.init(priKey);
            keyAgreement.doPhase(pubKey, true);
            SecretKey secretKey = keyAgreement.generateSecret(KEY_DH_DES);
            return secretKey;
        }
        catch (Throwable e) {
            throw new OIUEException(-120, "", e);
        }
    }

    public static byte[] getPublicKey(Map<String, Object> keyMap) {
        DHPublicKey key = (DHPublicKey)keyMap.get(PUBLIC_KEY);
        return key.getEncoded();
    }

    public static byte[] getPrivateKey(Map<String, Object> keyMap) {
        DHPrivateKey key = (DHPrivateKey)keyMap.get(PRIVATE_KEY);
        return key.getEncoded();
    }

    public static byte[] encryptDH(byte[] data, byte[] publicKey, byte[] privateKey) {
        byte[] bytes = null;
        try {
            SecretKey secretKey = SecurityUtil.getSecretKey(publicKey, privateKey);
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(1, secretKey);
            bytes = cipher.doFinal(data);
        }
        catch (Throwable e) {
            throw new OIUEException(-120, "", e);
        }
        return bytes;
    }

    public static byte[] decryptDH(byte[] data, byte[] publicKey, byte[] privateKey) {
        byte[] bytes = null;
        try {
            SecretKey secretKey = SecurityUtil.getSecretKey(publicKey, privateKey);
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(2, secretKey);
            bytes = cipher.doFinal(data);
        }
        catch (Throwable e) {
            throw new OIUEException(-120, "", e);
        }
        return bytes;
    }
}

