/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.string;

import java.io.UnsupportedEncodingException;

public class ChangeCharset {
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    public static final String GBK = "GBK";

    public String toASCII(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, US_ASCII);
    }

    public String toISO_8859_1(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, ISO_8859_1);
    }

    public String toUTF_8(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_8);
    }

    public String toUTF_16BE(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_16BE);
    }

    public String toUTF_16LE(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_16LE);
    }

    public String toUTF_16(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_16);
    }

    public String toGBK(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, GBK);
    }

    public String changeCharset(String str, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes();
            return new String(bs, newCharset);
        }
        return null;
    }

    public String changeCharset(String str, String oldCharset, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes(oldCharset);
            return new String(bs, newCharset);
        }
        return null;
    }

    public static String bytes2Str(byte[] b) {
        StringBuffer bs = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            bs.append(b[i] + " ");
        }
        return bs.toString();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        ChangeCharset test = new ChangeCharset();
        String str = "\u4f60.jpg";
        System.out.println("str: " + str);
        String gbk = test.toGBK(str);
        System.out.println("\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        System.out.println();
        String ascii = test.toASCII(str);
        System.out.println("\u8f6c\u6362\u6210US-ASCII\u7801: " + ascii + "$" + ChangeCharset.bytes2Str(ascii.getBytes()));
        gbk = test.changeCharset(ascii, US_ASCII, GBK);
        System.out.println("\u518d\u628aASCII\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        System.out.println();
        String iso88591 = test.toISO_8859_1(str);
        System.out.println("\u8f6c\u6362\u6210ISO-8859-1\u7801: " + iso88591 + "$" + ChangeCharset.bytes2Str(iso88591.getBytes()) + "$" + new String(iso88591.getBytes(ISO_8859_1), GBK));
        gbk = test.changeCharset(iso88591, ISO_8859_1, GBK);
        System.out.println("\u518d\u628aISO-8859-1\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        System.out.println();
        String utf8 = test.toUTF_8(str);
        System.out.println("\u8f6c\u6362\u6210UTF-8\u7801: " + utf8 + "$" + ChangeCharset.bytes2Str(utf8.getBytes()));
        gbk = test.changeCharset(utf8, UTF_8, GBK);
        System.out.println("\u518d\u628aUTF-8\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        System.out.println();
        String utf16be = test.toUTF_16BE(str);
        System.out.println("\u8f6c\u6362\u6210UTF-16BE\u7801:" + utf16be + "$" + ChangeCharset.bytes2Str(utf16be.getBytes()));
        gbk = test.changeCharset(utf16be, UTF_16BE, GBK);
        System.out.println("\u518d\u628aUTF-16BE\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        System.out.println();
        String utf16le = test.toUTF_16LE(str);
        System.out.println("\u8f6c\u6362\u6210UTF-16LE\u7801:" + utf16le + "$" + ChangeCharset.bytes2Str(utf16le.getBytes()));
        gbk = test.changeCharset(utf16le, UTF_16LE, GBK);
        System.out.println("\u518d\u628aUTF-16LE\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        System.out.println();
        String utf16 = test.toUTF_16(str);
        System.out.println("\u8f6c\u6362\u6210UTF-16\u7801:" + utf16 + "$" + ChangeCharset.bytes2Str(utf16.getBytes()));
        gbk = test.changeCharset(utf16, UTF_16LE, GBK);
        System.out.println("\u518d\u628aUTF-16\u7801\u7684\u5b57\u7b26\u4e32\u8f6c\u6362\u6210GBK\u7801: " + gbk + "$" + ChangeCharset.bytes2Str(gbk.getBytes()));
        String s = new String("\u4e2d\u6587".getBytes(UTF_8), UTF_8);
        System.out.println(s);
    }
}

