/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.string;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import org.oiue.tools.string.StringReplace;
import org.oiue.tools.string.StringUtil;

public class StringForPage {
    public static String replaceHtmlCode(String content) {
        if (StringUtil.isEmpty(content)) {
            return "";
        }
        String[] eventKeywords = new String[]{"onmouseover", "onmouseout", "onmousedown", "onmouseup", "onmousemove", "onclick", "ondblclick", "onkeypress", "onkeydown", "onkeyup", "ondragstart", "onerrorupdate", "onhelp", "onreadystatechange", "onrowenter", "onrowexit", "onselectstart", "onload", "onunload", "onbeforeunload", "onblur", "onerror", "onfocus", "onresize", "onscroll", "oncontextmenu"};
        content = StringReplace.replace(content, "<script", "&ltscript", false);
        content = StringReplace.replace(content, "</script", "&lt/script", false);
        content = StringReplace.replace(content, "<marquee", "&ltmarquee", false);
        content = StringReplace.replace(content, "</marquee", "&lt/marquee", false);
        for (int i = 0; i < eventKeywords.length; ++i) {
            content = StringReplace.replace(content, eventKeywords[i], "_" + eventKeywords[i], false);
        }
        return content;
    }

    public static String setTag(String sourceStr) {
        int j = sourceStr.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        for (int i = 0; i < j; ++i) {
            char ch = sourceStr.charAt(i);
            if (ch == '<') {
                stringbuffer.append("&lt");
                continue;
            }
            if (ch == '>') {
                stringbuffer.append("&gt");
                continue;
            }
            if (ch == '&') {
                stringbuffer.append("&amp");
                continue;
            }
            if (ch == '%') {
                stringbuffer.append("%%");
                continue;
            }
            stringbuffer.append(ch);
        }
        return stringbuffer.toString();
    }

    public static String setBr(String sourceStr) {
        int j = sourceStr.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        for (int i = 0; i < j; ++i) {
            if (sourceStr.charAt(i) == '\n' || sourceStr.charAt(i) == '\r') continue;
            stringbuffer.append(sourceStr.charAt(i));
        }
        return stringbuffer.toString();
    }

    public static String setNbsp(String sourceStr) {
        int j = sourceStr.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        for (int i = 0; i < j; ++i) {
            if (sourceStr.charAt(i) == ' ') {
                stringbuffer.append("&nbsp;");
                continue;
            }
            stringbuffer.append(sourceStr.charAt(i) + "");
        }
        return stringbuffer.toString();
    }

    public static String toQuoteMark(String sourceStr) {
        sourceStr = StringReplace.replaceStr(sourceStr, "'", "&#39;");
        sourceStr = StringReplace.replaceStr(sourceStr, "\"", "&#34;");
        sourceStr = StringReplace.replaceStr(sourceStr, "\r\n", "\n");
        return sourceStr;
    }

    public static String toHtml(String sourceStr) {
        sourceStr = StringReplace.replaceStr(sourceStr, "<", "&#60;");
        sourceStr = StringReplace.replaceStr(sourceStr, ">", "&#62;");
        return sourceStr;
    }

    public static String textToHtml(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return "";
        }
        sourceStr = StringReplace.replaceStr(sourceStr, "<", "&#60;");
        sourceStr = StringReplace.replaceStr(sourceStr, ">", "&#62;");
        sourceStr = StringReplace.replaceStr(sourceStr, "\n", "<br>\n");
        sourceStr = StringReplace.replaceStr(sourceStr, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        sourceStr = StringReplace.replaceStr(sourceStr, "  ", "&nbsp;&nbsp;");
        return sourceStr;
    }

    public static String replaceHtmlToText(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return "";
        }
        return StringForPage.setBr(StringForPage.setTag(sourceStr));
    }

    public static String toBR(String sourceStr) {
        sourceStr = StringReplace.replaceStr(sourceStr, "\n", "<br>\n");
        sourceStr = StringReplace.replaceStr(sourceStr, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        sourceStr = StringReplace.replaceStr(sourceStr, "  ", "&nbsp;&nbsp;");
        return sourceStr;
    }

    public static String replaceEnter(String sourceStr) {
        return StringReplace.replaceStr(sourceStr, "\n", "<br>");
    }

    public static String replacebr(String sourceStr) {
        return StringReplace.replaceStr(sourceStr, "<br>", "\n");
    }

    public static String replaceQuote(String sourceStr) {
        return StringReplace.replaceStr(sourceStr, "'", "''");
    }

    public static String toSQL(String sourceStr) {
        return StringReplace.replaceStr(sourceStr, "\r\n", "\n");
    }

    public static String replaceSql(String sourceStr) {
        return StringReplace.replaceStr(sourceStr, "'", "''");
    }

    public static String replacefu(String sourceStr) {
        return StringReplace.replaceStr(sourceStr, "\"", "\\\"");
    }

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String escapeSrc(String src) {
        return StringForPage.escape(StringForPage.escape(src));
    }

    public static String unescape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String unescapeSrc(String src) {
        return StringForPage.unescape(StringForPage.unescape(src));
    }

    public static String encode(String src) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(src)) {
            return "";
        }
        return URLEncoder.encode(src, "UTF-8");
    }

    public static String decode(String src) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(src)) {
            return "";
        }
        return URLDecoder.decode(src, "UTF-8");
    }

    public static boolean createFile(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean createDir(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File dir = new File(application.getRealPath(filePath));
            return dir.mkdirs();
        }
        return false;
    }

    public static boolean checkFileExists(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            return file.exists();
        }
        return false;
    }

    public static void deleteFile(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            file.delete();
        }
    }

    public static String scriptRedirect(String url) {
        return "<SCRIPT language=\"JavaScript\">document.location=\"" + url + "\";</SCRIPT>";
    }

    public static String scriptHistoryBack() {
        return "<SCRIPT language=\"JavaScript\">history.back();</SCRIPT>";
    }

    public static String scriptAlert(String message) {
        return "<SCRIPT language=\"JavaScript\">alert(\"" + message + "\");</SCRIPT>";
    }
}

