/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.string;

import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class StringUtil {
    public static boolean isEmpty(String sourceStr) {
        return sourceStr == null || sourceStr.length() == 0;
    }

    public static boolean isEmptys(String sourceStr) {
        return sourceStr == null || sourceStr.length() == 0 || sourceStr.trim().equalsIgnoreCase("null");
    }

    public static String isEmpty(String sourceStr, String errorMsg) {
        if (StringUtil.isEmpty(sourceStr)) {
            return errorMsg;
        }
        return "";
    }

    public static boolean isTrue(String bool) {
        if (bool == null) {
            return false;
        }
        bool = bool.toLowerCase();
        return (bool = bool.trim()).equals("true") || bool.equals("yes") || bool.equals("y");
    }

    public static boolean isFalse(String bool) {
        if (bool == null) {
            return true;
        }
        bool = bool.toLowerCase();
        return !(bool = bool.trim()).equals("false") && !bool.equals("no") && !bool.equals("n");
    }

    public static int getBytesLength(String sourceStr) {
        if (sourceStr == null) {
            return 0;
        }
        int bytesLength = sourceStr.getBytes().length;
        return bytesLength;
    }

    public static String trimTailSpaces(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return "";
        }
        String trimedString = sourceStr.trim();
        if (trimedString.length() == sourceStr.length()) {
            return sourceStr;
        }
        return sourceStr.substring(0, sourceStr.indexOf(trimedString) + trimedString.length());
    }

    public static int parseInt(String sourceStr) {
        try {
            return Integer.parseInt(sourceStr);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean isNumeric(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return false;
        }
        for (int i = 0; i < sourceStr.length(); ++i) {
            char charAt = sourceStr.charAt(i);
            if (Character.isDigit(charAt)) continue;
            return false;
        }
        return true;
    }

    public static String getFieldName(String sourceStr) {
        char charAt;
        if (StringUtil.isEmpty(sourceStr)) {
            return "";
        }
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < sourceStr.length() && !Character.isDigit(charAt = sourceStr.charAt(i)); ++i) {
            sBuffer.append(charAt);
        }
        return sBuffer.toString();
    }

    public static int getFieldId(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return 0;
        }
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < sourceStr.length(); ++i) {
            char charAt = sourceStr.charAt(i);
            if (!Character.isDigit(charAt)) continue;
            sBuffer.append(charAt);
        }
        if (sBuffer != null && sBuffer.length() > 0) {
            return Integer.parseInt(sBuffer.toString());
        }
        return -1;
    }

    public static String changeEncoding(String sourceStr, String sourceEncoding, String targetEncoding) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(sourceStr)) {
            return sourceStr;
        }
        byte[] bytes = sourceStr.getBytes(sourceEncoding);
        return new String(bytes, targetEncoding);
    }

    public static String toUTF8(String sourceStr) throws UnsupportedEncodingException {
        return StringUtil.changeEncoding(sourceStr, "ISO8859-1", "UTF-8");
    }

    public static String toISO(String sourceStr) throws UnsupportedEncodingException {
        return StringUtil.changeEncoding(sourceStr, "UTF-8", "ISO8859-1");
    }

    public static String clearNull(String input) {
        return StringUtil.isEmpty(input) ? "" : input;
    }

    public static String limitStringLength(String input, int maxLength) {
        if (StringUtil.isEmpty(input)) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input;
        }
        return input.substring(0, maxLength - 3) + "...";
    }

    public static boolean License(String license, int index) {
        if (license == null || license.length() <= index) {
            return false;
        }
        char c = license.charAt(index);
        return c == '1';
    }

    public static boolean LicenseArray(String license, int index) {
        if (license == null || license.length() < 1) {
            return false;
        }
        String[] c = license.split(",");
        return StringUtil.LicenseArray(c, index);
    }

    public static boolean LicenseArray(String[] license, int index) {
        if (license == null || license.length == 0) {
            return false;
        }
        for (int i = 0; i < license.length; ++i) {
            if (license[i] == null || !license[i].equals(index + "")) continue;
            return true;
        }
        return false;
    }

    public static String firstToUpper(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static Map parStr2Map(String par, String firstSeparator, String secondSeparator) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : strings = par.split(firstSeparator)) {
            if (string == null) continue;
            String[] st = string.split(secondSeparator);
            map.put(st[0].trim(), st.length > 1 ? st[1].trim() : "");
        }
        return map;
    }

    public static List parStr2Arr(String par, String firstSeparator, String secondSeparator) {
        String[] strings;
        ArrayList list = new ArrayList();
        for (String string : strings = par.split(firstSeparator)) {
            if (string == null) continue;
            String[] st = string.split(secondSeparator);
            ArrayList<String> lists = new ArrayList<String>();
            lists.add(st[0].trim());
            lists.add(st.length > 1 ? st[1].trim() : "");
            list.add(lists);
        }
        return list;
    }

    public static List parStr2ArrR(String par, String firstSeparator, String secondSeparator) {
        String[] strings;
        ArrayList list = new ArrayList();
        for (String string : strings = par.split(firstSeparator)) {
            if (string == null) continue;
            String[] st = string.split(secondSeparator);
            ArrayList<String> lists = new ArrayList<String>();
            lists.add(st.length > 1 ? st[1].trim() : "");
            lists.add(st[0].trim());
            list.add(lists);
        }
        return list;
    }

    public static Map parStr2MapR(String par, String firstSeparator, String secondSeparator) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : strings = par.split(firstSeparator)) {
            if (string == null) continue;
            String[] st = string.split(secondSeparator);
            map.put(st.length > 1 ? st[1].trim() : "", st[0].trim());
        }
        return map;
    }

    public static List Str2List(String source, String separator) {
        if (StringUtil.isEmptys(source) || StringUtil.isEmptys(separator)) {
            return new ArrayList();
        }
        String[] strs = source.split(separator);
        return Arrays.asList(strs);
    }

    public static boolean BracketMatching(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return true;
        }
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        boolean flag = true;
        for (int i = 0; i < sourceStr.length(); ++i) {
            char ch = sourceStr.charAt(i);
            if (ch == '(' || ch == '[' || ch == '{') {
                stack.offerFirst(Character.valueOf(ch));
                continue;
            }
            if (ch == ')') {
                if (stack.peekFirst() != null && ((Character)stack.peekFirst()).charValue() == '(') {
                    stack.pollFirst();
                    continue;
                }
                flag = false;
                break;
            }
            if (ch == ']') {
                if (stack.peekFirst() != null && ((Character)stack.peekFirst()).charValue() == '[') {
                    stack.pollFirst();
                    continue;
                }
                flag = false;
                break;
            }
            if (ch != '}') continue;
            if (stack.peekFirst() != null && ((Character)stack.peekFirst()).charValue() == '{') {
                stack.pollFirst();
                continue;
            }
            flag = false;
            break;
        }
        if (flag) {
            flag = stack.isEmpty();
        }
        return flag;
    }

    public static void checkNull(Object object, String name) {
        if (null == object) {
            String message = MessageFormat.format("t", new String(name));
            throw new NullPointerException(message);
        }
    }

    public static void checkString(String string, String name) {
        if (StringUtil.isEmpty(string)) {
            String message = MessageFormat.format("t", new String(name));
            throw new InvalidParameterException(message);
        }
    }

    public static Object scriptEngine(String epStr, Map per) throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        for (String type : per.keySet()) {
            engine.put(type, per.get(type));
        }
        return engine.eval(epStr);
    }

    public static Collection<String> analyzeStringPer(String source, String start, String end) {
        ArrayList<String> pers = new ArrayList<String>();
        StringBuffer s = new StringBuffer();
        String sourcetemp = source;
        sourcetemp = sourcetemp.replace(start, "<oiue>");
        String[] SQLtemps = sourcetemp.split("<oiue>");
        s.append(SQLtemps[0]);
        for (int i = 1; i < SQLtemps.length; ++i) {
            String tt = SQLtemps[i];
            Object[] temps = (tt = tt.replace(end, "<oiue>")).split("<oiue>");
            if (temps.length == 2) {
                pers.add(temps[0]);
                continue;
            }
            if (tt.length() == temps[0].length() + 6) {
                pers.add(temps[0]);
                continue;
            }
            throw new RuntimeException("source[" + source + "] tt[" + tt + "] temps:" + Arrays.toString(temps));
        }
        return pers;
    }
}

