/*
 * Decompiled with CFR 0.152.
 */
package org.oiue.tools.string;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class TranCharset {
    private static final String PRE_FIX_UTF = "&#x";
    private static final String POS_FIX_UTF = ";";

    public static String XmlFormalize(String sTemp) {
        StringBuffer sb = new StringBuffer();
        if (sTemp == null || sTemp.equals("")) {
            return "";
        }
        String s = TranCharset.TranEncodeTOGB(sTemp);
        block7: for (int i = 0; i < s.length(); ++i) {
            char cChar = s.charAt(i);
            if (TranCharset.isGB2312(cChar)) {
                sb.append(PRE_FIX_UTF);
                sb.append(Integer.toHexString(cChar));
                sb.append(POS_FIX_UTF);
                continue;
            }
            switch (cChar) {
                case ' ': {
                    sb.append("&#32;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(cChar);
                }
            }
        }
        return sb.toString();
    }

    public static String TranEncodeTOGB(String str) {
        try {
            String strEncode = TranCharset.getEncoding(str);
            String temp = new String(str.getBytes(strEncode), "GB2312");
            return temp;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean isGB2312(char c) {
        Character ch = new Character(c);
        String sCh = ch.toString();
        try {
            byte[] bb = sCh.getBytes("gb2312");
            if (bb.length > 1) {
                return true;
            }
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return false;
    }

    public static String getEncoding(String str) {
        String encode = "GB2312";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s = encode;
                return s;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        encode = "ISO-8859-1";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s1 = encode;
                return s1;
            }
        }
        catch (Exception s1) {
            // empty catch block
        }
        encode = "UTF-8";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s2 = encode;
                return s2;
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        encode = "GBK";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s3 = encode;
                return s3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

