/*
 * Decompiled with CFR 0.152.
 */
package org.okkam.awesome.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.okkam.awesome.apache.commons.lang3.ArrayUtils;

public class OkkamArrays {
    private OkkamArrays() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> int indexOf(T[] array, T valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind);
    }

    public static <T> List<T> toArrayList(T[] sourceArray) {
        ArrayList targetList = new ArrayList(sourceArray.length);
        Collections.addAll(targetList, sourceArray);
        return targetList;
    }

    @SafeVarargs
    public static <T> List<T> toArrayListStartingWith(T[] array, T ... elems) {
        ArrayList ret = new ArrayList(elems.length);
        Collections.addAll(ret, elems);
        Collections.addAll(ret, array);
        return ret;
    }

    public static <T> List<T> toArrayListEndingWith(T[] array, T ... elements) {
        ArrayList ret = new ArrayList(elements.length);
        Collections.addAll(ret, array);
        Collections.addAll(ret, elements);
        return ret;
    }

    public static <T> T[] addAll(T[] array, T ... elements) {
        return ArrayUtils.addAll(array, elements);
    }

    public static <T> T[] addAll(T[] array, List<T> addElmts) {
        T[] newArray = Arrays.copyOf(array, array.length + addElmts.size());
        System.arraycopy(array, 0, newArray, 0, array.length);
        for (int i = 0; i < addElmts.size(); ++i) {
            newArray[array.length + i] = addElmts.get(i);
        }
        return newArray;
    }
}

