/*
 * Decompiled with CFR 0.152.
 */
package org.okkam.awesome.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OkkamLists {
    private OkkamLists() {
        throw new IllegalStateException("Utility class");
    }

    @SafeVarargs
    public static <T> List<T> appendElements(List<T> list, T ... elements) {
        Collections.addAll(list, elements);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> prependElements(List<T> list, T ... elements) {
        int i = 0;
        for (T element : elements) {
            list.add(i++, element);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> addIfNotContained(List<T> list, T ... elements) {
        for (T element : elements) {
            if (list.contains(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static <T> boolean addIfEquals(List<T> list, T elemToAdd, T elemToCompare) {
        if (elemToAdd.equals(elemToCompare)) {
            list.add(elemToAdd);
            return true;
        }
        return false;
    }

    public static <T, T1> boolean addIfEquals(List<T> list, T elemToAdd, T1 element1, T1 element2) {
        if (element1.equals(element2)) {
            list.add(elemToAdd);
            return true;
        }
        return false;
    }

    public static <T> List<T> createArrayListIfNull(List<T> list) {
        return list == null ? new ArrayList() : list;
    }
}

