/*
 * Decompiled with CFR 0.152.
 */
package org.okkam.awesome.utils;

import java.util.Map;

public class OkkamStrings {
    private OkkamStrings() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isEmptyOrNull(String string, boolean trim) {
        return string == null || (trim ? string.trim().isEmpty() : string.isEmpty());
    }

    public static boolean isEmptyAndNotNull(String string, boolean trim) {
        return string != null && (trim ? string.trim().isEmpty() : string.isEmpty());
    }

    public static boolean noOneIsEmptyOrNull(boolean trim, String ... strings) {
        for (String string : strings) {
            if (!OkkamStrings.isEmptyOrNull(string, trim)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOneOf(String string, boolean trim, String ... ors) {
        string = OkkamStrings.trimIfNecessary(true, string);
        for (String or : ors) {
            if (!(string == null ? or == null : string.equals(or = OkkamStrings.trimIfNecessary(trim, or)))) continue;
            return true;
        }
        return false;
    }

    public static String trimIfNecessary(boolean trim, String src) {
        return src != null && trim ? src.trim() : src;
    }

    @SafeVarargs
    public static <T> StringBuilder appendAll(StringBuilder sb, T ... elements) {
        for (T element : elements) {
            sb.append(element);
        }
        return sb;
    }

    public static <T> String separateArrayBy(T[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append((Object)(array[i] == null ? "" : array[i]));
        }
        return sb.toString();
    }

    public static <T> String separateTreeMapValuesBy(Map<T, String> map, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<T, String> entry : map.entrySet()) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(entry.getValue());
            ++i;
        }
        return sb.toString();
    }
}

