/*
 * Decompiled with CFR 0.152.
 */
package org.okkam.awesome.utils;

import java.util.ArrayList;
import java.util.Map;

public class OkkamStrings {
    private OkkamStrings() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isEmptyOrNull(String string, boolean trim) {
        return string == null || (trim ? string.trim().isEmpty() : string.isEmpty());
    }

    public static boolean isEmptyAndNotNull(String string, boolean trim) {
        return string != null && (trim ? string.trim().isEmpty() : string.isEmpty());
    }

    public static boolean noOneIsEmptyOrNull(boolean trim, String ... strings) {
        for (String string : strings) {
            if (!OkkamStrings.isEmptyOrNull(string, trim)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOneOf(String string, boolean trim, String ... ors) {
        string = OkkamStrings.trimIfNecessary(true, string);
        for (String or : ors) {
            if (!(string == null ? or == null : string.equals(or = OkkamStrings.trimIfNecessary(trim, or)))) continue;
            return true;
        }
        return false;
    }

    public static String trimIfNecessary(boolean trim, String src) {
        return src != null && trim ? src.trim() : src;
    }

    @SafeVarargs
    public static <T> StringBuilder appendAll(StringBuilder sb, T ... elements) {
        for (T element : elements) {
            sb.append(element);
        }
        return sb;
    }

    public static <T> String separateArrayBy(T[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append((Object)(array[i] == null ? "" : array[i]));
        }
        return sb.toString();
    }

    public static <T> String separateTreeMapValuesBy(Map<T, String> map, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<T, String> entry : map.entrySet()) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(entry.getValue());
            ++i;
        }
        return sb.toString();
    }

    public static String[] splitByChar(String stringToSplit, char charToSplit) {
        char[] charArray = stringToSplit.toCharArray();
        ArrayList<String> ret = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != charToSplit) continue;
            ret.add(new String(charArray, start, i - start));
            start = i + 1;
        }
        ret.add(new String(charArray, start, charArray.length - start));
        return ret.toArray(new String[ret.size()]);
    }

    public static <T> String concatRange(T[] arr, String separator, int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("Illegal range");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = from; i <= to; ++i) {
            sb.append(arr[i]);
            if (i == to) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static <T> String concatRanges(T[] arr, String separator, int ... ranges) {
        if (ranges.length % 2 != 0) {
            throw new IllegalArgumentException("The number of ranges must be even");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; i += 2) {
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(OkkamStrings.concatRange(arr, separator, ranges[i], ranges[i + 1]));
        }
        return sb.toString();
    }

    public static String duplicate(String stringToDuplicate, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(stringToDuplicate);
        }
        return sb.toString();
    }
}

