/*
 * Decompiled with CFR 0.152.
 */
package org.olengski.optimize;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;
import org.olengski.optimize.ExitStatus;
import org.olengski.optimize.OptimizationException;
import org.olengski.optimize.Runner;

public class Optimizer {
    private static final String CLASSPATH_R_JS = "/r.js";

    public void optimize(File buildProfile, ErrorReporter reporter, Runner runner, String[] params) throws IOException, OptimizationException {
        File optimizerFile = this.getClasspathOptimizerFile();
        this.optimize(buildProfile, optimizerFile, reporter, runner, params);
    }

    public void optimize(File buildProfile, ErrorReporter reporter, Runner runner) throws IOException, OptimizationException {
        File optimizerFile = this.getClasspathOptimizerFile();
        this.optimize(buildProfile, optimizerFile, reporter, runner);
    }

    public void optimize(File buildProfile, File optimizerFile, ErrorReporter reporter, Runner runner, String[] params) throws IOException, OptimizationException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-o");
        args.add(buildProfile.getAbsolutePath());
        for (int i = 0; i < params.length; ++i) {
            args.add(params[i]);
        }
        String[] newParams = new String[args.size()];
        ExitStatus status = runner.exec(optimizerFile, newParams = args.toArray(newParams), reporter);
        if (!status.success()) {
            throw new OptimizationException("Optimizer returned non-zero exit status.");
        }
    }

    public void optimize(File buildProfile, File optimizerFile, ErrorReporter reporter, Runner runner) throws IOException, OptimizationException {
        String[] args = new String[]{"-o", buildProfile.getAbsolutePath()};
        ExitStatus status = runner.exec(optimizerFile, args, reporter);
        if (!status.success()) {
            throw new OptimizationException("Optimizer returned non-zero exit status.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getClasspathOptimizerFile() throws IOException {
        File optimizerFile = File.createTempFile("build", "js");
        optimizerFile.deleteOnExit();
        FileOutputStream out = null;
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(CLASSPATH_R_JS);
            out = new FileOutputStream(optimizerFile);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return optimizerFile;
    }
}

