/*
 * Decompiled with CFR 0.152.
 */
package org.olengski.web.security;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.olengski.web.security.annotation.EncodeType;
import org.olengski.web.security.annotation.UnsecuredField;
import org.olengski.web.security.annotation.XSSProtect;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.reflections.ReflectionUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class XSSAspect {
    private Logger logger = ESAPI.getLogger(this.getClass());

    @Around(value="execution(public * *(..)) && execution(@org.olengski.web.security.annotation.XSSProtect * *(..))")
    public Object decorateForSecurity(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] arguments = joinPoint.getArgs();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        EncodeType encodeType = method.getAnnotation(XSSProtect.class).encodeFor();
        Object objectToReturn = joinPoint.proceed(arguments);
        this.encodeFields(objectToReturn, encodeType);
        return objectToReturn;
    }

    private void encodeFields(Object objectToEncode, EncodeType encodeType) throws Exception {
        block5: {
            block4: {
                if (objectToEncode == null || !(objectToEncode instanceof List)) break block4;
                List listToProcess = (List)objectToEncode;
                for (Object object : listToProcess) {
                    this.encodeFields(object, encodeType);
                }
                break block5;
            }
            if (objectToEncode == null) break block5;
            Set fields = ReflectionUtils.getFields(objectToEncode.getClass(), (Predicate[])new Predicate[0]);
            for (Field field : fields) {
                Set getterMethods;
                if (field.getType() == String.class) {
                    getterMethods = ReflectionUtils.getMethods(objectToEncode.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)this.getGetterMethodName(field)), ReflectionUtils.withModifier((int)1)});
                    if (getterMethods.size() <= 0) continue;
                    Object valueToEncode = ((Method)getterMethods.iterator().next()).invoke(objectToEncode, new Object[0]);
                    Set setterMethods = ReflectionUtils.getMethods(objectToEncode.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)this.getSetterMethodName(field)), ReflectionUtils.withModifier((int)1)});
                    if (setterMethods.size() <= 0) continue;
                    Method method = (Method)setterMethods.iterator().next();
                    if (valueToEncode == null) continue;
                    String encoded = "";
                    if (field.getAnnotation(UnsecuredField.class) == null) {
                        encoded = this.encodeField(field, valueToEncode.toString(), encodeType);
                    }
                    this.logger.info(Logger.EVENT_SUCCESS, "Securing " + objectToEncode.getClass().getSimpleName() + "." + field.getName() + "==============" + valueToEncode + " ==> " + encoded);
                    method.invoke(objectToEncode, encoded);
                    continue;
                }
                if (field.getType().isPrimitive() || this.isOmittedType(field.getType()) || (getterMethods = ReflectionUtils.getMethods(objectToEncode.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)this.getGetterMethodName(field)), ReflectionUtils.withModifier((int)1)})).size() <= 0) continue;
                Method method = (Method)getterMethods.iterator().next();
                this.encodeFields(method.invoke(objectToEncode, new Object[0]), encodeType);
            }
        }
    }

    private boolean isOmittedType(Class clazz) {
        if (clazz.getPackage() != null && clazz.getPackage().getName().startsWith("java.lang")) {
            this.logger.info(Logger.EVENT_SUCCESS, "Omitting " + clazz.getName());
            return true;
        }
        return false;
    }

    private String encodeField(Field field, String valueToEncode, EncodeType encodeType) {
        valueToEncode = ESAPI.encoder().canonicalize(valueToEncode);
        this.logger.info(Logger.EVENT_SUCCESS, "ENCODE TYPE: " + encodeType.toString());
        if (encodeType.equals((Object)EncodeType.HTML)) {
            this.logger.info(Logger.EVENT_SUCCESS, "Encoding for HTML");
            return ESAPI.encoder().encodeForHTML(valueToEncode);
        }
        if (encodeType.equals((Object)EncodeType.HTML_ATTRIBUTE)) {
            this.logger.info(Logger.EVENT_SUCCESS, "Encoding for HTML_ATTR");
            return ESAPI.encoder().encodeForHTMLAttribute(valueToEncode);
        }
        if (encodeType.equals((Object)EncodeType.JAVASCRIPT)) {
            this.logger.info(Logger.EVENT_SUCCESS, "Encoding for JS");
            return ESAPI.encoder().encodeForJavaScript(valueToEncode);
        }
        this.logger.info(Logger.EVENT_SUCCESS, "Encoding for HTML By default");
        return ESAPI.encoder().encodeForHTML(valueToEncode);
    }

    private String getGetterMethodName(Field field) {
        return "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    private String getSetterMethodName(Field field) {
        return "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }
}

