/*
 * Decompiled with CFR 0.152.
 */
package org.olengski.web;

import com.google.common.base.Predicate;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.owasp.esapi.ESAPI;
import org.reflections.ReflectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
@Component
public class DoubleSubmissionAspect {
    Logger logger = Logger.getLogger(this.getClass());
    private long DEFAULT_MAX_AGE = 60000L;
    private long DEFUALT_MAX_HASH_LIST_SIZE = 15L;
    private long maxAge = 0L;
    private long maxHashListSize = 0L;

    @Pointcut(value="within(@org.springframework.stereotype.Controller *)")
    public void controllerBean() {
    }

    @Pointcut(value="within(@org.springframework.stereotype.Controller *)")
    public void doubleSubmitProtected() {
    }

    @Before(value="execution(public * *(..))&& execution(@org.olengski.web.DoubleSubmitProtect * *(..))")
    public void decorateForSecurity(JoinPoint joinPoint) throws Throwable {
        Date existingHashAdded;
        Object[] arguments = joinPoint.getArgs();
        StringWriter writer = new StringWriter();
        for (Object argument : arguments) {
            this.concatFields(writer, argument);
        }
        String concatenatedString = writer.toString();
        this.logger.info((Object)concatenatedString);
        Integer hashCode = concatenatedString.hashCode();
        if (this.maxAge == 0L) {
            this.maxAge = this.DEFAULT_MAX_AGE;
        }
        if ((long)this.getCurrentSessionSubmissions().size() > this.maxAge) {
            this.discardOldHashes();
        }
        if ((existingHashAdded = this.getCurrentSessionSubmissions().get(hashCode)) != null) {
            Long age = System.currentTimeMillis() - existingHashAdded.getTime();
            if (age < this.maxAge) {
                throw new RuntimeException("Double submission prevented. A similar submission was received before the threshold expired.");
            }
            this.getCurrentSessionSubmissions().put(hashCode, new Date());
        } else {
            this.getCurrentSessionSubmissions().put(hashCode, new Date());
        }
        System.out.println("Final String: " + writer.toString());
    }

    protected Map<Integer, Date> getCurrentSessionSubmissions() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HashMap<Integer, Date> mapOfSubmittedData = (HashMap<Integer, Date>)servletRequestAttributes.getRequest().getSession().getAttribute("USER_SUBMISSIONS");
        if (mapOfSubmittedData == null) {
            mapOfSubmittedData = new HashMap<Integer, Date>();
        }
        servletRequestAttributes.getRequest().getSession().setAttribute("USER_SUBMISSIONS", mapOfSubmittedData);
        return mapOfSubmittedData;
    }

    protected String concatFields(StringWriter writer, Object objectToEncode) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        block4: {
            block6: {
                Object[] listToProcess;
                block5: {
                    block3: {
                        this.logger.info((Object)("Atttempting to process " + objectToEncode.getClass().getName()));
                        if (objectToEncode == null || !this.isOfTypeWeCareAbout(objectToEncode)) break block3;
                        this.logger.info((Object)("Adding: " + objectToEncode.getClass().getName()));
                        writer.append(ESAPI.encoder().canonicalize(objectToEncode.toString()));
                        break block4;
                    }
                    if (objectToEncode == null || !(objectToEncode instanceof List)) break block5;
                    List listToProcess2 = (List)objectToEncode;
                    for (Object object : listToProcess2) {
                        this.concatFields(writer, object);
                    }
                    break block4;
                }
                if (objectToEncode == null || !objectToEncode.getClass().isArray()) break block6;
                for (Object object : listToProcess = (Object[])objectToEncode) {
                    this.concatFields(writer, object);
                }
                break block4;
            }
            if (objectToEncode == null || objectToEncode.getClass() == String.class) break block4;
            Set fields = ReflectionUtils.getFields(objectToEncode.getClass(), (Predicate[])new Predicate[0]);
            for (Field field : fields) {
                Set getterMethods = ReflectionUtils.getMethods(objectToEncode.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)this.getGetterMethodName(field)), ReflectionUtils.withModifier((int)1)});
                if (getterMethods.size() <= 0) continue;
                Method method = (Method)getterMethods.iterator().next();
                this.concatFields(writer, method.invoke(objectToEncode, new Object[0]));
            }
        }
        return writer.toString();
    }

    private boolean isOfTypeWeCareAbout(Object object) {
        return object.getClass() == String.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == BigDecimal.class || object.getClass() == Float.class || object.getClass() == Double.class || object.getClass() == Short.class || object.getClass() == Byte.class || object.getClass() == Date.class || object instanceof HttpSession;
    }

    private String getGetterMethodName(Field field) {
        return "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    private String getSetterMethodName(Field field) {
        return "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    private synchronized void discardOldHashes() {
        long currentTime = System.currentTimeMillis();
        this.logger.info((Object)("Cleaning up hashes: " + this.getCurrentSessionSubmissions().size()));
        ArrayList<Integer> keysOfHashesToEvict = new ArrayList<Integer>();
        if (this.maxHashListSize == 0L) {
            this.maxHashListSize = this.DEFUALT_MAX_HASH_LIST_SIZE;
        }
        for (Integer key : this.getCurrentSessionSubmissions().keySet()) {
            long age = currentTime - this.getCurrentSessionSubmissions().get(key).getTime();
            if (age < this.maxHashListSize) continue;
            this.logger.info((Object)("evicting " + age));
            keysOfHashesToEvict.add(key);
        }
        for (Integer key : keysOfHashesToEvict) {
            this.getCurrentSessionSubmissions().remove(key);
        }
        this.logger.info((Object)("After cleaning up tokens: " + this.getCurrentSessionSubmissions().size()));
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public long getMaxHashListSize() {
        return this.maxHashListSize;
    }

    public void setMaxHashListSize(long maxHashListSize) {
        this.maxHashListSize = maxHashListSize;
    }

    public static void main(String[] args) {
    }
}

