/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.i18nbinder.grouping;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.i18nbinder.grouping.FileGroup;
import org.omnaest.utils.propertyfile.PropertyFile;
import org.omnaest.utils.propertyfile.content.PropertyFileContent;
import org.omnaest.utils.propertyfile.content.PropertyMap;
import org.omnaest.utils.propertyfile.content.element.Property;

public class FileGroupToPropertiesAdapter {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String MULTILINE_VALUES_SEPARATOR = "\\" + LINE_SEPARATOR;
    protected FileGroup fileGroup = null;
    private PropertyFileCache propertyFileCache = new PropertyFileCache();
    private String fileEncoding = "utf-8";

    public FileGroupToPropertiesAdapter(FileGroup fileGroup) {
        this.fileGroup = fileGroup;
    }

    public FileGroup getFileGroup() {
        return this.fileGroup;
    }

    public void setFileGroup(FileGroup fileGroup) {
        this.fileGroup = fileGroup;
    }

    protected PropertyFile resolvePropertyFile(String groupToken, String fileEncoding) {
        Map<String, File> groupTokenToFileMap;
        File file;
        PropertyFile retval = null;
        if (groupToken != null && (file = (groupTokenToFileMap = this.fileGroup.getGroupTokenToFileMap()).get(groupToken)) != null) {
            retval = new PropertyFile(file);
            retval.setFileEncoding(fileEncoding);
        }
        return retval;
    }

    protected PropertyFile resolveAndLoadPropertyFile(String groupToken) {
        PropertyFile propertyFile = this.resolvePropertyFile(groupToken, this.fileEncoding);
        if (propertyFile != null) {
            PropertyFile propertyFileFromCache = this.propertyFileCache.get(propertyFile.getFile());
            if (propertyFileFromCache != null) {
                propertyFile = propertyFileFromCache;
            } else {
                propertyFile.load();
                this.propertyFileCache.put(propertyFile);
            }
        }
        return propertyFile;
    }

    protected PropertyFileAndProperty resolvePropertyFileAndProperty(String propertyKey, String groupToken) {
        PropertyFileContent propertyFileContent;
        PropertyMap propertyMap;
        Property property;
        PropertyFile propertyFile;
        PropertyFileAndProperty retval = null;
        if (propertyKey != null && groupToken != null && (propertyFile = this.resolveAndLoadPropertyFile(groupToken)) != null && (property = (propertyMap = (propertyFileContent = propertyFile.getPropertyFileContent()).getPropertyMap()).get((Object)propertyKey)) != null) {
            retval = new PropertyFileAndProperty();
            retval.setProperty(property);
            retval.setPropertyFile(propertyFile);
        }
        return retval;
    }

    public void writePropertyValue(String propertyKey, String groupToken, String value) {
        Property property;
        PropertyFileAndProperty propertyFileAndProperty;
        if (propertyKey != null && groupToken != null && value != null && (propertyFileAndProperty = this.resolvePropertyFileAndProperty(propertyKey, groupToken)) != null && (property = propertyFileAndProperty.getProperty()) != null) {
            String[] valueTokens = value.split(Pattern.quote(MULTILINE_VALUES_SEPARATOR));
            List valueList = property.getValueList();
            valueList.clear();
            valueList.addAll(Arrays.asList(valueTokens));
            propertyFileAndProperty.getPropertyFile().store();
        }
    }

    public String resolvePropertyValue(String propertyKey, String groupToken) {
        Property property;
        PropertyFileAndProperty propertyFileAndProperty;
        String retval = null;
        if (propertyKey != null && groupToken != null && (propertyFileAndProperty = this.resolvePropertyFileAndProperty(propertyKey, groupToken)) != null && (property = propertyFileAndProperty.getProperty()) != null) {
            retval = StringUtils.join((Iterable)property.getValueList(), (String)MULTILINE_VALUES_SEPARATOR);
        }
        return retval;
    }

    public List<String> determineGroupTokenList() {
        return new ArrayList<String>(this.fileGroup.getGroupTokenToFileMap().keySet());
    }

    public Set<String> determinePropertyKeySet() {
        HashSet<String> retset = new HashSet<String>();
        for (String groupToken : this.determineGroupTokenList()) {
            PropertyFile propertyFile = this.resolveAndLoadPropertyFile(groupToken);
            if (propertyFile == null) continue;
            PropertyFileContent propertyFileContent = propertyFile.getPropertyFileContent();
            PropertyMap propertyMap = propertyFileContent.getPropertyMap();
            retset.addAll(propertyMap.keySet());
        }
        return retset;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    private static class PropertyFileCache {
        private Map<File, PropertyFile> cache = new WeakHashMap<File, PropertyFile>();

        private PropertyFileCache() {
        }

        public PropertyFile get(File file) {
            return this.cache.get(file);
        }

        public void put(PropertyFile propertyFile) {
            this.cache.put(propertyFile.getFile(), propertyFile);
        }
    }

    protected static class PropertyFileAndProperty {
        protected PropertyFile propertyFile = null;
        protected Property property = null;

        protected PropertyFileAndProperty() {
        }

        public PropertyFile getPropertyFile() {
            return this.propertyFile;
        }

        public void setPropertyFile(PropertyFile propertyFile) {
            this.propertyFile = propertyFile;
        }

        public Property getProperty() {
            return this.property;
        }

        public void setProperty(Property property) {
            this.property = property;
        }
    }
}

