/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.i18nbinder.grouping;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omnaest.i18nbinder.grouping.FileGroup;
import org.omnaest.utils.pattern.MatchResultGroupReplacer;

public class FileGrouper {
    private final String GROUPING_PATTERN_DEFAULT_STRING = "(.*?_(\\w{2,3}_\\w{2,3}|\\w{2,3})|.*())\\.\\w*";
    private final Integer[] GROUPING_PATTERN_GROUPING_GROUP_INDEXES_DEFAULT = new Integer[]{2, 3};
    protected String GROUPING_REPLACEMENT_TOKEN_DEFAULT = "{group}";
    protected List<File> fileList = new ArrayList<File>();
    protected Pattern groupingPattern = Pattern.compile("(.*?_(\\w{2,3}_\\w{2,3}|\\w{2,3})|.*())\\.\\w*");
    protected List<Integer> groupingPatternGroupingGroupIndexList = Arrays.asList(this.GROUPING_PATTERN_GROUPING_GROUP_INDEXES_DEFAULT);
    protected String groupingPatternReplacementToken = this.GROUPING_REPLACEMENT_TOKEN_DEFAULT;

    public Map<String, FileGroup> determineFileGroupIdentifierToFileGroupMap() {
        HashMap<String, FileGroup> retmap = new HashMap<String, FileGroup>();
        for (File file : this.fileList) {
            FileGroup fileGroup;
            String absolutePath = file.getAbsolutePath();
            Matcher matcher = this.groupingPattern.matcher(absolutePath);
            if (!matcher.matches()) continue;
            ArrayList<Integer> groupingPatternGroupIndexMatchingList = new ArrayList<Integer>();
            String groupValueFirstMatching = null;
            for (Integer iGroupingPatternGroupingGroupIndex : this.groupingPatternGroupingGroupIndexList) {
                String groupValue;
                if (matcher.groupCount() < iGroupingPatternGroupingGroupIndex || (groupValue = matcher.group(iGroupingPatternGroupingGroupIndex)) == null || groupValueFirstMatching != null && !groupValueFirstMatching.equals(groupValue)) continue;
                groupingPatternGroupIndexMatchingList.add(iGroupingPatternGroupingGroupIndex);
                groupValueFirstMatching = groupValue;
            }
            if (groupValueFirstMatching == null) continue;
            MatchResultGroupReplacer matchResultGroupReplacer = new MatchResultGroupReplacer(matcher.toMatchResult());
            HashMap<Integer, String> groupIndexToNewValueMap = new HashMap<Integer, String>();
            for (Integer groupIndex : groupingPatternGroupIndexMatchingList) {
                groupIndexToNewValueMap.put(groupIndex, this.groupingPatternReplacementToken);
            }
            String fileGroupIdentifier = matchResultGroupReplacer.replaceGroups(groupIndexToNewValueMap);
            String groupToken = groupValueFirstMatching;
            if (!retmap.containsKey(fileGroupIdentifier)) {
                fileGroup = new FileGroup();
                fileGroup.setFileGroupIdentifier(fileGroupIdentifier);
                retmap.put(fileGroupIdentifier, fileGroup);
            }
            fileGroup = (FileGroup)retmap.get(fileGroupIdentifier);
            Map<String, File> groupTokenToFileMap = fileGroup.getGroupTokenToFileMap();
            groupTokenToFileMap.put(groupToken, file);
        }
        return retmap;
    }

    public boolean addFile(File e) {
        return this.fileList.add(e);
    }

    public boolean addAllFiles(Collection<? extends File> fileCollection) {
        return this.fileList.addAll(fileCollection);
    }

    public void clearFiles() {
        this.fileList.clear();
    }

    public boolean containsFile(File file) {
        return this.fileList.contains(file);
    }

    public boolean remove(File file) {
        return this.fileList.remove(file);
    }

    public boolean removeAll(Collection<File> fileCollection) {
        return this.fileList.removeAll(fileCollection);
    }

    public int size() {
        return this.fileList.size();
    }

    public String getGroupingPatternString() {
        return this.groupingPattern.pattern();
    }

    public void setGroupingPatternString(String groupingPatternString) throws Exception {
        if (groupingPatternString != null) {
            this.groupingPattern = Pattern.compile(groupingPatternString);
        }
    }

    public String getGroupingPatternReplacementToken() {
        return this.groupingPatternReplacementToken;
    }

    public void setGroupingPatternReplacementToken(String groupingPatternReplacementToken) {
        this.groupingPatternReplacementToken = groupingPatternReplacementToken;
    }

    public List<Integer> getGroupingPatternGroupingGroupIndexList() {
        return this.groupingPatternGroupingGroupIndexList;
    }

    public void setGroupingPatternGroupingGroupIndexList(List<Integer> groupingPatternGroupingGroupIndexList) {
        this.groupingPatternGroupingGroupIndexList = groupingPatternGroupingGroupIndexList;
    }
}

