/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.i18nbinder.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.omnaest.i18nbinder.grouping.FileGroup;
import org.omnaest.i18nbinder.grouping.FileGroupToPropertiesAdapter;
import org.omnaest.i18nbinder.grouping.FileGrouper;
import org.omnaest.i18nbinder.internal.LocaleFilter;
import org.omnaest.i18nbinder.internal.ModifierHelper;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverterElementToMapEntry;
import org.omnaest.utils.structure.element.filter.ElementFilter;
import org.omnaest.utils.structure.element.filter.ElementFilterNotBlank;
import org.omnaest.utils.structure.hierarchy.TokenMonoHierarchy;
import org.omnaest.utils.structure.map.SimpleEntry;

public class FacadeCreatorHelper {
    public static final String DEFAULT_JAVA_FACADE_FILENAME_I18N_FACADE = "I18nFacade";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static Map<String, String> createI18nInterfaceFacadeFromPropertyFiles(Set<File> propertyFileSet, LocaleFilter localeFilter, String fileNameLocaleGroupPattern, List<Integer> groupingPatternGroupingGroupIndexList, String baseNameInTargetPlattform, String baseFolderIgnoredPath, String packageName, String i18nFacadeName, boolean externalizeTypes, String propertyfileEncoding) {
        LinkedHashMap<String, String> retmap = new LinkedHashMap<String, String>();
        if (propertyFileSet != null) {
            FileGrouper fileGrouper = new FileGrouper();
            try {
                if (fileNameLocaleGroupPattern != null) {
                    fileGrouper.setGroupingPatternString(fileNameLocaleGroupPattern);
                }
                if (groupingPatternGroupingGroupIndexList != null) {
                    fileGrouper.setGroupingPatternGroupingGroupIndexList(groupingPatternGroupingGroupIndexList);
                }
            }
            catch (Exception e) {
                ModifierHelper.logger.info(e.getMessage());
            }
            fileGrouper.setGroupingPatternReplacementToken("");
            fileGrouper.addAllFiles(propertyFileSet);
            Map<String, FileGroup> fileGroupIdentifierToFileGroupMap = fileGrouper.determineFileGroupIdentifierToFileGroupMap();
            ArrayList<FileGroupToPropertiesAdapter> fileGroupToPropertiesAdapterList = new ArrayList<FileGroupToPropertiesAdapter>();
            for (String fileGroupIdentifier : fileGroupIdentifierToFileGroupMap.keySet()) {
                FileGroup fileGroup = fileGroupIdentifierToFileGroupMap.get(fileGroupIdentifier);
                FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter = new FileGroupToPropertiesAdapter(fileGroup);
                fileGroupToPropertiesAdapter.setFileEncoding(propertyfileEncoding);
                fileGroupToPropertiesAdapterList.add(fileGroupToPropertiesAdapter);
            }
            Collections.sort(fileGroupToPropertiesAdapterList, new Comparator<FileGroupToPropertiesAdapter>(){

                @Override
                public int compare(FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter1, FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter2) {
                    String fileGroupIdentifier1 = fileGroupToPropertiesAdapter1.getFileGroup().getFileGroupIdentifier();
                    String fileGroupIdentifier2 = fileGroupToPropertiesAdapter2.getFileGroup().getFileGroupIdentifier();
                    return fileGroupIdentifier1.compareTo(fileGroupIdentifier2);
                }
            });
            ArrayList localeList = new ArrayList();
            HashSet<String> localeSet = new HashSet<String>();
            for (FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter : fileGroupToPropertiesAdapterList) {
                localeSet.addAll(fileGroupToPropertiesAdapter.determineGroupTokenList());
            }
            localeList.addAll(localeSet);
            for (String locale : localeSet) {
                if (localeFilter.isLocaleAccepted(locale)) continue;
                localeList.remove(locale);
            }
            Collections.sort(localeList);
            TokenMonoHierarchy TokenMonoHierarchy2 = new TokenMonoHierarchy();
            for (FileGroupToPropertiesAdapter fileGroupToPropertiesAdapter : fileGroupToPropertiesAdapterList) {
                String[] fileGroupIdentifierTokens;
                String fileGroupIdentifier = fileGroupToPropertiesAdapter.getFileGroup().getFileGroupIdentifier();
                List<String> tokenPathElementList = new ArrayList<String>();
                String pathDelimiter = "[\\\\/]";
                if (StringUtils.isNotBlank((CharSequence)baseNameInTargetPlattform)) {
                    String[] baseNameTokens = baseNameInTargetPlattform.split("[\\\\/]");
                    tokenPathElementList.addAll(Arrays.asList(baseNameTokens));
                }
                if ((fileGroupIdentifierTokens = fileGroupIdentifier.replaceFirst(Pattern.quote(baseFolderIgnoredPath), "").split("[\\\\/]")).length > 0) {
                    String lastToken = fileGroupIdentifierTokens[fileGroupIdentifierTokens.length - 1];
                    fileGroupIdentifierTokens[fileGroupIdentifierTokens.length - 1] = lastToken = lastToken.replaceAll("\\.properties$", "").replaceAll("_", "");
                    tokenPathElementList.addAll(Arrays.asList(fileGroupIdentifierTokens));
                }
                tokenPathElementList = ListUtils.filter(tokenPathElementList, (ElementFilter)new ElementFilterNotBlank());
                ModifierHelper.logger.info("Processing: " + fileGroupIdentifier);
                ArrayList<String> propertyKeyList = new ArrayList<String>(fileGroupToPropertiesAdapter.determinePropertyKeySet());
                Collections.sort(propertyKeyList);
                for (String propertyKey : propertyKeyList) {
                    if (propertyKey == null) continue;
                    PropertyKeyAndValues propertyKeyAndValues = new PropertyKeyAndValues();
                    propertyKeyAndValues.propertyKey = propertyKey;
                    for (String locale : localeList) {
                        String value = fileGroupToPropertiesAdapter.resolvePropertyValue(propertyKey, locale);
                        if (!StringUtils.isNotBlank((CharSequence)(value = StringUtils.defaultString((String)value)))) continue;
                        propertyKeyAndValues.valueList.add(locale + "=" + value);
                    }
                    TokenMonoHierarchy.TokenElementPath tokenElementPath = new TokenMonoHierarchy.TokenElementPath(tokenPathElementList);
                    TokenMonoHierarchy2.addTokenElementPathWithValues(tokenElementPath, (Object[])new PropertyKeyAndValues[]{propertyKeyAndValues});
                }
            }
            LinkedHashMap<String, StringBuilder> externalizedClassToContentMap = externalizeTypes ? new LinkedHashMap<String, StringBuilder>() : null;
            retmap.put(packageName + "." + i18nFacadeName, FacadeCreatorHelper.buildFacadeSource((TokenMonoHierarchy<String, PropertyKeyAndValues>)TokenMonoHierarchy2, packageName, i18nFacadeName, externalizedClassToContentMap));
            if (externalizeTypes) {
                for (String subClassName : externalizedClassToContentMap.keySet()) {
                    StringBuilder stringBuilder = (StringBuilder)externalizedClassToContentMap.get(subClassName);
                    retmap.put(subClassName, stringBuilder.toString());
                }
            }
        }
        return retmap;
    }

    private static String buildFacadeSource(TokenMonoHierarchy<String, PropertyKeyAndValues> TokenMonoHierarchy2, String packageName, String i18nFacadeName, Map<String, StringBuilder> externalizedClassToContentMap) {
        StringBuilder retval = new StringBuilder();
        TokenMonoHierarchy.Navigator navigator = TokenMonoHierarchy2.getNavigator();
        String className = i18nFacadeName;
        boolean isSubClass = false;
        String rootPackageName = packageName;
        FacadeCreatorHelper.buildFacadeSource(retval, className, false, navigator, externalizedClassToContentMap, i18nFacadeName, packageName, rootPackageName);
        return retval.toString().replaceAll("\n", LINE_SEPARATOR);
    }

    private static void buildFacadeSource(StringBuilder stringBuilder, String className, boolean isSubClass, TokenMonoHierarchy.Navigator navigator, Map<String, StringBuilder> externalizedClassToContentMap, String i18nFacadeName, String packageName, String rootPackageName) {
        boolean hasProperties;
        boolean hasAtLeastOneSubclass;
        LinkedHashMap subClassNameToTokenElementMap = new LinkedHashMap();
        LinkedHashMap<String, List<String>> propertyNameToExampleValueListMap = new LinkedHashMap<String, List<String>>();
        HashMap<String, String> propertyNameToPropertyKeyMap = new HashMap<String, String>();
        String baseName = StringUtils.join((Iterable)navigator.determineTokenPathElementList(), (String)".");
        boolean externalizeTypes = externalizedClassToContentMap != null;
        boolean staticModifier = !externalizeTypes && isSubClass;
        List tokenElementOfChildrenList = navigator.getTokenElementOfChildrenList();
        subClassNameToTokenElementMap.putAll(ListUtils.toMap((Iterable)tokenElementOfChildrenList, (ElementConverterElementToMapEntry)new CamelCaseTokenElementToMapEntryConverter(className)));
        boolean bl = hasAtLeastOneSubclass = !subClassNameToTokenElementMap.isEmpty();
        if (navigator.hasValues()) {
            List propertyKeyAndValuesList = navigator.getValues();
            for (PropertyKeyAndValues propertyKeyAndValues : propertyKeyAndValuesList) {
                String[] tokens;
                String propertyKey = propertyKeyAndValues.propertyKey;
                String propertyName = "";
                for (String token : tokens = propertyKey.split("[^a-zA-Z0-9]")) {
                    propertyName = propertyName + StringUtils.capitalize((String)token);
                }
                String key = propertyName;
                ArrayList<String> valueList = new ArrayList<String>(propertyKeyAndValues.valueList);
                final String defaultLocaleString = String.valueOf(Locale.getDefault());
                final String defaultLocaleLanguageString = String.valueOf(Locale.getDefault().getLanguage());
                Collections.sort(valueList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int retval = 0;
                        String firstElement1 = (String)ListUtils.firstElement((List)ListUtils.valueOf((Object[])StringUtils.split((String)o1, (String)"=")));
                        String firstElement2 = (String)ListUtils.firstElement((List)ListUtils.valueOf((Object[])StringUtils.split((String)o2, (String)"=")));
                        if (StringUtils.startsWith((CharSequence)firstElement1, (CharSequence)defaultLocaleString)) {
                            --retval;
                        }
                        if (StringUtils.startsWith((CharSequence)firstElement2, (CharSequence)defaultLocaleString)) {
                            ++retval;
                        }
                        if (StringUtils.contains((CharSequence)firstElement1, (CharSequence)defaultLocaleString)) {
                            --retval;
                        }
                        if (StringUtils.contains((CharSequence)firstElement2, (CharSequence)defaultLocaleString)) {
                            ++retval;
                        }
                        if (StringUtils.contains((CharSequence)firstElement1, (CharSequence)defaultLocaleLanguageString)) {
                            --retval;
                        }
                        if (StringUtils.contains((CharSequence)firstElement2, (CharSequence)defaultLocaleLanguageString)) {
                            ++retval;
                        }
                        return retval;
                    }
                });
                propertyNameToExampleValueListMap.put(key, valueList);
                propertyNameToPropertyKeyMap.put(propertyName, propertyKey);
            }
        }
        boolean hasBaseName = StringUtils.isNotBlank((CharSequence)baseName);
        boolean bl2 = hasProperties = !propertyNameToExampleValueListMap.keySet().isEmpty();
        if (!isSubClass || externalizeTypes) {
            stringBuilder.append(StringUtils.isNotBlank((CharSequence)packageName) ? "package " + packageName + ";\n\n" : "");
            stringBuilder.append("import java.util.Locale;\n");
            stringBuilder.append("import java.util.MissingResourceException;\n");
            stringBuilder.append("import javax.annotation.Generated;\n\n");
            stringBuilder.append("import java.util.Map;\n");
            if (!isSubClass) {
                stringBuilder.append("import java.util.LinkedHashMap;\n");
                stringBuilder.append("import java.util.ResourceBundle;\n\n");
            }
            if (externalizeTypes) {
                if (hasProperties) {
                    stringBuilder.append("import " + rootPackageName + "." + i18nFacadeName + ";\n");
                    stringBuilder.append("import " + rootPackageName + "." + i18nFacadeName + ".Translator;\n");
                }
                if (hasAtLeastOneSubclass) {
                    for (String subClassName : subClassNameToTokenElementMap.keySet()) {
                        stringBuilder.append("import " + packageName + "." + StringUtils.lowerCase((String)className) + "." + subClassName + ";\n");
                    }
                }
            }
        }
        stringBuilder.append("/**\n");
        stringBuilder.append(" * This is an automatically with i18nBinder generated facade class.<br><br>\n");
        stringBuilder.append(" * To modify please adapt the underlying property files.<br><br>\n");
        stringBuilder.append(" * If the facade class is instantiated with a given {@link Locale} using {@link #" + className + "(Locale)} all non static methods will use this predefined {@link Locale} when invoked.<br><br>\n");
        stringBuilder.append(" * The facade methods will silently ignore all {@link MissingResourceException}s by default. To alter this behavior see {@link #" + className + "(Locale, boolean)}<br><br>\n");
        stringBuilder.append(hasBaseName ? " * Resource base: <b>" + baseName + "</b>\n" : "");
        if (hasProperties) {
            FacadeCreatorHelper.printJavaDocPropertiesExamplesForSubclassAndInstance(stringBuilder, propertyNameToExampleValueListMap, propertyNameToPropertyKeyMap);
        }
        for (String subClassName : subClassNameToTokenElementMap.keySet()) {
            stringBuilder.append(" * @see " + subClassName + "\n");
        }
        if (hasProperties) {
            stringBuilder.append(" * @see #translator()\n");
            stringBuilder.append(" * @see #translator(Locale)\n");
        }
        stringBuilder.append(" */ \n");
        stringBuilder.append("@Generated(value = \"http://code.google.com/p/i18n-binder/\", date = \"" + DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(Calendar.getInstance()) + "\")\n");
        stringBuilder.append("public " + (staticModifier ? "static " : "") + "class " + className + " {\n");
        if (!propertyNameToExampleValueListMap.isEmpty()) {
            stringBuilder.append("  public final static String baseName = \"" + baseName + "\";\n");
            stringBuilder.append("  private final Locale locale;\n");
            stringBuilder.append("  private final boolean silentlyIgnoreMissingResourceException;\n");
        }
        for (String subClassName : subClassNameToTokenElementMap.keySet()) {
            stringBuilder.append("  /** @see " + subClassName + " */\n");
            stringBuilder.append("  public final " + subClassName + " " + subClassName + ";\n");
        }
        if (!isSubClass) {
            stringBuilder.append("   /** Static access helper for the underlying resource */\n");
            stringBuilder.append("   public static class Resource\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    /** Internally used {@link ResourceBasedTranslator}. Changing this implementation affects the behavior of the whole facade */\n");
            stringBuilder.append("    public static ResourceBasedTranslator resourceBasedTranslator = new ResourceBasedTranslator()\n");
            stringBuilder.append("    {\n");
            stringBuilder.append("      @Override\n");
            stringBuilder.append("      public String translate( String baseName, String key, Locale locale )\n");
            stringBuilder.append("      {\n");
            stringBuilder.append("        ResourceBundle resourceBundle = ResourceBundle.getBundle( baseName,locale );\n");
            stringBuilder.append("        return resourceBundle.getString( key );\n");
            stringBuilder.append("      }\n\n");
            stringBuilder.append("      @Override\n");
            stringBuilder.append("      public String[] resolveAllKeys( String baseName, Locale locale )\n");
            stringBuilder.append("      {\n");
            stringBuilder.append("        ResourceBundle resourceBundle = ResourceBundle.getBundle( baseName,locale );\n");
            stringBuilder.append("        return resourceBundle.keySet().toArray( new String[0] );\n");
            stringBuilder.append("      }\n");
            stringBuilder.append("    };\n\n");
            stringBuilder.append("  }\n");
            stringBuilder.append("  /** Defines which {@link ResourceBasedTranslator} the facade should use. This affects all available instances. */\n");
            stringBuilder.append("  public static void use( ResourceBasedTranslator resourceBasedTranslator )\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    " + i18nFacadeName + ".Resource.resourceBasedTranslator = resourceBasedTranslator;\n");
            stringBuilder.append("  }\n\n");
        }
        if (!isSubClass) {
            FacadeCreatorHelper.appendResourceBasedTranslatorInterface(stringBuilder);
            FacadeCreatorHelper.appendTranslatorHelper(stringBuilder, i18nFacadeName);
        }
        stringBuilder.append("\n");
        stringBuilder.append("  /**\n");
        stringBuilder.append("   * This {@link " + className + "} constructor will create a new instance which silently ignores any {@link MissingResourceException} \n");
        stringBuilder.append("   * @see " + className + "\n");
        stringBuilder.append("   * @param locale\n");
        stringBuilder.append("   */ \n");
        stringBuilder.append("  public " + className + "( Locale locale )\n");
        stringBuilder.append("  {\n");
        stringBuilder.append("    this(locale,true);\n");
        stringBuilder.append("  }\n");
        stringBuilder.append("  \n");
        stringBuilder.append("\n");
        stringBuilder.append("  /**\n");
        stringBuilder.append("   * @see " + className + "\n");
        stringBuilder.append("   * @param locale\n");
        stringBuilder.append("   * @param silentlyIgnoreMissingResourceException\n");
        stringBuilder.append("   */ \n");
        stringBuilder.append("  public " + className + "( Locale locale, boolean silentlyIgnoreMissingResourceException )\n");
        stringBuilder.append("  {\n");
        stringBuilder.append("    super();\n");
        if (!propertyNameToExampleValueListMap.isEmpty()) {
            stringBuilder.append("    this.locale = locale;\n");
            stringBuilder.append("    this.silentlyIgnoreMissingResourceException = silentlyIgnoreMissingResourceException;\n");
        }
        for (String subClassName : subClassNameToTokenElementMap.keySet()) {
            stringBuilder.append("    this." + subClassName + " = new " + subClassName + "( locale, silentlyIgnoreMissingResourceException );\n");
        }
        stringBuilder.append("  }\n");
        stringBuilder.append("  \n");
        for (String subClassName : subClassNameToTokenElementMap.keySet()) {
            StringBuilder subClassStringBuilder;
            String subClassPackageName;
            boolean subClassIsSubClass = true;
            String string = subClassPackageName = !externalizeTypes ? packageName : packageName + "." + StringUtils.lowerCase((String)className);
            if (externalizeTypes) {
                subClassStringBuilder = new StringBuilder();
                externalizedClassToContentMap.put(subClassPackageName + "." + subClassName, subClassStringBuilder);
            } else {
                subClassStringBuilder = stringBuilder;
            }
            FacadeCreatorHelper.buildFacadeSource(subClassStringBuilder, subClassName, true, navigator.newNavigatorFork().navigateToChild(subClassNameToTokenElementMap.get(subClassName)), externalizedClassToContentMap, i18nFacadeName, subClassPackageName, rootPackageName);
        }
        if (hasProperties) {
            for (String propertyName : propertyNameToExampleValueListMap.keySet()) {
                String propertyKey = (String)propertyNameToPropertyKeyMap.get(propertyName);
                List exampleValueList = (List)propertyNameToExampleValueListMap.get(propertyName);
                List<String> replacementTokensForExampleValuesNumericPlaceholders = FacadeCreatorHelper.determineReplacementTokensForExampleValues(exampleValueList, "\\{\\d+\\}");
                List<String> replacementTokensForExampleValuesArbitraryPlaceholders = FacadeCreatorHelper.determineReplacementTokensForExampleValues(exampleValueList, "\\{\\w+\\}");
                boolean containsNumericalReplacementToken = replacementTokensForExampleValuesNumericPlaceholders.size() > 0;
                boolean containsArbitraryReplacementToken = !containsNumericalReplacementToken && replacementTokensForExampleValuesArbitraryPlaceholders.size() > 0;
                stringBuilder.append("  /**\n");
                stringBuilder.append("   * Similar to {@link #get" + propertyName + "()} for the given {@link Locale}.\n");
                stringBuilder.append("   * @see " + className + "\n");
                stringBuilder.append("   * @see #get" + propertyName + "()\n");
                stringBuilder.append("   * @param locale \n");
                stringBuilder.append("   */ \n");
                stringBuilder.append("  protected String get" + propertyName + "(Locale locale)\n");
                stringBuilder.append("  {\n");
                stringBuilder.append("    try\n");
                stringBuilder.append("    {\n");
                stringBuilder.append("      final String key = \"" + propertyKey + "\";\n");
                stringBuilder.append("      return " + i18nFacadeName + ".Resource.resourceBasedTranslator.translate( baseName, key, locale );\n");
                stringBuilder.append("    }\n");
                stringBuilder.append("    catch ( MissingResourceException e )\n");
                stringBuilder.append("    {\n");
                stringBuilder.append("      if (!this.silentlyIgnoreMissingResourceException)\n");
                stringBuilder.append("      {\n");
                stringBuilder.append("        throw e;\n");
                stringBuilder.append("      }\n");
                stringBuilder.append("      return null;\n");
                stringBuilder.append("    }\n");
                stringBuilder.append("  }\n\n");
                stringBuilder.append("  /**\n");
                stringBuilder.append("   * Returns the value of the property key <b>" + propertyKey + "</b> for the predefined {@link Locale}.\n");
                FacadeCreatorHelper.printJavaDocPlaceholders(stringBuilder, replacementTokensForExampleValuesArbitraryPlaceholders);
                FacadeCreatorHelper.printJavaDocValueExamples(stringBuilder, exampleValueList);
                stringBuilder.append("   * @see " + className + "\n");
                stringBuilder.append("   */ \n");
                stringBuilder.append("  public String get" + propertyName + "()\n");
                stringBuilder.append("  {\n");
                stringBuilder.append("    return get" + propertyName + "( this.locale );\n");
                stringBuilder.append("  }\n\n");
                if (containsNumericalReplacementToken) {
                    stringBuilder.append("  /**\n");
                    stringBuilder.append("   * Similar to  {@link #get" + propertyName + "(String[])} using the given {@link Locale}.\n");
                    stringBuilder.append("   * @see " + className + "\n");
                    stringBuilder.append("   * @see #get" + propertyName + "(String[])\n");
                    stringBuilder.append("   * @param locale\n");
                    stringBuilder.append("   * @param tokens\n");
                    stringBuilder.append("   */ \n");
                    stringBuilder.append("  public String get" + propertyName + "( Locale locale, String... tokens )\n");
                    stringBuilder.append("  {\n");
                    stringBuilder.append("    String retval = get" + propertyName + "( locale );\n");
                    stringBuilder.append("    for ( int ii = 0; ii < tokens.length; ii++ )\n");
                    stringBuilder.append("    {\n");
                    stringBuilder.append("      String token = tokens[ii];\n");
                    stringBuilder.append("      if ( token != null )\n");
                    stringBuilder.append("      {\n");
                    stringBuilder.append("        retval = retval.replaceAll( \"\\\\{\" + ii + \"\\\\}\", token );\n");
                    stringBuilder.append("      }\n");
                    stringBuilder.append("    }\n");
                    stringBuilder.append("    return retval;\n");
                    stringBuilder.append("  }\n\n");
                    stringBuilder.append("  /**\n");
                    stringBuilder.append("   * Returns the value of the property key <b>" + propertyKey + "</b> for the predefined {@link Locale} with all {0},{1},... placeholders replaced by the given tokens in their order.<br><br>\n");
                    stringBuilder.append("   * If there are not enough parameters existing placeholders will remain unreplaced.\n");
                    FacadeCreatorHelper.printJavaDocPlaceholders(stringBuilder, replacementTokensForExampleValuesNumericPlaceholders);
                    FacadeCreatorHelper.printJavaDocValueExamples(stringBuilder, exampleValueList);
                    stringBuilder.append("   * @see " + className + "\n");
                    stringBuilder.append("   * @see #get" + propertyName + "(Locale,String[])\n");
                    stringBuilder.append("   * @param tokens\n");
                    stringBuilder.append("   */ \n");
                    stringBuilder.append("  public String get" + propertyName + "( String... tokens )\n");
                    stringBuilder.append("  {\n");
                    stringBuilder.append("    return get" + propertyName + "( this.locale, tokens );\n");
                    stringBuilder.append("  }\n\n");
                }
                if (!containsArbitraryReplacementToken) continue;
                stringBuilder.append("  /**\n");
                stringBuilder.append("   * Returns the value of the property key <b>" + propertyKey + "</b> for the given {@link Locale} with arbitrary placeholder tag like {example} replaced by the given values.<br>\n");
                stringBuilder.append("   * The given placeholderToReplacementMap needs the placeholder tag name and a value. E.g. for {example} the key \"example\" has to be set.\n");
                FacadeCreatorHelper.printJavaDocPlaceholders(stringBuilder, replacementTokensForExampleValuesArbitraryPlaceholders);
                FacadeCreatorHelper.printJavaDocValueExamples(stringBuilder, exampleValueList);
                stringBuilder.append("   * @see " + className + "\n");
                stringBuilder.append("   * @see #get" + propertyName + "(Map)\n");
                stringBuilder.append("   * @param locale\n");
                stringBuilder.append("   * @param placeholderToReplacementMap\n");
                stringBuilder.append("   */ \n");
                stringBuilder.append("  public String get" + propertyName + "( Locale locale, Map<String, String> placeholderToReplacementMap )\n");
                stringBuilder.append("  {\n");
                stringBuilder.append("    String retval = get" + propertyName + "( locale );\n");
                stringBuilder.append("    if ( placeholderToReplacementMap != null )\n");
                stringBuilder.append("    {\n");
                stringBuilder.append("      for ( String placeholder : placeholderToReplacementMap.keySet() )\n");
                stringBuilder.append("      {\n");
                stringBuilder.append("        if ( placeholder != null )\n");
                stringBuilder.append("        {\n");
                stringBuilder.append("          String token = placeholderToReplacementMap.get( placeholder );\n");
                stringBuilder.append("          retval = retval.replaceAll( \"\\\\{\" + placeholder + \"\\\\}\", token );\n");
                stringBuilder.append("        }\n");
                stringBuilder.append("      }\n");
                stringBuilder.append("    }\n");
                stringBuilder.append("    return retval;\n");
                stringBuilder.append("  }\n\n");
                stringBuilder.append("  /**\n");
                stringBuilder.append("   * Similar to  {@link #get" + propertyName + "(Locale,Map)} using the predefined {@link Locale}.\n");
                stringBuilder.append("   * @see " + className + "\n");
                stringBuilder.append("   * @see #get" + propertyName + "(Locale,Map)\n");
                stringBuilder.append("   * @param placeholderToReplacementMap\n");
                stringBuilder.append("   */ \n");
                stringBuilder.append("  public String get" + propertyName + "( Map<String, String> placeholderToReplacementMap )\n");
                stringBuilder.append("  {\n");
                stringBuilder.append("    return get" + propertyName + "( this.locale, placeholderToReplacementMap );\n");
                stringBuilder.append("  }\n\n");
            }
            stringBuilder.append("  /**\n");
            stringBuilder.append("   * Returns a new instance of {@link " + className + "} which uses the given setting for the exception handling\n");
            stringBuilder.append("   * @see " + className + "\n");
            stringBuilder.append("   * @param silentlyIgnoreMissingResourceException \n");
            stringBuilder.append("   */ \n");
            stringBuilder.append("  public " + className + " doSilentlyIgnoreMissingResourceException( boolean silentlyIgnoreMissingResourceException )\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    return new " + className + "( this.locale, silentlyIgnoreMissingResourceException );\n");
            stringBuilder.append("  }\n\n");
            stringBuilder.append("  /**\n");
            stringBuilder.append("   * Returns a new instance of {@link " + className + "} which uses the given {@link Locale}\n");
            stringBuilder.append("   * @see " + className + "\n");
            stringBuilder.append("   * @param locale \n");
            stringBuilder.append("   */ \n");
            stringBuilder.append("  public " + className + " forLocale( Locale locale )\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    return new " + className + "( locale, this.silentlyIgnoreMissingResourceException );\n");
            stringBuilder.append("  }\n\n");
            stringBuilder.append("  /**\n");
            stringBuilder.append("   * Returns a new {@link Translator} instance using the given {@link Locale} and based on the {@value #baseName} i18n base\n");
            stringBuilder.append("   * @see " + className + "\n");
            stringBuilder.append("   * @see #translator()\n");
            stringBuilder.append("   * @see #translator(Locale)\n");
            stringBuilder.append("   * @return {@link Translator}");
            stringBuilder.append("   */ \n");
            stringBuilder.append("  public static Translator translator(Locale locale, boolean silentlyIgnoreMissingResourceException)\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    return new Translator( baseName, locale, silentlyIgnoreMissingResourceException );\n");
            stringBuilder.append("  }\n\n");
            stringBuilder.append("  /**\n");
            stringBuilder.append("   * Returns a new {@link Translator} instance using the given {@link Locale} and based on the {@value #baseName} i18n base\n");
            stringBuilder.append("   * @see " + className + "\n");
            stringBuilder.append("   * @see #translator()\n");
            stringBuilder.append("   * @see #translator(Locale,boolean)\n");
            stringBuilder.append("   * @return {@link Translator}");
            stringBuilder.append("   */ \n");
            stringBuilder.append("  public Translator translator(Locale locale)\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    return new Translator( baseName, locale, this.silentlyIgnoreMissingResourceException );\n");
            stringBuilder.append("  }\n\n");
            stringBuilder.append("  /**\n");
            stringBuilder.append("   * Returns a new {@link Translator} instance using the internal {@link Locale} and based on the {@value #baseName} i18n base\n");
            stringBuilder.append("   * @see " + className + "\n");
            stringBuilder.append("   * @see #translator(Locale)\n");
            stringBuilder.append("   * @see #translator(Locale,boolean)\n");
            stringBuilder.append("   * @return {@link Translator}");
            stringBuilder.append("   */ \n");
            stringBuilder.append("  public Translator translator()\n");
            stringBuilder.append("  {\n");
            stringBuilder.append("    return translator( this.locale );\n");
            stringBuilder.append("  }\n\n");
        }
        stringBuilder.append("}\n\n");
    }

    private static void printJavaDocPropertiesExamplesForSubclassAndInstance(StringBuilder stringBuilder, Map<String, List<String>> propertyNameToExampleValueListMap, Map<String, String> propertyNameToPropertyKeyMap) {
        stringBuilder.append(" * <br><br>\n");
        stringBuilder.append(" * <h1>Examples:</h1>\n");
        stringBuilder.append(" * <table border=\"1\">\n");
        stringBuilder.append(" * <thead>\n");
        stringBuilder.append(" * <tr>\n");
        stringBuilder.append(" * <th>key</th>\n");
        stringBuilder.append(" * <th>examples</th>\n");
        stringBuilder.append(" * </tr>\n");
        stringBuilder.append(" * </thead>\n");
        stringBuilder.append(" * <tbody>\n");
        for (String propertyName : propertyNameToExampleValueListMap.keySet()) {
            int exampleSizeMax = 3;
            String propertyKey = propertyNameToPropertyKeyMap.get(propertyName);
            ArrayList exampleValueList = new ArrayList(propertyNameToExampleValueListMap.get(propertyName));
            while (exampleValueList.size() > 3) {
                exampleValueList.remove(exampleValueList.size() - 1);
            }
            Iterator iteratorExampleValueList = exampleValueList.iterator();
            int exampleSize = exampleValueList.size();
            if (exampleSize <= 0) continue;
            stringBuilder.append(" * <tr>\n");
            stringBuilder.append(" * <td rowspan=\"" + exampleSize + "\">" + propertyKey + "</td>\n");
            stringBuilder.append(" * <td>" + (String)iteratorExampleValueList.next() + "</td>\n");
            stringBuilder.append(" * </tr>\n");
            while (iteratorExampleValueList.hasNext()) {
                stringBuilder.append(" * <tr>\n");
                stringBuilder.append(" * <td><small>" + (String)iteratorExampleValueList.next() + "</small></td>\n");
                stringBuilder.append(" * </tr>\n");
            }
        }
        stringBuilder.append(" * </tbody>\n");
        stringBuilder.append(" * </table><br><br>\n");
    }

    private static void appendResourceBasedTranslatorInterface(StringBuilder stringBuilder) {
        stringBuilder.append("\n");
        stringBuilder.append("  /**\n");
        stringBuilder.append("   * Basic interface which is used by the facade to resolve translated values for given keys<br>\n");
        stringBuilder.append("   * <br>\n");
        stringBuilder.append("   * Any implementation should be thread safe");
        stringBuilder.append("   */ \n");
        stringBuilder.append("  public static interface ResourceBasedTranslator {\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns the translated value for the given key respecting the base name and the given {@link Locale}\n");
        stringBuilder.append("     * @param baseName\n");
        stringBuilder.append("     * @param key\n");
        stringBuilder.append("     * @param locale\n");
        stringBuilder.append("     * @return\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public String translate( String baseName, String key, Locale locale );\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns all available keys for the given {@link Locale}\n");
        stringBuilder.append("     * @param baseName\n");
        stringBuilder.append("     * @param locale\n");
        stringBuilder.append("     * @return\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public String[] resolveAllKeys( String baseName, Locale locale );\n");
        stringBuilder.append("  }\n");
        stringBuilder.append("\n");
    }

    private static void appendTranslatorHelper(StringBuilder stringBuilder, String I18nFacadeName) {
        stringBuilder.append("\n");
        stringBuilder.append("  /**\n");
        stringBuilder.append("   * A {@link Translator} offers several methods to translate arbitrary keys into their i18n counterpart based on the initially\n");
        stringBuilder.append("   * given {@link Locale}.\n");
        stringBuilder.append("   * \n");
        stringBuilder.append("   * @see #translate(String)\n");
        stringBuilder.append("   * @see #translate(String[]) \n");
        stringBuilder.append("   * @see #allPropertyKeys() \n");
        stringBuilder.append("   */ \n");
        stringBuilder.append("  public static class Translator {\n");
        stringBuilder.append("\n");
        stringBuilder.append("    private final String baseName;\n");
        stringBuilder.append("    private final Locale locale;\n");
        stringBuilder.append("    private final boolean silentlyIgnoreMissingResourceException;\n");
        stringBuilder.append("\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @param baseName\n");
        stringBuilder.append("     * @param locale\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public Translator( String baseName, Locale locale )\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      this(baseName,locale,true);\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @param baseName\n");
        stringBuilder.append("     * @param locale\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public Translator( String baseName, Locale locale, boolean silentlyIgnoreMissingResourceException )\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      super();\n");
        stringBuilder.append("      this.baseName = baseName;\n");
        stringBuilder.append("      this.locale = locale;\n");
        stringBuilder.append("      this.silentlyIgnoreMissingResourceException = silentlyIgnoreMissingResourceException;\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns the translated property key for the given {@link Locale}\n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #translate(String)\n");
        stringBuilder.append("     * @see #translate(String[])\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public String translate(Locale locale, String key)\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      try\n");
        stringBuilder.append("      {\n");
        stringBuilder.append("        return " + I18nFacadeName + ".Resource.resourceBasedTranslator.translate( this.baseName, key, locale );\n");
        stringBuilder.append("      }\n");
        stringBuilder.append("      catch ( MissingResourceException e )\n");
        stringBuilder.append("      {\n");
        stringBuilder.append("        if (!this.silentlyIgnoreMissingResourceException)\n");
        stringBuilder.append("        {\n");
        stringBuilder.append("          throw e;\n");
        stringBuilder.append("        }\n");
        stringBuilder.append("        return null;\n");
        stringBuilder.append("      }\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns the translated property key for the predefined {@link Locale}\n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #translate(Locale, String)\n");
        stringBuilder.append("     * @see #translate(String[])\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public String translate( String key )\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      return translate( this.locale, key );\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns a translation {@link Map} with the given property keys and their respective values for the given {@link Locale}.\n");
        stringBuilder.append("     * @param keys \n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #allPropertyKeys()\n");
        stringBuilder.append("     * @see #translate(String)\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public Map<String, String> translate( Locale locale, String... keys )\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      Map<String, String> retmap = new LinkedHashMap<String, String>();\n");
        stringBuilder.append("      for ( String key : keys )\n");
        stringBuilder.append("      {\n");
        stringBuilder.append("        retmap.put( key, translate( locale, key ) );\n");
        stringBuilder.append("      }\n");
        stringBuilder.append("      return retmap;\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns a translation {@link Map} with the given property keys and their respective values for the predefined {@link Locale}.\n");
        stringBuilder.append("     * @param keys \n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #allPropertyKeys()\n");
        stringBuilder.append("     * @see #translate(String)\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public Map<String, String> translate( String... keys )\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      return translate( this.locale, keys );\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns all available property keys for the given {@link Locale}. \n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #allPropertyKeys()\n");
        stringBuilder.append("     * @see #translate(String[])\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public String[] allPropertyKeys(Locale locale)\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      return " + I18nFacadeName + ".Resource.resourceBasedTranslator.resolveAllKeys( this.baseName, locale );\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns all available property keys for the predefined {@link Locale}. \n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #allPropertyKeys(Locale)\n");
        stringBuilder.append("     * @see #translate(String[])\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public String[] allPropertyKeys()\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      return allPropertyKeys( this.locale );\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Returns a translation {@link Map} for the predefined {@link Locale} including all available i18n keys resolved using \n");
        stringBuilder.append("     * {@link #allPropertyKeys()} and their respective translation values resolved using {@link #translate(String...)} \n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #allPropertyKeys(Locale)\n");
        stringBuilder.append("     * @see #translate(String[])\n");
        stringBuilder.append("     * @return {@link Map}\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public Map<String, String> translationMap()\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      return this.translate( this.allPropertyKeys() );\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("    /**\n");
        stringBuilder.append("     * Similar to {@link #translationMap()} for the given {@link Locale} instead. \n");
        stringBuilder.append("     * @see Translator\n");
        stringBuilder.append("     * @see #allPropertyKeys(Locale)\n");
        stringBuilder.append("     * @see #translate(String[])\n");
        stringBuilder.append("     * @param locale\n");
        stringBuilder.append("     * @return {@link Map}\n");
        stringBuilder.append("     */ \n");
        stringBuilder.append("    public Map<String, String> translationMap( Locale locale )\n");
        stringBuilder.append("    {\n");
        stringBuilder.append("      return this.translate( locale, this.allPropertyKeys( locale ) );\n");
        stringBuilder.append("    }\n\n");
        stringBuilder.append("  }\n");
        stringBuilder.append("\n");
    }

    private static void printJavaDocPlaceholders(StringBuilder stringBuilder, List<String> replacementTokensForExampleValuesPlaceholders) {
        stringBuilder.append("   * <br><br>\n");
        if (!replacementTokensForExampleValuesPlaceholders.isEmpty()) {
            stringBuilder.append("   * Placeholders:\n");
            stringBuilder.append("   * <ul>\n");
            for (String replacementToken : replacementTokensForExampleValuesPlaceholders) {
                stringBuilder.append("   * <li><b>" + replacementToken + "</b></li>\n");
            }
            stringBuilder.append("   * </ul>\n");
        }
    }

    private static void printJavaDocValueExamples(StringBuilder stringBuilder, List<String> exampleValueList) {
        stringBuilder.append("   * \n");
        stringBuilder.append("   * Examples:\n");
        stringBuilder.append("   * <ul>\n");
        for (String exampleValue : exampleValueList) {
            stringBuilder.append("   * <li>" + exampleValue + "</li>\n");
        }
        stringBuilder.append("   * </ul>\n");
    }

    private static List<String> determineReplacementTokensForExampleValues(List<String> exampleValueList, String regexTokenPattern) {
        LinkedHashSet<String> retset = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile(regexTokenPattern);
        for (String exampleValue : exampleValueList) {
            Matcher matcher = pattern.matcher(exampleValue);
            while (matcher.find()) {
                retset.add(matcher.group());
            }
        }
        return new ArrayList<String>(retset);
    }

    protected static class CamelCaseTokenElementToMapEntryConverter
    implements ElementConverterElementToMapEntry<String, String, String> {
        public String excludedkey = null;

        public CamelCaseTokenElementToMapEntryConverter(String excludedkey) {
            this.excludedkey = excludedkey;
        }

        public Map.Entry<String, String> convert(String element) {
            String key = "";
            String value = "";
            if (element != null) {
                String[] tokens;
                for (String token : tokens = element.split("[^a-zA-Z0-9]")) {
                    key = key + StringUtils.capitalize((String)token);
                }
                key = StringUtils.isBlank((CharSequence)key) ? "Root" : key;
                key = key.matches("\\d+.*") ? "_" + key : key;
                key = StringUtils.equals((CharSequence)key, (CharSequence)this.excludedkey) ? key + "_" : key;
                value = element;
            }
            return new SimpleEntry((Object)key, (Object)value);
        }
    }

    protected static class PropertyKeyAndValues {
        public String propertyKey = null;
        public List<String> valueList = new ArrayList<String>();

        protected PropertyKeyAndValues() {
        }
    }
}

